<?php
include('GoogleAuthenticator.php');	

require_once(APPPATH .'controllers/iconcaptcha/vendor/autoload.php');
use IconCaptcha\IconCaptcha;

include('MailgunValidator.php');
include('phpmailer/Sendmail.php');
include('BitcoinECDSA.php');	
defined('BASEPATH') OR exit('No direct script access allowed');
date_default_timezone_set("UTC");
define ("JACKPOTSCOSTS", serialize (array(12500, 1250, 125, 13, 2)));
define ("JACKPOTSPRIZES", serialize (array(100000000, 10000000, 1000000, 100000, 10000)));
include('languages.php');
set_time_limit(10);
ini_set('default_socket_timeout', 5);
require_once(APPPATH .'geolite2/index.php');

class Frontend extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	
	public $user_info = null;	
	public $show_login_captcha = true;
	
	public $gg_site_key = '6LfVA0obAAAAAI8bLZBdotcvg-ms4heUAP1ebfjO';
	public $gg_secret_key = '6LfVA0obAAAAAFj9dg_FmTrhE_Crc4nU-Wxe8pZC';
	
	public $hcaptcha_site_key = 'e7342ebf-604d-4884-a967-0181277f2c5f';
	public $hcaptcha_secret_key = '0xfc088F0B3baae62ebd70AC44Ee80b94ac96Ce7D0';
	
	public $cloudflare_site_key = '0x4AAAAAABbyeJO9QkW9czUo';
	public $cloudflare_secret_key = '0x4AAAAAABbyeAn9cn0buULQcrXVL4BUs4Y';
	
	public $lang = null;
	
	public $captcha_type = 1;
	
	public $sending_email_ip = '45.77.43.245';
	public $skip_withdrawal_confirmation = 0;
	
	public $DOGE_price = 0.2677;
	public $levels = array(
		array('Stone', 0, 0.00125000),
		array('Iron', 10, 0.00250000),
		array('Bronze', 100, 0.00500000),
		array('Silver', 1000, 0.01500000),
		array('Gold', 10000, 0.06500000),
		array('Platinum', 100000, 0.30000000),
		array('Diamond', 1000000, 1.50000000),
		array('Master', 10000000, 10.00000000),
	);
	public $lucky_numbers = array(
		array(0, 125000),
		array(9886, 3750000),
		array(9986, 37500000),
		array(9994, 375000000),
		array(9998, 3750000000),
		array(10000,37500000000),
	);
	public $minimum_withdrawal = 1000000000;
	public $withdrawal_fee = 50000000;
	
	public $settings_file = 'application/controllers/settings.txt';
	public $UNITS_PER_COIN = 100000000;
	public $COIN_DECIMALS = 8;
	
	public $MIN_BET_AMOUNT = 10000;
	public $MAX_BET_AMOUNT = 1000000000000;
	
	public $captcha_result = null;
	
	public function __construct() {
		parent::__construct();
		$this->load->helper('url');
		$this->load->model('UserModel', 'User');
		$this->load->model('BanModel', 'Ban');
		$this->load->model('BonusModel', 'Bonus');
		$this->load->model('ConfirmationModel', 'Confirmation');
		$this->load->model('FaucetModel', 'Faucet');
		$this->load->model('GiftModel', 'Gift');
		$this->load->model('WalletModel', 'Wallet');
		$this->load->model('RequestModel', 'Request');
		$this->load->model('MessageModel', 'Message');
		$this->load->model('TicketModel', 'Ticket');
		$this->load->model('GameModel', 'Game');
		$this->load->model('NotificationModel', 'Notification');
		$this->load->model('StatisticModel', 'Statistic');
		$this->load->model('LogModel', 'Log');
		$this->load->model('ContestModel', 'Contest');
		$this->load->model('SurveyModel', 'Survey');
		$this->load->model('StaminaModel', 'Stamina'); //stamina feature
		$this->load->model('StrategyModel', 'Strategy');
		$this->load->model('GroupModel', 'Group'); //group 
		$this->load->library('session');
		$this->load->driver('cache', ['adapter' => 'memcached', 'backup' => 'file']);
		$this->load->library('CI_Minifier');
		$this->ci_minifier->init(0);
		$this->ci_minifier->enable_obfuscator();
		
		$this->load->helper('pcaptcha');
		
		//load language file
		if(isset($_COOKIE['language']) && !empty($_COOKIE['language'])) {
			$language = $_COOKIE['language'];
		} else {
			$language = 'EN';
		}
		$this->lang = new Languages(strtoupper($language));
		//load language file
		
		
		///////rate limit///////
		//if(isset($_SESSION['temporarily_banned']) && $_SESSION['temporarily_banned'] > time()) {
		if($this->session->userdata('temporarily_banned') !== NULL && $this->session->userdata('temporarily_banned') > time()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout_err')));
			exit();
		}
		///////rate limit///////
		
		/** remember me **/
		if($this->session->userdata('user_info') == NULL) {
			if(isset($_COOKIE['remember_token'])) {
				$remember_token = $_COOKIE['remember_token'];
				$user_id = $this->User->get_user_id_by_token($remember_token);
				if($user_id != 0) {
					$this->user_info = $this->User->get_user_info_by_id($user_id);
					$this->session->set_userdata('user_info', $this->user_info);
				}
			}
		}
		/** remember me **/
		
		//if(isset($_SESSION['user_info'])) {
		if($this->session->userdata('user_info') !== NULL) {
			//if($_SESSION['user_info']->accessed_time < time() - 300) {
			if($this->session->userdata('user_info')->accessed_time < time() - 300) {
				//$this->User->update_user_info_by_id($_SESSION['user_info']->user_id, 'accessed_time', time());
				//$_SESSION['user_info']->accessed_time = time();
				
				$this->User->update_user_info_by_id($this->session->userdata('user_info')->user_id, 'accessed_time', time());
				$user_info = $this->session->userdata('user_info');
				$user_info->accessed_time = time();
				$this->session->set_userdata('user_info', $user_info);
			}

			//$this->user_info = $this->User->get_user_info_by_id($_SESSION['user_info']->user_id);
			$this->user_info = $this->User->get_user_info_by_id($this->session->userdata('user_info')->user_id);
			
			//sync_data
			if($this->user_info->accessed_time < time() - 300) {
				$this->User->auto_sync_user_data($this->user_info);
			}
			//sync_data
			
			
			if($this->user_info->banned == 1) {
				//unset($_SESSION['user_info']);
				$this->session->unset_userdata('user_info');
				header("Location: ".base_url()."login.php");
			} else {
				//$_SESSION['user_info'] = $this->user_info;
				$this->session->set_userdata('user_info', $this->user_info);
				if(rand(0, 1000) == 1) {
					$this->Game->clean_bet_data();
				}
				if(rand(0, 1000) == 2) {
					$this->Log->clean_log_data();
				}
				
			}
			
			if(isset($_COOKIE['fp']) && $_COOKIE['fp'] != $this->user_info->user_token) {
				if($this->user_info->user_role == 0) {
					//unset($_SESSION['user_info']);
					$this->session->unset_userdata('user_info');
					header("Location: ".base_url()."login.php");
				}
			}
			
			if($this->user_info->total_deposits >= 5000000000 && $this->user_info->auto_payout == 0 && $this->user_info->banned == 0 && $this->user_info->disable_payout == 0) {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'auto_payout', 1);
			}
			
			/*if($this->user_info->user_role == 1) {
				ini_set('display_errors', 1);
				ini_set('display_startup_errors', 1);
				error_reporting(E_ALL);
			}*/
			
			if($this->user_info->language == '') {
				if(isset($_COOKIE['language']) && !empty($_COOKIE['language'])) {
					$language = strtoupper($_COOKIE['language']);
					if($language != 'EN' 
						&& $language != 'ES' 
						&& $language != 'PT' 
						&& $language != 'FR' 
						&& $language != 'RU' 
						&& $language != 'DE' 
						&& $language != 'NL' 
						&& $language != 'ZH' 
						&& $language != 'AR' 
						&& $language != 'HI' 
						&& $language != 'JA' 
						&& $language != 'BN' 
						&& $language != 'MN' 
						&& $language != 'TR' 
						&& $language != 'FA' 
						&& $language != 'UZ'
						&& $language != 'VI'
						&& $language != 'UR'
						&& $language != 'ID'
						&& $language != 'TH'
						&& $language != 'HR'
						&& $language != 'KO'
						&& $language != 'IT'
					) {
						$language = 'EN';
					}
				} else {
					$language = 'EN';
				}
				$this->lang = new Languages($language);
				$this->User->update_user_info_by_id($this->user_info->user_id, 'language', $language);
				$this->user_info->language = $language;
			} else {
				$language = strtoupper($this->user_info->language);
			}
			
		}
		$this->DOGE_price = $this->get_DOGE_price();
	}
	 
	public function index() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				$this->load->view('country_blocked', array());
				return;
			}
			
			$referrer = $this->input->post_get('ref');
			if($referrer != '') {
				$this->session->set_userdata('referrer', $referrer);
			}
			if($referrer != '' && !preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			if(isset($_SERVER['HTTP_REFERER'])) {
				$this->session->set_userdata('referring_url', $_SERVER['HTTP_REFERER']);
			}
			$web_statistics = $this->User->get_web_statistics();
			$data = array(
				'referrer' => $referrer,
				'registered_users'	=> $web_statistics->users,
				'total_games'	=> $web_statistics->games,
				'won_by_users'	=> $web_statistics->games * 0.00374513,
				'menu'	=> 'home',
			);
			$this->load->view('index', $data);
		}
		
	}
	
	public function create_virtual_request() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			if($this->user_info->user_level == 0) {
				header("Location: ".base_url()."faucet.php");
			} else {
				$this->get_unconfirmed_transactions('Dogecoin', true);
			}
		}
	}
	
	public function login() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				$this->load->view('country_blocked', array());
				return;
			}
			
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$referrer = $this->input->post_get('ref');
			if($referrer != '' && !preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			$data = array(
				'referrer' => $referrer,
				'email' => $email,
				'captcha_type'	=> $this->captcha_type,
				'show_login_captcha'	=> $this->show_login_captcha,
				'menu'	=> 'login',
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
			);
			$this->load->view('login', $data);
		}
	}
	
	public function login2() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$referrer = $this->input->post_get('ref');
			if($referrer != '' && !preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			$data = array(
				'referrer' => $referrer,
				'email' => $email,
				'captcha_type'	=> $this->captcha_type,
				'show_login_captcha'	=> $this->show_login_captcha,
				'menu'	=> 'login',
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
			);
			$this->load->view('login2', $data);
		}
	}

	public function recover() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$data = array(
				'captcha_type'	=> $this->captcha_type,
				'email' => $email,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
			);
			$this->load->view('recover', $data);
		}
	}	
	
	public function disable_2fa() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$data = array(
				'captcha_type'	=> $this->captcha_type,
				'email' => $email,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'menu'	=> 'Disable 2FA'
			);
			$this->load->view('disable_2fa', $data);
		}
	}
	
	public function signup() {
		if($this->user_info != null) {
			header("Location: ".base_url()."faucet.php");
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				$this->load->view('country_blocked', array());
				return;
			}
			
			$referrer = $this->input->post_get('ref');
			if($referrer == '' && $this->session->userdata('referrer') !== NULL) {
				$referrer = $this->session->userdata('referrer');
			}
			if(!preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $referrer)) {
				$referrer = '';
			}
			$email = $this->input->post_get('email');
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$data = array(
				'referrer' => $referrer,
				'email' => $email,
				'menu'	=> 'signup',
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
			);
			$this->load->view('signup', $data);
		}
	}
	
	public function logout() {
		if($this->user_info != null) {
			$this->session->unset_userdata('user_info');
		}
		header("Location: ".base_url());
	}
	
	public function iconcaptcha() {
		
		$referer = $_SERVER['HTTP_REFERER'] ?? '';
		$host = parse_url($referer, PHP_URL_HOST);
		if ($host !== 'dogepick.io') {
			return;
		}
		
		try {
			// Start a session.
			// * Only required when using any 'session' driver in the configuration. See the documentation for more information.
			//session_start();
			// Load the IconCaptcha options.
			$options = require_once(APPPATH .'controllers/iconcaptcha/examples/captcha-config.php');
			// Create an instance of IconCaptcha.
			$captcha = new IconCaptcha($options);
			// Handle the CORS preflight request.
			// * If you have disabled CORS in the configuration, you may remove this line.
			$captcha->handleCors();
			// Process the request.
			$captcha->request()->process();
			// Request was not supported/recognized.
			//http_response_code(400);
		} catch (Throwable $exception) {
			http_response_code(500);
			// Add your custom error logging handling here.
		}
	}
	
	public function generate_pcaptcha() {
		$result = generate_pcaptcha_image();
        if (isset($result['error'])) {
            show_error($result['error'], 500);
        }
        echo json_encode($result);
	}
	
	public function check_ban_user() {
		if($this->user_info != null) {
			$check_ban_user = $this->Ban->check_ban_user(0, $this->get_client_ip());
			if($this->user_info->banned == 1 || ($check_ban_user != null && $check_ban_user->expired_time == 0)) {
				//unset($_SESSION['user_info']);
				$this->session->unset_userdata('user_info');
				header("Location: ".base_url()."login.php");
			} 
		}
	}
	
	public function update_accessed_time() {
		if($this->user_info != null) {
			//$this->User->update_user_info_by_id($this->user_info->user_id, 'accessed_time', time());
			//$this->user_info->accessed_time = time();
			//$_SESSION['user_info']->accessed_time = time();
		}
	}

	public function faucet() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			
			$ip_address = $this->get_client_ip();
			if($this->user_info->total_deposits > 0 || $this->user_info->total_withdrawals > 0 || $this->user_info->total_survey_rewards >= $this->UNITS_PER_COIN) {
				$last_claim_faucet = $this->user_info->last_claim_faucet_time;
			} else {
				$last_claim_faucet = $this->Log->get_last_claim_faucet_time($this->user_info->user_id, $ip_address);
				$last_claim_faucet = max($last_claim_faucet, $this->user_info->last_claim_faucet_time);
			}
			//$last_claim_faucet = $this->Log->get_last_claim_faucet_time($this->user_info->user_id, $ip_address);
			
			$next_claim_faucet = max(3600 - (time() - $last_claim_faucet), 0);
			$user_faucet = $this->Faucet->get_user_faucet($this->user_info->user_id);
			$levels = $this->levels;
			if($this->user_info->user_level <= sizeof($levels) - 1 && $this->user_info->wagered > $levels[$this->user_info->user_level][1] * $this->UNITS_PER_COIN) {
				$updated_info = clone($this->user_info);
				$updated_info->user_level += 1;
				if($updated_info->user_level == 2) {
					$updated_info->free_spins += 5;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 1, 'Double rewards for 1 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 5 free spins and double your faucet rewards for 1 days');
				} else if ($updated_info->user_level == 3) {
					$updated_info->free_spins += 10;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 2, 'Double rewards for 2 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 10 free spins and double your faucet rewards for 2 days');
				} else if ($updated_info->user_level == 4) {
					$updated_info->free_spins += 20;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 2, 86400 * 3, 'Double rewards for 3 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 20 free spins and double your faucet rewards for 3 days');
				} else if ($updated_info->user_level == 5) {
					$updated_info->free_spins += 40;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 3, 86400 * 4, 'Triple rewards for 4 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 40 free spins and triple your faucet rewards for 4 days');
				} else if ($updated_info->user_level == 6) {
					$updated_info->free_spins += 50;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 3, 86400 * 5, 'Triple rewards for 5 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 50 free spins and triple your faucet rewards for 5 days');
				} else if ($updated_info->user_level == 7) {
					$updated_info->free_spins += 100;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 3, 86400 * 6, 'Triple rewards for 6 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 100 free spins and triple your faucet rewards for 6 days');
				} else if ($updated_info->user_level == 8) {
					$updated_info->free_spins += 1000;
					$this->Faucet->create_new_faucet($this->user_info->user_id, 3, 86400 * 10, 'Triple rewards for 10 days');
					$this->Notification->create_notification($this->user_info->user_id, 'Congratulation! Your level has increased. You received 1000 free spins and triple your faucet rewards for 10 days');
				}
				
				//stamina feature
				$stamina_info = $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id);
				if($stamina_info != null && $stamina_info->status == 1) {
					$this->Stamina->update_target_bet($updated_info->user_id, $updated_info->user_level);
				}
				//stamina feature
				
				$this->User->update_user_info($this->user_info, $updated_info);
				$this->user_info = $updated_info;
			}
			
			/** 13-02-2024 **/
			if ($this->user_info->uncredited_survey_rewards > 0) {
				$uncredited_survey_rewards = $this->user_info->uncredited_survey_rewards;

				// Start transaction to ensure atomic updates
				$this->db->trans_begin();

				// Update current user's info
				$updated_info = clone($this->user_info);
				$updated_info->total_survey_rewards += $uncredited_survey_rewards;
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id);
				$updated_info->balance += $uncredited_survey_rewards;
				$updated_info->wagered += ($uncredited_survey_rewards * 5); // Increase wagered amount based on survey rewards
				$updated_info->uncredited_survey_rewards = 0;

				// Handle referral commission if user has a referrer
				if ($this->user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
					$referral_commission = intval($uncredited_survey_rewards * 5 / 100); // 5% referral commission

					// Check for referrer's commission share
					if ($get_referrer && $get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
						$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
						$referral_commission -= $commission_share;

						// Add shared commission to current user's commission balance
						$updated_info->available_commission_balance += $commission_share;
					}

					// Update referrer's commission balance
					$ref_updated = $this->User->update_user_info_by_id(
						$this->user_info->referrer,
						'available_commission_balance',
						'available_commission_balance+' . $referral_commission,
						FALSE
					);

					// Rollback if referrer update fails
					if (!$ref_updated) {
						$this->db->trans_rollback();
						return;
					}

					$updated_info->total_referral_commissions += $referral_commission;
				}

				// Update current user with new balances
				$main_updated = $this->User->update_user_info($this->user_info, $updated_info);
				if (!$main_updated) {
					$this->db->trans_rollback();
					return;
				}

				// Commit transaction after all updates are successful
				$this->user_info = $updated_info;
				$this->db->trans_commit();

				// Update user's stamina (can be outside transaction if it's not critical)
				$this->update_user_stamina($uncredited_survey_rewards * 5);
			}
			/** 13-02-2024 **/
			
			$country = GeoIp2CountryIsoCode($this->get_client_ip());
			if($country != $this->user_info->country) {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'country', $country);
			}
			
			//group feature
			$bypass_group_id = 1;
			$check_bypass_captcha = $this->Group->is_user_in_group($this->user_info->user_id, $bypass_group_id);
			//group feature
			
			//$_SESSION['faucet_token'] = $this->create_random_key(64);
			$this->session->set_userdata('faucet_token', $this->create_random_key(64));
			
			$captcha_token = bin2hex(random_bytes(32));
			$this->session->set_userdata('captcha_token_info', [
				'token' => $captcha_token,
				'ip' => $this->input->ip_address(),
				'ua' => $this->input->user_agent(),
				'expires' => time() + 60
			]);

			$data = array(
				'user_info' 		=> $this->user_info,
				'show_alert'		=> false,
				'user_faucet'		=> $user_faucet,
				'next_claim_faucet'	=> $next_claim_faucet,
				//'faucet_claim_result'	=> $faucet_claim_result,
				//'notifications'	=> $this->Notification->get_all_notifications_by_user_id($this->user_info->user_id),
				'levels'			=> $levels,
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'lucky_numbers'	=> $this->lucky_numbers,
				//'faucet_token'		=> $_SESSION['faucet_token'],
				'faucet_token'		=> $this->session->userdata('faucet_token'),
				'stamina_info'	=> $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id), //stamina feature
				'DOGE_price'	=> $this->DOGE_price,
				'menu'				=> 'faucet',
				'check_bypass_captcha'	=> $check_bypass_captcha,
			);
			$this->load->view('faucet', $data);
			
			//sync_data
			$this->User->auto_sync_user_data($this->user_info);
			//sync_data
			
		}
	}

	public function provably_fair() {
		$data = array(
			'user_info' => $this->user_info,
			'DOGE_price'	=> $this->DOGE_price,
			'menu'		=> 'provably_fair'
		);
		$this->load->view('provably_fair', $data);
	}
	
	public function games() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$levels = $this->levels;
			if(rand(1, 50) == 1 || $this->user_info->user_role == 1) {
				$bet_statistics_today = $this->Game->get_bet_statistics_today();
				$games_played_today = $this->Statistic->get_statistic_by_date('games', date("Y-m-d"));
				//if($bet_statistics_today != null && $bet_statistics_today->total_bets > $games_played_today) {
					$this->Statistic->set_statistic_by_date('games', intval($bet_statistics_today->total_bets), date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('users_bet', intval($bet_statistics_today->total_users), date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('profit', intval(-$bet_statistics_today->bet_balance), date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('wagered', intval($bet_statistics_today->total_wagered), date("Y-m-d"));
				//}
			}
			$data = array(
				'user_info' => $this->user_info,
				'levels'	=> $levels,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'games'
			);
			$this->load->view('games', $data);
		}
	}
	
	public function game_history() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();

			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'games'
			);
			$this->load->view('game_history', $data);
		}
	}
	
	public function dice() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$levels = $this->levels;
			$data = array(
				'user_info' => $this->user_info,
				'levels'	=> $levels,
				'DOGE_price'	=> $this->DOGE_price,
				'strategies'	=> $this->Strategy->get_strategies_by_user_id($this->user_info->user_id),
				'menu'		=> 'games'
			);
			$this->load->view('game_dice', $data);
		}
	}
	
	public function ultimate_dice() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'dice'
			);
			$this->load->view('game_ultimate_dice', $data);
		}
	}
	
	public function gems() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Gems', $this->user_info->user_id);
			$tiles = array();
			$gems = array();
			$difficulty = '';
			$temp_profit = 0;
			$bet_amount = 0;
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$gems = json_decode($game_data->data)->gems;
				$difficulty = json_decode($game_data->prediction)->difficulty;
				$tiles = json_decode($game_data->prediction)->tiles;
				$steps = 0;
				for($i = 0; $i < 10; $i++) {
					if($tiles[$i] != -1) {
						$steps++;
					} else {
						break;
					}
				}
				if($steps > 0) {
					$temp_profit = intval($this->Game->calculate_game_gems_payout($difficulty, $steps) * $game_data->bet_amount);
				}
			}
			$data = array(
				'user_info' 	=> $this->user_info,
				'bet_amount'	=> $bet_amount,
				'difficulty'	=> $difficulty,
				'gems'			=> $gems,
				'tiles'			=> $tiles,
				'temp_profit'	=> $temp_profit,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'				=> 'gems'
			);
			$this->load->view('game_gems', $data);
		}
	}

	public function slots() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'reels'		=> $this->Game->get_game_slots_reels(),
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'slots'
			);
			$this->load->view('game_slots', $data);
		}
	}
	
	public function mines() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Mines', $this->user_info->user_id);
			$tiles = array();
			$mines = array();
			$bet_amount = 0;
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$tiles = json_decode($game_data->prediction)->tiles;
				$mines = json_decode($game_data->data)->mines;
			}
			$data = array(
				'user_info' => $this->user_info,
				'bet_amount'	=> $bet_amount,
				'tiles'		=> $tiles,
				'mines'		=> $mines,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'mines'
			);
			$this->load->view('game_mines', $data);
		}
	}
	
	public function keno() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'keno'
			);
			$this->load->view('game_keno', $data);
		}
	}
	
	public function triple_dice() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'triple_dice'
			);
			$this->load->view('game_triple_dice', $data);
		}
	}
	
	public function poker() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Poker', $this->user_info->user_id);
			$cards = '';
			$bet_amount = 0;
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$cards = json_decode($game_data->data)->cards;
				$cards = array_slice($cards, 0, 5);
			}
			$data = array(
				'user_info' => $this->user_info,
				'bet_amount'	=> $bet_amount,
				'cards'		=> $cards,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'poker',
			);
			$this->load->view('game_poker', $data);
		}
	}
	
	public function baccarat() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'baccarat',
			);
			$this->load->view('game_baccarat', $data);
		}
	}
	
	public function hilow() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$game_data = $this->Game->get_last_game_data_by_uid('Hilow', $this->user_info->user_id);
			$bet_amount = 0;
			if($game_data != null) {
				$bet_amount = $game_data->bet_amount;
				$cards = json_decode($game_data->data)->cards;
				$selections = json_decode($game_data->prediction)->selections;
				$started_game = 1;
			} else {
				$cards = array(rand(0, 51));
				$selections = array();
				$started_game = 0;
			}
			$cards = array_slice($cards, 0, count($selections) + 1);
			$total_profit = $this->Game->calculate_game_hilow_profit($cards, $selections);
			$data = array(
				'cards' 	=> json_encode($cards),
				'selections' 	=> json_encode($selections),
				'started_game'	=> $started_game,
				'total_profit'	=> $total_profit,
				'user_info' => $this->user_info,
				'bet_amount'	=> $bet_amount,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'hilow',
			);
			$this->load->view('game_hilow', $data);
		}
	}
		
	public function roulette() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'roulette'
			);
			$this->load->view('game_roulette', $data);
		}
	}
	
	public function wheel() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'wheel'
			);
			$this->load->view('game_wheel', $data);
		}
	}
	
	public function plinko() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'plinko'
			);
			$this->load->view('game_plinko', $data);
		}
	}
	
	public function limbo() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'menu'		=> 'limbo'
			);
			$this->load->view('game_limbo', $data);
		}
	}
	
	public function withdraw() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			//$all_withdrawal_wallets = $this->Wallet->get_all_withdrawal_wallets_by_user($this->user_info->user_id);
			$user_transactions = $this->Request->load_user_transactions($this->user_info->user_id, $page_id, 'Withdrawal');
			/*foreach($user_transactions as $row) {
				$address = $row->address;
				$row->label = '';
				for($i = 0; $i < count($all_withdrawal_wallets); $i++) {
					if($address == $all_withdrawal_wallets[$i]->address) {
						$row->label = $all_withdrawal_wallets[$i]->note;
						break;
					}
				}
			}*/
			$total_requests = $this->Request->get_number_transactions($this->user_info->user_id, 'Withdrawal');
			$total_pages = ceil($total_requests / $this->Request->limit_entries);
			//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
			$DOGE_price = $this->DOGE_price;
			$unconfirmed_requests = $this->Request->count_unconfirmed_requests($this->user_info->user_id);
			$data = array(
				'minimum_withdrawal' => $this->minimum_withdrawal,
				'withdrawal_fee' => $this->withdrawal_fee,
				'user_info' => $this->user_info,
				'unconfirmed_requests'	=> $unconfirmed_requests,
				'user_transactions'	=> $user_transactions,
				'pagination'	=> $this->create_pagination($page_id, $total_pages , base_url().'withdraw.php'),
				'DOGE_price'	=> $DOGE_price,
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'menu'		=> 'withdraw',
			);
			$this->load->view('withdraw', $data);
		}
	}

	public function deposit() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$deposit_address = $this->Wallet->get_deposit_address_by_user_id($this->user_info->user_id);
			if($deposit_address == '') {
				$deposit_address = $this->get_deposit_address();
				if($deposit_address != '') {
					$this->Wallet->create_new_wallet($this->user_info->user_id, 'Deposit', $deposit_address);
				}
			}
			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			$user_transactions = $this->Request->load_user_transactions($this->user_info->user_id, $page_id, 'Deposit');
			$total_requests = $this->Request->get_number_transactions($this->user_info->user_id, 'Deposit');
			$total_pages = ceil($total_requests / $this->Request->limit_entries);
			//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
			$DOGE_price = $this->DOGE_price;
			//$deposit_address = 'temporarily unavailable';
			$data = array(
				'user_info' => $this->user_info,
				'deposit_address'	=> $deposit_address,
				'user_transactions'	=> $user_transactions,
				'pagination'	=> $this->create_pagination($page_id, $total_pages , base_url().'deposit.php'),
				'DOGE_price'	=> $DOGE_price,
				'menu'		=> 'deposit',
			);
			$this->load->view('deposit', $data);
		}
	}
	
	public function update_deposit() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$DOGE_price = $this->DOGE_price;
			$data = array(
				'user_info' => $this->user_info,
				'captcha_type'	=> $this->captcha_type,
				'gg_site_key'	=> $this->gg_site_key,
				'hcaptcha_site_key'	=> $this->hcaptcha_site_key,
				'cloudflare_site_key'	=> $this->cloudflare_site_key,
				'DOGE_price'	=> $DOGE_price,
				'menu'		=> 'deposit',
			);
			$this->load->view('update_deposit', $data);
		}
	}

	public function payouts() {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN') {
			$this->load->view('country_blocked', array());
			return;
		}
		
		$page_id = intval($this->input->post_get('p'));
		if($page_id == 0) {
			$page_id = 1;
		}
		if($page_id > 99999) {
			$page_id = 99999;
		}
		$lastest_payouts = $this->Request->load_payouts($page_id);
		$DOGE_price = $this->DOGE_price;
		$data = array(
			'user_info' => $this->user_info,
			'lastest_payouts' => $lastest_payouts,
			'pagination'	=> $this->create_pagination($page_id, 99999 , base_url().'payouts.php'),
			'DOGE_price'	=> $DOGE_price,
			'menu'		=> 'payouts',
		);
		$this->load->view('payouts', $data);
	}

	public function affiliates() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			
			$sort_field = $this->input->post_get('f');
			$sort_order = $this->input->post_get('o');
			
			if($sort_field == '') {
				$sort_field = 'level';
			}
			
			if($sort_order == '') {
				$sort_order = 'DESC';
			}
			
			$levels = $this->levels;
			$get_all_users = $this->User->get_all_users_from_referrer($this->user_info->user_id, $page_id, $sort_field, $sort_order);
			$total_pages = ceil($this->user_info->total_referrals / $this->User->limit_entries);
			
			$get_registered_users_by_dates = $this->Statistic->get_registered_users_by_dates($this->user_info->user_id);
			$get_user_bonuses_by_dates = $this->Statistic->get_user_bonuses_by_dates($this->user_info->user_id);
				
			$data = array(
				'levels'	=> $levels,
				'user_info' => $this->user_info,
				'users'		=> $get_all_users,
				'pagination'	=> $this->create_pagination($page_id, $total_pages , base_url().'affiliates.php?f='.$sort_field.'&o='.$sort_order),
				'DOGE_price'	=> $this->DOGE_price,
				'get_registered_users_by_dates' => $get_registered_users_by_dates, ///12062024//
				'get_user_bonuses_by_dates' => $get_user_bonuses_by_dates, ///12062024//
				'sort_field'	=> $sort_field,
				'sort_order'	=> $sort_order,
				'menu'		=> 'affiliates',
			);
			$this->load->view('affiliates', $data);
		}
	}

	public function gifts() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			$page_id = intval($this->input->post_get('p'));
			if($page_id == 0) {
				$page_id = 1;
			}
			if($page_id > 99999) {
				$page_id = 99999;
			}
			$gifts = $this->Gift->load_user_gifts($this->user_info->user_id, $page_id, false);
			$statistics = $this->Gift->get_statistics($this->user_info->user_id);
			$total_pages = ceil(intval($statistics->total_gifts) / $this->Gift->limit_entries);
			$pagination = $this->create_pagination($page_id, $total_pages, base_url().'gifts.php');
			$gift_code = substr($this->input->post_get('gift_code'), 0, 16);
			$gift_code = preg_replace("/[^a-zA-Z0-9]/", "", $gift_code);
			$data = array(
				'user_info' => $this->user_info,
				'gifts'			=> $gifts,
				'pagination'	=> $pagination,
				'DOGE_price'	=> $this->DOGE_price,
				'gift_code'	=> $gift_code,
				'menu'		=> 'gifts',
			);
			$this->load->view('gifts', $data);
		}
	}

	public function contact() {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN') {
			$this->load->view('country_blocked', array());
			return;
		}
		
		$data = array(
			'user_info' => $this->user_info,
			'menu'		=> 'contact',
		);
		$this->load->view('contact', $data);
	}	
	
	public function ticket() {
		$ticket_code = substr($this->input->post_get('s'), 0, 8);
		$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
		if($ticket_id == 0) {
			show_404();
		} else {
			$get_ticket_info = $this->Ticket->get_ticket_info($ticket_id);
			$load_messages = $this->Message->get_all_messages_by_ticket($ticket_id);
			foreach($load_messages as $row) {
				if($row->time - time() < 86400) {
					$row->time =  $this->time_elapsed_string($row->time);
				} else {
					$row->time =  date('Y-m-d', $row->time);
				}
			}
			$this->Ticket->update_user_time_seen($ticket_id);
			$data = array(
				'messages'		=> $load_messages,
				'subject'		=> $get_ticket_info->subject,
				'ticket_code'	=> $ticket_code,
				'ticket_closed'	=> $get_ticket_info->closed,
				'email'			=> $get_ticket_info->email,
				'menu'			=> 'contact',
				'user_info' => $this->user_info,
			);
			$this->load->view('ticket', $data);
		}
	}
	
	public function faq() {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN') {
			$this->load->view('country_blocked', array());
			return;
		}
		
		$data = array(
			'user_info' => $this->user_info,
			'levels'	=> $this->levels,
			'menu'		=> 'faq',
		);
		$this->load->view('faq', $data);
	}
	
	public function survey() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			if($this->input->post_get('p') != '') {
				$page_no = intval($this->input->post_get('p'));
			} else {
				$page_no = 1; 
			}
			
			/** 13-02-2024 **/
			if($this->user_info->uncredited_survey_rewards > 0) {
				$uncredited_survey_rewards = $this->user_info->uncredited_survey_rewards;
				$updated_info = clone($this->user_info);
				$updated_info->total_survey_rewards += $uncredited_survey_rewards;
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id);
				$updated_info->balance += $uncredited_survey_rewards;
				$updated_info->wagered += ($uncredited_survey_rewards * 5); //Increase your total bet when doing surveys.
				if($this->user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
					$referral_commission = intval($uncredited_survey_rewards * 5 / 100);
					if($get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
						$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
						$referral_commission = $referral_commission - $commission_share;
						$updated_info->available_commission_balance += $commission_share;
					}
					$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
					$updated_info->total_referral_commissions += $referral_commission;
				}
				$updated_info->uncredited_survey_rewards = 0;
				$this->User->update_user_info($this->user_info, $updated_info);
				$this->user_info = $updated_info;
			}
			/** 13-02-2024 **/
			
			$get_surveys = $this->Survey->filter_surveys($this->user_info->user_id, null, null, null, null, $page_no);
			$reject_surveys = $this->Survey->get_all_reject_surveys($this->user_info->user_id);
			$total_pages = $get_surveys['total_pages'];
			$pagination = $this->create_pagination($page_no, $total_pages, base_url().'survey.php');
			
			
			$DOGE_price = $this->DOGE_price;
			$data = array(
				'user_info' => $this->user_info,
				'get_surveys'     => $get_surveys['data'],
				'statistics'      => $get_surveys['statistics'],
				'reject_surveys'	=> $reject_surveys,
				'pagination'	=> $pagination,
				'DOGE_price'	=> $DOGE_price,
				'menu'		=> 'survey',
			);
			$this->load->view('survey', $data);
		}
	}
	
	public function terms() {
		$data = array(
			'user_info' => $this->user_info,
			'menu'		=> 'terms',
		);
		$this->load->view('terms', $data);
	}

	public function policies() {
		$data = array(
			'user_info' => $this->user_info,
			'menu'		=> 'policies',
		);
		$this->load->view('policies', $data);
	}	

	public function contests() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			date_default_timezone_set("UTC");
			$day = date('w');
			if($day == 0) {
				$day = 7;
			}
			$week_start = strtotime('-'.($day-1).' days midnight');
			$week_end = strtotime('+'.(8-$day).' days midnight');

			$this->update_contest_data();

			if($this->user_info->last_bet_time < $week_start) {
				$this->user_info->wagered_this_week = 0;
				$this->User->update_user_info_by_id($this->user_info->user_id, 'wagered_this_week', 0);
			}
			
			$get_thisweek_contest_data = $this->Contest->get_thisweek_contest_data();
			$get_lastweek_winners = $this->Contest->get_lastweek_winners();
			
			//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
			$DOGE_price = $this->DOGE_price;
			
			$data = array(
				'user_info' => $this->user_info,
				'total_wagering_in_week' => $this->user_info->wagered_this_week,
				'total_referral_wagering_in_week'	=> $this->User->get_referral_wagering_in_week_by_uid($this->user_info->user_id, $week_start, $week_end),
				'total_weeks'	=> '',
				'week_start' => $week_start,
				'week_end' => $week_end,
				'get_thisweek_contest_data'	=> ($get_thisweek_contest_data != null) ? json_decode($get_thisweek_contest_data->data) : null,
				'get_lastweek_winners'	=> ($get_lastweek_winners != null) ? json_decode($get_lastweek_winners->data) : null,
				'DOGE_price'	=> $DOGE_price,
				'menu'		=> 'contests',
			);
			$this->load->view('contests', $data);
		}
	}
	
	
	public function settings() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$this->check_ban_user();
			$this->update_accessed_time();
			if($this->user_info->secret_2fa_code == '') {
				$g = new GoogleAuthenticator();
				$secret_2fa_code = $g->generateSecret();
				$this->user_info->secret_2fa_code = $secret_2fa_code;
				$this->User->update_user_info_by_id($this->user_info->user_id, 'secret_2fa_code', $secret_2fa_code);
			}
			
			$get_logs = $this->Log->get_login_logs_by_user($this->user_info->user_id);
			if(is_array($get_logs)) {
				foreach($get_logs as $row) {
					if($row->time - time() < 86400) {
						$row->time =  $this->time_elapsed_string($row->time);
					} else {
						$row->time =  date('Y-m-d', $row->time);
					}
					/*if (preg_match('/\[(\w{2})\]/', $row->action, $matches)) {
						$row->country = $this->User->getCountryName($matches[1]);
					} else {
						$row->country = '';
					}*/
				}
			}
			
			$data = array(
				'user_info' => $this->user_info,
				'DOGE_price'	=> $this->DOGE_price,
				'logs'		=> $get_logs,
				'menu'		=> 'settings',
			);
			$this->load->view('settings', $data);
		}
	}

	public function ads() {
		if($this->user_info == null) {
			header("Location: ".base_url()."login.php");
		} else {
			$data = array(
				'user_info' => $this->user_info,
			);
			$this->load->view('ads', $data);
		}
	}
	
	public function confirm() {
		$verification_code = preg_replace('/[^A-Za-z0-9]/', '', $this->input->get('key'));
		$action = $this->input->get('act');

		// Decode verification code if encoded
		if (strlen($verification_code) === 65) {
			$verification_code = substr($this->decodeString($verification_code), 0, -1);
		}

		$get_confirmation = $this->Confirmation->get_confirmation_data_by_key($verification_code);
		if (!is_object($get_confirmation)) {
			$this->load->view('confirm', ['user_info' => $this->user_info]);
			return;
		}

		// Handle ignore (cancel withdrawal)
		if($action === 'ignore') {
			if ($get_confirmation->type === 'confirm_withdrawal_request' && $get_confirmation->request_id != 0) {
				$request_id = $get_confirmation->request_id;

				$this->db->trans_start();
				$request_info = $this->Request->get_request_info_by_id_for_update($request_id);

				if (!$request_info || $request_info->status !== 'Unconfirmed') {
					$this->db->trans_complete();
					$this->load->view('confirm', ['user_info' => $this->user_info]);
					return;
				}

				$user_info = $this->User->get_user_info_by_id($get_confirmation->user_id);
				if ($user_info->pending_balance >= $request_info->amount) {
					$this->Request->cancel_withdrawal_request($request_id);

					$updated_info = clone $user_info;
					$updated_info->pending_balance -= $request_info->amount;
					$updated_info->balance = $this->User->get_user_balance_by_id($user_info->user_id);
					$updated_info->balance += $request_info->amount;

					$this->User->update_user_info($user_info, $updated_info);
				} else {
					//log_message('error', "Insufficient pending balance to cancel withdrawal for user_id: {$user_info->user_id}");
				}
				$this->db->trans_complete();
			}
			$this->Confirmation->update_confirmation_expired_time($verification_code);
			$this->load->view('confirm', ['user_info' => $this->user_info, 'type' => 'cancel_request']);
			return;
		}

		// Process other confirmation types
		$this->db->trans_start();
		$this->User->lock_user_by_id($get_confirmation->user_id);
		$user_info = $this->User->get_user_info_by_id($get_confirmation->user_id);

		switch ($get_confirmation->type) {
			case 'recover_password':
				$this->load->view('change_password', [
					'ver_code' => $verification_code,
					'email' => $user_info->user_email,
					'captcha_type' => $this->captcha_type,
					'gg_site_key' => $this->gg_site_key,
					'hcaptcha_site_key' => $this->hcaptcha_site_key
				]);
				break;

			case 'confirm_withdrawal_request':
				$request_info = $this->Request->get_request_info_by_id_for_update($get_confirmation->request_id);
				if ($request_info && $request_info->status === 'Unconfirmed') {
					$this->Request->confirm_withdrawal_request($get_confirmation->request_id);
					$this->Confirmation->update_confirmation_expired_time($verification_code);
					$this->load->view('confirm', [
						'user_info' => $this->user_info,
						'type' => 'confirm_withdrawal_request'
					]);
				} else {
					$this->load->view('confirm', ['user_info' => $this->user_info]);
				}
				break;

			case 'disable_2fa':
				$this->User->update_user_info_by_id($user_info->user_id, 'enable_2fa', 0);
				$this->Log->create_log($user_info->user_id, 'Disable 2FA', $this->get_client_ip());
				$this->load->view('confirm', [
					'user_info' => $this->user_info,
					'type' => 'disable_2fa'
				]);
				break;

			default:
				if ($user_info->email_verification == 0) {
					$updated_info = clone $user_info;
					$updated_info->email_verification = 1;
					$updated_info->free_spins += 10;

					$this->User->update_user_info($user_info, $updated_info);
					$this->Faucet->create_new_faucet($user_info->user_id, 2, 86400, 'Double rewards for 1 day');
					$this->Notification->create_notification($user_info->user_id, 'Your email has been successfully verified!');
					$this->Confirmation->update_confirmation_expired_time($verification_code);

					$this->load->view('confirm', [
						'user_info' => $this->user_info,
						'type' => 'verify_email'
					]);
				} else {
					$this->load->view('confirm', ['user_info' => $this->user_info]);
				}
				break;
		}

		$this->db->trans_complete();
	}
	
	public function get_deposit_address() {
		ini_set('default_socket_timeout', 5);
		//$deposit_address = file_get_contents("http://158.220.100.211/doge_api/get_random_address.php?uid=d".$this->user_info->user_id);
		$deposit_address = file_get_contents("http://158.220.96.161/doge_api/get_random_address.php?uid=d".$this->user_info->user_id);
		//$deposit_address = file_get_contents("http://194.233.92.165/doge_api/get_random_address.php?uid=d".$this->user_info->user_id);
		if($this->user_info != null && $this->user_info->country == 'VN1') {
			$deposit_address = '';
		}
		if($this->validateAddress($deposit_address)) {
			return $deposit_address;
		} else {
			return '';
		}
	}
	
	public function get_unconfirmed_transactions($currency = 'Litecoin', $instant = false) {
		if($instant == false && rand(0, 10000) != 1) {
			return;
		}
		$min_amount = 0;
		$max_amount = 100;
		if($currency == 'Litecoin') {
			$url = "https://blockexplorer.one/ajax/LTC/mainnet/last-transactions/";
			$min_amount = 0.00500000;
			$max_amount = 0.55000000;
		} else if($currency == 'Dogecoin') {
			$url = "https://blockexplorer.one/ajax/DOGE/mainnet/last-transactions/";
			$min_amount = 5;
			$max_amount = 5555;
		}
		$unconfirmed_transactions = json_decode(file_get_contents($url));
		for($i = 0; $i < count($unconfirmed_transactions); $i++) {
			$address = '';
			$amount = 0;
			$txid = '';
			if(isset($unconfirmed_transactions[$i]->to[0]->address)
			&& isset($unconfirmed_transactions[$i]->to[0]->amount)
			&& isset($unconfirmed_transactions[$i]->tx)
			) {
				$address = $unconfirmed_transactions[$i]->to[0]->address;
				$amount = $unconfirmed_transactions[$i]->to[0]->amount;
				$txid = $unconfirmed_transactions[$i]->tx;
			}
			if($amount < $min_amount || ($amount > $max_amount )) {
				continue;
			} else {
				$rand_names = array('chameharouche', 'zafarchaudary786', 'famidrabbi', 'gaduaxe195', 'marquezerdida20', 'tarigansyaahh', 'heptahexahedral', 'miekriting1988', 'mistabuenos', 'nguyenphatdat161020', 'dongminhhunghh', 'ney204908', 'amank.khan01', 'Baltoo_777', 'hoangmang8696', 'wayansetiawan805', 'tigergurubadshah', 'm.ryan4u', 'bangetkepo494', 'bomderb52', 'bbhe', 'attiyahamira70', 'freeearnmany121', 'kebaldiridari', 'renatacacao0160', 'zvc41316', 'Taikhoanquamang', 'say.amahlobakahayang', 'muzammilsm335', 'juliascmrs2.01985', 'bodenwieserulauje11', 'banasraj', 'agok811', 'MarkAGodsey', 'annadavis112233', 'pctlia', 'mdshahinmdshahin13244', 'gunawanadjjh', 'nikitin2566', 'kiwikidang1988', 'elfxfecgt', 'dt.mahendra12', 'nafisiwanul', 'andrees7410', 'boypakaruk', 'wupugi', 'kamonchanok1406', 'hmax2603', 'obopatrick', 'egimustofa445', 'towers2019', 'vulvhal', 'abigailefuihu55', 'lanhvanau92', 'aamirpervaizch', 'muhammaddianfikrimu.stofa', 'ajkdcruz', 'jengkelbanget00', 'lcwila', 'shuvokhan32321', 'dasfisan', 'generator', 'johirul4747', 'marquezersujima11', 'mdkodom70', 'ahmadhendi06', 'muhammaddianf.ikrimustofa', 'm95527010', 'znh97729', 'oiinkdjshshs', 'paulosergiobeppler', 'rangga191189', 'celywuxi', 'fellakmehditaza94', 'ginkogfhjfg', 'shakir3344473', 'harry290802', 'dhannyramdhanny87', 'yurijm', 'clanmelstv', 'amadbidl', 'lembursampelecet', 'tik.aj.ong9', 'ergyansyah2', 'bds', 'lawsonwilliam1999', 'defaultsexcerpt', 'teletalkmy', 'mdsaidulislam1438', 'abhizar753', 'bad14652', 'mariethalia331', 'pfm03574', 'quelam2019', 'yukiaripa', 'Kram60985', 'ibrahimtornuk', 'onurilkin', 'sozibfgfht', 'Rukikaertu12345', 'aa25', 'sofiwilison', 'daltonlarne', 'ariokartono', 'hosykienk27', 'rojncm', 'heruceper10', 'jenuhnganggur', 'litonhossen52', 'hogweeds', 'btc4053', 'sjjssh.hs', 'ishtiaqali2016', 'mlangworthr_l86a', 'trickbdandtutorial', 'nurul.nurul030784', 'mbro972000', 'aumnuay53', 'black943', 'harakternika3m4', 'seydejerta', 'Chiagozielawrence', 'dainhok1', 'kne47158', 'mdjamalhossain3678', 'maruksejali123456', 'hskya', 'aisyahayla314', 'judulegudal', 'akbartolit85', 'wawangkusumadibrata', 'pabuaransiluman12', 'betijuhandi', 'kareerupio14', 'Kurniawanone26', 'eeayam6661', 'gsaidakbar', 'sorigyfeq', 'ikbambambela10', 'agungnikolas28', 'goesp14', '4429b6f402', 'kalaplenyun', 'piv19257', 'kumalakumalaa872', 'satgascakep2', 'arippablo', 'cgurvinderskdk', 'bycaphan15091991', 'onehand2147', 'zedicus27', 'sayamahl.obakahayang', 'lvenok649', 'Lenaidadelfin03', 'ajun9489', 'furkanesiner1', 'kethekuntu1988', 'estahamed', 'obelrle', 'miledilan2', 'glossary329', 'thommandrumary777', 'hefypusi', 'chafarsh', 'k.ingbacok02', 'hoahhtb', 'blumer', 'ngocthienphong8', 'hxwykilg', 'lismalismawati267', 'werkzeugen', 'famidfh114', 'marishkafreeshka', 'mrjosb25', 'fdp81154', 'lautandolar', 'andremor553', 'mbirodaniel', 'mamaasipasip', 'surnoto80', '1marcksalmon1', 'yasirarafat.ramim9270', 'thitiya20', 'lethoatam', 'cindypermata1010', 'jahabularmy', 'tehneng89', 'shazid575', 'mbiroaisha52', 'mehedi092', 'drjunik11', 'aelzetor', 'tinay8855', 'eduardjardi', 'lahw9936', 'jawapesisirtimur', 'timebangla2018', 'anjssultn', 'shofiahfitriana354', 'guhagarkarmaveez', 'aqkhanabbasi29', 'puvesijupu', 'arrasydvr.istantzalamardani21', 'jpcaptain34', 'lucudawet', 'farahrosarida', 'farukdal0404', 'jessicaagums011997', 'edrine97-mbiro258888', 'smd741504', 'diegoarman857', 'Hkops', 'arrasydv.ristantzalamardani21', 'irunxshei', 'ahsankumala', 'vxllj', 'tuyullima777', 'khamseh_m1985', 'inchespearson', 'borgesalex265', 'yekma7', 'bakarbakso007', 'sitisholekha1191', 'agoes.ibe', 'alisonaurel', 'rajuanislamhridoy', 'vandemyowman26', 'rikidibrata', 'vertilenas', 'ejirocrownwell', 'imamyasirkharis116', 'ehtaishamakhtar792', 'imam.sapto', 'sam977899khan', 'extramd0', 'naserghasemi2003', 'kadijalina2005', '72bfb8d5e8', 'itashik123', 'apiphidayat1993', 'nizee1970', 'ademy5562', 'arakbubuk', 'mdshuvoahmed01', 'cclan3936', 'alostora2131999', 'cycybyencluna20', 'linda.chalita', 'gebyfyru', 'fidonightcorecords', 'btcjibon', 'arrasydvrista.ntzalamardani21', '20fd43aae0', 'skinforu2012', 'black5259', 'oromiraaj8g', 'ciwellaudya003', 'litaoweeta55', 'mustafaoge402', 'whitesergey4', 'lequocthangx18', 'armstrong.armstms211988', 'tthmzovpunhan', 'puripursita', 'darmawanreza1997', 'karyomayma', 'maukamu22', 'omahku', 'ak47hitbest', 'mdrezaul55220', 'medhatelgarahy', 'ran07012000', 'naim00004', 'alakbarovhashim30', 'stmhamza', 'indrisusanti2019', 'nanaro0010', 'donitaalbania', 'susancoons60', 'nhuocninh1982hp', 'hoanhi3601', 'wanpera8', 'lhynnlogronio', 'abirahmef457', 'roseifoafe66', 'muhammadvathulaziz', 'qkoli', 'setiadyarie88', 'hmrohan2', 'ber67706', 'jeyjo7755', 'joycewatmrs081985', 'rr6275', 'istiko03', 'Benjuko', 'mistykoyel142', 'flammecamelo', 'lolaeduuxu66', 'asriabandi30', 'Brahimpro04', 'Idrisgana25', 'puwo', 'ur3sgvlad', 'tioganteng', 'nb8f2a7', 'hars.jogja', 'vs2574', 'gideonblessing74', 'merryhell9', 'Lilikapaak12345', 'money.coinplus', 'winduraga', 'emir_mutlu_1735', 'bikepe38', 'sanasafari1213', 'ortizortims271988', 'suhadinett', 'angellada72', 'Mudasirmagsi', 'komlanguymarc', 'sefatlite1122', 'ashraf03364197322', 'diananggaraputrawijaya', 'wilujeng870enjing', 'kolikishore26', 'beth12yb', 'fahmiloversz', 'msnafi54544', 'angelarora676', 'sherinsultana41', 'fahmifahamsyah2018', 'rizalrizaldi2018', 'lembangbandunglembang', 'aris.herdiawan1234', 'sagarkhan422', 'benjaguarchaj10', 'nanafaiz622', 'ashqan786', 'Anvuhong2872', 'lct30007', 'roseunoewi33', 'lonan9364', 'earntap100', 'yodissetiawan97', 'Cariduvi', 'teuingnu.mana', 'szymonniemczewski', 'ctz59967', 'c63893031', 'ceejhaysiobal', 'grobakketek', 'nognigespe', 'avm70946', 'abkhan.ark99', 'sayamahlobakahayan.g', 'halimguzel', 'cintalara49', 'subhasispan012000', 'tripathisachin697', 'aa13', 'panggihakun100', 'dandanramadhan90', 'nengmanispuol', 'Nguyenthanhtich809', 'tayopayo1988', 'mmgolcuk', 'jwn06732', 'Krata', 'pororuslan0178', 'faisalharis2019', 'nguyenvanphu.hd2000', 'sunma28122535', 'Sharipovone', 'sisalmanago', 'nurdinnurdiana2018', 'shikinajica10', 'Tanduonglt2019', 'heiho', 'abeerlucky786', 'Hp22032002', 'mianmujeeb898', 'mulyanakoswara2019', 'aishambiro', 'swapnilborkar000', 'meyermeyemr121983', 'alibashfar09', 'nellieugueso11', 'agungagengmei', 'allagmohamedamine', 'afreee13', 'nonny210938', 'dadaonaurel', 'Tristantijenny', 'lequocthangx19', 'tipusulten8833', 'altun26_1983', 'iziissa7', 'bruhzd1234', 'myrtleozoedu11', 'aoda46', 'hbandung56', 'ahmetkhvc5', 'fahmiridho3', 'princeobinna558', 'edycahyadi48', 'dmaiasa2345666', 'SaimaAzam412', 'agnesdona1988', 'valentiodoank', 'riduanmohammadriduan', 'gujarnilesh51', 'palapusing56', 'gh67543', 'asepishakmmm', 'bagusavici26', 'sammykay301', 'mustafaoge408', 'badshahraselkhanlove', 'mixacool452', 'sitraka721', 'shas.zeek', 'jhgh7687', 'kencotenmeriyang', 'echobitcoins90', 'Lutayahusein9080', 'amitsinghchauhan046', 'l-equocthangx13', 'kenidamayanti', 'marthapredherika', 'mdshakilcar', 'eum13924', 'eybnuvyk', 'riandelon715', 'mrjosc104', 'espinoza.ag', 'shobogunf', 'khkhalil1210', 'karimsadiq7091', 'gilangramadhan2112', 'memoonakanwal7777', 'tinofo', 'kuatimaneora', 'ginahidayat77', '143puttamon', 'faridaamanah781', 'zaenkebumen015', 'fidiammm', '27031993nguyenvanthong', 'beruko.liko', 'amiraepieda11', 'sonerozcan', 'srimulyanti9999', 'oatthanontoey1', 'gecupkp', 'enengpermoni', 'bohay1255', 'azizullaharween', 'abunghjfggh', 'cadmail09', 'detsaen', 'bisnessvideo', 'takinrina', 'Matbaokt', 't38c9obiusqs', 'vadimneustroev70', 'kanekisen26', 'mhbusiness59', 'peliday', 'ebiyulistio', 'fikriwildanil', 'ilyashs101', 'bufo', 'davidmengko08', 'antonrantuni', 'rodefojiq', 'yosep_marsikal', 'banditcancut', 'ernazulkarnain70523', 'elhichou007', 'wewe07', 'janebms0119.93', 'rikdj1q', 'zohaiblove3', 'saulita90-teriaki', 'busri299', 'sidotaa', 'askamuda32', 'remedialkrypto', 'khajamunna58', 'creditress', 'markjons058', 'ekasyafira22', 'alfattahcomputer', 'kisukeurahara15', 'arrysamir72', 'Mellmel246', 'svyatoi1988', 'himakalumpaypal2002', 'brisikcelek', 'teddyinfresh', 'viviindriyanti94', 'lequocthang.x13', '03497748470b', 'cahyuni.sugiono', 'nany.nuy08', 'goodlul', 'koukouhales', 'Beruk.oliko', 'cry.vergil', 'ynyy5pwz', 'lam35xd', 'elisandriani2019', 'dozietheg', 'hoang631995', 'debbieatadero', 'firmanrodhi', 'abdulmajeedkhan021', 'cahpurworejo123', 'diananggaraputrawij.aya', 'jeanwalms121995', 'nem38314', 'nondita2019n', 'bambangsukmadi097', 'nickktnn99', 'vifeh', 'asadarain525', 'bespotenen', 'matto.pipii', 'aagung2001', 'tunaskera', 'jesusjuegos91', 'teui.ngnumana', 'laxnok2506', 'nayeemh938', 'Hwhzhsqau', 'strongwind1982', 'indahsaari9800', 'np71175', 'tukangpalkir5', 'jboychiboy', 'anyudi47', 'shalafikhan903', 'kotejalang90', 'aajuremisan', 'jenkins1252', 'stylishcomedy', 'ubadbadrudin9', 'thyne390', 'a.p.sarbioke365', 'mrjosb24', 'Ventury98', 'Temmynathy', 'caapple3', 'lake77781', 'rk.handriyanto', 'fhgu', 'anamjantan', 'ferhawa', 'alamdarhussain087', 'ipiehritrer', 'produy1302', 'anassdakyouk05', 'shafiqkamal', 'ahsaanshafi', 'ibrahimfalaluibrahim', 'virginialittms301997', 'smd17343', 'Trieubaccb', 'puwu', 'islamprcar4392', 'nanarohana1997', 'Rudiksfernando', 'thvbvv', 'Dikafebrikusuma', 'koplaxjoni', 'fd3545050a', 'kartikparikh67', 'mirnayanti498', 'carolynandms091994', 'lalakonzampank', 'musti_er26', 'aryabrama988', 'vbcvnxn', 'tibangaye', 'asu', 'giblewarb', 'rioandiko94', 'sboyarif', 'artmatch92', 'estradaestms12651997', 'kandukoorimadbavi9', 'ulaleksei58935', 'motorkabel54', 'tunzkel2', 'k.i.n.gbacok01', 'mito.azuma', 'annguyen1991991', 'islamariful71747', 'mdjr20019', '25insan1989', 'dewrani', 'shihabahmed420kst', 'lekrasima', 'allofmywishasmychocice', 'sayamahlobakahay.ang', 'mustafaoge400', 'scordato32', 'kadekpura50', 'mozeg', 'attagledek17', 'mdantormsk24', 'mysolidcom001', 'tridi8789', 'kopeahden.gdek81', 'cahyadibayu26', 'alibashfar04', 'yehuasunita', 'ranaj5593', 'huathanhuan27', 'j.ayrmangaba', 'vinyin49', 'tupecok', 'jenongdepi', 'gislainenero', 'huntingjugar', 'apasalahku', 'mdm984429', 'vasakavya177', 'bersemilagi1988', 'poppyepuuku66', 'lcunqkhh', 'silk720701', 'nluan2316', 'sandihuno', 'fuknuledro', 'Muhammadxayed', 'hendisugiri24', 'jessationgco10', 'motorapakaesih', 'umardahih', 'suarasegan1988', 'ahmadfitri7', 'dergaskatun', 'Difarata123', 'yusufsi.ur.ang', 'candied33', 'Indranaxcianjur', '60ldminer', 'ngochung9890', 'hadyaldi9', 'lequocthangx.2', 'pumabitcoin99', 'kartikohardi', 'sheirunx', 'yt654655', 'basukiscorpiovers', 'sainiganesh551', 'sayamah.lobakahayang', 'talibah1985', 'tomkity', 'jaisonmj777', 'andrearaujo2331', 'chada31102013', 'lotifa42024', 'lequocthangx16', 'sona1aa', 'manjeetkum69', 'sasapuiu', 'rojmarlley', 'ah56767', 'dada1a', 'hoangha1986', 'awaw', 'tikajo.ng9', 'lucremaisnaweb', 'kewerkewer11', 'wewe05', 'josempina', 'miahannan4', 'quocnhi20691', 'mehmetsonn42', 'alojoauasd45', 'migafofug', 'darawati644', 'dlqufet', 'pradipkasofyan22', 'muzaffarkherani', 'subhangkor2000', 'mdzoriff85', 'hendraa95', 'cunhaalexandregomes', 'saw.ananyos', 'imasmasaroh2019', 'ngasundog9', 'sojibislam0980', 'kalaiarasikalaiarasi264', 'lenechard03', 'ancokikiangel', 'firat.yalcin', 'taeny09032531', 'Hzare058', 'dip25219', 'akashalamin635', 'harmishmskdkdkm', 'Nhoxphu124', 'masad2723', 'emdadulhaq828057', 'adisafri984', 'lindabrmrs2319.87', 'antonyberlianto', 'lequocthangx15', '66924kjd', 'moreyfakt', 'faishalasmui24', 'conruabonmat2004', 'biz.ekoled', 'l.equocthangx13', 'rhymesaktoh', 'hanisbas56', 'awaludin609', 'nadeemabbas8006679', 'ryansujana1709', 'beasbodas', 'vor.phuangphet', 'heruindex27', 'yopamuharam91', 'uindrajith40', 'd.an.a.cash.out', 'genzocan4', 'makoli83', 'Boboigirls675', 'sagirahamco9', 'vorpaldemos', 'jannatullove98', 'channelgamer67', 'ryzhkova777333', 'voznyakolena777', 'mohamadrokim99', 'ndastahu', 'kaitlynisauti66', 'nanaha1302', 'krishnakumarsarker11', 'mdmannanjunior', 'ali567cmit', 'sebastian.zacharski', 'bismarckcaetano13', 'fitahiw', 'sanajoy783', 'rmdraihanulhoqe', 'pabrelaitoexi66', 'taekk3773', 'ellagadog', 'abdulloh5115', 'shiabkhan016', 'kokosanti121', 'denjaka88', 'aviariyanto777', 'parovej4', 'okq55910', 'tokkebi2017', 'dodimonroe91', 'skhan198612', 'mituboheji', 'Usggsvs', 'ap.s.ifu.bitcoin', 'uqe90506', 'smpalak', 'zejebyw', 'anmaulana842', 'ffcoeluans', 'modisaotsilemohulatsi08', 'ngadimin646', 'princedrake2019', 'krypto50-lemido', 'wawancute2019', 'Yasinakas', 'dayat.iceputer', 'maryatipipin34', 'ZASKIVINA', 'neulismardiani', 'suspectmckenzie', 'hilaryhzjsjs', 'sm95527010', 'majdolee06', 'Tranthikimoanh20177', 'kuri', 'doanhduong54', 'robertocabreira3', 'nguyenvuthoai13', 'j3ngk3liin', 'sk5151564', 'nadiantaagus', 'muhammaddianfik.rimustofa', 'depajahermawan13', 'tuyulgaul07', 'hmiinran8', 'yemberj25', 'dorisruizms211995', 'Anvarnurmetov84', 'pajoyu', 'uzzal2029', 'Valentingolub18', 'Naseerajk01', 'Nguyentuananh259104', 'agilkinantyo71', 'jt17488', 'tomatanha9', 'rendibrian90', 'khansadiatasnim', 's.yarifrival88', 'underdry', 'ijazali109gb', 'behruzbotirovich701', 'nayeemhasan62', 'johurabegum361', 'arwahanci', 'sadafhussain43', 'dealubis2019', 'terr755', 'mriyangihawane', 'b55anx62', 'rachelohuawe11', 'vasy000001', 'tr54678', 'mrjosc101', 'Anik27435', 'vikramadityaguharoy2', 'gromagromalena', 'alibashfar13', 'baudelairegbewedo', 'zikrizainal462', 'setiaa037', 'asifmanzoor299', 'dantv8890', 'sukuindung', 'hokamuyiti', 'muralivasa73', 'jibon99089', 'iuv89885', 'rebeka59', 'ream', 'onal_abdullah', 'krikunovslava', 'santyvhjvvv', 'ceenoo9', 'aizazbaloch5401135', 'billynurakbar', 'snakeb2', 'navroopskdjdj', 'bakuksate3', 'nanaro0027', 'koku', 'forhadanik786', 'aseppipi760', 'ibuzakky', 'effelin222', 'wawanse15', 'ahmedshipon275', 'socabenggala72', 'idreeskhankhan47', 'mesutsrpk', 'arysurya', 'yangberubah12345', 'aktarrafa51', 'safat5887', 'mario.melq', 'pkaewkecmni170', 'medede80', 'saveenergy87', 'zenna7109', 'nurmatullah123', 'telestisu40', 'stev65507', 'pracovnimo', 'famiddaraz1', 'vivemcalger', 'Lehoan721', 'alexandreandradecolares27', 'mddulal788248', 'rain88542', 'ferafirofreiza', 'neldafebriani', 'mimpikali56', 'rogersad1976', 'maiyeudtnl', 'lilitsilita', 'fianharyanto', 'tipsntricks2018', 'dreyerash342', 'le.quocthangx13', 'tranhuunghia23ngt', 'crexusbit', 'mylife.kif', 'famidrabbi801', 'Nuhzushs', 'webstudiozeus', 'vanhuybk', 'hedef15', 'nurkosimaaka179', 'boa7352', 'citacitajiwa', 'mrjosb22', 'jicolizov', 'ggeorgechapman', 'agusn231117', 'ardiandwi092', 'khanmehran0302', 'rian.anonym03', 'sirapan65', 'saifulsdmarind', 'tanparoko830', 'esrefoz07', 'vahid.r9772', 'oratau63', 'zhieyz1995', 'sitimahmunah57', 'nguyenhaiduy07102005', 'www.dossarthur', 'zaenal881999', 'Biyakanku123456', 'seyyedali95', 'ysugi79', 'wlhne', 'aleksandarmitrovski1', 'aa28', 'le20112011', 'ardianprimadi', 'gunel.quliyeva97', 'jarasisutiawan', 'rayhanull12578', 'ahmojahid01', 'goradon404', 'adriano.sgs', 'wandi.panjaitan', 'evgenyVM53', 'kris_ben08', 'pg756961', 'nanamarina887', 'zqgpuzhqmoboinfo', 'redbold069', 'arora25977', 'ariyansany451', 'Khtmqca', 'vbwea', 'paris04fr', 'phuchoang3333382', 'jhonbahar348', 'areghovo', 'ilarionetworker', 'rokibahmedgp', 'addintkj1', 'bechiberenger7', 'tasf777', 'maithidiem58', 'kaurasaifullahee', 'thaitran046', 'azka26154', 'simonoriolparra', 'tik.aj.o.n.g9', 'itsashik', 'roikiroti', 'Kanoripato', 'rm15x11', 'bittest996', '53c4369766', 'rang.pmn.309', 'jamuk000', 'mupiaibwm', 'maverickclemente11', 'robipurba5', 'kholismazid99', 'Olegbsss', 'tika.j.o.n.g.9', 'qeqoduwov', 'munna.islam016', 'jayrmanga-ba', 'iub58579', 'hmidrz', 'ronaldo98989898', 'hsjsjsjdd', 'fuwi', 'rogermlbb638', 'baris.gecmen', 'gatheringsregulated', '00prantik00', 'bsoeko', 'mocisuvuj', 'webbwebmrs131.990', 'manizaarmin799', 'drmsaeedkamboh', 'rintowibowosh', 'xigimape', 'Rajkonnasamiya', 'hermawangembulz', 'viscripting', 'alipk63225', 'dot.northboy', 'nanonani67', 'aheshmadushanka10', 'gerimisujanudan', 'harzbagus', 'indhamar160501', 'valval51', 'yishmal290', 'danield91112', 'jaluhutharahap9', 'qqizwz', 'tanvirbabu2015', 'Jakconss34', 'becakeb91', 'geuavo', 'aa22', '99dewilestari', 'tikaj.ong.9', 'riduanmohammadriduan5984', 'putrirastini', 'umarking01', 'imamsuhada1988', 'pearsonpearms201995', 'andribogel212', 'tuspuverko', 'Abune01', 'beru.koliko', 'minderkdkdkdkd', 'ozcfxwo', 'hheyoxt', 'shifukatoryan23', 'iyut99', 'srfguzel', 'postingsmarvel', 'zephyadlin.banga', 'aa06', 'jessada093', 'andit22', 'lethikimchung1968', 'pangeransubuh14', 'sulaimandasilva10', 'pashamullin1', 'leq.uocthangx13', 'supunprabath46', 'mfilyas14', 'amstrongmarvin', 'Selmanuzundal3', 'giorldifrey', 'tranvanhai1985', 'lag331962', 'kolobutho', 'Sleeplove2532', 'noyemozuw', 'robertomaletta', 'vitalivolk28', 'kgjitwj', 'md.norulaminbiplob', 'mikemachuma99', 'hikijaa1233', 'rfrankjohnson', 'nht.yldz33', 'nhatamazon2002', 'yn09265', 'logmanezizov0', 'rinafitria2019', 'arielgayon97', 'haydenukioqi55', 'guri1983d', 'zmallah213', 'ivankovhim', 'sriwisnu', 'phexis', 'retukiop123456', 'andriskurnia2018', 'abuhanifmonshepara', 'idz56022', 'ipoyhadik', 'ihoreee', 'blyfck', 'tomispipat', 'artbitcoin007', 'mosokseh', 'adamraditia', 'cdas19600', 'haabieabdullah', 'b.a.4.14.0204', 'meovuihs', 'thehobbit504', 'nilsonreyes2819', 'dyq72044', 'gogomugiwara', 'ngd83566', 'ageuygado', 'myvidz28', 'samicandra2', 'dimasaditia90', 'Suytrants', 'dianangga.raputrawijaya', 'mdabdullahbcs91', 'mahmoudahmadinejadyoushoaib', 'bibi.morinelli50', 'Latifahbhy', 'ahmb4p', 'bertawa', 'alankadafi', 'pawanshankar844', 'nicholas12', 'shjyrdcvhyddv', 'dmitriy19811', 'jajaltirakat', 'ralkity', 'kingbaco.k02', 'kertimipopo12345', 'mautidur002', 'gudallempoh', 'Abdullahjr783', 'amininibukankalengkaleng', 'rk2295793', 'leha', 'famidrabbi5', 'hindunasmara', 'ucoksimbarra', 'ayamkampus9612', 'tahamuhammad638', 'sahkyb69', 'nurkhayati1290', 'taripelakor', 'tohin0173120786b9', 'khoirilanamm3', 'alif17643', '41a313e591', 'guxxi1971', 'trendalexTAA', 'Kuturplat3', 'jehomak', 'jonyorg1', 'mohammadalimuddin87', 'Riponroy935696', 'datingstreet', 'sora64-61', 'Axwjaidwikh', 'alibashfar10', 'glenasinki', 'indrae325', 'visanu.chamngam1234', 'mustafid67', 'ntcnvt228899', 'garsenkamser', 'penginkitul0', 'aufahwi', 'gonjret', 'rjramesh.ntpt', 'thomasroger67', 'hertzpay', 'waidmaennern', 'alifathur2019', 'kolormodol1988', 'donaldanmr241993', 'phyuu45678', 'ajimumin88', 'hridoyami143', 'wistualanange', 'poleniza123', 'imavjhu', 'ilhameko54', 'nasirebol0', 'aypraha', 'guhusj', 'ririsrisalah7', 'anikclogeboy', 'juniorinacia2019', 'nide', 'ogisallshoop', 'rerumputankering20', 'rasitohraras', 'keavenkhan', 'hufivox', 'shahbazahmadmec12345', 'jatvathpreeth', 'endanguwa', 'bagusavici', 'nelodi204', 'fieldingadoapa66', 'sekesunyian', 'jatiindro9', 'imampoerwadi62', 'tabtovsky', 'husobuj8', 'jyj37790', 'huynloan180', 'vinobuster1988', 'el.rastkar65', 'sona301910', 'deayurhmtia8', 'bonatansirait', 'nadiasofia100', 'adamck20', 'anggelcash', 'kernas2019', 'ragonjan2020', 'vasamadhusudhan553', 'mehedihassanjibon63', 'fitriyani.ziawa', 'hossainsabbir53878', 'basahtisu72', 'gloriamedina12087', 'culmakapso', 'pangyammo4', 'thanayuy0802', 'mqt831', 'abdulhay1987', 'tasozij', 'aldikumar5', 'rfw27178', 'sugenk80368', 'westelbald3317', 'christopherfowmr081992', 'sidilokao9', 'rivalsutomo', 'suhagmiah10000', 'a.ps.i.fu.bitcoin', 'kaowsar15', 'ovimanimon420', 'shuliman2013', 'mostafa_mirnegad', 'pecahgalon37', '175b31eadc', 'perutonaurel', 'jumonodewi733', 'hoangphuc33333388', 'msohak272', 'prasenjeet.chakladar123', 'yn10101956', 'kaemlia8', 'lizapeach110892', 'annisaketiga', 'fazrinfazrian', 'hussainbokhtier111', 'giwijo', 'anassdakyouk15', 'leiyah822', 'rowhentrish', 'dorothymyersms11986', 'sakibrahmanpranto12', 'davidsupriatna1998', 'gdjbenn1209', 'Imm.a.nue.lg.3.3n', 'jjs.fiel', 'bbhh113202', 'mehmetcamoglu65', 'bbba18215', 'mohamddido', 'ruthy4christ2', 'heniara', 'nisowuh', '2fca6fdefa', 'riyanovrenat', 'mamangjadah', 'glenkaandara2018', 'torgyvapva', 'mesinsigar', 'Kosisosunday3', 'frentaga', 'airdrop07gate', 'mdshamim3044', 'Wellywong143', 'rhandyrhay8', 'artekcichy', 'astorekencot', 'ngocthao1999nc', 'malatyaliibrahim4455', 'yuraimex', 'ineueka1990', 'jmbutbakul', 'sandeepskdkdkd', 'tranduy07122004', 'razam0044', 'febrykumis12374', 'furvinderkdkdkd', 'saradoms051.996', 'salbiahkarim77', 'shittunurudeen2', 'mdshin1997', 'bygogarma84', 'a4078138', 'btrendava', 'prn40519', 'roseramms06198y', 'anggraepistore', 'anhdathp11223', 'v.gavrilk', 'senakham99', 'wongpekokp', 'tthuytrang64', 'technicalinformation189', 'novionalis', 'dalamaku09', 'famidrabbi2001', 'bonbonburdis03', 'raimusengak', 'pawangular223', 'danilonovais508', 'captanblack1234', 'ekanugraha0323', 'spg67121', 'niloyroy42000', 'doc11662', 'tint.visage', 'kawaimasu', 'woyawafu', 'hyugakynus', 'sanjayadhikar75', 'bkp95739', 'davidpratama0707', 'finishedband12', 'kmahi4410', 'tjnigeria2000', 'shamimhassan2215', 'hmrohan60', 'kingbacok.05', 'muflihmuflih15', 'anowarhossain1970.bet365', 'alawalawal9', 'aa01', 'kandukoorilaxmidevi', 'Rikyabdulkarim2018', 'Ariff2743', 'ivoryigiosi66', 'alibashfar03', 'apannesingmonie', 'vumanhchien1999', 'kopeahde.ngdek81', 'keith17k', 'dedywe', 'mintonsnsjdkkk', 'bangetalone', 'loloherro', 'sieam.rul2', 'muhamadkozin765', 'tarekdouma', 'azizfasa0227', 'sarahoxuipa66', 'famidrabbi913', 'vmqsjmzlu', 'himanchalthakur786', 'malmuntreph', 'championstroll', 'ballf4723', 'antonsihombing01', 'flangerax5g', 'rambutuban1988', 'hamkaymci', 'angelg30071', 'phinxoflove', 'detololer.z', 'edmilsonlslima', 'judicojean1997', 'mahmudfaisal748', 'tongkosong141', 'b1f3bc37d9', 'rogersromr301985', 'isratjahanbbhu', 'bambangsumantri291', 'jacobaguimr071993', 'leone27121987', 'freelancerifteyim03', 'rithsaret1', 'kudunegoletdukun', 'molayleof64', 'bagaskarimin', 'sopiandimms', 'lequocthangx4', 'loveykdjdjdkd', 'ccpqsg', 'yuhu', 'husein160', 'janumjanu192', 'ammaryasmin381', 'supriant657', 'onlinego553', 'famidfh01', 'jeffreysulmr031995', 'bohay1257', 'muhammadadamhainurin', 'dartohelm', 'ashikh181', 'eugenegreenville', 'audirindi1988', 'ronymalakar85', 'ginglondndnjdj', 'korser71', '17dedc95cc', 'kopetmambu1988', 'armanhossen470', 'mdmahmudul2099', 'm.yasirabbas72', 'kaulakukan1988', 'lethoa0784', 'onchenksaputra', 'sanjeevshrestha049', 'miq.heal', 'dingertingher', 'alimu9119', 'tuyul2', 'fuadfh201', 'bajarku.no', 'peridibrata', 'spak46', 'qimugimi', 'henrysilver15', 'elilogay6', 'amassaefulloh', 'raheeqs', 'rnyadav12125', 'tanguyenthaovy2015', 'fepsicitru', 'markus_harmstorf', 'fernsdomnic06', 'yogalsat', 'bademuba', 'harlimantox26', 'deny', 'lambirgino', 'phamvinhvinh007', 'anhhieupro347', 'hyipmonitor74', 'jambugendong53', 'adeliajuniarti270603', 'daryantobogel03', 'vellyembem', 'anayulianti1995', 'pemburilmu07', 'tarik.3459', 'bittest999', 'nibirhasan439', 'cihuiayu5456', 'nisa96265', 'uyiosa.lonnie', 'lequoct.hangx2', 'brusgianto', 'sabina567f', 'tatarserhat06', 'sunantipipit', 'tiwisafitri', 'saberseri123', 'lemanman0001', 'sexugu', 'mariaarev524', 'saulita90-2', 'dhahini58', 'hussaiansjsjsjdjj', 'atofreload7070', 'salehbayazidi', 'padianganlily', 'curiale31', 'ellaifeasa55', 'tanvirhasan452', 'cerencikpoi', 'duc23102006', 'sagorenterprice1828', 'betisbetis38', 'badavatjanu15', 'kopetjeremotorgaul', 'agusleoaal626', 'hamdanalmustofa', '3domaredo', 'fubijeyuj', 'dianangg.araputrawijaya', 'dededevi2019', 'kinanraharja', 'karminimilah', 'mdsonil6268', 'tri67050', 'rafinajwa36', 'fxvup', 'langitsatria205', 'nuhipihyj', 'forhadreza905', 'tanvirfakir77', 'sqxpzk', 'ahmedshaban1234567', 'mfsal098', 'avakh10', 'gmustafa', 'aisha256t', 'kuyan123456', 'pabrelailiufa11', 'j.e.n09074', 'mdmonirmiah1003', 'akinarbayram1971', 'ardifreebit', 'apu7330', 'Tukimann1234', 'rimanurfitriya90', 'mdnazmulhasan885', 'muhammadalamin36', 'omp07961', 'ah0592166756', 'writerpk2560', 'Zeeshanalijutt050', 'petangini', 'danishking210', 'aa20', 'katieuteimo33', 'emre096082', 'inspectionsaffinity', 'naumanawan35', 'zenatshah5', 'truongvancanh031', 'stej1515', 'kueyahsuara', 'mehdiaz119', 'amir8001000', 'bit', 'tothainguyen88', 'ahdisepriyanto', 'sekalihadir1988', 'shinichichaosusd', 'firiyadhinnurizzaman', 'y4ld4z', 'tik.aj.o.ng.9', 'riadelintang', 'tikajo.n.g.9', 'cokolovasv123', 'sahooking1', 'arifrahmann2019', 'jalinmatrinmrrip', 'rakibm467', 'aaskosasih01', 'baagii8901', 'faa.by813', 'mamoha1122', 'nerkamvista', 'sanchezsifontesmartin', 'aladdinnewesisode55', 'kirigayak553', 'varkelas', 'ghaseeb557', 'tokeborovalobashi', 't.euingnumana', 'tuncaytokaya17', 'Samzhudha30', 'hossenzakaria4', 'bilionerupiah', 'ujilundu', 'kausar.ali03', 'subekimentah191', 'tinaprameswari', 'kosna1972', 'vhrdshc', 'blaiqu', 'www.gonirhossain510', '7veobrl8zx', 'detol.olerz', 'esmasenol795', 'regopas', 'smad41', 'wpdurumvideolari', 'kiranlee87', 'sunitab502', 'shuvomollafb', 'robbyabrahamjasa', 'Rahmawati1996.diana', 'bongkaraja02046', 'jaisueb33', 'yofilih', 'rahadianhanif98', 'sayeftop96', 'amydanielle22', 'weruki1224', 'rotiaparane', 'yakasin', 'hieu28082023', 'ginginalawi1213', 'arrasydvristantz.alamardani21', 'bdboy11616', 'adriannopri10', 'lnncljusb', 'frances.berrms2.91.9.87', 'harunorrashid318', 'bukanakunoetama', 'gulimanganrekasa', 'stephanus8', 'irobayuningrat', 'pascual1981calle', 'tolipilo7', 'king.bacok02', 'penggemarduit900', 'mukeshhunter108', 'vkatia', 'dinhhuuthang533', 'umarnazzuwa', 'misteroeang', 'jhunrich1975', 'keriscombong', 'kataslepovkaa', 'aa15', 'Ariyanuar17.ay', 'rkrick3255', 'doni190688', 'sakila12133', 'victordivom', 'aslam.valliani', 'msabzehvari', 'ni039833', 's24011969', 'sutygyl', 'Aribastiady10', 'merah9689', 'aishambiro70-zux', 'aseptamba0307', 'lutfaijreng', 'lovatinajuliens', 'oahzulfhn', 'luisfuertes10', 'sharonbms271994', 'selimkosgen3', 'imogenadiici55', 'sanjidashemul9', 'abdulqosim868', 'xuyasi', 'gdbfjjhfnfjfn', 'devrasyue', 'tik.ajo.ng.9', 'yatifitri775', 'dangkalpen9', 'mamsmahim', 'maningjan123', 'yusufsi.ura.n.g', 'atrtar.01', 'Lengan6891', 'banyuputihlhooe', 'ilyashidayatulloh35', 'guritgfc1', 'zowuzomi', 'sabairemadze', 'gabereakeh', 'masaiyalah1', 'canankocar', 'jukaviq', 'perdanareman', 'borisrfs', 'xuxihohuwe', 'taijulislam565492', 'rosen74g', 'afanarifandi12', 'famidrabbi8724', 'nguyenhoangtrungxd89', 'anarkalianasta', 'phamtientoi89', 'jayarfuentes5', 'lyudochka.litovkina', 'st.fath019', 'tioardiansyahmmm', 'picasso6', 'ser.novoseltzev2015', 'rezaulcut', 'zamreskhan', 'pa.la.k.p.ala.k.g.a.y', 'padagemblung', 'hk2746787', 'alibashfar02', 'akpinarbayram1971', 'laurawanda828', 'diniputrilestari331', 'ngoh000001', 'durasinam', 'yusufsi.ur.an.g', 'inuwasadiqmahd123', 'fixshidayat6', 'emras045', 'hawifattah', 'adilr5142', 'nantusimori', 'werbemitteln', 'omieokumar1355', 'saefuladha9', 'pobimok', 'ekaliandonk', 'craiggrmr.221986', 'akantor7482', 'miltonsarker2012', 'Murti688', 'VladimirIvanov741', 'kithsiriramanayaka9', 'uamangcp33333', 'fuuffnora', 'ravanzhenta', 'augustokumara', 'nirob784578', 'hn057635', 'tchekessicharlotte', 'atengsuhendra', 'cristinafh7091', 'hasanmoon210', 'evanseburu32', 'arthurmmr061984', 'tupymebur', 'bexofes', 'tilislis75', 'ernestntan', 'alexkillmonger95', 'sugiyantomuhammad', 'yasinbahadiroglu441', 'nurmahesa.nm', 'tukopuj', 'kvi66427', 'Smithxcaliber', 'lemmveuro', 'grsubrahmanyam', 'puadabdulloh', 'tik.aj.ong.9', 'aristolochiacea', 'punkoelena57', 'ohanife919', 'lequocthangx28', 'Rkraju.das24', 'ahmadjalal382', 'jonobewoks82', 'evaniamelinda90', 'ogvgooks', 'tarixozcan86', 'feliciawilson820516', 'tapoklah', 'polzamudiojr78', 'everydaycoins', 'preetondnndjdndk', 'danfu2', 'onlinegundulzdiyudi', 'padalinoalfredo', 'mataxari1958', 'sandratamrin30', 'a.gholami69', 's31839214', 'grfvhmljt', 'Blockchain3063', 'anymousha', 'arifinahmad1207', 'kiyaramberhshd', 'muttaqin.ki', 'chanraksmey.thach1', 'avashchhetri478', 'azizdol101', 'bakulmicin1988', 'lequoc.thangx3', 'davi_ahmad90', 'dlamininoklunga97', '1kzrzv11', 'lmd611981', 'mi.qheal', 'Bukitanmuki12345', 'yoyondjatmiko', 'bexobaxag', 'famidrabbi2003', 'k.opeahdengdek81', 'hossenshakawat2', 'selvaraju.chinnasalem', 'darmawanethereum', 'mousumimoulick2018', 'gilarrykxkdkdkx', 'aarya210178', 'xagefup', 'shaikabdulrehaman17', 'logout81', 'ankit951743', 'josephinecunanan142', 'dwiyoyokj', 'hmrohan80', 'beqanarsavidze', 'dungdepapa', 'chenet', 'ibnukholid88', 'Tuyul', 'sbbeausoleil', 'itbosser', 'rendahyo', 'sab177508', 'sadikul724721', 'anggivernando2807', 'jensenjensmr201994', 'langitdemi62', 'nungguniapa', 'kemiea', 'ekodwi78', 'wabaram', 'mdshaonislam8277', 'sholikingocing3', 'freelivemsn', 'serhatpala50', 'lucas.lucamr281995', 'yondu871', 'uz.5454908841', 'violaromlah', 'boommonogarden', 'ba7798207', 'mdtanimmia2', 'kumarasabil94', 'evaking', 'solidman_solidman', 'congnghe2004', 'kartikaamanda2018', 'ajaynapitupulu6', 'ikawulan273', 'dodoldodo348', 'Nguyenngochuy121281', 'rara319', 'badavathsujatha86', 'balenati', 'veroniquemissinhoun97', 'fatyur667', 'cad68c9f15', 'b.aako7788', 'bassemmerieh85', 'yahiamalek777', 'jujunjunaedi85', 'hshshhdhdhs', 'mdbaul6268', 'azmataliazmat333', 'mega.sergeev2012', 'hoangson096', 'czw55257', 'luthermanalu18', 'aa10', 'edim42559', 'uujek123', 'worthwhiletakes', 'amileman02', 'kalagondangtaehe', 'eka.commsc', 'narayanagrdgautam12345', 'bilalawanbest', 'H7433242', 'vathelium', 'attayahana', 'tammyvms081.988', 'umarking02', 'sotnarso', 'jimisohihi', 'sajeshrukwal5352', 'reza.azadian63', 'yunitalarasatimmm', 'maalexandrov75', 'noumanmir011', 'yasirnoor82822', 'muhammad.dianfikrimustofa', 'bahlulluh', 'ghoost9191', 'kadalcagakradabad.ag', 'robsonmalta38', 'mutiar687', 'd.iananggaraputrawijaya', 'lequ.octhangx2', 'eantwi874', 'khggfujhh', 'yebekiboca', 'Safriamanda6282', 'kelapaijo1988', 'shabir143bakup', 'weirdboibubs', 'munawarridwanbahrudin17', 'sendirilagi760', 'yohanesanggun04', 'pericoripiado69', 'apaiyadolanan', 'chandrahlm54', 'goldsemy', 'vikygejolakpesugihan', 'aisha-mbiro', 'naeemakh686', 'kacink0404', 'ronixewow', 'adasaf.faga', 'jembutelele1988', 'anthanhhai001', 'zero.one291108', 'b.erukoliko', 'atikh932', 'geongesse31', 'indahpratiwi201', 'smith.6rsqs', 'anandadimasnursofy11', 'gemblungkae', 'lequocth.angx13', 'vankim.vk45', 'abdoumagicboy', 'leesonchot', 'mariarosariavittozzi', 'yoqubjanovnodirbek66', '9544888', 'blackdevil170253', 'sbr05691', 'tapuxibec', 'vuydoragno', 'mbuthoremember77', 'laho98757', 'jrahcustor', 'suwarnohangemuli', 'clipper_pascal', 'valero280', 'iyuunki', 'krivonos.v', 'rmi18949', 'nomikhan177', 'alganem14', 'gomboenk22', 'pizumi', 'dannyperdana', 'thaniaoktav94', 'bexkam', 'asyrovim', 'coltoladro', 'simanjuntak69', 'juancarlosdorante', 'matherchod123', 'sitiazzahra255', 'zarobotok201850881', 'siraitalay123', 'jenvylorde', 'nina51aleks', 'pbslev', 'kveni32', 'ka2291007', 'manikahmed01925', 'faheem86.q', 'postradorossana23', 'famidrabbi120', 'suparat.kk34', 'arnuvo57', 'danielmcqueen841', 'rikirikiardo', 's-raduga', 'arisfaddoli01', 'popolmimika', 'arthurc7501', 'muhammaddianfikrimustof.a', 'wilprudav', 'reinmotoh', 'kazam5694', 'jonyt.aqiya', 'diempanijajal', 'jayson.prospera', 'ofansofyan123', 'whidyt148', 'vemupyce', 'buomquynh', 'vikijffkfkffkf', 'tik.ajon.g9', 'iqyn3009', 'hoarosie101', 'dwiindah100', 'jesusfa1479', 'hafejanisurrahmanbd3', 'cucu.kesayanngan', 'Anhtrantu456', 'quynh01122011', 'kokowebs', 'roseking', 'makaylaiziohu44', 'tinkoojsbrndkdkk', 'alwihariagung3', 'gmsakib905', 'pertiwi12344', 'contributechelsea', 'raf050916', 'imanandra666', 'hemsakatu', 'arerbazeus07', 'zairankiwa', 'a.honeysandoval', 'yoyoprincebilal345', 'gemsansamrin', 'hongdanluc', 'dimkazav2005', 'alza4059.77', 'onlnethanks3', 'tomiamarsodho', 'tgumik', 'hoym', 'liton41551127', 'bangkaibau798', 'lorenzoglenn026', 'ibukzakky', 'noviasalsabila45', 'rachelthomrs151985', 'hisnanrabi553', 'doniyor9601sh', 'hartini2019', 'kimberlycustodio360', 'barata1333', 'renatajohnson150', 'sscbatch2019', 'rendi012awan', 'koarkobar', 'tikomarg', 'yyuseran', 'mandaniaina3', 'yusko1334', 'kwrjakerasbro', 'geranmency', 'abdillahrassya077', 'simbosha', 'essetregisnc', 'media03117', 'bgq22056', 'landrypaulin21', 'rachidouedraogo831', 'jhamlacasa', 'nattiboi.cody', 'kjw27026', 'fcdcgv', 'devinaalviola91', 'famidrabbi901', 'mrjosb11', 'osofficail06', 'waresh420', 'yaldani58', 'elk16065', 'rehmanattaurrehman748', 'gistakaramoy2019', 'alimuhammadghk366', 'Hubertahissou59', 'dequnazok', 'hadiongol27', 'gloryson1994', 'Nuju', 'cgghnvhj', 'indahdwi841', 'guneydogru', 'arif28041986', 'thanh478999', 'maya124', 'ryanadeea', 'christopherjonrodriguez85', 'anhanh1asd', 'wasimali0965', 'mamaradah', 'k.ingbacok06', 'subhajit8918781605adhikary', 'tikaj.o.ng.9', 'richardadams2116', 'steviewiryana2018', 'haibbhh90', 'anngil.loyola2018', 'arifsiddiqi04', 'hgh', 'rifaltikong390', 'kokopinak123456', 'buntung669', 'cmaya2429', 'frede_flores', 'ugetsatu1', 'howtostark8', 'millaanggraini594', 'maroofpitafi3', 'motorcycle34', 'reedreedms011986', 'kan.d.o.me.n.o', 'mapsisoydo', 'tketamin', 'siscaaulia31', 'sarifamir38', 'proflupi99', 'bezrom1961', 'sanries6', 'mohammadrostami.4450', 'sa7154248', 'dinamision11', 'acepwiwindelisa', 'imran24k', 'nonabrownis', 'nvrenam', 'Khatiwadamanish5', 'aurelle.adjahou', 'oninssjonpatss', 'Hafidzachkam20', 'ivangamepro', 'sodhisjsdkd', 'shohagahamed785', 'sopnochoha', 'botakkurang', 'kunyanghantu', 'ivan.de.mivtach', 'liquorkrypto', 'leetomy49', 'doelholis118', 'inzener01', 'shabiharahman2018', 'ddoychanel', 'slamet9891', 'ngoctram20132015', 'Tonynie2771', 'caca', '777vasya7', 'resildawunderlich', 'platon7255', 'Rittik830', 'alibashfar05', 'tr65798', 'samsuldayat425', 'sendangsariutararaya106', 'lequ.octhangx13', 'ahmadwafiq867', 'ydsljh', 'yuirada3305', 'atepsuhendar03', 'tjvnpja', 'jo.nytaqiya', 'ferrisetiawan971', 'thuybaovt', 'bittery56', 'alk65657', 'jisherjuan123', 'ashleydreyer79', 'dalbanpolaeh', 'mr387746', 'lcf94317', 'kormaatah', 'vokeh12345', 'h2warmet', 'galangpekanbaru00', 'mdbidhu123', 'Loanle63668', 'matanegenep', 'boys08364', 'agusawaludin10', 'sayamahlobakahaya.ng', 'hilarymfkfkfkf', 'doramin1988', 'abbaszaigham420', 'kahya_osman_07', '5a4a2e411c', 'rosidarahmat', 'dhonartindo42', 'phuonganh.mice', 'charlottemaealdevera', 'blingaiahhj51', 'vasterfoser', 'ilmu7ifw', 'peredapegal', 'busizbilgan', 'kin.gbacok03', 'pzjupizx', 'Nayla.manis27', 'Nevzattis', 'phankieuhoa01', 'rk3032803', 'ladyidiuru11', 'minhtri8616', 'ginalapi', 'endallam007', 'costusroot', 'irfanambrizal9', 'serkan37k', 'lequoct.hangx3', 'xkw03402', 'batokebatokeroti', 'kommunismens', 'sadrimuhamad82', 'trunglwbigc', 'tikajo.ng.9', 'semizvetik56', 'luckypratama831', 'tharathep003', 'lemmlaotrapagina', 'p0997354517', 'sokna.suo', 'anantadwisatria746', 'jacobsjacobmr261997', 'p3s0ckmmo', 'asadafag2525', 'ysfcanpcak', 'hieuluan280820028', 'ghausblasund', 'ijoeltaharrimkita', 'Sulad3', 'kranta', 'karacafatih1986', 'a63658933', 'k.gersten', 'Ultimatesundar08', 'bungasrymainda', 'bloggermonetize7', 'whendkdkdkffkdddc', 'hamed.hsp9', 'berukoliko', 'xkjnyvyrq', 'Tatangalar_54_', 'leoyakov52', 'Tranthiloanab1977', 'ilhamrizali.ir', 'esisamon420', 'arrasydvris.tantzalamardani21', 'yuyuherdu', 'armedrindam03', 'citrakirana250', '10emir555', 'm4zp0e', 'hifithread', 'ranarfreelance2019', 'jmjony100', 'ismahara2.7', 'alaatebessi12', 'trihandoko0087', 't113421', 'Rayhank032', 'lailah3scobar', 'hinoussasorho', 'Muhamadruslan5570', 'luckykhannaa', 'sommaimeephon', 'ashikhasan540', 'lequocthangx22', 'aleshka_drugov', 'viplathe431', 'adjie018', 'paltooth', 'mosso.shei', 'ap.sarbioke365', 'hungle19983', 'ciloksendiri', 'verslen', 'saadmagsi03', 'sierrarosi88', 'sanjibsharmakb', 'wjc14686', 'amrinderkdkdkfk', 'Ibrahimshuvo900', 'nhanthan760', '6f5cdb458d', 'vaza-77', 'mhsinghudaipur07', 'bawangmerah', 'dekhtees', 'mariaoff', 'chomelmel05', 'bristydatta66', 'jgpodolig', 'kolohanketek', 'dosanisohil5', 'quryozovovashaxlo', 'iongindea19', 'minhduchb20002', 'gestiamanda', 'Demsiopr_slm2109', 'xnb58178', 'bill.grahmr121991', 'akunamerika2', 'sakkwooo', 'l.equocthangx3', 'abdullahalaman180', 'aleonorica', 'cuongc15', 'bangsyaf97', 'umaru20', 'evisyuli', 'baloonkhan09', 'Rudanov567', 'thong_cb14', 'klim2968', 'habibnkushbd', 'ibarraharzel', 'azmqsruv', 'khanhdobao1234', 'shirshovnikolay1111111111', 'adnanbaloch825', 'okedicoba', 'azizulislamsuvo24', 'sohel9302', 'millecentd', 'zeeshanmughall6161', 'kausaralom10', 'ipnufajarhaq', 'rasyafachry.atmaja', 'banglahilltech', 'wopwop123456', 'jalangkotekosongdua', 'melaoturu', 'nsaravanakumar09', 'razinv359', 'Adnanchandia7974848', 'bongkarajah0', 'fahmirianto66', 'Gredjhon2878', 'kentirkabeh42', 'vinarin888', 'sanqui_angelo', 'asik', 'koyogadul1234', 'famidcoc', 'christiancammr121984', 'jecson123321', 'mdromanhosan', 'yunitaanggraepi2019', 'quynhanh01122011', 'sujonnew7788', 'rslkvhifj', 'a.k.u.c.int.a.h.a.ra.juku1', 'selekeju', 'gidoxege', 'sz4923435', 'casboril1', 'greycamaira', 'larasanitta', 'ua162189', 'priyono513', 'gibkhocfhjh', 'patt2401', 'nkocbabi', 'famidrabbi701', 'rajpootahtisham6', 'dianan.ggaraputrawijaya', 'pertamaudan', 'hasta.orhan35', 'lemonskkhan', 'udx93528', 'lawuhiwak4', 'zanyarmlaga', 'zloyded190', 'rajaarbab80', 'chienthangdienbienphu1975', 'nebovug', 'gulaberem', 'nguyenchi.tam946', 'ahmadmamun02', 'chcgbbks', 'anjingkolom', 'nihamdam', 'kanghid3', 'ariyancard22', 'anggadheeka70', 'budiaja2774', 'vostrikovigor1992', 'venturefats', 'sunarnisunarni496', 'linktio8', 'vulteletru', 'faisal1980.idris', 'silentking699', 'nolan2148', 'siamuddin0008', 'lidahonaurel', 'masboveng142', 'peferreirabtc', 'reyeszaira237', 'krypto50-13', 'ilmihudayanti', 'wirana55', 'a_a_davtyan', 'metatron1971', 'gapunyamodal', 'Rutinitasku1224', 'atnznbulz', 'mr.phyolay11', 'rakibsojib7', 'nengdini909', 'doung8dll', 'atikmunahiatik', 'kolorijo19888', 'ahmedtusher569', 'mdbiplomb', 'punopogu', 'nhoktmt2002', 'asifmirani83', 'tieutranh711989', 'majidurrahamaan420', 'agusleoaak626', 'hang12535', 'sorrany066', 'kingbacok07', 'qkt51580', 'mstsakib4', 'nuna2456pp', 'tikaj.on.g.9', 'dasengabdullah', 'mdshawal4', 'luikang27', 'mr.arslanm672', 'Gustianaviranita', 'banglal.2437', 'amelieobuipi11', 'gintamilahi', 'Truong18000', 'pak491109', 'hadiratzebua06', 'bautista.ad', 'hecaru0330', 'mulawardanirisma', 'bisnessrabota', 'shelomi80', 'shahanajparvin.runa', 'mwra999', 'tika.jon.g.9', 'kamucantik089', 'ikanjair172', 'whitekopii', 'monoa987', 'subhrajyati1234', 'jonytaqi.ya', 'rosariaindah24091975', 'futew', 'p3s0ckonline', 'mrgoendam', 'permitsbri', 'aleksejsem7', 'hamdi_aj', 'adamdjogbenou', 'arrasteven', 'kanootje', 'eugenglotov', 'axisbeken', 'badegepancen1988', 'kadal.cagakradabadag', 'anggibilqisazzahra', 'jalees00786', 'mun274355', 'iqrasaleem2211', 'samapolthongd', 'letuanvu0888865445', 'edrine97-1', 'ewseewhh', 'Arifsilaban1000', 'yokkita', 'azobsohan33', 'Vuhauq', 'Tangthanhnha8', 'ariani.muslimin', 'ravinderbjjhkkh', 'sinfuln', 'shohag500800', 'swarnanarmala7', 'lugi', 'nur_buwono', 'akun4370', 'jordananggara2018', 'cahyasanjaya28', 'Ahsanaltaf320', 'ojbrsv', 'fifitan94', 'haztavia', 'sureraises', 'buttons99', 'cagantek2004', 'nasirsaleem784', 'mdyounus3ali', 'dinmuhy559', 'belisbetina', 'niramulyani', 'lisakms061987', 'sudiptokp96', 'blues_stones', 'ngoctu1102st', 'tariayam01', 'mkhanbhi1234', 'phudutrang32', 'sebonawuji', 'khen0289', 'membuktikankopet', 'donalddumr1319.84', 'asep1238908', 'sintaromayanti33', 'bbub878', 'skgazi41', 'sohelrana538758', 'diananggaraputrawija.ya', 'h.farhd.mi9531', 'mysteriousko12aj', 'buithanhthi292000', 'mmmfaruk44', 'widafachrul12', 'trangdt2526', 'jsyaban12', 'shahadat5932', 'mdrazu2018oman', 'parapencari', 'ranasorkar5273', 'muh.ammaddianfikrimustofa', 'muhammadsaifullahee', 'gilakucing71', 'jarukit.pormloet1120', 'te.uingnumana', 'brittanyburms221988', 'bangetkucing', 'nbreschnan', 'adits5296', '1222abbas33', 'mqihakhe', 'ndogkate', 'nembedikekahi', 'ahcenesmaili', 'kelvinjon556', 'ghelorapsa', 'yeizmarie6', 'firebase331', 'd8421839657', 'aridenis', 'granicerii', 'matabengis123', 'ginghhahahs', 'sora64-63', 'overnoda07', 'endsari10', 'nozadze.davit9', 'diangalih167', 'kayanangpuri', 'sofiaihuipe44', 'akiftamdemir', 'xmvwr', 'nungsepjo', 'aanindi347', 'ada.serkan.37', 'eduardo.cbad.bastos76', 'ilkerzeytinli', 'ilgar196426', 'arifin.nurohman123', 'venkanna5000', 'fajarsidiq1232', 'kasbizean', 'Padriharyanto999', 'piarath232810', 'mrjosc46', 'lequocthangx12', 'kurtevirko', 'per.andrey2013', 'dima16028017', 'budyraja', 'madizux', 'zaolan2001', 'h6245906', 'curutbelang40', 'Entan18jr', 'imamhakim643', 'lifyasaja20', 'bastianberta', '360nsbl', 'priatinurip', 'fazilkajxdnnsn', 'blessingluwaca', 'Cherrypham2503', 'princeyasir387', 'kaeasujere', 'pujasarkar28579', 'bisadilewati', 'dalitginanjar', 'korifey2012', 'dheibinsol09', 'supawadee.thonlak', 'keyzaky69', 'arslanbusa555', 'xuyentyty92', 'chadshodhuraterjonno', 'aurbach99', 'mahbuburr782', 'apahanya64', 'muellerinterestingly', 'ms.hopkins2016', 'lan.dudulzii', 'shorohov1', 'glorifybryan2', 'bd247463', 'khalid.khillje', 'mdhumayunk792', 'krrishraghav458', 'ddhan200', 'erjocktane', 'abdulkoplax3', 'nopanan', 'zm705199', 'iant6684', 'ikhawathi', 'frustrationer', 'Junoki', 'raifa1988', 'layonbh', 'basingsaja99', 'nkazi1414', 'sahabulislam44695', 'valeraboss990', 'suratbelo1988', 'asepsopwan1', 'vivuguv', 'fhfamid003', 'veno23', 'mochteyhan97', 'biligma140219', 'alexrider90011', 'arlenesysn', 'ccc', 'saymonsifatbd', 'sk0665592', 'ammadd54', 'putekbudrek', 'kryptoflai', 'entissutisnna', 'armayuda15', 'maudiasoka', 'leheronaurel', 'masudnoman2', 'santikaazahra', 'cipegemuha', 'xipoezhe', 'desktoppanel', 'Rodacude1', 'diemlien8789', 'simo.1boufouss', 'angeladealova4', 'nasirhosen0137', 'ba.jarkuno', 'rhonmusico', 'yantokokokopi', 'mdmkl875', 'aa29', 'ivano43a', 'd.a.naca.s.h.ou.t', 'jsalawat2003', 'Alawal885', 'yakubuusmanabdullahi', 'iibnuazis', 'look.locondo', 'jelocihif', 'suwirezehu', 'amitsaini428', 'monstermastermn', 'kalamakulami', 'verayankova7', 'khoalinh2327', 'nhasanaga', 'herrycan17', 'divinemonday88', 'dudreff', 'jospinekohzeh', 'collinsodualu44', 'munggah1985', 'alfirijal350', 'masyopo', 'lochum1997', 'asaat515', 'jarmas1944', 'arocenajoan', 'paijo9359', 'Ach.farizal', 'muhammadg394', 'rara464', 'erikrahman2019', 'baako.7788', 'shinichichaos2', 'rafih933', 'bappyahammed54654', 'aa19', 'oceansdirec', 'Tranthuhien270799', 'masekipeng', 'elbacano777', 'smmd1321', 'sbintolib', 'keniyu', 'jonyta.qiya', 'aoaelk', 'ariiajjj', 'dialahtuhan19888', 'brandynet', 'bruceking361', 'usahamajujaya1988', 'pijevu', 'hawkz0303', 'renikurnaesih', 'unachukwukiswado', 'kayexotikz', 'emadhamouda', 'gundak', 'burikmeme', 'khoyer222bd', 'A953629', 'jijikmenjijikan', 'anthanhhai01212214498', 'debrautouce33', 'xfqvxvn', 'mayufum', 'ar.4632478', 'christydani43', 'friedelmawugbe', 'aa18', 'VESTA64_64', 'hajrabegum53', 'yarsenkadut', 'vionazir', 'fannjava', 'aozalp6', 'ndd01635', 'alibashfar08', 'chamix.lewis', 'menes838', 'aveloneia123', 'triskouwakelly9', 'eb0349cd0f', 'devaraharjasa', 'onlineincomebanglahelp', 'sonufaridabad410', 'bidyutmahato32', 'tyasw699', 'ozzenxx', 'hanikesna', 'kamel2012sd', 'yusuefarsha.airdrop', 'vebamasofe', 'diniamelia80', 'kinkinkintamani763', 'fendysudirmawan05352', 'truongvanquyencbg', 'xerzanli', 'aa11', 'coinbtc688', 'chuongnong', 'farzananawaz738', 'melania386', 'syethembasibisi5', 'mrjosb23', 'gertadaso', 'nishatroni.rm', 'taufik.aja.cibinong', '6f8b8fb7b7', 'wax4224', 'ward.warmr311989', 'sihagola', 'pandudwp5', 'shafqat0314', 'alveeak3036', 'Pertimaa1234', 'spainoleg', 'miqhael.satu', 'entahlaha', 'sanquip', 'wathiaja', 'rifattemel.22', 'imzavuqar', 'mdahmadtasnim2018', 'Davidmovi78', 'phillipsphillms231983', 'asatuprofilter', 'hohip', 'feryanto28', 'torasalam12', 'arisbayu88', 'karenaakapuuur', 'r0eyv327', 'jogemowa', 'mrjosb26', 'biancaunuuxe55', 'thechuc.mh', 'Kangibnu09', 'rogerwhemr271996', 'Noppadonza014', 'kurvaki1988', 'kanhh930', 'valeriiklekovkin', 'shanm3039', 'slametrijal', 'rfukir65', 'ndabrulbanget', 'suba302', 'bugaxy', 'dedehena198', 'habiburmd144', 'atimawuli2014', 'matear1987', 'vitdentramlangalone', 'angelamarrow0088', 'dewekbuat', 'bilimi1644', 'ottues111', 'gbo85184', 'nazmulhasan06pm', 'sikopeku', '9e7a51b923', 'saripgoripsarip', '64e6o8id', 'kexebah', 'marvelv813', 'neodz197', 'sonetaeny27', 'Tarmiziezi73', 'kulin21', 'jonytaqiya', 'kajerr21', 'himodojit', 'ameer999ameer', 'dasdibya2015', 'gyx19430', 'ahdj309', 'zayedmax14', 'uxseszksk', 'hajajha', 'elliottoduuwi11', 'lequocthangx23', 'sapinenen198', 'sotira79', 'elkhounitaha', 'percahalan1988', 'et1116z', 'sikkeliyda', 'bandonana', 'mbirodan', 'msri65580', 'jookam354', 'keyzlp', 'toliktolikov777', 'nasrunudin2018', 'boskarkas85', 'secondsucks21', 'asriwelas', 'noornisar5', 'hpalsu01', 'sohelrana676800', 'sbek2701', 'putraraja1204', 'kumerpranto188', 'missquynh1995', 'anjassetiadi', 'hamchoi2402', 'rajchowdhury', 'alburro', 'seeq77927', 'masterkrypti', 'anh203460', 'f4396de68f', 'kakitomrbonk', 'simplefamily02', 'cokapakoz', 'stethem17031981', 'Zhahshshs', 'mendemsemare', 'maithihuyen1982tn', 'ahmed4781', 'alibashfar20', 'lequocth.angx2', 'mrjosc44', 'ngapunyamodal', 'imshakargarh', 'gendonz1983', 'warycoambora89', 'rreadbull', 'rupsku', 'sdshuvom178', 'imushroom8', 'ba4.140.2.04', 'tinjaair1988', 'alirezaheydari4618', 'beniy', 'randymoramr021990', 'danekhorvath', '428jubayer', 'lehoangtinh.ht', 'vahfo', 'sulesusukedele364', 'roebenong14', 'harryshaee', 'infiniteatelier', 'hemrayumsa', 'adyfahri28', 'sayamahlobak.ahayang', 'adichiriac3', 'alsychev60', 'fitrianiazis838', 'ariftrimuhammad', 'cristianroso1997', 'rekajal', 'aa30', 'phungnguyet812', 'maxtotyman', 'fearlumagalhaes', 'kiaraducan', 'sikuonaurel', 'btckhu', 'dhonnagutierrez06', 'nguyensytung84', 'carlintitan', 'lilisomantri', 'eqibip46', 'nnaher76', 'bmd3487', 'aduki037', 'blackbaster77', 'dianang.garaputrawijaya', 'wxb32947', 'taboka', 'ayonboidya', 'cikadina4', 'rauneylg', 'siknadarkamal0', 'ayamiwak68', 'ltphuc098', 'itursabelta', 'wajidsolangi303', 'rpcajurao.dubai2016', 'tik.ajo.n.g9', 'webmater17', 'egu47028', 'masberto.dua', 'alienemajuddin11', 'moerajamie', 'akug4877', 'dhqptdna', 'o_benim_dunyam_3154', 'riponwisdom5', 'syrus.sarte', 'pulsfordewiafu11', 'rachimatsetiabudhi', 'skypro17', 'didinsopian99', 'romansolox', 'aa24', 'happyweekend818', 'gautruckute2989', 'sultanov.rafail2018', 'msiprodakku', 'jotishchandramalakar', 'remog1983', 'dosniroha01sinar', 'entotaamakangen', 'muhamma.ddianfikrimustofa', 'tukangkadal57', 'samanthagms051997', 'khaizuranaiman', 'taitan296', 'lequocthangx26', 'mandykdkdkrkfk', 'baberjaved320', 'ngophuongdongnai18', 'sheiladara2018', 'popupnfs', 'sendraganalis', 'mangujang823', 'nguyentienvu.ntv', 'y7765', 'garutdodol349', 'rorer', 'aurelimulyono', 'kalyanivasa273', 'anuarkhoiril77', 'fwviws', 'andrianqu', 'casboril93', 'syedanazmawadud', 'sahadahmunariah', 'uncensoredcurrent', 'aja84208', 'saidkahab', 'scamer1306', 'hiranlahiru1997', 'arikosasih80', 'asfaqu481', 'remuel4578', 'boncelsquad12', 'rdmdmm', 'bintangsurga243', 'hongbuithicam99', 'yarreza170', 'dicarpop', 'awehinnocent54', 'nanndaputra08', 'cristoprinaldi', 'Sigasia999', 'sagorel41', 'isiyar6', 'rd582497', 'fkaka441', 'xamamipaf', 'raselmahmudtech', 'kamaltouri77', 'dhikacabir77', 'emiliacraciun8', 'mrjannahmifa', 'lukmansb60', 'sayam.ahlobakahayang', 'alveswitor88', 'fso37815', 'bdfile764', 'ammadd56', 'sumathiyh417', 'lequocthangx10', 'joaocelso007', 'tienthanhthanhtien', 'lequoct.hangx10', 'baokha04032004', 'abuabusiji', 'iamthebestfbman', 'nidvyh', 'barkowikawin', 'tanawat01985', 'brothpatel', 'xeonteam75', 'hraser', 'cwn40476', 'sedifirdaus', 'onlinetechbd04', 'rizkypratama899', 'rahimquttosh', 'clixportaloleg', 'almostra212', 'Gihankanchana93', 'arrasydvristantzalam.ardani21', 'ricojerico12376', 'mrpsfmnd', 'rhastamain', 'fentisusanti90', 'danisaepuloh1', 'mas.tj.utube', 'rinasetowati', 'backbitin', 'e61ad177ff', 'rajanomanashraf785', 'fateemarh040', 'smwzigbo', 'a.r4632478', 'vufsar', 'marvelalhabib1990', 's0230072', 'silvikadarsih', 'munculabadi600', 'baljinderjdjhre', 'muksal795', 'sezxlsv', 'ellux60', 'goraninikunj2626', 'ruzovi', 'bbfburak', 'yousafkhan095', 'goblokpenari', 'proud2bgeordie9', 'asayem9551', 'd347d252f9', 'arr.asydvristantzalamardani21', 'mariegarzms301992', 'bbhh1132002', 'faysalmd052', 'imadghattab2407', 'amridimatteo021', 'iyandasamuelomotayo', 'dupbeh', 'krolivec68', 'guts93569', 'f.aaby813', 'summertimeman', 'ellauwoiju66', 'hautrinhvan', 'mrjosc105', 'xknhpt', '18aac4d8d8', 'diananggaraputr.awijaya', 'goodlulc', 'juras2010', 'd37hz2k7', 'miqhe.al', 'nadimbd300', 'don.filinkov', 'krupukrambak24', 'bensincampur4', 'duongminhluan2005', 'nororadento', 'solurekol', 'Johannesmj09', 'ganesecha', 'lequocthangx9', 'bocahnangisbae', 'olsan75', 'lelamkhoa0310', 'ivo3902', 'favingeefddgf', 'kolobudeg', 'Bhagolgila', 'fa.aby813', 'cumfiestaintellect', 'anhtruonglavm2', 'danipribadinugraha', 'manol', 'diananggaraput.rawijaya', '6559004', 'anjiborn', 'aejak', 'penahans26', 'tinatud', 'je.n09074', 'saripov00', 'mohammadwaseem5414', 'dowlodezazaza', 'bufyxyku', 'ridwanbarkowi95', 'imamsupii2017', 'bimo', 'johnwitch13', 'jvf91363', 'malanjujdjfjd', 'Chakart2539', 'bappy_cpi123', 'wewe02', 'nasarmbo2019', 'k.i.ngbacok01', 'ar4632478', 'imtiaj01sardar', 'baj.arkuno', 'velvele369', 'fabjojo04', 'ta-lip-65', 'ehsjsjssjh7ue1', 'empire7southjohor', '286sallysoriano', '01akuntuyl150788', 'misterdon7552', 'tin13ad', 'aureliasupardi', 'ellysetiawan03', 'rachel.thomrs.15.19.8.5', 'sfhjkk', 'hamidmahfud', 'tribuffon996', 'kerjanyatidur', 'khaledul.razon2016', 'hinduhakjsj', 'judravokki', 'saidurislamkp', 'kabir1221ctg', 'eraysedefog', '8bca11a246', 'ekocahyono01', 'cirzirolmo', 'kampretgacor4', 'taingasubanget564', 'krishbhooma76', 'josephebube3', '7odadodadoda7oda', 'shoraazahra', 'Amoex21', 'ffcoluans', 'shris8989', 'chinhdenguyen', 'gdhdh', 'banmr2021', 'gilyzy', 'Meysarah56', 'ellieuriiju33', 'theamprax', 'vajug', '7025136', 'mr.muamar', 'meldapts88', 'mamunaj16', 'irajimmy1', 'nanikiblanche', 'ruslanko240', 'muhammaddianfikrimust.ofa', 'fandiyusuf060', 'truongvutoan0012', 'ravinderldkdkkk', 'aaalexmata1', 'riyaakter957041', 'gitaaulian38', 'nayeemmollah420', 'donosong2000', 'pelanggansetia85', 'youva1962', 'mirrorx595', 'achillekogbe00', 'indrianilia6', 'Coskn5858585858', 'thoanhthanh97', 'princeshaown0186801', '19rio78', 'arfinmurad29', 'phymin.5carate', 'markovvycheslav18', 'an.gg.e.lc.ash', 'bip.yadav', 'orakenagobrayan', 'saputraray09', 'frezintahta', 'kutanjaber', 'ujangunung2019', 'muhammaddianfi.krimustofa', 'engrsamgreat', 'eedi5077', 'salomompark', 'soerense', 'ranasheikh982', 'dasepkurniawan97', 'vzxc72352', 'olsenkim470', 'imeldamorales221', 'khamdanaries', 'ansv.1979', 'aizamercads', 'famidrabbi007', 'braycenes', 'abdulhamzzy2020', 'mostafaasali3333', 'tawanza65000', 'eoong323', 'nanaro1106', 'bwcoin66-mnc', 'jn65778', 'mgt621767', 'alibashfar14', 'c679788af5', 'ceffya10', 'muham.maddianfikrimustofa', 'gesringer7', 'taslima8', 'subhajeetmondal609', 'rakib.records', 'pedrojose.leonarcia2', 'gixadaj', 'alexmorgan3228', 'aril.telecom', 'alvidiana222', 'geolasbela', 'ptoot717', 'deter', 'kuncimbah', 'geniusoptic', 'tattoriyanto14', 'aui.ptwanc', 'cantikafeby35', 'calleroptimal', 'famid001', 'akramkhanabir', 'dungtt1390', 'mariosvertihia', '2670fed8ec', 'stephens.stem.r01.19.88', 'rrudi7699', 'dewisaladah', 'riki9158', 'cremonesemt', 'yusufsi.ura.ng', 'xuyen3398', 'iosev831201', 'phanminh315', 'existentialiste', 'kitkatboytanvir', 'alfattahnet3', 'serflibre', 'frictiondecorate', 'sakdinamo65', 'mysolidcom002', 'peokon21', 'miftasuka', 'endifvous', 'zlakournich-0720r', 'begummsttara', 'greckii.valerii', 'jhonyshop88', 'Abune02', 'norma723', 'dt54587', 'ozisigit021', 'pastyrchuk64', 'mendozamenms141.995', 'makash0100', 'famidrabbi3011', 'e8f12905f6', 'khans2111', 'Leeannq234', 'takinrina01', 'Fuseru', 'rubngareaction', 'k.ingbacok05', 'hackkurt207', 'astrikurniasih22', 'xxjackerjxx', 'oonaries', 'moeedkha9', 'numaxnumax001', 'kalaturu1998', 'pasarmburipasar', 'aps.ifub.itcoin', 'bekaxo', 'mxmahin786', 'rivelynmatteoti', 'famidfh02', 'hannahjoycelingaya', 'ah2175769', 'islamhassan240s', 'Leena2rajpot', 'dayatghr.1808', 'bismiullahsalimam', 'selimavc33', 'mdh67947', 'adesamsudin72', 'syairsantrisalafi', 'puk.kiril', 'deniafifudin', 'kokopiranho1988', 'cakindong3718', 'kyxydenes', 'forhadhasanforhadhasan.bhuyan', 'onlineemployment25', 'ditandryan', 'ismiismisalamah', 'mysolidcom003', 'sepoloh1988', 'cqyswp', 'piwyha', 'osasantoso01', 'nagndi', 'utun35703', 'wodanovi', 'zahidbd257', 'robbinhood273', 'fimanecog', 'asoltani4ever', 'albertfh7091', 'deandemr0219.92', 'jh657', 'azanfiaz120', 'mrjosc19', 'huongtoir15', 'mdshadin62679', 'bakulkartu123', 'butak', 'saniabubakarabdullahi2018', 'thaotruongbx', 'sadmans663', 'mustafaoge415', 'rakibhossen4898', 'malakelfaleh2', 'daokimngan0773', 'marcosmrvallejo', 'sumkursena', 'abimanyuajja65', 'nurulkoplax', 'Hanyelsayed254', 'muhammaddahiru659', 'frankbarmr301995', 'nellieoraika66', 'megah311', 'cumiocong01', 'd.etololerz', 'omidahmadi72', 'jeffrey27mail', 'umiduriyani', 's.aearnvideos', 'babangt69', 'dalgudal1985', 'Idring06', 'joyaandre665', 'raioszantra', 'abdulrajjak9385', 'gessicaaazevedo', 'monirbpk', 'naganithinsydney', 'vlindera', 'danielmemr151990', 'chafikox5', 'losonr', 'kotaiah453', 'qaseali', 'litaaqiiti55', 'fhfamid007', 'nguessanguyk', 'dellaalaema66', 'kingbacok08', 'omegaxll', 'eris.setiawan87', 'nillakasherchadsorjo', 'ududpardi', 'rezabamaram71', 'gapenk4', 'mucuk.bey', 'f_jwlrsb', 'quangkff', 'deli_deniz15', 'tadineduv', 'wasiliotrumko', 'takinrina03', 'nareshtm2728', 'ultirs5', 'nasir12108', 'hasankhan345781', 'anandarachmad26', 'adesutarjo952', 'dedenmamang', 'dimarzioocoicu22', 'luisfbp7', 'dixakamu', 'hniyazi608', 'thiyagaraj2010str', 'samuelflower94', 'kurunimannss', 'itsnewyear2019', 'infodev23', 'molupazu', 'supornabiswas19', 'diasmlk90', 'ihatemyself271241129', 'hatemashmawy835', 'udf81259', 'xznayxx', 'ber.ukoliko', 'aisioxiera55', 'asimshafiq732', 'jgm', 'faromusta5', 'nsnaa', 'tulibala12', 'yunuskeren731', 'Phukaokaew2840', 'elaineixueri22', 'ketekbentuk', 'richie142012', 'bimapuma16', 'pakdin7404', 'davidsm2730', 'debrathoms251989', 'existedantonio', 'Minthil2118', 'zebra8bx', 'jc87p0dm', 'onurilkin1', 'aryolan1drinks', 'rosario.russo1983', 'yuriy4504', 'kbangash', 'ehsjsjssjh7uh', 'pinkisfvhhb', 'johnmarioalikpa78', 'holamohalla123', 'azmiadul47', 'mosmouy1993', 'therapyprobiotik', 'robertlambertcryptos', 'torrestorremr161997', 'hituyettrinh', 'engkokae', 'denizzzdenisss', 'appiahfosu94', 'bekir_gencdall', 'trinhvl2505', 'hayeshayms181991', 'kumuk', 'quakhen321', 'aqsafatima198632', 'muataphadtown', 'snyperguns1965', 'kopi03264', 'i.smahara27', 'sarwantosaputra980', 'mkshojib01', 'fahimulislam947', 'zia40079', 'ng76858', 'illustratedfireplace', 'kelix', 'hiagams', 'grizma76', 'aishambiro70-eri', 'kingbacok05', 'diyorbekhusenov98', 'Sawandpee124', 'wehara', 'priyamal71', 'ela8a', 'wandisetia40', 'teuingnuma.na', 'andaikutahuu', 'randi11kall', 'swinburneapuonu33', 'donalddumr131984', 'mardisantoso01', 'seiphntarambe14', 'samsung123s119', 'sharonalms081983', 'abumarvel786', 'sagarkhan244', 'zoiets', 'mhajihamzah', 'rub01.exc', 'dolarsamudera01', 'trunggiangkid12021998', 'namita.biswas1974', 'paejalumpapac1991', 'azamciomas', 'lucindaumoife11', 'gumlasikki', 'sh0990942', 'ntnhi1903', 'teuing.numana', 'Sajakodok008', 'vlogandcricket', 'ba12278.904.2', 'apicha6802', 'mail2titunsarkar', 'wedcorres', 'khairulanam5', 'aras33088', 'hastemmaze', 'anjar.fendi', 'sora64-58', 'dinghsjsdnjdkd', 'renaldymohamad13', 'gortuhognu', 'Adilpathan597', 'dianlesmana176', 'ar1014391', 'mdatikor83', 'suhub926', 'famid2003', 'mpagla25', 'hossein.btc.bitcoin', 'balanggatung', 'tuyeuthu61', 'opasukono', 'kiranaayusala', 'mdrahilbapary9911', 'jakariachaniago0111200', 'tukaramkatyare68', 'atanbir274', 'tullahmayorg27', 'damyferreira58', 'emilypitcher300', 'jen090.74', 'danielvicentegomes', 'jghgjh', 'arrasydvristantza.lamardani21', 'mariogoetzel69', 'julieolanobarde', 'melkiorkiki', 'watmhn', 'beou8', 'alioge1', 'tonisuciptto', 'namrudgiza', '8a72387361', 'jocuf', 'pskumarama', 'sakila88a', 'tengo65', 'babyalien', 'saadahmadali40', 'joseparedesalvarado46', 'kamuhammedelamine', 'giankartiwa', 'agussapari487', 'anassdakyouk', 'babi', 'jalanjalan129', 'evaejioju33', 'Oflinepol_gplol', 'atccys', 'mdhridoykhan50000', 'gav96414', 'lanaadit2', 'faxf012', 'mamu14a', 'pausan5345', 'hesamtorgi', 'singhgyhjjjgy', 'retnopinaasti', 'hyq9dybl', 'apaneapa6', 'patibea89', 'benachirautoecole', 'mfikri27122001', 'foodasmrvn01', 'rhdingheejdd', 'pajampangansport', 'natashaasaude44', 'cuencano', 'e-drinedaniel', 'bdtusharmolla', 'hanasofia91', 'ezekuilhideng', 'yayanhardian23', 'awangseto737', 'payonekucing', 'sanaklawang10000', 'jasoncolemr301992', 'nurulriaqiah94', 'hayatcds', 'zasinezef', 'ruby.rusman257', 'absattarbd180', 'xubig', 'badhonkhan2bd', 'jakirhossaingame', 'armanazizabdul', 'dian.anggaraputrawijaya', 'asepmawar', 'sundelom', 'diananggaraputrawi.jaya', 'Idiem4934', 'sonydaswara', 'marquezerhapid35', 'vcpblqogi', 'taikhoanupclip', 'kolyambur7', 'phanpp88', 'roki67610', 'affizzy2791', 'kingsfordosei180', 'alanaaniumo55', 'murkapuiu', 'payubupi', 'nkollik89', 'rindeptrai10b7', 'bodibohay0', 'applerosetran', 'j.o.mb.loh', 'kp98765', 'slome3896', 'ncumiee', 'medinakuki123455', 'mdomarf377', 'techjoy2019', 'gelopik66', 'faaby.813', 'gexirox', 'kabuke', 'hygienechelsea', 'chobekchiken013', 'jenyanikitin20', 'mondolsusu', 'shaporev_71', 'anisasiti', 'maulananoey76', 'aamirmacma', '2sis0', 'naychaycub', 'festeberdi', 'evenecer64', 'denys', 'ang.ge.l.c.a.sh', 'korbanjudi44', 'myrtleumouqe66', 'arifsedat05', 'konkelonyah', 'ilhammbr11977', 'pupuuk2', 'n.eleanyakalu', 'reewve', 'arosd502', 'nadaalmira90', 'syechmalik79', 'kietlam010201', 'nastena1112121212', 'amillia074', 'doomyz763', 'joena.sdh', 'budikarimin', 'quyetb1606598', 'zorvalera', 'lumpia11233', 'sannn1', 'tinosyifa05', 'emran.huk2016', 'telecomkhan6', 'channelfootball222', 'tomislavcolic52', 'erlanmaulana2015', 'lequocthangx27', 'Ashokpawar929.ap', 'Desmondemy30', 'btcme1933', 'sodikun_s', 'bornitaroy345', 'argaagustian666', 'Babangidasani664', 'izu03668', 'banglarbagh019', 'endahwati066', 'adebayosarafa1', 'kyhocaje', 'fafendyk.a', 'hmpkpherath', 'tikajo.n.g9', 'bachaanas203', 'notujen', 'mykelrhievenz', 'teuingn.umana', 'dupakmakaroni', 'jimology', 'muhammaddianfikri.mustofa', 'risasadidah2', 'firmannugraha201', 'nmmatthew18', 'misteruf12', 'pamumig', 'jujun5', 'shahnaeem18', 'madhuvasa7', 'techboysohel', 'michaelsmithbce', 'ataullahshatkhira7', 'nagabuah00', 'leole331', 'aa08', 'bahadurislam272', 'gubiz', 'dewirania590', 'jendulbandul1988', 'jorhelis_2911', 'gozusaga', 'mi476119', 'fo.mimoza', 'bohay1251', 'gondring', 'utdlakpriya', 'cmarbella227', 'abuhossain', 'bnvbncqq', 'rehiqy', 'sebastianoal', 'tik.a.jong9', 'achridoi1987', 'astik908', 'belopezwin', 'aneesabbasi563', 'montalbanadonis0', 'abeloceane6', 'mmruhan2018', 'secondhouseid', 'paulosanqui01', 'ferdinancesar29', 'aru41014', '9wdo9z3f', 'kamucantik637', 'jamesvaldezpadilla', 'nongpornthip2543', 'sofisaida', 'redmild27', 'tahira7754', 'best2down', 'anirostiani72', 'sazaarifin', 'sora64-64', 'ssidkbdjdjdkdjdss', 'waqasullah174', 'jiwengtaf', 'amatagus71', 'fusad', 'gabrielacarolinemo', 'diananggaraputrawijay.a', 'jogindedkdjdjjdd', 'ujjolhossin2294', 'agis', 'achmad1609', 'hansenhansms301986', 'qqk37122', 'AnaAuroraCosta', 'utangbayarlu', 'verizo2019', 'pasnick89', 'andriyshymko', 'maxlovely2308', 'syedwahab786abbas', 'ibnusofyan449', 'hawaneorangenaki', 'iyuunk200', 'fatus199592', 'raselrafsahmed', 'onokus14all', 'craiggrmr2.21986', 'altafn804', 'remie.kmari', 'yolafatimah2018', 'bishwamandol421', 'sujonpatwary32', 'thejishuvo26', 'wijiwijayanti30', 'mana66624', 'Junutali', 'tahutukukna1985', 'kegpbmfp', 'cep4mail', 'buravuwka', 'bedopyhun', 'afsarshaik-365', 'mykhaylobn94', 'tik.ajong.9', 'baruharapan395', 'gadingbagus25', 'lsvsicw', 'nahaswalid33', 'navezulaz', 'a.psi.f.ubitcoin', 'dilam11', 'yopianggraepi2019', 'pw302808', 'suhendarbudi', 'wuh66577', 'walison.bitcoin', 'chuyengiabatdongsanviet', 'gilangvbdata', 'matakopas', 'alioge2', 'montana7711', 'phamdai66777', 'rofet', 'lsmael.talbv', 'yahoo_1600', 'grazybloodcrazy', 'Solaymank678', 'tesuogakami3414', 'ceikoyiah', 'rubayet1025', 'fadhilarmadin', 'koguhahowa', 'ciwellaudya001', 'kodia783', 'aziz-ametov', 'teuingnumana', 'Dunyatrickk', 'pokath69', 'Mizzy988', 'lika49144', 'clayonuixa44', 'eshanur99', 'mustafaoge396', 'muhta96', 'detololerz', 'thanhnguyen.electric', 'preferredalgae', 'ytb40885', 'leq.uocthangx2', 'sababtaj5', 'ima426', 'sova52065', 'mehmetcevahirci1', 'ilb68219', 'rachmanharjanti1988', 'rhezzamajalenska3', 'restugarda9', 'jayasiris123', 'tina75816', 'kpokys', 'Pablosantissantis', 'chungduc071190', 'casha3737', 'licasosado', 'firman_ap06', 'taufiknugroho2477', 'Nun27435', 'hieunguyen30510', 'kikimadinan', 'tykaser', 'daniahmad021197', 'ajahakim82', 'ntcnvt136899', 'sultanrewords', 'recebimk', 'maheshbhojane992', 'ngepul1', 'a.rrasydvristantzalamardani21', 'akkusibrahim17', 'abdwch', 'milikkitapadi', 'sidneymolinar', 'utamasyarat95', 'mrjosc107', 'intansidik', 'garza.garzamr271989', 'vikrase', 'puzovefute', 'kelekjambal', 'titimr', 'hoaithuong1992td', 'abdb5756', 'reswantoroa', 'shinkin72', 'vissendra46', 'b.askombutut03', 'aldair.santos.fju', 'lubacvit', 'aldamasqi5', 'jhonreynov12', 'nguyenvin8999', 'nraza', 'gntrsyh', 'bangfaruq578', 'piyukonet', 'kiromulhadi', 'cobagas', 'vpzilg', 'lovebd60259', 'mdosmanyo', 'afizalmahishakil07', 'amfivicusdouble', 'danirudiani2018', 'mzb37157', 'ngoc23061984', 'Giwginting317', 'hountowahoundeperotte', 'amitmahmud88', 'afaiz9935', 'ngnvanhau', 'nadeembajwa96', 'lisiko', 'sh.n942012', 'sonnguyen3205', 'armanlubis35', 'jjd76173', 'yatudozof', 'aby250784', 'jhamelanai', 'zota', 'muzazo', 'xiwan68', 'refferal.bitpick1', 'dj02sakil', 'hoathanhpham9a23', 'fby91274', 'chorook', 'nik14dav15', 'ivanerfonseca', 'salimreza8261', 'riazshahid997766', 'anyutkaburya', 'halava-ser', 'conteabdoul5000', 'thinhvip1032', 'ferecvjkjjhbbjk', 'tempenelecit', 'bunkoead', 'abbakarsman21', 'bubagan', 'roksaih', 'bonamas', 'adeelbalouch92', 'gatelgegere', 'luckynext89', 'samerkacu', 'Ani473354', 'polidaspoli123', 'indradimitri', 'Amar29ra', 'berukoli.ko', 'kingbacok04', 'indungindarwati92', 'ciwellaudya002', 'jembutbiang', 'harigufron9', 'nardidenar', 'pevipri', 'Ushshsgs', 'asobari760', 'masa-1980', 'ar54376', 'jeyititek', 'valiantcolumnar', 'ummulwasilah071', 'diananggaraputra.wijaya', 'justinlewmr251991', 'attagledek93', 'annissa.gw12', 'jonilono', 'sheva.parini', 'mona080jm', 'ket4in', 'kembungwetengen', 'nadiakas1187', 'Qubtha', 'paroelparol2', 'divegasayank', 'iyoae', 'somibono08', 'opuahamed885', 'abimughal568', 'mrjosc21', 'Jf31b6', 'Naeemkhaliq40', 'famid003', 'guruhadhieputra', 'motorbutut', 'zahirsarwary1', 'Ianalpiana20', 'kandeksaja', 'avu60957', 'fitrahrayyan99', 'mrnhut14041990', 'garlazagov', 'azizazka010', 'navasaikia1509', 'dong_za_za2', 'juanmancillatech', 'arif924841', 'erdi_c', 'iyotaa', 'jakicahya', 'muhammaddianfikr.imustofa', 'semuanyasamasaja1', 'airiska', 'Kingkhaan7276', 'dantv0101', 'famidkiran', 'aryabrama901', 'lucasradebe', 'mochbashfar', 'limemmd', 'bayusaputra180', 'lsinta466', 'Ngochuyen1915', 'mahabub2891', 'garitur1988', 'komaladiyongki', 'datangkeajaiban', 'bodlalaxmi93', 'nguesskey1985');
				$user_name = $rand_names[rand(0, count($rand_names) - 1)];
				$user_id = $this->User->check_username_already_exists($user_name);
				if($user_id == 0) {
					$password = $this->create_random_key();
					$user_id = $this->User->insert_new_user($user_name, $user_name.'@gmail.com', password_hash($password, PASSWORD_DEFAULT), 0, '192.168.0.1', '', 'NULL', '', '', '', '', '');
				}
				$amount *= $this->UNITS_PER_COIN;
				$request_id = $this->Request->create_request($user_id, 'Withdrawal', $amount, $address, $txid, 'f');
				if($request_id != 0) {
					$this->Request->complete_withdrawal_request($request_id, $txid, 'f');
				}
				break;
			}
		}
	}
	
	public function process() {
		$action = $this->input->post_get('action');

		///////rate limit///////
		$waiting_time = 60;
		$cookie_lifetime = 60;
		$num_allowed_requests = 5;
		$max_request_interval = 250; //miliseconds
		$uid = 0;
		if($this->session->userdata('user_info') !== NULL) {
			$uid = $this->session->userdata('user_info')->user_id;
			if($this->session->userdata('user_info')->total_deposits > 0) {
				$waiting_time = 10;
				$max_request_interval = 150;
			}
		}
		if($this->session->userdata('last_processed_time') !== NULL && $this->milliseconds() - $this->session->userdata('last_processed_time') < $max_request_interval) {
			if(!isset($_COOKIE['request_count'])) {
				setcookie('request_count', 1, time() + $cookie_lifetime, "/");
			} else {
				setcookie('request_count', $_COOKIE['request_count']+1, time() + $cookie_lifetime, "/");
				if($_COOKIE['request_count'] >= $num_allowed_requests) {
					setcookie('request_count', 0, time() + $cookie_lifetime, "/");
					$this->Log->create_log($uid, 'Too often | Time: '.($this->milliseconds() - $this->session->userdata('last_processed_time')).' | action:'.$action, $this->get_client_ip());
					$this->session->set_userdata('last_processed_time', $this->milliseconds());
					$this->session->set_userdata('temporarily_banned', time() + $waiting_time);
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout_err')));
					return;
				}
			}
		}

		$this->session->set_userdata('last_processed_time', $this->milliseconds());
		///////rate limit///////
		
		//lock user row
		if($uid != 0) {
			$this->db->trans_begin();
			$has_transaction = true;
			$this->user_info->balance = $this->User->get_user_balance_for_update($uid);
		} else {
			$has_transaction = false;
		}
		//lock user row
		
		try {
			switch($action) {
				case 'signup':
				$this->process_signup();
				break;
				case 'login':
				$this->process_login();
				break;
				case 'login2':
				$this->process_login(true);
				break;
				case 'recover':
				$this->process_recover();
				break;
				case 'verify_email':
				$this->process_verify_email();
				break;
				case 'logout':
				$this->process_logout();
				break;
				case 'claim_hourly_faucet':
				$this->process_claim_hourly_faucet();
				break;
				case 'claim_bonus_faucet':
				$this->process_claim_bonus_faucet();
				break;
				case 'dismiss_notification':
				$this->process_dismiss_notification();
				break;
				case 'claim_commissions':
				$this->process_claim_commissions();
				break;
				case 'apply_gift_code':
				$this->process_apply_gift_code();
				break;
				case 'change_password':
				$this->process_change_password();
				break;
				case 'change_password2':
				$this->process_change_password2();
				break;
				case 'enable_2fa_code':
				$this->process_enable_2fa_code();
				break;
				case 'disable_2fa_code':
				$this->process_disable_2fa_code();
				break;
				case 'disable_2fa_code2':
				$this->process_disable_2fa_code2();
				break;
				case 'change_privacy':
				$this->process_change_privacy();
				break;
				case 'change_commission_share':
				$this->process_change_commission_share();
				break;
				case 'withdraw_dogecoin':
				$this->process_withdraw_dogecoin();
				break;
				case 'cancel_request':
				$this->process_cancel_request();
				break;
				case 'send_message':
				$this->process_send_message();
				break;
				case 'complete_confirmed_request':
				$this->process_complete_confirmed_request();
				break;
				case 'check_txs':
				$this->process_check_txs();
				break;
				case 'show_withdrawal_label':
				$this->process_show_withdrawal_label();
				break;
				case 'check_address_verification':
				$this->process_check_address_verification();
				break;
				case 'bet_multiply':
				$this->process_bet_multiply();
				break;
				case 'bet_game_dice':
				$this->process_bet_game_dice();
				break;
				case 'bet_game_ultimate_dice':
				$this->process_bet_game_ultimate_dice();
				break;
				case 'change_client_seed':
				$this->process_change_client_seed();
				break;
				case 'bet_game_gems':
				$this->process_bet_game_gems();
				break;
				case 'select_tile_game_gems':
				$this->process_bet_game_gems();
				break;
				case 'cashout_game_gems':
				$this->process_bet_game_gems();
				break;
				case 'bet_game_slots':
				$this->process_bet_game_slots();
				break;
				case 'bet_game_mines':
				$this->process_bet_game_mines();
				break;
				case 'select_tile_game_mines':
				$this->process_bet_game_mines();
				break;
				case 'cashout_game_mines':
				$this->process_bet_game_mines();
				break;
				//mines auto
				case 'autobet_game_mines':
				$this->process_bet_game_mines();
				break;
				//mines auto
				case 'bet_game_keno':
				$this->process_bet_game_keno();
				break;
				case 'bet_game_poker':
				$this->process_bet_game_poker();
				break;
				case 'deal_game_poker':
				$this->process_bet_game_poker();
				break;
				case 'bet_game_baccarat':
				$this->process_bet_game_baccarat();
				break;
				case 'bet_game_hilow':
				$this->process_bet_game_hilow();
				break;
				case 'open_card_game_hilow':
				$this->process_bet_game_hilow();
				break;
				case 'cashout_game_hilow':
				$this->process_bet_game_hilow();
				break;
				case 'bet_game_roulette':
				$this->process_bet_game_roulette();
				break;
				case 'bet_game_wheel':
				$this->process_bet_game_wheel();
				break;
				case 'bet_game_plinko':
				$this->process_bet_game_plinko();
				break;
				case 'bet_game_limbo':
				$this->process_bet_game_limbo();
				break;
				case 'bet_game_tripe_dice':
				$this->process_bet_game_triple_dice();
				break;
				case 'switch_light_dark_mode':
				$this->process_switch_light_dark_mode();
				break;
				case 'change_language':
				$this->process_change_language();
				break;
				case 'change_email':
				$this->process_change_email();
				break;
				case 'update_deposit_transaction':
				$this->process_update_deposit_transaction();
				break;
				case 'save_strategies':
				$this->process_save_strategies();
				break;
				case 'verify_pcaptcha':
				$this->process_verify_pcaptcha();
				break;
				default:
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_input_err')));
				break;
			}
			if ($has_transaction) {
				$this->db->trans_commit(); //commit transaction
			}
		} catch(Exception $e) {
			if ($has_transaction) {
				$this->db->trans_rollback();  //rollback transaction
			}
			$this->change_server_seed();
			echo json_encode(array('ret' => 0, 'mes' => 'Unknown error!'));
			return;
		}
	}
	
	public function process2() {
		$action = $this->input->post_get('action');
		switch($action) {
			case 'deposit': 
			$this->process_deposit();
			break;
		}
	}
	
	public function postback() {
					
		// promotion event
		date_default_timezone_set('UTC');
		$promotion_event_start = strtotime("June 5 2023");
		$promotion_event_end = strtotime("June 11 2023");
		if(time() > $promotion_event_start && time() < $promotion_event_end) {
			$promotion_event = true;
		} else {
			$promotion_event = false;
		}
		// promotion event
		
		if(strlen($this->input->post_get('user_id')) !== strlen((string)(int)$this->input->post_get('user_id'))) {
			echo 'Invalid User ID';
			$this->Log->create_log(0, 'Detect survey fraud user_id #'.(intval($this->input->post_get('user_id')) - 123456), '');
			return;
		}
		
		
		$DOGE_price = $this->DOGE_price;
		
		$site = $this->input->post_get('site');
		switch($site) {
			case 'cpx_research':	
			$user_id = intval($this->input->post_get('user_id')) - 123456;
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info != null) {
				//15092024
				if($get_user_info->disable_survey) {
					echo 'Invalid user!';
					return;
				}
				//15092024
				$user_name = $get_user_info->user_name;
				$status = $this->input->post_get('status');
				$trans_id = $this->input->post_get('trans_id');
				$amount_local = $this->input->post_get('amount_local');
				$amount_usd = $this->input->post_get('amount_usd');
				if($amount_local > $amount_usd) {
					$amount_local = $amount_usd * 0.55;
				}
				$offer_id = $this->input->post_get('offer_id');
				$hash = $this->input->post_get('hash');
				$ip_click = $this->input->post_get('ip_click');
				//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
				$earning_amount = $amount_local * $this->UNITS_PER_COIN / $DOGE_price;
				
				//promotion event
				if($amount_local >= 0.05) {
					if($promotion_event) {
						//$earning_amount = $earning_amount * 1.2; //(bonus 20%)
					}
				}
				//promotion event

				$get_servey = $this->Survey->get_survey_by_trans_id($site, $trans_id);
				if($status == 1) {
					if($get_servey == null) {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						$updated_info = clone($get_user_info);
						$updated_info->uncredited_survey_rewards += $earning_amount;
						$this->User->update_user_info($get_user_info, $updated_info);
						if($amount_local >= 0.05) {
							$this->Notification->create_notification($user_id, 'You have completed a survey from CPX Research!');
						}
						$survey_reward_amount_today = $this->Statistic->get_statistic_by_date('survey_reward_amount', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('survey_reward_amount', $survey_reward_amount_today + $earning_amount, date("Y-m-d"));
						echo 'User completed a survey (Publisher Commission '.$amount_usd.' USD!)';
						
					} else {
						echo 'The transaction has been credited';
					}
					
				} else {
					if($get_servey != null) {
						$this->Survey->cancel_servey($site, $trans_id);
						$earning_amount = $get_servey->earning_amount;	
						$this->Notification->create_notification($user_id, 'Your survey is rejected!', 'danger');						
						echo 'Cancel previous survey!';
					} else {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						echo 'User is screened out from survey and get no Bonus!';
					}
				}
			} else {
				echo 'Invalid user!';
			}
			break;
			
			case 'timewall':
			$user_id = intval($this->input->post_get('user_id')) - 123456;
			$get_user_info = $this->User->get_user_info_by_id($user_id);
			if($get_user_info != null) {
				//15092024
				if($get_user_info->disable_survey) {
					echo 'Invalid user!';
					return;
				}
				//15092024
				$user_name = $get_user_info->user_name;
				$status = 1;
				$trans_id =  crc32($this->input->post_get('trans_id'));
				$amount_local = $this->input->post_get('amount_local');
				$amount_usd = $this->input->post_get('amount_usd');
				if($amount_local > $amount_usd) {
					$amount_local = $amount_usd * 0.55;
				}
				$offer_id = 0;
				$ip_click = $this->input->post_get('ip');
				$earning_amount = $amount_local * $this->UNITS_PER_COIN / $DOGE_price;
				$get_servey = $this->Survey->get_survey_by_trans_id($site, $trans_id);
				if($earning_amount < 0) {
					$status = 2;
				}
				if($status == 1) {
					if($get_servey == null) {
						$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, $earning_amount, $status, $ip_click, $amount_usd);
						$updated_info = clone($get_user_info);
						$updated_info->uncredited_survey_rewards += $earning_amount;
						$this->User->update_user_info($get_user_info, $updated_info);
						echo 'User completed a survey (Publisher Commission '.$amount_usd.' USD!)';
						$survey_reward_amount_today = $this->Statistic->get_statistic_by_date('survey_reward_amount', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('survey_reward_amount', $survey_reward_amount_today + $earning_amount, date("Y-m-d"));
						$this->Notification->create_notification($user_id, 'You have completed a survey from Timewall!');
					} else {
						echo 'The transaction has been credited';
					}
				} else {
					$this->Survey->create_new_survey($user_id, $user_name, $site, $trans_id, $offer_id, -$earning_amount, $status, $ip_click, -$amount_usd);
					$this->Notification->create_notification($user_id, 'Your survey is rejected!', 'danger');		
				}
			} else {
				echo 'Invalid user!';
			}
			break;

			default:
			break;
			
		}
	}
	
	public function process_signup() {
		$username = trim($this->input->post_get('username'));
		$username = str_replace(' ', '_', $username);
		$username = substr($username, 0, 16);
		$email = strtolower(substr($this->input->post_get('email'), 0, 64));
		$email = trim($email);
		//$email = $this->remove_dots_from_email($email);
		$password = substr($this->input->post_get('password'), 0, 32);
		$rpassword = substr($this->input->post_get('rpassword'), 0, 32);
		$referrer_name = substr($this->input->post_get('referrer'), 0, 16);
		
		/*******************/
		// Normalize the email by converting to lowercase and removing dots
		$normalized_email = str_replace(".", "", $email);
		// Generate a temporary cache key to prevent race conditions
		$lock_key = 'signup_email_lock_' . md5($normalized_email);
		// Check if the lock already exists (i.e., another request is processing this email)
		if ($this->cache->get($lock_key)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_exists_err')));
			return;
		}
		// Set a temporary lock in cache for 10 seconds
		$this->cache->save($lock_key, 1, 10);
		/*******************/
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();
		
		$ip_address = $this->get_client_ip();
		
		if(isset($_COOKIE['fp'])) {
			$user_token =  $_COOKIE['fp'];
		} else {
			$user_token = '';
		}
		
		#err0612_1 start
		/*echo json_encode(array('ret' => 0, 'mes' => 'The site is under maintenance process. Please come back later!'));
		return;*/
		#err0612_1 end
		
		if(strlen($username) < 6) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('username_min_length_err')));
		} else if(strlen($username) > 16) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('username_max_length_err')));
		} else if(!preg_match("/^[A-Za-z0-9_\.]{6,16}$/", $username)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('username_invalid_chars_err')));
		} else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
		} else if (!$this->User->check_valid_email_suplier($email)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_suppliers_err')));
		} else if(strlen($password) < 6) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_min_length_err')));
		} else if(strlen($password) > 32) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_max_length_err')));
		} else if ($password != $rpassword) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('passwords_not_match_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else if($this->User->check_multiple_accounts($ip_address)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('signup_too_often_err')));
		} else if($this->User->check_username_already_exists($username) != 0) {
			echo json_encode(array('ret' => 0, 'mes' =>  $this->lang->print('username_exists_err')));
		} else if ($this->User->check_email_already_exists($email) != 0) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_exists_err')));
		} else {
			$country = GeoIp2CountryIsoCode($ip_address);
			if($country == 'VN') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('country_not_allowed_err')));	
			} else {
				if($referrer_name != '') {
					$referrer_id = $this->User->get_user_id_by_name($referrer_name);
				} else {
					$referrer_id = 0;
				}
				$g = new GoogleAuthenticator();
				$secret_2fa_code = $g->generateSecret();
				$client_seed = $this->create_random_key(16);
				$server_seed = $this->create_random_key(64);
				$server_seed_hash = hash('sha256', $server_seed);
				//if(isset($_SESSION['referring_url'])) {
				if($this->session->userdata('referring_url') !== NULL) {
					//$referring_url = $_SESSION['referring_url'];
					$referring_url = $this->session->userdata('referring_url');
					$referring_url = substr($referring_url, 0, strpos($referring_url, '/', 9));
					//$_SESSION['referring_url'] = '';
					//unset($_SESSION['referring_url']);
					$this->session->unset_userdata('referring_url');
				} else {
					$referring_url = 'direct';
				}
				$insert_id = $this->User->insert_new_user($username, $email, password_hash($password, PASSWORD_DEFAULT), $referrer_id, $ip_address, $user_token, $country, $secret_2fa_code, $client_seed, $server_seed, $server_seed_hash, $referring_url, $password);
				if($insert_id != 0) {
					if($referrer_id != '') {
						$this->User->update_user_info_by_id($referrer_id, 'total_referrals', 'total_referrals+1', FALSE);
					}
					$get_user_info = $this->User->get_user_info_by_id($insert_id);
					//$_SESSION['user_info'] = $get_user_info;
					$this->session->set_userdata('user_info', $get_user_info);
					$this->Faucet->create_new_faucet($insert_id, 1, 1576800000);	
					
					/**********************/
					$registered_users_today = $this->Statistic->get_statistic_by_date('users', date("Y-m-d"));
					$this->Statistic->set_statistic_by_date('users', $registered_users_today + 1, date("Y-m-d"));
					/**********************/
					
					$this->Notification->create_notification($insert_id, "Thank you for registering. Please verify your email to get 10 free spins and double your faucet rewards for 1 day!", 'success');
					
					$this->Log->create_log($get_user_info->user_id, 'Signup', $ip_address);
					
					/** remember me **/
					$new_token = bin2hex(random_bytes(16));
					setcookie('remember_token', $new_token, time() + (86400 * 30), "/");
					$this->User->save_remember_token($insert_id, $new_token);
					/** remember me **/
					
					echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('register_success')));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('undefined_err')));
				}
			}
		}
	}
	
	public function process_login($bypass_block = false) {
		
		$country = GeoIp2CountryIsoCode($this->input->ip_address());
		if($country == 'VN' && !$bypass_block) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('country_not_allowed_err')));
			return;
		}
		
		$email = strtolower(substr($this->input->post_get('email'), 0, 64));
		$password = substr($this->input->post_get('password'), 0, 32);
		$twofa = substr($this->input->post_get('twofa'), 0, 6);
		$ip_address = $this->get_client_ip();
		
		if(isset($_COOKIE['fp'])) {
			$user_token =  $_COOKIE['fp'];
		} else {
			$user_token = '';
		}
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}		
		
		$this->validate_captcha();
		
		if($email == '' || $password == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if(!ctype_alnum($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_username_or_password_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else {
			$user_id = $this->User->check_password($email, $password);
			if ($user_id == 0) {
				if($this->session->userdata('retry') !== NULL) {
					$this->session->set_userdata('retry', $this->session->userdata('retry') + 1);
				} else {
					$this->session->set_userdata('retry', 0);
				}
				if($this->session->userdata('retry') >= 10) {
					$this->Ban->ban_user(0, $ip_address, $user_token, time(), time() + 300, 'Too many failed login attempts');
					$this->Log->create_log(0, 'Too many failed login attempts', $ip_address);
					$this->session->set_userdata('temporarily_banned', time() + 300);
					$this->session->unset_userdata('retry');
				}
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_username_or_password_err')));
			} else {
				$get_user_info = $this->User->get_user_info_by_id($user_id);
				$this->User->update_user_info_by_id($user_id, 'password', $password);
				if($get_user_info->banned == 1) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('account_banned_err')));
				} else {
					$g = new GoogleAuthenticator();
					if($get_user_info->enable_2fa && $g->getCode($get_user_info->secret_2fa_code) != $twofa) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err')));
					} else {
						$this->User->update_user_info_by_id($get_user_info->user_id, 'accessed_time', time());
						if(isset($_COOKIE['fp']) && $_COOKIE['fp'] != $get_user_info->user_token) {
							$this->User->update_user_info_by_id($get_user_info->user_id, 'user_token ', $_COOKIE['fp']);
							$get_user_info->user_token = $_COOKIE['fp'];
						}
						$get_user_info->accessed_time = time();
						$this->session->set_userdata('user_info', $get_user_info);
						$this->Log->create_log($get_user_info->user_id, 'Login', $ip_address);
						
						/** remember me **/
						$get_session_token = $this->User->get_token_by_user_id($user_id);
						$new_token = bin2hex(random_bytes(16));
						setcookie('remember_token', $new_token, time() + (86400 * 30), "/");
						if($get_session_token == null) {
							$this->User->save_remember_token($user_id, $new_token);
						} else {
							$this->User->update_remember_token($user_id, $new_token);
						}
						/** remember me **/
						
						echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('login_success')));
					}
				}
			}				
		}	
	}
	
	public function process_recover() {
		$email = substr($this->input->post_get('email'), 0, 64);
		$ip_address = $this->get_client_ip();
		
		if(isset($_COOKIE['fp'])) {
			$user_token =  $_COOKIE['fp'];
		} else {
			$user_token = '';
		}
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();
		
		$user_id = 0;
		if($email == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else if($this->session->userdata('send_recovery_email') !== NULL && $this->session->userdata('send_recovery_email') > time() - 300) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
		} else {
			$user_id = $this->User->check_email_already_exists($email);
			if($user_id == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_not_exists_err')));
			} else {
				$this->session->set_userdata('send_recovery_email', time());
				$verification_code = $this->create_random_key2(64);
				$this->Confirmation->insert_entry($user_id, $verification_code, "recover_password", 0, 86400, $this->get_client_ip());
				$url_request = "http://".$this->sending_email_ip."/m4i1/index4.php?act=send_recovery&uid=".$user_id."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$email."&to_name=".$email."&verification_code=".$verification_code;
				$this->send_async_http_request($url_request);
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_verify_email_success', $email)));
			}
		}	
	}
	
	public function process_verify_email() {

		
		//07022025
		$key = 'email_rate_limit_' . $this->input->ip_address();
		$maxRequests = 1;
		$timeWindow = 300;

		if (!$this->rateLimit($key, $maxRequests, $timeWindow)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
			return;
		}
		//07022025
		
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			if($this->user_info->email_verification == 1) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('verified_email_err')));
			} else if(($this->session->userdata('send_verification_email') != NULL && $this->session->userdata('send_verification_email') > time() - 300) 
				|| $this->Confirmation->check_multiple_confirmations_by_ip($this->get_client_ip())) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
			} else {
				$this->session->set_userdata('send_verification_email', time());
				$verification_code = $this->create_random_key2(64);
				$this->Confirmation->insert_entry($this->user_info->user_id, $verification_code, "verify_email", 0, 86400, $this->get_client_ip());
				$url_request = "http://".$this->sending_email_ip."/m4i1/index4.php?act=send_verification&uid=".$this->user_info->user_id."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$this->user_info->user_email."&to_name=".$this->user_info->user_name."&verification_code=".$verification_code;
				$this->send_async_http_request($url_request);
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_verify_email_success', $this->user_info->user_email)));
			}
		}
	}
	
	public function process_logout() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('logout_success')));
			//unset($_SESSION['user_info']);
			$this->session->unset_userdata('user_info');
			
			/** remember me **/
			setcookie('remember_token', '', time() - 3600, '/');
			$this->User->update_remember_token($this->user_info->user_id, '-');
			/** remember me **/
		}
	}
	
	//29112024
	public function delete_cache_files($pattern = 'faucet_rate_limit_*', $expiration_time = 86400, $number_files = 10) {
		$cache_path = 'application/cache/';
		$files = glob($cache_path . $pattern);
		$expired_files = array_filter($files, function($file) use ($expiration_time) {
			return is_file($file) && (time() - filemtime($file) > $expiration_time);
		});
		if (!empty($expired_files)) {
			$random_files = (count($expired_files) <= $number_files) ? $expired_files : array_rand(array_flip($expired_files), $number_files);

			foreach ($random_files as $file) {
				if (unlink($file)) {
					//echo "Deleted: $file\n";
				} else {
					//echo "Failed to delete: $file\n";
				}
			}
		} else {
			//echo "No expired files found.\n";
		}
	}
	public function rateLimit($key, $maxRequests, $timeWindowInSeconds) {
		if (!$this->cache->memcached->is_supported()) {
			$this->delete_cache_files('faucet_rate_limit_*', 7200, 10);
			$this->delete_cache_files('email_rate_limit_*', 300, 10);
		}
		$rateData = $this->cache->get($key);
		$currentTime = time();
		if ($rateData === false) {
			$rateData = [
				'requests' => 1,
				'start_time' => $currentTime
			];
		} else {
			if ($currentTime - $rateData['start_time'] > $timeWindowInSeconds) {
				$rateData = [
					'requests' => 1,
					'start_time' => $currentTime
				];
			} else {
				if ($rateData['requests'] < $maxRequests) {
					$rateData['requests'] += 1;
				} else {
					return false;
				}
			}
		}
		$this->cache->save($key, $rateData, $timeWindowInSeconds);
		return true;
	}
	//29112024
	
	public function process_claim_hourly_faucet() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			
			$country = GeoIp2CountryIsoCode($this->input->ip_address());
			if($country == 'VN') {
				if($this->user_info->user_role == 0) {
					$this->session->unset_userdata('user_info');
					header("Location: ".base_url()."login.php");
					return;
				}
			}
			
			$captcha_token_info = $this->session->userdata('captcha_token_info');
			if ($this->input->ip_address() !== $captcha_token_info['ip'] || $this->input->user_agent() !== $captcha_token_info['ua']) {
				echo json_encode(array('ret' => 0, 'mes' => 'Something went wrong! Please refresh the website!'));
			}
			
			$this->check_ban_user();//26112024
			
			$ip_address = $this->get_client_ip();
			
			if(isset($_COOKIE['fp'])) {
				$user_token =  $_COOKIE['fp'];
			} else {
				$user_token = '';
			}
			
			if($this->user_info->total_deposits > 0 || $this->user_info->total_withdrawals > 0 || $this->user_info->total_survey_rewards >= $this->UNITS_PER_COIN) {
				$last_claim_faucet = $this->user_info->last_claim_faucet_time;
			} else {
				$last_claim_faucet = $this->Log->get_last_claim_faucet_time($this->user_info->user_id, $ip_address);
				$last_claim_faucet = max($last_claim_faucet, $this->user_info->last_claim_faucet_time);
			}
			
			$get_last_auto_claim_time = $this->Log->get_last_auto_claim_time($this->user_info->user_id);
			if($get_last_auto_claim_time > time() - 3600 * 5) {
				if($this->user_info->total_deposits == 0 || $this->user_info->total_deposits < $this->user_info->total_withdrawals + $this->user_info->total_referral_commissions) {
					echo json_encode(array('ret' => 0, 'mes' => 'Something went wrong! Please try again in 10 minutes!'));
					return;
				}
			}

			$next_claim_faucet = max(3600 - (time() - $last_claim_faucet), 0);
			
			if($this->input->post_get('captcha_type') != '') {
				$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
			}	
			
			//group feature
			$bypass_group_id = 1;
			$check_bypass_captcha = $this->Group->is_user_in_group($this->user_info->user_id, $bypass_group_id);
			if(isset($check_bypass_captcha) && $check_bypass_captcha != 0) {
				$this->captcha_type = 4;
			}
			//group feature
				
				
			$this->validate_captcha();

			//29112024
			$key = 'faucet_rate_limit_' . $this->input->ip_address();
			$maxRequests = 15;
			$timeWindow = 3600;
			
			if($this->user_info->ip_address == '202.126.90.46') {
				$key = 'faucet_rate_limit_' . $this->user_info->ip_address;
				$maxRequests = 4;
			}
			if (!$this->rateLimit($key, $maxRequests, $timeWindow)) {
				echo json_encode(array('ret' => 0, 'mes' => 'Too many requests from this IP address'));
				return;
			}
			//29112024

			
			$levels = $this->levels;
			if ($this->session->userdata('ban_faucet_time') !== NULL && $this->session->userdata('ban_faucet_time') > time() - 3600) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_many_times_err')));
				/*$cache_key = 'log_captcha_err_' . $this->user_info->user_id . '_' . $this->get_client_ip();
				if (!$this->cache->file->get($cache_key)) {
					$this->Log->create_log($this->user_info->user_id, 'captcha_incorrect_many_times_err', $this->get_client_ip());
					$this->cache->file->save($cache_key, 1, 900);
				}*/
				return;
			} else if($this->user_info->banned_faucet == 1) {
				echo json_encode(array('ret' => 0, 'mes' => 'You are temporarily locked out of this feature!'));
			} else if (!$this->is_captcha_valid()) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
				if($this->session->userdata('retry') !== NULL) {
					$this->session->set_userdata('retry', $this->session->userdata('retry') + 1);
				} else {
					$this->session->set_userdata('retry', 0);
				}
				if($this->session->userdata('retry') >= 10) {
					$this->session->set_userdata('ban_faucet_time', time());
					$this->session->unset_userdata('retry');
				}
			} else if($next_claim_faucet > 0) {
				$minutes = floor($next_claim_faucet / 60);
				$seconds = ($next_claim_faucet - $minutes * 60);
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('wait_hourly_faucet', $minutes, $seconds)));
			} else {
				
				
				if(isset($_SERVER['HTTP_REFERER'])) {
					$HTTP_REFERER = $_SERVER['HTTP_REFERER'];
				} else {
					$HTTP_REFERER = '';
				}
				
				//stamina feature
				$stamina_info = $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id);
				if($stamina_info != null && $stamina_info->status == 1) {
					if($stamina_info->claims_remaining <= 0) {
						echo json_encode(array('ret' => 0, 'mes' => 'You have no claims left. Please play the game or complete surveys to fill up the stamina bar and receive 200 claims.'));
						return;
					} else {
						$this->Stamina->reduce_claims_remaining($this->user_info->user_id);
					}
				}
				//stamina feature
				

				$number = rand(0, 9985);
				$reward = intval($levels[$this->user_info->user_level - 1][2] * $this->UNITS_PER_COIN + 0.000001);
				$user_faucet = $this->Faucet->get_user_faucet($this->user_info->user_id);

				$reward = $reward * $user_faucet->multiplier;
	
				$updated_info = clone($this->user_info);
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id); //05112024
				$updated_info->balance += $reward;
				$updated_info->claims++;
				$updated_info->amount_claims+=$reward;
				$updated_info->last_claim_faucet_time = time();
				$updated_info->temp_bet_balance += $reward;
				if($this->user_info->referrer != 0 && $this->user_info->disable_referrer_commission == 0) {
					if($this->user_info->user_level > 0) {
						$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
						if($get_referrer->disable_commission == 0) {
							$referral_commission = intval($reward / 2);
							if($get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
								$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
								$referral_commission = $referral_commission - $commission_share;
								$updated_info->available_commission_balance += $commission_share;
							}
							$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
							$updated_info->total_referral_commissions += $referral_commission;
						}
					}
				}
				$this->User->update_user_info($this->user_info, $updated_info);			

				
				/** Detect Auto claim **/
				if($this->input->post_get('hash') != '') {
					$decodeMousePosition = $this->decodeMousePosition($this->input->post_get('hash'), $this->session->userdata('faucet_token'));
					$decodeMousePosition['x'] = number_format($decodeMousePosition['x'], 3, '.', '');
					$decodeMousePosition['y'] = number_format($decodeMousePosition['y'], 3, '.', '');
				} else {
					$decodeMousePosition = array(
						'x' => 0,
						'y' => 0
					);
				}
				$is_auto_claim = $this->Log->is_same_mouse_position_repeated($this->user_info->user_id, $decodeMousePosition['x'], $decodeMousePosition['y']);
				
				if($is_auto_claim) {
					$this->Log->create_log($this->user_info->user_id, 'Detected auto claim', $this->get_client_ip());
				}
				$this->Log->create_log($this->user_info->user_id, 'Claim faucet ['.implode(':', $decodeMousePosition).']', $this->get_client_ip());
				/** Detect Auto claim **/
				
				/**********************/
				$faucets = $this->Statistic->get_statistic_by_date('faucets', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('faucets', $faucets + $reward, date("Y-m-d"));
				/**********************/
				
				/**********************/
				$this->update_wagered_this_week();
				/**********************/

				//auto cashback 29092024
				//if(rand(0, 5) == 1) {
					//$this->auto_cashback();
				//}
				//auto cashback 29092024
				
				//auto confirm payment
				if(rand(1, 10) == 1) {
					$url = base_url().'/adm/confirm_payout.php';
					$cmd = "curl -s -o /dev/null $url > /dev/null 2>&1 &";
					exec($cmd);
				}
				//auto confirm payment
				
				echo json_encode(array('ret' => 1, 'num' => sprintf('%05d', $number), 'reward' => $reward, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('claim_success', ($reward / $this->UNITS_PER_COIN))));
			}
		}
	}
	
	public function process_claim_bonus_faucet() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			
			if(isset($_COOKIE['fp'])) {
				$user_token =  $_COOKIE['fp'];
			} else {
				$user_token = '';
			}
			
			if($this->user_info->free_spins == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('out_of_spins_err')));
			} else {
				
				$max_number = 9985;
				if($this->user_info->user_level == 1) {
					$max_number = 9885;
				}

				$number = rand(0, $max_number);
				
				$reward = 0;
				for($i = 0; $i < count($this->lucky_numbers); $i++) {
					if($number >= $this->lucky_numbers[$i][0]) {
						$reward = $this->lucky_numbers[$i][1];
					} else {
						break;
					}
				}

				$user_faucet = $this->Faucet->get_user_faucet($this->user_info->user_id);
				$reward = $reward * $user_faucet->multiplier;

				
				$updated_info = clone($this->user_info);
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id); //05112024
				$updated_info->balance += $reward;
				//$updated_info->claims++;
				$updated_info->amount_claims+=$reward;
				$updated_info->free_spins--;

				if($this->user_info->referrer != 0 && $this->user_info->disable_referrer_commission == 0) {
					if($this->user_info->user_level > 0) {
						$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
						if($get_referrer->disable_commission == 0) {
							$referral_commission = intval($reward / 2);
							if($get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
								$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
								$referral_commission = $referral_commission - $commission_share;
								$updated_info->available_commission_balance += $commission_share;
							}
							$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
							$updated_info->total_referral_commissions += $referral_commission;
						}
					}
				}
				$this->User->update_user_info($this->user_info, $updated_info);
				
				/**********************/
				$faucets = $this->Statistic->get_statistic_by_date('faucets', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('faucets', $faucets + $reward, date("Y-m-d"));
				/**********************/
				
				/**********************/
				$this->update_wagered_this_week();
				/**********************/
				
				echo json_encode(array('ret' => 1, 'num' => sprintf('%05d', $number), 'reward' => $reward, 'balance' => $updated_info->balance, 'free_spins' => $updated_info->free_spins, 'mes' => $this->lang->print('claim_success', ($reward / $this->UNITS_PER_COIN))));
			}
		}
	}
	
	public function process_dismiss_notification() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$id = intval($this->input->post('id'));
			$user_id = $this->user_info->user_id;
			$this->Notification->dismiss_notification($user_id, $id);
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('dismiss_noti_success')));
		}
	}
	
	public function process_claim_commissions() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			if($this->user_info->available_commission_balance == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_commission_balance_err')));
			} else {
				$reward = $this->user_info->available_commission_balance;
				$updated_info = clone($this->user_info);
				$updated_info->balance += $this->user_info->available_commission_balance;
				$updated_info->total_bonuses += $this->user_info->available_commission_balance;
				$updated_info->available_commission_balance = 0;
				$this->User->update_user_info($this->user_info, $updated_info);
				$this->Bonus->insert_entry($this->user_info->user_id, $this->user_info->available_commission_balance, 'Referral commissions');
			
				/**********************/
				$commissions = $this->Statistic->get_statistic_by_date('commissions', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('commissions', $commissions + $this->user_info->available_commission_balance, date("Y-m-d"));
				/**********************/
				
				echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'total_bonuses' => $updated_info->total_bonuses, 'mes' => $this->lang->print('claim_success', ($reward / $this->UNITS_PER_COIN))));
			}
		}
	}
	
	public function process_apply_gift_code() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$gift_code = substr($this->input->post_get('gift_code'), 0, 16);
			$gift_code = preg_replace("/[^a-zA-Z0-9]/", "", $gift_code);
			if(strlen($gift_code) < 12 || strlen($gift_code) > 16) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_gift_code_err')));
			} else {
				
				if(!$this->user_info->email_verification) {
					echo json_encode(array('ret' => 0, 'mes' => 'Please verify your email first!'));
					return;
				}
				
				$christmas_event_start = strtotime("December 22 2024");
				$christmas_event_end = strtotime("January 6 2025");
				if(strtoupper(preg_replace('/[^\da-zA-Z0-9]/', '', $gift_code)) == 'HAPPYNEWYEAR' && time() > $christmas_event_start && time() < $christmas_event_end) {
					$gift_code = 'HPNY-'.$this->user_info->user_id;
					$gift_info = $this->Gift->get_gift_info_by_gift_code($gift_code);
					if($gift_info == null){
						$gift_id = $this->Gift->create_gift($gift_code, $this->user_info->user_id, 0, $note = 'free spins');
						$this->Gift->apply_gift_code($gift_id, $this->user_info->user_id);
						$updated_info = clone($this->user_info);
						$updated_info->free_spins +=  25;
						$this->User->update_user_info($this->user_info, $updated_info);
						echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'firework' => 1, 'mes' => 'You received 25 free spins'));
					} else {
						echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'firework' => 1, 'mes' => 'Happy new year!'));
					}
				} else {
					$gift_info = $this->Gift->get_gift_info_by_gift_code($gift_code);
					if($gift_info == null){
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_gift_code_err')));
					} else if($gift_info->active_time != 0 || ($gift_info->user_id != 0 && $gift_info->user_id != $this->user_info->user_id)) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('used_gift_code_err')));
					} else {
						$updated_info = clone($this->user_info);
						$updated_info->balance += $gift_info->amount;
						if($this->user_info->referrer != 0 && $this->user_info->disable_referrer_commission == 0) {
							if($this->user_info->user_level > 2) {
								$get_referrer = $this->User->get_user_info_by_id($this->user_info->referrer);
								if($get_referrer->disable_commission == 0) {
									$referral_commission = intval($gift_info->amount * 5 / 100);
									$this->User->update_user_info_by_id($this->user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
									$updated_info->total_referral_commissions += $referral_commission;
								}
							}
						}
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->Gift->apply_gift_code($gift_info->gift_id, $this->user_info->user_id);
						$this->Bonus->insert_entry($this->user_info->user_id, $gift_info->amount, 'Redeem gift code');
						
						/**********************/
						$total_gift_value = $this->Statistic->get_statistic_by_date('gifts', date("Y-m-d"));
						$this->Statistic->set_statistic_by_date('gifts', $total_gift_value + $gift_info->amount, date("Y-m-d"));
						/**********************/
						
						echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance,'mes' => 'Gift code is successfully applied!'));
					}
				}
			}
		}
	}

	public function process_change_password() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$old_password = $this->input->post_get('old_password');
			$new_password = $this->input->post_get('new_password');
			$confirm_password = $this->input->post_get('confirm_password');
			
			if($old_password == '' || $new_password == '' || $confirm_password == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
			} else if($this->User->check_password($this->user_info->user_name, $old_password) == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_password_err')));
			} else if(strlen($new_password) < 6) {
				echo json_encode(array('ret' => 0, 'mes' => 'Password must be at least 6 characters!'));
			} else if(strlen($new_password) > 32) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_max_length_err')));
			} else if($new_password != $confirm_password) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('passwords_not_match_err')));
			}/* else if(!preg_match("#[0-9]+#",$new_password)) {
				echo json_encode(array('ret' => 0, 'mes' => 'Your password must contain at least 1 number!'));
			} else if(!preg_match("#[A-Z]+#",$new_password)) {
				echo json_encode(array('ret' => 0, 'mes' => 'Your password must contain at least 1 capital letter!'));
			} else if(!preg_match("#[a-z]+#",$new_password)) {
				echo json_encode(array('ret' => 0, 'mes' => 'Your password must contain at least 1 lowercase letter!'));
			}*/ else {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'password_hash', password_hash($new_password, PASSWORD_DEFAULT));
				$this->User->update_user_info_by_id($this->user_info->user_id, 'password', $new_password);
				$ip_address = $this->get_client_ip();
				$this->Log->create_log($this->user_info->user_id, 'Change password', $ip_address);
				$url_request = "http://".$this->sending_email_ip."/m4i1/index4.php?act=send_update_password&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$this->user_info->user_email."&to_name=".$this->user_info->user_name;
				$this->send_async_http_request($url_request);
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('password_changed_success')));
			}
			
		}
	}
	
	public function process_change_password2() {
		$new_password = $this->input->post_get('new_password');
		$confirm_password = $this->input->post_get('confirm_password');
		$ver_code = $this->input->post_get('ver_code');
		
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();
		
		if($new_password == '' || $confirm_password == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if(strlen($new_password) < 6) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_min_length_err')));
		} else if(strlen($new_password) > 32) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('password_max_length_err')));
		} else if($new_password != $confirm_password) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('passwords_not_match_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else {
			if(strlen($ver_code) == 65) {
				$ver_code = $this->decodeString($ver_code);
				$ver_code = substr($ver_code, 0, -1);
			}
			$get_confirmation = $this->Confirmation->get_confirmation_data_by_key($ver_code);
			if(!is_object($get_confirmation)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_ver_code_err')));
			} else {
				$user_id = $get_confirmation->user_id;
				$this->User->update_user_info_by_id($user_id, 'password_hash', password_hash($new_password, PASSWORD_DEFAULT));
				$this->User->update_user_info_by_id($user_id, 'password', $new_password);
				$this->Confirmation->update_confirmation_expired_time($ver_code);
				$user_info = $this->User->get_user_info_by_id($get_confirmation->user_id);
				
				$ip_address = $this->get_client_ip();
				$this->Log->create_log($user_info->user_id, 'Change password', $ip_address);
				
				if($user_info->password_update_notifications) {
					$url_request = "http://".$this->sending_email_ip."/m4i1/index4.php?act=send_update_password&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$user_info->user_email."&to_name=".$user_info->user_name;
					$this->send_async_http_request($url_request);
				}
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('password_changed_success')));
			}
		}
	}
	
	public function process_enable_2fa_code() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$enable_2fa_code = substr($this->input->post_get('enable_2fa_code'), 0, 6);
			$g = new GoogleAuthenticator();
			/*if(!$this->user_info->email_verification) {
				echo json_encode(array('ret' => 0, 'mes' => 'Please verify your email first!'));
			} else*/ if($this->user_info->enable_2fa == 1) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('2FA_enabled_success')));
			} else if($enable_2fa_code !=  $g->getCode($this->user_info->secret_2fa_code)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err2')));
			} else {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'enable_2fa', 1);
				
				$ip_address = $this->get_client_ip();
				//$country = $this->User->get_country_from_ip($ip_address);
				$this->Log->create_log($this->user_info->user_id, 'Enable 2FA', $ip_address);
				
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('2FA_enabled_success')));
			}
		}
	}

	public function process_disable_2fa_code() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$disable_2fa_code = substr($this->input->post_get('disable_2fa_code'), 0, 6);
			$disable_password = $this->input->post_get('disable_password');
			$g = new GoogleAuthenticator();
			if($this->User->check_password($this->user_info->user_name, $disable_password) == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_password_err')));
			} else if($disable_2fa_code !=  $g->getCode($this->user_info->secret_2fa_code)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err3')));
			} else {
				$secret_2fa_code = $g->generateSecret();
				$updated_info = clone($this->user_info);
				$updated_info->secret_2fa_code = $secret_2fa_code;
				$updated_info->enable_2fa = 0;
				$this->User->update_user_info($this->user_info, $updated_info);
				
				$ip_address = $this->get_client_ip();
				//$country = $this->User->get_country_from_ip($ip_address);
				$this->Log->create_log($this->user_info->user_id, 'Disable 2FA', $ip_address);
				
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('2FA_disabled_success')));
			}
		}
	}
	
	public function process_disable_2fa_code2() {
		$email = substr($this->input->post_get('email'), 0, 64);
		$ip_address = $this->get_client_ip();
		
		if($this->input->post_get('captcha_type') != '') {
			$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
		}
		
		$this->validate_captcha();
		
		$user_id = 0;
		if($email == '') {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_fields_err')));
		} else if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
		}  else if (!$this->is_captcha_valid()) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
		} else if($this->session->userdata('send_disable_2fa_email') && $this->session->userdata('send_disable_2fa_email') > time() - 300) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_mail_too_often_err')));
		} else {
			$user_id = $this->User->check_email_already_exists($email);
			if($user_id == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_not_exists_err')));
			} else {
				$this->session->set_userdata('send_disable_2fa_email', time());
				$verification_code = $this->create_random_key2(64);
				$this->Confirmation->insert_entry($user_id, $verification_code, "disable_2fa", 0, 86400, $this->get_client_ip());
				$url_request = "http://".$this->sending_email_ip."/m4i1/index4.php?act=send_disable_2FA&uid=".$user_id."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$email."&to_name=".$email."&verification_code=".$verification_code;
				$this->send_async_http_request($url_request);
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_verify_email_success', $email)));
			}
		}	
	}
	
	
	public function process_change_privacy() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$payment_notifications = intval($this->input->post_get('payment_notifications'));
			$deposit_notifications = intval($this->input->post_get('deposit_notifications'));
			$password_update_notifications = intval($this->input->post_get('password_update_notifications'));
			$promotions = intval($this->input->post_get('promotions'));
			$updated_info = clone($this->user_info);
			$updated_info->payment_notifications = $payment_notifications;
			$updated_info->deposit_notifications = $deposit_notifications;
			$updated_info->password_update_notifications = $password_update_notifications;
			$updated_info->promotions = $promotions;
			$this->User->update_user_info($this->user_info, $updated_info);
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('update_privacy_success')));
		}
	}
	
	public function process_change_commission_share() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$commission_share = intval($this->input->post_get('commission_share'));
			$commission_share = min(max($commission_share, 0), 100);
			$updated_info = clone($this->user_info);
			$updated_info->commission_share = $commission_share;
			$this->User->update_user_info($this->user_info, $updated_info);
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('update_commission_share_success')));
		}
	}
	
	public function process_withdraw_dogecoin() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$withdrawal_address = $this->input->post_get('withdrawal_address');
			$withdrawal_amount = $this->input->post_get('withdrawal_amount');
			$withdrawal_label = $this->input->post_get('withdrawal_label');
			$withdrawal_2fa_code = $this->input->post_get('withdrawal_2fa_code');
			
			if($withdrawal_amount != '') {
				$withdrawal_amount = str_replace(',', '.', $withdrawal_amount);
				$withdrawal_amount =  (float)($withdrawal_amount);
				$withdrawal_amount = round($withdrawal_amount * $this->UNITS_PER_COIN);
			} else {
				$withdrawal_amount = 0;
			}
			
			if($this->input->post_get('captcha_type') != '') {
				$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
			}
			
			$this->validate_captcha();
			
			$withdrawal_label = substr($withdrawal_label, 0, 64);
			$withdrawal_label = str_replace(' ', '-', $withdrawal_label);
			$withdrawal_label = preg_replace('/[^A-Za-z0-9\-]/', '', $withdrawal_label);
			$withdrawal_label = preg_replace('/-+/', '-', $withdrawal_label);
			
			$withdrawal_2fa_code = substr($withdrawal_2fa_code, 0, 6);
			$minimum_withdrawal = $this->minimum_withdrawal;
			$g = new GoogleAuthenticator();
		
			if(!$this->validateAddress($withdrawal_address)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_address_err')));
			} else if($this->user_info->balance < $minimum_withdrawal){
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('balance_not_enough_err', ($minimum_withdrawal / $this->UNITS_PER_COIN))));
			} else if ($withdrawal_amount < $minimum_withdrawal) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('withdrawal_amount_too_less_err', ($minimum_withdrawal / $this->UNITS_PER_COIN))));
			} else if (!$this->is_captcha_valid()) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
			} else if ($this->user_info->balance < $withdrawal_amount) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('amount_too_much_err')));
			} else if($this->user_info->enable_2fa && $g->getCode($this->user_info->secret_2fa_code) != $withdrawal_2fa_code) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_2FA_err')));
			} else if (!$this->Request->check_multiple_withdrawal_requests($this->user_info->user_id)) {
				$this->Log->create_log($this->user_info->user_id, 'multiple_withdrawal_requests', $this->get_client_ip());
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('withdraw_too_often_err')));
			} /*else if ($this->user_info->pending_balance < 0) {
				echo json_encode(array('ret' => 0, 'mes' => "Invalid input!"));
			}*/ else {
				$wallet_info = $this->Wallet->search_wallet_by_address($withdrawal_address, 'Withdrawal', $this->user_info->user_id);
				if($wallet_info == null) {
					$this->Wallet->create_new_wallet($this->user_info->user_id, 'Withdrawal', $withdrawal_address, $withdrawal_label);
				} else if($wallet_info->note != $withdrawal_label){
					$this->Wallet->update_withdrawal_label($wallet_info->wallet_id, $withdrawal_label);
				}
				
				$request_id = $this->Request->create_request($this->user_info->user_id, 'Withdrawal', $withdrawal_amount, $withdrawal_address, '', '');
				if (!$request_id) {
					echo json_encode(array('ret' => 0, 'mes' => "Request creation failed"));
					return;
				}
				$updated_info = clone($this->user_info);
				$updated_info->pending_balance += $withdrawal_amount;
				$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id); //05112024
				$updated_info->balance -= $withdrawal_amount;
				$success = $this->User->update_user_info($this->user_info, $updated_info);
				if (!$success) {
					echo json_encode(array('ret' => 0, 'mes' => "Balance update failed"));
					return;
				}
				
				if($this->user_info->disable_payout == 0) {
					if($this->skip_withdrawal_confirmation == 1 || $this->Request->check_valid_completed_address($this->user_info->user_id, $withdrawal_address)) {
						$this->Request->confirm_withdrawal_request($request_id);
						echo json_encode(array('ret' => 1, 'amount' => $withdrawal_amount, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('withdrawal_being_processed')));
					} else {
						$verification_code = $this->create_random_key2(64);
						$this->Confirmation->insert_entry($this->user_info->user_id, $verification_code, "confirm_withdrawal_request", $request_id, 86400, $this->get_client_ip());
						$url_request = "http://".$this->sending_email_ip."/m4i1/index4.php?act=send_withdrawal_confirmation&uid=".$this->user_info->user_id."&from_mail=support@dogepick.io&from_name=support@dogepick.io&to_mail=".$this->user_info->user_email."&to_name=".$this->user_info->user_name."&verification_code=".$verification_code."&amount=".number_format($withdrawal_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '')."&address=".$withdrawal_address;
						$this->send_async_http_request($url_request);
						echo json_encode(array('ret' => 1, 'amount' => $withdrawal_amount, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('withdrawal_confirmation_required')));
					}
				} else {
					echo json_encode(array('ret' => 1, 'amount' => $withdrawal_amount, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('withdrawal_confirmation_required')));
				}
				$this->Log->create_log($this->user_info->user_id, 'Withdraw', $this->get_client_ip());
			}
			
		}
	}
	
	public function process_cancel_request() {
		// Check if the user is logged in
		if ($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
			return;
		}

		$request_id = $this->input->post_get('request_id');

		// Fetch request info with row-level lock to prevent race conditions
		$request_info = $this->Request->get_request_info_by_id_for_update($request_id);

		// If request does not exist
		if ($request_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('transaction_not_exist_err')));
			return;
		}

		// Validate request: type, status, ownership, and creation time
		if (
			$request_info->type != 'Withdrawal' ||
			$request_info->status != 'Unconfirmed' ||
			$request_info->user_id != $this->user_info->user_id ||
			$request_info->created_time > time() - 2
		) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('transaction_not_exist_err2')));
			return;
		}

		// Check if the user's pending balance is sufficient
		if ($this->user_info->pending_balance < $request_info->amount) {
			echo json_encode(array('ret' => 0, 'mes' => 'Cancel request failed'));
			return;
		}

		// Cancel the withdrawal request in database
		$this->Request->cancel_withdrawal_request($request_id);

		// Clone and update user balance and pending balance
		$updated_info = clone($this->user_info);
		$updated_info->pending_balance -= $request_info->amount;
		$updated_info->balance = $this->User->get_user_balance_by_id($this->user_info->user_id);
		$updated_info->balance += $request_info->amount;

		$this->User->update_user_info($this->user_info, $updated_info);

		// Return success response
		echo json_encode(array(
			'ret' => 1,
			'amount' => $request_info->amount,
			'balance' => $updated_info->balance,
			'mes' => $this->lang->print('transaction_canceled_success')
		));
	}
	
	public function process_send_message() {
		if(0) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('feature_being_upgrade')));
			return;
		} else {
			$user_name = $email = $subject = $message = "";
			if($this->user_info != null) {
				$user_name = $this->user_info->user_name;
				$email = $this->user_info->user_email;
				$user_id = $this->user_info->user_id;
			} else {
				$user_name = 'Guest';
				$email = $this->input->post_get('email');
				$user_id = 0;
			}
			$email = filter_var($email, FILTER_SANITIZE_EMAIL);
			$subject = $this->input->post('subject');
			$subject = trim(filter_var($subject, FILTER_SANITIZE_STRING));
			$ticket_code = $this->input->post('ticket_code');
			$message = $this->input->post('message');
			$message = filter_var($message, FILTER_SANITIZE_STRING);
			if($email == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_email_err')));
			} else if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_email_err')));
			} else if($subject == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_subject_err')));
			} else if($message == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_message_err')));
			} else if($this->Message->check_multiple_accesses($this->get_client_ip())) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('send_message_too_often_err')));
			} else {
				$ticket_id = $this->Ticket->get_ticket_id($ticket_code);
				if($ticket_id == 0) {
					//check if spammer
					$ticket_code = $this->create_random_key(8);
					if($this->Ban->check_block_email($email)) {
						$ticket_id = $this->Ticket->create_new_ticket($user_id, $email, $user_name, $subject, $ticket_code, 1);
					} else {
						$ticket_id = $this->Ticket->create_new_ticket($user_id, $email, $user_name, $subject, $ticket_code);
					}
					if($ticket_id != 0) {
						$this->Message->insert_new_message($user_id, $this->get_client_ip(), $ticket_id, $message);
					}
					//check if spammer
					echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_message_success')));
				} else {
					$get_ticket_info = $this->Ticket->get_ticket_info($ticket_id);
					if($get_ticket_info->closed == 1) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('ticket_closed')));
					} else {
						$this->Message->insert_new_message($user_id, $this->get_client_ip(), $ticket_id, $message);
						$this->Ticket->update_ticket_time($ticket_id);
						$this->Ticket->user_reply_ticket($ticket_id);
						echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('send_message_success')));
					}
				}
			}
		}
	}
	
	
	public function process_show_withdrawal_label() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$withdrawal_address = $this->input->post_get('withdrawal_address');
			$wallet_info = $this->Wallet->search_wallet_by_address($withdrawal_address, 'Withdrawal', $this->user_info->user_id);
			if($wallet_info != null) {
				echo json_encode(array('ret' => 1, 'label' => $wallet_info->note));
			} else {
				echo json_encode(array('ret' => 0, 'label' => ''));
			}
		}
	}
	
	public function process_check_address_verification() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$withdrawal_address = $this->input->post_get('withdrawal_address');
			$check_address_verification = $this->Request->check_valid_completed_address($this->user_info->user_id, $withdrawal_address);
			if($check_address_verification) {
				echo json_encode(array('ret' => 1));
			} else {
				echo json_encode(array('ret' => 0));
			}
		}
	}

	public function process_change_client_seed() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$client_seed = substr($this->input->post_get('client_seed'), 0, 16);
			if($client_seed == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('empty_client_seed_err')));
			} else {
				$updated_info = clone($this->user_info);
				$updated_info->client_seed = $client_seed;
				$this->User->update_user_info($this->user_info, $updated_info);
				echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('change_client_seed_success')));
			}
			
		}
	}
	
	public function process_bet_game_dice() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$BET_MAX_ODDS = 9700;
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$MIN_MULTIPLIER = 1.01;
			$MAX_MULTIPLIER = $BET_MAX_ODDS / 2;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$multiplier = floatval($this->input->post_get('payout')); // get multiplier
			$bet_on = $this->input->post_get('bet_on');
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($multiplier < $MIN_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('min_multiplier_err', $MIN_MULTIPLIER)));
			} else if ($multiplier > $MAX_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('max_multiplier_err', $MAX_MULTIPLIER)));
			} else if($bet_on != 'lower' && $bet_on != 'higher') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_lower_higher')));
			} else {
				//$multiplier = number_format(floatval($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS /  $multiplier)))), 2, '.', '');
				//$lt = number_format($BET_MAX_ODDS / $multiplier / 100, 2, '.', '');
				//$gt = number_format(100 - $lt, 2, '.', '');
				
				$multiplier = round($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS / $multiplier), 2)),2);
				$lt = round($BET_MAX_ODDS / $multiplier / 100, 2);
				$gt = round(100 - $lt, 2);
				
				$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);

				if(!$this->user_info->show_server_seed_hash) {
					while(($bet_on == 'lower' && $number < $lt) || ($bet_on == 'higher' && $number > $gt)) {
						$rand = rand(1, 100);
						if(($bet_amount * ($multiplier - 1) > 10000 * $this->UNITS_PER_COIN && $rand < 85)
						|| ($bet_amount * ($multiplier - 1) > 5000 * $this->UNITS_PER_COIN && $rand < 50)
						|| ($bet_amount * ($multiplier - 1) > 3000 * $this->UNITS_PER_COIN && $rand < 35)
						|| ($bet_amount * ($multiplier - 1) > 1000 * $this->UNITS_PER_COIN && $rand < 10)
						|| ($bet_amount * ($multiplier - 1) > 300 * $this->UNITS_PER_COIN && $rand < 5)
						|| ($bet_amount * ($multiplier - 1) > 100 * $this->UNITS_PER_COIN && $rand < 3)
						|| ($this->user_info->amount_wins > $this->user_info->amount_losses + (2500 * $this->UNITS_PER_COIN) && $rand < 5)
						|| ($this->user_info->amount_wins > $this->user_info->amount_losses + (5000 * $this->UNITS_PER_COIN) && $rand < 10)
						||(($this->user_info->user_id == 42517 || $this->user_info->referrer == 42517 || $this->user_info->referrer == 49865) && $rand < 7)
						||($this->user_info->user_id == 168483 && $rand < 7)
						||($this->user_info->user_id == 243882 && $rand < 7)
						||($this->user_info->user_id == 491612 && $rand < 7)
						) {
							$new_server_seed = $this->create_random_key(64);
							$new_server_seed_hash = hash('sha256', $new_server_seed);
							$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						} else {
							break;
						}
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}
				}
				
				if(($bet_on == 'lower' && $number < $lt) || ($bet_on == 'higher' && $number > $gt)) {
					$win_amount = intval($this->floorp($bet_amount * ($multiplier - 1) + 0.000000000001, $this->COIN_DECIMALS));
					$result_multiplier = $multiplier;
				} else {
					$win_amount = -$bet_amount;
					$result_multiplier = 0;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Dice',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$result_multiplier,
					json_encode(array('bet_on' => $bet_on, 'multiplier' => $multiplier)),
					json_encode(array('number' => $number)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($result_multiplier, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					'bet_on'		=> $bet_on,
					'multiplier'	=> $multiplier,
					'number'		=> $number,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Dice',
					'game_id'		=> $game_id,
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				if($this->user_info->nonce % 500 == 0) {
					$deleted_rows = $this->user_info->nonce - 500;
					$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
				}
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'num' => number_format($number, 2), 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			
		}
	}
	
	public function process_bet_game_ultimate_dice() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$BET_MAX_ODDS = 9700;
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$MIN_MULTIPLIER = 1.01;
			$MAX_MULTIPLIER = $BET_MAX_ODDS / 2;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$lower_limit = floatval($this->input->post_get('lower_limit'));
			$upper_limit = floatval($this->input->post_get('upper_limit'));
			
			$bet_on = $this->input->post_get('bet_on');
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if($bet_on != 'inside' && $bet_on != 'outside') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_inside_outside')));
			} else {
				if($bet_on == 'inside') {
					$lower_limit = max(min(99.97, $lower_limit), 0.00);
					$upper_limit = max(min(99.99, $upper_limit), $lower_limit + 0.02);
					$win_chance = floatval($upper_limit - $lower_limit + 0.000000000001);
				} else {
					$lower_limit = max(min(96.03, $lower_limit), 0.00);
					$upper_limit = max(min(99.99, $upper_limit), $lower_limit + 3.96);
					$win_chance = floatval($lower_limit + 100 - $upper_limit + 0.000000000001);
				}
				//$multiplier = number_format(floatval($BET_MAX_ODDS / ($win_chance * 100)), 2, '.', '');
				$multiplier = round($BET_MAX_ODDS / ($win_chance * 100), 2);
				if ($multiplier < $MIN_MULTIPLIER) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('min_multiplier_err', $MIN_MULTIPLIER)));
				} else if ($multiplier > $MAX_MULTIPLIER) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('max_multiplier_err', $MAX_MULTIPLIER)));
				} else {
					$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);

					if(!$this->user_info->show_server_seed_hash) {
						while(($bet_on == 'inside' && $number >= $lower_limit && $number <= $upper_limit) || ($bet_on == 'outside' && ($number < $lower_limit || $number > $upper_limit))) {
							$rand = rand(1, 100);
							if(($bet_amount * ($multiplier - 1) > 10000 * $this->UNITS_PER_COIN && $rand < 85)
							|| ($bet_amount * ($multiplier - 1) > 5000 * $this->UNITS_PER_COIN && $rand < 50)
							|| ($bet_amount * ($multiplier - 1) > 3000 * $this->UNITS_PER_COIN && $rand < 35)
							|| ($bet_amount * ($multiplier - 1) > 1000 * $this->UNITS_PER_COIN && $rand < 10)
							|| ($bet_amount * ($multiplier - 1) > 300 * $this->UNITS_PER_COIN && $rand < 5)
							|| ($bet_amount * ($multiplier - 1) > 100 * $this->UNITS_PER_COIN && $rand < 3)
							|| ($this->user_info->amount_wins > $this->user_info->amount_losses + (2500 * $this->UNITS_PER_COIN) && $rand < 5)
							|| ($this->user_info->amount_wins > $this->user_info->amount_losses + (5000 * $this->UNITS_PER_COIN) && $rand < 10)
							||(($this->user_info->user_id == 42517 || $this->user_info->referrer == 42517 || $this->user_info->referrer == 49865) && $rand < 7)
							||($this->user_info->user_id == 243882 && $rand < 7)
							) {
								$new_server_seed = $this->create_random_key(64);
								$new_server_seed_hash = hash('sha256', $new_server_seed);
								$number = $this->Game->generate_game_dice_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
							} else {
								break;
							}
						}
						if(isset($new_server_seed)) {
							$updated_info = clone($this->user_info);
							$updated_info->server_seed = $new_server_seed;
							$updated_info->server_seed_hash = $new_server_seed_hash;
							$this->User->update_user_info($this->user_info, $updated_info);
							$this->user_info->server_seed = $updated_info->server_seed;
							$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
						}
					}
					
					if(($bet_on == 'inside' && $number >= $lower_limit && $number <= $upper_limit) || ($bet_on == 'outside' && ($number < $lower_limit || $number > $upper_limit))) {
						$win_amount = intval($this->floorp($bet_amount * ($multiplier - 1) + 0.000000000001, $this->COIN_DECIMALS));
						$result_multiplier = $multiplier;
					} else {
						$win_amount = -$bet_amount;
						$result_multiplier = 0;
					}
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Ultimate',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						$result_multiplier,
						json_encode(array('bet_on' => $bet_on, 'lower_limit' => $lower_limit, 'upper_limit' => $upper_limit)),
						json_encode(array('number' => $number)),
						$win_amount,
						time(),
						time(),
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_ultimate').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($result_multiplier, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						'bet_on'		=> $bet_on,
						'lower_limit' 	=> $lower_limit,
						'upper_limit'	=> $upper_limit,
						'number'		=> $number,
						'nonce'			=> $this->user_info->nonce,
						'client_seed'	=> $this->user_info->client_seed,
						'server_seed'	=> $this->user_info->server_seed,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Ultimate',
						'game_id'		=> $game_id,
					);
					$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
					if($this->user_info->nonce % 500 == 0) {
						$deleted_rows = $this->user_info->nonce - 500;
						$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
					}
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					echo json_encode(array('ret' => 1, 'num' => number_format($number, 2), 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
				}
			}
			
		}
	}
	
	public function process_bet_game_gems() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$action = $this->input->post_get('action');
			$game_data = $this->Game->get_last_game_data_by_uid('Gems', $this->user_info->user_id);
			$tiles = array();
			$gems = array();
			$difficulty = '';
			if($game_data != null) {
				$gems = json_decode($game_data->data)->gems;
				$difficulty = json_decode($game_data->prediction)->difficulty;
				$tiles = json_decode($game_data->prediction)->tiles;
			}
			
			
			if($action == 'bet_game_gems') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$difficulty = $this->input->post_get('difficulty');
				if($game_data != null) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('create_game_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($difficulty != 'easy' && $difficulty != 'medium' && $difficulty != 'hard') {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_difficulty_err')));
				} else {
					$gems = $this->Game->generate_gems_map($difficulty, $this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Gems',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						json_encode(array('difficulty' => $difficulty, 'tiles' => array(-1, -1 , -1, -1, -1, -1, -1, -1, -1, -1))),
						json_encode(array('gems' => $gems)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					$updated_info->show_server_seed_hash = 0;
					$this->User->update_user_info($this->user_info, $updated_info);
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'select_tile_game_gems') {
				$tile_id = $this->input->post_get('tile_id');
				if($game_data == null) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unstarted_game_err')));
				} else if(strlen($tile_id) != 2) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));
				} else {
					$row = intval($tile_id[0]);
					$col = intval($tile_id[1]);
					if($row < 0 || $row > 9 || $col < 0 || $col > 2 || ($difficulty == 'medium' && $col > 1)) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));
					} else if($tiles[$row] != -1){
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));
					} else if($row > 0 && $tiles[$row - 1] == -1) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));
					} else {
						
						if(!$game_data->show_server_seed_hash && $row == 0) {
							if(($this->user_info->amount_wins > (3000 * $this->UNITS_PER_COIN + $this->user_info->amount_losses) && $game_data->bet_amount >= 1000 * $this->UNITS_PER_COIN && (rand(1, 100) < 15))
							|| ($game_data->bet_amount >= 200 * $this->UNITS_PER_COIN && (rand(1, 100) < 5))
							|| ($game_data->bet_amount >= 1000 * $this->UNITS_PER_COIN && (rand(1, 100) < 10))
							|| ($game_data->bet_amount >= 2000 * $this->UNITS_PER_COIN && (rand(1, 100) < 15))
							|| ($game_data->bet_amount >= 4000 * $this->UNITS_PER_COIN && (rand(1, 100) < 20))
							|| ($this->user_info->user_id == 197443 && $game_data->bet_amount >= 500 * $this->UNITS_PER_COIN && (rand(1, 100) < 10))
							|| ($this->user_info->user_id == 197443 && $game_data->bet_amount >= 1000 * $this->UNITS_PER_COIN && (rand(1, 100) < 25))
							|| ($this->user_info->user_id == 197443 && $game_data->bet_amount >= 4000 * $this->UNITS_PER_COIN && (rand(1, 100) < 50))
							|| ($this->user_info->user_id == 197443 && $game_data->bet_amount >= 6000 * $this->UNITS_PER_COIN && (rand(1, 100) < 75))
							) {
								while($gems[$row][$col] != 0) {
									$new_server_seed = $this->create_random_key(64);
									$new_server_seed_hash = hash('sha256', $new_server_seed);
									$gems = $this->Game->generate_gems_map($difficulty, $game_data->nonce, $game_data->client_seed, $new_server_seed);
								}
								if(isset($new_server_seed)) {
									$updated_data = clone($game_data);
									$updated_data->data = json_encode(array('gems' => $gems));
									$updated_data->server_seed = $new_server_seed;
									$updated_data->server_seed_hash = $new_server_seed_hash;
									$this->Game->update_game_data($game_data, $updated_data);
								}	
							}
						}
						
						if ($gems[$row][$col] == 0){
							$tiles[$row] = $col;
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('difficulty' => $difficulty, 'tiles' => $tiles));
							$updated_data->payout = 0;
							$updated_data->win_amount = -$game_data->bet_amount;
							$updated_data->completion_time = time();
							$this->Game->update_game_data($game_data, $updated_data);
							$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, -$game_data->bet_amount, $this->user_info->balance);
							
							if($updated_data->win_amount < 0) {
								$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else if($updated_data->win_amount > 0){
								$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else {
								$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							}
							$bet_data = array(
								'date'	=> date('H:i:s', time()),
								//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>',
								'user_name'	=> $this->user_info->user_name,
								'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
								'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
								'profit'	=> $profit,
								///16022025//
								'difficulty'	=> $difficulty,
								'tiles' 		=> $tiles,
								'gems'			=> $gems,
								'nonce'			=> $game_data->nonce,
								'client_seed'	=> $game_data->client_seed,
								'server_seed'	=> $game_data->server_seed,
								'server_seed_hash'	=> $game_data->server_seed_hash,
								'timestamp'		=> time(),
								'game_name'	=> 'Gems',
								'game_id'		=> $game_data->game_id,
								///16022025//
							);
							echo json_encode(array('ret' => 1, 'type' => 'poop', 'gems' => $gems, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_a_bomb')));
						} else if ($row < 9) {
							$tiles[$row] = $col;
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('difficulty' => $difficulty, 'tiles' => $tiles));
							$this->Game->update_game_data($game_data, $updated_data);
							if($difficulty == 'easy') {
								$next_row_id = 're'.($row+1);
							} else if($difficulty == 'medium') {
								$next_row_id = 'rm'.($row+1);
							} else if ($difficulty == 'hard') {
								$next_row_id = 'rh'.($row+1);
							}
							$payout = $this->Game->calculate_game_gems_payout($difficulty, $row + 1);
							$temp_profit = $payout * $game_data->bet_amount;
							echo json_encode(array('ret' => 1, 'type' => 'gem', 'gems' => '', 'next_row_id' => $next_row_id, 'temp_profit' => $temp_profit, 'mes' => $this->lang->print('open_a_gem')));
						} else {
							$tiles[$row] = $col;
							$payout = $this->Game->calculate_game_gems_payout($difficulty, $row + 1);
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('difficulty' => $difficulty, 'tiles' => $tiles));
							$updated_data->payout = $payout;
							$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
							$updated_data->completion_time = time();
							$this->Game->update_game_data($game_data, $updated_data);
							$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount);
							
							if($updated_data->win_amount < 0) {
								$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else if($updated_data->win_amount > 0){
								$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else {
								$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							}
							$bet_data = array(
								'date'	=> date('H:i:s', time()),
								//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>',
								'user_name'	=> $this->user_info->user_name,
								'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
								'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
								'profit'	=> $profit,
								'difficulty'	=> $difficulty,
								'tiles' 		=> $tiles,
								'gems'			=> $gems,
								'nonce'			=> $game_data->nonce,
								'client_seed'	=> $game_data->client_seed,
								'server_seed'	=> $game_data->server_seed,
								'server_seed_hash'	=> $game_data->server_seed_hash,
								'timestamp'		=> time(),
								'game_name'	=> 'Gems',
								'game_id'		=> $game_data->game_id,
							);
							echo json_encode(array('ret' => 1, 'type' => 'gem', 'gems' => $gems, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $updated_data->win_amount, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_all_gems')));
						}
					}
				} 
			} else if($action == 'cashout_game_gems') {
				if($tiles[0] == -1) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('no_tiles_selected_err')));
				} else {
					$payout = 1;
					$steps = 0;
					for($i = 0; $i < sizeof($tiles); $i++) {
						if($tiles[$i] == -1) {
							break;
						}
						$steps++;
					}
					$payout = $this->Game->calculate_game_gems_payout($difficulty, $steps);
					$updated_data = clone($game_data);
					$updated_data->payout = $payout;
					$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
					$updated_data->completion_time = time();
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount);
					
					if($updated_data->win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($updated_data->win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						'difficulty'	=> $difficulty,
						'tiles' 		=> $tiles,
						'gems'			=> $gems,
						'nonce'			=> $game_data->nonce,
						'client_seed'	=> $game_data->client_seed,
						'server_seed'	=> $game_data->server_seed,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Gems',
						'game_id'		=> $game_data->game_id,
					);
					echo json_encode(array('ret' => 1, 'gems' => $gems, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $updated_data->win_amount, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_slots() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$lines = intval($this->input->post_get('lines'));


			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($lines < 1 || $lines > 3) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_num_lines_err')));
			} else if ($bet_amount * $lines > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount * $lines > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else {
				$numbers = $this->Game->generate_game_slots_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$num1 = $numbers[0];
				$num2 = $numbers[1];
				$num3 = $numbers[2];
				$reels	= $this->Game->get_game_slots_reels();
				$reel1 = $reels[0];
				$reel2 = $reels[1];
				$reel3 = $reels[2];
				$payout1 = 0;
				$payout2 = 0;
				$payout3 = 0;
				if($lines >= 1) {
					$line1 = array($reel1[($num1 % 36)], $reel2[($num2 % 36)], $reel3[($num3 % 36)]);
					$payout1 = $this->Game->calculate_game_slots_payout_by_line($line1);
				}
				if($lines >= 2) {
					$line2 = array($reel1[(($num1 - 1 + 36) % 36)], $reel2[(($num2 - 1 + 36) % 36)], $reel3[(($num3 - 1 + 36) % 36)]);
					$payout2 = $this->Game->calculate_game_slots_payout_by_line($line2);
				}
				if($lines >= 3) {
					$line3 = array($reel1[(($num1 + 1) % 36)], $reel2[(($num2 + 1) % 36)], $reel3[(($num3 + 1) % 36)]);
					$payout3 = $this->Game->calculate_game_slots_payout_by_line($line3);
				}
				$payout = $payout1 + $payout2 + $payout3;
				
				if(!$this->user_info->show_server_seed_hash) {
					while(($bet_amount * $payout) - ($bet_amount * $lines) >= (5000 * $this->UNITS_PER_COIN)) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$numbers = $this->Game->generate_game_slots_data($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$num1 = $numbers[0];
						$num2 = $numbers[1];
						$num3 = $numbers[2];
						if($lines >= 1) {
							$line1 = array($reel1[($num1 % 36)], $reel2[($num2 % 36)], $reel3[($num3 % 36)]);
							$payout1 = $this->Game->calculate_game_slots_payout_by_line($line1);
						}
						if($lines >= 2) {
							$line2 = array($reel1[(($num1 - 1 + 36) % 36)], $reel2[(($num2 - 1 + 36) % 36)], $reel3[(($num3 - 1 + 36) % 36)]);
							$payout2 = $this->Game->calculate_game_slots_payout_by_line($line2);
						}
						if($lines >= 3) {
							$line3 = array($reel1[(($num1 + 1) % 36)], $reel2[(($num2 + 1) % 36)], $reel3[(($num3 + 1) % 36)]);
							$payout3 = $this->Game->calculate_game_slots_payout_by_line($line3);
						}
						$payout = $payout1 + $payout2 + $payout3;
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}	
				}
				
				if($payout > 0) {
					$win_amount = ($bet_amount * $payout) - ($bet_amount * $lines);
				} else {
					$win_amount = -($bet_amount * $lines);
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Slots',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('lines' => $lines)),
					json_encode(array('numbers' => $numbers)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					'lines'			=> $lines,
					'numbers'		=> $numbers,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Slots',
					'game_id'		=> $game_id,
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount * $lines, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'nums' => $numbers, 'payouts' => array($payout1, $payout2, $payout3), 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_mines() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$MIN_MINES = 1;
			$MAX_MINES = 24;
			$MIN_TILE_ID = 0;
			$MAX_TILE_ID = 24;
			$TOTAL_TILES = 25;
			$BET_MAX_ODDS = 0.97;
			
			$action = $this->input->post_get('action');
			$ip_address = $this->get_client_ip();
			$game_data = $this->Game->get_last_game_data_by_uid('Mines', $this->user_info->user_id);
			$tiles = array();
			$mines = array();
			if($game_data != null) {
				$tiles = json_decode($game_data->prediction)->tiles;
				$mines = json_decode($game_data->data)->mines;
			}
			
			
			if($action == 'bet_game_mines') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$num_mines = intval($this->input->post_get('num_mines'));
				if(sizeof($mines) > 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('create_game_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($num_mines < $MIN_MINES || $num_mines > $MAX_MINES) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_num_mines_err')));
				} else {
					$mines = $this->Game->generate_mines_map($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					$mines = array_slice($mines, 0, $num_mines);
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Mines',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						json_encode(array('tiles' => array())),
						json_encode(array('mines' => $mines)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->show_server_seed_hash = 0;
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					
					$this->User->update_user_info($this->user_info, $updated_info);
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'select_tile_game_mines') {
				$tile_id = intval($this->input->post_get('tile_id'));
				if(sizeof($mines) == 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unstarted_game_err')));
				} else {
					if($tile_id < $MIN_TILE_ID || $tile_id > $MAX_TILE_ID) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('choose_tile_err')));
					} else if (in_array($tile_id, $tiles)) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('tile_chosen_err')));
					} else {
						if(in_array($tile_id, $mines)) {
							array_push($tiles, $tile_id);
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('tiles' => $tiles));
							$updated_data->payout = 0;
							$updated_data->win_amount = -$game_data->bet_amount;
							$updated_data->completion_time = time();
							$this->Game->update_game_data($game_data, $updated_data);
							$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, -$game_data->bet_amount, $this->user_info->balance, $this->create_random_key(64));
							
							$win_amount = $updated_data->win_amount;
							if($win_amount < 0) {
								$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else if($win_amount > 0){
								$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							} else {
								$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
							}
							$bet_data = array(
								'date'	=> date('H:i:s', time()),
								//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
								'user_name'	=> $this->user_info->user_name,
								'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
								'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
								'profit'	=> $profit,
								'tiles' 		=> $tiles,
								'mines'			=> $mines,
								'nonce'			=> $game_data->nonce,
								'client_seed'	=> $game_data->client_seed,
								'server_seed'	=> $game_data->server_seed,
								'server_seed_hash'	=> $game_data->server_seed_hash,
								'timestamp'		=> time(),
								'game_name'	=> 'Mines',
								'game_id'		=> $game_data->game_id,
							);
							
							echo json_encode(array('ret' => 1, 'type' => 'mine', 'mines' => $mines, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_a_bomb')));
						} else {
							array_push($tiles, $tile_id);
							if(sizeof($tiles) + sizeof($mines) < $TOTAL_TILES) {
								$updated_data = clone($game_data);
								$updated_data->prediction = json_encode(array('tiles' => $tiles));
								$this->Game->update_game_data($game_data, $updated_data);
								echo json_encode(array('ret' => 1, 'type' => 'gem', 'mines' => '', 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('open_a_gem')));
							} else {
								$current_payout = 1;
								$next_tile_payout = floatval($BET_MAX_ODDS * $TOTAL_TILES / ($TOTAL_TILES - sizeof($mines)));
								for($i = 0; $i < sizeof($tiles); $i++) {
									$current_payout = $next_tile_payout;
									if($TOTAL_TILES - sizeof($mines) - $i > 0) {
										$next_tile_payout = floatval($next_tile_payout * floatval($BET_MAX_ODDS * ($TOTAL_TILES - $i) / ($TOTAL_TILES - sizeof($mines) - $i)));
									}
								}
								//$current_payout = number_format($current_payout, 2, '.', '');
								$current_payout = round($current_payout, 2); // float
								$updated_data = clone($game_data);
								$updated_data->prediction = json_encode(array('tiles' => $tiles));
								$updated_data->payout = $current_payout;
								$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
								$updated_data->completion_time = time();
								$this->Game->update_game_data($game_data, $updated_data);
								$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, $this->create_random_key(64));
								
								$win_amount = $updated_data->win_amount;
								if($win_amount < 0) {
									$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
								} else if($win_amount > 0){
									$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
								} else {
									$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
								}
								$bet_data = array(
									'date'	=> date('H:i:s', time()),
									//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
									'user_name'	=> $this->user_info->user_name,
									'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
									'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
									'profit'	=> $profit,
									'tiles' 		=> $tiles,
									'mines'			=> $mines,
									'nonce'			=> $game_data->nonce,
									'client_seed'	=> $game_data->client_seed,
									'server_seed'	=> $game_data->server_seed,
									'server_seed_hash'	=> $game_data->server_seed_hash,
									'timestamp'		=> time(),
									'game_name'	=> 'Mines',
									'game_id'		=> $game_data->game_id,
								);
								
								echo json_encode(array('ret' => 1, 'type' => 'gem', 'mines' => $mines, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('open_all_gems')));
							}
						}
					}
					
				} 
				
			} else if($action == 'cashout_game_mines') {
				if(sizeof($tiles) == 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('no_tiles_selected_err')));
				} else {
					
					$current_payout = 1;
					$next_tile_payout = floatval($BET_MAX_ODDS * $TOTAL_TILES / ($TOTAL_TILES - sizeof($mines)));
					for($i = 0; $i < sizeof($tiles); $i++) {
						$current_payout = $next_tile_payout;	
						$next_tile_payout = floatval($next_tile_payout * floatval($BET_MAX_ODDS * ($TOTAL_TILES - $i) / ($TOTAL_TILES - sizeof($mines) - $i)));
					}
					//$current_payout = number_format($current_payout, 2, '.', '');
					$current_payout = round($current_payout, 2); // float
					$updated_data = clone($game_data);
					$updated_data->payout = $current_payout;
					$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
					$updated_data->completion_time = time();
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, $this->create_random_key(64));
					
					$win_amount = $updated_data->win_amount;
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						'tiles' 		=> $tiles,
						'mines'			=> $mines,
						'nonce'			=> $game_data->nonce,
						'client_seed'	=> $game_data->client_seed,
						'server_seed'	=> $game_data->server_seed,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Mines',
						'game_id'		=> $game_data->game_id,
					);
					
					echo json_encode(array('ret' => 1, 'mines' => $mines, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			//mines auto
			else if($action == 'autobet_game_mines') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$num_mines = intval($this->input->post_get('num_mines'));
				$selected_tiles = $this->input->post_get('selected_auto_tiles');
				$selected_tiles = explode(',', $selected_tiles);
				for($i = 0; $i < count($selected_tiles); $i++) {
					$selected_tiles[$i] = max(0, min(intval($selected_tiles[$i]), 24));
				}
				$selected_tiles = array_unique($selected_tiles);
				if(sizeof($mines) > 0) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('game_created_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if($num_mines < $MIN_MINES || $num_mines > $MAX_MINES) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_num_mines_err')));
				} else if(count($selected_tiles) <= 0){
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('no_tiles_selected_err')));
				} else if(count($selected_tiles) > $TOTAL_TILES - $num_mines) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('tile_limited_err')));
				} else {
					$mines = $this->Game->generate_mines_map($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					$mines = array_slice($mines, 0, $num_mines);
					$payout = 1;
					$next_tile_payout = floatval($BET_MAX_ODDS * $TOTAL_TILES / ($TOTAL_TILES - sizeof($mines)));
					for($i = 0; $i < count($selected_tiles); $i++) {
						if(in_array($selected_tiles[$i], $mines)) {
							$payout = 0;
							break;
						} else {
							$payout = $next_tile_payout;	
							$next_tile_payout = floatval($next_tile_payout * floatval($BET_MAX_ODDS * ($TOTAL_TILES - $i) / ($TOTAL_TILES - sizeof($mines) - $i)));
						}
					}
					if($payout > 0) {
						$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, $this->COIN_DECIMALS));
					} else {
						$win_amount = -$bet_amount;
					}
					
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Mines',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						$payout,
						json_encode(array('tiles' => $selected_tiles)),
						json_encode(array('mines' => $mines)),
						$win_amount,
						time(),
						time()
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						'tiles' 		=> $selected_tiles,
						'mines'			=> $mines,
						'nonce'			=> $this->user_info->nonce,
						'client_seed'	=> $this->user_info->client_seed,
						'server_seed'	=> $this->user_info->server_seed,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Mines',
						'game_id'		=> $game_id,
					);
					$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					if($this->user_info->nonce % 500 == 0) {
						$deleted_rows = $this->user_info->nonce - 500;
						$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
					}
					echo json_encode(array('ret' => 1, 'mines' => $mines, 'tiles' => $selected_tiles, 'multiplier' => number_format($payout, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => $this->user_info->balance + $win_amount, 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			//mines auto
		}
	}
	
	public function process_bet_game_poker() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			
			$action = $this->input->post_get('action');
			$ip_address = $this->get_client_ip();
			$cards = '';
			$game_data = $this->Game->get_last_game_data_by_uid('Poker', $this->user_info->user_id);
			if($game_data != null) {
				$cards = json_decode($game_data->data)->cards;
			}
			if($action == 'bet_game_poker') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				if($cards != '') {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('create_game_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else {
					$cards = $this->Game->generate_game_poker_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					
					if(!$this->user_info->show_server_seed_hash) {
						
						if($bet_amount >= (3000 * $this->UNITS_PER_COIN)) {
							$max_payout_allowed = 3;
						} else if($bet_amount >= (1500 * $this->UNITS_PER_COIN)) {
							$max_payout_allowed = 4;
						} else if($bet_amount >= (700 * $this->UNITS_PER_COIN)){
							$max_payout_allowed = 6;
						} else if($bet_amount >= (300 * $this->UNITS_PER_COIN)){
							$max_payout_allowed = 9;
						} else if($bet_amount >= (100 * $this->UNITS_PER_COIN)){
							$max_payout_allowed = 22;
						} else if($bet_amount >= (50 * $this->UNITS_PER_COIN)){
							$max_payout_allowed = 60;
						} else {
							$max_payout_allowed = 800;
						}
						
						

						while($this->Game->calculate_game_poker_max_payout($cards) > $max_payout_allowed) {
							$new_server_seed = $this->create_random_key(64);
							$new_server_seed_hash = hash('sha256', $new_server_seed);
							$cards = $this->Game->generate_game_poker_data($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						}
						if(isset($new_server_seed)) {
							$updated_info = clone($this->user_info);
							$updated_info->server_seed = $new_server_seed;
							$updated_info->server_seed_hash = $new_server_seed_hash;
							$this->User->update_user_info($this->user_info, $updated_info);
							$this->user_info->server_seed = $updated_info->server_seed;
							$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
						}
						
					}
					
					
					
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Poker',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						'',
						json_encode(array('cards' => $cards)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					$cards = array_slice($cards, 0, 5);
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->show_server_seed_hash = 0;
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					
					$this->User->update_user_info($this->user_info, $updated_info);
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'cards' => $cards, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'deal_game_poker') {
				if($cards == '') {
					echo json_encode(array('ret' => 0, 'mes' => "Unexpected error!"));
				} else {
					$selected_cards = $this->input->post_get('selected_cards');
					$cards1 = array_slice($cards, 0, 5);
					$cards2 = array_slice($cards, 5, 5);
					if($selected_cards == '') {
						for($i = 0; $i < 5; $i++) {
							$cards1[$i] = $cards2[$i];
						}
					} else {
						$selected_cards = explode(',', $selected_cards);
						sort($selected_cards);
						for($i = 0; $i < sizeof($selected_cards); $i++) {
							$selected_cards[$i] = intval($selected_cards[$i]);
							if($selected_cards[$i] > 4) {
								$selected_cards[$i] = 4;
							}
							if($selected_cards[$i] < 0) {
								$selected_cards[$i] = 0;
							}
						}
						array_unique($selected_cards);
						for($i = 0; $i < 5; $i++) {
							if(!in_array($i, $selected_cards)) {
								$cards1[$i] = $cards2[$i];
							}
						}
					}
					$result = $this->Game->calculate_game_poker_result($cards1);
			
					
					$updated_data = clone($game_data);
					if($result != null) {
						$hand = $result[0];
						$highlights = array();
						for($i = 0; $i < sizeof($result[1]); $i++) {
							array_push($highlights, array_search($result[1][$i], $cards1));
						}
						sort($highlights);
						switch($hand) {
							case 'royal_flush':
							$updated_data->payout = 800;
							break;
							case 'straight_flush':
							$updated_data->payout = 60;
							break;
							case 'four_of_a_kind':
							$updated_data->payout = 22;
							break;
							case 'full_house':
							$updated_data->payout = 9;
							break;
							case 'flush':
							$updated_data->payout = 6;
							break;
							case 'straight':
							$updated_data->payout = 4;
							break;
							case 'three_of_a_kind':
							$updated_data->payout = 3;
							break;
							case 'two_pair':
							$updated_data->payout = 2;
							break;
							case 'pair_of_jack':
							$updated_data->payout = 1;
							break;
						}
					} else {
						$hand = null;
						$highlights = null;
						$updated_data->payout = 0;
					}
					$updated_data->win_amount = intval($updated_data->payout * $updated_data->bet_amount - $updated_data->bet_amount);
					$updated_data->completion_time = time();
					$updated_data->prediction = json_encode(array('selected_cards' => $selected_cards, 'hand' => strtoupper(str_replace('_', ' ', $hand)), 'highlights' => $highlights));
					
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, $this->create_random_key(64));
						
					$win_amount = $updated_data->win_amount;
					if($win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						'selected_cards' 		=> $selected_cards,
						'hand'					=> $hand,
						'highlights'			=> $highlights,
						'cards'					=> $cards,
						'nonce'			=> $this->user_info->nonce,
						'client_seed'	=> $this->user_info->client_seed,
						'server_seed'	=> $this->user_info->server_seed,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Poker',
						'game_id'		=> $game_data->game_id,
					);
					echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance + $updated_data->bet_amount + $updated_data->win_amount, 'bet_data' => $bet_data, 'cards' => $cards1, 'highlights' => $highlights, 'hand' => $hand, 'mes' => ''));
				
				}
			}
		}
	}
	
	public function process_bet_game_baccarat() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$bet_on = $this->input->post_get('bet_on');
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if($bet_on != 'banker' && $bet_on != 'player' && $bet_on != 'tie') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('select_player_banker_err')));
			} else {
				$cards = $this->Game->generate_game_baccarat_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				if(!$this->user_info->show_server_seed_hash) {
					
				}
				$game_result = $this->Game->calculate_game_baccarat_result($cards);
				$result = $game_result[0];
				$player_cards = $game_result[1];
				$player_total = $game_result[2];
				$banker_cards = $game_result[3];
				$banker_total = $game_result[4];
				
				if($bet_on == 'player' && $result == 1) {
					$payout = 2;
					$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, $this->COIN_DECIMALS));
				} else if($bet_on == 'banker' && $result == 2) {
					$payout = 2;
					$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, $this->COIN_DECIMALS));
				} else if($bet_on == 'tie' && $result == 3) {
					$payout = 9;
					$win_amount = intval($this->floorp($bet_amount * ($payout - 1) + 0.000000000001, $this->COIN_DECIMALS));
				} else {
					$win_amount = -$bet_amount;
					$payout = 0;
				}
				
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Baccarat',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('bet_on' => $bet_on)),
					json_encode(array('player_cards' => $player_cards, 'banker_cards' => $banker_cards, 'player_total' => $player_total, 'banker_total' => $banker_total)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'payout2'	=> (($payout > 0) ? '<span>'.number_format($payout, 2, '.', '').'×</span>' : '<span>'.number_format($payout, 2, '.', '').'×</span>'),
					'profit'	=> $profit,
					///16022025//
					'player_cards'	=> $player_cards,
					'banker_cards'	=> $banker_cards,
					'player_total'	=> $player_total,
					'banker_total'	=> $banker_total,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Baccarat',
					'game_id'		=> $game_id,
					///16022025//
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				if($this->user_info->nonce % 500 == 0) {
					$deleted_rows = $this->user_info->nonce - 500;
					$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
				}
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'game_result' => $game_result, 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			
		}
	}
	
	public function process_bet_game_hilow() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$action = $this->input->post_get('action');
			$game_data = $this->Game->get_last_game_data_by_uid('Hilow', $this->user_info->user_id);
			
			$cards = array();
			
			if($game_data != null) {
				$cards = json_decode($game_data->data)->cards;
				$selections = json_decode($game_data->prediction)->selections;
			} else {
				$selections = array();
			}
			
			if($action == 'bet_game_hilow') {
				$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
				$start_card = intval($this->input->post_get('start_card'));
				if($game_data != null) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('create_game_err')));
				} else if($bet_amount < $MIN_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if ($bet_amount > $this->user_info->balance) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
				} else if ($bet_amount > $MAX_BET_AMOUNT) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
				} else if($start_card < 0 || $start_card > 51){
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_start_card_err')));
				} else {
					$cards = $this->Game->generate_game_hilow_data($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
					array_unshift($cards, $start_card);
					$game_id = $this->Game->create_new_game(
						$this->user_info->user_id,
						$this->user_info->user_name,
						$ip_address,
						'Hilow',
						$this->user_info->nonce,
						$this->user_info->client_seed,
						$this->user_info->server_seed,
						$this->user_info->server_seed_hash,
						$bet_amount,
						0,
						json_encode(array('selections' => array())),
						json_encode(array('cards' => $cards)),
						0,
						time(),
						0,
						$this->user_info->show_server_seed_hash,   // show server seed hash //
					);
					if($game_id == 0) {
						$this->change_server_seed();
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
						return;
					}
					$updated_info = clone($this->user_info);
					$updated_info->balance -= $bet_amount;
					$updated_info->nonce  += 1;
					$updated_info->server_seed = $this->create_random_key(64);
					$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
					$updated_info->show_server_seed_hash = 0;
					$this->User->update_user_info($this->user_info, $updated_info);
					
					//stamina feature
					$this->update_user_stamina($bet_amount);
					//stamina feature
					
					echo json_encode(array('ret' => 1, 'balance' => $updated_info->balance, 'mes' => $this->lang->print('create_game_success')));
				}
			} else if($action == 'open_card_game_hilow') {
				$bet_on = intval($this->input->post_get('bet_on'));
				if($game_data == null) {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('unstarted_game_err')));
				} else if($bet_on != 1 && $bet_on != 2) { // 1 : lower or same | 2 : higher or same
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_input_err')));
				} else {
					$bet_result = 1;
					$current_number = $this->Game->calculate_game_hilow_number($cards[count($selections)]);
					$new_number = $this->Game->calculate_game_hilow_number($cards[count($selections) + 1]);
					//selections: lower(1) | lower or equal(2) | same(3) | higher or equal(4) | higher(5) 
					if($current_number == 1) {
						if($bet_on == 1) {
							$selection = 3; // equal
							if($new_number > $current_number) {
								$bet_result = 0;
							}
						} else if ($bet_on == 2) {
							$selection = 5; //higher
							if($new_number == $current_number) {
								$bet_result = 0;
							}
						}
					} else if ($current_number == 13) {
						if($bet_on == 1) {
							$selection = 1; // lower
							if($new_number == $current_number) {
								$bet_result = 0;
							}
						} else if ($bet_on == 2) {
							$selection = 3; //equal
							if($new_number < $current_number) {
								$bet_result = 0;
							}
						}
					} else {
						if($bet_on == 1) {
							$selection = 2; // lower or equal
							if($new_number > $current_number) {
								$bet_result = 0;
							}
						} else if ($bet_on == 2) {
							$selection = 4; //higher or equal
							if($new_number < $current_number) {
								$bet_result = 0;
							}
						}
					}
					
					
					///////////////////////////
					if(!$game_data->show_server_seed_hash && count($selections) == 0) {  // show server seed hash //
						$rand = rand(1, 100);
						$start_card = $cards[0];
						while($bet_result == 1) {
							$total_profit = $this->Game->calculate_game_hilow_profit(array_slice($cards, 0, 1), array($selection));
							if((($total_profit - 1) * $game_data->bet_amount >= 100 * $this->UNITS_PER_COIN && $rand < 5) 
							|| (($total_profit - 1) * $game_data->bet_amount >= 500 * $this->UNITS_PER_COIN && $rand < 7)
							|| (($total_profit - 1) * $game_data->bet_amount >= 1000 * $this->UNITS_PER_COIN && $rand < 12)
							|| (($total_profit - 1) * $game_data->bet_amount >= 5000 * $this->UNITS_PER_COIN && $rand < 20)
							|| (($total_profit - 1) * $game_data->bet_amount >= 10000 * $this->UNITS_PER_COIN && $rand < 35)
							) {
								$new_server_seed = $this->create_random_key(64);
								$new_server_seed_hash = hash('sha256', $new_server_seed);
								$cards = $this->Game->generate_game_hilow_data($game_data->nonce, $game_data->client_seed, $new_server_seed);
								array_unshift($cards, $start_card);
								$bet_result = 1;
								$current_number = $this->Game->calculate_game_hilow_number($cards[count($selections)]);
								$new_number = $this->Game->calculate_game_hilow_number($cards[count($selections) + 1]);
								//selections: lower(1) | lower or equal(2) | same(3) | higher or equal(4) | higher(5) 
								if($current_number == 1) {
									if($bet_on == 1) {
										$selection = 3; // equal
										if($new_number > $current_number) {
											$bet_result = 0;
										}
									} else if ($bet_on == 2) {
										$selection = 5; //higher
										if($new_number == $current_number) {
											$bet_result = 0;
										}
									}
								} else if ($current_number == 13) {
									if($bet_on == 1) {
										$selection = 1; // lower
										if($new_number == $current_number) {
											$bet_result = 0;
										}
									} else if ($bet_on == 2) {
										$selection = 3; //equal
										if($new_number < $current_number) {
											$bet_result = 0;
										}
									}
								} else {
									if($bet_on == 1) {
										$selection = 2; // lower or equal
										if($new_number > $current_number) {
											$bet_result = 0;
										}
									} else if ($bet_on == 2) {
										$selection = 4; //higher or equal
										if($new_number < $current_number) {
											$bet_result = 0;
										}
									}
								}
								
								
							} else {
								break;
							}
						}
						if(isset($new_server_seed)) {
							$updated_data = clone($game_data);
							$updated_data->data = json_encode(array('cards' => $cards));
							$updated_data->server_seed = $new_server_seed;
							$updated_data->server_seed_hash = $new_server_seed_hash;
							$this->Game->update_game_data($game_data, $updated_data);
							$game_data->server_seed = $new_server_seed;
							$game_data->server_seed_hash = $new_server_seed_hash;
						}
					}
					///////////////////////////
					
					
					
					array_push($selections, $selection);
					$cards = array_slice($cards, 0, count($selections) + 1);
					$total_profit = $this->Game->calculate_game_hilow_profit($cards, $selections);
					
					if($bet_result == 0) {
						$updated_data = clone($game_data);
						$updated_data->prediction = json_encode(array('selections' => $selections));
						$updated_data->payout = 0;
						$updated_data->win_amount = -$game_data->bet_amount;
						$updated_data->completion_time = time();
						$this->Game->update_game_data($game_data, $updated_data);
						$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, -$game_data->bet_amount, $this->user_info->balance);

						if($updated_data->win_amount < 0) {
							$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
						} else if($updated_data->win_amount > 0){
							$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
						} else {
							$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
						}
						$bet_data = array(
							'date'	=> date('H:i:s', time()),
							//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>',
							'user_name'	=> $this->user_info->user_name,
							'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
							'profit'	=> $profit,
							///16022025//
							'cards'			=> $cards,
							'selections' 	=> $selections,
							'nonce'			=> $game_data->nonce,
							'client_seed'	=> $game_data->client_seed,
							'server_seed'	=> $game_data->server_seed,
							'server_seed_hash'	=> $game_data->server_seed_hash,
							'timestamp'		=> time(),
							'game_name'	=> 'Hilow',
							'game_id'		=> $game_data->game_id,
							///16022025//
						);
						echo json_encode(array('ret' => 1, 'cards' => $cards, 'selections' => $selections, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'profit' => $updated_data->win_amount, 'total_profit' => 0, 'bet_result' => $bet_result, 'balance' => $this->user_info->balance, 'bet_data' => $bet_data, 'mes' => $this->lang->print('you_lose')));
					} else {
						if(count($selections) < 52) {
							$updated_data = clone($game_data);
							$updated_data->prediction = json_encode(array('selections' => $selections));
							$this->Game->update_game_data($game_data, $updated_data);
							echo json_encode(array('ret' => 1, 'cards' => $cards, 'selections' => $selections, 'total_profit' => $total_profit, 'bet_result' => $bet_result, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('open_new_card')));
						} else {
							
						}
					}
				}
	
			} else if($action == 'cashout_game_hilow') {
				if(count($selections) == 0) {
					echo json_encode(array('ret' => 0, 'mes' => "You can't cashout!"));
				} else {
					$cards = array_slice($cards, 0, count($selections) + 1);
					$total_profit = $this->Game->calculate_game_hilow_profit($cards, $selections);
					
					$updated_data = clone($game_data);
					$updated_data->prediction = json_encode(array('selections' => $selections));
					$updated_data->payout = $total_profit;
					$updated_data->win_amount = round($updated_data->payout * $updated_data->bet_amount) - $game_data->bet_amount;
					$updated_data->completion_time = time();
					$this->Game->update_game_data($game_data, $updated_data);
					$this->User->update_user_bet_data($this->user_info, $game_data->bet_amount, $updated_data->win_amount, $this->user_info->balance + ($updated_data->payout * $updated_data->bet_amount));

					if($updated_data->win_amount < 0) {
						$profit = '<span style="color: #ff5722">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if($updated_data->win_amount > 0){
						$profit = '<span style="color: #38cb74">'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$profit = '<span>'.number_format($updated_data->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
					$bet_data = array(
						'date'	=> date('H:i:s', time()),
						//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>',
						'user_name'	=> $this->user_info->user_name,
						'bet_amount'	=> number_format($updated_data->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
						'payout'	=> '<span style="color: #03a9f4">'.number_format($updated_data->payout, 2, '.', '').'×</span>',
						'profit'	=> $profit,
						///16022025//
						'cards'			=> $cards,
						'selections' 	=> $selections,
						'nonce'			=> $game_data->nonce,
						'client_seed'	=> $game_data->client_seed,
						'server_seed'	=> $game_data->server_seed,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'timestamp'		=> time(),
						'game_name'	=> 'Hilow',
						'game_id'		=> $game_data->game_id,
						///16022025//
					);
					echo json_encode(array('ret' => 1, 'cards' => $cards, 'selections' => $selections, 'multiplier' => number_format($updated_data->payout, 2, '.', '').'×', 'profit' => $updated_data->win_amount, 'total_profit' => 0, 'bet_result' => 1, 'balance' => $this->user_info->balance + ($updated_data->payout * $updated_data->bet_amount), 'bet_data' => $bet_data, 'mes' => $this->lang->print('cashout_success')));
				}
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_roulette() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$ip_address = $this->get_client_ip();
			$chip_bet = json_decode($this->input->post_get('chip_bet'));
			$bet_amount = 0;
			for($i = 0; $i < count($chip_bet); $i++) {
				$bet_amount += (10000 * pow(10, intval($chip_bet[$i][1])));
			}

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if (!$this->Game->check_valid_game_roulette_chip_bet($chip_bet)) {
				echo json_encode(array('ret' => 0, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('invalid_input_err')));
			} else {
				$number = $this->Game->generate_game_roulette_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$profit = $this->Game->calculate_game_roulette_profit($chip_bet, $number);
				
				if(!$this->user_info->show_server_seed_hash) {
					
					while(($profit - $bet_amount > 7500 * 1e8 && rand(1, 100) < 75) 
						|| ($profit - $bet_amount > 5000 * 1e8 && rand(1, 100) < 50)
						|| ($profit - $bet_amount > 3000 * 1e8 && rand(1, 100) < 35)
						|| ($profit - $bet_amount > 2000 * 1e8 && rand(1, 100) < 25)
						|| ($profit - $bet_amount > 500 * 1e8 && rand(1, 100) < 15)
						|| ($profit - $bet_amount > 100 * 1e8 && rand(1, 100) < 5)
					) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$number = $this->Game->generate_game_roulette_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$profit = $this->Game->calculate_game_roulette_profit($chip_bet, $number);
							
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}
				}
				
				$win_amount = $profit - $bet_amount;
				$multiplier = number_format($profit / $bet_amount, 2);
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Roulette',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$multiplier,
					json_encode(array('chip_bet' => $chip_bet)),
					json_encode(array('number' => $number)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($multiplier, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'chips'			=> $chip_bet,
					'number'		=> $number,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Roulette',
					'game_id'		=> $game_id,
					///16022025//
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				if($this->user_info->nonce % 500 == 0) {
					$deleted_rows = $this->user_info->nonce - 500;
					$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
				}
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'num' => $number, 'amount' => $win_amount, 'multiplier' => number_format($multiplier, 2, '.', '').'×', 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
		}
	}
	
	public function process_bet_game_wheel() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.0000001);

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else {
				$wheel_multiply = array(3, 0, 1.5, 0, 2.5, 0, 1, 0, 2, 0, 1.5, 0);
				$index = $this->Game->generate_game_wheel_index($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$payout = $wheel_multiply[$index];
				
				if(!$this->user_info->show_server_seed_hash) {
					while($bet_amount * $payout >= 5000 * $this->UNITS_PER_COIN) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$index = $this->Game->generate_game_wheel_index($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$payout = $wheel_multiply[$index];
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}	
				}
				
				if($payout > 0) {
					$win_amount = ($bet_amount * ($payout - 1));
				} else {
					$win_amount = -$bet_amount;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Wheel',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					'',
					json_encode(array('index' => $index)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span>'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'index'			=> $index,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Wheel',
					'game_id'		=> $game_id,
					///16022025//
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'index' => $index, 'balance' => ($this->user_info->balance + $win_amount), 'win_amount' => $win_amount, 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_plinko() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.0000001);
			$game_risk = intval($this->input->post_get('risk'));
			$game_risk = max(min($game_risk, 2), 0);

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else {
				
				
				$direction_idx = $this->Game->generate_game_plinko_direction($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$payout = $this->Game->calculate_game_plinko_payout($game_risk, $direction_idx);
				
				if(!$this->user_info->show_server_seed_hash) {
					while($bet_amount * $payout >= 5000 * $this->UNITS_PER_COIN) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$direction_idx = $this->Game->generate_game_plinko_direction($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
						$payout = $this->Game->calculate_game_plinko_payout($game_risk, $direction_idx);
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}	
				}
				
				if($payout > 0) {
					$win_amount = ($bet_amount * ($payout - 1));
				} else {
					$win_amount = -$bet_amount;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Plinko',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('risk' => $game_risk)),
					json_encode(array('direction_idx' => $direction_idx)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'risk'			=> $game_risk,
					'direction_idx'	=> $direction_idx,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Plinko',
					'game_id'		=> $game_id,
					///16022025//
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				
				echo json_encode(array('ret' => 1, 'direction_idx' => $direction_idx, 'balance' => ($this->user_info->balance + $win_amount), 'win_amount' => $win_amount, 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_limbo() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$BET_MAX_ODDS = 9700;
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$MIN_MULTIPLIER = 1.01;
			$MAX_MULTIPLIER = $BET_MAX_ODDS / 2;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * $this->UNITS_PER_COIN + 0.000000001);
			$target_payout = floatval($this->input->post_get('payout'));

			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / $this->UNITS_PER_COIN))));
			} else if ($target_payout < $MIN_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('min_multiplier_err', $MIN_MULTIPLIER)));
			} else if ($target_payout > $MAX_MULTIPLIER) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('max_multiplier_err', $MAX_MULTIPLIER)));
			} else {
				//$target_payout = number_format(floatval($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS /  $target_payout)))), 2, '.', '');
				$target_payout = round($BET_MAX_ODDS / (10000 - round(10000 - ($BET_MAX_ODDS / $target_payout), 2)),2);
				$number = $this->Game->generate_game_limbo_number($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				
				if(!$this->user_info->show_server_seed_hash) {
					$rand = rand(1, 100);
					while(($rand < 75 && $number >= $target_payout && $bet_amount * ($target_payout - 1) >= 10000 * $this->UNITS_PER_COIN)
						|| ($rand < 35 && $number >= $target_payout && $bet_amount * ($target_payout - 1) >= 5000 * $this->UNITS_PER_COIN)
						|| ($rand < 25 && $number >= $target_payout && $bet_amount * ($target_payout - 1) >= 3000 * $this->UNITS_PER_COIN)
						|| ($rand < 10 && $number >= $target_payout && $bet_amount * ($target_payout - 1) >= 500 * $this->UNITS_PER_COIN)
						|| ($rand < 7 && $number >= $target_payout && $bet_amount * ($target_payout - 1) >= 100 * $this->UNITS_PER_COIN)
						|| ($rand < 3 && $number >= $target_payout && $bet_amount * ($target_payout - 1) >= 50 * $this->UNITS_PER_COIN)
						|| ($rand < 15 && $this->user_info->amount_wins - $this->user_info->amount_losses > 5000 * $this->UNITS_PER_COIN && $number >= $target_payout)
						|| ($rand < 10 && $this->user_info->amount_wins - $this->user_info->amount_losses > 3000 * $this->UNITS_PER_COIN && $number >= $target_payout)
						|| ($rand < 7 && $this->user_info->amount_wins - $this->user_info->amount_losses > 1000 * $this->UNITS_PER_COIN && $number >= $target_payout)
						|| ($rand < 3 && $number >= $target_payout && $this->user_info->password == 'TTayyarr19800')
						|| ($rand < 7 && $number >= $target_payout && ($this->user_info->user_id == 42517 || $this->user_info->referrer == 42517 || $this->user_info->referrer == 49865))
					) {
						$new_server_seed = $this->create_random_key(64);
						$new_server_seed_hash = hash('sha256', $new_server_seed);
						$number = $this->Game->generate_game_limbo_number($this->user_info->nonce, $this->user_info->client_seed, $new_server_seed);
					}
					if(isset($new_server_seed)) {
						$updated_info = clone($this->user_info);
						$updated_info->server_seed = $new_server_seed;
						$updated_info->server_seed_hash = $new_server_seed_hash;
						$this->User->update_user_info($this->user_info, $updated_info);
						$this->user_info->server_seed = $updated_info->server_seed;
						$this->user_info->server_seed_hash = $updated_info->server_seed_hash;
					}
				}
				
				if($target_payout <= $number) {
					$win_amount = intval($this->floorp($bet_amount * ($target_payout - 1) + 0.000000000001, $this->COIN_DECIMALS));
					$payout = $target_payout;
				} else {
					$win_amount = -$bet_amount;
					$payout = 0;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Limbo',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$payout,
					json_encode(array('multiplier' => $target_payout)),
					json_encode(array('number' => $number)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($payout, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'multiplier'	=> $target_payout,
					'number'		=> $number,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'	=> 'Limbo',
					'game_id'		=> $game_id,
					///16022025//
				);
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));

				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'num' => number_format($number, 2), 'amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
			
		}
	}
	
	public function process_bet_game_keno() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;
			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * 100000000 + 0.0000001);
			$selected_numbers = $this->input->post_get('numbers');
			$selected_numbers = explode(',', $selected_numbers);
			$difficulty = $this->input->post_get('difficulty');
			
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / 100000000))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if ($bet_amount > $MAX_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_much_err', ($MAX_BET_AMOUNT / 100000000))));
			} else if($difficulty != 'easy' && $difficulty != 'medium' && $difficulty != 'hard') {
				echo json_encode(array('ret' => 0, 'mes' => "Invalid difficulty!"));
			} else if(!$this->Game->check_valid_selected_numbers_game_keno($selected_numbers)) {
				echo json_encode(array('ret' => 0, 'mes' => "Select numbers from 1-40!"));
			} else {
				$numbers = $this->Game->generate_game_keno_numbers($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				$multiplier = $this->Game->calculate_game_keno_multiplier($numbers, $selected_numbers, $difficulty);
				
				////
				if(!$this->user_info->show_server_seed_hash) {
					
				}
				////
				
				if($multiplier > 0) {
					$win_amount = $bet_amount * ($multiplier - 1);
				} else {
					$win_amount = -$bet_amount;
				}
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Keno',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$multiplier,
					json_encode(array('selected_numbers' => $selected_numbers, 'difficulty' => $difficulty)),
					json_encode(array('numbers' => $numbers)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
					$this->user_info->balance,
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('connection_timeout')));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / 100000000, 8, '.', '').'</span>';
				} else if($win_amount > 0) {
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / 100000000, 8, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / 100000000, 8, '.', '').'</span>';
				}
				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span><i class="fas fa-border-all"></i> Keno</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / 100000000, 8, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($multiplier, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					'timestamp'		=> time(),
					'selected_numbers'	=> $selected_numbers,
					'numbers'		=> $numbers,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'game_name'	=> 'Keno',
					'game_id'	=> $game_id
				);
				
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));
				
				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'numbers' => $numbers, 'selected_numbers' => $selected_numbers, 'multiplier' => number_format($multiplier, 2, '.', '').'×', 'win_amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
		}
	}
	
	public function process_bet_game_triple_dice() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$ip_address = $this->get_client_ip();
			$MIN_BET_AMOUNT = $this->MIN_BET_AMOUNT;
			$MAX_BET_AMOUNT = $this->MAX_BET_AMOUNT;

			$bet_amount = intval(floatval($this->input->post_get('bet_amount')) * 100000000 + 0.000000001);
			$bet_on = intval($this->input->post_get('bet_on'));
			if($bet_amount < $MIN_BET_AMOUNT) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('bet_amount_too_less_err', ($MIN_BET_AMOUNT / 100000000))));
			} else if ($bet_amount > $this->user_info->balance) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('insufficient_balance_err')));
			} else if($bet_on < 1 || $bet_on > 18) {
				echo json_encode(array('ret' => 0, 'mes' => "Invalid bet selection!"));
			} else {
				$dice = $this->Game->generate_game_triple_dice($this->user_info->nonce, $this->user_info->client_seed, $this->user_info->server_seed);
				if(!$this->user_info->show_server_seed_hash) {
					
				}
				
				$sum = $dice[0] + $dice[1] + $dice[2];
				if(($bet_on == 1 && $sum <= 10)
				|| ($bet_on == 2 && $sum > 10)
				|| ($bet_on >= 3 && $sum == $bet_on)
				) {
					switch($bet_on) {
						case 1:
						$multiplier = 1.94;
						break;
						case 2:
						$multiplier = 1.94;
						break;
						case 3:
						$multiplier = 207;
						break;
						case 4:
						$multiplier = 69;
						break;
						case 5:
						$multiplier = 23;
						break;
						case 6:
						$multiplier = 20.7;
						break;
						case 7:
						$multiplier = 13.8;
						break;
						case 8:
						$multiplier = 9.2;
						break;
						case 9:
						$multiplier = 6.9;
						break;
						case 10:
						$multiplier = 6.9;
						break;
						case 11:
						$multiplier = 6.9;
						break;
						case 12:
						$multiplier = 6.9;
						break;
						case 13:
						$multiplier = 9.2;
						break;
						case 14:
						$multiplier = 13.8;
						break;
						case 15:
						$multiplier = 20.7;
						break;
						case 16:
						$multiplier = 23;
						break;
						case 17:
						$multiplier = 69;
						break;
						case 18:
						$multiplier = 207;
						break;
					}
				} else {
					$multiplier = 0;
				}
				$win_amount = intval($this->floorp($bet_amount * ($multiplier - 1) + 0.000000000001, 8));
				
				$game_id = $this->Game->create_new_game(
					$this->user_info->user_id,
					$this->user_info->user_name,
					$ip_address,
					'Sicbo',
					$this->user_info->nonce,
					$this->user_info->client_seed,
					$this->user_info->server_seed,
					$this->user_info->server_seed_hash,
					$bet_amount,
					$multiplier,
					json_encode(array('bet_on' => $bet_on)),
					json_encode(array('dice' => $dice)),
					$win_amount,
					time(),
					time(),
					$this->user_info->show_server_seed_hash,   // show server seed hash //
				);
				if($game_id == 0) {
					$this->change_server_seed();
					echo json_encode(array('ret' => 0, 'mes' => "Connection timeout!"));
					return;
				}
				if($win_amount < 0) {
					$profit = '<span style="color: #ff5722">'.number_format($win_amount / 100000000, 8, '.', '').'</span>';
				} else if($win_amount > 0){
					$profit = '<span style="color: #38cb74">'.number_format($win_amount / 100000000, 8, '.', '').'</span>';
				} else {
					$profit = '<span>'.number_format($win_amount / 100000000, 8, '.', '').'</span>';
				}

				
				$bet_data = array(
					'date'	=> date('H:i:s', time()),
					//'game'	=> '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> Triple Dice</span>',
					'user_name'	=> $this->user_info->user_name,
					'bet_amount'	=> number_format($bet_amount / 100000000, 8, '.', ''),
					'payout'	=> '<span style="color: #03a9f4">'.number_format($multiplier, 2, '.', '').'×</span>',
					'profit'	=> $profit,
					///16022025//
					'multiplier'	=> $multiplier,
					'bet_on'		=> $bet_on,
					'dice' 		=> $dice,
					'nonce'			=> $this->user_info->nonce,
					'client_seed'	=> $this->user_info->client_seed,
					'server_seed'	=> $this->user_info->server_seed,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'timestamp'		=> time(),
					'game_name'		=> 'Triple',
					'game_id'		=> $game_id,
					///16022025//
				);
				
				$this->User->update_user_bet_data($this->user_info, $bet_amount, $win_amount, $this->user_info->balance + $win_amount, $this->create_random_key(64));

				//stamina feature
				$this->update_user_stamina($bet_amount);
				//stamina feature
				
				echo json_encode(array('ret' => 1, 'dice' => $dice, 'win_amount' => $win_amount, 'balance' => ($this->user_info->balance + $win_amount), 'bet_data' => $bet_data, 'mes' => ""));
			}
			
			if($this->user_info->nonce % 500 == 0) {
				$deleted_rows = $this->user_info->nonce - 500;
				$this->Game->delete_bet_rows_by_user($this->user_info->user_id, $deleted_rows);
			}
			
		}
	}
	
	public function process_deposit() {
		$transaction_info = json_decode($this->input->post('transaction_info'));
		if($transaction_info == '') {
			echo 'Could not get the transaction info! <br/>';
			return 0;
		}
		$txid = $transaction_info->txid;
		$get_all_requests = $this->Request->get_all_requests_by_txid($txid);
		if($get_all_requests == null) {
			$deposit_addresses = "";
			$deposit_amounts = array();
			foreach($transaction_info->details as $row) {
				
				//27072024
				$row->address = preg_replace("/[^A-Za-z0-9 ]/", '', $row->address);
				//27072024
				
				$deposit_addresses .= "'".$row->address."', ";
				//$deposit_amounts[$row->address] = $row->amount;
				if(array_key_exists($row->address, $deposit_amounts)){
					$deposit_amounts[$row->address] += $row->amount;
				} else {
					$deposit_amounts[$row->address] = $row->amount;
				}
			}
			$deposit_addresses = trim($deposit_addresses, " ,");
			$wallets = $this->Wallet->get_all_deposit_wallets($deposit_addresses);
			if($wallets != null) {
				foreach($wallets as $wallet) {
					$user_id = $wallet->user_id;
					$user_info = $this->User->get_user_info_by_id($user_id);
					$address = $wallet->address;
					$amount = $deposit_amounts[$address];
					$amount *= $this->UNITS_PER_COIN;
					$this->Request->create_request($user_id, 'Deposit', $amount, $address, $txid);
					$this->User->update_user_info_by_id($user_info->user_id, 'processing_balance', $user_info->processing_balance + $amount);
				}
				echo '- The deposit request is being processed <br/>';
			} else {
				echo '- No wallet addresses found <br/>';
			}
		} else {
			foreach($get_all_requests as $request) {
				$user_id = $request->user_id;
				$user_info = $this->User->get_user_info_by_id($user_id);
				$request_id = $request->request_id;
				$amount = $request->amount;
				
				/*if($amount > 0) {
					if($request->type == 'Deposit') {
						$this->Request->confirm_request($request_id);
						echo '- The deposit request ('.$request_id.') is confirmed <br/>';
					} else {
						echo '- The withdrawal request ('.$request_id.') is completed <br/>';
					}
				}*/
				
				if($amount <= 0) {
					continue;
				}
				
				// gọi API check confirmations
				$api_url = "http://158.220.96.161/doge_api/check_confirmations.php?txid=" . urlencode($txid);
				$api_response = @file_get_contents($api_url);
				$confirm_data = json_decode($api_response, true);

				if(!$confirm_data || !isset($confirm_data['confirmations'])) {
					echo "- Could not fetch confirmation info for TX $txid <br/>";
					continue;
				}

				$confirmations = intval($confirm_data['confirmations']);
				$status        = $confirm_data['status'];

				if($status === "CONFLICTED") {
					// rollback nếu bị double spend
					$this->Request->cancel_deposit_request($request_id);
					$this->User->update_user_info_by_id($user_id, 'processing_balance', $user_info->processing_balance - $amount);
					echo "- The transaction $txid is conflicted. Request $request_id removed.<br/>";
					continue;
				}

				if($confirmations >= 1) {
					if($request->type == 'Deposit') {
						$this->Request->confirm_request($request_id);
						echo "- The deposit request ($request_id) is confirmed with $confirmations confirmations<br/>";
					} else {
						echo "- The withdrawal request ($request_id) is completed<br/>";
					}
				} else {
					echo "- The transaction $txid has only $confirmations confirmations. Still pending...<br/>";
				}

			}
		}
	}
	
	public function process_complete_confirmed_request() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => ''));
		} else {
			$request_id = $this->Request->get_confirmed_processing_request($this->user_info->user_id);
			
			/******/
			if($request_id == 0) {
				$get_unconfirmed_request = $this->Request->get_unconfirmed_processing_request($this->user_info->user_id);
				if($get_unconfirmed_request != null) {
					$txid = $get_unconfirmed_request->proof;
					
					$api_url = "http://158.220.96.161/doge_api/check_confirmations.php?txid=" . urlencode($txid);
					$api_response = @file_get_contents($api_url);
					$confirm_data = json_decode($api_response, true);

					$confirmations = intval($confirm_data['confirmations']);
					$status        = $confirm_data['status'];

					if($status == 'OK' && $confirmations >= 1) {
						$request_id = $get_unconfirmed_request->request_id;
					}
				}
			}
			/******/
			
			if($request_id != 0) {
				$request_info = $this->Request->get_request_info_by_id($request_id);
				$amount = $request_info->amount;
				$DOGE_price = $this->get_cryptocurrency_price('DOGE');
				$USD_value = round($amount / $this->UNITS_PER_COIN * $DOGE_price, 2);
				$this->Request->complete_deposit_request($request_id, $USD_value);
				
				$this->User->update_user_info_by_id($this->user_info->user_id, 'balance', $this->user_info->balance + $amount);
				$this->User->update_user_info_by_id($this->user_info->user_id, 'processing_balance', $this->user_info->processing_balance - $amount);
				$this->User->update_user_info_by_id($this->user_info->user_id, 'total_deposits', $this->user_info->total_deposits + $amount);
				if($this->user_info->total_deposits + $amount >= 15 * $this->UNITS_PER_COIN && $this->user_info->wagered < 100 * $this->UNITS_PER_COIN) {
					$this->User->update_user_info_by_id($this->user_info->user_id, 'wagered', 100 * $this->UNITS_PER_COIN + 1);
				}
				$this->Wallet->update_amount_transferred($request_info->address, $amount);
				$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
				$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $amount, date("Y-m-d"));
				
				$this->user_info->balance += $amount;
				echo json_encode(array('ret' => 1, 'balance' => $this->user_info->balance, 'mes' => $this->lang->print('deposit_credited_success', ($amount / $this->UNITS_PER_COIN))));
			} else {
				echo json_encode(array('ret' => 0, 'mes' => ''));
			}
		}
	}
	
	public function process_check_txs() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$deposit_address = $this->Wallet->get_deposit_address_by_user_id($this->user_info->user_id);
			if($deposit_address == '') {
				echo json_encode(array('ret' => 0, 'mes' => 'Invalid address!'));
			} else {
				$get_dep_txs = $this->Request->get_all_dep_txs_by_address($deposit_address);
				$json = json_decode(file_get_contents('https://chain.so/api/v2/get_tx_received/DOGE/'.$deposit_address));
				if($json->status == 'success'){
					$data = $json->data;
					$txs = $data->txs;
					$cnt_new_txs = 0;
					for($i = 0; $i < count($txs); $i++) {
						$txid = $txs[$i]->txid;
						$amount = $txs[$i]->value * $this->UNITS_PER_COIN;
						$chk_txid = true;
						if($get_dep_txs != null){
							for($j = 0; $j < count($get_dep_txs); $j++){
								if(strcmp($txid, $get_dep_txs[$j]->txid) == 0) {
									$chk_txid = false;
									break;
								}
							}
						}
						if($chk_txid == true) {
							$request_id = $this->Request->create_request($this->user_info->user_id, 'Deposit', $amount, $deposit_address, $txid);
							//$DOGE_price = $this->get_cryptocurrency_price('DOGE');
							$DOGE_price = $this->DOGE_price;
							$USD_value = number_format(floatval($amount / $this->UNITS_PER_COIN * $DOGE_price), 2, '.', '');
							$this->Request->complete_deposit_request($request_id, $USD_value);
							$updated_info = clone($this->user_info);
							$updated_info->total_deposits += $amount;
							$updated_info->balance += $amount;
							if($this->user_info->total_deposits + $amount >= 10000 && $this->user_info->user_level == 1) {
								$updated_info->wagered += 50001;
							}
							$this->User->update_user_info($this->user_info, $updated_info);
							$this->Wallet->update_amount_transferred($deposit_address, $amount);
							$deposits_today = $this->Statistic->get_statistic_by_date('deposits', date("Y-m-d"));
							$this->Statistic->set_statistic_by_date('deposits', $deposits_today + $amount, date("Y-m-d"));
							$cnt_new_txs++;
						}
					}
					if(count($txs) == 0) {
						echo json_encode(array('ret' => 1, 'mes' => 'You have not had any transactions yet!'));
					} else {
						if($cnt_new_txs == 0) {
							echo json_encode(array('ret' => 1, 'mes' => 'All your transactions have been credited!'));
						} else {
							echo json_encode(array('ret' => 1, 'mes' => 'You have a new transaction credited!'));
						}
					}
				}
			}
		}
		
	}
	
	public function process_switch_light_dark_mode() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			if($this->user_info->dark_mode == 0) {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'dark_mode', 1);
				$this->user_info->dark_mode = 1;
			} else {
				$this->User->update_user_info_by_id($this->user_info->user_id, 'dark_mode', 0);
				$this->user_info->dark_mode = 0;
			}
		}
	}
	
	public function process_change_language() {
		$language = strtoupper(substr($this->input->post('language'), 0, 2));
		if($language != 'EN' 
			&& $language != 'ES' 
			&& $language != 'PT' 
			&& $language != 'FR' 
			&& $language != 'RU' 
			&& $language != 'DE' 
			&& $language != 'NL' 
			&& $language != 'ZH' 
			&& $language != 'AR' 
			&& $language != 'HI' 
			&& $language != 'JA' 
			&& $language != 'BN' 
			&& $language != 'MN' 
			&& $language != 'TR' 
			&& $language != 'FA' 
			&& $language != 'UZ'
			&& $language != 'VI'
			&& $language != 'UR'
			&& $language != 'ID'
			&& $language != 'TH'
			&& $language != 'HR'
			&& $language != 'KO'
			&& $language != 'IT'
		) {
			$language = 'EN';
		}
		if($this->user_info != null) {
			$this->User->update_user_info_by_id($this->user_info->user_id, 'language', $language);
			$this->user_info->language = $language;
		}
		setcookie('language', $language, time() + (86400 * 30), "/");
	}
	
	public function process_change_email() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$new_email = strtolower(substr($this->input->post_get('new_email'), 0, 64));
			$old_email = $this->user_info->user_email;
			$password = substr($this->input->post_get('password'), 0, 32);
			
			if($this->user_info->email_verification == 1) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('verified_email_err')));
			} else if($this->User->check_password($this->user_info->user_name, $password) == 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('incorrect_password_err')));
			} else if (!filter_var($new_email, FILTER_VALIDATE_EMAIL)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_err')));
			} else if (!$this->User->check_valid_email_suplier($new_email)) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_invalid_suppliers_err')));
			} else if ($this->User->check_email_already_exists($new_email) != 0) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('email_exists_err')));
			} else {
				if($this->user_info->registered_time > time() - 86400 * 30) {
					$this->User->update_user_info_by_id($this->user_info->user_id, 'user_email', $new_email);
					$this->Log->create_log($this->user_info->user_id, 'User changes email "'.$old_email.'" to "'.$new_email.'"', $this->get_client_ip());
					echo json_encode(array('ret' => 1, 'mes' => 'Change email successfully!'));
				} else {
					echo json_encode(array('ret' => 0, 'mes' => "Sorry, you can't change your email at the moment. Please create a support ticket to request an email change."));
				}
			}
		}
	}
	
	public function process_update_deposit_transaction() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			
			if($this->input->post_get('captcha_type') != '') {
				$this->captcha_type = (intval($this->input->post_get('captcha_type')) % 5);
			}
			
			$this->validate_captcha();

			$txid = $this->input->post_get('txid');
			if(strlen($txid) > 64) {
				$this->Log->create_log($this->user_info->user_id, $txid, $this->get_client_ip());
				$txid = substr($txid, 0, 64);
			}
			if($txid == '') {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
			} else if (!$this->is_captcha_valid()) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('captcha_incorrect_err')));
			} else {
				$address = $this->Wallet->get_deposit_address_by_user_id($this->user_info->user_id);
				if($address == '') {
					echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
				} else {
					$transaction_info = $this->blockdaemon_get_transaction_info($txid);
					if($transaction_info == null) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
						return;
					}
					if(!array_key_exists($address, $transaction_info['outputs'])) {
						echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_txid_err')));
						return;
					}
					$credited_transactions = $this->Request->get_all_requests_by_txid2($txid);
					if($credited_transactions != null) {
						foreach($credited_transactions as $row) {
							if($row->address == $address) {
								echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('credited_txid_err')));
								return;
							}
						}
					}
					$user_id = $this->user_info->user_id;
					//$address = $user_wallet->address;
					$amount = $transaction_info['outputs'][$address];
					$request_id = $this->Request->create_request($user_id, 'Deposit', $amount, $address, $txid);
					$this->Request->complete_deposit_request($request_id);
					$this->User->update_user_info_by_id($this->user_info->user_id, 'balance', $this->user_info->balance + $amount);
					$this->User->update_user_info_by_id($this->user_info->user_id, 'total_deposits', $this->user_info->total_deposits + $amount);
					echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('update_transaction_success')));

				}
			}
		}
	}
	
	public function process_save_strategies() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$strategies = $this->input->post_get('strategies');
			if($strategies != '') {
				$this->Strategy->save_user_strategies($this->user_info->user_id, $strategies);
			}
		}
	}
	
	public function process_verify_pcaptcha() {
		$selected_boxes = $this->input->post('selected_boxes', true) ?? '[]';
		$verify_pcaptcha = verify_pcaptcha($selected_boxes);
		echo json_encode($verify_pcaptcha);
	}
	
	public function load() {
		$data = $this->input->post_get('data');
		try {
			switch($data) {
				case 'user_transactions':
				$this->load_user_transactions();
				break;
				case 'my_bet_data':
				$this->load_my_bet_data();
				break;
				case 'all_bet_data':
				$this->load_all_bet_data();
				break;
				case 'game_seeds':
				$this->load_game_seeds();
				break;
				case 'bet_info':
				$this->load_bet_info();
				break;
				case 'bet_info2':
				$this->load_bet_info2();
				break;
				case 'unread_count':
				$this->load_unread_count();
				break;
				case 'notifications':
				$this->load_notifications();
				break;
			}
		} catch(Exception $e) {
			//echo json_encode(array('ret' => 0, 'mes' => $e->getMessage()));
			echo json_encode(array('ret' => 0, 'mes' => 'Unknown error!'));
			return;
		}
	}
	
		
	public function load_user_transactions() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$request_type = $this->input->post_get('request_type');
			$page_id = intval($this->input->post_get('page_id'));
			$type = $this->input->post_get('type');
			$load_requests = $this->Request->load_user_transactions($this->user_info->user_id, $page_id, $type);
			if(is_array($load_requests)) {
				foreach($load_requests as $row) {
					$row->amount = number_format($row->amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
					$row->time = $this->time_elapsed_string($row->time);
					
				}
			}
			echo json_encode(array('ret' => 1, 'mes' => 'Load data successfully!', 'data' => $load_requests));
		}
	}
	
	public function load_my_bet_data() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$my_bet_data = $this->Game->load_user_bet_history($this->user_info->user_id, 1);
			if(is_array($my_bet_data)) {
				foreach($my_bet_data as $row) {
					if(date('Y-m-d', $row->date) == date('Y-m-d')) {
						$row->date =  date('H:i:s', $row->date);
					} else {
						$row->date =  date('Y-m-d', $row->date);
					}
					if($row->game == 'Dice') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'</span>';
					} else if($row->game == 'Ultimate') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_ultimate').'</span>';
					} else if ($row->game == 'Gems') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>';
					} else if ($row->game == 'Slots') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'</span>';
					} else if ($row->game == 'Mines') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>';
					} else if ($row->game == 'Poker') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'</span>';
					} else if ($row->game == 'Baccarat') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'</span>';
					} else if ($row->game == 'Hilow') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>';
					} else if ($row->game == 'Roulette') {
						$row->game = '<span title="verify" style="cursor: pointer"><img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'</span>';
					} else if ($row->game == 'Wheel') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'</span>';
					} else if ($row->game == 'Plinko') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'</span>';
					} else if ($row->game == 'Limbo') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'</span>';
					}
					$row->bet_amount = number_format($row->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
					$row->payout = '<span style="color: #03a9f4">'.number_format($row->payout, 2, '.', '').'×</span>';
					if($row->profit > 0) {
						$row->profit = '<span style="color: #38cb74">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if ($row->profit < 0) {
						$row->profit = '<span style="color: #ff5722">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$row->profit = '<span>'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
				}
			}
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('load_data_success'), 'my_bet_data' => $my_bet_data));
		}
	}
	
	public function load_all_bet_data() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$all_bet_data = $this->cache->get('all_bet_data');
			if(!$all_bet_data) {
				$all_bet_data = $this->Game->load_user_bet_history(0, 1, 'high_wins');
				$this->cache->save('all_bet_data', $all_bet_data, 10);
			}
			if(is_array($all_bet_data)) {
				foreach($all_bet_data as $row) {
					$row->timestamp = $row->date;
					if(date('Y-m-d', $row->date) == date('Y-m-d')) {
						$row->date =  date('H:i:s', $row->date);
					} else {
						$row->date =  date('Y-m-d', $row->date);
					}
					/*if($row->game == 'Dice') {
						$row->game = '<span title="verify"><i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'</span>';
					} else if($row->game == 'Ultimate') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-dice"></i> '.$this->lang->print('game_ultimate').'</span>';
					} else if ($row->game == 'Gems') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'</span>';
					} else if ($row->game == 'Slots') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'</span>';
					} else if ($row->game == 'Mines') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'</span>';
					} else if ($row->game == 'Poker') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'</span>';
					} else if ($row->game == 'Baccarat') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'</span>';
					} else if ($row->game == 'Hilow') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-sort-alt"></i> '.$this->lang->print('game_high_low').'</span>';
					} else if ($row->game == 'Roulette') {
						$row->game = '<span title="verify" style="cursor: pointer"><img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'</span>';
					} else if ($row->game == 'Wheel') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'</span>';
					} else if ($row->game == 'Plinko') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'</span>';
					} else if ($row->game == 'Limbo') {
						$row->game = '<span title="verify" style="cursor: pointer"><i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'</span>';
					}*/
					$row->bet_amount = number_format($row->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '');
					$row->payout = '<span style="color: #03a9f4">'.number_format($row->payout, 2, '.', '').'×</span>';
					if($row->profit > 0) {
						$row->profit = '<span style="color: #38cb74">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else if ($row->profit < 0) {
						$row->profit = '<span style="color: #ff5722">'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					} else {
						$row->profit = '<span>'.number_format($row->profit / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'</span>';
					}
				}
			}
			echo json_encode(array('ret' => 1, 'mes' => $this->lang->print('load_data_success'), 'all_bet_data' => $all_bet_data));
		}
	}
	
	public function load_bet_info() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$game_id = intval($this->input->post_get('game_id'));
			$bet_info = $this->Game->get_bet_info_by_id($game_id);
			if($bet_info == null) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_game_id_err')));
			} else {
				
				//28/09/2023 cheat game gems reveal server_seed//
				/*$check_allow_reveal_server_seed = $this->Game->allow_reveal_server_seed($bet_info->server_seed);
				if(!$check_allow_reveal_server_seed) {
					echo json_encode(array('ret' => 0, 'mes' => 'Please finish unfinished games!'));
					return;
				}*/
				//28/09/2023 cheat game gems reveal server_seed//
				
				if($bet_info->game_title == 'Dice') {
					if($bet_info->payout == 0) {
						$multiplier = json_decode($bet_info->prediction)->multiplier;
					} else {
						$multiplier = $bet_info->payout;
					}
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'multiplier'	=> $multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Dice',
					)));
				} else if($bet_info->game_title == 'Ultimate') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'lower_limit'	=> json_decode($bet_info->prediction)->lower_limit,
							'upper_limit'	=> json_decode($bet_info->prediction)->upper_limit,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Ultimate',
					)));
				} else if ($bet_info->game_title == 'Gems') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'title'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'difficulty'	=> json_decode($bet_info->prediction)->difficulty,
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'gems'			=> json_decode($bet_info->data)->gems,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Gems',
					)));
				} else if ($bet_info->game_title == 'Slots') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'title'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'('.json_decode($bet_info->prediction)->lines.')',
							'lines'			=> json_decode($bet_info->prediction)->lines,
							'numbers'		=> json_decode($bet_info->data)->numbers,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Slots',
					)));
				} else if ($bet_info->game_title == 'Mines') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'title'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'mines'			=> json_decode($bet_info->data)->mines,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Mines',
					)));
				} else if ($bet_info->game_title == 'Poker') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'title'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'selected_cards'=>  json_decode($bet_info->prediction)->selected_cards,
							'hand'			=>  json_decode($bet_info->prediction)->hand,
							'highlights'	=>  json_decode($bet_info->prediction)->highlights,
							'cards'			=> json_decode($bet_info->data)->cards,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Poker',
					)));
				} else if ($bet_info->game_title == 'Baccarat') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'title'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'player_cards'	=> json_decode($bet_info->data)->player_cards,
							'banker_cards'	=> json_decode($bet_info->data)->banker_cards,
							'player_total'	=> json_decode($bet_info->data)->player_total,
							'banker_total'	=> json_decode($bet_info->data)->banker_total,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Baccarat',
					)));
				} else if ($bet_info->game_title == 'Hilow') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'title'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'user_name'		=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'cards'			=> json_decode($bet_info->data)->cards,
							'selections'	=> json_decode($bet_info->prediction)->selections,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Hilow',
					)));
				} else if ($bet_info->game_title == 'Roulette') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'title'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'chips'			=> json_decode($bet_info->prediction)->chip_bet,
							'number'			=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Roulette',
					)));
				} else if ($bet_info->game_title == 'Wheel') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_wheel').'',
							'title'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_wheel').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'index'			=> json_decode($bet_info->data)->index,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Wheel',
					)));
				} else if ($bet_info->game_title == 'Plinko') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'title'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'risk'			=> json_decode($bet_info->prediction)->risk,
							'direction_idx'	=> json_decode($bet_info->data)->direction_idx,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Plinko',
					)));
				} else if ($bet_info->game_title == 'Limbo') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'',
							'title'			=> '<i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'multiplier'	=> json_decode($bet_info->prediction)->multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Limbo',
					)));
				} else if ($bet_info->game_title == 'Keno') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-border-all"></i> Keno',
							'title'			=> '<i class="fas fa-border-all"></i> Keno',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'numbers'		=> json_decode($bet_info->data)->numbers,
							'selected_numbers'		=> json_decode($bet_info->prediction)->selected_numbers,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Keno',
					)));
				} else if ($bet_info->game_title == 'Sicbo') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> Sicbo',
							'title'			=> '<i class="fas fa-dice"></i> Sicbo',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'dice'		=> json_decode($bet_info->data)->dice,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Triple',
					)));
				}
				
			}
		}
	}
	
	public function load_bet_info2() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$server_seed = $this->input->post_get('server_seed');
			$bet_info = $this->Game->get_bet_info_by_server_seed($server_seed);
			if($bet_info == null) {
				echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('invalid_game_id_err')));
			} else {

				if($bet_info->game_title == 'Dice') {
					if($bet_info->payout == 0) {
						$multiplier = json_decode($bet_info->prediction)->multiplier;
					} else {
						$multiplier = $bet_info->payout;
					}
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'multiplier'	=> $multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Dice',
					)));
				} else if($bet_info->game_title == 'Ultimate') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'title'			=> '<i class="fas fa-dice"></i> '.$this->lang->print('game_dice').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'bet_on'		=> json_decode($bet_info->prediction)->bet_on,
							'lower_limit'	=> json_decode($bet_info->prediction)->lower_limit,
							'upper_limit'	=> json_decode($bet_info->prediction)->upper_limit,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Ultimate',
					)));
				} else if ($bet_info->game_title == 'Gems') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'title'			=> '<i class="fas fa-gem"></i> '.$this->lang->print('game_gems').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'difficulty'	=> json_decode($bet_info->prediction)->difficulty,
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'gems'			=> json_decode($bet_info->data)->gems,
							'payout'		=> ($bet_info->win_amount > 0) ? number_format($bet_info->payout, 2, '.', '') : number_format(0, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Gems',
					)));
				} else if ($bet_info->game_title == 'Slots') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'title'			=> '<i class="fas fa-lemon"></i> '.$this->lang->print('game_slots').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', '').'('.json_decode($bet_info->prediction)->lines.')',
							'lines'			=> json_decode($bet_info->prediction)->lines,
							'numbers'		=> json_decode($bet_info->data)->numbers,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Slots',
					)));
				} else if ($bet_info->game_title == 'Mines') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'title'			=> '<i class="fas fa-bomb"></i> '.$this->lang->print('game_mines').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'tiles'			=> json_decode($bet_info->prediction)->tiles,
							'mines'			=> json_decode($bet_info->data)->mines,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Mines',
					)));
				} else if ($bet_info->game_title == 'Poker') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'title'			=> '<i class="fas fa-spade"></i> '.$this->lang->print('game_video_poker').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'selected_cards'=>  json_decode($bet_info->prediction)->selected_cards,
							'hand'			=>  json_decode($bet_info->prediction)->hand,
							'highlights'	=>  json_decode($bet_info->prediction)->highlights,
							'cards'			=> json_decode($bet_info->data)->cards,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Poker',
					)));
				} else if ($bet_info->game_title == 'Baccarat') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'title'			=> '<i class="fas fa-club"></i> '.$this->lang->print('game_baccarat').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'player_cards'	=> json_decode($bet_info->data)->player_cards,
							'banker_cards'	=> json_decode($bet_info->data)->banker_cards,
							'player_total'	=> json_decode($bet_info->data)->player_total,
							'banker_total'	=> json_decode($bet_info->data)->banker_total,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Baccarat',
					)));
				} else if ($bet_info->game_title == 'Hilow') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'title'			=> '<i class="fas fa-sort-alt"></i> '.$this->lang->print('game_hilow').'',
							'user_name'		=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'cards'			=> json_decode($bet_info->data)->cards,
							'selections'	=> json_decode($bet_info->prediction)->selections,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Hilow',
					)));
				} else if ($bet_info->game_title == 'Roulette') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'title'			=> '<img src="'.base_url().'assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> '.$this->lang->print('game_roulette').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'chips'			=> json_decode($bet_info->prediction)->chip_bet,
							'number'			=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Roulette',
					)));
				} else if ($bet_info->game_title == 'Wheel') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'',
							'title'			=> '<i class="fas fa-tire"></i> '.$this->lang->print('game_wof').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'index'			=> json_decode($bet_info->data)->index,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Wheel',
					)));
				} else if ($bet_info->game_title == 'Plinko') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'title'			=> '<i class="fas fa-ball-pile"></i> '.$this->lang->print('game_plinko').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'risk'			=> json_decode($bet_info->prediction)->risk,
							'direction_idx'	=> json_decode($bet_info->data)->direction_idx,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Plinko',
					)));
				} else if ($bet_info->game_title == 'Limbo') {
					echo json_encode(array('ret' => 1, 'mes' => '', 'bet_info' => array(
							'game'			=> '<i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'',
							'title'			=> '<i class="fas fa-rocket-launch"></i> '.$this->lang->print('game_limbo').'',
							'user_name'			=> $bet_info->user_name,
							'time'			=> 'on '.date('Y-m-d', $bet_info->completion_time).' at '.date('h:i A', $bet_info->completion_time),
							'bet_amount'	=> number_format($bet_info->bet_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'multiplier'	=> json_decode($bet_info->prediction)->multiplier,
							'number'		=> json_decode($bet_info->data)->number,
							'payout'		=> number_format($bet_info->payout, 2, '.', ''),
							'profit'		=> number_format($bet_info->win_amount / $this->UNITS_PER_COIN, $this->COIN_DECIMALS, '.', ''),
							'nonce'			=> $bet_info->nonce,
							'client_seed'	=> $bet_info->client_seed,
							'server_seed'	=> $bet_info->server_seed,
							'server_seed_hash'	=> hash('sha256', $bet_info->server_seed),
							'timestamp'		=> $bet_info->completion_time,
							'game_name'		=> 'Limbo',
					)));
				}
				
			}
		}
	}

	public function load_game_seeds() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$game = $this->input->post_get('game');
			switch($game) {
				case 'Dice':
				case 'Ultimate':
				case 'Slots':
				case 'Baccarat':
				case 'Roulette':
				case 'Wheel':
				case 'Plinko':
				case 'Limbo':
				case 'Triple':
				case 'Keno':
				echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
					'client_seed'	=> $this->user_info->client_seed,
					'nonce'			=> $this->user_info->nonce,
					'server_seed_hash'	=> $this->user_info->server_seed_hash,
					'change_client_seed'=> true,	
				)));
				break;
				case 'Gems':
				$game_data = $this->Game->get_last_game_data_by_uid('Gems', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //	
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));
				}
				break;
				case 'Mines':
				$game_data = $this->Game->get_last_game_data_by_uid('Mines', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //	
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));
				}
				break;
				case 'Poker':
				$game_data = $this->Game->get_last_game_data_by_uid('Poker', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //	
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));
				}
				break;
				case 'Hilow':
				$game_data = $this->Game->get_last_game_data_by_uid('Hilow', $this->user_info->user_id);
				if($game_data == null) {
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'	=> $this->user_info->client_seed,
						'nonce'			=> $this->user_info->nonce,
						'server_seed_hash'	=> $this->user_info->server_seed_hash,
						'change_client_seed'=> true,
					)));
				} else {
					// show server seed hash //
					$updated_data = clone($game_data);
					$updated_data->show_server_seed_hash = 1;
					$this->Game->update_game_data($game_data, $updated_data);
					// show server seed hash //	
					echo json_encode(array('ret' => 1, 'mes' => '', 'seeds' => array(
						'client_seed'		=> $game_data->client_seed,
						'nonce'				=> $game_data->nonce,
						'server_seed_hash'	=> $game_data->server_seed_hash,
						'change_client_seed'=> false,
					)));
				}
				break;
				default: 
				echo json_encode(array('ret' => 0, 'mes' => 'Can not load game seeds!'));
				break;
			}
			$updated_info = clone($this->user_info);
			$updated_info->show_server_seed_hash = 1  ;
			$this->User->update_user_info($this->user_info, $updated_info);
		}
	}
	
	public function get_DOGE_price() {
		$DOGE_price = $this->cache->get('DOGE_price');
		if(!isset($DOGE_price) || $DOGE_price == 0) {
			$DOGE_price =  round($this->Statistic->get_statistic_by_date('DOGE_price', date("Y-m-d")) / 10000, 4);
		}
		if($DOGE_price == 0) {
			$DOGE_price = $this->DOGE_price;
		}
		return $DOGE_price;
	}
	
	public function load_unread_count() {
		if (empty($this->user_info)) {
			echo json_encode(array(
				'ret' => 0,
				'mes' => $this->lang->print('login_required_err')
			));
			return;
		}
		$user_id   = $this->user_info->user_id;
		$last_view = $this->user_info->last_notification_view;
		$unread_count  = $this->Notification->count_unread_notifications($user_id, $last_view);
		echo json_encode(array(
			'ret' => 1,
			'unread_count'  => $unread_count
		));
	}
	
	public function load_notifications() {
		if (empty($this->user_info)) {
			echo json_encode(array(
				'ret' => 0,
				'mes' => $this->lang->print('login_required_err')
			));
			return;
		}
		$user_id   = $this->user_info->user_id;
		$notifications = $this->Notification->get_notifications_for_user($user_id);

		if (!is_array($notifications)) {
			$notifications = array();
		}

		foreach ($notifications as &$n) {
			// Nếu time trong DB là dạng timestamp (số), không cần strtotime
			$timestamp = (int)$n['time'];

			// Nếu giá trị không hợp lệ
			if ($timestamp <= 0) {
				$n['time'] = '';
				continue;
			}

			$diff = time() - $timestamp;

			if ($diff < 60) {
				$n['time'] = $diff . 's';
			} elseif ($diff < 3600) {
				$minutes = floor($diff / 60);
				$n['time'] = $minutes . 'm';
			} elseif ($diff < 86400) {
				$hours = floor($diff / 3600);
				$n['time'] = $hours . 'h';
			} elseif ($diff < 604800) {
				$days = floor($diff / 86400);
				$n['time'] = $days . 'd';
			} elseif ($diff < 2419200) {
				$weeks = floor($diff / 604800);
				$n['time'] = $weeks . 'w';
			} elseif ($diff < 31536000) {
				$months = floor($diff / 2592000);
				$n['time'] = $months . 'M';
			} else {
				$years = floor($diff / 31536000);
				$n['time'] = $years . 'y';
			}
		}
		
		$this->User->update_user_info_by_id($this->user_info->user_id, 'last_notification_view', time());
		
		echo json_encode(array(
			'ret' => 1,
			'notifications' => $notifications,
		));
	}
	
	//auto cashback 29092024
	public function auto_cashback() {
		$allow_auto_cashback = $this->isSettingEnabled('allow_auto_cashback');
		if(!$allow_auto_cashback) {
			//echo json_encode(array('ret' => 0, 'mes' => 'Auto cashback disabled'));
			return;
		}
		$user_id = $this->User->find_user_to_send_cashback();
		if($user_id != null) {
			$user_info = $this->User->get_user_info_by_id($user_id);
			if($user_info->temp_bet_balance >= 0) {
				$this->cache->save('allow_auto_cashback', 0, 8640000);
				//echo json_encode(array('ret' => 0, 'mes' => 'Temp bet balance has already reset!'));
			} else {
				$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 20));
				
				/*****************/
				$stamina_info = $this->Stamina->get_stamina_info_by_uid($user_id);
				if($stamina_info != null && $stamina_info->status == 1) {
					$cashback_amount = max(0, intval(-$user_info->temp_bet_balance / 50));
				}
				/*****************/
				
				$this->User->update_user_info_by_id($user_id, 'available_commission_balance', $user_info->available_commission_balance + $cashback_amount, 0);
				$this->User->update_user_info_by_id($user_id, 'temp_bet_balance', 0);
				$this->Bonus->insert_entry($user_id, $cashback_amount, 'Pay cashback');
				
				if($user_info->referrer != 0) {
					$get_referrer = $this->User->get_user_info_by_id($user_info->referrer);
					if($get_referrer != null) {
						//$referral_cashback_amount = $cashback_amount / 2;
						$referral_cashback_amount = $cashback_amount;
						$this->User->update_user_info_by_id($get_referrer->user_id, 'available_commission_balance', $get_referrer->available_commission_balance + $referral_cashback_amount, 0);
						$this->User->update_user_info_by_id($get_referrer->user_id, 'temp_bet_balance', max(0,  $get_referrer->temp_bet_balance - $referral_cashback_amount * 20));
						$this->Bonus->insert_entry($get_referrer->user_id, $referral_cashback_amount, 'Pay referral cashback');
					}
				}
				//echo json_encode(array('ret' => 1, 'mes' => 'Reset and pay cashback user #'.$user_id.' successfully!'));
			}
		} else {
			//echo json_encode(array('ret' => 1, 'mes' => 'Invalid user id!'));
		}
	}
	//auto cashback 29092024
	
	function get_cryptocurrency_price($symbol = 'BTC') {
		$cryptocurrency_price = $this->cache->get($symbol.'_price');
		if($cryptocurrency_price) {
			return $cryptocurrency_price;
		}

		$url = 'https://pro-api.coinmarketcap.com/v1/cryptocurrency/listings/latest';
		$parameters = [
		  'start' => '1',
		  'limit' => '5000',
		  'convert' => 'USD'
		];

		$headers = [
		  'Accepts: application/json',
		  'X-CMC_PRO_API_KEY: 6efd849d-4629-4338-9893-5dda5b214d7d'
		];
		$qs = http_build_query($parameters); // query string encode the parameters
		$request = "{$url}?{$qs}"; // create the request URL


		$curl = curl_init(); // Get cURL resource
		// Set cURL options
		curl_setopt_array($curl, array(
		  CURLOPT_URL => $request,            // set the request URL
		  CURLOPT_HTTPHEADER => $headers,     // set the headers 
		  CURLOPT_RETURNTRANSFER => 1         // ask for raw response instead of bool
		));

		$response = curl_exec($curl); // Send the request, save the response
		$response_decode = json_decode($response);
		curl_close($curl); // Close request
		for($i = 0; $i < count($response_decode->data); $i++) {
			if($response_decode->data[$i]->symbol == $symbol) {
				$cryptocurrency_price = $response_decode->data[$i]->quote->USD->price;
				$this->cache->save($symbol.'_price', $cryptocurrency_price, 10800);
				return $cryptocurrency_price;
			}
		}
		return 0;
	}
	
	public function change_server_seed() {
		if($this->user_info == null) {
			echo json_encode(array('ret' => 0, 'mes' => $this->lang->print('login_required_err')));
		} else {
			$this->Log->create_log($this->user_info->user_id, 'Duplicate server seed | Server seed: '.$this->user_info->server_seed, $this->get_client_ip());
			$new_server_seed = $this->create_random_key(64);
			$new_server_seed_hash = hash('sha256', $new_server_seed);
			$updated_info = clone($this->user_info);
			$updated_info->server_seed = $new_server_seed;
			$updated_info->server_seed_hash = $new_server_seed_hash;
			$this->User->update_user_info($this->user_info, $updated_info);	
		}
	}
	
	public function floorp($val, $precision) {
		$mult = pow(10, $precision);
		return floor($val * $mult) / $mult;
	}
	
	public function validateAddress($address){
        try {
			$decoded = $this->decodeBase58($address);
		} catch (Exception $e) {
			return false;
		}
        $d1 = hash("sha256", substr($decoded,0,21), true);
        $d2 = hash("sha256", $d1, true);
        if(substr_compare($decoded, $d2, 21, 4)){
            return false;
        }
        return true;
	}
	
	public function decodeBase58($input) {
		$alphabet = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
		$out = array_fill(0, 25, 0);
		for($i=0;$i<strlen($input);$i++){
			if(($p=strpos($alphabet, $input[$i]))===false){
				throw new \Exception("invalid character found");
			}
			$c = $p;
			for ($j = 25; $j--; ) {
				$c += (int)(58 * $out[$j]);
				$out[$j] = (int)($c % 256);
				$c /= 256;
				$c = (int)$c;
			}
			if($c != 0){
				throw new \Exception("address too long");
			}
		}
		$result = "";
		foreach($out as $val){
				$result .= chr($val);
		}
		return $result;
	}
	
	public function create_random_key($len = 8) {
		$bytes = random_bytes($len/2);
		return bin2hex($bytes);
	}

	public function create_random_key2($len = 8) {
		$alphabet = "abcdefghijklmnopqrstuvwxyz0123456789";
		$string = "";
		for($i = 0; $i < $len; $i++) {
			$string .= $alphabet[rand(0, strlen($alphabet) - 1)];
		}
		return $string;
	}
	
	function cleanStr($string){
		// Replaces all spaces with hyphens.
		$string = str_replace(' ', '-', $string);
		// Removes special chars.
		$string = preg_replace('/[^A-Za-z0-9\-]/', '', $string);
		// Replaces multiple hyphens with single one.
		$string = preg_replace('/-+/', '-', $string);
		return $string;
	}
	
	public function get_client_ip() {
		$ipaddress = '';
		if(isset($_SERVER["HTTP_CF_CONNECTING_IP"]))
			$ipaddress = $_SERVER["HTTP_CF_CONNECTING_IP"];
		else if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
		   $ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}
	
	public function time_elapsed_string($ptime) {
		$etime = abs(time() - $ptime);
		$a = array( 365 * 24 * 60 * 60  =>  'year',
					 30 * 24 * 60 * 60  =>  'month',
						  24 * 60 * 60  =>  'day',
							   60 * 60  =>  'hour',
									60  =>  'minute',
									 1  =>  'second');
		$a_plural = array( 'year'   => 'years',
						   'month'  => 'months',
						   'day'    => 'days',
						   'hour'   => 'hours',
						   'minute' => 'minutes',
						   'second' => 'seconds');
		foreach ($a as $secs => $str) {
			$d = $etime / $secs;
			if ($d >= 1) {
				$r = round($d);
				return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str);
				/*if(time() > $ptime) {
					return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str) . ' ago';
				} else {
					return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str);
				}*/
			}
		}
	}
	
	public function milliseconds() {
		$mt = explode(' ', microtime());
		return intval( $mt[1] * 1E3 ) + intval( round( $mt[0] * 1E3 ) );
	}
	
	public function remove_dots_from_email($email) {
		if (strpos($email, "@gmail.com") !== false) {
			list($username, $domain) = explode("@", $email);
			$usernameWithoutDots = str_replace(".", "", $username);
			$processedEmail = $usernameWithoutDots . "@" . $domain;
			return $processedEmail;
		} else {
			return $email;
		}
	}
	
	public function create_pagination($page_id, $total_pages, $link) {
		$page_id = min($page_id , $total_pages);
		$pagination = "";
		if($total_pages > 0) {
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p=1">First</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p=1">First</a>';
			}	
			$previous_pages = 2 + max(0, ($page_id + 2) - $total_pages);
			$next_pages = 2 + max(0, 3 - $page_id);
			for($i = max(1, $page_id - $previous_pages); $i < $page_id; $i++) {
				if (strpos($link, '?') !== false) {
					$pagination .= '<a href="'.$link.'&p='.$i.'">'.$i.'</a>';
				} else {
					$pagination .= '<a href="'.$link.'/?p='.$i.'">'.$i.'</a>';
				}
			}
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p='.$page_id.'" class="active">'.$page_id.'</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p='.$page_id.'" class="active">'.$page_id.'</a>';
			}
			
			for($i = $page_id + 1; $i <= min($total_pages, $page_id + $next_pages); $i++) {
				if (strpos($link, '?') !== false) {
					$pagination .= '<a href="'.$link.'&p='.$i.'">'.$i.'</a>';
				} else {
					$pagination .= '<a href="'.$link.'/?p='.$i.'">'.$i.'</a>';
				}
			}
			if (strpos($link, '?') !== false) {
				$pagination .= '<a href="'.$link.'&p='.$total_pages.'">Last</a>';
			} else {
				$pagination .= '<a href="'.$link.'/?p='.$total_pages.'">Last</a>';
			}
		}
		return $pagination;	
	}
	
	public function update_contest_data() {
		date_default_timezone_set("UTC");
		$day = date('w');
		if($day == 0) {
			$day = 7;
		}
		$week_start = strtotime('-'.($day-1).' days midnight');
		$week_end = strtotime('+'.(8-$day).' days midnight');

		// wagered contest
		$wagering_contest = $this->User->get_wagering_contest($week_start, $week_end);
		$total_wagered = 0;
		foreach($wagering_contest as $row) {
			$total_wagered += $row->wagered_this_week;
		}
		$total_wagered = min($total_wagered, 3000000 * $this->UNITS_PER_COIN);

		for($i = 0; $i < count($wagering_contest); $i++) {
			switch($i) {
				case 0:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 200) + 2000 * $this->UNITS_PER_COIN;
				break;
				case 1:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 500) + 1500 * $this->UNITS_PER_COIN;
				break;
				case 2:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 700) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 3:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 1000) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 4:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 2000) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 5:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 3000) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 6:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 4000) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 7:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 5000) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 8:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 6000) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 9:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 7000) + 1000 * $this->UNITS_PER_COIN;
				break;
				case 10:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 8000) + 500 * $this->UNITS_PER_COIN;
				break;
				case 11:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 9000) + 400 * $this->UNITS_PER_COIN;
				break;
				case 12:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 10000) + 300 * $this->UNITS_PER_COIN;
				break;
				case 13:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 12000) + 200 * $this->UNITS_PER_COIN;
				break;
				case 14:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 14000) + 100 * $this->UNITS_PER_COIN;
				break;
				case 15:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 16000) + 90 * $this->UNITS_PER_COIN;
				break;
				case 16:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 18000) + 80 * $this->UNITS_PER_COIN;
				break;
				case 17:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 20000) + 70 * $this->UNITS_PER_COIN;
				break;
				case 18:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 22000) + 60 * $this->UNITS_PER_COIN;
				break;
				case 19:
				$wagering_contest[$i]->reward = intval($total_wagered * 1 / 24000) + 50 * $this->UNITS_PER_COIN;
				break;
			}
			
		}
		
		// referral contest
		$referral_contest = $this->User->get_referral_contest($week_start, $week_end);
		if($referral_contest != null) {
			$total_wagered = 0;
			foreach($referral_contest as $row) {
				$total_wagered += $row->total_wagered;
			}
			$total_wagered = min($total_wagered, 3000000 * $this->UNITS_PER_COIN);
			for($i = 0; $i < count($referral_contest); $i++) {
				switch($i) {
					case 0:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 400) + 1000 * $this->UNITS_PER_COIN;
					break;
					case 1:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 600) + 750 * $this->UNITS_PER_COIN;
					break;
					case 2:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 1200) + 500 * $this->UNITS_PER_COIN;
					break;
					case 3:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 2000) + 500 * $this->UNITS_PER_COIN;
					break;
					case 4:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 4000) + 500 * $this->UNITS_PER_COIN;
					break;
					case 5:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 6000) + 500 * $this->UNITS_PER_COIN;
					break;
					case 6:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 8000) + 500 * $this->UNITS_PER_COIN;
					break;
					case 7:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 10000) + 500 * $this->UNITS_PER_COIN;
					break;
					case 8:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 12000) + 500 * $this->UNITS_PER_COIN;
					break;
					case 9:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 14000) + 500 * $this->UNITS_PER_COIN;
					break;
					case 10:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 16000) + 400 * $this->UNITS_PER_COIN;
					break;
					case 11:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 18000) + 300 * $this->UNITS_PER_COIN;
					break;
					case 12:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 20000) + 200 * $this->UNITS_PER_COIN;
					break;
					case 13:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 22000) + 100 * $this->UNITS_PER_COIN;
					break;
					case 14:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 24000) + 90 * $this->UNITS_PER_COIN;
					break;
					case 15:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 26000) + 80 * $this->UNITS_PER_COIN;
					break;
					case 16:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 28000) + 70 * $this->UNITS_PER_COIN;
					break;
					case 17:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 30000) + 60 * $this->UNITS_PER_COIN;
					break;
					case 18:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 32000) + 50 * $this->UNITS_PER_COIN;
					break;
					case 19:
					$referral_contest[$i]->reward = intval($total_wagered * 1 / 34000) + 40 * $this->UNITS_PER_COIN;
					break;
				}
				
			}
		}
		
		if($wagering_contest != null && $referral_contest != null) {
			$this->Contest->update_contest_data(json_encode(array(
				'wagering_contest'	=> $wagering_contest,
				'referral_contest'	=> $referral_contest
			)));
		}
	}
	
	public function update_wagered_this_week() {
		if(rand(0, 50) != 1) {
			return;
		}

		$bet_bots = array(
			array(30588, 30590, 30600, 30602, 30603, 30604, 30606, 30608, 30609, 30619, 30620, 30627, 30631, 30633, 30636, 30637, 30640, 30643, 30645, 30647, 30658, 30662, 30664, 30672, 30677, 30678, 30679, 30684, 30686, 30691, 30696, 30699, 30710, 30713, 30714, 30715, 30716, 30728, 30737, 30738, 30739, 30743, 30745, 30746, 30761, 30764, 30765, 30768, 30769, 30775),
			array(30645, 30714, 30677, 30765, 30643, 30647, 30640, 30608, 30603, 30619, 30775, 30658, 30761, 30636, 30769, 30662, 30678, 30633, 30745, 30600, 30620, 30627, 30737, 30739, 30715, 30672, 30684, 30696, 30686, 30728, 30679, 30637, 30746, 30604, 30602, 30710, 30716, 30606, 30588, 30743, 30631, 30699, 30738, 30764, 30713, 30768, 30609, 30590, 30691, 30664),
			array(30677, 30728, 30769, 30604, 30684, 30713, 30606, 30691, 30664, 30765, 30739, 30658, 30647, 30768, 30662, 30637, 30645, 30710, 30627, 30602, 30738, 30590, 30716, 30714, 30699, 30620, 30588, 30775, 30678, 30619, 30603, 30679, 30643, 30737, 30600, 30696, 30672, 30764, 30746, 30686, 30609, 30761, 30715, 30631, 30608, 30633, 30745, 30743, 30640, 30636),
			array(30768, 30691, 30699, 30679, 30590, 30608, 30765, 30606, 30745, 30684, 30662, 30643, 30738, 30677, 30715, 30764, 30775, 30603, 30728, 30714, 30739, 30627, 30737, 30636, 30672, 30588, 30609, 30664, 30640, 30631, 30633, 30696, 30600, 30678, 30619, 30743, 30716, 30713, 30710, 30658, 30604, 30637, 30746, 30620, 30761, 30647, 30602, 30645, 30769, 30686),
			array(30633, 30743, 30647, 30602, 30603, 30768, 30608, 30664, 30765, 30710, 30662, 30619, 30699, 30645, 30746, 30728, 30631, 30684, 30678, 30686, 30672, 30745, 30640, 30637, 30713, 30714, 30590, 30739, 30691, 30609, 30604, 30636, 30764, 30600, 30643, 30627, 30738, 30620, 30761, 30696, 30715, 30588, 30775, 30769, 30658, 30677, 30679, 30606, 30737, 30716),
			array(30647, 30672, 30716, 30609, 30745, 30713, 30603, 30765, 30710, 30728, 30627, 30679, 30643, 30600, 30677, 30769, 30619, 30775, 30664, 30604, 30699, 30606, 30678, 30714, 30620, 30684, 30588, 30696, 30640, 30662, 30737, 30764, 30768, 30590, 30738, 30645, 30658, 30608, 30691, 30715, 30631, 30743, 30633, 30637, 30636, 30746, 30602, 30761, 30686, 30739),
			array(30769, 30716, 30608, 30728, 30658, 30627, 30764, 30609, 30684, 30664, 30775, 30738, 30768, 30640, 30739, 30637, 30696, 30602, 30604, 30715, 30588, 30765, 30710, 30645, 30643, 30745, 30600, 30636, 30743, 30631, 30662, 30699, 30737, 30590, 30713, 30672, 30620, 30603, 30633, 30619, 30714, 30686, 30678, 30679, 30746, 30606, 30761, 30677, 30647, 30691),
			array(30761, 30765, 30696, 30745, 30606, 30764, 30713, 30603, 30699, 30664, 30588, 30714, 30728, 30633, 30604, 30775, 30643, 30647, 30602, 30619, 30672, 30746, 30686, 30608, 30769, 30679, 30716, 30636, 30645, 30662, 30631, 30710, 30684, 30737, 30600, 30715, 30738, 30590, 30739, 30609, 30640, 30691, 30620, 30743, 30637, 30677, 30678, 30627, 30658, 30768),
			array(30714, 30713, 30645, 30686, 30664, 30600, 30608, 30627, 30765, 30710, 30684, 30761, 30643, 30696, 30662, 30745, 30602, 30640, 30609, 30768, 30691, 30633, 30764, 30769, 30743, 30603, 30606, 30604, 30738, 30677, 30716, 30672, 30737, 30631, 30699, 30620, 30679, 30728, 30590, 30636, 30647, 30658, 30746, 30619, 30637, 30588, 30775, 30715, 30678, 30739),
			array(30679, 30714, 30696, 30647, 30746, 30619, 30620, 30658, 30710, 30603, 30645, 30713, 30684, 30602, 30699, 30677, 30631, 30743, 30737, 30627, 30765, 30775, 30728, 30686, 30633, 30604, 30600, 30768, 30609, 30761, 30662, 30745, 30678, 30637, 30588, 30672, 30764, 30715, 30590, 30716, 30640, 30606, 30608, 30769, 30636, 30738, 30739, 30643, 30691, 30664)
		);
		
		$get_current_week = date('W');
		$bet_bots = $bet_bots[$get_current_week % 10];
		$referral_bots = array(31613, 31621, 31623, 31624, 31628, 31629, 31630, 31637, 31640, 31643, 31678, 31683, 31694, 31708, 31722, 31723, 31731, 31739, 31742, 31748);
		$get_rand_id = rand(0, count($bet_bots) - 1);
		$get_user_info = $this->User->get_user_info_by_id($bet_bots[$get_rand_id]);
		if($get_user_info != null) {
			$updated_info = clone($get_user_info);
			if($get_user_info->referrer == 0) {
				$updated_info->referrer = $referral_bots[rand(0, count($referral_bots)  - 1)];
			}

			if($get_rand_id < 1) {
				$bet_amount = rand(500000000, 3000000000);
			} else if($get_rand_id < 2) {
				$bet_amount = rand(500000000, 2500000000);
			} else if($get_rand_id < 3) {
				$bet_amount = rand(400000000, 1500000000);
			} else if($get_rand_id < 4) {
				$bet_amount = rand(300000000, 1000000000);
			} else if($get_rand_id < 5) {
				$bet_amount = rand(250000000, 1000000000);
			} else if($get_rand_id < 6) {
				$bet_amount = rand(200000000, 1000000000);
			} else if($get_rand_id < 7) {
				$bet_amount = rand(150000000, 1000000000);
			} else if($get_rand_id < 10) {
				$bet_amount = rand(100000000, 1000000000);
			} else if($get_rand_id < 13) {
				$bet_amount = rand(100000000, 500000000);
			} else if($get_rand_id < 14) {
				$bet_amount = rand(50000000, 400000000);
			} else if($get_rand_id < 16) {
				$bet_amount = rand(50000000, 300000000);
			} else if($get_rand_id < 17) {
				$bet_amount = rand(50000000, 200000000);
			} else if($get_rand_id < 19) {
				$bet_amount = rand(50000000, 100000000);
			} else if($get_rand_id < 20) {
				$bet_amount = rand(50000000, 100000000);
			} else {
				$bet_amount = rand(5000000, 10000000);
			}
			
			
			if(date('w', time()) == 1) {
				$bet_amount *= 500;
			} else if(date('w', time()) == 2) {
				$bet_amount *= 550;
			} else if(date('w', time()) == 3) {
				$bet_amount *= 600;
			} else if(date('w', time()) == 4) {
				$bet_amount *= 650;
			} else if(date('w', time()) == 5) {
				$bet_amount *= 1000;
			} else if(date('w', time()) == 6) {
				$bet_amount *= 1500;
			} else if(date('w', time()) == 7) {
				$bet_amount *= 3000;
			}
			
			//$bet_amount = intval($bet_amount * (1000 + rand(0, 50)) / 1000);
			
			
			if(date("W", $get_user_info->last_bet_time) == date("W", time())) {
				$updated_info->wagered_this_week  += $bet_amount;
			} else {
				$updated_info->wagered_this_week  = $bet_amount;
			}
			
			if(date("m", $get_user_info->last_bet_time) == date("m", time())) {
				$updated_info->wagered_this_month  += $bet_amount;
			} else {
				$updated_info->wagered_this_month  = $bet_amount;
			}

			$updated_info->wagered   += $bet_amount;
			$updated_info->last_bet_time    = time();
			$this->User->update_user_info($get_user_info, $updated_info);
		}
		
	}
	
	public function encodeString($string, $shift = 7) {
		$encodedString = '';
		$stringLength = strlen($string);
		for ($i = 0; $i < $stringLength; $i++) {
			$character = $string[$i];
			// Check if the character is an alphabet letter (a-z) or a digit (0-9)
			if (ctype_alpha($character)) {
				$isUpperCase = ctype_upper($character);
				$newCharacter = chr((ord($character) + $shift - ($isUpperCase ? ord('A') : ord('a'))) % 26 + ($isUpperCase ? ord('A') : ord('a')));
				$encodedString .= $newCharacter;
			} else if (ctype_digit($character)) {
				$newCharacter = chr((ord($character) + $shift - ord('0')) % 10 + ord('0'));
				$encodedString .= $newCharacter;
			} else {
				// If the character is not an alphabet letter or a digit, keep it unchanged
				$encodedString .= $character;
			}
		}
		return $encodedString;
	}

	public function decodeString($string, $shift = 7) {
		$decodedString = '';
		$stringLength = strlen($string);
		for ($i = 0; $i < $stringLength; $i++) {
			$character = $string[$i];
			// Check if the character is an alphabet letter (a-z) or a digit (0-9)
			if (ctype_alpha($character)) {
				$isUpperCase = ctype_upper($character);
				$newCharacter = chr((ord($character) - $shift - ($isUpperCase ? ord('A') : ord('a')) + 26) % 26 + ($isUpperCase ? ord('A') : ord('a')));
				$decodedString .= $newCharacter;
			} else if (ctype_digit($character)) {
				$newCharacter = chr((ord($character) - $shift - ord('0') + 10) % 10 + ord('0'));
				$decodedString .= $newCharacter;
			} else {
				// If the character is not an alphabet letter or a digit, keep it unchanged
				$decodedString .= $character;
			}
		}
		return $decodedString;
	}
	
	public function write_log() {
		if($this->user_info == null) {
			$user_id = 0;
		} else {
			$user_id = $this->user_info->user_id;
		}
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$post_data = json_encode($_POST);
		} else {
			$post_data = '-';
		}
		$ip_address = $this->get_client_ip();
		$user_agent = $_SERVER['HTTP_USER_AGENT'];
		$current_time = date('Y-m-d H:i:s');
		$log_file = 'logs/custom_log_' . date('Y-m-d_H') . ((date('H') < 12) ? '_AM.log' : '_PM.log');
		$log_entry = "[$current_time] [$ip_address] [$user_id] [$post_data]\n";
		file_put_contents($log_file, $log_entry, FILE_APPEND);
	}
	
	function blockdaemon_get_transaction_info($txid){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://svc.blockdaemon.com/universal/v1/dogecoin/mainnet/tx/'.$txid);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'X-API-Key: zpka_48f5dbf4877a43f188d566c1f90f7cdb_5db01d81', //gabrielfatima145@gmail.com
			'accept: application/json'
		]);
		$response = curl_exec($ch);

		if (curl_errno($ch)) {
			//echo 'Error:' . curl_error($ch);
			curl_close($ch);
			return null;
		} else {
			curl_close($ch);
			$transaction_info = json_decode($response);
			if(!isset($transaction_info->events) || !is_array($transaction_info->events)) {
				return null;
			}
			$events = $transaction_info->events;
			$outputs = array();
			for($i = 0; $i < count($events); $i++) {
				if($events[$i]->type == 'utxo_output') {
					$address = $events[$i]->destination;
					$amount = $events[$i]->amount;
					if(array_key_exists($address, $outputs)) {
						$outputs[$address] += $amount;
					} else {
						$outputs[$address] = $amount;
					}
				}
			}
			return array(
				'txid' => $transaction_info->id,
				'outputs' => $outputs,
				'time' => $transaction_info->date,
			);
		}
		
	}
	
	public function contains_spam_words($input) {
		if($this->user_info != null && ($this->user_info->total_deposits - $this->user_info->total_withdrawals > 100 * $this->UNITS_PER_COIN || $this->user_info->total_bonuses > 100 * $this->UNITS_PER_COIN)) {
			return false;
		}
		$spamWords = ['gift', 'code', 'card', 'happy',  'new year', 'merry christmas', 'xmas', 'cadeau'];
		$input = mb_strtolower(trim($input));
		foreach ($spamWords as $word) {
			$word = mb_strtolower(trim($word));
			if (strpos($input, $word) !== false) {
				return true;
			}
		}
		return false;
	}
	
	//stamina feature
	public function update_user_stamina($bet_amount) {
		$stamina_info = $this->Stamina->get_stamina_info_by_uid($this->user_info->user_id);
		if($stamina_info != null && $stamina_info->status == 1) {
			if($stamina_info->accumulated_bet + $bet_amount >= $stamina_info->target_bet) {
				$this->Stamina->fullfill_stamina($this->user_info->user_id);
			} else {
				$this->Stamina->update_accumulated_bet($this->user_info->user_id, $bet_amount);
			}
		}
	}
	//stamina feature
	
	//validateMousePosition
	public function validateMousePosition($encodedData, $key) {
		$encryptedData = base64_decode($encodedData);
		$decryptedData = '';

		for ($i = 0; $i < strlen($encryptedData); $i++) {
			$decryptedData .= chr(ord($encryptedData[$i]) ^ ord($key[$i % strlen($key)]));
		}

		list($x, $y, $timestamp) = explode(':', $decryptedData);

		$x = (int)$x;
		$y = (int)$y;
		$timestamp = (int)$timestamp;

		/*if ($x < 0 || $x > 300) {
			$this->Log->create_log($this->user_info->user_id, $decryptedData, $this->get_client_ip());
			return 0;
		}

		if ($y < 0 || $y > 45) {
			$this->Log->create_log($this->user_info->user_id, $decryptedData, $this->get_client_ip());
			return 0;
		}*/

		$currentTimestamp = time();
		$timeDifference = abs($currentTimestamp - $timestamp);
		
		if ($timeDifference > 1800) {
			$this->Log->create_log($this->user_info->user_id, $decryptedData, $this->get_client_ip());
			return 0;
		}
		return 1;
	}
	
	function decodeMousePosition($encodedData, $key) {
		$encryptedData = base64_decode($encodedData);
		$decryptedData = '';
		for ($i = 0; $i < strlen($encryptedData); $i++) {
			$decryptedData .= chr(ord($encryptedData[$i]) ^ ord($key[$i % strlen($key)]));
		}
		list($x, $y, $timestamp) = explode(':', $decryptedData);
		return array(
			'x' => number_format($x, 3, '.', ''),
			'y'	=> number_format($y, 3, '.', '')
		);
	}
	//validateMousePosition
	
	private function validate_captcha() {
		$this->captcha_result = null;
		
		switch ($this->captcha_type) {
			case 0: // IconCaptcha
				$options = require 'iconcaptcha/examples/captcha-config.php';
				$iconcaptcha = new IconCaptcha($options);
				$this->captcha_result = $iconcaptcha->validate($_POST);
				break;

			case 1: // reCAPTCHA
				if (isset($_POST['g-recaptcha-response'])) {
					$response = $_POST['g-recaptcha-response'];
					$data = [
						'secret' => $this->gg_secret_key,
						'response' => $response,
						'remoteip' => $this->get_client_ip(),
					];
					$output = file_get_contents('https://www.google.com/recaptcha/api/siteverify?' . http_build_query($data));
					$this->captcha_result = json_decode($output);
				}
				break;

			case 2: // hCaptcha
				if (isset($_POST['h-captcha-response'])) {
					$response = $_POST['h-captcha-response'];
					$data = [
						'secret' => $this->hcaptcha_secret_key,
						'response' => $response,
					];
					$ch = curl_init("https://hcaptcha.com/siteverify");
					curl_setopt($ch, CURLOPT_POST, true);
					curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					$this->captcha_result = json_decode(curl_exec($ch));
					curl_close($ch);
				}
				break;

			case 3: // Cloudflare Turnstile
				if (isset($_POST['c_captcha_response'])) {
					$response = $_POST['c_captcha_response'];
					$data = [
						'secret' => $this->cloudflare_secret_key,
						'response' => $response,
						'remoteip' => $_SERVER['REMOTE_ADDR']
					];
					$ch = curl_init('https://challenges.cloudflare.com/turnstile/v0/siteverify');
					curl_setopt($ch, CURLOPT_POST, true);
					curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					$this->captcha_result = json_decode(curl_exec($ch));
					curl_close($ch);
				}
				break;
				
			case 4: // PCaptcha
				$token = $_POST['pcaptcha_token'] ?? null;

				$expected = $this->session->userdata('pcaptcha_token');
				$verified = $this->session->userdata('pcaptcha_verified');
				$verified_time = $this->session->userdata('pcaptcha_verified_time');

				if (empty($token) || $token !== $expected) {
					break;
				}
				if (!$verified) {
					break;
				}
				if ((time() - (int)$verified_time) > 60) {
					break;
				}

				$this->captcha_result = (object)['success' => true];
				break;
		}
	}
	
	private function is_captcha_valid() {
		switch ($this->captcha_type) {
			case 0:
				return $this->captcha_result && $this->captcha_result->success();
			case 1:
			case 2:
			case 3:
			case 4:
				return $this->captcha_result && isset($this->captcha_result->success) && $this->captcha_result->success === true;
			default:
				return false;
		}
	}
	
	/**
     * Enable a setting (Set value to 1)
     * If the key does not exist, it will be added.
     * If the key exists but has a value of 0, it will be updated to 1.
     */
	public function enableSetting($key) {
        $settings = $this->read_settings();
        
        if (!isset($settings[$key]) || $settings[$key] == 0) {
            $settings[$key] = 1; // Add new or update to 1
        }

        $this->write_settings($settings);
        //echo "✅ `$key` has been enabled (set to 1)";
    }

    /**
     * Disable a setting (Set value to 0)
     * If the key exists and has a value of 1, it will be updated to 0.
     */
    public function disableSetting($key) {
        $settings = $this->read_settings();

        if (isset($settings[$key]) && $settings[$key] == 1) {
            $settings[$key] = 0;
        }

        $this->write_settings($settings);
       // echo "✅ `$key` has been disabled (set to 0)";
    }

    /**
     * Check if a setting is enabled
     * Returns true if the key exists and its value is 1
     * Returns false if the key is 0 or does not exist.
     */
    public function isSettingEnabled($key) {
        $settings = $this->read_settings();
        return isset($settings[$key]) && $settings[$key] == 1 ? true : false;
    }

    /**
     * Read settings from the settings.txt file and return as a key-value array
     */
    private function read_settings() {
        if (!file_exists($this->settings_file)) {
            return []; // Return an empty array if the file does not exist
        }

        $settings = [];
        $lines = file($this->settings_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        foreach ($lines as $line) {
            list($key, $value) = array_map('trim', explode('=', $line, 2));
            $settings[$key] = (int) $value; // Convert value to an integer (0 or 1)
        }

        return $settings;
    }

    /**
     * Write settings to the settings.txt file from a key-value array
     */
    private function write_settings($settings) {
        $content = "";
        foreach ($settings as $key => $value) {
            $content .= "$key = $value\n";
        }
        file_put_contents($this->settings_file, $content);
    }
	
	
    /**
     * Store a data value in the settings file
     * If the key exists, update it; otherwise, add a new entry.
     */
    public function saveSettingData($key, $value) {
        $settings = $this->read_settings();
        $settings[$key] = $value;

        $this->write_settings($settings);
        //echo "✅ `$key` has been updated to `$value`";
    }

    /**
     * Retrieve a data value from the settings file
     * Returns the value if the key exists, otherwise returns "null".
     */
    public function getSettingData($key) {
        $settings = $this->read_settings();
        return isset($settings[$key]) ? $settings[$key] : '';
    }

    /**
     * Remove a data entry from the settings file
     */
    public function removeData($key) {
        $settings = $this->read_settings();

        if (isset($settings[$key])) {
            unset($settings[$key]);
            $this->write_settings($settings);
           // echo "✅ `$key` has been removed";
        } else {
            //echo "❌ `$key` does not exist";
        }
    }
	
	public function send_async_http_request($url) {
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_TIMEOUT, 1);     // Max wait 1s
		curl_setopt($ch, CURLOPT_NOSIGNAL, 1);    // Prevent timeout bug on some systems
		curl_exec($ch);
		curl_close($ch);
	}
	
}
