<?php
	Class LangDE {
		public $langs = array(
			'under_maintenance'					=>	'Die Website wird derzeit gewartet. Bitte versuchen Sie es später erneut!',
			'connection_timeout_err'			=>	'Zeitüberschreitung bei der Verbindung, bitte versuchen Sie es später noch einmal!',
			'invalid_input_err'					=>	'Ungültige Eingabe!',
			'username_min_length_err'			=>	'Der Benutzername muss mindestens 6 Zeichen lang sein!',
			'username_max_length_err'			=>	'Der Benutzername darf höchstens 16 Zeichen lang sein!',
			'username_invalid_chars_err'		=>	'Nur alphanumerische Eingaben sind erlaubt!',
			'email_invalid_err'					=>	'Die E-Mail muss eine gültige E-Mail-Adresse sein!',
			'email_invalid_suppliers_err'		=>	'Sie dürfen diese E-Mail nicht zur Registrierung verwenden. Bitte wählen Sie eine E-Mail eines anderen Anbieters!',
			'password_min_length_err'			=>	'Das Passwort muss mindestens 6 Zeichen lang sein!',
			'password_max_length_err'			=>	'Das Passwort darf höchstens 32 Zeichen lang sein!',
			'passwords_not_match_err'			=>	'Passwörter stimmen nicht überein!',
			'captcha_incorrect_err'				=>	'Ungültiger Captcha-Code. Bitte versuchen Sie es erneut!',
			'signup_too_often_err'				=>	'Zu viele Zugriffe von dieser IP-Adresse. Bitte versuchen Sie es später erneut!',
			'username_exists_err'				=>	'Benutzername existiert bereits!',
			'email_exists_err'					=>	'E-Mail existiert bereits!',
			'country_not_allowed_err'			=>	'Land ist nicht erlaubt!',
			'undefined_err'						=>	'Etwas ist schief gelaufen!',
			'register_success'					=>	'Ihr Konto wurde erfolgreich registriert!',
			'empty_fields_err'					=>	'Alle Felder dürfen nicht leer sein!',
			'incorrect_username_or_password_err'	=>	'Bitte geben Sie den richtigen Benutzernamen oder das richtige Passwort ein!',
			'account_banned_err'				=>	'Ihr Konto wurde dauerhaft gesperrt. Grund: Verstoß gegen Richtlinien!',
			'incorrect_2FA_err'					=>	'Bitte geben Sie den richtigen 2FA-Code ein, um fortzufahren!',
			'login_success'						=>	'Erfolgreich angemeldet!',
			'send_mail_too_often_err'			=>	'Bitte warten Sie 5 Minuten, bevor Sie eine weitere E-Mail anfordern!',
			'email_not_exists_err'				=>	'Ihre E-Mail-Adresse ist nicht registriert!',
			'send_verify_email_success'			=>	'Wir haben eine E-Mail mit einem Bestätigungslink an %s gesendet. Sie müssen auf diesen Link klicken, um fortzufahren. Dieser Link läuft in 2 Stunden ab.', //$email
			'unavailable_feature_err'			=>	'Diese Funktion ist derzeit nicht verfügbar',
			'verified_email_err'				=>	'Ihre E-Mail wurde bereits verifiziert!',
			'login_required_err'				=>	'Sie müssen sich anmelden, um fortzufahren!',
			'logout_success'					=>	'Abmeldung erfolgreich!',
			'captcha_incorrect_many_times_err'	=>	'Zu viele fehlerhafte Captchas. Bitte versuchen Sie es in 10 Minuten erneut!',
			'wait_hourly_faucet'				=>	'Bitte warten Sie %d Minuten, %d Sekunden bis zum nächsten Faucet-Antrag!', //$email, $seconds
			'claim_success'						=>	'Sie haben %.8f DOGE erhalten!', //(reward / 100000000)
			'out_of_spins_err'					=>	'Keine Spins mehr verfügbar. Um weitere Spins zu erhalten, spielen Sie bitte mehr unserer Spiele!',
			'dismiss_noti_success'				=>	'Benachrichtigung erfolgreich ausgeblendet!',
			'empty_commission_balance_err'		=>	'Ihr verfügbares Provisionsguthaben ist leer!',
			'invalid_gift_code_err'				=>	'Bitte geben Sie einen gültigen Gutscheincode ein!',
			'incorrect_gift_code_err'			=>	'Dieser Gutscheincode ist ungültig oder gelöscht!',
			'used_gift_code_err'				=>	'Dieser Gutscheincode wurde bereits verwendet!',
			'apply_gift_success'				=>	'Gutscheincode erfolgreich angewendet!',
			'password_changed_success'			=>	'Passwort erfolgreich geändert!',
			'incorrect_ver_code_err'			=>	'Der Bestätigungscode existiert nicht oder ist abgelaufen!',
			'incorrect_2FA_err2'				=>	'Sie müssen einen gültigen Token angeben, um 2FA für Ihr Konto zu aktivieren!',
			'2FA_enabled_success'				=>	'2FA aktiviert!',
			'2FA_disabled_success'				=>	'2FA deaktiviert!',
			'incorrect_password_err'			=>	'Falsches Passwort!',
			'update_privacy_success'			=>	'Datenschutzeinstellungen erfolgreich aktualisiert!',
			'update_commission_share_success'	=>	'Provisionsverteilung erfolgreich aktualisiert!',
			'verification_required_err'			=>	'Bitte verifizieren Sie Ihre E-Mail, bevor Sie eine Auszahlung vornehmen!',
			'invalid_address_err'				=>	'Bitte geben Sie eine gültige Auszahlungsadresse ein!',
			'balance_not_enough_err'			=>	'Sie haben weniger als %.8f DOGE. Warten Sie auf den Mindestbetrag!', //($minimum_withdrawal / 100000000)
			'withdrawal_amount_too_less_err'	=>	'Mindestbetrag für Auszahlungen beträgt %.8f DOGE!', //($minimum_withdrawal / 100000000)
			'amount_too_much_err'				=>	'Der Auszahlungsbetrag ist höher als Ihr Kontostand!',
			'withdraw_too_often_err'			=>	'Sie versuchen es zu oft. Bitte versuchen Sie es später noch einmal!',
			'withdrawal_being_processed'		=>	'Ihr Auszahlungsantrag wird bearbeitet!',
			'withdrawal_confirmation_required'	=>	'Bitte bestätigen Sie den Auszahlungsantrag, indem Sie auf den Link in der E-Mail klicken, die wir Ihnen gesendet haben!',
			'transaction_not_exist_err'			=>	'Diese Anfrage existiert nicht!',
			'transaction_not_exist_err2'		=>	'Die Anfrage wurde storniert oder existiert nicht!',
			'transaction_canceled_success'		=>	'Ihre Anfrage wurde storniert!',
			'feature_being_upgrade'				=>	'Diese Funktion wird derzeit aufgerüstet!',
			'empty_email_err'					=>	'Bitte geben Sie Ihre E-Mail-Adresse ein!',
			'invalid_email_err'					=>	'Ihre E-Mail-Adresse ist keine gültige Adresse!',
			'empty_subject_err'					=>	'Bitte geben Sie einen Betreff ein!',
			'empty_message_err'					=>	'Bitte geben Sie eine Nachricht ein!',
			'send_message_too_often_err'		=>	'Bitte senden Sie jede Nachricht nach jeweils 1 Minute!',
			'ticket_closed'						=>	'Dieses Ticket ist geschlossen!',
			'send_message_success'				=>	'Ihre Nachricht wurde erfolgreich gesendet!',
			'empty_client_seed_err'				=>	'Bitte geben Sie Ihr Client-Seed ein!',
			'change_client_seed_success'		=>	'Client-Seed erfolgreich geändert!',
			'bet_amount_too_less_err'			=>	'Der Mindesteinsatz beträgt %.8f DOGE!', //($MIN_BET_AMOUNT / 100000000)
			'insufficient_balance_err'			=>	'Unzureichendes Guthaben!',
			'bet_amount_too_much_err'			=>	'Der Einsatzbetrag muss kleiner oder gleich %.8f DOGE sein!', //($MAX_BET_AMOUNT / 100000000)
			'min_payout_err'					=>	'Die Mindestauszahlung muss größer oder gleich %f sein!', //$MIN_PAYOUT
			'max_payout_err'					=>	'Die maximale Auszahlung muss kleiner oder gleich %f sein!', //$MAX_PAYOUT
			'min_multiplier_err' => 'Der minimale Multiplikator muss größer oder gleich %f sein!', //MIN MULTIPLIER
			'max_multiplier_err' => 'Der maximale Multiplikator muss kleiner oder gleich %f sein!', //MAX MULTIPLIER
			'select_lower_higher'				=>	'Bitte wählen Sie niedriger oder höher!',
			'select_inside_outside'				=>	'Bitte wählen Sie innen oder außen!',
			'connection_timeout'				=>	'Verbindungstimeout!',
			'create_game_err'					=>	'Kann kein neues Spiel erstellen!',
			'select_difficulty_err'				=>	'Bitte wählen Sie die Schwierigkeit!',
			'create_game_success'				=>	'Neues Spiel erfolgreich erstellt!',
			'unstarted_game_err'				=>	'Bitte klicken Sie zuerst auf Start!',
			'choose_tile_err'					=>	'Bitte wählen Sie das richtige Feld!',
			'open_a_bomb'						=>	'Sie haben eine Bombe geöffnet!',
			'open_a_gem'						=>	'Sie haben einen Edelstein geöffnet!',
			'open_all_gems'						=>	'Sie haben alle Edelsteine geöffnet!',
			'no_tiles_selected_err'				=>	'Bitte wählen Sie mindestens ein Feld!',
			'cashout_success'					=>	'Einsatz erfolgreich ausgezahlt!',
			'select_num_mines_err'				=>	'Bitte wählen Sie die Anzahl der Minen!',
			'select_num_lines_err'				=>	'Bitte wählen Sie die Anzahl der Linien!',
			'tile_chosen_err'					=>	'Dieses Feld wurde bereits gewählt!',
			'game_created_err'					=>	'Sie haben bereits ein aktives Spiel. Bitte beenden Sie dieses, bevor Sie ein neues starten!',
			'tile_limited_err'					=>	'Anzahl der Felder über dem Limit!',
			'unexpected_err'					=>	'Unerwarteter Fehler!',
			'select_player_banker_err'			=>	'Bitte wählen Sie Bankier, Spieler oder Unentschieden!',
			'invalid_start_card_err'			=>	'Ungültige Startkarte!',
			'you_lose'							=>	'Sie verlieren!',
			'open_new_card'						=>	'Sie öffnen eine neue Karte!',
			'can_not_cashout_err'				=>	'Sie können nicht auszahlen!',
			'invalid_txid_err'					=>	'Bitte geben Sie eine gültige Transaktions-ID ein!',
			'invalid_network_err'				=>	'Ungültiges Netzwerk!',
			'credited_txid_err'					=>	'Die Transaktion wurde bereits gutgeschrieben!',
			'update_transaction_success'		=>	'Transaktion erfolgreich aktualisiert!',
			'load_data_success'					=>	'Daten erfolgreich geladen!',
			'invalid_game_id_err'				=>	'Spiel-ID existiert nicht!',
			'load_game_seed_failed'				=>	'Spiel-Seed kann nicht geladen werden!',
			'deposit_credited_success'			=>	'Sie haben erfolgreich %.8f DOGE eingezahlt!', //($total_amount / 100000000)
			'game_dice'							=> 	'Würfeln',
			'game_slots'						=> 	'Spielautomaten',
			'game_gems'							=> 	'Edelsteine',
			'game_mines'						=> 	'Minen',
			'game_video_poker'					=> 	'Video-Poker',
			'game_baccarat'						=> 	'Baccarat',
			'game_high_low'						=> 	'Hoch-Niedrig',
			'game_roulette'						=> 	'Roulette',
			'game_wof'							=> 	'Glücksrad',
			'game_plinko'						=> 	'Plinko',
			'game_limbo'						=> 	'Limbo',
			'game_ultimate'						=> 	'Ultimatives Würfeln',
		);
		
		public function __construct() {}
		
		public function print($key, ...$params) {
			if (isset($this->langs[$key])) {
				if (!empty($params)) {
					return vsprintf($this->langs[$key], $params);
				}
				return $this->langs[$key];
			}
			return '';
		}
	}
?>