<?php
    Class LangFR {
        public $langs = array(
            'under_maintenance'                 =>  'Le site est en cours de maintenance. Veuillez revenir plus tard !',
            'connection_timeout_err'            =>  'Délai de connexion dépassé, veuillez réessayer plus tard !',
            'invalid_input_err'                 =>  'Entrée invalide !',
            'username_min_length_err'           =>  'Le nom d’utilisateur doit comporter au moins 6 caractères !',
            'username_max_length_err'           =>  'Le nom d’utilisateur doit comporter au maximum 16 caractères !',
            'username_invalid_chars_err'        =>  'Seulement des caractères alphanumériques !',
            'email_invalid_err'                 =>  'L’e-mail doit être une adresse valide !',
            'email_invalid_suppliers_err'       =>  'Vous ne devez pas utiliser cet e-mail pour vous inscrire. Veuillez en choisir un autre !',
            'password_min_length_err'           =>  'Le mot de passe doit comporter au moins 6 caractères !',
            'password_max_length_err'           =>  'Le mot de passe doit comporter au maximum 32 caractères !',
            'passwords_not_match_err'           =>  'Les mots de passe ne correspondent pas !',
            'captcha_incorrect_err'             =>  'Code captcha invalide. Veuillez réessayer !',
            'signup_too_often_err'              =>  'Trop de tentatives depuis cette adresse IP. Veuillez réessayer plus tard !',
            'username_exists_err'               =>  'Le nom d’utilisateur existe déjà !',
            'email_exists_err'                  =>  'L’e-mail existe déjà !',
            'country_not_allowed_err'           =>  'Pays non autorisé !',
            'undefined_err'                     =>  'Une erreur s’est produite !',
            'register_success'                  =>  'Votre compte a été enregistré avec succès !',
            'empty_fields_err'                  =>  'Tous les champs ne peuvent pas être vides !',
            'incorrect_username_or_password_err' => 'Veuillez saisir le nom d’utilisateur ou le mot de passe correct !',
            'account_banned_err'                =>  'Votre compte a été définitivement banni. Motif : violation de la politique !',
            'incorrect_2FA_err'                 =>  'Veuillez entrer le code 2FA correct pour continuer !',
            'login_success'                     =>  'Connexion réussie !',
            'send_mail_too_often_err'           =>  'Veuillez attendre 5 minutes avant de demander un autre e-mail !',
            'email_not_exists_err'              =>  'Votre adresse e-mail n’est pas enregistrée !',
            'send_verify_email_success'         =>  'Nous avons envoyé un e-mail avec un lien de confirmation à %s. Vous devez cliquer sur ce lien pour continuer. Ce lien expirera dans 2 heures.', //$email
            'unavailable_feature_err'           =>  'Cette fonctionnalité est actuellement indisponible',
            'verified_email_err'                =>  'Votre e-mail a déjà été vérifié !',
            'login_required_err'                =>  'Vous devez vous connecter pour continuer !',
            'logout_success'                    =>  'Déconnexion réussie !',
            'captcha_incorrect_many_times_err'  =>  'Échec de captcha trop de fois. Veuillez réessayer dans 10 minutes !',
            'wait_hourly_faucet'                =>  'Veuillez attendre %d minutes, %d secondes pour la prochaine demande de robinet !', //$email, $seconds
            'claim_success'                     =>  'Vous avez reçu %.8f DOGE !', //(reward / 100000000)
            'out_of_spins_err'                  =>  'Tours épuisés. Pour obtenir plus de tours bonus, veuillez jouer plus à nos jeux !',
            'dismiss_noti_success'              =>  'Notification ignorée avec succès !',
            'empty_commission_balance_err'      =>  'Votre solde de commissions disponible est vide !',
            'invalid_gift_code_err'             =>  'Veuillez entrer un code-cadeau valide !',
            'incorrect_gift_code_err'           =>  'Ce code-cadeau est invalide ou supprimé !',
            'used_gift_code_err'                =>  'Ce code-cadeau a déjà été utilisé !',
            'apply_gift_success'                =>  'Code-cadeau appliqué avec succès !',
            'password_changed_success'          =>  'Le mot de passe a été modifié avec succès !',
            'incorrect_ver_code_err'            =>  'Le code de vérification n’existe pas ou a expiré !',
            'incorrect_2FA_err2'                =>  'Vous devez fournir un jeton valide pour activer la 2FA pour votre compte !',
            '2FA_enabled_success'               =>  '2FA activée !',
            '2FA_disabled_success'              =>  '2FA désactivée !',
            'incorrect_password_err'            =>  'Mot de passe incorrect !',
            'update_privacy_success'            =>  'Confidentialité mise à jour avec succès !',
            'update_commission_share_success'   =>  'Part de commission mise à jour avec succès !',
            'verification_required_err'         =>  'Veuillez vérifier votre e-mail avant de retirer !',
            'invalid_address_err'               =>  'Veuillez entrer une adresse de retrait valide !',
            'balance_not_enough_err'            =>  'Vous avez moins de %.8f DOGE. Attendez le montant minimum !', //($minimum_withdrawal / 100000000)
            'withdrawal_amount_too_less_err'    =>  'Le montant de retrait minimum est de %.8f DOGE !', //($minimum_withdrawal / 100000000)
            'amount_too_much_err'               =>  'Le montant de retrait est supérieur au solde de votre compte !',
            'withdraw_too_often_err'            =>  'Vous essayez trop souvent. Veuillez réessayer plus tard !',
            'withdrawal_being_processed'        =>  'Votre demande de retrait est en cours de traitement !',
            'withdrawal_confirmation_required'  =>  'Veuillez confirmer la demande de retrait en cliquant sur le lien que nous vous avons envoyé par e-mail !',
            'transaction_not_exist_err'         =>  'Cette demande n’existe pas !',
            'transaction_not_exist_err2'        =>  'La demande a été annulée ou n’existe pas !',
            'transaction_canceled_success'      =>  'Votre demande a été annulée !',
            'feature_being_upgrade'             =>  'Cette fonctionnalité est en cours de mise à niveau !',
            'empty_email_err'                   =>  'Veuillez entrer votre e-mail !',
            'invalid_email_err'                 =>  'Votre e-mail n’est pas une adresse valide !',
            'empty_subject_err'                 =>  'Veuillez entrer l’objet !',
            'empty_message_err'                 =>  'Veuillez entrer le message !',
            'send_message_too_often_err'        =>  'Veuillez envoyer chaque message après 1 minute !',
            'ticket_closed'                     =>  'Ce ticket est fermé !',
            'send_message_success'              =>  'Votre message a été envoyé avec succès !',
            'empty_client_seed_err'             =>  'Veuillez entrer votre graine client !',
            'change_client_seed_success'        =>  'Graine client modifiée avec succès !',
            'bet_amount_too_less_err'           =>  'Le montant du pari doit être d’au moins %.8f DOGE !', //($MIN_BET_AMOUNT / 100000000)
            'insufficient_balance_err'          =>  'Solde insuffisant !',
            'bet_amount_too_much_err'           =>  'Le montant du pari doit être inférieur ou égal à %.8f DOGE !', //($MAX_BET_AMOUNT / 100000000)
            'min_payout_err'                    =>  'Le paiement minimum doit être supérieur ou égal à %f !', //$MIN_PAYOUT
            'max_payout_err'                    =>  'Le paiement maximum doit être inférieur ou égal à %f !', //$MAX_PAYOUT
			'min_multiplier_err' => 'Le multiplicateur minimum doit être supérieur ou égal à %f!', //MIN MULTIPLIER
			'max_multiplier_err' => 'Le multiplicateur maximum doit être inférieur ou égal à %f!', //MAX MULTIPLIER
            'select_lower_higher'               =>  'Veuillez sélectionner inférieur ou supérieur !',
            'select_inside_outside'             =>  'Veuillez sélectionner intérieur ou extérieur !',
            'connection_timeout'                =>  'Délai de connexion dépassé !',
            'create_game_err'                   =>  'Impossible de créer un nouveau jeu !',
            'select_difficulty_err'             =>  'Veuillez sélectionner la difficulté !',
            'create_game_success'               =>  'Jeu créé avec succès !',
            'unstarted_game_err'                =>  'Veuillez cliquer d’abord sur démarrer !',
            'choose_tile_err'                   =>  'Veuillez choisir la case correcte !',
            'open_a_bomb'                       =>  'Vous avez ouvert une bombe !',
            'open_a_gem'                        =>  'Vous avez ouvert une gemme !',
            'open_all_gems'                     =>  'Vous avez ouvert toutes les gemmes !',
            'no_tiles_selected_err'             =>  'Veuillez sélectionner au moins une case !',
            'cashout_success'                   =>  'Retrait du pari réussi !',
            'select_num_mines_err'              =>  'Veuillez sélectionner le nombre de mines !',
            'select_num_lines_err'              =>  'Veuillez sélectionner le nombre de lignes',
            'tile_chosen_err'                   =>  'Cette case a déjà été choisie !',
            'game_created_err'                  =>  'Vous avez déjà un jeu actif. Veuillez terminer celui-ci avant d’en commencer un nouveau !',
            'tile_limited_err'                  =>  'Nombre de cases au-delà de la limite !',
            'unexpected_err'                    =>  'Erreur inattendue !',
            'select_player_banker_err'          =>  'Veuillez sélectionner banquier, joueur ou égalité !',
            'invalid_start_card_err'            =>  'Carte de départ invalide !',
            'you_lose'                          =>  'Vous avez perdu !',
            'open_new_card'                     =>  'Vous avez ouvert une nouvelle carte !',
            'can_not_cashout_err'               =>  'Vous ne pouvez pas encaisser !',
            'invalid_txid_err'                  =>  'Veuillez entrer un ID de transaction valide !',
            'invalid_network_err'               =>  'Réseau invalide !',
            'credited_txid_err'                 =>  'La transaction a déjà été créditée !',
            'update_transaction_success'        =>  'Mise à jour de la transaction réussie !',
            'load_data_success'                 =>  'Données chargées avec succès !',
            'invalid_game_id_err'               =>  'L’identifiant du jeu n’existe pas !',
            'load_game_seed_failed'             =>  'Impossible de charger les graines du jeu !',
            'deposit_credited_success'          =>  'Vous avez déposé avec succès %.8f DOGE !', //($total_amount / 100000000)
			'game_dice'							=> 	'Dés',
			'game_slots'						=> 	'Machines à sous',
			'game_gems'							=> 	'Gemmes',
			'game_mines'						=> 	'Mines',
			'game_video_poker'					=> 	'Vidéo Poker',
			'game_baccarat'						=> 	'Baccarat',
			'game_high_low'						=> 	'Haut-Bas',
			'game_roulette'						=> 	'Roulette',
			'game_wof'							=> 	'Roue de la Fortune',
			'game_plinko'						=> 	'Plinko',
			'game_limbo'						=> 	'Limbo',
			'game_ultimate'						=> 	'Dés Ultimes',
        );
        
        public function __construct() {}
        
        public function print($key, ...$params) {
            if (isset($this->langs[$key])) {
                if (!empty($params)) {
                    return vsprintf($this->langs[$key], $params);
                }
                return $this->langs[$key];
            }
            return '';
        }
    }
?>