<?php
    Class LangIT {
        public $langs = array(
            'under_maintenance'					=>	'Il sito è in manutenzione. Per favore riprova più tardi!',
            'connection_timeout_err'			=>  'Tempo di connessione scaduto, per favore riprova più tardi!',
            'invalid_input_err'					=>  'Input non valido!',
            'username_min_length_err'			=>	'Il nome utente deve avere almeno 6 caratteri!',
            'username_max_length_err'			=>	'Il nome utente deve avere al massimo 16 caratteri!',
            'username_invalid_chars_err'		=>	'Solo input alfanumerico!',
            'email_invalid_err'					=>	"L'email deve essere valida!",
            'email_invalid_suppliers_err'		=>	"Non puoi usare questa email per registrarti. Per favore scegli l'email di altri fornitori!",
            'password_min_length_err'			=>	'La password deve avere almeno 6 caratteri!',
            'password_max_length_err'			=>	'La password deve avere al massimo 32 caratteri!',
            'passwords_not_match_err'			=>	'Le password non corrispondono!',
            'captcha_incorrect_err'				=>	'Codice captcha non valido. Per favore riprova!',
            'signup_too_often_err'				=>	'Troppe registrazioni da questo indirizzo IP. Per favore riprova più tardi!',
            'username_exists_err'				=>	'Nome utente già esistente!',
            'email_exists_err'					=>	'Email già esistente!',
            'country_not_allowed_err'			=>	'Paese non consentito!',
            'undefined_err'						=>	'Qualcosa è andato storto!',
            'register_success'					=>	'Il tuo account è stato registrato con successo!',
            'empty_fields_err'					=>	'Tutti i campi non possono essere vuoti!',
            'incorrect_username_or_password_err'=>	'Inserisci nome utente o password corretti!',
            'account_banned_err'				=>	'Il tuo account è stato permanentemente bloccato. Motivo: violazione della policy!',
            'incorrect_2FA_err'					=>	'Inserisci il codice 2FA corretto per continuare!',
            'login_success'						=>	'Accesso effettuato con successo!',
            'send_mail_too_often_err'			=>	"Aspetta 5 minuti prima di richiedere un'altra email!",
            'email_not_exists_err'				=>	"L'indirizzo email non è registrato!",
            'send_verify_email_success'			=>	"Abbiamo inviato un'email con un link di conferma a %s. Devi cliccare su questo link per continuare. Questo link scadrà tra 2 ore.", // %s: email
            'unavailable_feature_err'			=>	'Questa funzione non è attualmente disponibile',
            'verified_email_err'				=>	'La tua email è stata verificata!',
            'login_required_err'				=>	"Devi effettuare l'accesso per continuare!",
            'logout_success'					=>	'Disconnessione riuscita!',
            'captcha_incorrect_many_times_err'	=>	'Troppe volte captcha non riuscito. Riprova tra 10 minuti!',
            'wait_hourly_faucet'				=>	'Aspetta %d minuti, %d secondi per il prossimo claim!', // %d: minuti e secondi
            'claim_success'						=>	'Hai ricevuto %.8f DOGE!', // %.8f: reward / 100000000
            'out_of_spins_err'					=>	'Giri esauriti. Gioca di più per ottenere altri giri bonus!',
            'dismiss_noti_success'				=>	'Notifica ignorata con successo!',
            'empty_commission_balance_err'		=>	'Il saldo delle commissioni disponibili è vuoto!',
            'invalid_gift_code_err'				=>	'Inserisci un codice regalo valido!',
            'incorrect_gift_code_err'			=>	'Questo codice regalo non è valido o è stato eliminato!',
            'used_gift_code_err'				=>	'Questo codice regalo è già stato utilizzato!',
            'apply_gift_success'				=>	'Codice regalo applicato con successo!',
            'password_changed_success'			=>	'Password modificata con successo!',
            'incorrect_ver_code_err'			=>	'Il codice di verifica non esiste o è scaduto!',
            'incorrect_2FA_err2'				=>	'Devi fornire un token valido per abilitare il 2FA per il tuo account!',
            '2FA_enabled_success'				=>	'2FA abilitato!',
            '2FA_disabled_success'				=>	'2FA disabilitato!',
            'incorrect_password_err'			=>	'Password errata!',
            'update_privacy_success'			=>	'Privacy aggiornata con successo!',
            'update_commission_share_success'	=>	'Percentuale di commissione aggiornata con successo!',
            'verification_required_err'			=>	'Verifica la tua email prima di prelevare!',
            'invalid_address_err'				=>	'Inserisci un indirizzo di prelievo valido!',
            'balance_not_enough_err'			=>	"Hai meno di %.8f DOGE. Attendi l'importo minimo!", // %.8f: minimum_withdrawal / 100000000
            'withdrawal_amount_too_less_err'	=>	"L'importo minimo di prelievo è di %.8f DOGE!", // %.8f: minimum_withdrawal / 100000000
            'amount_too_much_err'				=>	"L'importo del prelievo è maggiore del saldo del tuo account!",
            'withdraw_too_often_err'			=>	'Stai tentando troppo spesso. Riprova più tardi!',
            'withdrawal_being_processed'		=>	'La tua richiesta di prelievo è in fase di elaborazione!',
            'withdrawal_confirmation_required'	=>	'Conferma la richiesta di prelievo cliccando sul link che ti abbiamo inviato via email!',
            'transaction_not_exist_err'			=>	'Questa richiesta non esiste!',
            'transaction_not_exist_err2'		=>	'La richiesta è stata annullata o non esiste!',
            'transaction_canceled_success'		=>	'La tua richiesta è stata annullata!',
            'feature_being_upgrade'				=>	'Questa funzione è in fase di aggiornamento!',
            'empty_email_err'					=>	'Inserisci la tua email!',
            'invalid_email_err'					=>	'La tua email non è un indirizzo email valido!',
            'empty_subject_err'					=>	"Inserisci l'oggetto!",
            'empty_message_err'					=>	'Inserisci il messaggio!',
            'send_message_too_often_err'		=>	'Invia ciascun messaggio dopo 1 minuto!',
            'ticket_closed'						=>	'Questo ticket è chiuso!',
            'send_message_success'				=>	'Messaggio inviato con successo!',
            'empty_client_seed_err'				=>	'Inserisci il tuo client seed!',
            'change_client_seed_success'		=>	'Client seed cambiato con successo!',
            'bet_amount_too_less_err'			=>	"L'importo della scommessa deve essere almeno di %.8f DOGE!", // %.8f: MIN_BET_AMOUNT / 100000000
            'insufficient_balance_err'			=>	'Saldo insufficiente!',
            'bet_amount_too_much_err'			=>	"L'importo della scommessa deve essere minore o uguale a %.8f DOGE!", // %.8f: MAX_BET_AMOUNT / 100000000
            'min_payout_err'					=>	'Il payout minimo deve essere maggiore o uguale a %f!', // %f: MIN_PAYOUT
            'max_payout_err'					=>	'Il payout massimo deve essere minore o uguale a %f!', // %f: MAX_PAYOUT
			'min_multiplier_err' => 'Il moltiplicatore minimo deve essere maggiore o uguale a %f!', //MIN MULTIPLIER
			'max_multiplier_err' => 'Il moltiplicatore massimo deve essere minore o uguale a %f!', //MAX MULTIPLIER
            'select_lower_higher'				=>	'Seleziona inferiore o superiore!',
            'select_inside_outside'				=>	'Seleziona dentro o fuori!',
            'connection_timeout'				=>	'Tempo di connessione scaduto!',
            'create_game_err'					=>	'Impossibile creare un nuovo gioco!',
            'select_difficulty_err'				=>	'Seleziona la difficoltà!',
            'create_game_success'				=>	'Nuovo gioco creato con successo!',
            'unstarted_game_err'				=>	'Clicca prima su inizia!',
            'choose_tile_err'					=>	'Scegli la tessera corretta!',
            'open_a_bomb'						=>	'Hai aperto una bomba!',
            'open_a_gem'						=>	'Hai aperto una gemma!',
            'open_all_gems'						=>	'Hai aperto tutte le gemme!',
			'no_tiles_selected_err'			=>	'Per favore seleziona almeno una tessera!',
			'cashout_success'				=>	'Scommessa incassata con successo!',
			'select_num_mines_err'			=>	'Per favore seleziona il numero di mine!',
			'select_num_lines_err'			=>	'Per favore seleziona il numero di linee!',
			'tile_chosen_err'				=>	'Questa tessera è già stata scelta!',
			'game_created_err'				=>	'Hai già un gioco attivo. Completa quello attuale prima di iniziarne uno nuovo!',
			'tile_limited_err'				=>	'Numero di tessere oltre il limite!',
			'unexpected_err'				=>	'Errore inaspettato!',
			'select_player_banker_err'		=>	'Per favore seleziona banco, giocatore o pareggio!',
			'invalid_start_card_err'		=>	'Carta di partenza non valida!',
			'you_lose'						=>	'Hai perso!',
			'open_new_card'					=>	'Hai aperto una nuova carta!',
			'can_not_cashout_err'			=>	'Non puoi incassare!',
			'invalid_txid_err'				=>	'Per favore inserisci un ID transazione valido!',
			'invalid_network_err'			=>	'Rete non valida!',
			'credited_txid_err'				=>	'La transazione è già stata accreditata!',
			'update_transaction_success'	=>	'Transazione aggiornata con successo!',
			'load_data_success'				=>	'Dati caricati con successo!',
			'invalid_game_id_err'			=>	"L'ID del gioco non esiste!",
			'load_game_seed_failed'			=>	'Impossibile caricare i semi di gioco!',
			'deposit_credited_success'		=>	'Hai depositato con successo %.8f DOGE!', //($total_amount / 100000000)
			'game_dice'						=>	'Dadi',
			'game_slots'					=>	'Slot',
			'game_gems'						=>	'Gemme',
			'game_mines'					=>	'Mine',
			'game_video_poker'				=>	'Video Poker',
			'game_baccarat'					=>	'Baccarat',
			'game_high_low'					=>	'Alto-Basso',
			'game_roulette'					=>	'Roulette',
			'game_wof'						=>	'Ruota della Fortuna',
			'game_plinko'					=>	'Plinko',
			'game_limbo'					=>	'Limbo',
			'game_ultimate'					=>	'Dadi Ultimate',
	);
		
		public function __construct() {}
		
		public function print($key, ...$params) {
			if (isset($this->langs[$key])) {
				if (!empty($params)) {
					return vsprintf($this->langs[$key], $params);
				}
				return $this->langs[$key];
			}
			return '';
		}
	}
?>