<?php
	Class LangJA {
		public $langs = array(
			'under_maintenance'					=>	'サイトは現在メンテナンス中です。後で再度お越しください！',
			'connection_timeout_err'			=>  '接続タイムアウト、後でもう一度お試しください！',
			'invalid_input_err'					=>  '無効な入力です！',
			'username_min_length_err'			=>	'ユーザー名は6文字以上である必要があります！',
			'username_max_length_err'			=>	'ユーザー名は最大16文字までです！',
			'username_invalid_chars_err'		=>	'英数字のみ入力可能です！',
			'email_invalid_err'					=>	'有効なメールアドレスを入力してください！',
			'email_invalid_suppliers_err'		=>	'このメールアドレスは使用できません。他のプロバイダーのメールアドレスを選んでください！',
			'password_min_length_err'			=>	'パスワードは6文字以上である必要があります！',
			'password_max_length_err'			=>	'パスワードは最大32文字までです！',
			'passwords_not_match_err'			=>	'パスワードが一致しません！',
			'captcha_incorrect_err'				=>	'無効なキャプチャコードです。もう一度お試しください！',
			'signup_too_often_err'				=>	'このIPアドレスからのアクセスが多すぎます。後でお試しください！',
			'username_exists_err'				=>	'このユーザー名は既に存在します！',
			'email_exists_err'					=>	'このメールアドレスは既に登録されています！',
			'country_not_allowed_err'			=>	'この国からのアクセスは許可されていません！',
			'undefined_err'						=>	'エラーが発生しました！',
			'register_success'					=>	'アカウントが正常に登録されました！',
			'empty_fields_err'					=>	'すべてのフィールドを入力してください！',
			'incorrect_username_or_password_err'	=>	'正しいユーザー名またはパスワードを入力してください！',
			'account_banned_err'				=>	'アカウントは永久に停止されました。理由：ポリシー違反！',
			'incorrect_2FA_err'					=>	'続行するには正しい2FAコードを入力してください！',
			'login_success'						=>	'ログイン成功！',
			'send_mail_too_often_err'			=>	'別のメールをリクエストする前に5分お待ちください！',
			'email_not_exists_err'				=>	'このメールアドレスは登録されていません！',
			'send_verify_email_success'			=>	'%sに確認リンクを送信しました。このリンクをクリックして続行してください。有効期限は2時間です。',
			'unavailable_feature_err'			=>	'この機能は現在利用できません',
			'verified_email_err'				=>	'メールが既に確認されています！',
			'login_required_err'				=>	'続行するにはログインが必要です！',
			'logout_success'					=>	'ログアウトしました！',
			'captcha_incorrect_many_times_err'	=>	'キャプチャの失敗が多すぎます。10分後に再試行してください！',
			'wait_hourly_faucet'				=>	'次のファウセットの請求まで%d分%d秒お待ちください！',
			'claim_success'						=>	'%.8f DOGEを獲得しました！',
			'out_of_spins_err'					=>	'スピンが不足しています。ボーナススピンをさらに獲得するには、ゲームをプレイしてください！',
			'dismiss_noti_success'				=>	'通知を正常に解除しました！',
			'empty_commission_balance_err'		=>	'利用可能なコミッション残高が空です！',
			'invalid_gift_code_err'				=>	'有効なギフトコードを入力してください！',
			'incorrect_gift_code_err'			=>	'このギフトコードは無効または削除されています！',
			'used_gift_code_err'				=>	'このギフトコードは既に使用されています！',
			'apply_gift_success'				=>	'ギフトコードが正常に適用されました！',
			'password_changed_success'			=>	'パスワードが正常に変更されました！',
			'incorrect_ver_code_err'			=>	'確認コードが存在しないか、有効期限が切れています！',
			'incorrect_2FA_err2'				=>	'アカウントに2FAを有効にするには有効なトークンが必要です！',
			'2FA_enabled_success'				=>	'2FAが有効になりました！',
			'2FA_disabled_success'				=>	'2FAが無効になりました！',
			'incorrect_password_err'			=>	'パスワードが間違っています！',
			'update_privacy_success'			=>	'プライバシーが正常に更新されました！',
			'update_commission_share_success'	=>	'コミッション共有を正常に更新しました！',
			'verification_required_err'			=>	'引き出しを行う前にメールを確認してください！',
			'invalid_address_err'				=>	'有効な引き出しアドレスを入力してください！',
			'balance_not_enough_err'			=>	'残高が不足しています（%.8f DOGE以下）。最低金額をお待ちください！',
			'withdrawal_amount_too_less_err'	=>	'最小引き出し金額は%.8f DOGEです！',
			'amount_too_much_err'				=>	'引き出し金額がアカウント残高を超えています！',
			'withdraw_too_often_err'			=>	'引き出しのリクエストが多すぎます。後でお試しください！',
			'withdrawal_being_processed'		=>	'引き出しリクエストは処理中です！',
			'withdrawal_confirmation_required'	=>	'送信されたメール内のリンクをクリックして、引き出しリクエストを確認してください！',
			'transaction_not_exist_err'			=>	'このリクエストは存在しません！',
			'transaction_not_exist_err2'		=>	'リクエストがキャンセルされたか、存在しません！',
			'transaction_canceled_success'		=>	'リクエストがキャンセルされました！',
			'feature_being_upgrade'				=>	'この機能は現在アップグレード中です！',
			'empty_email_err'					=>	'メールアドレスを入力してください！',
			'invalid_email_err'					=>	'有効なメールアドレスを入力してください！',
			'empty_subject_err'					=>	'件名を入力してください！',
			'empty_message_err'					=>	'メッセージを入力してください！',
			'send_message_too_often_err'		=>	'各メッセージを送信する間に1分待ってください！',
			'ticket_closed'						=>	'このチケットはクローズされました！',
			'send_message_success'				=>	'メッセージが正常に送信されました！',
			'empty_client_seed_err'				=>	'クライアントシードを入力してください！',
			'change_client_seed_success'		=>	'クライアントシードが正常に変更されました！',
			'bet_amount_too_less_err'			=>	'ベット額は少なくとも%.8f DOGEである必要があります！',
			'insufficient_balance_err'			=>	'残高が不足しています！',
			'bet_amount_too_much_err'			=>	'ベット額は最大%.8f DOGEまでです！',
			'min_payout_err'					=>	'最小ペイアウトは%f以上である必要があります！',
			'max_payout_err'					=>	'最大ペイアウトは%f以下である必要があります！',
			'min_multiplier_err' => '最小マルチプライヤーは%f以上である必要があります！', //MIN MULTIPLIER
			'max_multiplier_err' => '最大マルチプライヤーは%f以下である必要があります！', //MAX MULTIPLIER
			'select_lower_higher'				=>	'低いまたは高いを選択してください！',
			'select_inside_outside'				=>	'内側または外側を選択してください！',
			'connection_timeout'				=>	'接続タイムアウト！',
			'create_game_err'					=>	'新しいゲームを作成できません！',
			'select_difficulty_err'				=>	'難易度を選択してください！',
			'create_game_success'				=>	'新しいゲームが正常に作成されました！',
			'unstarted_game_err'				=>	'最初に「開始」をクリックしてください！',
			'choose_tile_err'					=>	'正しいタイルを選択してください！',
			'open_a_bomb'						=>	'爆弾を開けました！',
			'open_a_gem'						=>	'宝石を開けました！',
			'open_all_gems'						=>	'すべての宝石を開けました！',
			'no_tiles_selected_err'				=>	'少なくとも1つのタイルを選択してください！',
			'cashout_success'					=>	'ベットが正常にキャッシュアウトされました！',
			'select_num_mines_err'				=>	'地雷の数を選択してください！',
			'select_num_lines_err'				=>	'ラインの数を選択してください',
			'tile_chosen_err'					=>	'このタイルは既に選択されています！',
			'game_created_err'					=>	'すでにアクティブなゲームがあります。新しいゲームを始める前にそれを終了してください！',
			'tile_limited_err'					=>	'タイルの数が制限を超えています！',
			'unexpected_err'					=>	'予期しないエラーです！',
			'select_player_banker_err'			=>	'バンカー、プレイヤー、またはタイを選択してください！',
			'invalid_start_card_err'			=>	'無効なスタートカードです！',
			'you_lose'							=>	'負けました！',
			'open_new_card'						=>	'新しいカードを開けました！',
			'can_not_cashout_err'				=>	'キャッシュアウトできません！',
			'invalid_txid_err'					=>	'有効なトランザクションIDを入力してください！',
			'invalid_network_err'				=>	'無効なネットワークです！',
			'credited_txid_err'					=>	'トランザクションはすでにクレジットされています！',
			'update_transaction_success'		=>	'トランザクションが正常に更新されました！',
			'load_data_success'					=>	'データが正常に読み込まれました！',
			'invalid_game_id_err'				=>	'ゲームIDが存在しません！',
			'load_game_seed_failed'				=>	'ゲームシードを読み込めません！',
			'deposit_credited_success'			=>	'%.8f DOGEが正常に入金されました！',
			'game_dice'							=> 'ダイス',
			'game_slots'						=> 'スロット',
			'game_gems'							=> 'ジェム',
			'game_mines'						=> 'マイン',
			'game_video_poker'					=> 'ビデオポーカー',
			'game_baccarat'						=> 'バカラ',
			'game_high_low'						=> 'ハイロー',
			'game_roulette'						=> 'ルーレット',
			'game_wof'							=> '運命の輪',
			'game_plinko'						=> 'プリンク',
			'game_limbo'						=> 'リンボ',
			'game_ultimate'						=> 'アルティメットダイス',
		);
		
		public function __construct() {}
		
		public function print($key, ...$params) {
			if (isset($this->langs[$key])) {
				if (!empty($params)) {
					return vsprintf($this->langs[$key], $params);
				}
				return $this->langs[$key];
			}
			return '';
		}
	}
?>