<?php
Class LangNL {
	public $langs = array(
		'under_maintenance'					=>	'De site is in onderhoud. Kom later terug!',
		'connection_timeout_err'			=>  'Verbindingstime-out, probeer het later opnieuw!',
		'invalid_input_err'					=>  'Ongeldige invoer!',
		'username_min_length_err'			=>	'Gebruikersnaam moet minimaal 6 tekens bevatten!',
		'username_max_length_err'			=>	'Gebruikersnaam mag maximaal 16 tekens bevatten!',
		'username_invalid_chars_err'		=>	'Alleen alfanumerieke invoer!',
		'email_invalid_err'					=>	'E-mail moet een geldig e-mailadres zijn!',
		'email_invalid_suppliers_err'		=>	'U mag deze e-mail niet gebruiken om te registreren. Kies een e-mail van een andere aanbieder!',
		'password_min_length_err'			=>	'Wachtwoord moet minimaal 6 tekens bevatten!',
		'password_max_length_err'			=>	'Wachtwoord mag maximaal 32 tekens bevatten!',
		'passwords_not_match_err'			=>	'Wachtwoorden komen niet overeen!',
		'captcha_incorrect_err'				=>	'Ongeldige captcha-code. Probeer het opnieuw!',
		'signup_too_often_err'				=>	'Te veel toegang vanaf dit IP-adres. Probeer het later opnieuw!',
		'username_exists_err'				=>	'Gebruikersnaam bestaat al!',
		'email_exists_err'					=>	'E-mailadres bestaat al!',
		'country_not_allowed_err'			=>	'Land niet toegestaan!',
		'undefined_err'						=>	'Er is iets misgegaan!',
		'register_success'					=>	'Uw account is succesvol geregistreerd!',
		'empty_fields_err'					=>	'Alle velden kunnen niet leeg zijn!',
		'incorrect_username_or_password_err'	=>	'Voer de juiste gebruikersnaam of het juiste wachtwoord in!',
		'account_banned_err'				=>	'Uw account is permanent verbannen. Reden: schending van het beleid!',
		'incorrect_2FA_err'					=>	'Voer de juiste 2FA-code in om door te gaan!',
		'login_success'						=>	'Succesvol ingelogd!',
		'send_mail_too_often_err'			=>	'Wacht 5 minuten voordat u een nieuwe e-mail aanvraagt!',
		'email_not_exists_err'				=>	'Uw e-mailadres is niet geregistreerd!',
		'send_verify_email_success'			=>	'We hebben een e-mail met een bevestigingslink naar %s gestuurd. U moet op deze link klikken om door te gaan. Deze link verloopt over 2 uur.', //$email
		'unavailable_feature_err'			=>	'Deze functie is momenteel niet beschikbaar',
		'verified_email_err'				=>	'Uw e-mail is geverifieerd!',
		'login_required_err'				=>	'U moet inloggen om door te gaan!',
		'logout_success'					=>	'Uitloggen!',
		'captcha_incorrect_many_times_err'	=>	'Te vaak onjuiste captcha. Probeer het opnieuw over 10 minuten!',
		'wait_hourly_faucet'				=>	'Wacht %d minuten, %d seconden voor de volgende faucet claim!', //$email, $seconds
		'claim_success'						=>	'U hebt %.8f DOGE ontvangen!', //(reward / 100000000)
		'out_of_spins_err'					=>	'Geen spins meer. Om meer bonusspins te krijgen, speel meer van onze spellen!',
		'dismiss_noti_success'				=>	'Melding succesvol afgesloten!',
		'empty_commission_balance_err'		=>	'Uw beschikbare commissiesaldo is leeg!',
		'invalid_gift_code_err'				=>	'Voer een geldige cadeaucode in!',
		'incorrect_gift_code_err'			=>	'Deze cadeaucode is ongeldig of verwijderd!',
		'used_gift_code_err'				=>	'Deze cadeaucode is al gebruikt!',
		'apply_gift_success'				=>	'Cadeaucode succesvol toegepast!',
		'password_changed_success'			=>	'Wachtwoord succesvol gewijzigd!',
		'incorrect_ver_code_err'			=>	'De verificatiecode bestaat niet of is verlopen!',
		'incorrect_2FA_err2'				=>	'U moet een geldige token opgeven om 2FA voor uw account in te schakelen!',
		'2FA_enabled_success'				=>	'2FA ingeschakeld!',
		'2FA_disabled_success'				=>	'2FA uitgeschakeld!',
		'incorrect_password_err'			=>	'Onjuist wachtwoord!',
		'update_privacy_success'			=>	'Privacy succesvol bijgewerkt!',
		'update_commission_share_success'	=>	'Commissiedeling succesvol bijgewerkt!',
		'verification_required_err'			=>	'Verifieer uw e-mail voordat u geld opneemt!',
		'invalid_address_err'				=>	'Voer een geldig opnameadres in!',
		'balance_not_enough_err'			=>	'U heeft minder dan %.8f DOGE. Wacht op het minimum bedrag!', //($minimum_withdrawal / 100000000)
		'withdrawal_amount_too_less_err'	=>	'Minimale opnamebedrag is %.8f DOGE!', //($minimum_withdrawal / 100000000)
		'amount_too_much_err'				=>	'Het opnamebedrag is hoger dan uw account saldo!',
		'withdraw_too_often_err'			=>	'U probeert te vaak op te nemen. Probeer het later opnieuw!',
		'withdrawal_being_processed'		=>	'Uw opnameverzoek wordt verwerkt!',
		'withdrawal_confirmation_required'	=>	'Bevestig het opnameverzoek door op de link in de e-mail te klikken die we u hebben gestuurd!',
		'transaction_not_exist_err'			=>	'Dit verzoek bestaat niet!',
		'transaction_not_exist_err2'		=>	'Het verzoek is geannuleerd of bestaat niet!',
		'transaction_canceled_success'		=>	'Uw verzoek is geannuleerd!',
		'feature_being_upgrade'				=>	'Deze functie wordt geüpgraded!',
		'empty_email_err'					=>	'Voer uw e-mail in!',
		'invalid_email_err'					=>	'Uw e-mail is geen geldig e-mailadres!',
		'empty_subject_err'					=>	'Voer het onderwerp in!',
		'empty_message_err'					=>	'Voer het bericht in!',
		'send_message_too_often_err'		=>	'Stuur elke boodschap na 1 minuut!',
		'ticket_closed'						=>	'Dit ticket is gesloten!',
		'send_message_success'				=>	'Uw bericht is succesvol verzonden!',
		'empty_client_seed_err'				=>	'Voer uw client seed in!',
		'change_client_seed_success'		=>	'Client seed succesvol gewijzigd!',
		'bet_amount_too_less_err'			=>	'Inzetbedrag moet minimaal %.8f DOGE zijn!', //($MIN_BET_AMOUNT / 100000000)
		'insufficient_balance_err'			=>	'Onvoldoende saldo!',
		'bet_amount_too_much_err'			=>	'Inzetbedrag mag niet hoger zijn dan %.8f DOGE!', //($MAX_BET_AMOUNT / 100000000)
		'min_payout_err'					=>	'Minimale uitbetaling moet meer dan of gelijk zijn aan %f!', //$MIN_PAYOUT
		'max_payout_err'					=>	'Maximale uitbetaling moet minder dan of gelijk zijn aan %f!', //$MAX_PAYOUT
		'min_multiplier_err' => 'De minimale multiplier moet groter dan of gelijk zijn aan %f!', //MIN MULTIPLIER
		'max_multiplier_err' => 'De maximale multiplier moet kleiner dan of gelijk zijn aan %f!', //MAX MULTIPLIER
		'select_lower_higher'				=>	'Selecteer lager of hoger!',
		'select_inside_outside'				=>	'Selecteer binnen of buiten!',
		'connection_timeout'				=>	'Verbindingstime-out!',
		'create_game_err'					=>	'Kan geen nieuw spel maken!',
		'select_difficulty_err'				=>	'Selecteer de moeilijkheidsgraad!',
		'create_game_success'				=>	'Nieuw spel succesvol aangemaakt!',
		'unstarted_game_err'				=>	'Klik eerst op starten!',
		'choose_tile_err'					=>	'Kies de juiste tegel!',
		'open_a_bomb'						=>	'U heeft een bom geopend!',
		'open_a_gem'						=>	'U heeft een edelsteen geopend!',
		'open_all_gems'						=>	'U heeft alle edelstenen geopend!',
		'no_tiles_selected_err'				=>	'Selecteer minimaal één tegel!',
		'cashout_success'					=>	'Inzet succesvol uitbetaald!',
		'select_num_mines_err'				=>	'Selecteer het aantal mijnen!',
		'select_num_lines_err'				=>	'Selecteer aantal lijnen',
		'tile_chosen_err'					=>	'Deze tegel is al gekozen!',
		'game_created_err'					=>	'U heeft al een actief spel. Beëindig dat eerst voordat u een nieuw spel start!',
		'tile_limited_err'					=>	'Aantal tegels overschrijdt de limiet!',
		'unexpected_err'					=>	'Onverwachte fout!',
		'select_player_banker_err'			=>	'Selecteer bankier, speler of gelijkspel!',
		'invalid_start_card_err'			=>	'Ongeldige startkaart!',
		'you_lose'							=>	'U verliest!',
		'open_new_card'						=>	'U opent een nieuwe kaart!',
		'can_not_cashout_err'				=>	'U kunt niet uitbetalen!',
		'invalid_txid_err'					=>	'Voer een geldige transactie-ID in!',
		'invalid_network_err'				=>	'Ongeldig netwerk!',
		'credited_txid_err'					=>	'De transactie is al gecrediteerd!',
		'update_transaction_success'		=>	'Transactie succesvol bijgewerkt!',
		'load_data_success'					=>	'Gegevens succesvol geladen!',
		'invalid_game_id_err'				=>	'Spel-ID bestaat niet!',
		'load_game_seed_failed'				=>	'Kan geen spelzaden laden!',
		'deposit_credited_success'			=>	'U heeft succesvol %.8f DOGE gestort!', //($total_amount / 100000000)
		'game_dice'							=> 	'Dobbelsteen',
		'game_slots'						=> 	'Gokkasten',
		'game_gems'							=> 	'Edelstenen',
		'game_mines'						=> 	'Mijnen',
		'game_video_poker'					=> 	'Videopoker',
		'game_baccarat'						=> 	'Baccarat',
		'game_high_low'						=> 	'Hoog-Laag',
		'game_roulette'						=> 	'Roulette',
		'game_wof'							=> 	'Rad van Fortuin',
		'game_plinko'						=> 	'Plinko',
		'game_limbo'						=> 	'Limbo',
		'game_ultimate'						=> 	'Ultieme Dobbelsteen',
	);

	public function __construct() {}

	public function print($key, ...$params) {
		if (isset($this->langs[$key])) {
			if (!empty($params)) {
				return vsprintf($this->langs[$key], $params);
			}
			return $this->langs[$key];
		}
		return '';
	}
}
?>