<?php
	Class LangRU {
		public $langs = array(
			'under_maintenance'					=>	'Сайт находится на техническом обслуживании. Пожалуйста, вернитесь позже!',
			'connection_timeout_err'			=>  'Время подключения истекло, пожалуйста, попробуйте позже!',
			'invalid_input_err'					=>  'Неверный ввод!',
			'username_min_length_err'			=>	'Имя пользователя должно содержать не менее 6 символов!',
			'username_max_length_err'			=>	'Имя пользователя должно содержать не более 16 символов!',
			'username_invalid_chars_err'		=>	'Только буквенно-цифровые символы!',
			'email_invalid_err'					=>	'Введите действительный адрес электронной почты!',
			'email_invalid_suppliers_err'		=>	'Вы не должны использовать этот адрес для регистрации. Пожалуйста, выберите почту другого провайдера!',
			'password_min_length_err'			=>	'Пароль должен содержать не менее 6 символов!',
			'password_max_length_err'			=>	'Пароль должен содержать не более 32 символов!',
			'passwords_not_match_err'			=>	'Пароли не совпадают!',
			'captcha_incorrect_err'				=>	'Неверный код капчи. Попробуйте еще раз!',
			'signup_too_often_err'				=>	'Слишком много попыток с этого IP-адреса. Пожалуйста, попробуйте позже!',
			'username_exists_err'				=>	'Имя пользователя уже существует!',
			'email_exists_err'					=>	'Электронная почта уже существует!',
			'country_not_allowed_err'			=>	'Страна не разрешена!',
			'undefined_err'						=>	'Произошла ошибка!',
			'register_success'					=>	'Ваш аккаунт успешно зарегистрирован!',
			'empty_fields_err'					=>	'Все поля должны быть заполнены!',
			'incorrect_username_or_password_err'	=>	'Введите правильное имя пользователя или пароль!',
			'account_banned_err'				=>	'Ваш аккаунт был заблокирован навсегда. Причина: нарушение политики!',
			'incorrect_2FA_err'					=>	'Введите правильный код 2FA для продолжения!',
			'login_success'						=>	'Вход выполнен успешно!',
			'send_mail_too_often_err'			=>	'Подождите 5 минут, прежде чем запрашивать новое письмо!',
			'email_not_exists_err'				=>	'Ваш адрес электронной почты не зарегистрирован!',
			'send_verify_email_success'			=>	'Мы отправили письмо с подтверждающей ссылкой на %s. Пожалуйста, нажмите на эту ссылку, чтобы продолжить. Срок действия ссылки истекает через 2 часа.', //$email
			'unavailable_feature_err'			=>	'Эта функция в настоящее время недоступна',
			'verified_email_err'				=>	'Ваш адрес электронной почты уже подтвержден!',
			'login_required_err'				=>	'Вы должны войти в систему, чтобы продолжить!',
			'logout_success'					=>	'Выход выполнен!',
			'captcha_incorrect_many_times_err'	=>	'Слишком много ошибок капчи. Попробуйте еще раз через 10 минут!',
			'wait_hourly_faucet'				=>	'Пожалуйста, подождите %d минут, %d секунд до следующего запроса на кран!', //$email, $seconds
			'claim_success'						=>	'Вы получили %.8f DOGE!', //(reward / 100000000)
			'out_of_spins_err'					=>	'Попытки закончились. Чтобы получить больше бонусных попыток, играйте в наши игры!',
			'dismiss_noti_success'				=>	'Уведомление успешно скрыто!',
			'empty_commission_balance_err'		=>	'Ваш баланс комиссий пуст!',
			'invalid_gift_code_err'				=>	'Введите действительный код подарка!',
			'incorrect_gift_code_err'			=>	'Этот код подарка недействителен или удален!',
			'used_gift_code_err'				=>	'Этот код подарка уже использован!',
			'apply_gift_success'				=>	'Код подарка успешно применен!',
			'password_changed_success'			=>	'Пароль успешно изменен!',
			'incorrect_ver_code_err'			=>	'Код подтверждения не существует или истек!',
			'incorrect_2FA_err2'				=>	'Вам нужно предоставить действительный токен, чтобы включить 2FA для вашего аккаунта!',
			'2FA_enabled_success'				=>	'2FA включена!',
			'2FA_disabled_success'				=>	'2FA отключена!',
			'incorrect_password_err'			=>	'Неверный пароль!',
			'update_privacy_success'			=>	'Политика конфиденциальности успешно обновлена!',
			'update_commission_share_success'	=>	'Доля комиссии успешно обновлена!',
			'verification_required_err'			=>	'Пожалуйста, подтвердите ваш адрес электронной почты перед выводом средств!',
			'invalid_address_err'				=>	'Введите правильный адрес для вывода средств!',
			'balance_not_enough_err'			=>	'У вас на счету меньше %.8f DOGE. Дождитесь минимальной суммы!', //($minimum_withdrawal / 100000000)
			'withdrawal_amount_too_less_err'	=>	'Минимальная сумма для вывода %.8f DOGE!', //($minimum_withdrawal / 100000000)
			'amount_too_much_err'				=>	'Сумма вывода превышает баланс на вашем счете!',
			'withdraw_too_often_err'			=>	'Вы пытаетесь слишком часто. Пожалуйста, попробуйте позже!',
			'withdrawal_being_processed'		=>	'Ваш запрос на вывод средств обрабатывается!',
			'withdrawal_confirmation_required'	=>	'Пожалуйста, подтвердите запрос на вывод, кликнув по ссылке, отправленной на ваш адрес электронной почты!',
			'transaction_not_exist_err'			=>	'Запрос не существует!',
			'transaction_not_exist_err2'		=>	'Запрос был отменен или не существует!',
			'transaction_canceled_success'		=>	'Ваш запрос был отменен!',
			'feature_being_upgrade'				=>	'Эта функция обновляется!',
			'empty_email_err'					=>	'Введите ваш адрес электронной почты!',
			'invalid_email_err'					=>	'Ваш адрес электронной почты недействителен!',
			'empty_subject_err'					=>	'Введите тему!',
			'empty_message_err'					=>	'Введите сообщение!',
			'send_message_too_often_err'		=>	'Отправляйте сообщение с интервалом в 1 минуту!',
			'ticket_closed'						=>	'Этот тикет закрыт!',
			'send_message_success'				=>	'Ваше сообщение успешно отправлено!',
			'empty_client_seed_err'				=>	'Введите ваш клиентский сид!',
			'change_client_seed_success'		=>	'Клиентский сид успешно изменен!',
			'bet_amount_too_less_err'			=>	'Сумма ставки должна быть не менее %.8f DOGE!', //($MIN_BET_AMOUNT / 100000000)
			'insufficient_balance_err'			=>	'Недостаточно средств!',
			'bet_amount_too_much_err'			=>	'Сумма ставки должна быть не более %.8f DOGE!', //($MAX_BET_AMOUNT / 100000000)
			'min_payout_err'					=>	'Минимальная выплата должна быть не менее %f!', //$MIN_PAYOUT
			'max_payout_err'					=>	'Максимальная выплата должна быть не более %f!', //$MAX_PAYOUT
			'min_multiplier_err' => 'Минимальный множитель должен быть не меньше %f!', //MIN MULTIPLIER
			'max_multiplier_err' => 'Максимальный множитель должен быть не больше %f!', //MAX MULTIPLIER
			'select_lower_higher'				=>	'Выберите меньше или больше!',
			'select_inside_outside'				=>	'Выберите внутри или снаружи!',
			'connection_timeout'				=>	'Время подключения истекло!',
			'create_game_err'					=>	'Невозможно создать новую игру!',
			'select_difficulty_err'				=>	'Пожалуйста, выберите уровень сложности!',
			'create_game_success'				=>	'Новая игра успешно создана!',
			'unstarted_game_err'				=>	'Пожалуйста, сначала нажмите "Старт"!',
			'choose_tile_err'					=>	'Пожалуйста, выберите правильную плитку!',
			'open_a_bomb'						=>	'Вы открыли бомбу!',
			'open_a_gem'						=>	'Вы открыли драгоценный камень!',
			'open_all_gems'						=>	'Вы открыли все драгоценные камни!',
			'no_tiles_selected_err'				=>	'Выберите хотя бы одну плитку!',
			'cashout_success'					=>	'Ставка успешно выведена!',
			'select_num_mines_err'				=>	'Пожалуйста, выберите количество мин!',
			'select_num_lines_err'				=>	'Пожалуйста, выберите количество линий',
			'tile_chosen_err'					=>	'Эта плитка уже выбрана!',
			'game_created_err'					=>	'У вас уже есть активная игра. Пожалуйста, завершите ее перед началом новой!',
			'tile_limited_err'					=>	'Количество плиток превышает лимит!',
			'unexpected_err'					=>	'Непредвиденная ошибка!',
			'select_player_banker_err'			=>	'Пожалуйста, выберите банкир, игрок или ничья!',
			'invalid_start_card_err'			=>	'Недействительная стартовая карта!',
			'you_lose'							=>	'Вы проиграли!',
			'open_new_card'						=>	'Вы открыли новую карту!',
			'can_not_cashout_err'				=>	'Вы не можете вывести средства!',
			'invalid_txid_err'					=>	'Введите действительный ID транзакции!',
			'invalid_network_err'				=>	'Неверная сеть!',
			'credited_txid_err'					=>	'Транзакция уже была зачислена!',
			'update_transaction_success'		=>	'Транзакция успешно обновлена!',
			'load_data_success'					=>	'Данные успешно загружены!',
			'invalid_game_id_err'				=>	'ID игры не существует!',
			'load_game_seed_failed'				=>	'Не удалось загрузить сиды игры!',
			'deposit_credited_success'			=>	'Вы успешно внесли депозит %.8f DOGE!', //($total_amount / 100000000)
			'game_dice'							=> 	'Кости',
			'game_slots'						=> 	'Слоты',
			'game_gems'							=> 	'Драгоценные камни',
			'game_mines'						=> 	'Мины',
			'game_video_poker'					=> 	'Видеопокер',
			'game_baccarat'						=> 	'Баккара',
			'game_high_low'						=> 	'Больше-Меньше',
			'game_roulette'						=> 	'Рулетка',
			'game_wof'							=> 	'Колесо Фортуны',
			'game_plinko'						=> 	'Плинко',
			'game_limbo'						=> 	'Лимбо',
			'game_ultimate'						=> 	'Ультимативные Кости',
		);
		
		public function __construct() {}
		
		public function print($key, ...$params) {
			if (isset($this->langs[$key])) {
				if (!empty($params)) {
					return vsprintf($this->langs[$key], $params);
				}
				return $this->langs[$key];
			}
			return '';
		}
	}
?>