<?php
require 'vendor/autoload.php';
use GeoIp2\Database\Reader;
use GeoIp2\Exception\AddressNotFoundException;

function sanitize_ip($ip) {
    // Replace localhost IPs with a fallback public IP
    if ($ip === '::1' || $ip === '127.0.0.1') {
        return '8.8.8.8'; // fallback IP
    }
    return $ip;
}

function GeoIp2Country($ip) {
    $ip = sanitize_ip($ip);
    try {
        $reader = new Reader(APPPATH.'geolite2/GeoLite2-City.mmdb');
        $record = $reader->city($ip);
        return $record->country->name ?? '';
    } catch (AddressNotFoundException $e) {
        return '';
    } catch (Exception $e) {
        return '';
    }
}

function GeoIp2CountryIsoCode($ip) {
    $ip = sanitize_ip($ip);
    try {
        $reader = new Reader(APPPATH.'geolite2/GeoLite2-City.mmdb');
        $record = $reader->city($ip);
        return $record->country->isoCode ?? '';
    } catch (AddressNotFoundException $e) {
        return '';
    } catch (Exception $e) {
        return '';
    }
}

function GeoIp2City($ip) {
    $ip = sanitize_ip($ip);
    try {
        $reader = new Reader(APPPATH.'geolite2/GeoLite2-City.mmdb');
        $record = $reader->city($ip);
        return $record->city->name ?? '';
    } catch (AddressNotFoundException $e) {
        return '';
    } catch (Exception $e) {
        return '';
    }
}
?>