<?php
class BanModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function ban_user($user_id, $ip, $user_token, $time, $expired_time, $reason) {
		$user_id = $this->db->escape_str($user_id);
		$ip = $this->db->escape_str($ip);
		$user_token = $this->db->escape_str($user_token);
		$data = array(
			'user_id' 		=> $user_id,
			'ip' 			=> $ip,
			'user_token' 	=> $user_token,
			'email' 		=> '',
			'time'			=> $time,
			'expired_time'	=> $expired_time,
			'reason' 		=> $reason,
		);
		$this->db->insert('ez_bans', $data);
		$insert_id = $this->db->insert_id();
		return  $insert_id;
	}

	public function unban($ban_id) {
		$ban_id = $this->db->escape_str($ban_id);
		$ban_id = intval($ban_id);
		$this->db->set('expired_time', time(), false);
		$this->db->where('ban_id', $ban_id);
		$this->db->update('ez_bans');
	}

	public function check_ban_user($user_id, $ip = '') {
		$user_id = $this->db->escape_str($user_id);
		$ip = $this->db->escape_str($ip);
		if($user_id == 0) {
			if(isset($_COOKIE['fp'])) {
				$finger_print = $_COOKIE['fp'];
			} else {
				$finger_print = '--';
			}
			$finger_print = $this->db->escape_str($finger_print);
			$sql = "SELECT * FROM `ez_bans` WHERE (`ip` = ? OR `user_token` = ?) AND `email` = '' AND (`expired_time` > ? OR `expired_time` = 0) ORDER BY `expired_time` DESC LIMIT 1";
			$query = $this->db->query($sql, array($ip, $finger_print, time()));
		} else {
			$sql = "SELECT * FROM `ez_bans` WHERE `user_id` = ? AND `email` = '' AND (`expired_time` > ? OR `expired_time` = 0) ORDER BY `expired_time` DESC LIMIT 1";
			$query = $this->db->query($sql, array($user_id, time()));
		}
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function block_email($email, $time, $expired_time) {
		$data = array(
			'user_id' 		=> 0,
			'ip' 			=> '',
			'user_token' 	=> '',
			'email' 		=> $email,
			'time'			=> $time,
			'expired_time'	=> $expired_time,
			'reason' 		=> '',
		);
		$this->db->insert('ez_bans', $data);
		$insert_id = $this->db->insert_id();
		return  $insert_id;
	}

	public function unblock_email($email) {
		$email = $this->db->escape_str($email);
		$this->db->set('expired_time', time(), false);
		$this->db->where('email', $email);
		$this->db->update('ez_bans');
	}
	
	public function check_block_email($email) {
		$email = $this->db->escape_str($email);
		$sql = "SELECT * FROM `ez_bans` WHERE `email` = ? AND (`expired_time` > ? OR `expired_time` = 0) ORDER BY `expired_time` DESC LIMIT 1";
		$query = $this->db->query($sql, array($email, time()));
		if($query->num_rows() > 0) {
			return 1;
		}
		return 0;
	}
	
	public function get_user_id($ban_id) {
		$ban_id = $this->db->escape_str($ban_id);
		$ban_id = intval($ban_id);
		$sql = "SELECT * FROM `ez_bans` WHERE `ban_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($ban_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->user_id;
		}
		return 0;
	}
	
	public function load_bans($page_id = 1) {
		$sql = "SELECT `ban_id`, `user_id` AS `uid`, `ip`, `time`, `expired_time`, `reason`, `user_token`, `email` FROM `ez_bans` WHERE `expired_time` > ? OR `expired_time` = 0 ORDER BY `ban_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
		$query = $this->db->query($sql, array(time()));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function get_statistics() {
		$sql = "SELECT COUNT(`ban_id`) AS `total_users` FROM `ez_bans` WHERE `expired_time` = 0 || `expired_time` > '".time()."'";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}

}
?>