<?php
class BonusModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function insert_entry($user_id, $amount, $message, $type = 'DOGE') {
		$user_id = $this->db->escape_str($user_id);
		$message = $this->db->escape_str($message);
		$amount = $this->db->escape_str($amount);
		$data = array(
			'user_id' 		=> $user_id,
			'amount'		=> $amount,
			'message' 		=> $message,
			'time'			=> time(),
			'type'			=> $type
		);
		$this->db->insert('ez_bonuses', $data);
		$insert_id = $this->db->insert_id();
		
		//sync_data
		$this->auto_sync_bonus_data(array(
			'bonus_id'		=> $insert_id,
			'user_id' 		=> $user_id,
			'amount'		=> $amount,
			'message' 		=> $message,
			'time'			=> time(),
			'type'			=> $type,
		));
		//sync_data
		
		return  $insert_id;
	}
	
	public function get_statistics($user_id = 0) {
		$user_id = $this->db->escape_str($user_id);
		if($user_id != 0) {
			$sql = "SELECT COUNT(`bonus_id`) AS `total_requests`, SUM(`amount`) AS `total_amount`, MAX(`amount`) AS `max_amount` FROM `ez_bonuses` WHERE `user_id` = ? AND (`message` LIKE '%Referral commissions%' OR `message` LIKE '%Auto claim commissions%')";
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT COUNT(`bonus_id`) AS `total_requests`, SUM(`amount`) AS `total_amount`, MAX(`amount`) AS `max_amount` FROM `ez_bonuses`";
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}

	public function load_user_bonuses($user_id, $page_id = 1) {
		$user_id = $this->db->escape_str($user_id);
		if($user_id != 0) {
			$sql = "SELECT `bonus_id` AS `id`, `ez_bonuses`.`user_id` AS `uid`, `amount`, `time`, `message`, `user_name`, `type` FROM `ez_bonuses`, `ez_users` WHERE `ez_bonuses`.`user_id` = `ez_users`.`user_id` AND `ez_bonuses`.`user_id` = ? ORDER BY `bonus_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT `bonus_id` AS `id`, `ez_bonuses`.`user_id` AS `uid`, `amount`, `time`, `message`, `user_name`, `type`  FROM `ez_bonuses`, `ez_users` WHERE `ez_bonuses`.`user_id` = `ez_users`.`user_id` ORDER BY `bonus_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql);
		}
		
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	//sync_data
	public function auto_sync_bonus_data($bonus_data) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/dogepick/bonuses.php';
		$jsonData = json_encode($bonus_data);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
}
?>