<?php
	class ConfirmationModel extends CI_Model {

		public $limit_entries = 50;
		
		function __construct() {
			parent::__construct();
			$this->load->database();
		}
		
		public function insert_entry($user_id, $confirmation_key, $type, $request_id = 0, $lifetime = 86400, $ip_address = '') {
			$user_id = $this->db->escape_str($user_id);
			$confirmation_key = $this->db->escape_str($confirmation_key);
			$type = $this->db->escape_str($type);
			$request_id = $this->db->escape_str($request_id);
			$data = array(
				'user_id' 			=> $user_id,
				'confirmation_key' 	=> $confirmation_key,
				'type' 				=> $type,
				'request_id' 		=> $request_id,
				'date'				=> time(),
				'expired_time'		=> time() + $lifetime,
				'ip_address'		=> $ip_address
			);
			$this->db->insert('ez_confirmations', $data);
			$insert_id = $this->db->insert_id();
			return  $insert_id;
		}
		
		public function check_multiple_confirmations($user_id, $type) {
			$user_id = $this->db->escape_str($user_id);
			$type = $this->db->escape_str($type);
			$sql = "SELECT * FROM `ez_confirmations` WHERE `user_id` = ? AND `type` = ? AND `date` > ?";
			$query = $this->db->query($sql, array($user_id, $type, time() - 300));
			if($query->num_rows() > 0) {
				return 0;
			}
			return 1;
		}
		
		public function check_multiple_confirmations_by_ip($ip_address) {
			$sql = "SELECT * FROM `ez_confirmations` WHERE `ip_address` = ? AND `date` > ?";
			$query = $this->db->query($sql, array($ip_address, time() - 300));
			if($query->num_rows() > 0) {
				return 1;
			}
			return 0;
		}
		
		public function get_confirmation_data_by_key($key) {
			$key = $this->db->escape_str($key);
			$sql = "SELECT * FROM `ez_confirmations` WHERE `confirmation_key` = ? AND `expired_time` > ?";
			$query = $this->db->query($sql, array($key, time()));
			if($query->num_rows() > 0) {
				return $query->result()[0];
			}
			return 0;
		}
		
		public function update_confirmation_expired_time($key) {
			$key = $this->db->escape_str($key);
			$key = $this->db->escape_str($key);
			$this->db->set('expired_time', time());
			$this->db->where('confirmation_key', $key);
			$this->db->update('ez_confirmations');
		}
	}
?>
