<?php
class FaucetModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function create_new_faucet($user_id, $multiplier, $life_time, $note = '') {
		$data = array(
			'user_id' 		=> $user_id,
			'multiplier' 	=> $multiplier,
			'active_time' 	=> time(),
			'expired_time'	=> time() + $life_time,
			'note'			=> $note,
		);
		$this->db->insert('ez_faucets', $data);
		$insert_id = $this->db->insert_id();
		
		//sync_data
		$this->auto_sync_faucet_data(array(
			'faucet_id'		=> $insert_id,
			'user_id' 		=> $user_id,
			'multiplier' 	=> $multiplier,
			'active_time' 	=> time(),
			'expired_time'	=> time() + $life_time,
			'note'			=> $note,
		));
		//sync_data
		
		return  $insert_id;
	}

	public function get_user_faucet($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$user_id = intval($user_id);
		$sql = "SELECT * FROM `ez_faucets` WHERE `user_id` = ? AND `expired_time` > ? ORDER BY `multiplier` DESC, `expired_time` DESC LIMIT 1";
		$query = $this->db->query($sql, array($user_id, time()));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	//sync_data
	public function auto_sync_faucet_data($faucet_data) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/dogepick/faucets.php';
		$jsonData = json_encode($faucet_data);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
}
?>