<?php
class GroupModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function get_all_groups() {
        return $this->db->get('ez_groups')->result();
    }

    public function create_group($name, $description = '') {
        return $this->db->insert('ez_groups', [
            'group_name' => $name,
            'description' => $description
        ]);
    }

	public function delete_group($group_id) {
        $this->db->where('group_id', $group_id);
		$this->db->delete('ez_groups');
    }

    public function get_group_users($group_id) {
        $this->db->select('ez_users.*');
        $this->db->from('ez_users');
        $this->db->join('ez_user_groups', 'ez_users.user_id = ez_user_groups.user_id');
        $this->db->where('ez_user_groups.group_id', $group_id);
        return $this->db->get()->result();
    }
	
	public function add_user_to_group($user_id, $group_id) {
		$exists = $this->db->get_where('ez_user_groups', [
			'user_id' => $user_id,
			'group_id' => $group_id,
		])->row();

		if ($exists) {
			return FALSE;
		}

		return $this->db->insert('ez_user_groups', [
			'user_id' => $user_id,
			'group_id' => $group_id,
			'time'	=> time()
		]);
	}
	
	public function get_user_groups($user_id) {
		$this->db->select('g.group_id, g.group_name, g.description');
		$this->db->from('ez_groups g');
		$this->db->join('ez_user_groups ug', 'ug.group_id = g.group_id');
		$this->db->where('ug.user_id', $user_id);
		return $this->db->get()->result();
	}
	
	public function get_groups_not_joined_by_user($user_id) {
		$this->db->select('g.group_id, g.group_name, g.description');
		$this->db->from('ez_groups g');
		$this->db->join('ez_user_groups ug', 'ug.group_id = g.group_id AND ug.user_id = '.$this->db->escape($user_id), 'left');
		$this->db->where('ug.user_id IS NULL');
		return $this->db->get()->result();
	}
	
	public function remove_user_from_group($user_id, $group_id) {
		return $this->db->delete('ez_user_groups', [
			'user_id' => $user_id,
			'group_id' => $group_id
		]);
	}
	
	public function is_user_in_group($user_id, $group_id) {
		$this->db->where('user_id', $user_id);
		$this->db->where('group_id', $group_id);
		$query = $this->db->get('ez_user_groups');
		return $query->num_rows() > 0;
	}
}
?>