<?php
class LogModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function create_log($user_id, $action, $ip) {
		$action = $this->db->escape_str($action);
		if(isset($_COOKIE['fp'])) {
			$finger_print = $_COOKIE['fp'];
		} else {
			$finger_print = '';
		}
		$data = array(
			'user_id' 	=> $user_id,
			'action' 	=> $action,
			'time' 		=> time(),
			'ip' 		=> $ip,
			'cookie'	=> $finger_print
		);
		$this->db->insert('ez_logs', $data);
		$insert_id = $this->db->insert_id();
		return  $insert_id;
	}
	
	public function abnormal_activities($page_no, $action, $time, $type = 'cookie') {
		if($type == 'cookie') {
			$query = $this->db->query("SELECT MAX(`user_id`) AS `user_id`, `cookie`, COUNT(`cookie`) AS `count` FROM `ez_logs` WHERE `time` > UNIX_TIMESTAMP() - ".$time." AND `action` LIKE '%".$action."%' GROUP BY `cookie` HAVING `count` > 2 ORDER BY `count` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_no - 1)));
			$query2 = $this->db->query("SELECT MAX(`user_id`) AS `user_id`, `cookie`, COUNT(`cookie`) AS `count` FROM `ez_logs` WHERE `time` > UNIX_TIMESTAMP() - ".$time." AND `action` LIKE '%".$action."%' GROUP BY `cookie` HAVING `count` > 2");
		} else {
			$query = $this->db->query("SELECT MAX(`user_id`) AS `user_id`, `ip`, COUNT(`ip`) AS `count` FROM `ez_logs` WHERE `time` > UNIX_TIMESTAMP() - ".$time." AND `action` LIKE '%".$action."%' GROUP BY `ip` HAVING `count` > 2 ORDER BY `count` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_no - 1)));
			$query2 = $this->db->query("SELECT MAX(`user_id`) AS `user_id`, `ip`, COUNT(`ip`) AS `count` FROM `ez_logs` WHERE `time` > UNIX_TIMESTAMP() - ".$time." AND `action` LIKE '%".$action."%' GROUP BY `ip` HAVING `count` > 2");
		}
	
		$total_records = $query2->num_rows();
		$total_pages = ceil($total_records / $this->limit_entries);
		if($total_pages > 0) {
			return array('data' => $query->result(),
					'total_pages' => $total_pages);
		}
		return null;
	}
	
	public function load_logs($search_key = 0, $page_id = 1) {
		$total_records = 0;
		$data = null;
		
		$where = "";
		
		if(filter_var($search_key, FILTER_VALIDATE_IP)) {
			$where = " WHERE `ip` = '".$search_key."'";
		} else if(strlen($search_key) == 16) {
			$where = " WHERE `cookie` = '".$search_key."'";
		} else if(is_numeric($search_key)) {
			$where = " WHERE `user_id` = '".$search_key."'";
		}  else if(strtolower($search_key) == 'auto claim') {
			$where = " WHERE `action` LIKE '%auto claim%'";
		} 

		
		$query = $this->db->query("SELECT * FROM `ez_logs`".$where." ORDER BY `log_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1)));
		$query2 = $this->db->query("SELECT COUNT(`log_id`) AS `total_records` FROM `ez_logs`".$where);

		if($query->num_rows() > 0) {
			$data = $query->result();
		}
		
		if($query2->num_rows() > 0) {
			$total_records =  $query2->result()[0]->total_records;
		}
		$total_pages = ceil($total_records / $this->limit_entries);
		return array('data' => $data,
					'total_pages' => $total_pages);
	}
	
	public function get_login_logs_by_user($user_id) {
		$sql = "SELECT `ip`, `time`, `action` FROM `ez_logs` WHERE `user_id` = ? AND `action` LIKE '%] Login%' ORDER BY `log_id` DESC LIMIT 20";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	
	public function create_random_key($len = 8) {
		$alphabets = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
		$string = "";
		for($i = 0; $i < $len; $i++) {
			$string .= $alphabets[rand(0, strlen($alphabets) - 1)];
		}
		return $string;
	}
	
	public function get_user_log_data($user_id) {
		$query = $this->db->query("SELECT COUNT(DISTINCT(ip)) AS cnt_ip, COUNT(DISTINCT(cookie)) AS cnt_cookie FROM ez_logs WHERE user_id = '".$user_id."'");
		if($query->num_rows() > 0) {
			$result = $query->result()[0];
			return array($result->cnt_ip, $result->cnt_cookie);
		}
		return array(0, 0);
	}
		
	public function get_last_claim_faucet_time($user_id, $ip) {
		if(isset($_COOKIE['fp'])) {
			$finger_print = $_COOKIE['fp'];
		} else {
			$finger_print = '';
		}
		$sql = "SELECT * FROM `ez_logs` WHERE (`action` LIKE '%Claim faucet%' OR `action` LIKE '%auto claim%') AND (`user_id` = ? OR `ip` = ?) ORDER BY `time` DESC LIMIT 1";
		$query = $this->db->query($sql, array($user_id, $ip));
		if($query->num_rows() > 0) {
			return $query->result()[0]->time;
		}
		return 0;
	}
	
	public function clean_log_data() {
		$query = $this->db->query("DELETE FROM `ez_logs` WHERE (`action` LIKE '%Claim faucet%' OR `action` LIKE '%auto claim%' OR `action` LIKE 'captcha_incorrect_many_times_err') AND `time` < (UNIX_TIMESTAMP() - 86400 * 7) LIMIT 5000");
	}
	
	public function get_all_ips_by_uid($user_id) {
		$sql = "SELECT `ip` FROM `ez_logs` WHERE `user_id` = ? GROUP BY `ip` LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function get_all_cookies_by_uid($user_id) {
		$sql = "SELECT `cookie` FROM `ez_logs` WHERE `user_id` = ? GROUP BY `cookie`";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function get_faucet_claim_rate($user_id) {
		$sql = "SELECT COUNT(log_id) AS `claims`, MIN(`time`) AS `start_time`, MAX(`time`) AS `end_time` FROM `ez_logs` WHERE user_id = ? AND (`action` LIKE '%Claim faucet%')";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			$result = $query->result()[0];
			$claims = $result->claims;
			$start_time = $result->start_time;
			$end_time = $result->end_time;
			if($claims > 10) {
				return number_format(floatval($claims * 86400 / ($end_time - $start_time)), 2);
			}
		}
		return 0;
	}
	
	public function is_same_mouse_position_repeated($user_id, $current_x, $current_y, $threshold = 6, $limit = 10) {
		$limit = intval($limit);
		$sql = "SELECT action FROM `ez_logs` 
				WHERE user_id = ? 
				  AND action LIKE '%Claim faucet%' 
				ORDER BY time DESC 
				LIMIT $limit";

		$query = $this->db->query($sql, [$user_id]);

		if (!$query) {
			log_message('error', 'SQL query failed in LogModel::is_same_mouse_position_repeated');
			return false;
		}

		$results = $query->result_array();
		$match_count = 0;

		foreach ($results as $row) {
			$coords = $this->extract_coordinates($row['action']);
			if ($coords && $coords['x'] == $current_x && $coords['y'] == $current_y) {
				$match_count++;
			}
		}

		return $match_count >= $threshold;
	}

	private function extract_coordinates($action_str) {
		if (preg_match('/Claim faucet \[(\d+\.\d+):(\d+\.\d+)\]/', $action_str, $matches)) {
			return ['x' => floatval($matches[1]), 'y' => floatval($matches[2])];
		}
		return null;
	}
	
	public function get_last_auto_claim_time($user_id) {
        $this->db->select_max('time', 'last_time');
        $this->db->where('user_id', $user_id);
        $this->db->where('action', 'Detected auto claim');
        $query = $this->db->get('ez_logs');

        if ($query->num_rows() > 0) {
            return (int) $query->row()->last_time;
        }
        return 0;
    }
}
?>