<?php
class NotificationModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function dismiss_notification($user_id, $notification_id) {
		$sql = "UPDATE `ez_notifications` SET `dismiss` = '1' WHERE `user_id` = ?  AND `notification_id` = ?";
		$query = $this->db->query($sql, array($user_id, $notification_id));
	}

	public function create_notification($user_id, $content, $type = 'success') {
		$user_id = $this->db->escape_str($user_id);
		//$content = $this->db->escape_str($content);
		$data = array(
			'user_id' 	=> $user_id,
			'content' 	=> $content,
			'type'	=> $type,
			'time'	=> time(),
			'dismiss'	=> 0
		);
		$this->db->insert('ez_notifications', $data);
		return $this->db->insert_id();
	}
	
	public function get_all_notifications_by_user_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT * FROM `ez_notifications` WHERE `user_id` = ? AND `dismiss` != '1' ORDER BY `time` DESC";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return 0;
	}
	
	public function load_user_notifications($user_id = 0, $page_id = 1) {
		$user_id = $this->db->escape_str($user_id);
		if($user_id != 0) {
			$sql = "SELECT * FROM `ez_notifications` WHERE `user_id` = ? ORDER BY `notification_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT * FROM `ez_notifications` ORDER BY `notification_id` DESC LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function count_notifications($user_id = 0) {
		$user_id = $this->db->escape_str($user_id);
		if($user_id != 0) {
			$sql = "SELECT COUNT(`notification_id`) AS CNT FROM `ez_notifications` WHERE `user_id` = ?";
			$query = $this->db->query($sql, array($user_id));
		} else {
			$sql = "SELECT COUNT(`notification_id`) AS CNT FROM `ez_notifications`";
			$query = $this->db->query($sql);
		}
		if($query->num_rows() > 0) {
			return $query->result()[0]->CNT;
		}
		return 0;
	}
	
	public function clean_notification_data() {
		$query = $this->db->query("DELETE FROM `ez_notifications` WHERE `time` <= '".(time() - 7 * 86400)."' AND `dismiss` = '1'");
	}
	public function find_notification_by_ticket_code($user_id, $ticket_code) {
		$sql = "SELECT * FROM `ez_notifications` WHERE `user_id` = '".$user_id."' AND `dismiss` = '0' AND `content` LIKE '%".$ticket_code."%'";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function get_latest_trustpilot_notification($user_id) {
		$sql = "SELECT * FROM `ez_notifications` WHERE `user_id` = '".$user_id."' AND `content` LIKE '%trustpilot.com%' ORDER BY `time` DESC LIMIT 1";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0]->time;
		}
		return 0;
	}
		
	public function count_unread_notifications($user_id, $last_view_time) {
		$this->db->where('user_id', $user_id);
		$this->db->where('dismiss', 0);
		$this->db->where('time >', $last_view_time);
		return $this->db->count_all_results('ez_notifications');
	}
	
	public function get_notifications_for_user($user_id){
		$this->db->where('user_id', $user_id);
		$this->db->where('dismiss', 0);
		$this->db->order_by('time', 'DESC');
		$this->db->limit(10);
		$notifications = $this->db->get('ez_notifications')->result_array();
		return $notifications;
	}
}
?>