<?php
class StrategyModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function save_user_strategies($user_id, $strategies) {
		$user_id = $this->db->escape_str($user_id);
		$strategies = $this->db->escape_str($strategies);
		if(strlen($strategies) >= 65535 || !$this->is_valid_json($strategies)) {
			return;
		}
		$get_strategies_by_user_id = $this->get_strategies_by_user_id($user_id);
		if($get_strategies_by_user_id == null) {
			$data = array(
				'user_id' 		=> $user_id,
				'strategies' 	=> $strategies,
				'time' 			=> time(),
			);
			$this->db->insert('ez_strategies', $data);
			$this->db->insert_id();
		} else {
			$sql = "UPDATE `ez_strategies` SET `strategies` = ?, `time` = ? WHERE `user_id` = ?";
			$query = $this->db->query($sql, array($strategies, time(), $user_id));
		}
	}
	
	public function get_strategies_by_user_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT * FROM `ez_strategies` WHERE `user_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return stripslashes($query->result()[0]->strategies);
		}
		return null;
	}
	
	public function is_valid_json($string) {
		$string = str_replace('\\', '', $string);
		$string = trim($string);
		if (!in_array($string[0] ?? '', ['{', '[']) || !in_array($string[strlen($string) - 1] ?? '', ['}', ']'])) {
			return false;
		}
		json_decode($string, true);
		return json_last_error() === JSON_ERROR_NONE;
	}
	
}
?>