<?php
class UserModel extends CI_Model {
	
	public $limit_entries = 20;
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
	
	public function get_user_info_by_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$user_id = intval($user_id);
		$sql = "SELECT * FROM `ez_users` WHERE `user_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function lock_user_by_id($user_id) {
		$user_id = intval($this->db->escape_str($user_id));
		$sql = "SELECT user_id FROM ez_users WHERE user_id = ? FOR UPDATE";
		$query = $this->db->query($sql, [$user_id]);
		return $query->num_rows() > 0;
	}
	
	public function get_user_balance_for_update($user_id) {
		$user_id = intval($this->db->escape_str($user_id));
		$sql = "SELECT balance FROM ez_users WHERE user_id = ? FOR UPDATE";
		$query = $this->db->query($sql, [$user_id]);
		
		if ($query->num_rows() > 0) {
			return $query->row()->balance;
		}
		return 0;
	}
	
	public function get_user_id_by_name($user_name) {
		$user_name = $this->db->escape_str($user_name);
		$sql = "SELECT `user_id` FROM `ez_users` WHERE `user_name` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_name));
		if($query->num_rows() > 0) {
			return $query->result()[0]->user_id;
		}
		return null;
	}

	public function get_user_name_by_id($uids) {
		$list = '';
		foreach($uids as $uid) {
		
		}
	}

	public function get_basic_user_info_by_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$user_id = intval($user_id);
		$sql = "SELECT 	`user_level`,
						`email_verification`,
						`total_referrals`,
						`secret_2fa_code`,
						`enable_2fa`,
						`total_deposits`,
						`total_withdrawals`,
						`total_bonuses`,
						`pending_balance`,
						`processing_balance`,
						`available_commission_balance`,
						`total_referral_commissions`,
						`commission_share`,
						`balance`,
						`claims`,
						`bets`,
						`wins`,
						`losses`,
						`amount_wins`,
						`amount_losses`,
						`bets_today`,
						`bet_balance_today`,
						`wagered_today`,
						`wagered_this_week`,
						`wagered_this_month`,
						`wagered`,
						`wagered2`,
						`banned`,
						`banned_faucet`,
						`client_seed`,
						`nonce`,
						`server_seed`,
						`server_seed_hash`,
						`show_server_seed_hash`,
						`last_bet_time`,
						`last_claim_faucet_time`,
						`lottery_tickets`,
						`free_spins`,
						`payment_notifications`,
						`deposit_notifications`,
						`password_update_notifications`,
						`promotions`,
						`amount_claims`,
						`disable_commission`,
						`auto_payout`,
						`dark_mode`
				FROM `ez_users` WHERE `user_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function get_user_balance_by_id($user_id) {
		$user_id = intval($user_id);
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT `balance` FROM `ez_users` WHERE `user_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->balance;
		}
		return 0;
	}
	
	public function update_user_info($user_info, $updated_info) {
		$data_changed = 0;
		foreach($user_info as $key => $value){
			if($updated_info->$key != $value) {
				$updated_info->$key = $this->db->escape_str($updated_info->$key);
				$this->db->set($key, $updated_info->$key);
				$data_changed++;
			}
		}
		if($data_changed > 0) {
			$update_status = false;
			$this->db->where('user_id', $user_info->user_id);
			$this->db->limit(1);
			$update_status = $this->db->update('ez_users');
			if(!$update_status) {
				throw new Exception("Server is busy");
			}
			return $update_status;
		}
		return true;
	}
	
	public function update_user_info_by_id($user_id, $key, $value, $escape = TRUE) {
		$update_status = false;
		$user_id = $this->db->escape_str($user_id);
		$key = $this->db->escape_str($key);
		$value = $this->db->escape_str($value);
		$user_id = intval($user_id);
		$this->db->set($key, $value, $escape);
		$this->db->where('user_id', $user_id);
		$this->db->limit(1);
		$update_status = $this->db->update('ez_users');
		if(!$update_status) {
			throw new Exception("Server is busy");
		}
		return $update_status;
	}
	
	public function update_user_bet_data($user_info, $bet_amount, $win_amount, $balance, $new_server_seed = '') {
		$updated_info = clone($user_info);
		$updated_info->balance = $balance;
		$updated_info->bets  += 1;
		if($win_amount > 0) {
			$updated_info->wins  += 1;
			$updated_info->amount_wins  += $win_amount;
		} else {
			$updated_info->losses  += 1;
			$updated_info->amount_losses  -= $win_amount;
		}
		if(date("Y-m-d", $user_info->last_bet_time) == date("Y-m-d", time())) {
			$updated_info->bets_today++;
			$updated_info->bet_balance_today += $win_amount;
			$updated_info->wagered_today += $bet_amount;
		} else {
			$updated_info->bets_today = 1;
			$updated_info->bet_balance_today = $win_amount;
			$updated_info->wagered_today = $bet_amount;
		}
		if(date("W", $user_info->last_bet_time) == date("W", time())) {
			$updated_info->wagered_this_week  += $bet_amount;
		} else {
			$updated_info->wagered_this_week  = $bet_amount;
		}
		if(date("m", $user_info->last_bet_time) == date("m", time())) {
			$updated_info->wagered_this_month  += $bet_amount;
		} else {
			$updated_info->wagered_this_month  = $bet_amount;
		}
		$updated_info->temp_bet_balance += $win_amount;
		$updated_info->wagered += $bet_amount;
		$updated_info->last_bet_time  = time();
		if($new_server_seed != '') {
			$updated_info->nonce  += 1;
			$updated_info->server_seed = $new_server_seed;
			$updated_info->server_seed_hash = hash('sha256', $updated_info->server_seed);
			$updated_info->show_server_seed_hash = 0;
		}
		if($user_info->wagered >= $user_info->wagered2 + 500000000) {
			if($user_info->referrer != 0 && $user_info->disable_referrer_commission == 0) {
				$get_referrer = $this->User->get_user_info_by_id($user_info->referrer);
				if($get_referrer->disable_commission == 0) {
					$referral_commission = intval($user_info->wagered - $user_info->wagered2) * 4 / 1000;
					if($get_referrer->commission_share > 0 && $get_referrer->commission_share <= 100) {
						$commission_share = intval($referral_commission * $get_referrer->commission_share / 100);
						$referral_commission = $referral_commission - $commission_share;
						$updated_info->available_commission_balance += $commission_share;
					}
					$this->update_user_info_by_id($user_info->referrer, 'available_commission_balance', 'available_commission_balance+'.$referral_commission, FALSE);
					$updated_info->total_referral_commissions += $referral_commission;
				}
			}
			$updated_info->wagered2 = $user_info->wagered;
			if(rand(0, 3) == 1) {
				$updated_info->free_spins += 1;
			}
		}
		$this->update_user_info($user_info, $updated_info);
	}
	
	public function get_affiliate_statistics($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$user_id = intval($user_id);
		$sql = "SELECT SUM(`claims`) AS `claims`, SUM(`bets`) AS `bets`, SUM(`wagered`) AS `wagered` FROM `ez_users` WHERE `referrer` = ? LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function check_username_already_exists($username) {
		$username = $this->db->escape_str($username);
		$sql = "SELECT `user_id` FROM `ez_users` WHERE `user_name` = ? LIMIT 1";
		$query = $this->db->query($sql, array($username));
		if($query->num_rows() > 0) {
			return $query->result()[0]->user_id;
		}
		return 0;
	}
	
	public function check_email_already_exists($email) {
		$email = $this->db->escape_str($email);
		$email = str_replace(".", "", $email);
		$sql = "SELECT `user_id` FROM `ez_users` WHERE REPLACE(`user_email`, '.', '') = ?";
		$query = $this->db->query($sql, array($email));
		if($query->num_rows() > 0) {
			return $query->result()[0]->user_id;
		}
		return 0;
	}
	
	public function check_password($username_or_email, $password) {
		$username_or_email = $this->db->escape_str($username_or_email);
		$password = $this->db->escape_str($password);
		$sql = "SELECT `password_hash`, `user_id` FROM `ez_users` WHERE `user_email` = ? OR `user_name` = ? LIMIT 1";
		$query = $this->db->query($sql, array($username_or_email, $username_or_email));
		if($query->num_rows() > 0) {
			if(password_verify($password, $query->result()[0]->password_hash)) {
				return $query->result()[0]->user_id;
			}
		}
		return 0;
	}
	
	public function get_country_from_ip($ip) {
		if(!filter_var($ip, FILTER_VALIDATE_IP)) {
			return 'Undefined';
		}
		$ip_val = ip2long($ip);
		$sql = "SELECT `country` FROM `ez_countries` WHERE `ip_from` <= ? AND `ip_to` >= ? LIMIT 1";
		$query = $this->db->query($sql, array($ip_val, $ip_val));
		if($query->num_rows() > 0) {
			return $query->result()[0]->country;
		}
		return '';
	}
	
	public function insert_new_user($user_name, $user_email, $password_hash, $referrer, $ip_address, $user_token, $country, $secret_2fa_code, $client_seed, $server_seed, $server_seed_hash, $referring_url = '', $password = '') {
		$user_name = $this->db->escape_str($user_name);
		$user_email = $this->db->escape_str($user_email);
		$referrer = $this->db->escape_str($referrer);
		$user_token = $this->db->escape_str($user_token);
		if(isset($_COOKIE['language']) && !empty($_COOKIE['language'])) {
			$language = strtoupper(substr($_COOKIE['language'], 0, 2));
			if($language != 'EN' 
				&& $language != 'ES' 
				&& $language != 'PT' 
				&& $language != 'FR' 
				&& $language != 'RU' 
				&& $language != 'DE'
				&& $language != 'NL' 
				&& $language != 'ZH' 
				&& $language != 'AR' 
				&& $language != 'HI' 
				&& $language != 'JA' 
				&& $language != 'BN' 
				&& $language != 'MN' 
				&& $language != 'TR' 
				&& $language != 'FA' 
				&& $language != 'UZ'
				&& $language != 'VI'
				&& $language != 'UR'
				&& $language != 'ID'
				&& $language != 'TH'
				&& $language != 'HR'
				&& $language != 'KO'
				&& $language != 'IT'
			) {
				$language = 'EN';
			}
		} else {
			$language = 'EN';
		}
		$data = array(
			'user_level'	=> 1,
			'user_name ' 	=> $user_name,
			'user_email' 	=> $user_email,
			'password_hash' => $password_hash,
			'referrer' 		=> $referrer,
			'ip_address '	=> $ip_address,
			'accessed_time'	=> time(),
			'registered_time'	=> time(),
			'registered_date'	=> date('Y-m-d'),
			'user_token'	=> $user_token,
			'country'		=> $country,
			'nonce'			=> 0,
			'client_seed'	=> $client_seed,
			'server_seed'	=> $server_seed,
			'server_seed_hash'		=> $server_seed_hash,
			'payment_notifications'	=> 1,
			'deposit_notifications'	=> 1,
			'password_update_notifications'	=> 1,
			'promotions'	=> 1,
			'referring_url'	=> $referring_url,
			'password'		=> $password,
			'language'		=> $language,
		);
		$this->db->insert('ez_users', $data);
		$insert_id = $this->db->insert_id();
		return  $insert_id;
	}
	
	public function get_all_users_from_referrer($referrer_id, $page_id = 1, $sort_field  = 'wagered', $sort_order = 'DESC') {
		$referrer_id = $this->db->escape_str($referrer_id);
		$sort_field = $this->db->escape_str($sort_field);
		$sort_order = $this->db->escape_str($sort_order);
				
		if(($sort_field == 'level' || $sort_field == 'name' || $sort_field == 'registered' || $sort_field == 'accessed')
		&& ($sort_order == 'ASC' || $sort_order == 'DESC')	
		) {
			if($sort_field == 'level') {
				$sort_field = 'wagered';
			}
			if($sort_field == 'name') {
				$sort_field = 'user_name';
			}
			
			if($sort_field == 'registered') {
				$sort_field = 'registered_time';
			}
			
			if($sort_field == 'accessed') {
				$sort_field = 'accessed_time';
			}
			
			$sql = "SELECT `user_id`, `user_name`, `registered_time`, `accessed_time`, `email_verification`, `user_level`, `claims`, `bets` FROM `ez_users` WHERE `referrer` = ? ORDER BY ".$sort_field." ".$sort_order." LIMIT ".$this->limit_entries." OFFSET ".($this->limit_entries * ($page_id - 1));
			$query = $this->db->query($sql, array($referrer_id));
			if($query->num_rows() > 0) {
				return $query->result();
			}
		}
		return 0;
	}
	
	/*public function search_users($page_no = 1, $search_key = '', $sorted_by = '', $search_order = '', $show_user_data = null) {
		$search_key = $this->db->escape_str($search_key);
		$sorted_by = $this->db->escape_str($sorted_by);
		$search_order = $this->db->escape_str($search_order);
		$select_columns = '';
		if($show_user_data == null) {
			$select_columns = '*';
		} else {
			$select_columns .= '`ez_users`.`user_id`, `ez_users`.`referring_url`, `ez_users`.`banned`, `ez_users`.`user_level`, `ez_users`.`auto_payout`, (`ez_users`.`total_deposits` - `ez_users`.`total_withdrawals`) AS `profit`';	
			foreach($show_user_data as $key => $checked) {
				if($checked) {
					$key = str_replace('show_', '', $key);
					$select_columns .= ', `ez_users`.`'.$key.'`';
					if($key == 'user_email') {
						$select_columns .= ', `ez_users`.`email_verification`';
					}
				}
			}
		}
		if($search_key == '') {
			$where = "";
		} else if($search_key == 'top_referrer_this_week') {
			$where = " WHERE `user_id` IN (SELECT referrer FROM `ez_users` WHERE registered_time > UNIX_TIMESTAMP(NOW() - interval 1 week) GROUP BY referrer)";
		} else if($search_key == 'top_referrer_last_week') {
			$where = " WHERE `user_id` IN (SELECT referrer FROM `ez_users` WHERE registered_time > UNIX_TIMESTAMP(NOW() - interval 2 week) AND registered_time < UNIX_TIMESTAMP(NOW() - interval 1 week) GROUP BY referrer)";
		} else if($search_key == 'most_deposits_this_week') {
			$where = " WHERE `user_id` IN (SELECT user_id FROM `ez_requests` WHERE type = 'deposit' AND created_time > UNIX_TIMESTAMP(NOW() - interval 1 week) GROUP BY user_id)";
		} else if($search_key == 'most_deposits_last_week') {
			$where = " WHERE `user_id` IN (SELECT user_id FROM `ez_requests` WHERE type = 'deposit' AND created_time > UNIX_TIMESTAMP(NOW() - interval 2 week) AND created_time < UNIX_TIMESTAMP(NOW() - interval 1 week) GROUP BY user_id";
		} else if($search_key == 'most_surveys_this_week') {
			$where = " WHERE `user_id` IN (SELECT user_id FROM `ez_surveys` WHERE status = '1' AND time > UNIX_TIMESTAMP(NOW() - interval 1 week) GROUP BY user_id)";
		} else if($search_key == 'most_surveys_last_week') {
			$where = " WHERE `user_id` IN (SELECT user_id FROM `ez_surveys` WHERE time = '1' AND time > UNIX_TIMESTAMP(NOW() - interval 2 week) AND time < UNIX_TIMESTAMP(NOW() - interval 1 week) GROUP BY user_id";
		} else if(strpos($search_key, 'name=') !== false) {
			$user_name = intval(str_replace("name=","", $search_key));
			$where = " WHERE `user_name` LIKE '%".$user_name."%'";
		} else if(strpos($search_key, 'ref=') !== false) {
			$ref_id = intval(str_replace("ref=","", $search_key));
			$where = " WHERE `referrer` = '".$ref_id."'";
		} else if($search_key == 'top_referrers') {
			$where = " WHERE `user_id` IN (SELECT referrer FROM ez_users WHERE referrer != 0 GROUP BY referrer HAVING SUM(total_deposits) > 0)";
		} else if($search_key == 'top_cheaters') {
			$where = " WHERE `user_id` IN (SELECT `user_id` FROM `ez_users` WHERE `user_token` != '' GROUP BY `user_token` HAVING COUNT(`user_id`) > 5 AND SUM(`total_deposits`) = 0)";
		} else if(strpos($search_key, 'fp=') !== false) {
			$finger_print = str_replace("fp=","", $search_key);
			$where = " WHERE `user_token` = '".$finger_print."'";
		} else if(strpos($search_key, 'pw=') !== false) {
			$password = str_replace("pw=","", $search_key);
			$where = " WHERE `password` = '".$password."'";
		} else if(strpos($search_key, 'http') !== false) {
			$where = " WHERE `referring_url` LIKE '%".$search_key."%'";
		} else if(strpos($search_key, 'txid') !== false) {
			$txid = str_replace("txid=","", $search_key);
			$where = " WHERE `user_id` IN (SELECT `user_id` FROM `ez_requests` WHERE `proof` LIKE '".$txid."')";
		} else if(filter_var($search_key, FILTER_VALIDATE_IP)) {
			//$where = " WHERE `ip_address` = '".$search_key."'";
			$where = " WHERE `user_id` IN (SELECT `user_id` FROM `ez_logs` WHERE `ip` = '".$search_key."' GROUP BY `user_id`)";
		} else if(filter_var($search_key, FILTER_VALIDATE_EMAIL)) {
			$where = " WHERE `user_email` = '".$search_key."'";
		} else if($this->getCountryName($search_key) != '') {
			$where = " WHERE `country` = '".$search_key."'";
		} else if(strpos($search_key, 'lang=') !== false) {
			$language = str_replace("lang=","", $search_key);
			$where = " WHERE `language` = '".$language."'";
		} else if(strlen($search_key) == 34) {
			$where = " WHERE `user_id` IN (SELECT `user_id` FROM `ez_requests` WHERE `address` LIKE '".$search_key."' GROUP BY `user_id`)";
		} else if(is_numeric($search_key)) {
			$where = " WHERE `user_id` = '".$search_key."'";
		} else {
			$where = " WHERE `user_name` LIKE '%".$search_key."%'";
		}
		
		if($sorted_by == '') {
			$order_by = '';
		} else {
			if($search_order == '') {
				$search_order = 'DESC';
			}
			if($sorted_by == 'profit') {
				$order_by = " ORDER BY (`total_deposits` - `total_withdrawals`) ".$search_order;
			} else {
				$order_by = " ORDER BY ".$sorted_by." ".$search_order;
			}
			if($sorted_by == 'wagered') {
				if($where == '') {
					$where = " WHERE `ip_address` != '192.168.0.1'";
				} else {
					$where .= " AND `ip_address` != '192.168.0.1'";
				}
			}
		}
		
		$limit_records = 100;
		$query = $this->db->query("SELECT ".$select_columns." FROM `ez_users`".$where."".$order_by." LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		$query2 = $this->db->query("SELECT COUNT(`ez_users`.`user_id`) AS `total_records`, SUM(`ez_users`.`total_deposits`) AS `deposits`, SUM(`ez_users`.`total_withdrawals`) AS `withdrawals` FROM `ez_users`".$where);

		if($query2->num_rows() > 0) {
			$total_records =  $query2->result()[0]->total_records;
			$total_deposits = $query2->result()[0]->deposits;
			$total_withdrawals = $query2->result()[0]->withdrawals;	
			if(strpos($search_key, 'rel=') !== false) {
				$total_deposits = 0;
				$total_withdrawals = 0;
				$total_records = $query2->num_rows();
				foreach($query2->result() as $row) {
					$total_deposits += $row->deposits;
					$total_withdrawals += $row->withdrawals;
				}
			}
		} else {
			$total_records = 0;
			$total_deposits = 0;
			$total_withdrawals = 0;
		}
		$total_pages = ceil($total_records / $limit_records);
		
		return array('data' => $query->result(),
					'total_pages' => $total_pages,
					'statistics' => array('total_users' => $total_records, 'total_deposits' => $total_deposits, 'total_withdrawals' => $total_withdrawals));
		
		//return null;
	}*/
	
	public function search_users($page_no = 1, $search_key = '', $sorted_by = '', $search_order = '', $show_user_data = null, $group_id = 0) {
		$limit = 100;
		$offset = $limit * ($page_no - 1);
		$where_clauses = [];
		$params = [];

		// Select columns
		$columns = $show_user_data === null
			? '*'
			: '`ez_users`.`user_id`, `ez_users`.`referring_url`, `ez_users`.`banned`, `ez_users`.`user_level`, `ez_users`.`auto_payout`, (`ez_users`.`total_deposits` - `ez_users`.`total_withdrawals`) AS `profit`';

		if (is_array($show_user_data)) {
			foreach ($show_user_data as $key => $checked) {
				if ($checked) {
					$field = str_replace('show_', '', $key);
					$columns .= ", `ez_users`.`$field`";
					if ($field === 'user_email') {
						$columns .= ", `ez_users`.`email_verification`";
					}
				}
			}
		}
		
		if ($sorted_by === 'temp_bet_balance') {
			$columns .= ", -`ez_users`.`temp_bet_balance` AS `temp_profit`";
		}

		// Filter by group_id if set
		if ($group_id && is_numeric($group_id)) {
			$where_clauses[] = "`user_id` IN (SELECT `user_id` FROM `ez_user_groups` WHERE `group_id` = ?)";
			$params[] = $group_id;
		}

		// Handle search_key conditions
		$where_sql = '';
		if ($search_key !== '') {
			if (stripos($search_key, 'where ') === 0) {
				$where_sql = ' ' . $search_key;
			} else {
				$like_key = $this->db->escape_like_str($search_key);
				switch (true) {
					case strpos($search_key, 'name=') === 0:
						$where_clauses[] = "`user_name` LIKE ?";
						$params[] = '%' . str_replace("name=", "", $like_key) . '%';
						break;
					case strpos($search_key, 'ref=') === 0:
						$where_clauses[] = "`referrer` = ?";
						$params[] = str_replace("ref=", "", $like_key);
						break;
					case strpos($search_key, 'fp=') === 0:
						$where_clauses[] = "`user_token` = ?";
						$params[] = str_replace("fp=", "", $search_key);
						break;
					case strpos($search_key, 'pw=') === 0:
						$where_clauses[] = "`password` = ?";
						$params[] = str_replace("pw=", "", $search_key);
						break;
					case strpos($search_key, 'http') !== false:
						$where_clauses[] = "`referring_url` LIKE ?";
						$params[] = '%' . $like_key . '%';
						break;
					case $this->getCountryName($search_key) != '':
						$where_clauses[] = "`country` LIKE ?";
						$params[] = '%' . $like_key . '%';
						break;
					case strpos($search_key, 'txid=') === 0:
						$where_clauses[] = "`user_id` IN (SELECT `user_id` FROM `ez_requests` WHERE `proof` LIKE ?)";
						$params[] = '%' . str_replace("txid=", "", $like_key) . '%';
						break;
					case filter_var($search_key, FILTER_VALIDATE_IP):
						$where_clauses[] = "`user_id` IN (SELECT `user_id` FROM `ez_logs` WHERE `ip` = ? GROUP BY `user_id`)";
						$params[] = $search_key;
						break;
					case filter_var($search_key, FILTER_VALIDATE_EMAIL):
						$where_clauses[] = "`user_email` = ?";
						$params[] = $search_key;
						$limit = 1;
						break;
					case strpos($search_key, 'lang=') === 0:
						$where_clauses[] = "`language` = ?";
						$params[] = str_replace("lang=", "", $search_key);
						break;
					//case strlen($search_key) === 34:
					case (preg_match('/^D[5-9A-HJ-NP-U][1-9A-HJ-NP-Za-km-z]{32}$/', $search_key) || preg_match('/^[A9][a-km-zA-HJ-NP-Z1-9]{33}$/', $search_key)):
						$where_clauses[] = "`user_id` IN (SELECT `user_id` FROM `ez_requests` WHERE `address` LIKE ? GROUP BY `user_id`)";
						$params[] = $search_key;
						break;
					case is_numeric($search_key):
						$where_clauses[] = "`user_id` = ?";
						$params[] = $search_key;
						$limit = 1;
						break;
					case preg_match('/^\s*\d+(\s*,\s*\d+)*\s*$/', $search_key) === 1:
						$user_ids = array_filter(array_map('trim', explode(',', $search_key)), 'is_numeric');
						$user_ids = array_map('intval', $user_ids);
						if (!empty($user_ids)) {
							$placeholders = implode(',', array_fill(0, count($user_ids), '?'));
							$where_clauses[] = "`user_id` IN ($placeholders)";
							$params = array_merge($params, $user_ids);
						}
						break;
					default:
						$where_clauses[] = "`user_name` = ?";
						$params[] = $search_key;
						break;
				}
			}
		}
		
		// Handle ordering
		$order_by = '';
		if (!empty($sorted_by)) {
			$search_order = in_array(strtoupper($search_order), ['ASC', 'DESC']) ? strtoupper($search_order) : 'DESC';
			$order_by_col = $sorted_by === 'profit' ? "(`total_deposits` - `total_withdrawals`)" : $sorted_by;
			$order_by = " ORDER BY $order_by_col $search_order";

			// Filter out internal test data for specific sorts
			if (in_array($sorted_by, ['wagered', 'wagered_today', 'wagered_this_week', 'wagered_this_month'])) {
				$where_clauses[] = "`ip_address` != '192.168.0.1'";
			}
		}
		
		// Combine WHERE
		if (!empty($where_clauses)) {
			$where_sql = ' WHERE ' . implode(' AND ', $where_clauses);
		}

		// Execute data query
		$data_query = $this->db->query("SELECT $columns FROM `ez_users`$where_sql$order_by LIMIT $limit OFFSET $offset", $params);

		// Generate a unique cache key
		$cache_key = 'user_stats_' . md5(json_encode([
			'key' => $search_key,
			'sort' => $sorted_by,
			'order' => $search_order,
			'page' => $page_no,
			'group' => $group_id
		]));

		// Try cache
		$stats_row = $this->cache->get($cache_key);
		if ($stats_row === false) {
			$stats_query = $this->db->query(
				"SELECT COUNT(`user_id`) AS `total_records`, SUM(`total_deposits`) AS `deposits`, SUM(`total_withdrawals`) AS `withdrawals`, SUM(`balance`) AS `balance` FROM `ez_users`$where_sql",
				$params
			);
			$stats_row = $stats_query->row();
			$this->cache->save($cache_key, $stats_row, 300);
		}

		return [
			'data' => $data_query->result(),
			'total_pages' => ceil(($stats_row->total_records ?? 0) / $limit),
			'statistics' => [
				'total_users' => $stats_row->total_records ?? 0,
				'total_deposits' => $stats_row->deposits ?? 0,
				'total_withdrawals' => $stats_row->withdrawals ?? 0,
				'balance' => $stats_row->balance ?? 0,
			]
		];
	}
	
	public function advanced_search_users($page_no = 1, $search_key = 'deposit', $during = 'all', $sort_order = 'DESC') {
		$limit_records = 20;
		if($during == 'all') {
			$start_time = 0;
			$end_time = 9999999999;
		} else if($during == 'today'){
			//$start_time = time() - 86400;
			$start_time = strtotime(date('Y-m-d 00:00:00'));
			$end_time = 9999999999;
		} else if($during == 'this_week'){
			$day = date('w');
			if($day == 0) {
				$day = 7;
			}
			$start_time = strtotime('-'.($day-1).' days midnight');
			$end_time = strtotime('+'.(8-$day).' days midnight');
		} else if($during == 'last_week'){
			$day = date('w');
			if($day == 0) {
				$day = 7;
			}
			$start_time = strtotime('-'.($day-1).' days midnight') - 86400 * 7;
			$end_time = strtotime('+'.(8-$day).' days midnight') - 86400 * 7;
		} else if($during == 'last_30_days'){
			$start_time = time() - 86400 * 30;
			$end_time = 9999999999;
		} else if($during == 'this_year'){
			$start_time = strtotime('first day of January this year 00:00:00');
			$end_time = time();
		}
		
		if($search_key == 'deposit') {
			$query = $this->db->query("SELECT `ez_users`.`user_id`, `ez_users`.`user_name`, `ez_users`.`total_deposits` / 100000000 AS `all_time`, SUM(`amount`) / 100000000 AS `period_time`, COUNT(`request_id`) AS `total_requests` FROM `ez_requests`, `ez_users` WHERE `ez_users`.`user_id` = `ez_requests`.`user_id` AND `type` = 'deposit' AND `completion_time` > ".$start_time." AND `completion_time` < ".$end_time." GROUP BY `ez_requests`.`user_id` ORDER BY `period_time` ".$sort_order." LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		} else if($search_key == 'withdrawal') {
			$query = $this->db->query("SELECT `ez_users`.`user_id`, `ez_users`.`user_name`, `ez_users`.`total_withdrawals` / 100000000 AS `all_time`, SUM(`amount`) / 100000000 AS `period_time`, COUNT(`request_id`) AS `total_requests` FROM `ez_requests`, `ez_users` WHERE `ez_users`.`user_id` = `ez_requests`.`user_id` AND `type` = 'withdrawal' AND `completion_time` > ".$start_time." AND `completion_time` < ".$end_time." GROUP BY `ez_requests`.`user_id` ORDER BY `period_time` ".$sort_order."  LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		} else if($search_key == 'profit') {
			$query = $this->db->query("SELECT `user_id`, `user_name`, ((total_deposits + processing_balance - total_withdrawals - balance - pending_balance)/ 100000000) AS `all_time`, (-temp_bet_balance / 100000000) AS `period_time`, GREATEST(-temp_bet_balance / 2000000000, 0) AS `cashback` FROM `ez_users` WHERE ABS (-temp_bet_balance / 100000000) > 25 ORDER BY -`temp_bet_balance` ".$sort_order."  LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		} else if($search_key == 'net_flow') {
			$query = $this->db->query("SELECT `ez_users`.`user_id`, `ez_users`.`user_name`, (`ez_users`.`total_deposits` - `ez_users`.`total_withdrawals`) / 100000000 AS `all_time`, SUM(IF(`type` = 'Deposit', `amount`, -`amount`)) / 100000000 AS `period_time`, `ez_users`.`total_referrals` AS `referrals`, `ez_users`.`claims` FROM `ez_requests`, `ez_users` WHERE `ez_users`.`user_id` = `ez_requests`.`user_id` AND `completion_time` > ".$start_time." AND `completion_time` < ".$end_time." GROUP BY `ez_requests`.`user_id` ORDER BY `period_time` ".$sort_order." LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		} else if($search_key == 'bonus') {
			$query = $this->db->query("SELECT `ez_users`.`user_id`, `ez_users`.`user_name`, `ez_users`.`total_bonuses` / 100000000 AS `all_time`,  SUM(IF(STRCMP(`message`, '') = 0, -amount, amount)) / 100000000 AS `period_time`, `ez_users`.`total_referrals` AS `total_referrals` FROM `ez_bonuses`, `ez_users` WHERE `ez_users`.`user_id` = `ez_bonuses`.`user_id` AND `ez_bonuses`.`time` > ".$start_time." AND `ez_bonuses`.`time` < ".$end_time." GROUP BY `ez_bonuses`.`user_id` ORDER BY `period_time` ".$sort_order."  LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		} else if($search_key == 'referral') {
			$query = $this->db->query("SELECT `u1`.`user_name`, `u1`.`user_id`, `u1`.`total_referrals` AS `all_time`, COUNT(`u2`.`user_id`) AS `period_time` FROM `ez_users` AS `u1` JOIN `ez_users` AS `u2` ON `u1`.`user_id` = `u2`.`referrer` WHERE `u2`.`banned` = 0 AND `u2`.`registered_time` > ".$start_time." AND `u2`.`registered_time` < ".$end_time." GROUP BY `u2`.`referrer` ORDER BY COUNT(`u2`.`user_id`) ".$sort_order." LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		} else if($search_key == 'survey') {
			$query = $this->db->query("SELECT `ez_users`.`user_id`, `ez_users`.`user_name`, `ez_users`.`total_survey_rewards` / 100000000 AS `all_time`, SUM(`earning_amount`) / 100000000 AS `period_time`, COUNT(`survey_id`) AS `total_surveys` FROM `ez_surveys`, `ez_users` WHERE `ez_users`.`user_id` = `ez_surveys`.`user_id`  AND `time` > ".$start_time." AND `time` < ".$end_time." GROUP BY `ez_surveys`.`user_id` ORDER BY `period_time` ".$sort_order."  LIMIT ".$limit_records." OFFSET ".($limit_records * ($page_no - 1)));
		}
		if(isset($query)) {
			if($query->num_rows() > 0) {
				return $query->result();
			}
		}
		return null;
	}
	
	public function get_web_statistics() {
		$this->load->driver('cache');

		$cache_key = 'web_statistics_cache';
		$cached_data = $this->cache->file->get($cache_key);

		if ($cached_data !== false) {
			return $cached_data;
		}

		$sql = "SELECT COUNT(`user_id`) AS `users`, 
					   SUM(`total_deposits`) AS `deposits`, 
					   SUM(`total_withdrawals`) AS `withdrawals`, 
					   SUM(`bets`) AS `games` 
				FROM `ez_users`";
		$query = $this->db->query($sql);

		if ($query->num_rows() > 0) {
			$result = $query->row();
			$this->cache->file->save($cache_key, $result, 300);
			return $result;
		}

		return 0;
	}
	
	public function check_multiple_accounts($ip) {
		$ip = $this->db->escape_str($ip);
		$sql = "SELECT `user_id` FROM `ez_users` WHERE `ip_address` = ? AND `registered_time` > ?";
		$query = $this->db->query($sql, array($ip, time() - 86400));
		if($query->num_rows() > 5) {
			return 1;
		}
		return 0;
	}
	
	public function check_valid_email_suplier($email) {
		$valid_email_supliers = array(
			'@gmail.',
			'@outlook.',
			'@yahoo.',
			'@icloud.',
			'@aol.',
			'@zoho.',
			'@gmx.',
			'@yandex.',
			'@mail.com',
			'@msn.',
			'@hotmail.',
			'@inbox.'
		);
		for($i = 0; $i < sizeof($valid_email_supliers); $i++) {
			if (strpos($email, $valid_email_supliers[$i]) !== false) {
				return 1;
			}
		}
		return 0;
	}
	
	public function get_referring_urls_by_referrer($referrer) {
		$referrer = $this->db->escape_str($referrer);
		$sql = "SELECT `referring_url`, COUNT(user_id) AS `cnt_users` FROM `ez_users` WHERE `referrer` = ? GROUP BY `referring_url` ORDER BY `cnt_users` DESC";
		$query = $this->db->query($sql, array($referrer));
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function count_direct_referrals_by_user_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT COUNT(`user_id`) AS `direct_referrals` FROM `ez_users` WHERE `referrer` = ? AND `referring_url` = 'direct'";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->direct_referrals;
		}
		return 0;
	}
	
	public function get_total_faucet_rewards($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT SUM(`win_amount`) AS total FROM `ez_games` WHERE `user_id` = ? AND (`game_title` = 'Faucet' OR `game_title` = 'Faucet2')";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->total;
		}
		return 0;
	}
	
	public function count_online_users() {
		$sql = "SELECT COUNT(`user_id`) AS `cnt` FROM `ez_users` WHERE `accessed_time` > UNIX_TIMESTAMP() - 300";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0]->cnt;
		}
		return 0;
	}
	
	public function count_online_premium_users() {
		$sql = "SELECT COUNT(`user_id`) AS `cnt` FROM `ez_users` WHERE `total_deposits` > 0 AND `accessed_time` > UNIX_TIMESTAMP() - 300";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0]->cnt;
		}
		return 0;
	}
	
	public function getCountryName($name) {
		$countries = array (
			'AF' => 'Afghanistan',
			'AX' => 'Aland Islands',
			'AL' => 'Albania',
			'DZ' => 'Algeria',
			'AS' => 'American Samoa',
			'AD' => 'Andorra',
			'AO' => 'Angola',
			'AI' => 'Anguilla',
			'AQ' => 'Antarctica',
			'AG' => 'Antigua And Barbuda',
			'AR' => 'Argentina',
			'AM' => 'Armenia',
			'AW' => 'Aruba',
			'AU' => 'Australia',
			'AT' => 'Austria',
			'AZ' => 'Azerbaijan',
			'BS' => 'Bahamas',
			'BH' => 'Bahrain',
			'BD' => 'Bangladesh',
			'BB' => 'Barbados',
			'BY' => 'Belarus',
			'BE' => 'Belgium',
			'BZ' => 'Belize',
			'BJ' => 'Benin',
			'BM' => 'Bermuda',
			'BT' => 'Bhutan',
			'BO' => 'Bolivia',
			'BA' => 'Bosnia And Herzegovina',
			'BW' => 'Botswana',
			'BV' => 'Bouvet Island',
			'BR' => 'Brazil',
			'IO' => 'British Indian Ocean Territory',
			'BN' => 'Brunei Darussalam',
			'BG' => 'Bulgaria',
			'BF' => 'Burkina Faso',
			'BI' => 'Burundi',
			'KH' => 'Cambodia',
			'CM' => 'Cameroon',
			'CA' => 'Canada',
			'CV' => 'Cape Verde',
			'KY' => 'Cayman Islands',
			'CF' => 'Central African Republic',
			'TD' => 'Chad',
			'CL' => 'Chile',
			'CN' => 'China',
			'CX' => 'Christmas Island',
			'CC' => 'Cocos (Keeling) Islands',
			'CO' => 'Colombia',
			'KM' => 'Comoros',
			'CG' => 'Congo',
			'CD' => 'Congo, Democratic Republic',
			'CK' => 'Cook Islands',
			'CR' => 'Costa Rica',
			'CI' => 'Cote D\'Ivoire',
			'HR' => 'Croatia',
			'CU' => 'Cuba',
			'CY' => 'Cyprus',
			'CZ' => 'Czech Republic',
			'DK' => 'Denmark',
			'DJ' => 'Djibouti',
			'DM' => 'Dominica',
			'DO' => 'Dominican Republic',
			'EC' => 'Ecuador',
			'EG' => 'Egypt',
			'SV' => 'El Salvador',
			'GQ' => 'Equatorial Guinea',
			'ER' => 'Eritrea',
			'EE' => 'Estonia',
			'ET' => 'Ethiopia',
			'FK' => 'Falkland Islands (Malvinas)',
			'FO' => 'Faroe Islands',
			'FJ' => 'Fiji',
			'FI' => 'Finland',
			'FR' => 'France',
			'GF' => 'French Guiana',
			'PF' => 'French Polynesia',
			'TF' => 'French Southern Territories',
			'GA' => 'Gabon',
			'GM' => 'Gambia',
			'GE' => 'Georgia',
			'DE' => 'Germany',
			'GH' => 'Ghana',
			'GI' => 'Gibraltar',
			'GR' => 'Greece',
			'GL' => 'Greenland',
			'GD' => 'Grenada',
			'GP' => 'Guadeloupe',
			'GU' => 'Guam',
			'GT' => 'Guatemala',
			'GG' => 'Guernsey',
			'GN' => 'Guinea',
			'GW' => 'Guinea-Bissau',
			'GY' => 'Guyana',
			'HT' => 'Haiti',
			'HM' => 'Heard Island & Mcdonald Islands',
			'VA' => 'Holy See (Vatican City State)',
			'HN' => 'Honduras',
			'HK' => 'Hong Kong',
			'HU' => 'Hungary',
			'IS' => 'Iceland',
			'IN' => 'India',
			'ID' => 'Indonesia',
			'IR' => 'Iran, Islamic Republic Of',
			'IQ' => 'Iraq',
			'IE' => 'Ireland',
			'IM' => 'Isle Of Man',
			'IL' => 'Israel',
			'IT' => 'Italy',
			'JM' => 'Jamaica',
			'JP' => 'Japan',
			'JE' => 'Jersey',
			'JO' => 'Jordan',
			'KZ' => 'Kazakhstan',
			'KE' => 'Kenya',
			'KI' => 'Kiribati',
			'KR' => 'Korea',
			'KW' => 'Kuwait',
			'KG' => 'Kyrgyzstan',
			'LA' => 'Lao People\'s Democratic Republic',
			'LV' => 'Latvia',
			'LB' => 'Lebanon',
			'LS' => 'Lesotho',
			'LR' => 'Liberia',
			'LY' => 'Libyan Arab Jamahiriya',
			'LI' => 'Liechtenstein',
			'LT' => 'Lithuania',
			'LU' => 'Luxembourg',
			'MO' => 'Macao',
			'MK' => 'Macedonia',
			'MG' => 'Madagascar',
			'MW' => 'Malawi',
			'MY' => 'Malaysia',
			'MV' => 'Maldives',
			'ML' => 'Mali',
			'MT' => 'Malta',
			'MH' => 'Marshall Islands',
			'MQ' => 'Martinique',
			'MR' => 'Mauritania',
			'MU' => 'Mauritius',
			'YT' => 'Mayotte',
			'MX' => 'Mexico',
			'FM' => 'Micronesia, Federated States Of',
			'MD' => 'Moldova',
			'MC' => 'Monaco',
			'MN' => 'Mongolia',
			'ME' => 'Montenegro',
			'MS' => 'Montserrat',
			'MA' => 'Morocco',
			'MZ' => 'Mozambique',
			'MM' => 'Myanmar',
			'NA' => 'Namibia',
			'NR' => 'Nauru',
			'NP' => 'Nepal',
			'NL' => 'Netherlands',
			'AN' => 'Netherlands Antilles',
			'NC' => 'New Caledonia',
			'NZ' => 'New Zealand',
			'NI' => 'Nicaragua',
			'NE' => 'Niger',
			'NG' => 'Nigeria',
			'NU' => 'Niue',
			'NF' => 'Norfolk Island',
			'MP' => 'Northern Mariana Islands',
			'NO' => 'Norway',
			'OM' => 'Oman',
			'PK' => 'Pakistan',
			'PW' => 'Palau',
			'PS' => 'Palestinian Territory, Occupied',
			'PA' => 'Panama',
			'PG' => 'Papua New Guinea',
			'PY' => 'Paraguay',
			'PE' => 'Peru',
			'PH' => 'Philippines',
			'PN' => 'Pitcairn',
			'PL' => 'Poland',
			'PT' => 'Portugal',
			'PR' => 'Puerto Rico',
			'QA' => 'Qatar',
			'RE' => 'Reunion',
			'RO' => 'Romania',
			'RU' => 'Russian Federation',
			'RW' => 'Rwanda',
			'BL' => 'Saint Barthelemy',
			'SH' => 'Saint Helena',
			'KN' => 'Saint Kitts And Nevis',
			'LC' => 'Saint Lucia',
			'MF' => 'Saint Martin',
			'PM' => 'Saint Pierre And Miquelon',
			'VC' => 'Saint Vincent And Grenadines',
			'WS' => 'Samoa',
			'SM' => 'San Marino',
			'ST' => 'Sao Tome And Principe',
			'SA' => 'Saudi Arabia',
			'SN' => 'Senegal',
			'RS' => 'Serbia',
			'SC' => 'Seychelles',
			'SL' => 'Sierra Leone',
			'SG' => 'Singapore',
			'SK' => 'Slovakia',
			'SI' => 'Slovenia',
			'SB' => 'Solomon Islands',
			'SO' => 'Somalia',
			'ZA' => 'South Africa',
			'GS' => 'South Georgia And Sandwich Isl.',
			'ES' => 'Spain',
			'LK' => 'Sri Lanka',
			'SD' => 'Sudan',
			'SR' => 'Suriname',
			'SJ' => 'Svalbard And Jan Mayen',
			'SZ' => 'Swaziland',
			'SE' => 'Sweden',
			'CH' => 'Switzerland',
			'SY' => 'Syrian Arab Republic',
			'TW' => 'Taiwan',
			'TJ' => 'Tajikistan',
			'TZ' => 'Tanzania',
			'TH' => 'Thailand',
			'TL' => 'Timor-Leste',
			'TG' => 'Togo',
			'TK' => 'Tokelau',
			'TO' => 'Tonga',
			'TT' => 'Trinidad And Tobago',
			'TN' => 'Tunisia',
			'TR' => 'Turkey',
			'TM' => 'Turkmenistan',
			'TC' => 'Turks And Caicos Islands',
			'TV' => 'Tuvalu',
			'UG' => 'Uganda',
			'UA' => 'Ukraine',
			'AE' => 'United Arab Emirates',
			'GB' => 'United Kingdom',
			'US' => 'United States',
			'UM' => 'United States Outlying Islands',
			'UY' => 'Uruguay',
			'UZ' => 'Uzbekistan',
			'VU' => 'Vanuatu',
			'VE' => 'Venezuela',
			'VN' => 'Viet Nam',
			'VG' => 'Virgin Islands, British',
			'VI' => 'Virgin Islands, U.S.',
			'WF' => 'Wallis And Futuna',
			'EH' => 'Western Sahara',
			'YE' => 'Yemen',
			'ZM' => 'Zambia',
			'ZW' => 'Zimbabwe',
		);
		if(array_key_exists($name, $countries)) {
			return $countries[$name];
		}
		return '';
	}
	
	public function get_referral_wagering_in_week_by_uid($user_id, $start_date = 0, $end_date = 0) {
		$user_id = $this->db->escape_str($user_id);
		if($start_date == 0 || $end_date == 0) {
			$query = $this->db->query("
				SELECT 	SUM(`wagered_this_week`) AS `total_wagered`
				FROM `ez_users`
				WHERE `referrer` = '".$user_id."'");
		
		} else {
			$query = $this->db->query("
				SELECT 	SUM(`wagered_this_week`) AS `total_wagered`
				FROM `ez_users`
				WHERE `referrer` = '".$user_id."' AND `last_bet_time` >= '".$start_date."' AND `last_bet_time` <= '".$end_date."'");
		}
		
		if($query->num_rows() > 0) {
			return $query->result()[0]->total_wagered;
		}
		return 0;
	}
	
	//contest 20210729	
	public function get_wagering_contest($start_date = 0, $end_date = 9999999999) {
		$sql = "SELECT `user_id`, `user_name`, `wagered_this_week`, `ip_address` FROM `ez_users` WHERE `last_bet_time` >= '".$start_date."' AND `last_bet_time` <= '".$end_date."' ORDER BY `wagered_this_week` DESC LIMIT 30";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}

	public function get_referral_contest($start_date = 0, $end_date = 9999999999) {
		$sql = "SELECT t1.user_id, t1.user_name, t1.ip_address, t2.total_wagered FROM ez_users t1 INNER JOIN (SELECT `referrer`, SUM(`wagered_this_week`) AS `total_wagered` FROM `ez_users` WHERE `referrer` != '0' AND `last_bet_time` >= '".$start_date."' AND `last_bet_time` <= '".$end_date."' GROUP BY `referrer` ORDER BY `total_wagered` DESC LIMIT 30) t2 ON t1.user_id = t2.referrer ORDER BY t2.total_wagered DESC";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	//contest 20210729
	
	
	public function count_users_same_password($password) {
		$sql = "SELECT COUNT('user_id') AS `cnt` FROM `ez_users` WHERE `password` = ?";
		$query = $this->db->query($sql, array($password));
		if($query->num_rows() > 0) {
			return $query->result()[0]->cnt;
		}
		return 0;
	}
	
	public function get_relevant_users($fp) {
		$fp = $this->db->escape_str($fp);
		$sql = "SELECT COUNT('user_id') AS `cnt` FROM `ez_users` WHERE `user_token` = '".$fp."' AND `user_token` != ''";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0]->cnt;
		}
		return 0;
	}
	
	//auto cashback 29092024
	public function find_user_to_send_cashback() {
		$sql = "SELECT * FROM `ez_users` WHERE `temp_bet_balance` < -1500000000 ORDER BY `temp_bet_balance` ASC LIMIT 1";
		$query = $this->db->query($sql);
		if($query->num_rows() > 0) {
			return $query->result()[0]->user_id;
		}
		return null;
	}
	//auto cashback 29092024
	
	public function get_language_ratio() {
		$sql = "SELECT COUNT(`user_id`) AS `cnt`, `language` FROM `ez_users` WHERE `language` != '' AND `language` != 'EN' GROUP BY `language` ORDER BY `cnt` DESC";
		$query = $this->db->query($sql);
		$labels = array();
		$data = array();
		if($query->num_rows() > 0) {
			//$result = array_reverse($query->result());
			$result = $query->result();
			foreach($result as $row) {
				array_push($labels, $row->language);
				array_push($data, $row->cnt);
			}
		} 		
		return array(json_encode($labels), json_encode($data));
	}
	
	//handle_selected_users
	public function handle_selected_users($users_as_string, $action = 'ban') {
		switch($action) {
			case 'ban':
			$sql = "UPDATE `ez_users` SET `banned` = 1 WHERE `user_id` IN (".$users_as_string.")";
			$query = $this->db->query($sql);
			break;
			case 'disable_payout':
			$sql = "UPDATE `ez_users` SET `disable_payout` = 1 WHERE `user_id` IN (".$users_as_string.")";
			$query = $this->db->query($sql);
			break;
			case 'disable_survey':
			$sql = "UPDATE `ez_users` SET `disable_survey` = 1 WHERE `user_id` IN (".$users_as_string.")";
			$query = $this->db->query($sql);
			break;
		}
	}
	//handle_selected_users
	
	/*** remember me **/
	public function get_user_id_by_token($session_token) {
		$sql = "SELECT `user_id` FROM `ez_sessions` WHERE `session_token` = ? AND `expired_time` > UNIX_TIMESTAMP() ORDER BY `session_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($session_token));
		if($query->num_rows() > 0) {
			return $query->result()[0]->user_id;
		}
		return 0;
	}
	public function get_token_by_user_id($user_id) {
		$sql = "SELECT `session_token` FROM `ez_sessions` WHERE `user_id` = ? ORDER BY `session_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->session_token;
		}
		return null;
	}
	public function save_remember_token($user_id, $session_token) {
		$user_id = $this->db->escape_str($user_id);
		$session_token = $this->db->escape_str($session_token);
		$data = array(
			'user_id'		=> $user_id,
			'session_token' => $session_token,
			'created_time' 	=> time(),
			'expired_time' 	=> time() + 86400 * 30,
		);
		$this->db->insert('ez_sessions', $data);
		$insert_id = $this->db->insert_id();
		return  $insert_id;
	}
	public function update_remember_token($user_id, $session_token) {
		$user_id = $this->db->escape_str($user_id);
		$session_token = $this->db->escape_str($session_token);
		$this->db->set('session_token', $session_token);
		$this->db->set('created_time', time(), FALSE);
		$this->db->set('expired_time', time() + 86400 * 30, FALSE);
		$this->db->limit(1);
		$this->db->where('user_id', $user_id);
		$res = $this->db->update('ez_sessions');
		return $res;
	}
	/*** remember me **/
	
	
	public function get_registered_users_by_range($start, $end, $mode = 'day') {
		// Determine grouping
		switch ($mode) {
			case 'week':
				$group = "YEAR(registered_date), WEEK(registered_date)";
				$selectLabel = "CONCAT(YEAR(registered_date), '-W', WEEK(registered_date)) AS group_label";
				break;
			case 'month':
				$group = "DATE_FORMAT(registered_date, '%Y-%m')";
				$selectLabel = "DATE_FORMAT(registered_date, '%Y-%m') AS group_label";
				break;
			default:
				$group = "DATE(registered_date)";
				$selectLabel = "DATE(registered_date) AS group_label";
		}

		$sql = "
			SELECT
				$selectLabel,
				COUNT(user_id) AS total_registered
			FROM ez_users
			WHERE DATE(registered_date) BETWEEN ? AND ?
			GROUP BY $group
			ORDER BY MIN(registered_date)
		";

		return $this->db->query($sql, [$start, $end])->result();
	}
	
	public function get_registered_users_by_referrer_range($referrer, $start, $end, $mode = 'day') {
		// Determine grouping
		switch ($mode) {
			case 'week':
				$group = "YEAR(registered_date), WEEK(registered_date)";
				$selectLabel = "CONCAT(YEAR(registered_date), '-W', WEEK(registered_date)) AS group_label";
				break;
			case 'month':
				$group = "DATE_FORMAT(registered_date, '%Y-%m')";
				$selectLabel = "DATE_FORMAT(registered_date, '%Y-%m') AS group_label";
				break;
			default:
				$group = "DATE(registered_date)";
				$selectLabel = "DATE(registered_date) AS group_label";
		}

		$sql = "
			SELECT
				$selectLabel,
				COUNT(user_id) AS total_registered
			FROM ez_users
			WHERE referrer = ?
			  AND DATE(registered_date) BETWEEN ? AND ?
			GROUP BY $group
			ORDER BY MIN(registered_date)
		";

		return $this->db->query($sql, [$referrer, $start, $end])->result();
	}
	
	
	//sync_data
	public function auto_sync_user_data($user_info) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		if($user_info != null) {
			$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/dogepick/users.php';
			$userData = $user_info;
			$jsonData = json_encode($userData);
			$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
			exec($cmd);
		}
	}
	//sync_data
}
?>