<?php
class WalletModel extends CI_Model {
	
	function __construct() {
		parent::__construct();
		$this->load->database();
	}

	public function create_new_wallet($user_id, $type, $address, $note = '') {
		$user_id = $this->db->escape_str($user_id);
		$type = $this->db->escape_str($type);
		$address = $this->db->escape_str($address);
		$data = array(
			'user_id' 		=> $user_id,
			'type' 			=> $type,
			'address'		=> $address,
			'created_time'	=> time(),
			'note'			=> $note,
		);
		$this->db->insert('ez_wallets', $data);
		$insert_id = $this->db->insert_id();
		
		//sync_data
		$this->auto_sync_wallet_data($insert_id);
		//sync_data
		
		return  $insert_id;
	}
	
	public function search_wallet_by_address($address, $type = '', $user_id) {
		$user_id = $this->db->escape_str($user_id);
		$type = $this->db->escape_str($type);
		$address = $this->db->escape_str($address);
		$sql = "SELECT * FROM `ez_wallets` WHERE `address` = ? AND `type` = ? AND `user_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($address, $type, $user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return null;
	}
	
	public function get_wallet_by_wallet_id($wallet_id) {
		$wallet_id = $this->db->escape_str($wallet_id);
		$sql = "SELECT * FROM `ez_wallets` WHERE `wallet_id` = ? LIMIT 1";
		$query = $this->db->query($sql, array($wallet_id));
		if($query->num_rows() > 0) {
			return $query->result()[0];
		}
		return '';
	}
	
	public function get_deposit_address_by_user_id($user_id) {
		$user_id = $this->db->escape_str($user_id);
		$sql = "SELECT `address` FROM `ez_wallets` WHERE `user_id` = ? AND `type` = 'Deposit' ORDER BY `wallet_id` DESC LIMIT 1";
		$query = $this->db->query($sql, array($user_id));
		if($query->num_rows() > 0) {
			return $query->result()[0]->address;
		}
		return '';
	}
	
	public function update_withdrawal_label($wallet_id, $label) {
		$wallet_id = $this->db->escape_str($wallet_id);
		$this->db->set('note', $label);
		$this->db->where('wallet_id', $wallet_id);
		$res = $this->db->update('ez_wallets');
		
		//sync_data
		$this->auto_sync_wallet_data($wallet_id);
		//sync_data
		
		return $res;
		
	}
	
	public function get_all_deposit_wallets($deposit_addresses) {
		$query = $this->db->query("SELECT * FROM `ez_wallets` WHERE `address` IN (".$deposit_addresses.") AND `type` = 'Deposit'");
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return null;
	}
	
	public function get_all_withdrawal_wallets_by_user($user_id) {
		$query = $this->db->query("SELECT * FROM `ez_wallets` WHERE `user_id` = '".$user_id."' AND `type` = 'Withdrawal'");
		if($query->num_rows() > 0) {
			return $query->result();
		}
		return array();
	}
	
	public function update_amount_transferred($address, $amount) {
		$address = $this->db->escape_str($address);
		$this->db->set('amount_transferred', 'amount_transferred+'.$amount, FALSE);
		$this->db->where('address', $address);
		$this->db->update('ez_wallets');
	}
	
	//sync_data
	public function auto_sync_wallet_data($wallet_id) {
		if(!SYNC_DATA_ALLOWED) {
			return;
		}
		$wallet_info = $this->get_wallet_by_wallet_id($wallet_id);
		$apiUrl = 'http://'.SYNC_DATA_IP.'/backup/dogepick/wallets.php';
		$walletData = $wallet_info;
		$jsonData = json_encode($walletData);
		$cmd = "curl -X POST -H 'Content-Type: application/json' -d '$jsonData' '$apiUrl' > /dev/null 2>&1 &";
		exec($cmd);
	}
	//sync_data
}
?>