<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Bans</h2>
					<section style="max-width: 800px; margin: 20px auto;">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-user"></i></span>
							<input id="ban_object" name="ban_object" type="text" class="form-control" placeholder="User ID or IP or Cookie" value="<?php if($user_id != 0) echo $user_id;?>" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-clock"></i></span>
							<select name="ban_time" id="ban_time" class="form-control" style="height: 45px;">
								<option value="0">Permanently</option>
								<option value="1">1 hour</option>
								<option value="6">6 hours</option>
								<option value="24">1 day</option>
								<option value="168">7 days</option>
								<option value="720">30 days</option>
								<option value="8760">365 days</option>
							</select>
							
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-pen-alt"></i></span>
							<input id="reason" name="reason" type="text" class="form-control" placeholder="Reason" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<div class="btn btn-info" style="width: 200px; padding: 10px;" onclick="process_ban()">Ban</div>
						</div>
					</section>
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>User/IP/Email</td>
									<td>Date</td>
									<td>Reason</td>
									<td>Expired Date</td>
									<td>Action</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($bans)) {
										foreach($bans as $row) {
											echo '<tr>';
											echo '<td>';
											if($row->uid != 0) {
												echo '<a href="'.base_url().'adm/profile.php?uid='.$row->uid.'">'.$row->uid.'</a>';
											} else if($row->ip != ''){
												echo '<a style="color: #8bc34a" href="'.base_url().'adm/logs.php?s='.$row->ip.'">'.$row->ip.'</a>';
											} else if($row->user_token != ''){
												echo '<a style="color: #FF9800" href="'.base_url().'adm/logs.php?s='.$row->user_token.'">'.$row->user_token.'</a>';
											} else if($row->email != ''){
												echo '<a style="color: #9c27b0" href="'.base_url().'/adm/tickets.php?email='.$row->email.'">'.$row->email.'</a>';
											}
											echo '</td>';
											if(time() - $row->time > 86400) {
												echo '<td>'.date("Y-m-d", $row->time).'</td>';
											} else {
												echo '<td>'.date("H:i:s", $row->time).'</td>';
											}
											echo '<td>'.$row->reason.'</td>';
											
											if($row->expired_time == 0) {
												$row->expired_time  =  'Permanently';
											} else if(date('Y-m-d', $row->expired_time) == date('Y-m-d')) {
												$row->expired_time  =  date('H:i:s A', $row->expired_time);
											} else {
												$row->expired_time  =  date('Y-m-d', $row->expired_time);
											}
											echo '<td>'.$row->expired_time.'</td>';
											echo '<td><a href="javascript:void(0)" onclick="process_unban('.$row->ban_id.')">Unban</a></td>';
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="7">No users found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			function process_ban() {
				var ban_object = $('#ban_object').val();
				var ban_time = $('#ban_time').val();
				var reason = $('#reason').val();
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=ban&ban_object="+ban_object+"&ban_time="+ban_time+"&reason="+reason,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
			
			function process_unban(ban_id) {
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=unban&ban_id="+ban_id,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
		</script>
	</body>
</html>