<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Dashboard</h2>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">USERS</td><td width="50%"><?=$web_statistic->users?></td></tr>
							<tr class="history_row"><td width="50%">ONLINE</td><td width="50%"><?=$online_users?> (<?=$online_premium_users?>)</td></tr>
							<tr class="history_row"><td width="50%">REVENUE</td><td width="50%"><?=number_format(($web_statistic->deposits - $web_statistic->withdrawals) / 100000000, 0)?></td></tr>
							<?php
								$balance = file_get_contents('http://158.220.96.161/doge_api/balance.php');
							?>
							<?php
								$balance2 = file_get_contents('http://194.233.92.165/doge_api/balance.php');
							?>
							<tr class="history_row"><td width="50%">BALANCE</td><td width="50%"><?=number_format($balance, 0)?> ($<?=number_format($balance * $DOGE_price, 0)?>)<br/><?=number_format($balance2, 0)?> ($<?=number_format($balance2 * $DOGE_price, 0)?>)</td></tr>
							<tr class="history_row"><td width="50%">DOGE PRICE</td><td width="50%"><?php echo number_format($DOGE_price, 4);?> USD</td></tr>
							<tr class="history_row"><td width="50%">GAMES</td><td width="50%"><?=number_format($web_statistic->games, 0)?></td></tr>
							<tr class="history_row"><td width="50%">BACKUP</td><td width="50%"><?=file_get_contents('http://84.247.145.55/backup/check_file.php?file=dogepick')?><br/><a href="javascript: void(0)" onclick="process_backup()">Backup</a></tr>
						</tbody>
					</table>
					
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">REGISTERED USERS</div>
					<label for="registerStartDate">Start:</label>
					<input type="date" id="registerStartDate" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">
					<label for="registerEndDate">Start:</label>
					<input type="date" id="registerEndDate" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">
					<label for="registerGroupMode">Group by:</label>
					<select id="registerGroupMode" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">
						<option value="day">Day</option>
						 <!--<option value="week">Week</option>-->
						<option value="month">Month</option>
					</select>
					<button onclick="loadRegisterChart()" class="btn btn-info">View Chart</button>
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="registerChart"></canvas>
					</div>
					
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">CASH FLOW</div>
					
					<!-- Date filters for cashflow chart -->
					<label for="cashflowStartDate">Start:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowStartDate">

					<label for="cashflowEndDate">End:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" id="cashflowEndDate">

					<label for="cashflowGroupMode">Group by:</label>
					<select id="cashflowGroupMode" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF">
					  <option value="day">Day</option>
					  <!--<option value="week">Week</option>-->
					  <option value="month">Month</option>
					</select>
					
					<label for="cashflowUnit">Unit:</label>
					<select id="cashflowUnit" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF">
					  <option value="DOGE">DOGE</option>
					  <option value="USD">USD</option>
					</select>
					
					<button onclick="loadCashflowChart()" class="btn btn-info">View Chart</button>
					
					<!-- Chart container -->
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="cashflowChart"></canvas>
					</div>

					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">SURVEYS</div>
					
					<!-- Date filters -->
					<label for="surveyStartDate">Start:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF"  id="surveyStartDate">

					<label for="surveyEndDate">End:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF"  id="surveyEndDate">

					<!-- Unit selector -->
					<label for="surveyUnit">Unit:</label>
					<select id="surveyUnit" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF" >
					  <option value="DOGE">DOGE</option>
					  <option value="USD">USD</option>
					</select>
					
					<button onclick="loadSurveyChartDaily()" class="btn btn-info">View Chart</button>
					
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="surveyChart"></canvas>
					</div>


					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">GAME STATS</div>
					<!-- Date filters -->
					<label for="gameStartDate">Start:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF"  id="gameStartDate">

					<label for="gameEndDate">End:</label>
					<input type="date" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF"  id="gameEndDate">
					
					<select id="chartGroupSelector" style="border-radius: 2px; border: 1px solid #DDD; background: #EFEFEF">
						<option value="users_bet">Users Bet</option>
						<option value="games">Games Played</option>
						<option value="doge">Wagered & Profit (DOGE)</option>
					</select>
					
					<button onclick="loadGameChartDaily()" class="btn btn-info">View Chart</button>
					
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="gameChart"></canvas>
					</div>
					
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">DAILY GAME MARKET</div>
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="chart5"></canvas>
					</div>
					
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">LANGUAGE RATIO</div>
					<div style="width: 100%; max-width: 800px; margin: 0px auto">
						<canvas id="chart7"></canvas>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
		
		var chart5 = new Chart(document.getElementById('chart5').getContext('2d'), {
			type: 'pie',
			data: {
				labels: <?=$daily_game_market[0]?>,
				datasets: [{
					data: <?=$daily_game_market[1]?>,
					backgroundColor: ['#f44336', '#9c27b0', '#3f51b5', '#03a9f4', '#4caf50', '#ffc107', '#ff5722', '#795548', '#607d8b', '#cddc39', '#009688', '#e91e63'],
				}]
			}
		});
		
		var chart7 = new Chart(document.getElementById('chart7').getContext('2d'), {
			type: 'pie',
			data: {
				labels: <?=$language_ratio[0]?>,
				datasets: [{
					data: <?=$language_ratio[1]?>,
					backgroundColor: ['#f44336', '#9c27b0', '#3f51b5', '#03a9f4', '#4caf50', '#ffc107', '#ff5722', '#795548', '#607d8b', '#cddc39', '#009688', '#e91e63', '#5fb4ff', '#753968', '#47fa33', '#7319e9', '#855769', '#855769'],
				}]
			}
		});
		
		function process_backup() {
			var r = confirm("Are you sure?");
			if (r == true) {
				$.ajax({
					url: "<?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=backup_db",
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
					}
				});
			}
		}
		
		function setRegisterDefaultDates() {
			const end = new Date();
			const start = new Date();
			start.setDate(end.getDate() - 9);

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('registerStartDate').value = formatDate(start);
			document.getElementById('registerEndDate').value = formatDate(end);
		}

		function loadRegisterChart() {
			const start = document.getElementById('registerStartDate').value;
			const end = document.getElementById('registerEndDate').value;
			const groupMode = document.getElementById('registerGroupMode').value;

			if (!start || !end) {
				alert('Please select both start and end dates.');
				return;
			}

			fetch(`/adm/load.php?data=registered_users_by_range&start=${start}&end=${end}&group_mode=${groupMode}`)
				.then(res => res.json())
				.then(data => {
					const labels = data.map(row => row.group_label);
					const totals = data.map(row => parseInt(row.total_registered));

					const ctx = document.getElementById('registerChart').getContext('2d');
					if (window.registerChartInstance) window.registerChartInstance.destroy();

					window.registerChartInstance = new Chart(ctx, {
						type: 'bar',
						data: {
							labels,
							datasets: [
								{ 
									label: 'Total Registered Users', 
									data: totals, 
									backgroundColor: '#03a9f4', 
									borderColor: '#0288d1', 
									borderWidth: 1 
								}
							]
						},
						options: {
							responsive: true,
							scales: {
								y: { beginAtZero: true }
							}
						}
					});
				});
		}

		function setRegisterDefaultDatesByGroupMode(mode) {
			const end = new Date();
			const start = new Date();

			switch (mode) {
				case 'month':
					start.setMonth(end.getMonth() - 9); // 10 months
					break;
				case 'week':
					start.setDate(end.getDate() - 7 * 9); // 10 weeks
					break;
				case 'day':
				default:
					start.setDate(end.getDate() - 9); // 10 days
					break;
			}

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('registerStartDate').value = formatDate(start);
			document.getElementById('registerEndDate').value = formatDate(end);
		}

		document.getElementById('registerGroupMode').addEventListener('change', function () {
			const mode = this.value;
			setRegisterDefaultDatesByGroupMode(mode);
			loadRegisterChart();
		});

		setRegisterDefaultDates();
		loadRegisterChart();
		
		function setCashflowDefaultDates() {
			const end = new Date();
			const start = new Date();
			start.setDate(end.getDate() - 9);

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('cashflowStartDate').value = formatDate(start);
			document.getElementById('cashflowEndDate').value = formatDate(end);
		}

		function loadCashflowChart() {
			const start = document.getElementById('cashflowStartDate').value;
			const end = document.getElementById('cashflowEndDate').value;
			const groupMode = document.getElementById('cashflowGroupMode').value;
			const unit = document.getElementById('cashflowUnit').value;

			if (!start || !end) {
				alert('Please select both start and end dates.');
				return;
			}
			fetch(`/adm/load.php?data=cashflow_by_date_range&start=${start}&end=${end}&group_mode=${groupMode}&unit=${unit}`)
				.then(res => res.json())
				.then(data => {
					const labels = data.map(row => row.group_label);
					const deposits = data.map(row => parseFloat(row.deposit));
					const withdrawals = data.map(row => parseFloat(row.withdrawal));
					const profits = data.map((_, i) => deposits[i] - withdrawals[i]);

					const ctx = document.getElementById('cashflowChart').getContext('2d');
					if (window.cashflowChartInstance) window.cashflowChartInstance.destroy();

					window.cashflowChartInstance = new Chart(ctx, {
						type: 'line',
						data: {
							labels,
							datasets: [
								{ label: 'Deposit', data: deposits, backgroundColor: '#03a9f46e', borderColor: '#03a9f4', fill: false, borderWidth: 1},
								{ label: 'Withdrawal', data: withdrawals, backgroundColor: '#f443366b', borderColor: '#f44336', fill: false, borderWidth: 1},
								{ label: 'Profit', data: profits, backgroundColor: '#4caf507a', borderColor: '#4CAF50', fill: false, borderWidth: 1}
							]
						},
						options: {
							responsive: true,
							scales: {
								y: { beginAtZero: true }
							}
						}
					});
				});
			
		}
		
		function setCashflowDefaultDatesByGroupMode(mode) {
			const end = new Date();
			const start = new Date();

			switch (mode) {
				case 'month':
					start.setMonth(end.getMonth() - 9); // 10 months
					break;
				case 'week':
					start.setDate(end.getDate() - 7 * 9); // 10 weeks
					break;
				case 'day':
				default:
					start.setDate(end.getDate() - 9); // 10 days
					break;
			}

			const formatDate = date => date.toISOString().split('T')[0];

			document.getElementById('cashflowStartDate').value = formatDate(start);
			document.getElementById('cashflowEndDate').value = formatDate(end);
		}
		
		document.getElementById('cashflowGroupMode').addEventListener('change', function () {
			const mode = this.value;
			setCashflowDefaultDatesByGroupMode(mode);
			loadCashflowChart();
		});
		
		document.getElementById('cashflowUnit').addEventListener('change', function () {
			loadCashflowChart();
		});

		//window.addEventListener('DOMContentLoaded', () => {
			setCashflowDefaultDates();
			loadCashflowChart();
		//});
		
		// Set default dates: from first day of current month to today
		function setSurveyDefaultDates() {
			const end = new Date();
			const start = new Date();
			start.setDate(1); // ngày đầu tháng

			const format = d => d.toISOString().split('T')[0];

			document.getElementById('surveyStartDate').value = format(start);
			document.getElementById('surveyEndDate').value = format(end);
		}
		
		
		// Load chart data from API
		function loadSurveyChartDaily() {
			const unit = document.getElementById('surveyUnit').value;
			const start = document.getElementById('surveyStartDate').value;
			const end = document.getElementById('surveyEndDate').value;

			if (!start || !end) {
				alert('Please select a valid date range.');
				return;
			}

			fetch(`/adm/load.php?data=survey_summary_by_day&unit=${unit}&start=${start}&end=${end}`)
				.then(res => res.json())
				.then(data => {
					const labels = data.map(row => row.day);

					const datasets = [
						{
							label: 'CPX Research',
							data: data.map(r => +r.cpx_research),
							backgroundColor: '#2196f3',
							stack: 'total'
						},
						/*{
							label: 'BitLabs',
							data: data.map(r => +r.bitlabs),
							backgroundColor: '#4caf50',
							stack: 'total'
						},
						{
							label: 'TheoremReach',
							data: data.map(r => +r.theoremreach),
							backgroundColor: '#9c27b0',
							stack: 'total'
						},*/
						{
							label: 'TimeWall',
							data: data.map(r => +r.timewall),
							backgroundColor: '#f44336',
							stack: 'total'
						},
						{
							label: 'Rejected',
							data: data.map(r => +r.rejected),
							backgroundColor: '#9e9e9e',
							stack: 'total'
						}
					];

					const ctx = document.getElementById('surveyChart').getContext('2d');
					if (window.surveyChartInstance) window.surveyChartInstance.destroy();

					window.surveyChartInstance = new Chart(ctx, {
						type: 'bar',
						data: {
							labels,
							datasets
						},
						options: {
							responsive: true,
							plugins: {
								title: {
									display: true,
									text: `Survey Earnings Per Day (${unit})`
								},
								legend: {
									position: 'bottom'
								},
								tooltip: {
									mode: 'index',
									intersect: false
								}
							},
							interaction: {
								mode: 'index',
								intersect: false
							},
							scales: {
								x: {
									stacked: true
								},
								y: {
									stacked: true,
									beginAtZero: true
								}
							}
						}
					});
				}
			);
		}
		
		
		// Auto-init on page load
		//window.addEventListener('DOMContentLoaded', () => {
			setSurveyDefaultDates();
			loadSurveyChartDaily();
		//});

		// Reload chart when unit changes
		document.getElementById('surveyUnit').addEventListener('change', loadSurveyChartDaily);
		
		
		// Set default dates: from first day of current month to today
		function setGameDefaultDates() {
			const end = new Date();
			const start = new Date();
			start.setDate(1); // ngày đầu tháng

			const format = d => d.toISOString().split('T')[0];

			document.getElementById('gameStartDate').value = format(start);
			document.getElementById('gameEndDate').value = format(end);
		}
		
		// Load chart data from API
		function loadGameChartDaily() {
			const start = document.getElementById('gameStartDate').value;
			const end = document.getElementById('gameEndDate').value;
			const group = document.getElementById('chartGroupSelector').value;
			
			fetch(`/adm/load.php?data=game_stats_by_day&start=${start}&end=${end}`)
				.then(res => res.json())
				.then(data => {
					const labels = data.map(row => row.date);
					let datasets = [];
					let title = '';
					let yTickFormatter = val => val.toLocaleString();

					if (group === 'users_bet') {
						title = 'Users Bet Per Day';
						datasets = [
							{
								label: 'Users Bet',
								data: data.map(r => +r.users_bet),
								backgroundColor: '#2196f3'
							}
						];
					} else if (group === 'games') {
						title = 'Games Played Per Day';
						datasets = [
							{
								label: 'Games Played',
								data: data.map(r => +r.games),
								backgroundColor: '#4caf50'
							}
						];
					} else if (group === 'doge') {
						title = 'Wagered & Profit Per Day (DOGE)';
						yTickFormatter = val => val.toFixed(4);
						datasets = [
							{
								label: 'Wagered (DOGE)',
								data: data.map(r => +r.wagered / 100000000),
								backgroundColor: '#ff9800'
							},
							{
								label: 'Profit (DOGE)',
								data: data.map(r => +r.profit / 100000000),
								backgroundColor: '#f44336'
							}
						];
					}

					const ctx = document.getElementById('gameChart').getContext('2d');
					if (window.gameChartInstance) window.gameChartInstance.destroy();

					window.gameChartInstance = new Chart(ctx, {
						type: 'bar',
						data: {
							labels,
							datasets
						},
						options: {
							responsive: true,
							plugins: {
								title: {
									display: true,
									text: title
								},
								legend: {
									position: 'bottom'
								},
								tooltip: {
									mode: 'index',
									intersect: false,
									callbacks: {
										label: function(context) {
											const val = context.parsed.y;
											if (group === 'doge') {
												return `${context.dataset.label}: ${val.toFixed(4)} DOGE`;
											}
											return `${context.dataset.label}: ${val.toLocaleString()}`;
										}
									}
								}
							},
							interaction: {
								mode: 'index',
								intersect: false
							},
							scales: {
								x: { stacked: false },
								y: {
									beginAtZero: true,
									ticks: {
										callback: yTickFormatter
									}
								}
							}
						}
					});
				});
		}

		loadGameChartDaily();
		setGameDefaultDates();

		</script>
	</body>
</html>