<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<div style="max-width: 700px; margin: 0px auto;">
						<h2>PROVABLY FAIR</h2>
						<p style="font-style: italic">Provable fairness is a transparent way for us to guarantee as the operator that we are providing true randomness without manipulation. This roll verifier is entirely coded in javascript so you can view the source to see how the roll is calculated and we will not be able to manipulate this script in any way because the calculations are done right here in your browser and the source is open for everyone to see.</p>
					</div>
					<div class="game_main gems_game_container" style="max-width: 700px;  width: 100%; margin: 0px auto; text-align: left; padding: 20px">
						<div class="input_label">Game</div>
						<div class="input_group" style="padding: 0px; margin-top: 5px">
							<div class="icon"><i class="fas fa-gamepad"></i></div>
							<select style="width: calc(100% - 45px); height: 43px; border: none; padding-left: 10px" id="game">
								<option>Dice</option>
								<option>Gems</option>
								<option>Slots</option>
								<option>Mines</option>
								<option>Poker</option>
								<option>Baccarat</option>
								<option>Hilow</option>
								<option>Roulette</option>
								<option>Wheel</option>
								<option>Plinko</option>
								<option>Limbo</option>
							</select>
						</div>
						<div class="input_label" style="margin-top: 10px">Nonce</div>
						<div class="input_group" style="padding: 0px;">
							<div class="icon"><i class="fas fa-sort-numeric-up"></i></div>
							<input style="padding-left: 10px" type="number" id="nonce">
						</div>
						<div class="input_label" style="margin-top: 10px">Server seed</div>
						<div class="input_group" style="padding: 0px;">
							<div class="icon"><i class="fas fa-server"></i></div>
							<input style="padding-left: 10px" type="text" id="server_seed" maxlength="64">
						</div>
						<div class="input_label" style="margin-top: 10px">Server seed hash</div>
						<div class="input_group" style="padding: 0px; background: #F1F1F1">
							<div class="icon"><i class="fas fa-code"></i></div>
							<input style="padding-left: 10px" type="text" id="server_seed_hash" readonly="readonly">
						</div>
						<div class="input_label" style="margin-top: 10px">Client seed</div>
						<div class="input_group" style="padding: 0px;">
							<div class="icon"><i class="fas fa-laptop-code"></i></div>
							<input style="padding-left: 10px" type="text" id="client_seed" maxlength="16">
						</div>
						<div id="game_result">
							<div id="game_dice_result" style="margin: 50px auto; display: none">
								<div class="slider">
									<div class="min_max">0</div>
									<div class="runway">
										<div class="result_maker" style="display: block; left: calc(50% - 30px); display: none">
											<span>50.00</span>
										</div>
									</div>
									<div class="min_max">100</div>
								</div>
							</div>
							
							<div id="game_slots_result" style="display: none">
								<div class="slots__container slots__container--won">
									<div class="slots__row-container">
										<span class="slots__row slots__row--one slots__row--active"><span></span><span></span><span></span></span>
										<span class="slots__row slots__row--two slots__row--active"><span></span><span></span><span></span></span>
										<span class="slots__row slots__row--three slots__row--active"><span></span><span></span><span></span></span>
									</div>
									<div class="reel__container" id="first_reel">
										<div class="reel reel--start" style="transform: rotateX(90deg);"></div>
									</div>
									<div class="reel__container" id="second_reel">
										<div class="reel reel--start" style="transform: rotateX(-90deg);"></div>
									</div>
									<div class="reel__container" id="third_reel">
										<div class="reel reel--start" style="transform: rotateX(-70deg);"></div>
									</div>
								</div>
							</div>
							<div style="max-width: 350px; margin: 0px auto; display: none" id="game_gems_result">
								<div class="progress_table" style="padding: 20px 0px">
									<div id="easy_difficulty" style="display: block"></div>
									<div id="medium_difficulty" style="display: none"></div>
									<div id="hard_difficulty" style="display: none"></div>

								</div>
								<div class="difficulty">
									<div class="row">
										<div class="col-xs-4">
											<div class="radio icheck-success">
												<input type="radio" id="easy" name="difficulty" checked="checked">
												<label for="easy">Easy</label>
											</div>
										</div>
										<div class="col-xs-4">
											<div class="radio icheck-success">
												<input type="radio" id="medium" name="difficulty">
												<label for="medium">Medium</label>
											</div>
										</div>
										<div class="col-xs-4">
											<div class="radio icheck-success">
												<input type="radio" id="hard" name="difficulty">
												<label for="hard">Hard</label>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div style="margin: 0px auto; display: none" id="game_mines_result">
								<div class="input_label" style="margin-top: 10px">Bomb</div>
								<div class="input_group" style="padding: 0px;">
									<div class="icon"><i class="fas fa-bomb"></i></div>
									<select id="num_bombs" >
										<?php for($i = 1; $i <= 24; $i++){
											if($i == 3) {
												echo '<option value="'.$i.'" selected>'.$i.'</option>';
											} else {
												echo '<option value="'.$i.'">'.$i.'</option>';
											}
										}
										?>
									</select>
								</div>
								<div class="game_main" style="width: 100%; background: none; box-shadow: none; margin: 0px; padding: 0px">
									<div class="mine_board">
									</div>
								</div>
							</div>
							<div style="margin: 0px auto; display: none" id="game_poker_result">
								<div class="poker_game_container single_title_n" style="margin: 50px auto;">
								</div>
							</div>
							<div style="margin: 0px auto; display: none" id="game_baccarat_result">
							</div>
							<div style="margin: 0px auto; display: none" id="game_hilow_result">
								<div class="hilow_game_container single_title_n" style="margin: 10px auto; max-width: 1000px">
								</div>
							</div>
							<div style="margin: 0px auto; display: none" id="game_roulette_result">
								<div class="roulette_game_container single_title_n" style="margin: 10px auto; max-width: 1000px">
								</div>
							</div>
							<div style="margin: 0px auto; display: none" id="game_wheel_result">
								<div class="wheel_game_container single_title_n" style="margin: 10px auto; max-width: 1000px">
								</div>
							</div>
							<div style="margin: 0px auto; display: none" id="game_plinko_result">
								<div class="input_label" style="margin-top: 10px">Risk</div>
								<div class="input_group" style="padding: 0px;">
									<div class="icon"><i class="fas fa-line-height addon"></i></div>
									<select id="risk" >
										<option value="0">Low</option>
										<option value="1">Medium</option>
										<option value="2">High</option>
									</select>
								</div>
								<div class="plinko_game_container single_title_n" style="margin: 50px auto 0px; max-width: 1000px">
								</div>
							</div>
							<div style="margin: 0px auto; display: none" id="game_limbo_result">
								<div class="limbo_game_container single_title_n" style="margin: 50px auto 0px; max-width: 1000px"></div>
							</div>
						</div>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script src="<?=base_url()?>assets/js/cryptojs.js" type="text/javascript"></script>
		<script src="<?=base_url()?>assets/js/cryptojs2.js" type="text/javascript"></script>
		<script src="<?=base_url()?>assets/js/cryptojs3.js" type="text/javascript"></script>
		<script src="<?=base_url()?>assets/js/cryptojs4.js" type="text/javascript"></script>

		
		<script>
			var server_seed = '';
			var server_seed_hash = '';
			var client_seed = '';
			var nonce = '';
			var game = '';
			$(document).ready(function() {
				prepare_data();
				$("#nonce").keyup("change", change_nonce);
				$("#client_seed").keyup("change", change_client_seed);
				$("#server_seed").keyup("change", change_server_seed);
				$("#game").change("change", change_game);
				$("#num_bombs").change("change", change_num_bombs);
				$("#risk").change("change", change_game_plinko_risk);
				$("input[type=radio][name=difficulty]").on("change", change_difficulty);
			});
			
			function prepare_data() {
				server_seed = getUrlParameter('server_seed');
				client_seed = getUrlParameter('client_seed');
				nonce = getUrlParameter('nonce');
				game = getUrlParameter('game');
				
				if(typeof nonce === "undefined" || nonce == '') {
					nonce = 1;
				}
				if(typeof server_seed === "undefined" || server_seed == '') {
					server_seed = 's';
				}
				if(typeof client_seed === "undefined" || client_seed == '') {
					client_seed = 'c';
				}
				if(typeof game === "undefined" || game == '') {
					game = $('#game').val();
				} else {
					$("#game").val(game);
				}
				server_seed_hash = CryptoJS.SHA256(server_seed).toString(CryptoJS.enc.Hex);
				$('#server_seed').val(server_seed);
				$('#server_seed_hash').val(server_seed_hash);
				$('#client_seed').val(client_seed);
				$('#nonce').val(nonce);
				
				generate_game_dice_number();
				generare_game_gems_map();
				generate_game_slots_data();
				generate_game_mines_data();
				generate_game_poker_data();
				generate_game_baccarat_data();
				generate_game_hilow_data();
				generate_game_roulette_number();
				generate_game_wheel_index();
				generate_game_plinko_payout();
				generate_game_limbo_number();
				
				if(game == 'Dice') {
					$('#game_dice_result').show();
				} else if(game == 'Slots') {
					$('#game_slots_result').show();
				} else if(game == 'Gems') {
					$('#game_gems_result').show();
				} else if(game == 'Mines') {
					$('#game_mines_result').show();
				} else if(game == 'Poker') {
					$('#game_poker_result').show();
				} else if(game == 'Baccarat') {
					$('#game_baccarat_result').show();
				} else if(game == 'Hilow') {
					$('#game_hilow_result').show();
				} else if(game == 'Roulette') {
					$('#game_roulette_result').show();
				} else if(game == 'Wheel') {
					$('#game_wheel_result').show();
				} else if(game == 'Plinko') {
					$('#game_plinko_result').show();
				} else if(game == 'Limbo') {
					$('#game_limbo_result').show();
				}
				
			}
			
			function change_nonce() {
				nonce = $('#nonce').val();
				if(typeof nonce === "undefined" || nonce == '') {
					nonce = 1;
				}
				generate_game_dice_number();
				generare_game_gems_map();
				generate_game_slots_data();
				generate_game_mines_data();
				generate_game_poker_data();
				generate_game_baccarat_data();
				generate_game_hilow_data();
				generate_game_roulette_number();
				generate_game_wheel_index();
				generate_game_plinko_payout();
				generate_game_limbo_number();
			}
			
			function change_client_seed() {
				client_seed = $('#client_seed').val();
				if(typeof client_seed === "undefined" || client_seed == '') {
					nonce = 'c';
				}
				generate_game_dice_number();
				generare_game_gems_map();
				generate_game_slots_data();
				generate_game_mines_data();
				generate_game_poker_data();
				generate_game_baccarat_data();
				generate_game_hilow_data();
				generate_game_roulette_number();
				generate_game_wheel_index();
				generate_game_plinko_payout();
				generate_game_limbo_number();
			}

			function change_server_seed() {
				server_seed = $('#server_seed').val();
				if(typeof server_seed === "undefined" || server_seed == '') {
					nonce = 's';
				}
				server_seed_hash = CryptoJS.SHA256(server_seed).toString(CryptoJS.enc.Hex);
				$('#server_seed_hash').val(server_seed_hash);
				generate_game_dice_number();
				generare_game_gems_map();
				generate_game_slots_data();
				generate_game_mines_data();
				generate_game_poker_data();
				generate_game_baccarat_data();
				generate_game_hilow_data();
				generate_game_roulette_number();
				generate_game_wheel_index();
				generate_game_plinko_payout();
				generate_game_limbo_number();
			}
			
			function change_game() {
				$('#game_result > div').hide();
				game = $('#game').val();
				if(game == 'Dice') {
					$('#game_dice_result').show();
				} else if(game == 'Slots') {
					$('#game_slots_result').show();
				} else if(game == 'Gems') {
					$('#game_gems_result').show();
				} else if(game == 'Mines') {
					$('#game_mines_result').show();
				} else if(game == 'Poker') {
					$('#game_poker_result').show();
				} else if(game == 'Baccarat') {
					$('#game_baccarat_result').show();
				} else if(game == 'Hilow') {
					$('#game_hilow_result').show();
				} else if(game == 'Roulette') {
					$('#game_roulette_result').show();
				} else if(game == 'Wheel') {
					$('#game_wheel_result').show();
				} else if(game == 'Plinko') {
					$('#game_plinko_result').show();
				} else if(game == 'Limbo') {
					$('#game_limbo_result').show();
				}
			}
			
			function base64ToHex(str) {
				var raw = atob(str);
				let result = '';
				for (let i = 0; i < raw.length; i++) {
					var hex = raw.charCodeAt(i).toString(16);
					result += (hex.length === 2 ? hex : '0' + hex);
				}
				return result.toUpperCase();
			}
			
			function base64toDec(str) {
				var raw = atob(str);
				var decs = [];
				for (let i = 0; i < raw.length; i++) {
					var hex = raw.charCodeAt(i).toString(16);
					var dec = parseInt(hex, 16);
					decs.push(dec);
				}
				return decs;
			}
			
			function generate_game_dice_number() {
				var hash = CryptoJS.HmacSHA256(client_seed+':'+nonce, server_seed);
				var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
				var hashInDecs = base64toDec(hashInBase64);
				var number = 	parseInt((	parseFloat(hashInDecs[0] / 256) + 
										parseFloat(hashInDecs[1] / (256 * 256)) +
										parseFloat(hashInDecs[2] / (256 * 256 * 256)) +
										parseFloat(hashInDecs[3] / (256 * 256 * 256 * 256))) * 10000);
				number = (number/100).toFixed(2);
				$('.result_maker').show();
				$('.result_maker span').html(number);
				$('.result_maker').css('left', 'calc('+parseFloat(number)+'% - 30px)');
			}
			
			function generare_game_gems_map() {
				var num_rows = 10;
				var hashs = [];
				var easy_nums = [];
				var medium_nums = [];
				var hard_nums = [];
				var num = 0;
				for(i = 0; i < num_rows; i++) {
					var hash = CryptoJS.HmacSHA256(client_seed+':'+nonce+':'+i, server_seed);
					hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
					hashs.push(base64toDec(hashInBase64));
				}
				for(i = 0; i < num_rows; i++) {
					num = 	parseInt((	parseFloat(hashs[i][0] / 256) + 
										parseFloat(hashs[i][1] / (256 * 256)) +
										parseFloat(hashs[i][2] / (256 * 256 * 256)) +
										parseFloat(hashs[i][3] / (256 * 256 * 256 * 256))) * 3);
					easy_nums.push(num);
				}
				for(i = 0; i < num_rows; i++) {
					num = 	parseInt((	parseFloat(hashs[i][0] / 256) + 
										parseFloat(hashs[i][1] / (256 * 256)) +
										parseFloat(hashs[i][2] / (256 * 256 * 256)) +
										parseFloat(hashs[i][3] / (256 * 256 * 256 * 256))) * 2);
					medium_nums.push(num);
				}
				for(i = 0; i < num_rows; i++) {
					num = 	parseInt((	parseFloat(hashs[i][0] / 256) + 
										parseFloat(hashs[i][1] / (256 * 256)) +
										parseFloat(hashs[i][2] / (256 * 256 * 256)) +
										parseFloat(hashs[i][3] / (256 * 256 * 256 * 256))) * 3);
					hard_nums.push(num);
				}

				var process_table = '';
				for(i = easy_nums.length - 1; i >= 0; i--) {
					var process_row = '';
					process_row += '<div class="progress_row col_3 opened">';
					for(j = 0; j < 3; j++) {
						if(easy_nums[i] != j) {
							process_row += '<button class="progress_cell" type="button"><span><i class="fas fa-gem"></i></span></button>';
						} else {
							process_row += '<button class="progress_cell" type="button"><span></span></button>';
						}
					}
					process_row += '</div>';
					process_table += process_row;
				}
				$('#easy_difficulty').html(process_table);
				
				process_table = '';
				for(i = medium_nums.length - 1; i >= 0; i--) {
					var process_row = '';
					process_row += '<div class="progress_row col_2 opened">';
					for(j = 0; j < 2; j++) {
						if(medium_nums[i] == j) {
							process_row += '<button class="progress_cell" type="button"><span><i class="fas fa-gem"></i></span></button>';
						} else {
							process_row += '<button class="progress_cell" type="button"><span></span></button>';
						}
					}
					process_row += '</div>';
					process_table += process_row;
				}
				$('#medium_difficulty').html(process_table);
				
				var process_table = '';
				for(i = hard_nums.length - 1; i >= 0; i--) {
					var process_row = '';
					process_row += '<div class="progress_row col_3 opened">';
					for(j = 0; j < 3; j++) {
						if(hard_nums[i] == j) {
							process_row += '<button class="progress_cell" type="button"><span><i class="fas fa-gem"></i></span></button>';
						} else {
							process_row += '<button class="progress_cell" type="button"><span></span></button>';
						}
					}
					process_row += '</div>';
					process_table += process_row;
				}
				$('#hard_difficulty').html(process_table);
			}
			
			function change_difficulty() {
				if($('#easy').is(':checked')) {
					$('#easy_difficulty').show();
					$('#medium_difficulty').hide();
					$('#hard_difficulty').hide();
					difficulty = 'easy';
				} else if($('#medium').is(':checked')){
					$('#easy_difficulty').hide();
					$('#medium_difficulty').show();
					$('#hard_difficulty').hide();
					difficulty = 'medium';
				} else if($('#hard').is(':checked')){
					$('#easy_difficulty').hide();
					$('#medium_difficulty').hide();
					$('#hard_difficulty').show();
					difficulty = 'hard';
				}
			}
			
			function change_num_bombs() {
				game = $('#game').val();
				if(game == 'Mines') {
					generate_game_mines_data();
				}
			}
			
			function change_game_plinko_risk() {
				risk = $('#risk').val();
				if(game == 'Plinko') {
					generate_game_plinko_payout();
				}
			}
			
			function generate_game_slots_data() {
				var hash = CryptoJS.HmacSHA256(client_seed+':'+nonce, server_seed);
				var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
				var hashInDecs = base64toDec(hashInBase64);
				var num1 = 	parseInt((	parseFloat(hashInDecs[0] / 256) + 
										parseFloat(hashInDecs[1] / (256 * 256)) +
										parseFloat(hashInDecs[2] / (256 * 256 * 256)) +
										parseFloat(hashInDecs[3] / (256 * 256 * 256 * 256))) * 36);
										
				var num2 = 	parseInt((	parseFloat(hashInDecs[4] / 256) + 
										parseFloat(hashInDecs[5] / (256 * 256)) +
										parseFloat(hashInDecs[6] / (256 * 256 * 256)) +
										parseFloat(hashInDecs[7] / (256 * 256 * 256 * 256))) * 36);
				
				var num3 = 	parseInt((	parseFloat(hashInDecs[8] / 256) + 
										parseFloat(hashInDecs[9] / (256 * 256)) +
										parseFloat(hashInDecs[10] / (256 * 256 * 256)) +
										parseFloat(hashInDecs[11] / (256 * 256 * 256 * 256))) * 36);
										
				var reel1 = ['bell', 'bell', 'orange', 'watermelon', 'watermelon', 'orange', 'watermelon', 'bell', 'bell', 'bar', 'watermelon', 'bell', 'seven', 'bell', 'watermelon', 'bell', 'cherry', 'cherry', 'bell', 'bell', 'bell', 'bell', 'bell', 'watermelon', 'watermelon', 'cherry', 'seven', 'watermelon', 'cherry', 'bell', 'bell', 'watermelon', 'bell', 'cherry', 'bell', 'orange'];						
				var reel2 = ['orange', 'bell', 'watermelon', 'bell', 'bell', 'bell', 'bell', 'bell', 'cherry', 'watermelon', 'watermelon', 'bell', 'bell', 'bell', 'bell', 'bell', 'cherry', 'orange', 'cherry', 'watermelon', 'watermelon', 'bell', 'watermelon', 'watermelon', 'seven', 'orange', 'cherry', 'bar', 'bell', 'cherry', 'bell', 'cherry', 'bell', 'watermelon', 'watermelon', 'seven'];
				var reel3 = ['bell', 'bell', 'bell', 'bell', 'cherry', 'seven', 'watermelon', 'bell', 'watermelon', 'bell', 'bell', 'watermelon', 'bell', 'bell', 'watermelon', 'cherry', 'seven', 'cherry', 'cherry', 'bell', 'bell', 'watermelon', 'orange', 'bell', 'bell', 'watermelon', 'cherry', 'watermelon', 'bell', 'bar', 'watermelon', 'bell', 'orange', 'bell', 'seven', 'watermelon'];				
				if($('#first_reel .reel--start').is(':empty')) {
					var html = '';
					for(i = 0; i < reel1.length; i++) {
						html += '<div class="reel__part reel__part--'+reel1[i]+'"></div>';
						html +=	'<div class="reel__part reel__part--transparent"></div>';
					}
					$('#first_reel .reel--start').html(html);
				}
				if($('#second_reel .reel--start').is(':empty')) {
					var html = '';
					for(i = 0; i < reel2.length; i++) {
						html += '<div class="reel__part reel__part--'+reel2[i]+'"></div>';
						html +=	'<div class="reel__part reel__part--transparent"></div>';
					}
					$('#second_reel .reel--start').html(html);
				}
				if($('#third_reel .reel--start').is(':empty')) {
					var html = '';
					for(i = 0; i < reel3.length; i++) {
						html += '<div class="reel__part reel__part--'+reel3[i]+'"></div>';
						html +=	'<div class="reel__part reel__part--transparent"></div>';
					}
					$('#third_reel .reel--start').html(html);
				}
										
				setTimeout(function(){
					$('#first_reel .reel ').css('transition', 'none 0s ease 0s');
					$('#first_reel .reel').css('transform', 'rotateX('+(num1 * 10)+'deg)');
					$('#first_reel .reel ').css('transition', '');
				}, 0);
				setTimeout(function(){
					$('#second_reel .reel ').css('transition', 'none 0s ease 0s');
					$('#second_reel .reel').css('transform', 'rotateX('+(num2 * 10)+'deg)');
					$('#second_reel .reel ').css('transition', '');
				}, 100);
				setTimeout(function(){
					$('#third_reel .reel ').css('transition', 'none 0s ease 0s');
					$('#third_reel .reel').css('transform', 'rotateX('+(num3 * 10)+'deg)');
					$('#third_reel .reel ').css('transition', '');
				}, 150);						
										
										
			}
			function generate_game_mines_data() {
				var hash1 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':0', server_seed);
				var hash2 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':1', server_seed);
				var hash3 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':2', server_seed);
				var hashInDecs1 = base64toDec(CryptoJS.enc.Base64.stringify(hash1));
				var hashInDecs2 = base64toDec(CryptoJS.enc.Base64.stringify(hash2));
				var hashInDecs3 = base64toDec(CryptoJS.enc.Base64.stringify(hash3));
				var hashInDecs = [];
				var num_bombs = parseInt($('#num_bombs').val());
				
				hashInDecs = hashInDecs.concat(hashInDecs1);
				hashInDecs = hashInDecs.concat(hashInDecs2);
				hashInDecs = hashInDecs.concat(hashInDecs3);
				var arr_nums = [];
				var arr_mines = [];
				for(i = 0, j = 25; i < hashInDecs.length, j > 1; i+=4, j--) {
					var number =  parseInt((hashInDecs[i] / Math.pow(256, 1)
							+  hashInDecs[i+1] / Math.pow(256, 2)
							+  hashInDecs[i+2] / Math.pow(256, 3)
							+  hashInDecs[i+3] / Math.pow(256, 4)) * j);
					arr_nums.push(number);
				}
				for(i = 0; i < arr_nums.length; i++){
					var number = arr_nums[i];
					for(j = 0; j <= number; j++) {
						if(arr_mines.includes(j)) {
							number++;
						}
					}
					arr_mines.push(number);
				}
				arr_mines = arr_mines.slice(0, num_bombs);
				var content = '';
				for(i = 0; i < 25; i++) {
					if(arr_mines.includes(i)) {
						content += '<div class="tile" id="tile_'+i+'"><div class="back"><img src="<?=base_url()?>assets/img/games/Bomb_150.png" class="show"/></div></div>';
					} else {
						content += '<div class="tile" id="tile_'+i+'"><div class="back"><img src="<?=base_url()?>assets/img/games/Diamond_150.png" class="show"/></div></div>';
					}							
				}
				$('.mine_board').html(content);
			}
			
			function generate_game_poker_data() {
				var hash1 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':0', server_seed);
				var hash2 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':1', server_seed);
				var hash3 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':2', server_seed);
				var hash4 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':3', server_seed);
				var hash5 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':4', server_seed);
				var hash6 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':5', server_seed);
				var hash7 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':6', server_seed);
				var hashInDecs1 = base64toDec(CryptoJS.enc.Base64.stringify(hash1));
				var hashInDecs2 = base64toDec(CryptoJS.enc.Base64.stringify(hash2));
				var hashInDecs3 = base64toDec(CryptoJS.enc.Base64.stringify(hash3));
				var hashInDecs4 = base64toDec(CryptoJS.enc.Base64.stringify(hash4));
				var hashInDecs5 = base64toDec(CryptoJS.enc.Base64.stringify(hash5));
				var hashInDecs6 = base64toDec(CryptoJS.enc.Base64.stringify(hash6));
				var hashInDecs7 = base64toDec(CryptoJS.enc.Base64.stringify(hash7));
				var hashInDecs = [];
				var arr_nums = [];
				var arr_cards = [];
				hashInDecs = hashInDecs.concat(hashInDecs1);
				hashInDecs = hashInDecs.concat(hashInDecs2);
				hashInDecs = hashInDecs.concat(hashInDecs3);
				hashInDecs = hashInDecs.concat(hashInDecs4);
				hashInDecs = hashInDecs.concat(hashInDecs5);
				hashInDecs = hashInDecs.concat(hashInDecs6);
				hashInDecs = hashInDecs.concat(hashInDecs7);
				for(i = 0, j = 52; i < hashInDecs.length, j >= 1; i+=4, j--) {
					var number =  parseInt((hashInDecs[i] / Math.pow(256, 1)
							+  hashInDecs[i+1] / Math.pow(256, 2)
							+  hashInDecs[i+2] / Math.pow(256, 3)
							+  hashInDecs[i+3] / Math.pow(256, 4)) * j);
					arr_nums.push(number);
				}
				for(i = 0; i < arr_nums.length; i++){
					var number = arr_nums[i];
					for(j = 0; j <= number; j++) {
						if(arr_cards.includes(j)) {
							number++;
						}
					}
					arr_cards.push(number);
				}
				arr_cards = arr_cards.slice(0, 10);
				
				var content = '';
				content +='<span>Initial Hand</span>';
				content += '<div class="game_poker_board">';
				for(i = 0; i < 5; i++) {
					content += draw_poker_card(arr_cards[i]);
				}
				content += '</div>';
				content +='<span>Coming Cards</span>';
				content += '<div class="game_poker_board">';
				for(i = 5; i < 10; i++) {
					content += draw_poker_card(arr_cards[i]);
				}
				content += '</div>';
				$('.poker_game_container').html(content);
			}
			
			function generate_game_baccarat_data() {
				var hash = CryptoJS.HmacSHA256(client_seed+':'+nonce+':0', server_seed);
				var hashInDecs = base64toDec(CryptoJS.enc.Base64.stringify(hash));
				var card1 =  parseInt((hashInDecs[0] / Math.pow(256, 1)
							+  hashInDecs[1] / Math.pow(256, 2)
							+  hashInDecs[2] / Math.pow(256, 3)
							+  hashInDecs[3] / Math.pow(256, 4)) * 52);
				var card2 =  parseInt((hashInDecs[4] / Math.pow(256, 1)
							+  hashInDecs[5] / Math.pow(256, 2)
							+  hashInDecs[6] / Math.pow(256, 3)
							+  hashInDecs[7] / Math.pow(256, 4)) * 52);
				var card3 =  parseInt((hashInDecs[8] / Math.pow(256, 1)
							+  hashInDecs[9] / Math.pow(256, 2)
							+  hashInDecs[10] / Math.pow(256, 3)
							+  hashInDecs[11] / Math.pow(256, 4)) * 52);
				var card4 =  parseInt((hashInDecs[12] / Math.pow(256, 1)
							+  hashInDecs[13] / Math.pow(256, 2)
							+  hashInDecs[14] / Math.pow(256, 3)
							+  hashInDecs[15] / Math.pow(256, 4)) * 52);
				var card5 =  parseInt((hashInDecs[16] / Math.pow(256, 1)
							+  hashInDecs[17] / Math.pow(256, 2)
							+  hashInDecs[18] / Math.pow(256, 3)
							+  hashInDecs[19] / Math.pow(256, 4)) * 52);
				var card6 =  parseInt((hashInDecs[20] / Math.pow(256, 1)
							+  hashInDecs[21] / Math.pow(256, 2)
							+  hashInDecs[22] / Math.pow(256, 3)
							+  hashInDecs[23] / Math.pow(256, 4)) * 52);
				var arr_cards = [card1, card2, card3, card4, card5, card6];
				var result = calculate_game_baccarat_result(arr_cards);
				var content = '';
				content += '<div class="baccarat_game_container" style="margin: 0px auto">';
				content += '<div class="bc_board">';
				if(result[0] == 2) {
					content += '<div class="bc_row win" style="margin: 30px auto 10px; width: fit-content; display: flex">';
					for(i = 0; i < result[3].length; i++) {
						content += draw_baccarat_card(result[3][i]);
					}
					content += '</div>';
					content += '<div class="bc_summary win">Banker: <span>'+result[4]+'</span></div>';
					content += '<div class="bc_row" style="margin: 30px auto 10px; width: fit-content; display: flex">';
					for(i = 0; i < result[1].length; i++) {
						content += draw_baccarat_card(result[1][i]);
					}
					content += '</div>';
					content += '<div class="bc_summary">Player: <span>'+result[2]+'</span></div>';
				} else if (result[0] == 1) {
					content += '<div class="bc_row" style="margin: 30px auto 10px; width: fit-content; display: flex">';
					for(i = 0; i < result[1].length; i++) {
						content += draw_baccarat_card(result[3][i]);
					}
					content += '</div>';
					content += '<div class="bc_summary">Banker: <span>'+result[4]+'</span></div>';

					content += '<div class="bc_row win" style="margin: 30px auto 10px; width: fit-content; display: flex">';
					for(i = 0; i < result[1].length; i++) {
						content += draw_baccarat_card(result[1][i]);
					}
					content += '</div>';
					content += '<div class="bc_summary win">Player: <span>'+result[2]+'</span></div>';
				} else {
					content += '<div class="bc_row tie" style="margin: 30px auto 10px; width: fit-content; display: flex">';
					for(i = 0; i < result[1].length; i++) {
						content += draw_baccarat_card(result[3][i]);
					}
					content += '</div>';
					content += '<div class="bc_summary tie">Banker: <span>'+result[4]+'</span></div>';

					content += '<div class="bc_row tie" style="margin: 30px auto 10px; width: fit-content; display: flex">';
					for(i = 0; i < result[1].length; i++) {
						content += draw_baccarat_card(result[1][i]);
					}
					content += '</div>';
					content += '<div class="bc_summary tie">Player: <span>'+result[2]+'</span></div>';
				}
				content += '</div>';
				content += '</div>';
				$('#game_baccarat_result').html(content);

			}
			
			function generate_game_hilow_data() {
				var hash1 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':0', server_seed);
				var hash2 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':1', server_seed);
				var hash3 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':2', server_seed);
				var hash4 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':3', server_seed);
				var hash5 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':4', server_seed);
				var hash6 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':5', server_seed);
				var hash7 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':6', server_seed);
				var hashInDecs1 = base64toDec(CryptoJS.enc.Base64.stringify(hash1));
				var hashInDecs2 = base64toDec(CryptoJS.enc.Base64.stringify(hash2));
				var hashInDecs3 = base64toDec(CryptoJS.enc.Base64.stringify(hash3));
				var hashInDecs4 = base64toDec(CryptoJS.enc.Base64.stringify(hash4));
				var hashInDecs5 = base64toDec(CryptoJS.enc.Base64.stringify(hash5));
				var hashInDecs6 = base64toDec(CryptoJS.enc.Base64.stringify(hash6));
				var hashInDecs7 = base64toDec(CryptoJS.enc.Base64.stringify(hash7));
				var hashInDecs = [];
				var arr_nums = [];
				var arr_cards = [];
				hashInDecs = hashInDecs.concat(hashInDecs1);
				hashInDecs = hashInDecs.concat(hashInDecs2);
				hashInDecs = hashInDecs.concat(hashInDecs3);
				hashInDecs = hashInDecs.concat(hashInDecs4);
				hashInDecs = hashInDecs.concat(hashInDecs5);
				hashInDecs = hashInDecs.concat(hashInDecs6);
				hashInDecs = hashInDecs.concat(hashInDecs7);
				for(i = 0; i < hashInDecs.length; i+=4) {
					var number =  parseInt((hashInDecs[i] / Math.pow(256, 1)
							+  hashInDecs[i+1] / Math.pow(256, 2)
							+  hashInDecs[i+2] / Math.pow(256, 3)
							+  hashInDecs[i+3] / Math.pow(256, 4)) * 52);
					arr_cards.push(number);
				}
				arr_cards = arr_cards.slice(0, 52);
				
				var content = '';
				content += '<div class="game_hilow_board">';
				content += '<div class="hilow_card_list" style="height: 175px">';
				content += '<div class="hilow_slider">';
				for(i = 0; i < arr_cards.length; i++) {
					content += draw_poker_card(arr_cards[i]);
					content += '<div style="margin-left: 10px"></div>';
				}
				content += '</div>';
				content += '</div>';
				content += '</div>';
				content += '</div>';
				$('.hilow_game_container').html(content);
			}
			
			function calculate_game_baccarat_point(card_value) {
				number = 0;
				if(Math.floor(card_value / 4) < 8) {
					number = Math.floor(card_value / 4) + 2;
				} else if (Math.floor(card_value / 4) < 12) {
					number = 0;
				} else {
					number = 1;
				}
				return number;
			}
			
			function calculate_game_baccarat_result(cards) {
				var player_cards = [cards[0], cards[1]];
				var banker_cards = [cards[2], cards[3]];
				var player_total = (calculate_game_baccarat_point(player_cards[0]) + calculate_game_baccarat_point(player_cards[1])) % 10;
				var banker_total = (calculate_game_baccarat_point(banker_cards[0]) + calculate_game_baccarat_point(banker_cards[1])) % 10;
				if(player_total < 6 && banker_total < 8) {
					player_cards.push(cards[4]);
					player_total = (player_total + calculate_game_baccarat_point(player_cards[2])) % 10;
				}
				if(player_cards.length == 2) {
					if(banker_total < 3 && player_total < 8) {
						banker_cards.push(cards[5]);
						banker_total = (banker_total + calculate_game_baccarat_point(banker_cards[2])) % 10;
					}
				} else {
					player_3rd_card = calculate_game_baccarat_point(player_cards[2]);
					if(banker_total < 3) {
						banker_cards.push(cards[5]);
						banker_total = (banker_total + calculate_game_baccarat_point(banker_cards[2])) % 10;
					} else if(banker_total == 3 && player_3rd_card != 8) {
						banker_cards.push(cards[5]);
						banker_total = (banker_total + calculate_game_baccarat_point(banker_cards[2])) % 10;
					} else if(banker_total == 4 && (player_3rd_card != 0 && player_3rd_card != 1 && player_3rd_card != 8 && player_3rd_card != 9)) {
						banker_cards.push(cards[5]);
						banker_total = (banker_total + calculate_game_baccarat_point(banker_cards[2])) % 10;
					} else if(banker_total == 5 && (player_3rd_card == 4 || player_3rd_card == 5 || player_3rd_card == 6 || player_3rd_card == 7)) {
						banker_cards.push(cards[5]);
						banker_total = (banker_total + calculate_game_baccarat_point(banker_cards[2])) % 10;
					} else if(banker_total == 6 && (player_3rd_card == 6 || player_3rd_card == 7)) {
						banker_cards.push(cards[5]);
						banker_total = (banker_total + calculate_game_baccarat_point(banker_cards[2])) % 10;
					}
				}
				if(player_total > banker_total) {
					return [1, player_cards, player_total, banker_cards, banker_total];
				} else if (player_total < banker_total) {
					return [2, player_cards, player_total, banker_cards, banker_total];
				} else {
					return [3, player_cards, player_total, banker_cards, banker_total];
				}
			}
			
			function generate_game_roulette_number() {
				var hash = CryptoJS.HmacSHA256(client_seed+':'+nonce, server_seed);
				var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
				var hashInDecs = base64toDec(hashInBase64);
				var number = 	parseInt((	parseFloat(hashInDecs[0] / 256) + 
										parseFloat(hashInDecs[1] / (256 * 256)) +
										parseFloat(hashInDecs[2] / (256 * 256 * 256)) +
										parseFloat(hashInDecs[3] / (256 * 256 * 256 * 256))) * 37);
				number = parseInt(number);
				var roulette_wheel = [0, 26, 3, 35, 12, 28, 7, 29, 18, 22, 9, 31, 14, 20, 1, 33, 16, 24, 5, 10, 23, 8, 30, 11, 36, 13, 27, 6, 34, 17, 25, 2, 21, 4, 19, 15, 32];
				var index = roulette_wheel.indexOf(number);
				var deg = index * 9.72972973;
				var content = '<div class="roulette-wrap"><div class="roulette-wheel" style="transform: rotate('+deg+'deg) translateZ(0.0001px); transition: -webkit-transform 2000ms cubic-bezier(0.17, 0.67, 0.12, 0.99) 0s;"></div><span class="frame"></span><span class="ball"></span></div>';
				$('.roulette_game_container').html(content);
			}
			
			function generate_game_wheel_index() {
				var hash = CryptoJS.HmacSHA256(client_seed+':'+nonce, server_seed);
				var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
				var hashInDecs = base64toDec(hashInBase64);
				var index = 	parseInt((	parseFloat(hashInDecs[0] / 256) + 
										parseFloat(hashInDecs[1] / (256 * 256)) +
										parseFloat(hashInDecs[2] / (256 * 256 * 256)) +
										parseFloat(hashInDecs[3] / (256 * 256 * 256 * 256))) * 12);
				index = parseInt(index);
				var deg = index * 30;
				var content = '<div id="wheel-main"><div class="wheel-container"><div class="wheel2" style="transform: rotate('+deg+'deg); transition: -webkit-transform 0ms ease 0s;"></div><div class="wheel-shadow"></div><div class="wheel-mask"></div><div class="wheel-pointer"></div><div class="wheel-center"></div></div></div>';
				$('.wheel_game_container').html(content);
			}
			
			function generate_game_plinko_payout() {
				var hash1 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':0', server_seed);
				var hash2 = CryptoJS.HmacSHA256(client_seed+':'+nonce+':1', server_seed);
				var hashInDecs1 = base64toDec(CryptoJS.enc.Base64.stringify(hash1));
				var hashInDecs2 = base64toDec(CryptoJS.enc.Base64.stringify(hash2));
				var row1 =  parseInt((hashInDecs1[0] / Math.pow(256, 1)
							+  hashInDecs1[1] / Math.pow(256, 2)
							+  hashInDecs1[2] / Math.pow(256, 3)
							+  hashInDecs1[3] / Math.pow(256, 4)) * 2);
				var row2 =  parseInt((hashInDecs1[4] / Math.pow(256, 1)
							+  hashInDecs1[5] / Math.pow(256, 2)
							+  hashInDecs1[6] / Math.pow(256, 3)
							+  hashInDecs1[7] / Math.pow(256, 4)) * 2);
				var row3 =  parseInt((hashInDecs1[8] / Math.pow(256, 1)
							+  hashInDecs1[9] / Math.pow(256, 2)
							+  hashInDecs1[10] / Math.pow(256, 3)
							+  hashInDecs1[11] / Math.pow(256, 4)) * 2);
				var row4 =  parseInt((hashInDecs1[12] / Math.pow(256, 1)
							+  hashInDecs1[13] / Math.pow(256, 2)
							+  hashInDecs1[14] / Math.pow(256, 3)
							+  hashInDecs1[15] / Math.pow(256, 4)) * 2);
				var row5 =  parseInt((hashInDecs1[16] / Math.pow(256, 1)
							+  hashInDecs1[17] / Math.pow(256, 2)
							+  hashInDecs1[18] / Math.pow(256, 3)
							+  hashInDecs1[19] / Math.pow(256, 4)) * 2);
				var row6 =  parseInt((hashInDecs1[20] / Math.pow(256, 1)
							+  hashInDecs1[21] / Math.pow(256, 2)
							+  hashInDecs1[22] / Math.pow(256, 3)
							+  hashInDecs1[23] / Math.pow(256, 4)) * 2);
				var row7 =  parseInt((hashInDecs1[24] / Math.pow(256, 1)
							+  hashInDecs1[25] / Math.pow(256, 2)
							+  hashInDecs1[26] / Math.pow(256, 3)
							+  hashInDecs1[27] / Math.pow(256, 4)) * 2);
				var row8 =  parseInt((hashInDecs1[28] / Math.pow(256, 1)
							+  hashInDecs1[29] / Math.pow(256, 2)
							+  hashInDecs1[30] / Math.pow(256, 3)
							+  hashInDecs1[31] / Math.pow(256, 4)) * 2);
				var row9 =  parseInt((hashInDecs2[0] / Math.pow(256, 1)
							+  hashInDecs2[1] / Math.pow(256, 2)
							+  hashInDecs2[2] / Math.pow(256, 3)
							+  hashInDecs2[3] / Math.pow(256, 4)) * 2);
				var row10 =  parseInt((hashInDecs2[4] / Math.pow(256, 1)
							+  hashInDecs2[5] / Math.pow(256, 2)
							+  hashInDecs2[6] / Math.pow(256, 3)
							+  hashInDecs2[7] / Math.pow(256, 4)) * 2);	
				var direction_idx = row1*(2**9)+row2*(2**8)+row3*(2**7)+row4*(2**6)+row5*(2**5)+row6*(2**4)+row7*(2**3)+row8*(2**2)+row9*2+row10;
				console.log(direction_idx);
				var bin = direction_idx.toString(2);
				var slot_idx = 0;
				for(let i = 0; i < bin.length; i++) {
					slot_idx += parseInt(bin[i]);
				}
				const risk_payouts = [
					[9, 2.4, 1.3, 1.1, 1, 0.5, 1, 1.1, 1.3, 2.4, 9],
					[36, 5, 2, 1.2, 0.6, 0.4, 0.6, 1.2, 2, 5, 36],
					[75, 10, 3, 0.7, 0.4, 0.15, 0.4, 0.7, 3, 10, 75]
				];
				var risk = parseInt($('#risk').val());
				var payout = risk_payouts[risk][slot_idx].toFixed(2);
				var content = '<div style="background: #ff003f;box-shadow: 0 0.2em 0 0 #a60004; text-align: center; border-radius: 5px; color: #FFF; width: 70px; padding: 10px; margin-left: calc(50% - 35px)">'+payout+'×</div>';
				$('.plinko_game_container').html(content);
			}
			
			function generate_game_limbo_number() {
				const MAGIC_NUMBER = 16777216;
				var hash = CryptoJS.HmacSHA256(client_seed+':'+nonce, server_seed);
				var hashInBase64 = CryptoJS.enc.Base64.stringify(hash);
				var hashInDecs = base64toDec(hashInBase64);
				var number = parseInt((parseFloat(hashInDecs[0] / 256) + 
										parseFloat(hashInDecs[1] / (256 * 256)) +
										parseFloat(hashInDecs[2] / (256 * 256 * 256)) +
										parseFloat(hashInDecs[3] / (256 * 256 * 256 * 256))) * MAGIC_NUMBER);
				number = parseFloat(MAGIC_NUMBER / (number + 1) * 0.97).toFixed(2);
				var content = '<div style="background: #03A9F4;box-shadow: 0 0.2em 0 0 #2196F3; text-align: center; border-radius: 5px; color: #FFF; width: 120px; padding: 10px; margin-left: calc(50% - 35px)">'+number+'×</div>';
				$('.limbo_game_container').html(content);
			}
		</script>
	</body>
</html>