<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<link href="<?=base_url()?>assets/css/games2.css" rel="stylesheet">
	<link href="<?=base_url()?>assets/css/poker.css" rel="stylesheet">
	<link href="<?=base_url()?>assets/css/baccarat.css" rel="stylesheet">
	<link href="<?=base_url()?>assets/css/hilow.css" rel="stylesheet">
	<link href="<?=base_url()?>assets/css/roulette.css" rel="stylesheet">
	<link href="<?=base_url()?>assets/css/wheel.css" rel="stylesheet">
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Games</h2>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL WAGERD</td><td width="50%"><?=number_format($statistics->total_amount / 100000000, 8, '.', '')?></td></tr>
							<tr class="history_row"><td>TOTAL GAMES</td><td><?=$statistics->total_games?></td></tr>
							<tr class="history_row"><td>BET BALANCE</td><td><?=number_format($statistics->bet_balance / 100000000, 8, '.', '')?></td></tr>
							<tr class="history_row"><td>ACTIONS</td><td><a href="javascript:void(0)" onclick="adm_clean_bet_data()"><i class="fas fa-broom"></i> Clean bet data</a></td></tr>
						</tbody>
					</table>
					
					<section style="max-width: 800px; margin: 20px auto;">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-user"></i></span>
							<input id="user_id" name="user_id" type="text" class="form-control" placeholder="User ID" value="<?php if($user_id != 0) echo $user_id;?>" style="height: 45px;">
						</div>
						<div class="input-group" id="show_bitcoin_amount" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 12px"><i class="fas fa-money-bill-alt"></i></span>
							<input id="amount" name="amount" type="text" class="form-control" placeholder="Bet amount" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<div class="btn btn-info" style="width: 200px; padding: 10px;" onclick="process_place_bet()">Place bet</div>
						</div>
					</section>
					
					
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>Time</td>
									<td>Game</td>
									<td>User</td>
									<td>Bet amount</td>
									<td>Payout</td>
									<td>Profit</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($games)) {
										foreach($games as $row) {
											echo '<tr>';
											if(date('Y-m-d', $row->date) == date('Y-m-d')) {
												$row->date =  date('H:i:s A', $row->date);
											} else {
												$row->date =  date('Y-m-d', $row->date);
											}
											$row->game = '<a style="color: #38cb74" href="javascript:void(0)" onclick="show_bet_info('.$row->game_id.')">'.$row->game.'</a>';
											
											$row->bet_amount = number_format($row->bet_amount / 100000000, 8, '.', '');
											$row->payout = '<span style="color: #03a9f4">'.number_format($row->payout, 2, '.', '').'×</span>';
											if($row->profit > 0) {
												$row->profit = '<span style="color: #38cb74">'.number_format($row->profit / 100000000, 8, '.', '').'</span>';
											} else if ($row->profit < 0) {
												$row->profit = '<span style="color: #ff5722">'.number_format($row->profit / 100000000, 8, '.', '').'</span>';
											} else {
												$row->profit = '<span>'.number_format($row->profit / 100000000, 8, '.', '').'</span>';
											}
											echo '<td>'.$row->date.'</td>';
											echo '<td>'.$row->game.'</td>';
											echo '<td><a href="'.base_url().'adm/profile.php?uid='.$row->user_id.'">'.$row->user_name.'</a></td>';
											echo '<td>'.$row->bet_amount.'</td>';
											echo '<td>'.$row->payout.'</td>';
											echo '<td>'.$row->profit.'</td>';
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="6">No games found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			function process_create_gift() {
				var user_id = $('#user_id').val();
				var amount = $('#amount').val();
				var note = $('#note').val();
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=create_gift&user_id="+user_id+"&amount="+amount+"&note="+note,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
			
			function adm_clean_bet_data() {
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=clean_bet_data",
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
							}
						},
						timeout: 10000
					})
				}, 10);
			}
			
			function process_place_bet() {
				var user_id = $('#user_id').val();
				var amount = $('#amount').val();
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=place_bet&user_id="+user_id+"&amount="+amount,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
			
			
		</script>
	</body>
</html>