<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Gifts</h2>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL AMOUNT</td><td width="50%"><?=number_format($statistics->total_amount / 100000000, 8, '.', '')?></td></tr>
							<tr class="history_row"><td>TOTAL GIFTS</td><td><?=$statistics->total_gifts?></td></tr>
							<tr class="history_row"><td>MAX AMOUNT</td><td><?=number_format($statistics->max_amount / 100000000, 8, '.', '')?></td></tr>
						</tbody>
					</table>
					<div style="margin-top: 30px; font-weight: bold; font-size: 15px">CREATE A GIFT</div>
					<section style="max-width: 800px; margin: 20px auto;">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-user"></i></span>
							<input id="user_id" name="user_id" type="text" class="form-control" placeholder="User ID" value="<?php if($user_id != 0) echo $user_id;?>" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-money-bill-alt"></i></span>
							<input id="amount" name="amount" type="text" class="form-control" placeholder="Amount (LTC)" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-pen-alt"></i></span>
							<input id="note" name="note" type="text" class="form-control" placeholder="Note" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<div class="btn btn-info" style="width: 200px; padding: 10px;" onclick="process_create_gift()">Create Gift</div>
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<div class="btn btn-danger" style="width: 200px; padding: 10px;" onclick="process_create_xmas_gift()">Create Xmas Gift</div>
						</div>
					</section>
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>Gift Code</td>
									<td>Value</td>
									<td>User</td>
									<td>Created Date</td>
									<td>Active Date</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($gifts)) {
										foreach($gifts as $row) {
											echo '<tr>';
											if(date('Y-m-d', $row->created_time) == date('Y-m-d')) {
												$row->created_time  =  date('H:i:s A', $row->created_time);
											} else {
												$row->created_time  =  date('Y-m-d', $row->created_time);
											}
											if($row->active_time == 0) {
												$row->active_time = '__:__:__';
											} else if(date('Y-m-d', $row->active_time) == date('Y-m-d')) {
												$row->active_time   =  date('H:i:s', $row->active_time);
											} else {
												$row->active_time   =  date('Y-m-d', $row->active_time);
											}
											if($row->uid != 0) {
												$row->uid = '<a href="'.base_url().'adm/profile.php?uid='.$row->uid.'">'.$row->user_name.'</a>';
											}
											echo '<td>'.$row->gift_code.'</td>';
											echo '<td>'.number_format($row->amount / 100000000, 8, '.', '').'</td>';
											echo '<td>'.$row->uid.'</td>';
											echo '<td>'.$row->created_time.'</td>';
											echo '<td>'.$row->active_time.'</td>';
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="5">No gifts found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			function process_create_gift() {
				var user_id = $('#user_id').val();
				var amount = $('#amount').val();
				var note = $('#note').val();
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=create_gift&user_id="+user_id+"&amount="+amount+"&note="+note,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
			
			function process_create_xmas_gift() {
				var user_id = $('#user_id').val();
				var amount = $('#amount').val();
				var note = $('#note').val();
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=create_xmas_gift&user_id="+user_id+"&amount="+amount+"&note="+note,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
		</script>
	</body>
</html>