<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Notifications</h2>
					<section style="max-width: 800px; margin: 20px auto;">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-user"></i></span>
							<input id="user_id" name="user_id" type="text" class="form-control" placeholder="User ID" value="<?php if($user_id != 0) echo $user_id;?>" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px"><i class="fas fa-bell"></i></span>
							<select name="notification_type" id="notification_type" class="form-control" style="height: 45px;">
								<option value="info">Info</option>
								<option value="success">Success</option>
								<option value="warning">Warning</option>
								<option value="danger">Danger</option>
							</select>
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-pen-alt"></i></span>
							<textarea id="content" name="content" type="text" class="form-control" style="height: 200px; resize: none;"></textarea>
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<div class="btn btn-info" style="width: 200px; padding: 10px;" id="notify" onclick="notify()">Send notification</div>
						</div>
					</section>
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>UserID</td>
									<td>Type</td>
									<td>Content</td>
									<td>Dismiss</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($notifications)) {
										foreach($notifications as $row) {
											echo '<tr>';
											echo '<td><a href="'.base_url().'adm/profile.php?uid='.$row->user_id.'">'.$row->user_id.'</a></td>';
											if($row->type == 'info') {
												echo '<td style="color: #2196f3">Info</td>';
											} else if($row->type == 'success') {
												echo '<td style="color: green">Success</td>';
											}  else if($row->type == 'warning') {
												echo '<td style="color: orange">Warning</td>';
											}  else if($row->type == 'danger') {
												echo '<td style="color: red">Danger</td>';
											} 
											echo '<td>'.$row->content.'</td>';
											echo '<td>'.$row->dismiss.'</td>';
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="4">No notifications found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			function notify() {
				var user_id = $('#user_id').val();
				var type = $('#notification_type').val();
				var content = $('#content').val();
				$("#notify").attr("disabled", !0);
				$("#notify").text("Please wait");
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=notify&user_id="+user_id+"&type="+type+"&content="+content,
					error: function(){
						$.toast({
							heading: 'Error!',
							text: "Request timed out. Please try again!",
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
						$("#notify").text("Send notification");
						$("#notify").attr("disabled", false);
					}
				});
			}
		</script>
	</body>
</html>