<script src="<?=base_url()?>assets/js/jquery.js"></script>
<script src="<?=base_url()?>assets/js/flipclock.min.js"></script>
<script src="<?=base_url()?>assets/js/bootstrap.js"></script>
<script src="<?=base_url()?>assets/js/jquery.toast.js" type="text/javascript"></script>
<script src="<?=base_url()?>assets/js/qrcode.min.js" type="text/javascript"></script>
<script src="<?=base_url()?>assets/js/Chart.min.js" type="text/javascript"></script>
<script>
	function getToken() {
		var ck = document.cookie.match(/csrf_cookie_name=([a-z0-9]+)/);
		if (ck.length === 2) return ck[1];
		return null;
	}
	$.ajaxSetup({
		beforeSend: function(xhr, settings) {
			if (settings.data.indexOf('csrf_test_name') === -1) {
				settings.data += '&csrf_test_name=' + getToken();
			}
		}
	});
</script>

<script>
	function show_modal(header, content) {
		if($("#modal-mask").length == 0) {
			var html = '';
			html +='<div id="modal-mask" class="visible">';
			html +='<div id="modal-window">';
			html +='<span class="close-modal" onclick="hide_modal()"><i class="fas fa-times-circle"></i></span>';
			html +='<div class="modalbox">';
			html +='<header>'+header+'</header>';
			html +='<div class="center-content">';
			if(content == '') {
				html +='<center><img src="<?=base_url()?>assets/img/loading2.gif" style="width: 40px; margin: 0px auto"></center>';
			} else {
				html += content;
			}
			html +='</div>';
			html +='</div>';
			html +='</div>';
			html +='</div>';
			$('body').append(html);
		} else {
			$('#modal-mask').addClass('visible');
			$('#modal-mask header').html(header);
			if(content == '') {
				$('#modal-mask .center-content').html('<center><img src="<?=base_url()?>assets/img/loading2.gif" style="width: 40px; margin: 0px auto"></center>');
			} else {
				$('#modal-mask .center-content').html(content);
			}	
		}
	}
	
	function hide_modal() {
		$('#modal-mask').removeClass('visible');
	}
	
	function show_bet_info(game_id) {
		show_modal('<i class="fas fa-clipboard-list"></i> Bet Info', '');
		setTimeout(function(){
			$.ajax({
				url: "<?=base_url()?>load.php",
				type: "POST",
				data: "data=bet_info&game_id="+game_id,
				error: function(){
					console.log("Request timed out. Please try again!");
				},
				success: function(out){
					let obj = JSON.parse(out);
					if(obj.ret == 0) {
						$.toast({
							heading: 'Error!',
							text: obj.mes,
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
					} else {
						var content = '';
						var bet_info = obj.bet_info;
						content += '<div class="bet_info">';
						content += '<div class="game_title"><b>'+bet_info.title+'</b></div>';
						content += '<div class="user">Placed by '+bet_info.user_name+'</div>';
						content += '<div class="time">'+bet_info.time+'</div>';
						content += '<div class="box">';
						content += '<div><div class="title">Bet</div><span>'+bet_info.bet_amount+'</span></div>';
						content += '<div><div class="title">Multiplier</div><span style="color: #03a9f4">'+bet_info.payout+'x</span></div>';
						if(bet_info.profit > 0) {
							content += '<div><div class="title">Profit</div><span style="color: #38cb74">'+bet_info.profit+'</span></div>';
						} else {
							content += '<div><div class="title">Profit</div><span style="color: #ff5722">'+bet_info.profit+'</span></div>';
						}
						content += '</div>';
						if(bet_info.game_name == 'Dice') {
							const MAGIC_NUMBER = 9700;
							var payout = bet_info.multiplier;
							var lt = (Math.round(MAGIC_NUMBER / payout) / 100).toFixed(2);
							var gt = (100 - lt).toFixed(2);
							
							content += '<div class="game_main" style="background: none; box-shadow: none; padding: 0px; margin: 20px 0px">';
							content += '<div class="slider">';
							content += '	<div class="min_max">0</div>';
							content += '	<div class="runway">';
							
							if(bet_info.bet_on == 'higher') {
								content += '	<div class="slider_bar" style="width: '+gt+'%; border-radius: 5px 0px 0px 5px; float: left"></div>';
								if(bet_info.profit > 0) {
									content += '<div class="result_maker" style="display: block; left: calc('+bet_info.number+'% - 30px)">';
								} else {
									content += '<div class="result_maker negative" style="display: block; left: calc('+bet_info.number+'% - 30px)">';
								}
								content += '		<span>'+bet_info.number+'</span>';
								content += '	</div>';
								content += '<div class="slider_button" style="left: calc('+gt+'% - 17px)"></div>';
							} else {
								content += '	<div class="slider_bar" style="width: '+gt+'%; border-radius: 0px 5px 5px 0px; float: right"></div>';
								if(bet_info.profit > 0) {
									content += '<div class="result_maker" style="display: block; left: calc('+bet_info.number+'% - 30px)">';
								} else {
									content += '<div class="result_maker negative" style="display: block; left: calc('+bet_info.number+'% - 30px)">';
								}
								content += '			<span>'+bet_info.number+'</span>';
								content += '		</div>';
								content += '	<div class="slider_button" style="left: calc('+lt+'% - 17px)"></div>';
							}
							content += '	</div>';
							content += '	<div class="min_max">100</div>';
							content += '</div>';
							content += '</div>';
						} else if (bet_info.game_name == 'Gems') {
							content += '<div class="gems_game_container game_main" style="background: none; box-shadow: none; padding: 0px; margin: 20px auto">';
							content += '<div class="progress_table">';
							if(bet_info.difficulty == 'easy') {
								content += '<div id="easy_difficulty">';
								for(i = bet_info.gems.length - 1; i >= 0; i--) {
									if(bet_info.tiles[i] != -1) {
										content += '<div class="progress_row col_3 opened">';
									} else {
										content += '<div class="progress_row col_3">';
									}
									for(j = 0; j < 3; j++) {
										if(bet_info.gems[i][j] == 1) {
											if(bet_info.tiles[i] == j) {
												content += '<button class="progress_cell chosen" type="button"><span><i class="fas fa-gem"></i></span></button>';
											} else {
												content += '<button class="progress_cell" type="button"><span><i class="fas fa-gem"></i></span></button>';
											}		
										} else {
											if(bet_info.tiles[i] == j) {
												content += '<button class="progress_cell chosen" type="button"><span></span></button>';
											} else {
												content += '<button class="progress_cell" type="button"><span></span></button>';
											}
										}
									}
									content += '</div>';
								}
								content += '</div>';
							} else if (bet_info.difficulty == 'medium') {
								content += '<div id="medium_difficulty">';
								for(i = bet_info.gems.length - 1; i >= 0; i--) {
									if(bet_info.tiles[i] != -1) {
										content += '<div class="progress_row col_2 opened">';
									} else {
										content += '<div class="progress_row col_2">';
									}
									for(j = 0; j < 2; j++) {
										if(bet_info.gems[i][j] == 1) {
											if(bet_info.tiles[i] == j) {
												content += '<button class="progress_cell chosen" type="button"><span><i class="fas fa-gem"></i></span></button>';
											} else {
												content += '<button class="progress_cell" type="button"><span><i class="fas fa-gem"></i></span></button>';
											}		
										} else {
											if(bet_info.tiles[i] == j) {
												content += '<button class="progress_cell chosen" type="button"><span></span></button>';
											} else {
												content += '<button class="progress_cell" type="button"><span></span></button>';
											}
										}
									}
									content += '</div>';
								}
								content += '</div>';
							} else if (bet_info.difficulty == 'hard') {
								content += '<div id="hard_difficulty">';
								for(i = bet_info.gems.length - 1; i >= 0; i--) {
									if(bet_info.tiles[i] != -1) {
										content += '<div class="progress_row col_3 opened">';
									} else {
										content += '<div class="progress_row col_3">';
									}
									for(j = 0; j < 3; j++) {
										if(bet_info.gems[i][j] == 1) {
											if(bet_info.tiles[i] == j) {
												content += '<button class="progress_cell chosen" type="button"><span><i class="fas fa-gem"></i></span></button>';
											} else {
												content += '<button class="progress_cell" type="button"><span><i class="fas fa-gem"></i></span></button>';
											}		
										} else {
											if(bet_info.tiles[i] == j) {
												content += '<button class="progress_cell chosen" type="button"><span></span></button>';
											} else {
												content += '<button class="progress_cell" type="button"><span></span></button>';
											}
										}
									}
									content += '</div>';
								}
								content += '</div>';
							}
							content += '</div>';
							content += '</div>';
							
						} else if(bet_info.game_name == 'Slots') {
							content += '<div class="game_main" style="max-width: 550px; width: 100%; background: none; box-shadow: none; margin: 0px; padding: 0px">';
							content += '<div class="slots__container slots__container--won">';
							content += '<div class="slots__row-container">';
							if(bet_info.lines == 1) {
								content += '<span class="slots__row slots__row--one slots__row--active"><span></span><span></span><span></span></span>';
								content += '<span class="slots__row slots__row--two"><span></span><span></span><span></span></span>';
								content += '<span class="slots__row slots__row--three"><span></span><span></span><span></span></span>';
							} else if(bet_info.lines == 2) {
								content += '<span class="slots__row slots__row--one slots__row--active"><span></span><span></span><span></span></span>';
								content += '<span class="slots__row slots__row--two slots__row--active"><span></span><span></span><span></span></span>';
								content += '<span class="slots__row slots__row--three"><span></span><span></span><span></span></span>';
							} else if(bet_info.lines == 3) {
								content += '<span class="slots__row slots__row--one slots__row--active"><span></span><span></span><span></span></span>';
								content += '<span class="slots__row slots__row--two slots__row--active"><span></span><span></span><span></span></span>';
								content += '<span class="slots__row slots__row--three slots__row--active"><span></span><span></span><span></span></span>';
							}
							content += '</div>';
							var reel1 = ['bell', 'bell', 'orange', 'watermelon', 'watermelon', 'orange', 'watermelon', 'bell', 'bell', 'bar', 'watermelon', 'bell', 'seven', 'bell', 'watermelon', 'bell', 'cherry', 'cherry', 'bell', 'bell', 'bell', 'bell', 'bell', 'watermelon', 'watermelon', 'cherry', 'seven', 'watermelon', 'cherry', 'bell', 'bell', 'watermelon', 'bell', 'cherry', 'bell', 'orange'];						
							var reel2 = ['orange', 'bell', 'watermelon', 'bell', 'bell', 'bell', 'bell', 'bell', 'cherry', 'watermelon', 'watermelon', 'bell', 'bell', 'bell', 'bell', 'bell', 'cherry', 'orange', 'cherry', 'watermelon', 'watermelon', 'bell', 'watermelon', 'watermelon', 'seven', 'orange', 'cherry', 'bar', 'bell', 'cherry', 'bell', 'cherry', 'bell', 'watermelon', 'watermelon', 'seven'];
							var reel3 = ['bell', 'bell', 'bell', 'bell', 'cherry', 'seven', 'watermelon', 'bell', 'watermelon', 'bell', 'bell', 'watermelon', 'bell', 'bell', 'watermelon', 'cherry', 'seven', 'cherry', 'cherry', 'bell', 'bell', 'watermelon', 'orange', 'bell', 'bell', 'watermelon', 'cherry', 'watermelon', 'bell', 'bar', 'watermelon', 'bell', 'orange', 'bell', 'seven', 'watermelon'];				
							
							content += '<div class="reel__container first_reel">';
							content += '<div class="reel reel--start" style="transform: rotateX('+(bet_info.numbers[0] * 10)+'deg);">';
							for(i = 0; i < reel1.length; i++) {
								content += '<div class="reel__part reel__part--'+reel1[i]+'"></div>';
								content += '<div class="reel__part reel__part--transparent"></div>';
							}
							content += '</div>';
							content += '</div>';
							
							content += '<div class="reel__container second_reel">';
							content += '<div class="reel reel--start" style="transform: rotateX('+(bet_info.numbers[1] * 10)+'deg);">';
							for(i = 0; i < reel2.length; i++) {
								content += '<div class="reel__part reel__part--'+reel2[i]+'"></div>';
								content += '<div class="reel__part reel__part--transparent"></div>';
							}
							content += '</div>';
							content += '</div>';
							
							content += '<div class="reel__container third_reel">';
							content += '<div class="reel reel--start" style="transform: rotateX('+(bet_info.numbers[2] * 10)+'deg);">';
							for(i = 0; i < reel3.length; i++) {
								content += '<div class="reel__part reel__part--'+reel3[i]+'"></div>';
								content += '<div class="reel__part reel__part--transparent"></div>';
							}
							content += '</div>';
							content += '</div>';	
							content += '</div>';
							content += '</div>';
						} else if(bet_info.game_name == 'Mines') {
							mines = bet_info.mines;
							tiles = bet_info.tiles;
							content += '<div class="game_main" style="width: 100%; background: none; box-shadow: none; margin: 0px; padding: 0px"><div class="mine_board">';
							for(i = 0; i < 25; i++) {
								if(mines.includes(i)) {
									if(tiles.includes(i)) {
										content += '<div class="tile" id="tile_'+i+'"><div class="back"><img src="<?=base_url()?>assets/img/games/Bomb_150.png" class="show"/></div></div>';
									} else {
										content += '<div class="tile" id="tile_'+i+'"><div class="back revealed"><img src="<?=base_url()?>assets/img/games/Bomb_150.png" class="show"/></div></div>';
									}
								} else {
									if(tiles.includes(i)) {
										content += '<div class="tile" id="tile_'+i+'"><div class="back"><img src="<?=base_url()?>assets/img/games/Diamond_150.png" class="show"/></div></div>';
									} else {
										content += '<div class="tile" id="tile_'+i+'"><div class="back revealed"><img src="<?=base_url()?>assets/img/games/Diamond_150.png" class="show"/></div></div>';
									}
								}							
							}
							content += '</div></div>';
						} else if(bet_info.game_name == 'Poker') {
							content += '<div class="poker_game_container single_title_n">';

							content +='<span>Initial Hand</span>';
							content += '<div class="game_poker_board">';
							for(i = 0; i < 5; i++) {
								if(Array.isArray(bet_info.selected_cards) && bet_info.selected_cards.includes(i)) {
									content += draw_poker_card(bet_info.cards[i], 'picked');
								} else {
									content += draw_poker_card(bet_info.cards[i]);
								}
							}
							content += '</div>';
							if(bet_info.hand != '') {
								content +='<span>Player Hand ('+bet_info.hand+')</span>';
							} else {
								content +='<span>Player Hand</span>';
							}
							content += '<div class="game_poker_board">';
							for(i = 5; i < 10; i++) {
								if(Array.isArray(bet_info.selected_cards) && bet_info.selected_cards.includes(i-5)) {
									if(Array.isArray(bet_info.highlights) && bet_info.highlights.includes(i-5)) {
										content += draw_poker_card(bet_info.cards[i-5], '', 'highlight');
									} else {
										content += draw_poker_card(bet_info.cards[i-5]);
									}
									
								} else {
									if(Array.isArray(bet_info.highlights) && bet_info.highlights.includes(i-5)) {
										content += draw_poker_card(bet_info.cards[i], '', 'highlight');
									} else {
										content += draw_poker_card(bet_info.cards[i]);
									}
								}
							}
							content += '</div>';
							content += '</div>';

						} else if(bet_info.game_name == 'Baccarat') {
							content += '<div class="baccarat_game_container">';
							content += '<div class="bc_board">';
							if(bet_info.banker_total > bet_info.player_total) {
								content += '<div class="bc_row win" style="margin: 30px auto 10px; width: fit-content; display: flex">';
								for(i = 0; i < bet_info.banker_cards.length; i++) {
									content += draw_baccarat_card(bet_info.banker_cards[i]);
								}
								content += '</div>';
								content += '<div class="bc_summary win">Banker: <span>'+bet_info.banker_total+'</span></div>';

								content += '<div class="bc_row" style="margin: 30px auto 10px; width: fit-content; display: flex">';
								for(i = 0; i < bet_info.player_cards.length; i++) {
									content += draw_baccarat_card(bet_info.player_cards[i]);
								}
								content += '</div>';
								content += '<div class="bc_summary">Player: <span>'+bet_info.player_total+'</span></div>';
							} else if (bet_info.banker_total < bet_info.player_total) {
								content += '<div class="bc_row" style="margin: 30px auto 10px; width: fit-content; display: flex">';
								for(i = 0; i < bet_info.banker_cards.length; i++) {
									content += draw_baccarat_card(bet_info.banker_cards[i]);
								}
								content += '</div>';
								content += '<div class="bc_summary">Banker: <span>'+bet_info.banker_total+'</span></div>';

								content += '<div class="bc_row win" style="margin: 30px auto 10px; width: fit-content; display: flex">';
								for(i = 0; i < bet_info.player_cards.length; i++) {
									content += draw_baccarat_card(bet_info.player_cards[i]);
								}
								content += '</div>';
								content += '<div class="bc_summary win">Player: <span>'+bet_info.player_total+'</span></div>';
							} else {
								content += '<div class="bc_row tie" style="margin: 30px auto 10px; width: fit-content; display: flex">';
								for(i = 0; i < bet_info.banker_cards.length; i++) {
									content += draw_baccarat_card(bet_info.banker_cards[i]);
								}
								content += '</div>';
								content += '<div class="bc_summary tie">Banker: <span>'+bet_info.banker_total+'</span></div>';

								content += '<div class="bc_row tie" style="margin: 30px auto 10px; width: fit-content; display: flex">';
								for(i = 0; i < bet_info.player_cards.length; i++) {
									content += draw_baccarat_card(bet_info.player_cards[i]);
								}
								content += '</div>';
								content += '<div class="bc_summary tie">Player: <span>'+bet_info.player_total+'</span></div>';
							}
	
							content += '</div>';
							content += '</div>';

						} else if(bet_info.game_name == 'Hilow') {
							content += '<div class="hilow_game_container">';
							content += '<div class="hilow_card_list">';
							content += '<div class="hilow_slider">';
							for(i = 0; i < bet_info.selections.length; i++) {
								var number1 = Math.floor(bet_info.cards[i] / 4) + 2;
								if(number1 >= 14) {
									number1 = 1;
								}
								var number2 = Math.floor(bet_info.cards[i+1] / 4) + 2;
								if(number2 >= 14) {
									number2 = 1;
								}
								// selections: lower(1) | lower or equal(2) | equal(3) | higher or equal(4) | higher(5)
								content += draw_hilow_card(bet_info.cards[i]);
								if(bet_info.selections[i] == 1) {
									if(number2 < number1) {
										content += '<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-down"></i></div>';
									} else {
										content += '<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-down"></i></div>';
									}
								} else if(bet_info.selections[i] == 2){
									if(number2 <= number1) {
										content += '<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-double-down"></i></div>';
									} else {
										content += '<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-double-down"></i></div>';
									}
								} else if(bet_info.selections[i] == 3){
									if(number2 == number1) {
										content += '<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-equals"></i></div>';
									} else {
										content += '<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-equals"></i></div>';
									}
								} else if(bet_info.selections[i] == 4){
									if(number2 >= number1) {
										content += '<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-double-up"></i></div>';
									} else {
										content += '<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-double-up"></i></div>';
									}
								} else if(bet_info.selections[i] == 5){
									if(number2 > number1) {
										content += '<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-up"></i></div>';
									} else {
										content += '<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: 1"><i class="fas fa-angle-up"></i></div>';
									}
								}
							}
							content += draw_hilow_card(bet_info.cards[bet_info.selections.length]);
							content += '</div>';
							content += '</div>';
							content += '</div>';
						} else if(bet_info.game_name == 'Roulette') {
							var roulette_wheel = [0, 26, 3, 35, 12, 28, 7, 29, 18, 22, 9, 31, 14, 20, 1, 33, 16, 24, 5, 10, 23, 8, 30, 11, 36, 13, 27, 6, 34, 17, 25, 2, 21, 4, 19, 15, 32];
							var index = roulette_wheel.indexOf(bet_info.number);
							var deg = index * 9.72972973;
							content += '<div class="roulette-wrap"><div class="roulette-wheel" style="transform: rotate('+deg+'deg) translateZ(0.0001px); transition: -webkit-transform 2000ms cubic-bezier(0.17, 0.67, 0.12, 0.99) 0s;"></div><span class="frame"></span><span class="ball"></span></div>';
							content += draw_roulette_table(bet_info.chips);
						} else if(bet_info.game_name == 'Wheel') {
							var wheel_multiply = [3, 0, 1.5, 0, 2.5, 0, 1, 0, 2, 0, 1.5, 0];
							var payout = wheel_multiply.indexOf(bet_info.index);
							var deg = bet_info.index * 30;
							content += '<div id="wheel-main"><div class="wheel-container"><div class="wheel2" style="transform: rotate('+deg+'deg); transition: -webkit-transform 0ms ease 0s;"></div><div class="wheel-shadow"></div><div class="wheel-mask"></div><div class="wheel-pointer"></div><div class="wheel-center"></div></div></div>';
						} else if(bet_info.game_name == 'Plinko') {
							if(bet_info.risk == 0) {
								bet_info.risk = 'Low';
							} else if (bet_info.risk == 1){
								bet_info.risk = 'Medium';
							} else if (bet_info.risk == 2){
								bet_info.risk = 'High';
							}
							content += '<div style="background: #ff003f;box-shadow: 0 0.2em 0 0 #a60004; text-align: center; border-radius: 5px; color: #FFF; width: 70px; padding: 10px; margin-left: calc(50% - 35px)">'+bet_info.payout+'×</div>';
							content += '<div class="input_label" style="margin-top: 10px">Risk</div>';
							content += '<div class="input_group" style="padding: 0px;">';
							content += '	<div class="icon"><i class="fas fa-line-height addon"></i></div>';
							content += '	<input style="padding-left: 10px" type="text" value="'+bet_info.risk+'" readonly="readonly">';
							content += '</div>';
						} else if(bet_info.game_name == 'Limbo') {
							content += '<div style="width: 120px; margin: 10px auto; background: #03a9f4; box-shadow: 0 0.2em 0 0 #2196F3; color: #FFF; padding: 10px;border-radius: 5px; text-align: center">Target: '+bet_info.multiplier+'x</div>';
							if(bet_info.payout > 0) {
								content += '<div style="width: 120px; margin: 10px auto; background: #8bc34a; box-shadow: 0 0.2em 0 0 #4CAF50; color: #FFF; padding: 10px;border-radius: 5px;  text-align: center">Result: '+bet_info.number+'x</div>';
							} else {
								content += '<div style="width: 120px; margin: 10px auto; background: #F44336; box-shadow: 0 0.2em 0 0 #cf1507; color: #FFF; padding: 10px;border-radius: 5px;  text-align: center">Result: '+bet_info.number+'x</div>';
							}
							
						} else if(bet_info.game_name == 'Keno') {
							var numbers = bet_info.numbers;
							var selected_numbers = bet_info.selected_numbers;
							for(let i = 0; i < selected_numbers.length; i++) {
								selected_numbers[i] = parseInt(selected_numbers[i]);
							}
							content += '<div class="table_gamebox keno_gameboard"><div class="keno_table">';
							for(let i = 1; i <= 40; i++) {
								if(selected_numbers.includes(i)) {
									if(numbers.includes(i)) {
										content += '<div class="keno_gamecell matched" number_id="'+i+'"><div class="keno_gem">'+i+'</div></div>';
									} else {
										content += '<div class="keno_gamecell selected" number_id="'+i+'"><div class="keno_gamecell_coverimg"></div><div class="keno_gamecell_index">'+i+'</div></div>';
									}
								} else {
									if(numbers.includes(i)) {
										content += '<div class="keno_gamecell opened" number_id="'+i+'"><div class="keno_gamecell_index">'+i+'</div></div>';
									} else {
										content += '<div class="keno_gamecell" number_id="'+i+'"><div class="keno_gamecell_coverimg"></div><div class="keno_gamecell_index">'+i+'</div></div>';
									}
								}
							}
							content += '</div></div>';
						} else if(bet_info.game_name == 'Triple') {
							content += '<div class="result_dice_group" style="width: 275px; margin: 50px auto 0px">';
							content += '<div class="dice_cube wiggle die__'+bet_info.dice[0]+'"><i class="dot_1"></i><i class="dot_2"></i><i class="dot_3"></i><i class="dot_4"></i><i class="dot_5"></i><i class="dot_6"></i><i class="dot_7"></i><i class="dot_8"></i></div>';
							content += '<div class="dice_cube wiggle die__'+bet_info.dice[1]+'"><i class="dot_1"></i><i class="dot_2"></i><i class="dot_3"></i><i class="dot_4"></i><i class="dot_5"></i><i class="dot_6"></i><i class="dot_7"></i><i class="dot_8"></i></div>';
							content += '<div class="dice_cube wiggle die__'+bet_info.dice[2]+'"><i class="dot_1"></i><i class="dot_2"></i><i class="dot_3"></i><i class="dot_4"></i><i class="dot_5"></i><i class="dot_6"></i><i class="dot_7"></i><i class="dot_8"></i></div>';
							content += '</div>';
							if (typeof bet_info.bet_on !== 'undefined') {
								if(bet_info.bet_on == 1) {
									bet_on = 'SMALL';
								} else if(bet_info.bet_on == 2) {
									bet_on = 'BIG';
								} else {
									bet_on = bet_info.bet_on;
								}
								if(bet_info.profit > 0) { 
									content += '<div style="border: 1px solid #38cb74; width: 150px; margin: 10px auto; border-radius: 5px; padding: 10px; text-align: center">Bet on: <span style="font-weight: bold; font-size: 18px; color: #38cb74">'+bet_on+'</span></div>';
								} else {
									content += '<div style="border: 1px solid #ff5722; width: 150px; margin: 10px auto; border-radius: 5px; padding: 10px; text-align: center">Bet on: <span style="font-weight: bold; font-size: 18px; color: #ff5722">'+bet_on+'</span></div>';
								}
								
							}
						}
						content += '<div class="input_label" style="margin-top: 10px">Nonce</div>';
						content += '<div class="input_group" style="padding: 0px;">';
						content += '	<div class="icon"><i class="fas fa-sort-numeric-up"></i></div>';
						content += '	<input style="padding-left: 10px" type="number" id="ver_nonce" value="'+bet_info.nonce+'" readonly="readonly">';
						content += '</div>';
						content += '<div class="input_label" style="margin-top: 10px">Server seed</div>';
						content += '<div class="input_group" style="padding: 0px;">';
						content += '	<div class="icon"><i class="fas fa-server"></i></div>';
						content += '	<input style="padding-left: 10px" type="text" id="ver_server_seed" maxlength="64"  value="'+bet_info.server_seed+'" readonly="readonly">';
						content += '</div>';
						content += '<div class="input_label" style="margin-top: 10px">Server seed hash</div>';
						content += '<div class="input_group" style="padding: 0px;">';
						content += '	<div class="icon"><i class="fas fa-code"></i></div>';
						content += '	<input style="padding-left: 10px" type="text" id="ver_server_seed_hash" value="'+bet_info.server_seed_hash+'" readonly="readonly">';
						content += '</div>';
						content += '<div class="input_label" style="margin-top: 10px">Client seed</div>';
						content += '<div class="input_group" style="padding: 0px;">';
						content += '	<div class="icon"><i class="fas fa-laptop-code"></i></div>';
						content += '	<input style="padding-left: 10px" type="text" id="ver_client_seed" maxlength="16"  value="'+bet_info.client_seed+'" readonly="readonly">';
						if(bet_info.game_name == 'Ultimate') {
							bet_info.game = 'Dice';
						}
						content += '	<input style="padding-left: 10px" type="hidden" id="ver_game" value="'+bet_info.game_name+'"">';
						content += '</div>';
						content += '<button class="process_btn" type="submit" onclick="redirect_verify()" style="width: 100%; margin: 20px auto">VERIFY</button>';
						content += '</div>';
						show_modal('<i class="fas fa-clipboard-list"></i> Bet Info', content);
					}
				}
			});
		}, 500);
	}
	
	function draw_poker_card(card_value, picked = '', highlight = '') {
		var number = '';
		var suit = '';
		if(Math.floor(card_value / 4) < 9) {
			number = Math.floor(card_value / 4) + 2;
		} else if (Math.floor(card_value / 4) == 9) {
			number = 'J';
		} else if (Math.floor(card_value / 4) == 10) {
			number = 'Q';
		} else if (Math.floor(card_value / 4) == 11) {
			number = 'K';
		} else {
			number = 'A';
		}
		if(card_value % 4 == 0) {
			suit = 'diamond';
		} else if(card_value % 4 == 1) {
			suit = 'heart';
		} else if(card_value % 4 == 2) {
			suit = 'club';
		} else if(card_value % 4 == 3) {
			suit = 'spade';
		}
		var content = '';
		content += '	<div class="poker_card">';
		content += '		<div class="poker_card_inner '+suit+' '+picked+' '+highlight+'">';
		content += '			<div class="front">';
		content += '				<p class="card_number">'+number+'</p>';
		content += '				<p class="card_symbol"><i class="fas fa-'+suit+'"></i></p>';
		content += '				<div class="text">HOLD</div>';
		content += '			</div>';
		content += '		</div>';
		content += '	</div>';
		return content;
	}
	
	function draw_baccarat_card(card_value) {
		var number = '';
		var suit = '';
		if(Math.floor(card_value / 4) < 9) {
			number = Math.floor(card_value / 4) + 2;
		} else if (Math.floor(card_value / 4) == 9) {
			number = 'J';
		} else if (Math.floor(card_value / 4) == 10) {
			number = 'Q';
		} else if (Math.floor(card_value / 4) == 11) {
			number = 'K';
		} else {
			number = 'A';
		}
		if(card_value % 4 == 0) {
			suit = 'diamond';
		} else if(card_value % 4 == 1) {
			suit = 'heart';
		} else if(card_value % 4 == 2) {
			suit = 'club';
		} else if(card_value % 4 == 3) {
			suit = 'spade';
		}
		var content = '';
		content += '	<div class="bc_card" style="margin: 2px !important">';
		content += '		<div class="bc_card_inner '+suit+'">';
		content += '			<div class="front">';
		content += '				<p class="card_number">'+number+'</p>';
		content += '				<p class="card_symbol"><i class="fas fa-'+suit+'"></i></p>';
		content += '			</div>';
		content += '		</div>';
		content += '	</div>';
		return content;
	}
	
	function draw_hilow_card(card_value) {
		var number = '';
		var suit = '';
		if(Math.floor(card_value / 4) < 9) {
			number = Math.floor(card_value / 4) + 2;
		} else if (Math.floor(card_value / 4) == 9) {
			number = 'J';
		} else if (Math.floor(card_value / 4) == 10) {
			number = 'Q';
		} else if (Math.floor(card_value / 4) == 11) {
			number = 'K';
		} else {
			number = 'A';
		}
		if(card_value % 4 == 0) {
			suit = 'diamond';
		} else if(card_value % 4 == 1) {
			suit = 'heart';
		} else if(card_value % 4 == 2) {
			suit = 'club';
		} else if(card_value % 4 == 3) {
			suit = 'spade';
		}
		var content = '';
		content += '	<div class="hilow_small_card">';
		content += '		<div class="hilow_small_card_inner '+suit+'">';
		content += '			<div class="front">';
		content += '				<p class="card_number">'+number+'</p>';
		content += '				<p class="card_symbol"><i class="fas fa-'+suit+'"></i></p>';
		content += '			</div>';
		content += '		</div>';
		content += '	</div>';
		return content;
	}
	
	function draw_roulette_table(chips) {
		const chip_type = ['<div data-coin="10000" class="chip small">10K</div>',
						'<div data-coin="100000" class="chip small">10K</div>',
						'<div data-coin="1000000" class="chip small">1M</div>',
						'<div data-coin="10000000" class="chip small">10M</div>',
						'<div data-coin="100000000" class="chip small">100M</div>',
						'<div data-coin="1000000000" class="chip small">1B</div>',
						'<div data-coin="10000000000" class="chip small">10B</div>'];
		var content = '';
		content += '<div class="col-xs-12" style="padding: 0; width: 320px; margin-left: calc(50% - 160px); float: inherit;">';
			content += '<div class="border-bets">';
				content += '<div class="two-cell-bets">';
					content += '<span data-id-number="49" class="horizontal-bet" data-border-id="0-1">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 49) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="50" class="vertical-bet" data-border-id="1-2">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 50) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="51" class="horizontal-bet" data-border-id="0-2">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 51) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="52" class="vertical-bet" data-border-id="2-3">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 52) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="53" class="horizontal-bet" data-border-id="0-3">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 53) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="54" class="horizontal-bet" data-border-id="1-4">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 54) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="55" class="vertical-bet" data-border-id="4-5">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 55) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="56" class="horizontal-bet" data-border-id="2-5">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 56) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="57" class="vertical-bet" data-border-id="5-6">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 57) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="58" class="horizontal-bet" data-border-id="3-6">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 58) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="59" class="horizontal-bet" data-border-id="4-7">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 59) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="60" class="vertical-bet" data-border-id="7-8">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 60) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="61" class="horizontal-bet" data-border-id="5-8">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 61) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="62" class="vertical-bet" data-border-id="8-9">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 62) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="63" class="horizontal-bet" data-border-id="6-9">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 63) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="64" class="horizontal-bet" data-border-id="7-10">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 64) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="65" class="vertical-bet" data-border-id="10-11">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 65) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="66" class="horizontal-bet" data-border-id="8-11">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 66) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="67" class="vertical-bet" data-border-id="11-12">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 67) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="68" class="horizontal-bet" data-border-id="9-12">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 68) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="69" class="horizontal-bet" data-border-id="10-13">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 69) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="70" class="vertical-bet" data-border-id="13-14">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 70) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="71" class="horizontal-bet" data-border-id="11-14">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 71) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="72" class="vertical-bet" data-border-id="14-15">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 72) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="73" class="horizontal-bet" data-border-id="12-15">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 73) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="74" class="horizontal-bet" data-border-id="13-16">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 74) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="75" class="vertical-bet" data-border-id="16-17">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 75) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="76" class="horizontal-bet" data-border-id="14-17">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 76) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="77" class="vertical-bet" data-border-id="17-18">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 77) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="78" class="horizontal-bet" data-border-id="15-18">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 78) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="79" class="horizontal-bet" data-border-id="16-19">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 79) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="80" class="vertical-bet" data-border-id="19-20">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 80) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="81" class="horizontal-bet" data-border-id="17-20">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 81) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="82" class="vertical-bet" data-border-id="20-21">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 82) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="83" class="horizontal-bet" data-border-id="18-21">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 83) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="84" class="horizontal-bet" data-border-id="19-22">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 84) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="85" class="vertical-bet" data-border-id="22-23">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 85) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="86" class="horizontal-bet" data-border-id="20-23">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 86) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="87" class="vertical-bet" data-border-id="23-24">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 87) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="88" class="horizontal-bet" data-border-id="21-24">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 88) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="89" class="horizontal-bet" data-border-id="22-25">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 89) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="90" class="vertical-bet" data-border-id="25-26">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 90) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="91" class="horizontal-bet" data-border-id="23-26">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 91) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="92" class="vertical-bet" data-border-id="26-27">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 92) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="93" class="horizontal-bet" data-border-id="24-27">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 93) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="94" class="horizontal-bet" data-border-id="25-28">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 94) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="95" class="vertical-bet" data-border-id="28-29">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 95) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="96" class="horizontal-bet" data-border-id="26-29">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 96) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="97" class="vertical-bet" data-border-id="29-30">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 97) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="98" class="horizontal-bet" data-border-id="27-30">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 98) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="99" class="horizontal-bet" data-border-id="28-31">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 99) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="100" class="vertical-bet" data-border-id="31-32">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 100) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="101" class="horizontal-bet" data-border-id="29-32">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 101) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="102" class="vertical-bet" data-border-id="32-33">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 102) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="104" class="horizontal-bet" data-border-id="30-33">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 104) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="105" class="horizontal-bet" data-border-id="31-34">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 105) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="106" class="vertical-bet" data-border-id="34-35">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 106) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="107" class="horizontal-bet" data-border-id="32-35">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 107) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="108" class="vertical-bet" data-border-id="35-36">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 108) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="109" class="horizontal-bet" data-border-id="33-36">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 109) {content += chip_type[chips[i][1]];}}
					content += '</span>';
				content += '</div>';
				content += '<div class="four-cell-bets">';
					content += '<span data-id-number="110" data-border-id="0-1-2">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 110) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="111" data-border-id="0-2-3">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 111) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="124" data-border-id="1-2-4-5">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 124) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="125" data-border-id="2-3-5-6">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 125) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="126" data-border-id="4-5-7-8">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 126) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="127" data-border-id="5-6-8-9">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 127) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="128" data-border-id="7-8-10-11">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 128) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="129" data-border-id="8-9-11-12">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 129) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="130" data-border-id="10-11-13-14">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 130) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="131" data-border-id="11-12-14-15">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 131) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="132" data-border-id="13-14-16-17">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 132) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="133" data-border-id="14-15-17-18">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 133) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="134" data-border-id="16-17-19-20">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 134) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="135" data-border-id="17-18-20-21">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 135) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="136" data-border-id="19-20-22-23">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 136) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="137" data-border-id="20-21-23-24">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 137) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="138" data-border-id="22-23-25-26">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 138) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="139" data-border-id="23-24-26-27">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 139) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="140" data-border-id="25-26-28-29">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 140) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="141" data-border-id="26-27-29-30">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 141) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="142" data-border-id="28-29-31-32">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 142) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="143" data-border-id="29-30-32-33">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 143) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="144" data-border-id="31-32-34-35">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 144) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="145" data-border-id="32-33-35-36">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 145) {content += chip_type[chips[i][1]];}}
					content += '</span>';
				content += '</div>';
				content += '<div class="line-bets">';
					content += '<span data-id-number="112" data-border-id="1-2-3">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 112) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="113" data-border-id="4-5-6">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 113) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="114" data-border-id="7-8-9">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 114) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="115" data-border-id="10-11-12">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 115) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="116" data-border-id="13-14-15">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 116) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="117" data-border-id="16-17-18">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 117) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="118" data-border-id="19-20-21">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 118) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="119" data-border-id="22-23-24">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 119) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="120" data-border-id="25-26-27">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 120) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="121" data-border-id="28-29-30">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 121) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="122" data-border-id="31-32-33">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 122) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="123" data-border-id="34-35-36">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 123) {content += chip_type[chips[i][1]];}}
					content += '</span>';
				content += '</div>';
				content += '<div class="six-cell-bet">';
					content += '<span data-id-number="146" data-border-id="1-2-3-4-5-6">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 146) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="147" data-border-id="4-5-6-7-8-9">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 147) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="148" data-border-id="7-8-9-10-11-12">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 148) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="149" data-border-id="10-11-12-13-14-15">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 149) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="150" data-border-id="13-14-15-16-17-18">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 150) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="151" data-border-id="16-17-18-19-20-21">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 151) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="152" data-border-id="19-20-21-22-23-24">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 152) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="153" data-border-id="22-23-24-25-26-27">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 153) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="154" data-border-id="25-26-27-28-29-30">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 154) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="155" data-border-id="28-29-30-31-32-33">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 155) {content += chip_type[chips[i][1]];}}
					content += '</span>';
					content += '<span data-id-number="156" data-border-id="31-32-33-34-35-36">';
					for(let i = 0; i < chips.length; i++){if(chips[i][0] == 156) {content += chip_type[chips[i][1]];}}
					content += '</span>';
				content += '</div>';
			content += '</div>';
			content += '<div class="zero" data-id-number="0">';
				content += '<span>0</span>';
				for(let i = 0; i < chips.length; i++){if(chips[i][0] == 0) {content += chip_type[chips[i][1]];}}
			content += '</div>';
			content += '<table class="roulette">';
				content += '<tbody>';
					content += '<tr>';
						content += '<td data-id-number="37" id="c18" rowspan="2" class="text-roulette" style="border-radius: 3px 0 0 0;">';
							content += '<span style="top: 22px; left: -3px;"><strong>1</strong> to <strong>18</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 37) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="1" class="s12 c18 column1 odd r"><span class="number red">1</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 1) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="2" class="s12 c18 column2 even b"><span class="number">2</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 2) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="3" class="s12 c18 column3 odd r"><span class="number red">3</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 3) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="43" id="s12" rowspan="4" class="text-roulette right-number" style="border-radius: 0 3px 0 0;">';
							content += '<span style="top: 55px; left: -2px;"><strong>1</strong>st <strong>12</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 43) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="4" class="s12 c18 column1 even b"><span class="number">4</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 4) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="5" class="s12 c18 column2 odd r"><span class="number red">5</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 5) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="6" class="s12 c18 column3 even b"><span class="number">6</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 6) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td id="even" data-id-number="41" rowspan="2" class="text-roulette">';
							content += '<span style="top: 23px; left: 2px;"><strong>Even</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 41) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="7" class="s12 c18 column1 odd r"><span class="number red">7</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 7) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="8" class="s12 c18 column2 even b"><span class="number">8</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 8) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="9" class="s12 c18 column3 odd r"><span class="number red">9</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 9) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="10" class="s12 c18 column1 even b"><span class="number">10</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 10) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="11" class="s12 c18 column2 odd b"><span class="number">11</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 11) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="12" class="s12 c18 column3 even r"><span class="number red">12</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 12) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="40" id="r" rowspan="2" class="text-roulette">';
							content += '<span id="diamond-narrow" class="red"></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 40) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="13" class="s24 c18 column1 odd b"><span class="number">13</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 13) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="14" class="s24 c18 column2 even r"><span class="number red">14</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 14) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="15" class="s24 c18 column3 odd b"><span class="number">15</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 15) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="44" id="s24" rowspan="4" class="text-roulette right-number">';
							content += '<span style="top: 55px; left: -4px;"><strong>2</strong>nd <strong>12</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 44) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="16" class="s24 c18 column1 even r"><span class="number red">16</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 16) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="17" class="s24 c18 column2 odd b"><span class="number">17</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 17) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="18" class="s24 c18 column3 even r"><span class="number red">18</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 18) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="39" id="b" rowspan="2" class="text-roulette">';
							content += '<span id="diamond-narrow"></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 39) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="19" class="s24 c36 column1 odd r"><span class="number red">19</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 19) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="20" class="s24 c36 column2 even b"><span class="number">20</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 20) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="21" class="s24 c36 column3 odd r"><span class="number red">21</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 21) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="22" class="s24 c36 column1 even b"><span class="number">22</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 22) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="23" class="s24 c36 column2 odd r"><span class="number red">23</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 23) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="24" class="s24 c36 column3 even b"><span class="number">24</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 24) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td id="odd" data-id-number="42" rowspan="2" class="text-roulette">';
							content += '<span style="top: 22px; left: 3px;"><strong>Odd</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 42) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="25" class="s36 c36 column1 odd r"><span class="number red">25</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 25) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="26" class="s36 c36 column2 even b"><span class="number">26</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 26) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="27" class="s36 c36 column3 odd r"><span class="number red">27</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 27) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="45" id="s36" rowspan="4" class="text-roulette right-number" style="border-radius: 0 0 3px 0;">';
							content += '<span style="top: 55px; left: -3px;"><strong>3</strong>rd <strong>12</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 45) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="28" class="s36 c36 column1 even b"><span class="number">28</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 28) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="29" class="s36 c36 column2 odd b"><span class="number">29</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 29) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="30" class="s36 c36 column3 even r"><span class="number red">30</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 30) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="38" id="c36" rowspan="2" class="text-roulette" style="border-radius: 0 0 0 3px;">';
							content += '<span style="top: 21px; left: -4px;"><strong>19</strong>to<strong>36</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 38) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="31" class="s36 c36 column1 odd b"><span class="number">31</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 31) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="32" class="s36 c36 column2 even r"><span class="number red">32</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 32) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="33" class="s36 c36 column3 odd b"><span class="number">33</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 33) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td data-id-number="34" class="s36 c36 column1 even r"><span class="number red">34</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 34) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="35" class="s36 c36 column2 odd b"><span class="number">35</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 35) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="36" class="s36 c36 column3 even r"><span class="number red">36</span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 36) {content += chip_type[chips[i][1]];}}
						content += '</td>';
					content += '</tr>';
					content += '<tr>';
						content += '<td class="empty" style="border-right: 2px solid #DDD"></td>';
						content += '<td data-id-number="46" id="column1" class="text-roulette bottom-text"><span><strong>2</strong> to <strong>1</strong></span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 46) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="47" id="column2" class="text-roulette bottom-text"><span><strong>2</strong> to <strong>1</strong></span>';
						for(let i = 0; i < chips.length; i++){if(chips[i][0] == 47) {content += chip_type[chips[i][1]];}}
						content += '</td>';
						content += '<td data-id-number="48" id="column3" class="text-roulette bottom-text" style="border-radius: 0 0 3px 0;">';
							content += '<span><strong>2</strong> to <strong>1</strong></span>';
							for(let i = 0; i < chips.length; i++){if(chips[i][0] == 48) {content += chip_type[chips[i][1]];}}
						content +='</td>';							
						content += '<td class="empty"></td>';
					content += '</tr>';
				content += '</tbody>';
			content += '</table>';
		content += '</div>';
		return content;
	}
	
	function redirect_verify() {
		var nonce = $('#ver_nonce').val();
		var server_seed = $('#ver_server_seed').val();
		var client_seed = $('#ver_client_seed').val();
		var game = $('#ver_game').val();
		window.open(
			"<?=base_url()?>provably_fair.php?game="+game+"&nonce="+nonce+"&server_seed="+server_seed+"&client_seed="+client_seed,
			"_blank"
		);
	}
	
	$(document).ready(function() {
		$('.show_bet_info').on('click', show_bet_info);
		$('[data-toggle="tooltip"]').tooltip();
		$('.js_clipboard').click(function(e){
			e.preventDefault();
			$(this).attr('title', "Copied")
			  .tooltip('fixTitle')
			  .data('bs.tooltip')
			  .$tip.find('.tooltip-inner')
			  .text("Copied");
			$(this).attr('title', "Copy")
			  .tooltip('fixTitle')
			  .data('bs.tooltip');
			 
			var textToCopy = $(this).attr('data-copy');
			var $temp = $("<input>");
			$("body").append($temp);
			$temp.val(textToCopy).select();
			document.execCommand("copy");
			$temp.remove();
		});
	});
	
</script>