<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Surveys</h2>
					<a href="<?=base_url()?>adm/surveys.php?&s=top_thisweek">Top This Week</a>
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL AMOUNT</td><td width="50%"><?=number_format($statistics['total_amount'] / 100000000, 8, '.', '')?> (<?=number_format($statistics['total_USD'], 3, '.', '')?>$)</td></tr>
							<tr class="history_row"><td>TOTAL SURVEYS</td><td><?=$statistics['total_surveys']?></td></tr>
							<?php if($reject_surveys != null):?>
							<tr class="history_row"><td>REJECT</td><td><?=$reject_surveys->total_surveys?> (<?=number_format($reject_surveys->USD_value, 2)?>$)</td></tr>
							<?php endif?>
						</tbody>
					</table>
					
					<form method="GET" style="margin: 20px auto;">
					
					  <!-- User ID / Email / Wallet (tùy bạn dùng mapping ở controller; ở đây ưu tiên user_id) -->
					  <div class="input-group" style="margin:20px auto 0; height:45px; font-size:14px; max-width:800px;">
						<span class="input-group-addon" style="border-radius:0; padding:14px 15px">
						  <i class="fas fa-search"></i>
						</span>
						<input name="user_id" type="text" class="form-control"
							   placeholder="User ID"
							   style="height:45px;"
							   value="<?= isset($filters['user_id']) && $filters['user_id'] !== null ? htmlspecialchars($filters['user_id']) : '' ?>">
					  </div>

					  <!-- Provider -->
					  <div class="input-group" style="margin:20px auto 0; height:45px; max-width:800px; font-size:14px">
						<span class="input-group-addon" style="border-radius:0; padding:14px 13.5px">
						  <i class="fas fa-filter"></i>
						</span>
						<select name="survey_site" class="form-control" style="height:45px;">
						  <option value="">Provider (All)</option>
						  <?php
							$providers = ['cpx_research','timewall','bitlabs', 'theoremreach','monlix'];
							$cur = isset($filters['survey_site']) ? $filters['survey_site'] : '';
							foreach ($providers as $p) {
							  $sel = ($cur === $p) ? 'selected' : '';
							  echo "<option value=\"{$p}\" {$sel}>".htmlspecialchars($p)."</option>";
							}
						  ?>
						</select>
					  </div>

					  <!-- Status -->
					  <div class="input-group" style="margin:20px auto 0; height:45px; max-width:800px; font-size:14px">
						<span class="input-group-addon" style="border-radius:0; padding:14px 13.5px">
						  <i class="fas fa-check-circle"></i>
						</span>
						<select name="status" class="form-control" style="height:45px;">
						  <option value="">Status (All)</option>
						  <option value="1" <?= (isset($filters['status']) && (int)$filters['status'] === 1) ? 'selected' : '' ?>>Completed / Bonus</option>
						  <option value="2" <?= (isset($filters['status']) && (int)$filters['status'] === 2) ? 'selected' : '' ?>>Rejected</option>
						</select>
					  </div>

					  <!-- Submit -->
					  <div class="input-group" style="margin:20px auto 0; height:45px; font-size:14px">
						<input class="btn btn-info" style="width:200px; padding:10px;" type="submit" value="Search">
					  </div>

					  <!-- Khi submit, về trang 1 -->
					  <input type="hidden" name="p" value="1">
					</form>
					
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>Site</td>
									<td>User</td>
									<td>TransID</td>
									<td>Earning</td>
									<td>Status</td>
									<td>Country</td>
									<td>Date</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($get_surveys)) {
										foreach($get_surveys as $row) {
											echo '<tr>';
											echo '<td><a style="color: #ff9800" href="'.base_url().'adm/surveys.php?survey_site='.$row->survey_site.'">'.$row->survey_site.'</a></td>';
											echo '<td><a href="'.base_url().'adm/profile.php?uid='.$row->user_id.'">'.$row->user_name.'</a></td>';
											echo '<td>'.$row->trans_id.'</td>';
											$amount_USD = $row->USD_value;
											$amount_local = number_format(floatval($row->earning_amount / 100000000 * $DOGE_price), 4, '.', '');
											echo '<td>'.number_format($row->earning_amount / 100000000, 8).'<br/>'.number_format($amount_local, 4).'$ / '.number_format($amount_USD, 4).'$</td>';
											
											if($row->status == 1) {
												if($amount_USD > 0.1) {
													echo '<td><a style="color: #4caf50" href="'.base_url().'adm/surveys.php?status=1">Completed</a></td>';
												} else if ($amount_USD >= 0) {
													echo '<td><a style="color: #00bcd4" href="'.base_url().'adm/surveys.php?status=1">Bonus</a></td>';
												} else {
													echo '<td style="color: #999">Survey out</td>';
												}
											} else {
												echo '<td><a  style="color: #ff5722" href="'.base_url().'adm/surveys.php?status=2">Reject</a></td>';
											}
											
											echo '<td>';
											echo '<a href="'.base_url().'adm/users.php?k='.$row->ip_click.'">'.$row->ip_click.'</a>';
											if($row->ip_click != '') {
												$country = GeoIp2CountryIsoCode($row->ip_click);
												echo '<br/>'.$country;
											}
											echo '</td>';
											
											if(date('Y-m-d', $row->time) == date('Y-m-d')) {
												$row->time =  date('H:i:s A', $row->time);
											} else {
												$row->time =  date('H:i:s (Y-m-d)', $row->time);
											}
											echo '<td>'.$row->time.'</td>';
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="7">No surveys found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
	</body>
</html>