<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
	  #preview {
		margin-top: 10px;
		height: 65px;
		overflow-x: auto;
		white-space: nowrap;
		border: 1px solid #DDD;
		padding: 6px;
		border-radius: 5px;
	  }

	  #preview img {
		height: 50px;
		margin-right: 8px;
		border-radius: 6px;
		object-fit: cover;
		float: left;
	  }
	  #noImage {
		  color: #888;
		  font-style: italic;
		  white-space: nowrap;
		  margin-top: 15px;
		}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Tickets</h2>
					<section style="max-width: 800px; margin: 20px auto;">
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-envelope"></i></span>
							<input id="email" name="email" type="text" class="form-control" placeholder="Email" value="<?=$email?>" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-heading"></i></span>
							<input id="subject" name="subject" type="text" class="form-control" placeholder="Subject" style="height: 45px;">
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 15px"><i class="fas fa-pen-alt"></i></span>
							<textarea id="message" name="message" type="text" class="form-control" style="height: 200px; resize: none;"></textarea>
						</div>
						
						<!-- upload images -->
						<div style="width: 100%; text-align: left; margin-top: 10px"><a id="uploadBtn" href="javascript: void(0)"><i class="fas fa-paperclip"></i> Attach images</a></div>
						<input type="file" id="imageInput" style="display: none" accept="image/*" multiple>
						<div id="preview">
							 <div id="noImage">No image uploaded.</div>
						</div>
						<!-- upload images -->
						
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<div class="btn btn-info" style="width: 200px; padding: 10px;" id="process_create_ticket" onclick="process_create_ticket()">Create ticket</div>
						</div>
					</section>
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>Date</td>
									<td>User</td>
									<td>Email</td>
									<td>Subject</td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($tickets)) {
										foreach($tickets as $row) {
											echo '<tr>';
											echo '<td>'.$row->updated_time.'</td>';
											if($row->user_id != 0) {
												echo '<td><a href="'.base_url().'adm/profile.php?uid='.$row->user_id.'">'.$row->user_name.'</a></td>';
											} else {
												echo '<td>'.$row->user_name.'</td>';
											}	
											echo '<td><a style="color: #8bc34a;" href="'.base_url().'adm/tickets.php?email='.$row->email.'">'.$row->email.'</a></td>';
											echo '<td style="text-align: left">';
											
											if($row->replied == 0 && $row->closed == 0) {
												echo '<a style="color: #03A9F4" href="'.base_url().'adm/messages.php?s='.$row->ticket_code.'">';
												echo '<i class="fas fa-envelope"></i> ';
												echo ucfirst($row->subject);
												echo '</a>';
											} else {
												echo '<a style="color: #AAA" href="'.base_url().'adm/messages.php?s='.$row->ticket_code.'">';
												if($row->replied == 0) {
													echo '<i class="fas fa-lock"></i> ';
												} else {
													echo '<i class="fas fa-reply"></i> ';
												}
												echo ucfirst($row->subject);
												echo '</a>';
											}
											echo '</td>';
											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="4">No messages found</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			function process_create_ticket() {
				var email = $('#email').val();
				var subject = $('#subject').val();
				var message = $('#message').val();
				$("#process_create_ticket").attr("disabled", !0);
				$("#process_create_ticket").text("Please wait");
				$.ajax({
					url: " <?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=create_ticket&email="+email+"&subject="+subject+"&message="+message,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
						$("#process_create_ticket").text("Send email");
						$("#process_create_ticket").attr("disabled", false);
					}
				});
			}
		</script>
		
		<script>
			const uploadBtn = document.getElementById("uploadBtn");
			const imageInput = document.getElementById("imageInput");
			const cloudName = "dhu220mvv";
			const uploadPreset = "dogepick";
			const textarea = document.getElementById("message");	
			const preview = document.getElementById("preview");
				
			uploadBtn.addEventListener("click", () => {
				imageInput.click();
			});

			document.getElementById("imageInput").addEventListener("change", async (e) => {
				const files = e.target.files;
				for (let file of files) {
					const formData = new FormData();
					formData.append("file", file);
					formData.append("upload_preset", uploadPreset);

					const res = await fetch(`https://api.cloudinary.com/v1_1/${cloudName}/image/upload`, {
						method: "POST",
						body: formData
					});

					const data = await res.json();
					if (data.secure_url) {
						textarea.value += `${data.secure_url}\n`;
						updatePreview();
						
					} else {
						alert("Upload failed");
					}
				}
			});
			
			
			function updatePreview() {
			  const content = textarea.value;
			  const urls = [];

			  const imgTagRegex = /<img\s[^>]*src=["']([^"']+)["']/gi;
			  let match;
			  while ((match = imgTagRegex.exec(content)) !== null) {
				urls.push(match[1]);
			  }

			  const urlRegex = /(https?:\/\/[^\s]+(\.jpg|\.png|\.webp|\.jpeg|\.gif))/gi;
			  let urlMatch;
			  while ((urlMatch = urlRegex.exec(content)) !== null) {
				if (!urls.includes(urlMatch[1])) urls.push(urlMatch[1]);
			  }

			  if (urls.length === 0) {
				preview.style.display = "block";
				preview.innerHTML = '<div id="noImage">No image uploaded.</div>';
				return;
			  }

			  preview.style.display = "block";
			  preview.innerHTML = "";
			  urls.forEach(url => {
				const img = document.createElement("img");
				img.src = url;
				preview.appendChild(img);
			  });
			}
			textarea.addEventListener("input", updatePreview);
			updatePreview();
		</script>
		
	</body>
</html>