<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu.php');?>
		<section class="get_form_nine_area p_100">
            <div class="container">
               	<div class="single_title_n">
               		<h2>Withdrawals</h2>
					<a href="<?=base_url()?>adm/withdrawals.php?status=Unconfirmed">[Unconfirmed]</a> | <a href="<?=base_url()?>adm/withdrawals.php?status=Pending">[Pending]</a>  | <a href="<?=base_url()?>adm/withdrawals.php?status=Processing">[Processing]</a> 
					<table class="history_tbl" style="max-width: 800px; margin: 20px auto">
						<thead><tr><th class="top_header" colspan="7" style="background: #8bc34a; border: none">STATISTICS</th></tr></thead>
						<tbody>
							<tr class="history_row"><td width="50%">TOTAL AMOUNT</td><td width="50%"><?=number_format($statistics->total_amount / 100000000, 8, '.', '')?><br/><span style="color: #03A9F4">$<?=$statistics->USD_value?></span></td></tr>
							<tr class="history_row"><td>TOTAL REQUESTS</td><td><?=$statistics->total_requests?></td></tr>
							<?php if(false):?><tr class="history_row"><td>MAX AMOUNT</td><td><?=number_format($statistics->max_amount / 100000000, 8, '.', '')?></td></tr><?php endif?>
							<!--<tr class="history_row"><td>ACTION</td><td><a href="javascript: void(0)" onclick="process_payout2()">Pay checked requests</a></td></tr>-->
							<tr class="history_row"><td>AUTO PAYOUT</td><td><?php if($allow_auto_payout == 1) echo '<a style="color: green" onclick="disable_auto_payout2()">Enabled</a>'; else echo '<a style="color: red" onclick="enable_auto_payout2()">Disabled</a>';?></td></tr>
							<tr class="history_row"><td>LAST AUTO PAYOUT</td><td><?=$last_auto_payout?></td></tr>
						</tbody>
					</table>
					<div style="width: 100%; overflow-x: auto; margin: 100px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td>User</td>
									<td>Net Flow</td>
									<td>Amount</td>
									<td>Address / TxID</td>
									<td>Status / Actions</td>
								</tr>
							</thead>
							<tbody>
								<?php
								if (is_array($transactions)) {
									foreach ($transactions as $row) {
										echo '<tr>';

										// --- User ---
										echo '<td>';
										if (!empty($row->auto_payout)) {
											echo '<i class="fas fa-badge-check" style="color: #8bc34a; margin-right: 5px"></i>';
										}
										echo '<a href="' . base_url() . 'adm/profile.php?uid=' . $row->uid . '">' . $row->user_name . '</a> (' . $row->total_referrals . ')<br/>';
										echo '<a href="' . base_url() . 'adm/users.php?k=' . GeoIp2CountryIsoCode($row->ip_address) . '" style="color: #9e9e9e">' . GeoIp2Country($row->ip_address) . '</a>';
										echo '</td>';

										// --- Net Flow ---
										echo '<td>';
										echo '<div style="color: green">' . number_format($row->total_deposits / 100000000, 8, '.', '') . '</div>';
										echo '<div style="color: red">' . number_format($row->total_withdrawals / 100000000, 8, '.', '') . '</div>';
										echo '</td>';

										// --- Amount ---
										echo '<td>';
										echo number_format($row->amount / 100000000, 8, '.', '') . '<br/><span style="color: #03A9F4">$' . number_format($row->USD_value, 2, '.', '').'</span>';;
										echo '</td>';

										// --- Address + TxID ---
										echo '<td>';
										echo '<a href="https://dogechain.info/address/' . $row->address . '">' . substr($row->address, 0, 6) . '...' . substr($row->address, -6) . '</a> ';
										echo '<i class="far fa-copy fa-fw js_clipboard" data-copy="' . $row->address . '" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i><br/>';

										if (!empty($row->txid)) {
											if (strlen($row->txid) > 30) {
												echo '<a style="color: #4caf50" href="https://dogechain.info/tx/' . $row->txid . '">' . substr($row->txid, 0, 6) . '...' . substr($row->txid, -6) . '</a> ';
											} else {
												echo '<a style="color: orange" href="' . base_url() . 'adm/users.php?k=txid=' . $row->txid . '">' . $row->txid . '</a> ';
											}
											echo '<i class="far fa-copy fa-fw js_clipboard" data-copy="' . $row->txid . '" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>';
										}
										echo '</td>';

										// --- Status + Actions + Time ---
										echo '<td id="req' . $row->id . '">';
										switch ($row->status) {
											case 'Completed':
												echo '<a href="javascript:void(0)" style="color: #4caf50">' . $row->status . '</a>';
												break;
											case 'Pending':
											case 'Unconfirmed':
												echo '<a href="javascript:void(0)" onclick="process_payout(' . $row->id . ')" style="color: #0083ff">Payout</a> | ';
												echo '<a href="javascript:void(0)" class="process_cancel_request" style="color: #ff9800" reqid="' . $row->id . '" request_act="refund">Refund</a> | ';
												echo '<a href="javascript:void(0)" class="process_cancel_request" style="color: #ff5722" reqid="' . $row->id . '" request_act="reject">Reject</a>';
												break;
											case 'Processing':
												echo '<a href="javascript:void(0)" onclick="process_check_transaction(' . $row->id . ')" reqid="' . $row->id . '">Check</a> | ';
												echo '<a href="javascript:void(0)" onclick="process_repay(' . $row->id . ')" reqid="' . $row->id . '">Repay</a> | ';
												echo '<a href="javascript:void(0)" onclick="process_edit_txid(' . $row->id . ', `' . $row->txid . '`)" reqid="' . $row->id . '">Edit txid</a>';
												break;
											default:
												echo $row->status;
										}
										echo '<br/>' . $row->time;
										echo '</td>';

										echo '</tr>';
									}
								} else {
									echo '<tr><td colspan="5">No requests found</td></tr>';
								}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
			   </div>
            </div>
        </section>
		<?php include('scripts.php');?>
		<script>
			function process_payout(request_id) {
				var r = confirm("Are you sure?");
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=payout&request_id="+request_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$('#req'+request_id).html('<a style="color: #4caf50">Completed</a>');
							}
						}
					});
				} 
			}
			
			function process_cancel_request() {
				var request_id = $(this).attr('reqid');
				var request_act = $(this).attr('request_act');
				var r = confirm("Are you sure?");
				if (r == true) {
					$.ajax({
						url: "<?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=cancel_request&request_id="+request_id+"&request_act="+request_act,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
			
			function process_payout2() {
				var r = confirm("Are you sure?");
				if (r == true) {
					var reqs = [];
					
					$('input.request_payment:checkbox:checked').each(function () {
						var req_id = $(this).val();
						reqs.push(req_id);
					});
					
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=payout2&reqs="+reqs,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									//window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
			
			function process_check_transaction(request_id) {
				$.ajax({
					url: "<?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=check_processing_request&request_id="+request_id,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							$('#req'+request_id).html('<a style="color: #4caf50">Completed</a>');
						}
					}
				});
			}
			
			function process_edit_txid(request_id, txid) {
				var get_txid = prompt("Please enter txid", txid);
				$.ajax({
					url: "<?=base_url()?>adm/process.php",
					type: "POST",
					data: "action=edit_txid&request_id="+request_id+"&txid="+get_txid,
					error: function(){
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
							setTimeout(function() {
								window.location.reload();
							}, 500);
						}
					}
				});
			}
			
			function enable_auto_payout2() {
				var r = confirm("Enabled auto payout!");
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=enable_auto_payout2",
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
			
			function disable_auto_payout2() {
				var r = confirm("Disable auto payout!");
				if (r == true) {
					$.ajax({
						url: " <?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=disable_auto_payout2",
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								setTimeout(function() {
									window.location.reload();
								}, 500);
							}
						}
					});
				}
			}
			
			function process_repay(request_id) {
				//var request_id = $(this).attr('reqid');
				var r = confirm("Are you sure?");
				if (r == true) {
					$.ajax({
						url: "<?=base_url()?>adm/process.php",
						type: "POST",
						data: "action=repay&request_id="+request_id,
						error: function(){
							console.log("Request timed out. Please try again!");
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
							} else {
								$.toast({
									heading: 'Success!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'success'
								});
								/*setTimeout(function() {
									window.location.reload();
								}, 500);*/
								$('#req'+request_id).html('<a style="color: #4caf50">Repaid</a>');
							}
						}
					});
				}
			}
			
			$(document).ready(function() {
				$('.process_cancel_request').on('click', process_cancel_request);
			});
		</script>
	</body>
</html>