<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
	  #preview {
		margin-top: 10px;
		height: 65px;
		overflow-x: auto;
		white-space: nowrap;
		border: 1px solid #DDD;
		padding: 6px;
		border-radius: 5px;
	  }

	  #preview img {
		height: 50px;
		margin-right: 8px;
		border-radius: 6px;
		object-fit: cover;
		float: left;
	  }
	  #noImage {
		  color: #888;
		  font-style: italic;
		  white-space: nowrap;
		  margin-top: 15px;
		}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="margin-bottom: 100px; padding-top:120px;">
            <div class="container">
               	<div class="single_title_n">
               		<h2><?=$langs['contact_page_heading']?></h2>
               		<p><?=$langs['contact_page_desc']?></p>
					<section style="max-width: 700px; margin: 20px auto;"> 
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px"> 
							<span class="input-group-addon" style="border-radius: 0px; padding: 14px 15px"><i class="fas fa-envelope"></i></span>
							<?php if($user_info != ''):?>
							<input id="email" name="email" type="text" class="form-control" placeholder="<?=$langs['your_email']?>" value="<?=$user_info->user_email?>" readonly="readonly" style="height: 45px;">
							<?php else:?>
							<input id="email" name="email" type="text" class="form-control" placeholder="<?=$langs['your_email']?>" value="" style="height: 45px;">
							<?php endif?>
						</div>
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px"> 
							<span class="input-group-addon" style="border-radius: 0px; padding: 14px 15px"><i class="fas fa-heading"></i></span> 
							<input id="subject" name="subject" type="text" class="form-control" placeholder="<?=$langs['mail_subject']?>" style="height: 45px;"> 
						</div> 
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px"> 
							<span class="input-group-addon" style="border-radius: 0px; padding: 14px 15px"><i class="fas fa-pen-alt"></i></span> 
							<textarea id="message" name="message" type="text" class="form-control" style="height: 200px; resize: none;"></textarea> 
						</div>
						
						<!-- upload images -->
						<div style="width: 100%; text-align: left; margin-top: 10px"><a id="uploadBtn" href="javascript: void(0)"><i class="fas fa-paperclip"></i> <?=$langs['attach_images']?></a></div>
						<input type="file" id="imageInput" style="display: none" accept="image/*" multiple>
						<div id="preview">
							 <div id="noImage">No image uploaded.</div>
						</div>
						<!-- upload images -->
						
						<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 800px; font-size: 14px">
							<button id="process_send_message" class="process_btn" type="submit" onclick="process_send_message()" style="width: 300px"><?=$langs['send_message_btn']?></button>
						</div> 
					</section>
				</div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			function process_send_message() {
				$("#process_send_message").attr("disabled", !0);
				var btn_label = $("#process_send_message").text();
				$("#process_send_message").text("<?=$langs['please_wait_btn']?>");
				var email = $('#email').val();
				var subject = $('#subject').val();
				var message = $('#message').val();
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=send_message&email="+email+ "&subject="+subject+ "&message="+message,
					error: function(){
						$("#process_send_message").attr("disabled", false);
						$("#process_send_message").text(btn_label);
						console.log("Request timed out. Please try again!");
					},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
						} else {
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
						$("#process_send_message").attr("disabled", false);
						$("#process_send_message").text(btn_label);
					}
				});
			}
		</script>
		
		<script>
			const uploadBtn = document.getElementById("uploadBtn");
			const imageInput = document.getElementById("imageInput");
			const cloudName = "dhu220mvv";
			const uploadPreset = "dogepick";
			const textarea = document.getElementById("message");	
			const preview = document.getElementById("preview");
				
			uploadBtn.addEventListener("click", () => {
				imageInput.click();
			});

			document.getElementById("imageInput").addEventListener("change", async (e) => {
				const files = e.target.files;
				for (let file of files) {
					const formData = new FormData();
					formData.append("file", file);
					formData.append("upload_preset", uploadPreset);

					const res = await fetch(`https://api.cloudinary.com/v1_1/${cloudName}/image/upload`, {
						method: "POST",
						body: formData
					});

					const data = await res.json();
					if (data.secure_url) {
						textarea.value += `${data.secure_url}\n`;
						updatePreview();
						
					} else {
						alert("Upload failed");
					}
				}
			});
			
			
			function updatePreview() {
			  const content = textarea.value;
			  const urls = [];

			  const imgTagRegex = /<img\s[^>]*src=["']([^"']+)["']/gi;
			  let match;
			  while ((match = imgTagRegex.exec(content)) !== null) {
				urls.push(match[1]);
			  }

			  const urlRegex = /(https?:\/\/[^\s]+(\.jpg|\.png|\.webp|\.jpeg|\.gif))/gi;
			  let urlMatch;
			  while ((urlMatch = urlRegex.exec(content)) !== null) {
				if (!urls.includes(urlMatch[1])) urls.push(urlMatch[1]);
			  }

			  if (urls.length === 0) {
				preview.style.display = "block";
				preview.innerHTML = '<div id="noImage">No image uploaded.</div>';
				return;
			  }

			  preview.style.display = "block";
			  preview.innerHTML = "";
			  urls.forEach(url => {
				const img = document.createElement("img");
				img.src = url;
				preview.appendChild(img);
			  });
			}
			textarea.addEventListener("input", updatePreview);
			updatePreview();
		</script>
		
	</body>
</html>