<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
		@media only screen and (min-width: 600px) {
			#deposit_address , #deposit_address_on_bsc {
				height: 45px;
				line-height: 23px;
				overflow: hidden;
			}
		}
		.dark_mode .form-wrapper__main {
			background: #213743 !important;
			border: none;
			box-shadow: 0 8px 17px 2px rgba(0,0,0,.14), 0 3px 14px 2px rgba(0,0,0,.12), 0 5px 5px -3px rgba(0,0,0,.2);
			border-radius: 2px;
		}
		.dark_mode .form__input#network {
			background: #0f212e !important;
		}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['deposit_page_heading']?></h2>
					<div class="form-wrapper" style="margin-top: 50px">
						<div class="form-wrapper__inner">
							<div class="form-wrapper__main" style="width: 100%; max-width: 600px">
								<p><?=$langs['deposit_guide']?></p>
								<div style="margin-top: 20px">
									<div class="form__input-wrapper">
										<div style="margin: 0px auto; max-width: 500px; text-align: left"><label class="form__label"><?=$langs['select_network_label']?></label></div>
										<div class="form__input-container">
											<select class="form__input" type="text" id="network" name="network" style="padding:5px 15px; max-width: 500px" disabled="disabled">
												<option value="Dogecoin">Dogecoin</option>
											</select>
										</div>
									</div>
									
									<div class="input-group" style="margin: 20px auto 0px; height: 45px; max-width: 500px; font-size: 14px">
										<span class="input-group-addon" style="border-radius: 0px;  padding: 14px 13.5px" onclick="copy_address()"><i class="fas fa-copy"></i></span>
										<input id="deposit_address" type="text" class="form-control" readonly="readonly" name="deposit_address" placeholder="Address" onclick="copy_address()" style="height: 45px; background: #FFF; font-size: 13px" value="<?=($deposit_address != '') ? $deposit_address : 'Could not get the deposit address!'?>">
									</div>
									<div class="input-group-address-note alert alert-info text-left no-margin-bottom" style="margin: 0px auto 0px; max-width: 500px; border-radius: 0px; font-size: 13px; background-color: #337ab747; border-color: #337ab747;">
										<div>
											<span><?=$langs['deposit_note']?></span>
										</div>
									</div>
								</div>
								<?php if($deposit_address != '' && $deposit_address != 'temporarily unavailable'):?>
								<div id="deposit_qrcode" style="width:200px; height:200px; border: 5px solid #FFF; margin: 30px auto 0px"></div>
								<p><i style="font-size: 15px"><?=$langs['deposit_qr_code']?></i></p>
								<p><?=$langs['deposit_manual_credit']?></p>
								<?php endif?>	
							</div>
						</div>
					</div>			
					<div style="width: 100%; overflow-x: auto; margin-top: 30px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['trans_tbl_amount']?></td>
									<td><?=$langs['trans_tbl_address']?> / TxID</td> <!-- Merge Address + TxID -->
									<td><?=$langs['trans_tbl_status']?></td>
								</tr>
							</thead>
							<tbody>
								<?php if(isset($user_transactions) && $user_transactions != null): ?>
									<?php foreach($user_transactions as $row): ?>
										<tr>
											<!-- Amount + USD -->
											<td>
												<?php
													$amount = $row->amount / 100000000;
													echo (floor($amount) == $amount) ? intval($amount) : rtrim(rtrim(number_format($amount, 8, '.', ''), '0'), '.');
												?>
												DOGE
												<br/>
												<span style="color: #00bcd4">
													$<?=number_format(floatval($row->USD_value), 2, '.', '')?>
												</span>
											</td>

											<!-- Address + TxID -->
											<td>
												<a href="https://dogechain.info/address/<?=$row->address?>">
													<?=substr($row->address, 0, 6).'...'.substr($row->address, -6)?>
												</a>
												<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->address?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>
												<?php if(!empty($row->txid)): ?>
													<br/>
													<?php if(strlen($row->txid) > 30): ?>
														<a href="https://dogechain.info/tx/<?=$row->txid?>" style="color: #4caf50">
															<?=substr($row->txid, 0, 6).'...'.substr($row->txid, -6)?>
														</a>
													<?php else: ?>
														<a href="javascript:void(0)" style="color: #777">
															<?=$row->txid?>
														</a>
													<?php endif; ?>
													<i class="far fa-copy fa-fw js_clipboard" data-copy="<?=$row->txid?>" style="color: #adb5bd; cursor: pointer" data-toggle="tooltip" title="Copy"></i>
												<?php endif; ?>
											</td>

											<!-- Status + Date -->
											<td>
												<?php
													if($row->status == 'Completed') {
														echo '<a href="javascript:void(0)" style="color: #4caf50">'.$langs['trans_stt_completed'].'</a>';
													} else if($row->status == 'Processing') {
														echo '<a href="javascript:void(0)" style="color: #03A9F4" title="'.$langs['trans_stt_processing_desc'].'">'.$langs['trans_stt_processing'].'</a>';
													} else {
														echo htmlspecialchars($row->status);
													}
												?>
												<br/>
												<?php
													if(date('Y-m-d', $row->time) == date('Y-m-d')) {
														$row->time =  date('H:i:s A', $row->time);
													} else {
														$row->time =  date('Y-m-d', $row->time);
													}
													echo $row->time;
												?>
											</td>
										</tr>
									<?php endforeach; ?>
								<?php else: ?>
									<tr><td colspan="3"><?=$langs['no_trans_found']?></td></tr>
								<?php endif; ?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
						
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			var qrcode = new QRCode("deposit_qrcode", {
				text:"<?=$deposit_address?>",
				width:200,
				height:200,
				colorDark:"#000000",
				colorLight:"#ffffff",
				correctLevel:QRCode.CorrectLevel.H
			});
			function copy_address() {
				var copyText = document.getElementById("deposit_address");
				copyText.select();
				copyText.setSelectionRange(0, 99999);
				document.execCommand("copy");
				$.toast({
					heading: 'Succees!',
					text: 'Dogecoin address copied',
					showHideTransition: 'slide',
					position: 'top-right',
					icon: 'success'
				});
			}
			
			function process_complete_confirmed_request() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=complete_confirmed_request",
					error: function(){},
					success: function(out){
						obj = JSON.parse(out);
						if(obj.ret == 1) {
							$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
							$.toast({
								heading: 'Success!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'success'
							});
						}
					}
				});
			}
			
			$(document).ready(function() {
				process_complete_confirmed_request();
			});
			
		</script>

	</body>
</html>