<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<style>
		.game_result_wrap {
			font-size: 0.875rem;
			border-radius: 10px;
			text-align: center;
			position: absolute;
			width: 150px;
			height: 85px;
			left: calc(50% - 75px);
			top: calc(50% - 37.5px);
			border: 4px solid;
			box-shadow: 0 10px 15px -3px rgba(0, 0, 0, .2), 0 4px 6px -2px rgba(0, 0, 0, .1);
			z-index: 2;
			display: none;
			border-color: #00e701;
			background-image: url(<?=base_url()?>assets/img/games/3440162.png) !important;
			background-repeat: repeat;
		}
		.game_result_wrap.lose {
			border-color: #557086;
			color: #EFEFEF;
		}
		.game_result_wrap.draw {
			border-color: #ff9d00;
			color: #ff9d00;
		}
		.game_result_wrap.win {
			border-color: #00e701;
			color: #00e701;
		}
		.game_result_wrap .multiplier {
			font-size: 25px;
			font-weight: 600;
			width: 100%;
			margin-top: 5px;
		}
		.game_result_wrap .win_amount {
			font-size: 14px;
			line-height: 35px;
			font-weight: 600;
		}
		</style>
	
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_high_low']?></h2>
					<div class="game_main hilow_game_container">
						<div class="col-xs-12">
							<div class="hilow_board">
							
							
								<div class="hilow_rules">
									<h3>K</h3>
									<h3><i class="fas fa-arrow-to-top"></i></h3>
									<p><?=$langs['king_being_the_highest']?></p>
								</div>
								<div class="hilow_deck">
									<div class="hilow_card"><div class="hilow_card_inner flipped" style="border: none !important"><div class="front"></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>
									<div class="hilow_card" style="margin-top:-153px"><div class="hilow_card_inner flipped" style="border: none !important"><div class="front"></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>
									<div class="hilow_card" style="margin-top:-153px"><div class="hilow_card_inner flipped" style="border: none !important"><div class="front"></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>
								</div>
								<div class="hilow_rules">
									<h3>A</h3>
									<h3><i class="fas fa-arrow-to-bottom"></i></i></h3>
									<p><?=$langs['ace_being_the_lowest']?></p>
								</div>
								<div class="game_result_wrap">
									<div class="multiplier"></div>
									<div class="win_amount"></div>
								</div>
								
							</div>
							
						
							
							<div class="hilow_card_list">
								<div class="hilow_slider">
								</div>
							</div>

							<div class="col-12" style="text-align: center; display: flex; margin-top: 5px">
								<button class="hilow_bet_high_btn" style="height: auto; border-radius: 5px"><span></span></button>
								<button class="hilow_bet_low_btn" style="height: auto; border-radius: 5px"><span></span></button>
							</div>

							<div class="input_container">
								<div class="row">
									<div class="col-xs-12 col-sm-6 bet_amount">
										<div class="input_label"><?=$langs['bet_ammount_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px">
											<input type="text" id="bet_amount" value="<?php if($bet_amount != 0) echo number_format($bet_amount / 100000000, 8); else echo $MIN_BET_AMOUNT;?>">
										</div>
										<span id="bet_double">2X</span>
										<span id="bet_half">1/2</span>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="input_label" id="total_profit_label"><?=$langs['total_profit_label']?></div>
										<div class="input_group"><img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px"><input readonly="readonly" type="text" id="total_profit" value="0.00000001"></div>
									</div>
									<div class="col-xs-6">
										<div class="input_label" id="profit_higher_label"><?=$langs['profit_higher_label']?></div>
										<div class="input_group"><img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px"><input readonly="readonly" type="text" id="profit_higher" value="0.00000001"></div>
									</div>
									<div class="col-xs-6">
										<div class="input_label" id="profit_lower_label"><?=$langs['profit_lower_label']?></div>
										<div class="input_group"><img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px"><input readonly="readonly" type="text" id="profit_lower" value="0.00000001"></div>
									</div>
								</div>
							</div>
							
							<div class="col-12" style="text-align: center;">
								<button id="bet_game_hilow"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['bet_btn']?></span></button>
								<button id="cashout_game_hilow"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['game_cashout_btn']?></span></button>

							</div>

						</div>
						<div style="clear: both"></div>
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Hilow')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Hilow')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
				</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
		
			var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
			const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
			const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
			const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
			const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
			const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
			const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
			
			var my_bet_data = [];
			var g_cards = <?=$cards?>;
			var g_selections = <?=$selections?>;
			var g_total_profit = <?=$total_profit?>;
			var g_started_game = <?=$started_game?>;
			var g_card_animation = 0;
			var MAGIC_NUMBER = 97;
			
			function card_value_2_number(card_value) {
				var number = Math.floor(card_value / 4) + 2;
				if(number == 14) {
					number = 1;
				}
				return number;
			}
			
			function card_value_2_rank(card_value) {
				var rank = '';
				if(Math.floor(card_value / 4) < 9) {
					rank = Math.floor(card_value / 4) + 2;
				} else if (Math.floor(card_value / 4) == 9) {
					rank = 'J';
				} else if (Math.floor(card_value / 4) == 10) {
					rank = 'Q';
				} else if (Math.floor(card_value / 4) == 11) {
					rank = 'K';
				} else {
					rank = 'A';
				}
				return rank;
			}

			function card_value_2_suit(card_value) {
				suit = '';
				if(card_value % 4 == 0) {
					suit = 'diamond';
				} else if(card_value % 4 == 1) {
					suit = 'heart';
				} else if(card_value % 4 == 2) {
					suit = 'club';
				} else if(card_value % 4 == 3) {
					suit = 'spade';
				}
				return suit;
			}

			function setup_hilow_cards() {
				$('.hilow_slider').html('');

				for(i = 0; i < g_cards.length - 1; i++) {
					var opacity = 0;
					if(i < g_cards.length - 2 || !g_card_animation) {
						opacity = 1;
					} else {
						opacity = 0;
					}
					$('.hilow_slider').append('<div class="hilow_small_card" id="hilow_small_card_'+(i+1)+'"><div class="hilow_small_card_inner '+card_value_2_suit(g_cards[i])+'"><div class="front"><p class="card_number">'+card_value_2_rank(g_cards[i])+'</p><p class="card_symbol"><i class="fas fa-'+card_value_2_suit(g_cards[i])+'"></i></p></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>');
					// selections: lower(1) | lower or equal(2) | equal(3) | higher or equal(4) | higher(5)
					if(g_selections[i] == 1) {
						if(card_value_2_number(g_cards[i+1]) < card_value_2_number(g_cards[i])) {
							$('.hilow_slider').append('<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-down"></i></div>');
						} else {
							$('.hilow_slider').append('<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-down"></i></div>');
						}
					} else if(g_selections[i] == 2){
						if(card_value_2_number(g_cards[i+1]) <= card_value_2_number(g_cards[i])) {
							$('.hilow_slider').append('<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-double-down"></i></div>');
						} else {
							$('.hilow_slider').append('<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-double-down"></i></div>');
						}
					} else if(g_selections[i] == 3){
						if(card_value_2_number(g_cards[i+1]) == card_value_2_number(g_cards[i])) {
							$('.hilow_slider').append('<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-equals"></i></div>');
						} else {
							$('.hilow_slider').append('<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-equals"></i></div>');
						}
					} else if(g_selections[i] == 4){
						if(card_value_2_number(g_cards[i+1]) >= card_value_2_number(g_cards[i])) {
							$('.hilow_slider').append('<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-double-up"></i></div>');
						} else {
							$('.hilow_slider').append('<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-double-up"></i></div>');
						}
					} else if(g_selections[i] == 5){
						if(card_value_2_number(g_cards[i+1]) > card_value_2_number(g_cards[i])) {
							$('.hilow_slider').append('<div class="comparison true" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-up"></i></div>');
						} else {
							$('.hilow_slider').append('<div class="comparison false" id="hilow_comparison_'+(i+1)+'" style="opacity: '+opacity+'"><i class="fas fa-angle-up"></i></div>');
						}
					}
				}
				$('#hilow_current_card').remove();
				if(g_card_animation) {
					$('.hilow_deck').append('<div class="hilow_card" id="hilow_current_card" style="margin-top:-150px"><div class="hilow_card_inner '+card_value_2_suit(g_cards[g_cards.length-1])+' flipped" style="border: none !important"><div class="front"><p class="card_number">'+card_value_2_rank(g_cards[g_cards.length-1])+'</p><p class="card_symbol"><i class="fas fa-'+card_value_2_suit(g_cards[g_cards.length-1])+'"></i></p></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>');
					$('.hilow_slider').append('<div class="hilow_small_card" id="hilow_small_card_'+g_cards.length+'"><div class="hilow_small_card_inner '+card_value_2_suit(g_cards[g_cards.length-1])+' flipped"><div class="front"><p class="card_number">'+card_value_2_rank(g_cards[g_cards.length-1])+'</p><p class="card_symbol"><i class="fas fa-'+card_value_2_suit(g_cards[g_cards.length-1])+'"></i></p></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>');
				} else {
					$('.hilow_deck').append('<div class="hilow_card" id="hilow_current_card" style="margin-top:-150px"><div class="hilow_card_inner '+card_value_2_suit(g_cards[g_cards.length-1])+'" style="border: none !important"><div class="front"><p class="card_number">'+card_value_2_rank(g_cards[g_cards.length-1])+'</p><p class="card_symbol"><i class="fas fa-'+card_value_2_suit(g_cards[g_cards.length-1])+'"></i></p></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>');
					$('.hilow_slider').append('<div class="hilow_small_card" id="hilow_small_card_'+g_cards.length+'"><div class="hilow_small_card_inner '+card_value_2_suit(g_cards[g_cards.length-1])+'"><div class="front"><p class="card_number">'+card_value_2_rank(g_cards[g_cards.length-1])+'</p><p class="card_symbol"><i class="fas fa-'+card_value_2_suit(g_cards[g_cards.length-1])+'"></i></p></div><div class="back"><div></div><div></div><div></div><div></div><i class="fas fa-question-circle"></i></div></div></div>');
				}
				

				setTimeout(function(){
					$('.hilow_slider #hilow_comparison_'+(g_cards.length-1)).css('opacity', '1');
				}, 10);
				$(".hilow_card_list").scrollLeft(100000);
				
				calculate_win_rate();
				calculate_profit();
				if(g_started_game) {
					$('.hilow_bet_high_btn').attr("disabled", false);
					$('.hilow_bet_low_btn').attr("disabled", false);
					$('#bet_game_hilow').hide();
					$('#cashout_game_hilow').show();
					if(g_cards.length == 1) {
						$('#cashout_game_hilow').attr("disabled", true);
					} else {
						$('#cashout_game_hilow').attr("disabled", false);
					}
					$('#bet_amount').prop('disabled', true);
					$('#total_profit').prop('disabled', true);
					$('#profit_higher').prop('disabled', true);
					$('#profit_lower').prop('disabled', true);
					$('#bet_amount').parent().addClass('disabled');
					$('#total_profit').parent().addClass('disabled');
					$('#profit_higher').parent().addClass('disabled');
					$('#profit_lower').parent().addClass('disabled');
				} else {
					$('.hilow_bet_high_btn').attr("disabled", true);
					$('.hilow_bet_low_btn').attr("disabled", true);
					$('#bet_game_hilow').show();
					$('#bet_game_hilow').prop('disabled', false);
					$('#cashout_game_hilow').hide();
					$('#bet_amount').prop('disabled', false);
					$('#total_profit').prop('disabled', false);
					$('#profit_higher').prop('disabled', false);
					$('#profit_lower').prop('disabled', false);
					$('#bet_amount').parent().removeClass('disabled');
					$('#total_profit').parent().removeClass('disabled');
					$('#profit_higher').parent().removeClass('disabled');
					$('#profit_lower').parent().removeClass('disabled');
				}
				if(g_card_animation) {
					setTimeout(function(){
						$('#hilow_small_card_'+g_cards.length+' .hilow_small_card_inner').removeClass('flipped');
						$('#hilow_current_card .hilow_card_inner').removeClass('flipped');
					}, 200);
				}
			}
			
			function calculate_win_rate() {
				var current_number = card_value_2_number(g_cards[g_cards.length-1]);
				if(current_number == 1) {
					equal_rate = parseFloat(Math.round(parseFloat(1 / 13) * 10000) / 100).toFixed(2);
					higher_rate = parseFloat(Math.round(parseFloat(12 / 13) * 10000) / 100).toFixed(2);
					$('.hilow_bet_high_btn span').html('<?=$langs['higher_label']?> <i class="fas fa-angle-up"></i><br/>'+higher_rate+'%');
					$('.hilow_bet_low_btn span').html('<?=$langs['equal_label']?> <i class="fas fa-equals"></i><br/>'+equal_rate+'%');
				} else if(current_number == 13) {
					equal_rate = parseFloat(Math.round(parseFloat(1 / 13) * 10000) / 100).toFixed(2);
					lower_rate = parseFloat(Math.round(parseFloat(12 / 13) * 10000) / 100).toFixed(2);
					$('.hilow_bet_high_btn span').html('<?=$langs['equal_label']?>  <i class="fas fa-equals"></i><br/>'+equal_rate+'%');
					$('.hilow_bet_low_btn span').html('<?=$langs['lower_label']?> <i class="fas fa-angle-down"></i><br/>'+lower_rate+'%');
				} else {
					higher_or_equal_rate = parseFloat(Math.round(parseFloat((13 - current_number + 1) / 13) * 10000) / 100).toFixed(2);
					lower_or_equal_rate = parseFloat(Math.round(parseFloat((current_number - 1 + 1) / 13) * 10000) / 100).toFixed(2);
					$('.hilow_bet_high_btn span').html('<?=$langs['higher_or_equal_label']?> <i class="fas fa-angle-double-up"></i><br/>'+higher_or_equal_rate+'%');
					$('.hilow_bet_low_btn span').html('<?=$langs['lower_or_equal_label']?> <i class="fas fa-angle-double-down"></i><br/>'+lower_or_equal_rate+'%');
				}
			}

			function calculate_profit() {
				var current_number = card_value_2_number(g_cards[g_cards.length-1]);
				var bet_amount = parseFloat($('#bet_amount').val());
				if(current_number == 1) {
					profit_higher = parseFloat(g_total_profit *  Math.round(parseFloat(13 / 12) * MAGIC_NUMBER) / 100).toFixed(2);
					profit_lower = parseFloat(g_total_profit *  Math.round(parseFloat(13 / 1) * MAGIC_NUMBER) / 100).toFixed(2);
				} else if(current_number == 13) {
					profit_higher = parseFloat(g_total_profit * Math.round(parseFloat(13 / 1) * MAGIC_NUMBER) / 100).toFixed(2);
					profit_lower = parseFloat(g_total_profit * Math.round(parseFloat(13 / 12) * MAGIC_NUMBER) / 100).toFixed(2);
				} else {
					profit_higher = parseFloat(g_total_profit * Math.round(parseFloat(13 / (13 - current_number + 1)) * MAGIC_NUMBER) / 100).toFixed(2);
					profit_lower = parseFloat(g_total_profit * Math.round(parseFloat(13 / (current_number - 1 + 1)) * MAGIC_NUMBER) / 100).toFixed(2);
				}
				$('#profit_higher_label').html('<?=$langs['profit_higher_label']?> ('+profit_higher+'x)');
				$('#profit_lower_label').html('<?=$langs['profit_lower_label']?> ('+profit_lower+'x)');
				$('#total_profit_label').html('<?=$langs['total_profit_label']?> ('+parseFloat(Math.round(g_total_profit * 100) / 100).toFixed(2)+'x)');
				$('#total_profit').val(parseFloat(g_total_profit * bet_amount).toFixed(8));
				$('#profit_higher').val(parseFloat(profit_higher * bet_amount).toFixed(8));
				$('#profit_lower').val(parseFloat(profit_lower * bet_amount).toFixed(8));
			}
			
			function open_new_card(bet_on) {
				$(".hilow_bet_low_btn").attr("disabled", true);
				$(".hilow_bet_high_btn").attr("disabled", true);
				
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=open_card_game_hilow&bet_on="+bet_on,
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timed out. Please try again!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});	
						$(".hilow_bet_low_btn").attr("disabled", false);
						$(".hilow_bet_high_btn").attr("disabled", false);
					},
					success: function(out){
						let obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$(".hilow_bet_low_btn").attr("disabled", false);
							$(".hilow_bet_high_btn").attr("disabled", false);
						} else {
							g_cards = obj.cards;
							g_selections = obj.selections;
							g_total_profit = obj.total_profit;
							if(bet_on == 1) {
								$('#hilow_current_card').css({'transform': 'translate(300px, -200px) rotate(-45deg)', 'transition-duration' : '0.7s'});
							} else if(bet_on == 2){
								$('#hilow_current_card').css({'transform': 'translate(-300px, -200px) rotate(-45deg)', 'transition-duration' : '0.7s'});
							}
							
							setTimeout(function(){
								if(obj.bet_result != 0) {
									g_card_animation = 1;
									setup_hilow_cards();
								} else {
									g_started_game = 0;
									g_card_animation = 1;
									setup_hilow_cards();
									$(".hilow_bet_low_btn").attr("disabled", true);
									$(".hilow_bet_high_btn").attr("disabled", true);
									setTimeout(function(){
										$('.game_result_wrap').show();
										if(obj.profit > 0) {
											$('.game_result_wrap').removeClass('lose');
											$('.game_result_wrap').addClass('win');
											$('.game_result_wrap .multiplier').text(obj.multiplier);
											$('.game_result_wrap .win_amount').html(((obj.profit) / 100000000).toFixed(8));
											
										} else {
											$('.game_result_wrap').removeClass('win');
											$('.game_result_wrap').addClass('lose');
											$('.game_result_wrap .multiplier').text(obj.multiplier);
											$('.game_result_wrap .win_amount').html(((obj.profit) / 100000000).toFixed(8));
										}
										
										$('.user_balance').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8));
										user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
										if(Array.isArray(my_bet_data)) {
											my_bet_data.unshift(obj.bet_data);
										} else {
											my_bet_data = [obj.bet_data];
										}
										if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
											my_bet_data = my_bet_data.slice(0, 20);
										}
										store_bet_data(my_bet_data);
										show_my_bet_data(my_bet_data);
									}, 700);
								}
							}, 700);
						}
					}
				});

			}

			function process_bet_game_hilow() {
				var bet_amount = parseFloat($('#bet_amount').val());
				$("#bet_game_hilow").attr("disabled", true);
				$('#bet_game_hilow span').hide();
				$('#bet_game_hilow img').show();
				$('.game_result_wrap').hide();
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_hilow&bet_amount="+bet_amount+"&start_card="+g_cards[g_cards.length-1],
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});	
							$("#bet_game_hilow").attr("disabled", false);
							$('#bet_game_hilow img').hide();
							$('#bet_game_hilow span').show();
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								$("#bet_game_hilow").attr("disabled", false);
								$('#bet_game_hilow img').hide();
								$('#bet_game_hilow span').show();
							} else {
								$("#bet_game_hilow").attr("disabled", false);
								$('#bet_game_hilow img').hide();
								$('#bet_game_hilow span').show();
								$('.user_balance').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								g_cards = [g_cards[g_cards.length-1]];
								g_selections = [];
								g_total_profit = 1;
								g_started_game = 1;
								g_card_animation = 0;
								setup_hilow_cards();
							}
						}
					});
				}, 100);
			}
			
			function process_cashout_game_hilow() {
				$("#cashout_game_hilow").attr("disabled", true);
				$('#cashout_game_hilow span').hide();
				$('#cashout_game_hilow img').show();
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=cashout_game_hilow",
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});	
							$("#cashout_game_hilow").attr("disabled", false);
							$('#cashout_game_hilow img').hide();
							$('#cashout_game_hilow span').show();
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								$("#cashout_game_hilow").attr("disabled", false);
								$('#cashout_game_hilow img').hide();
								$('#cashout_game_hilow span').show();
							} else {
								$('.user_balance').text(parseFloat(parseInt(obj.balance) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								$("#cashout_game_hilow").attr("disabled", false);
								$('#cashout_game_hilow img').hide();
								$('#cashout_game_hilow span').show();
								g_started_game = 0;
								g_card_animation = 0;
								setup_hilow_cards();
								
								setTimeout(function(){
									$('.game_result_wrap').show();
									if(obj.profit > 0) {
										$('.game_result_wrap').removeClass('lose');
										$('.game_result_wrap').addClass('win');
										$('.game_result_wrap .multiplier').text(obj.multiplier);
										$('.game_result_wrap .win_amount').html(((obj.profit) / 100000000).toFixed(8));
										
									} else {
										$('.game_result_wrap').removeClass('win');
										$('.game_result_wrap').addClass('lose');
										$('.game_result_wrap .multiplier').text(obj.multiplier);
										$('.game_result_wrap .win_amount').html(((obj.profit) / 100000000).toFixed(8));
									}
									
									
								}, 100);
								
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								
							}
						}
					});
				}, 100);
			}
			
			
			function set_bet_double_amount() {		
				if($('#bet_amount').prop("disabled")) {
					return;
				}			
				if($('#bet_btn').css('display') == 'none'){
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount *= 2;
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function set_bet_half_amount() {
				if($('#bet_amount').prop("disabled")) {
					return;
				}
				if($('#bet_btn').css('display') == 'none'){
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount /= 2;
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function change_bet_amount() {
				if($('#bet_btn').css('display') == 'none'){
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
					 $('#bet_amount').parent().css('border', '2px solid #f44336');
				} else {
					 $('#bet_amount').parent().css('border', '1px solid #DDD');
				}
				setTimeout(function() {
					$('#bet_amount').val(bet_amount.toFixed(8));
				}, 100);
			}
			
			$(document).ready(function() {
				g_card_animation = 0;
				setup_hilow_cards();
				$("#bet_double").on("click", set_bet_double_amount);
				$("#bet_half").on("click", set_bet_half_amount);
				$("#bet_amount").on("change", change_bet_amount);
				$('#show_my_bets').on('click', show_my_bets);
				$('#show_all_bets').on('click', show_all_bets);
				$("#bet_game_hilow").on("click", process_bet_game_hilow);
				$("#cashout_game_hilow").on("click", process_cashout_game_hilow);
				$(".hilow_bet_high_btn").on("click", function(){
					open_new_card(2);
				});
				$(".hilow_bet_low_btn").on("click", function(){
					open_new_card(1);
				});
				
				show_my_bets(my_bet_data);
				$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
				$('#show_all_bets').on('click', show_all_bets);
			});
			
		</script>
	</body>
</html>