<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
	#clear_game_data_btn {
	  margin: 10px;
	  float: right;
	  padding: 8px 16px;
	  background-color: #e74c3c;
	  color: white;
	  border: none;
	  border-radius: 4px;
	  cursor: pointer;
	}

	#clear_game_data_btn:hover {
	  background-color: #c0392b;
	}
</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu2.php');?>
			<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_history_page_heading']?></h2>
					<p><?=$langs['game_history_page_desc']?></p>
					<button id="clear_game_data_btn"><i class="fas fa-trash-alt"></i> <?=$langs['clear_history_btn']?></button>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
						
						
					<div class="pagination">
					  <a href="javascript: void(0)" id="pagination_prev" class="active" onclick="navigatePage(-1)">Prev</a>
					  <a href="javascript: void(0)" id="pagination_info" data-current-page="1">Page 1</a>
					  <a href="javascript: void(0)" id="pagination_next" class="active" onclick="navigatePage(1)">Next</a>
					</div>	
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
		
			var my_bet_data = [];
			
			function show_bet_info3(seed) {
				var bet_info = null;
				show_modal('<i class="fas fa-clipboard-list"></i> <?=$langs['bet_info']?>', '');
				if(localforage.getItem('my_bet_data_large') !== null) {
					localforage.getItem("my_bet_data_large").then(function (value) {
						my_bet_data = value;
						for(let i = 0; i < my_bet_data.length; i++) {
							bet_info = my_bet_data[i];
							if(bet_info.server_seed == seed) {
								show_bet_info_detail(bet_info);
								return;
							} else {
								bet_info = null;
							}
						}
						if (bet_info == null) {
							$.ajax({
								url: "<?=base_url()?>load.php",
								type: "POST",
								data: { data: "bet_info2", server_seed: seed },
								error: function () {
									console.log("<?=$langs['connection_timeout_err']?>");
								},
								success: function (out) {
									let obj = JSON.parse(out);
									if (obj.ret == 1) {
										 bet_info = obj.bet_info;
										show_bet_info_detail(bet_info);
										return;
									}
								}
							});
						}
					});
				}
			}

			function load_and_show_my_bet_data_paginated(page = 1, perPage = 20) {
				localforage.getItem('my_bet_data_large').then((bet_data) => {
					if (!Array.isArray(bet_data) || bet_data.length === 0) {
						$('#my_bets_table .bets_table tbody').html('<tr><td colspan="5">No bet history available.</td></tr>');
						$('#pagination_info').html('');
						return;
					}

					// Sort newest to oldest
					bet_data = bet_data.slice().reverse(); // Use slice() to avoid mutating original array

					const totalPages = Math.ceil(bet_data.length / perPage);
					page = Math.max(1, Math.min(page, totalPages)); // Keep page within bounds

					const startIndex = (page - 1) * perPage;
					const endIndex = Math.min(startIndex + perPage, bet_data.length);

					let html = '';
					for (let i = startIndex; i < endIndex; i++) {
						const bet = bet_data[i];
						let game_title = '';
						switch(bet.game_name) {
							case 'Dice':
							game_title = '<i class="fas fa-dice"></i> <?=$langs['game_dice']?>';
							break;
							case 'Ultimate':
							game_title = '<i class="fas fa-dice"></i> <?=$langs['game_ultimate']?>';
							break;
							case 'Gems':
							game_title = '<i class="fas fa-gem"></i> <?=$langs['game_gems']?>';
							break;
							case 'Slots':
							game_title = '<i class="fas fa-lemon"></i> <?=$langs['game_slots']?>';
							break;
							case 'Mines':
							game_title = '<i class="fas fa-bomb"></i> <?=$langs['game_mines']?>';
							break;
							case 'Keno':
							game_title = '<i class="fas fa-border-all"></i> <?=$langs['game_keno']?>';
							break;
							case 'Poker':
							game_title = '<i class="fas fa-spade"></i> <?=$langs['game_video_poker']?>';
							break;
							case 'Baccarat':
							game_title = '<i class="fas fa-club"></i> <?=$langs['game_baccarat']?>';
							break;
							case 'Hilow':
							game_title = '<i class="fas fa-sort-alt"></i> <?=$langs['game_high_low']?>';
							break;
							case 'Roulette':
							game_title = '<img src="<?=base_url()?>assets/img/games/roulette/roulette_icon.svg" style="width: 14px; height: 14px"> <?=$langs['game_roulette']?>';
							break;
							case 'Wheel':
							game_title = '<i class="fas fa-tire"></i> <?=$langs['game_wof']?>';
							break;
							case 'Plinko':
							game_title = '<i class="fas fa-ball-pile"></i> <?=$langs['game_plinko']?>';
							break;
							case 'Limbo':
							game_title = '<i class="fas fa-rocket-launch"></i> <?=$langs['game_limbo']?>';
							break;
							case 'Triple':
							game_title = '<i class="fas fa-dice"></i> <?=$langs['game_sicbo']?>';
							break;
						}
						html += '<tr>';
						html += '<td>' + convertTimestampToGMT0(bet.timestamp) + '</td>';
						html += '<td onclick="show_bet_info3(`' + bet.server_seed + '`)">' + game_title + '</td>';
						html += '<td>' + bet.bet_amount + '</td>';
						html += '<td>' + bet.payout + '</td>';
						html += '<td>' + bet.profit + '</td>';
						html += '</tr>';
					}

					$('#my_bets_table .bets_table tbody').html(html);
					$('#pagination_info').html(`${page} / ${totalPages}`);

					// Update navigation buttons
					$('#pagination_prev').prop('disabled', page <= 1);
					$('#pagination_next').prop('disabled', page >= totalPages);

					// Store current page
					$('#pagination_info').data('current-page', page);
				});
			}


			function navigatePage(direction) {
				const currentPage = parseInt($('#pagination_info').data('current-page')) || 1;
				const newPage = currentPage + direction;
				const url = new URL(window.location);

				url.searchParams.set('page', newPage);
				history.pushState(null, '', url.toString());

				load_and_show_my_bet_data_paginated(newPage);
			}
			
			$(document).ready(function() {
				const urlParams = new URLSearchParams(window.location.search);
				const pageFromUrl = parseInt(urlParams.get('page')) || 1;
				navigatePage(pageFromUrl - 1)
			});
			
			document.getElementById('clear_game_data_btn').addEventListener('click', function () {
			  if (confirm('Are you sure you want to delete all game history?')) {
				localforage.removeItem('my_bet_data_large').then(() => {
				  localforage.removeItem('my_bet_data').then(() => {
					$.toast({
						heading: 'Success!',
						text: 'Game history has been cleared.',
						showHideTransition: 'slide',
						position: 'top-right',
						icon: 'success'
					});
					$('#my_bets_table .bets_table tbody').html('<tr><td colspan="5">No bet history available.</td></tr>');
					$('#pagination_info').html('1/1');
				  });
				});
			  }
			});
			
		</script>
	</body>
</html>
