<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
		#start_auto_bet_btn, #stop_auto_bet_btn {
			display: none;
		}
	</style>
	<link href="<?=base_url()?>assets/css/limbo.css" rel="stylesheet">
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_limbo']?></h2>
					<div class="game_main row" style="width: 100%; max-width: 550px">
						<img id="imgball" src="<?=base_url()?>assets/img/games/plinko/ball.svg" width="0" height="0"/>
						<div class="col-xs-12">
							<div id="game_limbo_container">
								<div class="game_area">
									<div class="game_area_number"><span>1.00x</span></div>
									<div class="game_area_boom"></div>
									<div class="game_area_rocket">
										<div class="game_area_rocket_main game_area_rocket_shake">
											<div class="game_area_rocket_body"></div>
											<div class="game_area_rocket_tail"></div>
										</div>
									</div>
									<div class="meteor_shower" style="opacity: 0">
										<div class="meteor-1"></div>
										<div class="meteor-2"></div>
										<div class="meteor-3"></div>
										<div class="meteor-4"></div>
										<div class="meteor-5"></div>
										<div class="meteor-6"></div>
										<div class="meteor-7"></div>
										<div class="meteor-8"></div>
										<div class="meteor-9"></div>
										<div class="meteor-10"></div>
										<div class="meteor-11"></div>
										<div class="meteor-12"></div>
										<div class="meteor-13"></div>
										<div class="meteor-14"></div>
										<div class="meteor-15"></div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-3 auto_dice_box">
							<div class="checkbox icheck-info">
								<input type="checkbox" id="auto_bet">
								<label for="auto_bet"><?=$langs['switch_auto']?></label>
							</div>
						</div>
						<div class="col-xs-6">
							<button class="btn bet_btn" id="process_bet_game_limbo"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['bet_btn']?></span></button>
							<button class="btn bet_btn" id="start_auto_bet_btn"><span><?=$langs['game_start_auto_bet_btn']?></span></button>
							<button class="btn bet_btn" id="stop_auto_bet_btn"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['game_stop_auto_bet_btn']?></span></button>
						</div>
						<div class="col-xs-12">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-12 col-sm-12 bet_amount">
										<div class="input_label"><?=$langs['bet_ammount_label']?></div>
										<div class="input_group" style="height:44px"><img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:20px;height:20px;margin-top:9px"><input type="text" id="bet_amount" value="<?=$MIN_BET_AMOUNT?>"></div><span id="bet_double" onclick="set_bet_double_amount">2X</span><span id="bet_half"
											onclick="set_bet_half_amount">1/2</span>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="input_label"><?=$langs['target_multiplier_label']?></div>
										<div class="input_group"><input type="text" id="payout" value="2.00"><i class="fas fa-times addon"></i></div>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="input_label"><?=$langs['win_chance_label']?></div>
										<div class="input_group"><input type="text" id="win_chance" value="48.50"><i style="font-size:12px" class="fas fa-percent addon"></i></div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-xs-12 col-sm-6" id="on_win_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_win_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onwin" name="onwin" checked="checked">
								  <label for="reset_onwin"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onwin" name="onwin">
									  <label for="increase_onwin"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onwin_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6" id="on_loss_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_loss_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onloss" name="onloss" checked="checked">
								  <label for="reset_onloss"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onloss" name="onloss">
									  <label for="increase_onloss"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onloss_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="stop_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="stop_on_profit" value="0.00000000">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_loss_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="stop_on_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="total_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['number_rolls_label']?></div>
										<div class="input_group">
											<input type="text" id="number_rolls" value="0" readonly="readonly">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['total_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="profit_loss" value="0.00000000" readonly="readonly">
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Limbo')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Limbo')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
				</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
		var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
		const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
		const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
		const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
		const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
		const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
		const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
		
		const MAGIC_NUMBER = 9700;
		const MIN_PAYOUT = 1.01;
		const MAX_PAYOUT = MAGIC_NUMBER / 2;
		const MIN_WIN_CHANCE = (parseFloat(MAGIC_NUMBER / MAX_PAYOUT) / 100).toFixed(2);
		const MAX_WIN_CHANCE = (parseFloat(MAGIC_NUMBER / MIN_PAYOUT) / 100).toFixed(2);

		var auto_betting_status = 'stopped';
		var profit_loss = 0.00000000;
		var base_bet = 0.00000100;
		var bet_mode = 'manual';
		var my_bet_data = [];
		var prepare_for_stopping = false;
		
		function switch_bet_mode() {
			if(auto_betting_status == 'running') {
				return;
			}
			if(bet_mode == 'manual') {
				$('#on_win_box').show();
				$('#on_loss_box').show();
				$('#stop_profit_box').show();
				$('#total_profit_box').show();
				$('#start_auto_bet_btn').show();
				$('#process_bet_game_limbo').hide();
				bet_mode = 'auto';
			} else {
				$('#on_win_box').hide();
				$('#on_loss_box').hide();
				$('#stop_profit_box').hide();
				$('#total_profit_box').hide();
				$('#start_auto_bet_btn').hide();
				$('#process_bet_game_limbo').show();
				bet_mode = 'manual';
			}
		}
		
		function set_bet_double_amount() {
			if($('#bet_amount').prop("disabled")) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount *= 2;
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function set_bet_half_amount() {
			if($('#bet_amount').prop("disabled")) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount /= 2;
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function change_bet_amount() {
			var bet_amount = parseFloat($('#bet_amount').val());
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				 $('#bet_amount').parent().css('border', '2px solid #f44336');
			} else {
				 $('#bet_amount').parent().css('border', '1px solid #DDD');
			}
			setTimeout(function() {
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}, 100);
		}
		
		function change_payout() {
			var payout = parseFloat($('#payout').val());
			if(payout < MIN_PAYOUT || isNaN(payout)) {
				payout = MIN_PAYOUT;
			}
			if(payout > MAX_PAYOUT) {
				payout = MAX_PAYOUT;
			}
			payout = parseFloat(MAGIC_NUMBER / (10000 - Math.round(10000 - (MAGIC_NUMBER /  payout)))).toFixed(2);
			var win_chance = (Math.round(MAGIC_NUMBER / payout) / 100).toFixed(2);
			setTimeout(function() {
				$('#payout').val(payout);
				$('#win_chance').val(win_chance);
			}, 100);
		}

		function change_win_chance() {
			var win_chance = parseFloat($('#win_chance').val());
			if(win_chance < MIN_WIN_CHANCE || isNaN(win_chance)) {
				win_chance = MIN_WIN_CHANCE;
			}
			if(win_chance > MAX_WIN_CHANCE) {
				win_chance = MAX_WIN_CHANCE;
			}
			var payout = parseFloat(MAGIC_NUMBER / Math.round(win_chance * 100)).toFixed(2);
			var win_chance = (Math.round(MAGIC_NUMBER / payout) / 100).toFixed(2);
			setTimeout(function() {
				$('#payout').val(payout);
				$('#win_chance').val(win_chance);
			}, 100);
		}
		
		function change_on_win() {
			if($('#increase_onwin').is(':checked')) {
				$('#increase_onwin_by').prop('disabled', false);
				$('#increase_onwin_by').parent().removeClass('disabled');
			} else {
				$('#increase_onwin_by').prop('disabled', true);
				$('#increase_onwin_by').parent().addClass('disabled');
			}
		}

		function change_on_loss() {
			if($('#increase_onloss').is(':checked')) {
				$('#increase_onloss_by').prop('disabled', false);
				$('#increase_onloss_by').parent().removeClass('disabled');
			} else {
				$('#increase_onloss_by').prop('disabled', true);
				$('#increase_onloss_by').parent().addClass('disabled');
			}
		}
		
		function change_increase_onwin_by() {
			var increase_onwin_by = parseInt($('#increase_onwin_by').val());
			if(increase_onwin_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onwin_by)) {
				increase_onwin_by = MIN_BET_INCREASE_PERCENT;
			} else if(increase_onwin_by > MAX_BET_INCREASE_PERCENT) {
				increase_onwin_by = MAX_BET_INCREASE_PERCENT;
			}
			$('#increase_onwin_by').val(increase_onwin_by);
		}
		
		function change_increase_onloss_by() {
			var increase_onloss_by = parseInt($('#increase_onloss_by').val());
			if(increase_onloss_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onloss_by)) {
				increase_onloss_by = MIN_BET_INCREASE_PERCENT;
			} else if(increase_onloss_by > MAX_BET_INCREASE_PERCENT) {
				increase_onloss_by = MAX_BET_INCREASE_PERCENT;
			}
			$('#increase_onloss_by').val(increase_onloss_by);
		}

		function change_stop_on_profit() {
			var stop_on_profit = parseFloat($('#stop_on_profit').val());
			if(stop_on_profit < MIN_STOP_ON_PROFIT || isNaN(stop_on_profit)) {
				stop_on_profit = MIN_STOP_ON_PROFIT;
			} else if(stop_on_profit > MAX_STOP_ON_PROFIT) {
				stop_on_profit = MAX_STOP_ON_PROFIT;
			}
			$('#stop_on_profit').val(stop_on_profit.toFixed(8));
		}

		function change_stop_on_loss() {
			var stop_on_loss = parseFloat($('#stop_on_loss').val());
			if(stop_on_loss < MIN_STOP_ON_PROFIT || isNaN(stop_on_loss)) {
				stop_on_loss = MIN_STOP_ON_PROFIT;
			} else if(stop_on_loss > MAX_STOP_ON_PROFIT) {
				stop_on_loss = MAX_STOP_ON_PROFIT;
			}
			$('#stop_on_loss').val(stop_on_loss.toFixed(8));
		}
		
		function disable_all_inputs() {
			$('#auto_bet').prop('disabled', true);
			$('#bet_amount').prop('disabled', true);
			$('#bet_amount').parent().addClass('disabled');
			$('#payout').prop('disabled', true);
			$('#payout').parent().addClass('disabled');
			$('#win_chance').prop('disabled', true);
			$('#win_chance').parent().addClass('disabled');
			$('#reset_onwin').prop('disabled', true);
			$('#increase_onwin').prop('disabled', true);
			$('#increase_onwin_by').prop('disabled', true);
			$('#increase_onwin_by').parent().addClass('disabled');
			$('#reset_onloss').prop('disabled', true);
			$('#increase_onloss').prop('disabled', true);
			$('#increase_onloss_by').prop('disabled', true);
			$('#increase_onloss_by').parent().addClass('disabled');	
			$('#stop_on_profit').prop('disabled', true);
			$('#stop_on_profit').parent().addClass('disabled');
			$('#stop_on_loss').prop('disabled', true);
			$('#stop_on_loss').parent().addClass('disabled');
			$('#number_rolls').prop('disabled', true);
			$('#number_rolls').parent().addClass('disabled');
			$('#profit_loss').prop('disabled', true);
			$('#profit_loss').parent().addClass('disabled');
		}
		
		function enable_all_inputs() {
			$('#auto_bet').prop('disabled', false);
			$('#bet_amount').prop('disabled', false);
			$('#bet_amount').parent().removeClass('disabled');
			$('#payout').prop('disabled', false);
			$('#payout').parent().removeClass('disabled');
			$('#win_chance').prop('disabled', false);
			$('#win_chance').parent().removeClass('disabled');
			$('#reset_onwin').prop('disabled', false);
			$('#increase_onwin').prop('disabled', false);
			if($('#increase_onwin').is(':checked')) {
				$('#increase_onwin_by').prop('disabled', false);
				$('#increase_onwin_by').parent().removeClass('disabled');
			}
			$('#reset_onloss').prop('disabled', false);
			$('#increase_onloss').prop('disabled', false);
			if($('#increase_onloss').is(':checked')) {
				$('#increase_onloss_by').prop('disabled', false);
				$('#increase_onloss_by').parent().removeClass('disabled');
			} 
			$('#stop_on_profit').prop('disabled', false);
			$('#stop_on_profit').parent().removeClass('disabled');
			$('#stop_on_loss').prop('disabled', false);
			$('#stop_on_loss').parent().removeClass('disabled');
			$('#number_rolls').prop('disabled', false);
			$('#number_rolls').parent().removeClass('disabled');
			$('#profit_loss').prop('disabled', false);
			$('#profit_loss').parent().removeClass('disabled');
		}
 
		function process_bet_game_limbo(){
			if(bet_mode == 'auto'){
				if(auto_betting_status != 'running') {
					return;
				} else {
					var on_win = null;
					var increase_onwin_by = 0;
					var on_loss = null;
					var increase_onloss_by = 0;
					var stop_on_profit = 0;
					var stop_on_loss = 0;
					if($('#increase_onwin').is(':checked')) {
						on_win = 'increase_onwin';
						increase_onwin_by = parseInt($('#increase_onwin_by').val());
					} else {
						on_win = 'reset_onwin';
					}
					if($('#increase_onloss').is(':checked')) {
						on_loss = 'increase_onloss';
						increase_onloss_by = parseInt($('#increase_onloss_by').val());
					} else {
						on_loss = 'reset_onloss';
					}
					stop_on_profit = parseFloat($('#stop_on_profit').val());
					stop_on_loss = parseFloat($('#stop_on_loss').val());
					var number_rolls = parseInt($('#number_rolls').val());
					disable_all_inputs();
				}
			} else {
				disable_all_inputs();
			}
			
			var bet_amount = parseFloat($('#bet_amount').val());
			var payout = parseFloat($('#payout').val());
			$('.game_area_number span').css('color', '#ffffff');
			setTimeout(function() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=bet_game_limbo&bet_amount="+bet_amount+"&payout="+payout,
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timed out. Please try again!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
						if(bet_mode == 'auto'){
							stop_auto_bet();
						}
						enable_all_inputs();
					},
					success: function(out){
						let obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							if(bet_mode == 'auto'){
								stop_auto_bet();
							}
							enable_all_inputs();
						} else {
							var number = parseFloat(obj.num).toFixed(2);
							var counter = 1;
							var increment = (number - counter) / 50;
							var interval = setInterval(function(){
								counter += increment;
								if(counter >= number) {
									counter = number;
									clearInterval(interval);
								}
								$('.game_area_number span').html(parseFloat(counter).toFixed(2)+'x');
							}, 10);
							$('.game_area .game_area_rocket').addClass('flying');
							setTimeout(function(){
								$('.game_area .game_area_boom').addClass('game_area_boom_boom');
								$('.game_area .game_area_rocket').addClass('boom');
								$('.game_area .game_area_rocket').removeClass('flying');
								if(obj.amount >= 0) {
									$('.game_area_number span').css('color', '#00e701');
								} else {
									$('.game_area_number span').css('color', '#E9113C');
								}
								setTimeout(function(){
									$('.game_area .game_area_boom').removeClass('game_area_boom_boom');
									$('.game_area .game_area_rocket').removeClass('boom');
									$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
									user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
									
									if(Array.isArray(my_bet_data)) {
										my_bet_data.unshift(obj.bet_data);
									} else {
										my_bet_data = [obj.bet_data];
									}
									if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
										my_bet_data = my_bet_data.slice(0, 20);
									}
									store_bet_data(my_bet_data);
									show_my_bet_data(my_bet_data);
									enable_all_inputs();
									if(bet_mode == 'auto'){
										if(obj.amount >= 0) {
											if(on_win == 'reset_onwin') {
												bet_amount = base_bet;
											} else if(on_win == 'increase_onwin') {
												bet_amount =  parseFloat(bet_amount * (1 + increase_onwin_by / 100));
											}
										} else {
											if(on_loss == 'reset_onloss') {
												bet_amount = base_bet;
											} else if(on_loss == 'increase_onloss') {
												bet_amount =  parseFloat(bet_amount * (1 + increase_onloss_by / 100));
											}
										}
										$('#bet_amount').val(bet_amount.toFixed(8));
										$('#number_rolls').val(number_rolls+1);
										profit_loss = parseFloat((profit_loss * 100000000 +  parseInt(obj.amount)) / 100000000).toFixed(8);
										$('#profit_loss').val(profit_loss);
										if(profit_loss > 0) {
											$('#profit_loss').css('color', '#03a9f4');
										} else if(profit_loss < 0) {
											$('#profit_loss').css('color', '#e91e63');
										} else {
											$('#profit_loss').css('color', '#333');
										}
										
										if((stop_on_profit > 0 && profit_loss >= stop_on_profit) 
										|| (stop_on_loss > 0 && profit_loss <= -stop_on_loss)) {
											stop_auto_bet();
										} else {
											process_bet_game_limbo(bet_amount);
										}
									}
									
								}, 700);
							}, 500);

						}
					}
				});
			}, 10);
		
			
			
		}
		
		function start_auto_bet() {
			profit_loss = 0;
			$('#start_auto_bet_btn').hide();
			$('#stop_auto_bet_btn').show();
			base_bet = parseFloat($('#bet_amount').val());
			$('#number_rolls').val(0);
			$('#profit_loss').val(profit_loss.toFixed(8));
			$('#profit_loss').css('color', '#333');
			auto_betting_status = 'running';
			process_bet_game_limbo();
		}
		
		function stop_auto_bet() {
			enable_all_inputs();
			auto_betting_status = 'stopped';
			$('#start_auto_bet_btn').show();
			$('#stop_auto_bet_btn').hide();
		}


		$(document).ready(function() {
			setTimeout(function(){
				$('.meteor_shower').css('opacity', 1);
			}, 1000);
			$("#auto_bet").on("change", switch_bet_mode);
			$("#bet_double").on("click", set_bet_double_amount);
			$("#bet_half").on("click", set_bet_half_amount);
			$("#bet_amount").on("change", change_bet_amount);
			$("#payout").on("change", change_payout);
			$("#win_chance").on("change", change_win_chance);
			$("#process_bet_game_limbo").on("click", process_bet_game_limbo);
			$("#start_auto_bet_btn").on("click", start_auto_bet);
			$("#stop_auto_bet_btn").on("click", stop_auto_bet);
			$("input[type=radio][name=onwin]").on("change", change_on_win);
			$("input[type=radio][name=onloss]").on("change", change_on_loss);
			$("#increase_onwin_by").on("change", change_increase_onwin_by);
			$("#increase_onloss_by").on("change", change_increase_onloss_by);
			$("#stop_on_profit").on("change", change_stop_on_profit);
			$("#stop_on_loss").on("change", change_stop_on_loss);
			
			show_my_bets(my_bet_data);
			$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
			$('#show_all_bets').on('click', show_all_bets);
			
			<?php if(isset($user_info) && $user_info->total_deposits < 0):?>
			document.addEventListener("visibilitychange", function(){
				prepare_for_stopping = setTimeout(function(){
					if(document.hidden) {
						if(auto_betting_status == 'running') {
							stop_auto_bet();
						}
						prepare_for_stopping = false;
					} else {
						clearTimeout(prepare_for_stopping);
					}
				}, 5000);
			}, false);
			<?php endif?>
			
		});
		
		
	</script>
	</body>
</html>