<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
		.payout_slot {
			position: relative;
			border-radius: 0.3em;
			text-align: center;
			animation-duration: .3s!important;
			animation-timing-function: cubic-bezier(.18,.89,.32,1.28);
			box-shadow: 0 0.2em 0 0 #a60004;
			background: rgb(255, 0, 63);
			grid-row: 1;
		}
		.payout_slot>span {
			position: absolute;
			top: 0;
			left: 0;
			bottom: 0;
			right: 0;
			display: flex;
			align-items: center;
			justify-content: center;
			font-weight: 700;
			color: #FFF;
			font-size: .75em;
		}
		@keyframes button_slide_down {
			0%,to {
				transform: translate(0)
			}

			50% {
				transform: translateY(30%)
			}
		}
		.payout_slot.slide_down {
			animation-name: button_slide_down
		}
		#start_auto_bet_btn, #stop_auto_bet_btn {
			display: none;
		}
		.game_plinko_footer {
			height: 25px;
			width: calc(100% - 20px);
			margin-left: 10px;
			display: grid;
			grid-gap: 1%;
			position: relative;
			top: -30px;
		}
		#game_plinko_container {
			width: 400px;
			height: 400px;
			margin: 0px calc(50% - 200px) 10px;
			scale: 1;
		}
		@media only screen and (max-width: 450px) {
			#game_plinko_container {
				scale: 0.85;
				margin-top: -30px;
			}
		}
		@media only screen and (max-width: 400px) {
			#game_plinko_container {
				scale: 0.8;
			}
		}
		@media only screen and (max-width: 350px) {
			#game_plinko_container {
				scale: 0.7;
			}
		}
		
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_plinko']?></h2>
					<div class="game_main row" style="width: 100%; max-width: 500px">
						<img id="imgball" src="<?=base_url()?>assets/img/games/plinko/ball.svg" width="0" height="0"/>
						<div class="col-xs-12">
							<div id="game_plinko_container">
								<canvas id="canvas" width="400" height="400"></canvas>
								<div class="game_plinko_footer">
								</div>
							</div>
						</div>
						<div class="col-xs-3 auto_dice_box">
							<div class="checkbox icheck-info">
								<input type="checkbox" id="auto_bet">
								<label for="auto_bet"><?=$langs['switch_auto']?></label>
							</div>
						</div>
						<div class="col-xs-6">
							<button class="btn bet_btn" id="process_bet_game_plinko"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['bet_btn']?></span></button>
							<button class="btn bet_btn" id="start_auto_bet_btn"><span><?=$langs['game_start_auto_bet_btn']?></span></button>
							<button class="btn bet_btn" id="stop_auto_bet_btn" style="text-transform: uppercase;"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['game_stop_auto_bet_btn']?></span></button>
						</div>
						<div class="col-xs-12">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-12 col-sm-6 bet_amount">
										<div class="input_label"><?=$langs['bet_ammount_label']?></div>
										<div class="input_group" style="height:44px"><img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:20px;height:20px;margin-top:9px"><input type="text" id="bet_amount" value="<?=$MIN_BET_AMOUNT?>"></div><span id="bet_double" onclick="set_bet_double_amount">2X</span><span id="bet_half"
											onclick="set_bet_half_amount">1/2</span></div>
									<div class="col-xs-12 col-sm-6">
										<div class="input_label"><?=$langs['game_risk_label']?></div>
										<div class="input_group"><select id="game_risk"><option value="0"><?=$langs['game_risk_low_label']?></option><option value="1"><?=$langs['game_risk_medium_label']?></option><option value="2"><?=$langs['game_risk_high_label']?></option></select></div>
									</div>
								</div>
							</div>
						</div>
						

					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Plinko')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Plinko')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
				</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
		class Obstacle {
			constructor(x, y, r) {
				this.x = x; // X-coordinate
				this.y = y; // Y-coordinate
				this.r = r; // Radius
				if($("body").hasClass("dark_mode")) {
					this.color = '#FFFFFF';
				} else {
					this.color = '#213743';
				}
				this.color2 = '#03a9f466';
				this.animation = false;
				this.r2 = 0; // Maximum radius of the animation
				
			}
			
			hit() {
				if(this.animation == false) {
					this.animation = 'fadein';
				}
			}
			
			update() {
				if(this.animation == 'fadein') {
					if(this.r2 < 10) {
						this.r2+=1;
					} else {
						this.animation = 'fadeout';
					}
				} else if(this.animation == 'fadeout') {
					if(this.r2 > 0) {
						this.r2-=1;
					} else {
						this.animation = false;
					}
				}				
			}

			draw(ctx) {
				//Draw animation after collision
				if(this.r2 > 0) {
					ctx.beginPath();
					ctx.fillStyle = this.color2;
					ctx.arc(this.x, this.y, this.r2, 0, Math.PI * 2);
					ctx.fill();
				}
				
				// Draw obstacle
				ctx.beginPath();
				ctx.fillStyle = this.color;
				ctx.arc(this.x, this.y, this.r, 0, Math.PI * 2);
				ctx.fill();
			}
		}

		class Ball {
			constructor(x, y, r) {
				this.startX = x;
				this.startY = y;
				this.x = x; // X-coordinate
				this.y = y; // Y-coordinate
				this.r = r; // Radius
				this.vx = 0; // X-coordinate speed
				this.vy = 0; // Y-coordinate speed
				this.gravity = 0.5; // Gravity factor
				this.friction = 0.001; // Friction factor
				this.bounce = 0.6; // Bounce factor
				this.angle = Math.PI / 2;
				this.alive = true; // Check if the ball alive
			}
			
			hit(obstacle) {
				// Calculate the distance
				let distance = Math.sqrt((obstacle.x - this.x) ** 2 + (obstacle.y - this.y) ** 2);
				if (distance <= this.r + obstacle.r) {
					// Calculate the direction of the ball after collision
					let angle = Math.atan2(this.y - obstacle.y, this.x - obstacle.x);
					let newAngle = 2 * angle - this.angle - Math.PI;
					this.vx = this.bounce * this.vy * Math.cos(newAngle);
					this.vy = this.bounce * this.vy * Math.sin(newAngle);
					
					// Update the posistion of the ball to avoid continuous collision
					this.x = obstacle.x + (this.r + obstacle.r) * Math.cos(angle);
					this.y = obstacle.y + (this.r + obstacle.r) * Math.sin(angle);
					return true;
				} else {
					return false;
				}
			}
			
			update() {
				// Add gravity
				this.vy += this.gravity;
				// Add friction
				this.vx *= (1 - this.friction);
				this.vy *= (1 - this.friction);
				// Update the posistion of the ball base the speed
				this.x += this.vx;
				this.y += this.vy;
			}
			
			draw(ctx) {
				var image  = document.getElementById("imgball");
				ctx.drawImage(image, this.x - this.r, this.y - this.r, 2 * this.r, 2 * this.r);
			}
		}
		
		class Board {
			constructor(ctx, width, height) {
				this.obstacles = []; // array of the obstacles
				this.balls = []; //array of the balls
				this.ctx = ctx;
				this.width = width;
				this.height = height;
				this.cols = 3;
				this.rows = 10;
				this.gap = 35;
				this.prediction = [[196.41, 15.64], [199.14, 5.83], [196.38, 15.77], [197.2, 19.94], [192.68, 15.43], [190.21, 11.62], [199.19, 6.76], [198.82, 17.73], [198.57, 4.08], [190.6, 1.67], [199.9, 3.89], [190.19, 6.62], [198.23, 6.82], [192.15, 13.85], [199.19, 16.19], [198.08, 9.28], [193.71, 19.52], [198.7, 14.55], [196.52, 13.38], [191.3, 12.85], [193.6, 17.04], [196.11, 16.49], [191.67, 12.57], [193.16, 15.92], [197.02, 17.8], [191.32, 7.86], [198.68, 5.27], [198.9, 6.43], [196.62, 17.87], [197.62, 13.8], [199.38, 5.11], [198.78, 9.83], [199.12, 3.32], [195.9, 19.65], [192.93, 5.1], [196.74, 13.79], [195.17, 17.52], [192.14, 13.86], [192.16, 13.54], [192.16, 17.9], [197.26, 11.61], [197.39, 0.54], [191.51, 1.51], [198.56, 4.26], [198.74, 7.35], [197.36, 11.61], [198.5, 0.39], [191.19, 8.64], [198.06, 6.07], [197.97, 5.27], [194.56, 18.39], [197.07, 10.02], [191.05, 3.2], [196.13, 12.54], [190.92, 15.1], [190.85, 12.36], [197.55, 2.21], [198.53, 15.75], [190.6, 4.29], [190.12, 18.49], [197.93, 0.01], [194.58, 18.22], [197.57, 13.84], [192.31, 5.53], [198.72, 5.9], [190.71, 10.43], [191.31, 11.92], [192.09, 0.83], [191.24, 19.24], [197.33, 11.31], [192.29, 1.33], [197.57, 0.73], [199.05, 19.45], [190.14, 8.74], [199.26, 1.83], [190.85, 15.24], [190.17, 14.4], [192.25, 14.76], [190.11, 11.03], [197.77, 2.82], [199.21, 1.73], [190.03, 15.35], [197.82, 8.82], [190.87, 3.17], [191.35, 18.91], [191.47, 0.58], [190.46, 0.28], [199.24, 2], [199.35, 2.88], [190.84, 0.31], [192.56, 0.93], [192.25, 16.48], [198.85, 16.37], [199.12, 11.85], [198.81, 13.87], [190.55, 6.33], [195.81, 15.31], [198.06, 11.02], [190.21, 1.59], [199.15, 7.26], [191.09, 10.23], [190.71, 12.71], [197.97, 3.82], [198.38, 0.94], [192.9, 0.87], [193, 0], [192.57, 5.8], [194.02, 17.11], [197.02, 5.21], [193.43, 10.84], [190.43, 16.69], [190.2, 1.8], [190.88, 14.98], [199.27, 5.64], [197.94, 7.22], [191.63, 16.07], [192.28, 0.65], [197.52, 11.9], [190.12, 14.88], [190.32, 9.41], [190.77, 18.51], [192.53, 0.99], [192.74, 5.11], [194.85, 18.93], [194.62, 18.47], [193.29, 6.08], [193.81, 18.74], [191.05, 13.77], [191.33, 17.76], [195.07, 16.25], [191.82, 5.88], [199.16, 14.76], [198.23, 8.51], [198.24, 10.46], [197.63, 16.96], [195.44, 16.83], [199.21, 18], [198.28, 11.22], [196.79, 12.96], [198.16, 12.98], [199.81, 4.22], [198.09, 16.66], [191.96, 5.89], [196.9, 13.39], [191.68, 14.12], [196.59, 18.3], [199.1, 17.55], [196.2, 10.93], [196.51, 12.06], [191.31, 5.46], [199.83, 1.17], [198.03, 9.88], [198.13, 10.38], [198.59, 13.67], [199.29, 16.78], [198.2, 11.21], [199.67, 9.1], [198.33, 12.02], [198.96, 11.19], [196.96, 14.98], [198.19, 17.6], [198.19, 7.99], [190.12, 4.85], [191.24, 18.2], [196.01, 10.31], [198.02, 10.23], [193.16, 18.68], [199.42, 9.33], [198.76, 18.71], [196.84, 12.69], [197.09, 13.87], [197.85, 15.49], [199.69, 0.09], [192.86, 0.33], [197.52, 19.47], [192.67, 17.86], [197.76, 10.91], [192.03, 5.63], [198.36, 12.29], [191.43, 13.22], [199.22, 11.6], [190.95, 14.53], [196.73, 19.16], [191.83, 15.48], [192.73, 11.05], [199.19, 13.67], [190.06, 4.07], [192.98, 16.01], [191.95, 18.62], [192.66, 18.08], [198.34, 12.93], [199.07, 10.36], [197.83, 6.4], [199.37, 11.09], [197.88, 17.45], [199.5, 9.04], [196.75, 18.72], [192.86, 16.22], [198.43, 10.14], [190.58, 8.99], [199.52, 9.31], [192.09, 15.82], [199.09, 15.75], [198.49, 9.02], [190.14, 4.36], [190.52, 5.08], [192.01, 15.34], [193.03, 11.54], [198.13, 12.96], [197.61, 12], [199.47, 5.89], [197.13, 16.41], [199.4, 16.17], [196.75, 14.81], [197.34, 14.93], [198.67, 3.58], [198.86, 0.42], [194.48, 19.93], [191.91, 18.95], [191.65, 10.32], [197.41, 15.36], [197.3, 14.86], [193.29, 16.75], [199.22, 4.12], [195.03, 17.97], [195.22, 18.33], [191.19, 5.05], [196.11, 19.12], [199.68, 4.45], [192.61, 14.59], [199.05, 15.65], [193.27, 19.77], [197.39, 16.07], [191.73, 7.21], [195.53, 15.52], [192.39, 17.3], [193.73, 15.72], [197.32, 19.37], [197.17, 15.59], [198.72, 11.81], [192.56, 5.22], [197.77, 10.47], [199.48, 13.6], [197.03, 6.78], [195.76, 17.16], [194.88, 15.12], [196.63, 13.86], [197.3, 10.79], [197.77, 18.59], [192.13, 16.93], [190.19, 3.13], [197.32, 14.16], [195.27, 16.3], [198.14, 13.84], [196.91, 6.31], [199.36, 11.64], [193.11, 2.47], [195.91, 4.76], [196.3, 6.86], [193.62, 6.74], [195.46, 9.78], [195.26, 14.62], [193.25, 11.76], [192.89, 6.94], [197.89, 9.76], [196.64, 7.72], [192.48, 7.3], [196.18, 13.04], [193.35, 0.04], [195.25, 13.17], [194.37, 14.95], [193.26, 13.47], [195.68, 12.36], [192.16, 7.27], [194.48, 12.35], [193.23, 2.47], [193.28, 4.75], [192.62, 3.03], [194.02, 4.88], [195.29, 13.6], [192.09, 7.76], [192.98, 13.02], [193.94, 4.76], [195, 9.23], [194.37, 11.72], [195.2, 10.95], [194.79, 10.56], [193.8, 12.94], [192.07, 7.66], [195.25, 1.51], [196.56, 4.47], [194.4, 11.96], [194.53, 9.66], [196.27, 6.94], [195.26, 13.63], [194.99, 9.24], [195.09, 3.01], [194.75, 0.77], [194.46, 1.4], [196.48, 4.47], [195.99, 6.02], [195.42, 1.72], [195.59, 5.97], [195.76, 2.41], [195.52, 2.56], [195.54, 4.71], [192.49, 13.62], [195.62, 8.6], [192.47, 13.59], [192.78, 4.79], [195.06, 10.7], [194.49, 8.49], [194.11, 0.81], [195.2, 12.9], [194.15, 7.42], [195.2, 13.22], [196.92, 9.49], [194.48, 11.44], [196.47, 7.3], [194.39, 11.26], [193.63, 1.7], [194.41, 14.07], [194.18, 5.08], [195.28, 7.42], [193.61, 6.47], [193.25, 6.77], [193.33, 8.06], [192.99, 11.95], [195.9, 6.67], [194.32, 9.73], [193.23, 3.14], [193.99, 3.43], [197.33, 1.46], [195.52, 9.65], [195.17, 9.13], [191.45, 2.79], [192.81, 2.67], [193.79, 8.91], [194.54, 9.4], [195.75, 3.42], [193.11, 1.24], [197.32, 2.05], [193.84, 13.22], [193.35, 12.41], [194.84, 0.16], [194.3, 8.36], [194.56, 12.75], [194.06, 3.52], [195.75, 9.9], [195.49, 9.4], [194.77, 8.45], [193.19, 1.88], [193.68, 5.26], [196.6, 5.02], [194.42, 10.96], [194.17, 4.24], [194.42, 11.67], [194.45, 3.82], [193.87, 5.34], [194.08, 1.06], [196.74, 0.07], [194.99, 8.33], [193.42, 2.24], [195.8, 5.21], [193.53, 11.31], [194.04, 7.78], [195.11, 5.37], [192.87, 4.2], [194.95, 1.41], [193.87, 6.18], [195.91, 9.1], [194.21, 13.27], [194.71, 6.96], [194.93, 3.75], [193.11, 4.63], [193.68, 2.45], [193.45, 6.9], [194.71, 8.23], [196.14, 5.06], [193.5, 11.35], [195.1, 7.44], [195.42, 12.99], [194.8, 5.1], [195.68, 13.11], [193.52, 17.28], [192.99, 12.27], [199.66, 11.09], [199.45, 19.28], [199.79, 18.55], [196.63, 9.48], [199.79, 18.5], [192.83, 12.02], [193.11, 12.41], [199.66, 15.95], [199.88, 7.63], [199.08, 18.66], [191.25, 3.17], [195.72, 0.55], [194.29, 14.55], [193.84, 10.28], [193.28, 12.88], [196.45, 6.74], [192.72, 3.46], [195.17, 18.56], [195.09, 7.92], [192.44, 9.51], [199.79, 17.05], [193.82, 15.06], [196.61, 3.99], [197.28, 4.1], [193.36, 10.27], [199.95, 1.08], [195.17, 18.38], [196.01, 7.22], [195.2, 8.51], [195.37, 5.54], [192.84, 9.9], [192.72, 3.75], [199.75, 11.98], [193.84, 13.44], [193.28, 4.08], [194.91, 18.1], [195.99, 1.05], [193.38, 4.2], [196.61, 9.25], [198.66, 1.13], [199.71, 14.23], [199.71, 10.96], [193.31, 4.12], [195.78, 7.15], [191.59, 2.54], [192.91, 12.21], [195.7, 6.67], [192.69, 12.55], [199.94, 14.83], [194.01, 15.28], [198.78, 2.3], [195.8, 0.58], [192.65, 3.72], [194.09, 6.33], [199.84, 16.99], [199.8, 15.74], [196.58, 5.95], [193.4, 13.53], [193.34, 17.1], [196.52, 9.14], [194.3, 14.75], [191.7, 2.23], [196.43, 3.17], [192.43, 4.16], [193.53, 5.25], [192.81, 16.42], [196.81, 8.81], [194.71, 15.16], [193.93, 14.14], [193.35, 10.54], [197.46, 4.35], [196.71, 8.8], [191.93, 8.63], [193.38, 10.08], [196.58, 3.21], [196.14, 7.13], [194.18, 10.42], [196.52, 2.18], [192.59, 13.45], [196.69, 6.48], [195.98, 1.86], [196.43, 9.53], [192.98, 3.86], [193.9, 10.28], [199.65, 18.57], [192.97, 9.4], [191.6, 4.15], [193.57, 10.3], [195.83, 9.46], [197.43, 9.21], [193.48, 14.19], [196.09, 0.21], [196.72, 0.71], [195.29, 6.61], [196.25, 8.28], [194.12, 17.04], [193.35, 13.15], [193.02, 12.88], [196.06, 6.94], [194.31, 6.48], [199.86, 15.18], [193.45, 13.29], [196.35, 3.5], [199.76, 5.78], [196.29, 7.65], [196.08, 7.55], [199.96, 12.27], [196.43, 8.73], [192.52, 8.93], [199.94, 7.48], [193.61, 10.38], [193.8, 14.58], [191.33, 2.77], [199.79, 16.04], [194.38, 6.68], [198.44, 6.44], [192, 12.78], [199.96, 2.62], [194.32, 16.94], [194.09, 14.94], [193.59, 9.97], [199.12, 19.62], [194.1, 15.15], [199.93, 3.25], [191.87, 8.64], [192.05, 12.84], [204.91, 0.57], [204.56, 8.74], [203.32, 9.69], [203.41, 2.4], [202.89, 9.84], [205.66, 6.46], [200.15, 7.67], [203.31, 2.77], [205.93, 14.11], [206.36, 9.83], [207.1, 13.73], [205.67, 5.44], [202.81, 8.38], [204.87, 11.5], [203.55, 2.02], [206.37, 16.04], [203.81, 1.18], [200.29, 12.34], [203.26, 2.58], [201, 18.27], [205.73, 10.84], [208.01, 2.66], [206.62, 5.09], [205.74, 10.86], [200.08, 8.55], [207.66, 12.69], [200.17, 5.06], [200.03, 16.92], [208.77, 2.98], [200.09, 9.92], [205.73, 0.38], [206.98, 3.94], [205.27, 5.82], [204.17, 1.18], [208.26, 8.16], [205.87, 18.49], [204.02, 2.26], [208.26, 8.3], [207, 14], [207.55, 12.1], [205.07, 5.92], [203.51, 2.79], [206.91, 9.53], [206.54, 9.53], [203.09, 13.72], [202.6, 3.48], [203.83, 2.46], [202.52, 3.59], [203.79, 2.24], [206.43, 10.29], [204.7, 0.32], [205.36, 7.09], [206.33, 10.41], [203.88, 0.27], [204.61, 5.74], [205.69, 18.63], [204.21, 6.34], [207.84, 8.55], [204.72, 0.31], [200.19, 6.75], [203.36, 3.41], [204.43, 7.06], [208.53, 3], [203.07, 9.87], [200.31, 18.91], [203.74, 8.38], [200.2, 8.12], [200.43, 15.58], [200.16, 8.16], [207.1, 10.1], [208.58, 3.2], [204.31, 9.46], [205.17, 18.05], [200.48, 10.47], [202.82, 4.39], [200.08, 18.66], [203.82, 2.85], [200.52, 15.85], [205.39, 17.39], [207.03, 12.25], [200.56, 19.11], [208.13, 2.85], [207.05, 3.69], [207.51, 13.45], [208.12, 9.03], [200.52, 11.04], [205.28, 14.85], [201.93, 10.79], [203.36, 6.05], [205.99, 13.69], [203.36, 9.46], [207.26, 12.61], [203.91, 8.06], [200.04, 12.89], [202.36, 9.5], [200.16, 13.05], [205.53, 5.55], [206.59, 5.13], [204.33, 1.7], [200.94, 19.22], [203.05, 3.69], [200.18, 12.34], [206.79, 9.55], [207.53, 13.53], [200.02, 8.03], [207.56, 4.36], [206.63, 5.1], [206.9, 3.95], [207.29, 8.97], [203.62, 6], [206.77, 13.26], [207.29, 4.38], [200.08, 19.95], [205.53, 7], [206.61, 14.59], [204.58, 18.85], [200.24, 18.19], [200.05, 8.07], [203.08, 4.69], [204.2, 0.77], [206.3, 13.29], [207.52, 4.97], [204.86, 5.9], [205.84, 14.1], [203.76, 6.12], [200.53, 16.76], [200.16, 16.8], [207.56, 3.09], [204.81, 12.04], [204.14, 4.51], [202.16, 4.34], [206.6, 3.01], [206.61, 11.91], [204.78, 9.14], [204.47, 3.63], [206.6, 8.49], [205.42, 7.49], [206.91, 1.78], [202.29, 3.96], [203.84, 4.95], [205.71, 4.46], [205.95, 12.18], [207.08, 2.3], [205.75, 6.02], [205.29, 1.02], [205.47, 4.76], [207.77, 3.46], [204.67, 8.96], [203.66, 4.43], [206.22, 5.26], [205.7, 11.43], [205.16, 9.32], [205.33, 11.34], [205.18, 8.01], [208.23, 2.93], [205.19, 1.57], [205.75, 1.57], [207.79, 2.21], [203.12, 0.53], [205.18, 3.59], [205.98, 6.7], [203.11, 0.15], [206.64, 8.02], [205.12, 6.9], [206.76, 3.18], [205.52, 11.22], [200.77, 19.22], [206.1, 11.56], [203.19, 7.93], [206.05, 7.92], [205.29, 3.65], [204.98, 4.26], [207.12, 11.79], [204.79, 13.8], [204.2, 4.26], [202.91, 7.56], [205.82, 7.4], [204.97, 2.63], [206.07, 4.29], [204.74, 10.21], [203.47, 8.36], [203.82, 4.63], [205.66, 3.1], [204.65, 10.35], [205.21, 10.15], [206.22, 13.26], [206.89, 12.25], [206.82, 12.33], [204.95, 5.51], [206.24, 4.57], [206.24, 7.62], [205.92, 8.39], [206.46, 10.89], [206.13, 9.19], [204.15, 3.31], [208.25, 4.39], [207.87, 7.65], [205.84, 12.21], [206.61, 7.83], [203.75, 13.79], [203.08, 1.24], [205.99, 12.72], [204.11, 5.98], [204.16, 5.84], [204.14, 10.97], [204.74, 8.1], [205.41, 11.68], [205.71, 4.99], [203.86, 3.54], [203.55, 3.97], [205, 0.72], [206.46, 14.05], [205.57, 2.79], [204.44, 2.39], [206.66, 2.04], [205.64, 5.09], [204.59, 11.55], [207.79, 7.71], [203.52, 14.32], [206.24, 8.37], [205.47, 2.81], [204.47, 2.17], [206.48, 14.01], [206.48, 8.16], [206.15, 1.23], [205.29, 12.4], [204.64, 3.99], [204, 12.46], [205.83, 5.04], [204.31, 4.56], [203.24, 14.34], [204.28, 4.71], [205.35, 0.24], [205.38, 0.13], [205.46, 12.46], [206.65, 2.01], [207.54, 1.87], [203.76, 6.67], [205.19, 14.47], [204.93, 4.31], [202.85, 9.21], [206.01, 1.39], [205.52, 8.4], [205.44, 13.7], [208.03, 7.59], [204.75, 11.56], [201.77, 5.17], [205.2, 8.75], [204.34, 13.93], [201.83, 11.47], [205.63, 7.98], [205.72, 0.11], [206.96, 8.57], [207.37, 1.75], [205.53, 0.31], [204.88, 10.81], [201.02, 14.7], [205.31, 19.23], [203.23, 5.97], [202.46, 11.48], [200.16, 0.98], [200.91, 4.89], [209.69, 6.43], [201.27, 3.89], [209.66, 3.37], [205.68, 16.79], [200.6, 9.27], [207.09, 19.25], [203.06, 12.76], [200.38, 13.7], [200.45, 17.82], [209.09, 6.63], [203.16, 6.56], [202.46, 14.47], [200.41, 2.54], [204.15, 16.6], [202.42, 18.17], [208.56, 13.88], [202.38, 11.28], [200.58, 9.39], [207.65, 6], [201.96, 18.37], [202.64, 14.84], [205.41, 18.68], [200.67, 5.4], [205.37, 17.96], [207.62, 15.51], [200.63, 11.08], [202.85, 18.78], [200.21, 1.83], [209.81, 3.23], [208.47, 15.31], [203.56, 12.73], [209.05, 2.95], [209.05, 5.51], [202.13, 3.09], [201.6, 19.93], [200.44, 7.41], [202.06, 19.78], [202.61, 15.28], [202.91, 18.64], [200.49, 7.32], [200.61, 4.66], [202.91, 18.58], [208.12, 3.93], [203.68, 17.32], [202.68, 10.71], [205.31, 18.07], [200.9, 13.64], [200.49, 6.01], [207.77, 6.35], [205.59, 16.72], [202.07, 17.6], [204.1, 16.77], [208.22, 4.49], [207.48, 17.35], [206.49, 16.11], [200.69, 5.02], [200.81, 0.08], [200.64, 5.89], [202.19, 15.71], [207.62, 15.79], [201.52, 2.93], [207.6, 18.57], [208.92, 14.55], [209.2, 13.91], [203.17, 13.28], [208.37, 14.76], [201.56, 2.7], [207.41, 11], [201.55, 6.16], [209.18, 9.36], [208.48, 18.24], [201.86, 12.89], [208.72, 14.97], [204.32, 15.81], [204.47, 18.74], [204.51, 16.88], [205.3, 17.18], [200.48, 0.23], [207.17, 19.66], [201.67, 7.24], [203.91, 10.6], [208.12, 10.3], [201.08, 15.34], [207.65, 0.08], [202.91, 19.82], [203.05, 12.89], [209.43, 8.69], [206.48, 18.98], [209.41, 5.03], [202.72, 14.94], [200.4, 0.65], [203.33, 19.04], [200.44, 7.77], [203.6, 18.81], [207.64, 15.59], [203.96, 16.97], [203.85, 11.08], [201.51, 12.62], [203.44, 19.9], [201.47, 19.07], [201.45, 12.82], [201.21, 19.75], [204.86, 16.31], [205.57, 15.34], [208.25, 5.81], [200.88, 15.46], [200.53, 12.51], [200.3, 3.79], [209.56, 4.71], [203.97, 18.3], [202.69, 8.28], [207.87, 6.24], [207.71, 10.41], [209.62, 14.24], [201.99, 12.02], [209.72, 4.63], [201.82, 0.77], [202.97, 13.76], [208.44, 18.41], [209.29, 14.55], [203.43, 18.7], [206.7, 0.78], [208.65, 19.16], [203.61, 10.32], [208.59, 16], [207.92, 11.25], [208.97, 18.78], [207.69, 0.9], [208.57, 6.46], [209.07, 15.56], [208.25, 13.85], [204.6, 18.32], [208.62, 16.02], [208.28, 11.07], [208.61, 18.53], [204.92, 18.81], [208.96, 18.45], [209.34, 9.65], [206.16, 18.79], [209.21, 2.13], [200.57, 4.27], [200.94, 8.18], [204.19, 15.08], [203.35, 17.46], [209.35, 2.36], [206.85, 0.21], [209.23, 2.11], [207.39, 11.49], [209.49, 9.75], [201.55, 11.45], [209.06, 4.4], [201.81, 6.06], [201.5, 8.03], [204.89, 19.6], [209.49, 11.44], [208.45, 8.94], [204.5, 15.26], [203.79, 17.96], [204.72, 15.78], [209.78, 15.95], [208.82, 0.62], [204.53, 19.89], [209.54, 3.53], [208.76, 16.66], [208.43, 15.7], [209.45, 0.45], [208.6, 18.68], [209.84, 5.89], [204.65, 17.73], [208.22, 0.94], [209.92, 11.05], [209.66, 11.19], [207.23, 11.69], [200.7, 4.4], [209.22, 15.79], [202.12, 2.12], [205.67, 15.81], [208.25, 9.16], [204.68, 19.63], [209.67, 18.95], [204.75, 19.69], [203.76, 16.99], [202.91, 19.7], [209.57, 18.52], [209.95, 0.21], [208.23, 16.49], [201.57, 4.16], [201.22, 11.03], [202.21, 15.81], [202.29, 6.32], [202.34, 0.47], [200.71, 15], [202.14, 7.6], [201.37, 1.53], [201.98, 9.2], [209.78, 13.58], [201.38, 12.06], [208.7, 7.42], [201.54, 7.17], [209.88, 13.82], [208.24, 7.54], [208.66, 2.01], [208.62, 18.46], [207.87, 5.06], [202.26, 16.31], [203.22, 16.32], [202.58, 12.09], [208.89, 7.43], [201.03, 6.19], [209.89, 6.82], [202.1, 6.88], [202.62, 1.44], [205.47, 17.85], [200.49, 7.91], [201.79, 3.39], [209.86, 13.87], [209.6, 13.67], [207.81, 9.71], [208.31, 17.34], [206.95, 10.8], [201.48, 1.44], [202.32, 6.97], [207.85, 10.08], [209.36, 12.14], [202.35, 2.2], [200.22, 9.13], [206.73, 17.62], [200.62, 16.63], [201.79, 9.6], [208.75, 7.72], [200.95, 17.34], [209.86, 16.1], [202.18, 16.54], [201.95, 11.42], [209.74, 6.5], [202.52, 6.6], [209.57, 16.24], [200.78, 16.59], [207.06, 11.56], [208.5, 3.98], [202.17, 0.6], [200.63, 15.77], [201.93, 9.14], [200.58, 8.33], [200.99, 13.36], [200.44, 3.54], [200.92, 5.26], [204.38, 19.82], [206.62, 15.22], [209.42, 11.88]];
				this.createObstacles(); // create the obstacles
			}

			createObstacles() {
				var r = 3;
				var x = 0;
				var y = 0;
				var i = 0;
				var j = 0;
				var cols = this.cols;
				var rows = this.rows;
				var gap = this.gap;
				for(i = 0; i < rows; i++) {
					y = (i + 1) * gap + 10;
					x = (this.width / 2) - (cols + 1) * (gap / 2);
					
					for(j = 0; j < cols; j++) {
						x+= gap;
						this.obstacles.push(new Obstacle(x, y, r));
					}
					cols++;
				}
			}
			
			createBall(idx) {
				var x = this.prediction[idx][0];
				var y = this.prediction[idx][1];
				var ball = new Ball(x, y, 10);
				this.balls.push(ball);
				return ball;
			}

			update() {
				for (let ball of this.balls) {
					for (let i = 0; i < this.obstacles.length; i++) {
						if(ball.alive && ball.hit(this.obstacles[i])){
							this.obstacles[i].hit();
						}
					}
				}
				for (let ball of this.balls) {
					if(ball.alive == true) {
						ball.update();
						if(ball.y >= 365) {
							let payout_slot_id = Math.floor((ball.x - 10) / ((this.width - 20) / (this.rows + this.cols - 2)));
							$('#payout_slot_'+payout_slot_id).addClass('slide_down');
							setTimeout(function(){$('#payout_slot_'+payout_slot_id).removeClass('slide_down');}, 100);
							ball.alive = false;
						}
					}
				}
				for (let obstacle of this.obstacles) {
					obstacle.update();
				}
			}

			draw() {
				for (let obstacle of this.obstacles) {
					obstacle.draw(this.ctx);
				}
				for (let ball of this.balls) {
					if(ball.alive == true) {
						ball.draw(this.ctx);
					}
				}
			}
		}
		
		var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
		const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
		const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
		const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
		const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
		const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
		const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
		
		const MAGIC_NUMBER = 0.97;
		var auto_betting_status = '';
		var bet_mode = 'manual';
		var my_bet_data = [];
		var board;
		var game_risk = 0;
		var prepare_for_stopping = false;
		
		// Init game
		function init() {
			canvas = document.getElementById("canvas");
			ctx = canvas.getContext("2d");
			board = new Board(ctx, 400, 400);
			draw_payout_slots();
		}
		
		function draw_payout_slots() {
			const payout_slot_colors = [['#ff003f', '#a60004'], ['#ff2632', '#a60000'], ['#ff4d26', '#a70000'], ['#ff7319', '#a82a00'], ['#ff9a0d', '#aa5500'], ['#ffc107', '#ab7900'], ['#ff9a0d', '#aa5500'], ['#ff7319', '#a82a00'], ['#ff4d26', '#a70000'], ['#ff2632', '#a60000'], ['#ff003f', '#a60004']];
			const risk_payouts = [
				[9, 2.4, 1.3, 1.1, 1, 0.5, 1, 1.1, 1.3, 2.4, 9],
				[36, 5, 2, 1.2, 0.6, 0.4, 0.6, 1.2, 2, 5, 36],
				[75, 10, 3, 0.7, 0.4, 0.15, 0.4, 0.7, 3, 10, 75]
			];
			var html = '';
			for(let i = 0; i < payout_slot_colors.length; i++) {
				html += '<div class="payout_slot" id="payout_slot_'+i+'" style="background: '+payout_slot_colors[i][0]+'; box-shadow: 0 0.2em 0 0 '+payout_slot_colors[i][1]+'"><span>'+risk_payouts[game_risk][i]+'x</span></div>';
			}
			$('.game_plinko_footer').html(html);
		}

		// Update game state after each frame
		function update() {
			board.ctx.clearRect(0, 0, board.width, board.height);
			board.update();
			board.draw();
			requestAnimationFrame(update);
		}
		
		function change_risk() {
			game_risk = parseInt($('#game_risk').val());
			if(isNaN(game_risk) || game_risk == '' || game_risk < 0) {
				game_risk = 0;
			} else if(game_risk > 2) {
				game_risk = 2;
			}
			draw_payout_slots();
		}
		
		function switch_bet_mode() {
			if(auto_betting_status == 'running') {
				return;
			}
			if(bet_mode == 'manual') {
				$('#start_auto_bet_btn').show();
				$('#process_bet_game_plinko').hide();
				bet_mode = 'auto';
			} else {
				$('#start_auto_bet_btn').hide();
				$('#process_bet_game_plinko').show();
				bet_mode = 'manual';
			}
		}
		
		function set_bet_double_amount() {
			if($('#bet_amount').prop("disabled")) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount *= 2;
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function set_bet_half_amount() {
			if($('#bet_amount').prop("disabled")) {
				return;
			}
			var bet_amount = parseFloat($('#bet_amount').val());
			bet_amount /= 2;
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			$('#bet_amount').val(bet_amount.toFixed(8));
		}
		
		function change_bet_amount() {
			var bet_amount = parseFloat($('#bet_amount').val());
			if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
				bet_amount = MIN_BET_AMOUNT;
			}
			if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
				//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				 $('#bet_amount').parent().css('border', '2px solid #f44336');
			} else {
				 $('#bet_amount').parent().css('border', '1px solid #DDD');
			}
			setTimeout(function() {
				$('#bet_amount').val(bet_amount.toFixed(8));
			}, 100);
		}
 
 
		function process_bet_game_plinko(){
			var bet_amount = parseFloat($('#bet_amount').val());
			$("#process_bet_game_plinko").attr("disabled", true);
			$("#bet_amount").attr("disabled", true);
			$('#bet_amount').parent().addClass('disabled');
			$("#game_risk").attr("disabled", true);
			$('#auto_bet').prop('disabled', true);
			$('#process_bet_game_plinko span').hide();
			$('#process_bet_game_plinko img').show();

			setTimeout(function() {
				$.ajax({
					url: "<?=base_url()?>process.php",
					type: "POST",
					data: "action=bet_game_plinko&bet_amount="+bet_amount+"&risk="+game_risk,
					error: function(){
						$.toast({
							heading: 'Error!',
							text: 'Request timed out. Please try again!',
							showHideTransition: 'slide',
							position: 'top-right',
							icon: 'error'
						});
						$("#process_bet_game_plinko").attr("disabled", false);
						$('#process_bet_game_plinko span').show();
						$('#process_bet_game_plinko img').hide();
						$("#bet_amount").attr("disabled", false);
						$('#bet_amount').parent().removeClass('disabled');
						$("#game_risk").attr("disabled", false);
						$('#auto_bet').prop('disabled', false);
						if(bet_mode == 'auto' && auto_betting_status == 'running') {
							stop_auto_bet();
						}
					},
					success: function(out){
						let obj = JSON.parse(out);
						if(obj.ret == 0) {
							$.toast({
								heading: 'Error!',
								text: obj.mes,
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$("#process_bet_game_plinko").attr("disabled", false);
							$('#process_bet_game_plinko span').show();
							$('#process_bet_game_plinko img').hide();
							$("#bet_amount").attr("disabled", false);
							$('#bet_amount').parent().removeClass('disabled');
							$("#game_risk").attr("disabled", false);
							$('#auto_bet').prop('disabled', false);
							if(bet_mode == 'auto' && auto_betting_status == 'running') {
								stop_auto_bet();
							}
						} else {
							let idx = obj.direction_idx;
							var new_ball = board.createBall(idx);
							new_ball.obj = obj;
							$('#process_bet_game_plinko span').show();
							$('#process_bet_game_plinko img').hide();
							$("#process_bet_game_plinko").attr("disabled", false);
							
							if(bet_mode == 'auto' && auto_betting_status == 'running') {
								setTimeout(function(){
									process_bet_game_plinko();
								}, 500);
							}
							
							let interval = setInterval(function(){
								if(!new_ball.alive) {
									clearInterval(interval);
									$('.user_balance').text(parseFloat((parseInt(new_ball.obj.balance)) / 100000000).toFixed(8));
									user_balance = parseFloat((parseInt(new_ball.obj.balance)) / 100000000).toFixed(8);
									if(Array.isArray(my_bet_data)) {
										my_bet_data.unshift(obj.bet_data);
									} else {
										my_bet_data = [obj.bet_data];
									}
									if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
										my_bet_data = my_bet_data.slice(0, 20);
									}
									store_bet_data(my_bet_data);
									show_my_bet_data(my_bet_data);
								}
							});
							let interval2 = setInterval(function(){
								let chk_balls_alive = false;
								for (let ball of board.balls) {
									if(ball.alive) {
										chk_balls_alive = true;
									}
								}
								if(chk_balls_alive == false) {
									clearInterval(interval2);
									$("#bet_amount").attr("disabled", false);
									$('#bet_amount').parent().removeClass('disabled');
									$("#game_risk").attr("disabled", false);
									$('#auto_bet').prop('disabled', false);
									if(bet_mode == 'auto') {
										$('#stop_auto_bet_btn').hide();
										$('#start_auto_bet_btn').show();
										$('#stop_auto_bet_btn').html('<img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['game_stop_auto_bet_btn']?></span>');
									}
								}
							}, 100);
						}
					}
				});
			}, 10);
		}
		
		function start_auto_bet() {
			$('#start_auto_bet_btn').hide();
			$('#stop_auto_bet_btn').show();
			auto_betting_status = 'running';
			process_bet_game_plinko();
		}
		
		function stop_auto_bet() {
			auto_betting_status = 'stopped';
			$('#stop_auto_bet_btn').html('<span><i class="fas fa-hourglass-start"></i> <?=$langs['please_wait_btn']?></span>');
		}


		$(document).ready(function() {
			init();
			update();
			$("#auto_bet").on("change", switch_bet_mode);
			$("#bet_double").on("click", set_bet_double_amount);
			$("#bet_half").on("click", set_bet_half_amount);
			$("#bet_amount").on("change", change_bet_amount);
			$("#game_risk").on("change", change_risk);
			$("#process_bet_game_plinko").on("click", process_bet_game_plinko);
			$("#start_auto_bet_btn").on("click", start_auto_bet);
			$("#stop_auto_bet_btn").on("click", stop_auto_bet);
			
			show_my_bets(my_bet_data);
			$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
			$('#show_all_bets').on('click', show_all_bets);
			
			<?php if(isset($user_info) && $user_info->total_deposits < 0):?>
			document.addEventListener("visibilitychange", function(){
				prepare_for_stopping = setTimeout(function(){
					if(document.hidden) {
						if(auto_betting_status == 'running') {
							stop_auto_bet();
						}
						prepare_for_stopping = false;
					} else {
						clearTimeout(prepare_for_stopping);
					}
				}, 5000);
			}, false);
			<?php endif?>
			
		});
		
		
	</script>
	</body>
</html>