<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<style>
		.dark_mode .slots__result-multiplier {
			background: rgb(0 0 0 / 38%);
		}
		</style>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_slots']?></h2>
					<div class="game_main" id="game_slots" style="max-width: 550px; width: 100%;">			
						<div class="slots__container slots__container--won">
							<div class="slots__result-multiplier"><span id="payout1"></span><span id="payout2"></span><span id="payout3"></span></div>
							<div class="slots__row-container">
								<span class="slots__row slots__row--one slots__row--active"><span></span><span></span><span></span></span>
								<span class="slots__row slots__row--two"><span></span><span></span><span></span></span>
								<span class="slots__row slots__row--three"><span></span><span></span><span></span></span>
							</div>
							<div class="reel__container first_reel">
								<div class="reel reel--start" style="transform: rotateX(90deg);">
									<?php if(is_array($reels)):?>
									<?php for($i = 0; $i < sizeof($reels[0]); $i++):?>
									<div class="reel__part reel__part--<?=$reels[0][$i]?>"></div>
									<div class="reel__part reel__part--transparent"></div>
									<?php endfor?>
									<?php endif?>
								</div>
							</div>
							<div class="reel__container second_reel">
								<div class="reel reel--start" style="transform: rotateX(-90deg);">
									<?php if(is_array($reels)):?>
									<?php for($i = 0; $i < sizeof($reels[1]); $i++):?>
									<div class="reel__part reel__part--<?=$reels[1][$i]?>"></div>
									<div class="reel__part reel__part--transparent"></div>
									<?php endfor?>
									<?php endif?>
								</div>
							</div>
							<div class="reel__container third_reel">
								<div class="reel reel--start" style="transform: rotateX(-70deg);">
									<?php if(is_array($reels)):?>
									<?php for($i = 0; $i < sizeof($reels[2]); $i++):?>
									<div class="reel__part reel__part--<?=$reels[2][$i]?>"></div>
									<div class="reel__part reel__part--transparent"></div>
									<?php endfor?>
									<?php endif?>
								</div>
							</div>
						</div>
						
						<div class="col-sm-12">
							<div class="row">	
								<div class="col-xs-3 auto_spin_box">
									<div class="checkbox icheck-info">
										<input type="checkbox" id="auto_spin">
										<label for="auto_spin"><?=$langs['switch_auto']?></label>
									</div>
								</div>
								<div class="col-xs-6">
									<button class="btn" id="spin_btn"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['spin_btn']?></span></button>
									<button class="btn" id="start_auto_spin_btn"><span><?=$langs['start_auto_spin_btn']?></span></button>
									<button class="btn" id="stop_auto_spin_btn" style="text-transform: uppercase;"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['stop_auto_spin_btn']?></span></button>
								</div>
								<div class="col-xs-3"></div>
							</div>
						</div>
						<div class="col-sm-12">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-12 col-sm-6 bet_amount">
										<div class="input_label"><?=$langs['bet_ammount_label']?></div>
										<div class="input_group" style="height: 44px">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 16px"/>
											<input type="text" id="bet_amount" value="<?=$MIN_BET_AMOUNT?>">
										</div>
										<span id="bet_double" onclick="set_bet_double_amount">2X</span>
										<span id="bet_half" onclick="set_bet_half_amount">1/2</span>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="input_label"><?=$langs['num_lines']?></div>
										<div class="input_group">
											<select id="num_lines">
												<option>1</option>
												<option>2</option>
												<option>3</option>
											</select>
											<!--<input type="number" id="num_lines" name="num_lines" min="1" max="3" value="1">-->
											<i class="fas fa-line-height addon"></i>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div style="clear: both"></div>
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Slots')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Slots')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
				</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
			const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
			const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
			const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
			const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
			const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
			const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
			
			const MAGIC_NUMBER = 0.97;
			var num_lines = 1;
			var auto_betting_status = '';
			var bet_mode = 'manual';
			var my_bet_data = [];
			var prepare_for_stopping = false;
			
			
			function switch_bet_mode() {
				if(auto_betting_status == 'running') {
					return;
				}
				if(bet_mode == 'manual') {
					$('#start_auto_spin_btn').show();
					$('#spin_btn').hide();
					bet_mode = 'auto';
				} else {
					$('#start_auto_spin_btn').hide();
					$('#spin_btn').show();
					bet_mode = 'manual';
				}
			}
			
			function set_bet_double_amount() {			
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount *= 2;
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function set_bet_half_amount() {
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount /= 2;
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function change_bet_amount() {
				var bet_amount = parseFloat($('#bet_amount').val());
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
					 $('#bet_amount').parent().css('border', '2px solid #f44336');
				} else {
					 $('#bet_amount').parent().css('border', '1px solid #DDD');
				}
				setTimeout(function() {
					$('#bet_amount').val(bet_amount.toFixed(8));
				}, 100);
			}
			
			function change_lines() {
				num_lines = parseInt($('#num_lines').val());
				if(isNaN(num_lines) || num_lines == '' || num_lines < 1) {
					num_lines = 1;
				} else if(num_lines > 3) {
					num_lines = 3;
				}
				$('#num_lines').val(num_lines);
				$('.slots__row-container .slots__row ').removeClass('slots__row--active');
				if(num_lines >= 1) {
					$('.slots__row--one').addClass('slots__row--active');
				}
				if(num_lines >= 2) {
					$('.slots__row--two').addClass('slots__row--active');
				}
				if(num_lines >= 3) {
					$('.slots__row--three').addClass('slots__row--active');
				}
			}
			
			function get_rotateX_by_from_reel(reel_id) {
				var matrix = $('.'+reel_id+' .reel').css('transform');
				var values = matrix.split('(')[1].split(')')[0].split(',');
				var sinB = parseFloat(values[8]);
				var rotateY = Math.round(Math.asin(sinB) * 180 / Math.PI);
				var cosB = Math.cos(rotateY * Math.PI / 180);
				var matrixVal10 = parseFloat(values[9]);
				var rotateX = Math.round(Math.asin(-matrixVal10 / cosB) * 180 / Math.PI);
				var matrixVal1 = parseFloat(values[0]);
				var rotateZ = Math.round(Math.acos(matrixVal1 / cosB) * 180 / Math.PI);
				return rotateX;
			}
		
			function process_bet_game_slots() {
				if(bet_mode == 'manual') {
					if($('#spin_btn').prop('disabled')) {
						return;
					}
					$('#spin_btn').prop('disabled', true);
					$('#spin_btn img').show();
					$('#spin_btn span').hide();
				} else {
					if(auto_betting_status != 'running') {
						$('#start_auto_spin_btn').show();
						$('#stop_auto_spin_btn').hide();
						$('#stop_auto_spin_btn').html('<img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['stop_auto_spin_btn']?></span>');
						return;
					}
					$('#start_auto_spin_btn').hide();
					$('#stop_auto_spin_btn').show();
				}
				
				$('.slots__result-multiplier').removeClass('showing');
				var bet_amount = parseFloat($('#bet_amount').val());
				var first_deg = get_rotateX_by_from_reel('first_reel');
				var second_deg = get_rotateX_by_from_reel('second_reel');
				var third_deg = get_rotateX_by_from_reel('third_reel');
				var deg = 0;
				var interval1 = setInterval(function(){
					first_deg -= 10;
					$('#game_slots .first_reel .reel').css('transform', 'rotateX('+first_deg+'deg)');
				}, 5);
				var interval2 = setInterval(function(){
					second_deg -= 10;
					$('#game_slots .second_reel .reel').css('transform', 'rotateX('+second_deg+'deg)');
				}, 5);
				var interval3 = setInterval(function(){
					third_deg -= 10;
					$('#game_slots .third_reel .reel').css('transform', 'rotateX('+third_deg+'deg)');
				}, 5);
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_slots&bet_amount="+bet_amount+"&lines="+num_lines,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});					
							clearInterval(interval1);
							$('#game_slots .first_reel .reel ').css('transition', 'none 0s ease 0s');
							$('#game_slots .first_reel .reel').css('transform', 'rotateX('+first_deg+'deg)');
							$('#game_slots .first_reel .reel ').css('transition', '');
							clearInterval(interval2);
							$('#game_slots .second_reel .reel ').css('transition', 'none 0s ease 0s');
							$('#game_slots .second_reel .reel').css('transform', 'rotateX('+second_deg+'deg)');
							$('#game_slots .second_reel .reel ').css('transition', '');
							clearInterval(interval3);
							$('.third_reel .reel ').css('transition', 'none 0s ease 0s');
							$('.third_reel .reel').css('transform', 'rotateX('+third_deg+'deg)');
							$('.third_reel .reel ').css('transition', '');
							if(bet_mode == 'manual') {
								$('#spin_btn span').show();
								$('#spin_btn img').hide();
								setTimeout(function(){
										$('#spin_btn').prop('disabled', false);
								}, 500);
							} else {
								$('#start_auto_spin_btn').show();
								$('#stop_auto_spin_btn').hide();
							}							
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								clearInterval(interval1);
								$('#game_slots .first_reel .reel ').css('transition', 'none 0s ease 0s');
								$('#game_slots .first_reel .reel').css('transform', 'rotateX('+first_deg+'deg)');
								$('#game_slots .first_reel .reel ').css('transition', '');
								clearInterval(interval2);
								$('#game_slots .second_reel .reel ').css('transition', 'none 0s ease 0s');
								$('#game_slots .second_reel .reel').css('transform', 'rotateX('+second_deg+'deg)');
								$('#game_slots .second_reel .reel ').css('transition', '');
								clearInterval(interval3);
								$('#game_slots .third_reel .reel ').css('transition', 'none 0s ease 0s');
								$('#game_slots .third_reel .reel').css('transform', 'rotateX('+third_deg+'deg)');
								$('#game_slots .third_reel .reel ').css('transition', '');
								if(bet_mode == 'manual') {
									$('#spin_btn span').show();
									$('#spin_btn img').hide();
									setTimeout(function(){
											$('#spin_btn').prop('disabled', false);
									}, 500);
								} else {
									$('#start_auto_spin_btn').show();
									$('#stop_auto_spin_btn').hide();
								}
								
							} else {
								var nums = obj.nums;
								deg = nums[0] * 10;
								while(deg > first_deg) {
									deg -= 360;
								}
								first_deg = deg;
								deg = nums[0] * 10;
								while(deg > second_deg) {
									deg -= 360;
								}
								second_deg = deg;
								deg = nums[0] * 10;
								while(deg > third_deg) {
									deg -= 360;
								}
								third_deg = deg;
								setTimeout(function(){
									first_deg = nums[0] * 10;
									clearInterval(interval1);
									$('#game_slots .first_reel .reel ').css('transition', 'none 0s ease 0s');
									$('#game_slots .first_reel .reel').css('transform', 'rotateX('+first_deg+'deg)');
									$('#game_slots .first_reel .reel ').css('transition', '');
								}, 0);
								setTimeout(function(){
									second_deg = nums[1] * 10;
									clearInterval(interval2);
									$('#game_slots .second_reel .reel ').css('transition', 'none 0s ease 0s');
									$('#game_slots .second_reel .reel').css('transform', 'rotateX('+second_deg+'deg)');
									$('#game_slots .second_reel .reel ').css('transition', '');
								}, 100);
								setTimeout(function(){
									third_deg = nums[2] * 10;
									clearInterval(interval3);
									$('#game_slots .third_reel .reel ').css('transition', 'none 0s ease 0s');
									$('#game_slots .third_reel .reel').css('transform', 'rotateX('+third_deg+'deg)');
									$('#game_slots .third_reel .reel ').css('transition', '');
								}, 150);
								setTimeout(function(){
									var payouts = obj.payouts;
									if(payouts[0] != 0 || payouts[1] != 0 || payouts[2] != 0) {
										setTimeout(function(){
											if(payouts[0] != 0) {$('#payout1').html('x'+payouts[0]);} else {$('#payout1').html('');}
											if(payouts[1] != 0) {$('#payout2').html('x'+payouts[1]);} else {$('#payout2').html('');}
											if(payouts[2] != 0) {$('#payout3').html('x'+payouts[2]);} else {$('#payout3').html('');}
											$('#game_slots .slots__result-multiplier').addClass('showing');
											if(bet_mode == 'manual') {
												$('#spin_btn').prop('disabled', false);
												$('#spin_btn span').show();
												$('#spin_btn img').hide();
											}													
										}, 200);
										setTimeout(function(){
											$('.slots__result-multiplier').removeClass('showing');
										}, 2000);
									} else {
										if(bet_mode == 'manual') {
											$('#spin_btn').prop('disabled', false);
											$('#spin_btn span').show();
											$('#spin_btn img').hide();
										}
									}
									$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
									user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
									if(Array.isArray(my_bet_data)) {
										my_bet_data.unshift(obj.bet_data);
									} else {
										my_bet_data = [obj.bet_data];
									}
									if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
										my_bet_data = my_bet_data.slice(0, 20);
									}
									store_bet_data(my_bet_data);
									show_my_bet_data(my_bet_data);
									if(bet_mode == 'auto') {
										if(auto_betting_status == 'running') {
											setTimeout(function(){
												process_bet_game_slots();
											}, 700);
										} else {
											$('#start_auto_spin_btn').show();
											$('#stop_auto_spin_btn').hide();
											$('#stop_auto_spin_btn').html('<img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['stop_auto_spin_btn']?></span>');
										}
									}
								}, 100);
							}
						}
					});
				}, 100);
			}
			
			function start_auto_bet() {
				auto_betting_status = 'running';
				process_bet_game_slots();
			}
			
			function stop_auto_bet() {
				auto_betting_status = 'stopped';
				$('#stop_auto_spin_btn').html('<span><i class="fas fa-hourglass-start"></i> <?=$langs['please_wait_btn']?></span>');
			}
			
			$(document).ready(function() {
				$("#auto_spin").on("change", switch_bet_mode);
				$("#bet_double").on("click", set_bet_double_amount);
				$("#bet_half").on("click", set_bet_half_amount);
				$("#bet_amount").on("change", change_bet_amount);
				$("#num_lines").on("change", change_lines);
				$("#spin_btn").on("click", process_bet_game_slots);
				$("#start_auto_spin_btn").on("click", start_auto_bet);
				$("#stop_auto_spin_btn").on("click", stop_auto_bet);
				
				show_my_bets(my_bet_data);
				$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
				$('#show_all_bets').on('click', show_all_bets);
				
				<?php if(isset($user_info) && $user_info->total_deposits < 0):?>
				document.addEventListener("visibilitychange", function(){
					prepare_for_stopping = setTimeout(function(){
						if(document.hidden) {
							if(auto_betting_status == 'running') {
								stop_auto_bet();
							}
							prepare_for_stopping = false;
						} else {
							clearTimeout(prepare_for_stopping);
						}
					}, 5000);
				}, false);
				<?php endif?>
				
			});
			
		</script>
	</body>
</html>