<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_ultimate']?></h2>
					<div class="game_main row game_ultimate_dice" id="game_ultimate_dice">		
						<div class="col-xs-12">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-12 col-sm-6 bet_amount">
										<div class="input_label"><?=$langs['bet_ammount_label']?></div>
										<div class="input_group" style="height: 44px">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="bet_amount" value="<?=$MIN_BET_AMOUNT?>">
										</div>
										<span id="bet_double" onclick="set_bet_double_amount">2X</span>
										<span id="bet_half" onclick="set_bet_half_amount">1/2</span>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="input_label"><?=$langs['profit_on_win_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="win_profit" value="0.00010000" readonly="readonly">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12">
							<div class="input_container">
								<div class="row">
									<div class="col-sm-6 col-xs-6">
										<div class="input_label"><?=$langs['multiplier_label']?></div>
										<div class="input_group">
											<input type="text" id="multiplier" value="2.00">
											<i class="fas fa-times addon"></i>
										</div>
									</div>
									<div class="col-sm-6 col-xs-6">
										<div class="input_label"><?=$langs['win_chance_label']?></div>
										<div class="input_group">
											<input type="text" id="win_chance" value="48.50">
											<i style="font-size: 12px" class="fas fa-percent addon"></i>
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-xs-12">
							<div class="input_container">
								<div class="row">
									<div class="col-sm-5 col-xs-4">
										<div class="input_label"><?=$langs['game_ultimate_low_label']?></div>
										<div class="input_group">
											<input type="text" id="lower_limit" value="25.75">
										</div>
									</div>
									<div class="col-sm-2 col-xs-4 text-center" id="switch_bet_mode" style="margin-top: 30px; padding: 0px">
										<input type="checkbox" class="jtoggler">
										<div id="bet_on_label" style="font-size: 12px"><?=$langs['bet_on_inside_label']?></div>
									</div>
									<div class="col-sm-5 col-xs-4">
										<div class="input_label"><?=$langs['game_ultimate_high_label']?></div>
										<div class="input_group">
											<input type="text" id="upper_limit" value="74.25">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-3 auto_spin_box">
							<div class="checkbox icheck-info">
								<input type="checkbox" id="auto_dice">
								<label for="auto_dice"><?=$langs['switch_auto']?></label>
							</div>
						</div>
						<div class="col-xs-6">
							<button class="btn bet_btn" id="roll_dice"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['roll_dice_btn']?></span></button>
							<button class="btn bet_btn" id="start_autobet"><span><?=$langs['start_auto_dice_btn']?></span></button>
							<button class="btn bet_btn" id="stop_autobet"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['stop_auto_dice_btn']?></span></button>
						</div>
						<div class="col-xs-3"></div>
						<div class="col-xs-12">
							<div class="slider">
								<div class="min_max">0</div>
								<div class="runway">
									<div class="slider_bar"></div>
									<div class="result_maker">
										<span>62.66</span>
									</div>
									<div class="slider_button"></div>
									<div class="slider_left_button"></div>
									<div class="slider_right_button"></div>
								</div>
								<div class="min_max">100</div>
							</div>
						</div>
						
						<div class="col-xs-12 col-sm-6" id="on_win_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_win_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onwin" name="onwin" checked="checked">
								  <label for="reset_onwin"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onwin" name="onwin">
									  <label for="increase_onwin"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onwin_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6" id="on_loss_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_loss_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onloss" name="onloss" checked="checked">
								  <label for="reset_onloss"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onloss" name="onloss">
									  <label for="increase_onloss"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onloss_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="stop_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="stop_on_profit" value="0.00000000">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_loss_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="stop_on_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-xs-12" id="total_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['number_bets_label']?></div>
										<div class="input_group">
											<input type="text" id="number_rolls" value="0">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['total_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width: 20px; height: 20px; margin-top: 9px"/>
											<input type="text" id="profit_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Ultimate')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Ultimate')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
			const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
			const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
			const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
			const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
			const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
			const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
			
			const MAGIC_NUMBER = 9700;
			const MIN_MULTIPLIER = 1.01;
			const MAX_MULTIPLIER = MAGIC_NUMBER / 2;
			const MIN_WIN_CHANCE = (parseFloat(MAGIC_NUMBER / MAX_MULTIPLIER) / 100);
			const MAX_WIN_CHANCE = (parseFloat(MAGIC_NUMBER / MIN_MULTIPLIER) / 100);
			const MIN_LIMIT = 0;
			const MAX_LIMIT = 99.99;

			var auto_betting_status = 'stopped';
			var profit_loss = 0.00000000;
			var base_bet = 0.00010000;
			var bet_mode = 'manual';
			var bet_on = 'inside';
			var slide_btn_moving = false;
			var slide_left_btn_moving = false;
			var slide_right_btn_moving = false;
			var my_bet_data = [];
			var prepare_for_stopping = false;

		
			function switch_bet_mode() {
				if(auto_betting_status == 'running') {
					return;
				}
				if(bet_mode == 'manual') {
					$('#start_autobet').show();
					$('#roll_dice').hide();
					$('#on_win_box').show();
					$('#on_loss_box').show();
					$('#stop_profit_box').show();
					$('#total_profit_box').show();
					bet_mode = 'auto';
				} else {
					$('#start_autobet').hide();
					$('#roll_dice').show();
					$('#on_win_box').hide();
					$('#on_loss_box').hide();
					$('#stop_profit_box').hide();
					$('#total_profit_box').hide();
					bet_mode = 'manual';
				}
			}
			
			function set_bet_double_amount() {
				if(auto_betting_status == 'running') {
					return;
				}				
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount *= 2;
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}
			
			function set_bet_half_amount() {
				if(auto_betting_status == 'running') {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount /= 2;
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}
			
			function change_bet_amount() {
				var bet_amount = parseFloat($('#bet_amount').val());
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
					 $('#bet_amount').parent().css('border', '2px solid #f44336');
				} else {
					 $('#bet_amount').parent().css('border', '1px solid #DDD');
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
				set_win_profit();
			}
			
			function change_multiplier() {
				var multiplier = parseFloat($('#multiplier').val());
				if(multiplier < MIN_MULTIPLIER || isNaN(multiplier)) {
					multiplier = MIN_MULTIPLIER;
				}
				if(multiplier > MAX_MULTIPLIER) {
					multiplier = MAX_MULTIPLIER;
				}
				multiplier = parseFloat(MAGIC_NUMBER / (10000 - Math.round(10000 - (MAGIC_NUMBER /  multiplier))));
				var win_chance = (Math.round(MAGIC_NUMBER / multiplier) / 100);
				$('#multiplier').val(multiplier.toFixed(2));
				$('#win_chance').val(win_chance.toFixed(2));
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				var average_number = parseFloat((lower_limit + upper_limit) / 2);
				if(bet_on == 'inside') {
					if(average_number > 50 && average_number + parseFloat(win_chance / 2) > 99.99) {
						upper_limit = 99.99;
						lower_limit = upper_limit - win_chance;
					} else if(average_number < 50 && average_number - parseFloat(win_chance / 2) < 0) {
						lower_limit = 0;
						upper_limit = lower_limit + win_chance;
					} else {
						upper_limit = average_number + parseFloat(win_chance / 2);
						lower_limit = average_number - parseFloat(win_chance / 2);
					}
				} else {
					if(average_number > 50 && average_number + parseFloat((100 - win_chance) / 2) > 99.99) {
						upper_limit = 99.99;
						lower_limit = upper_limit - (100 - win_chance);
					} else if(average_number < 50 && average_number - parseFloat((100 - win_chance) / 2) < 0) {
						lower_limit = 0;
						upper_limit = lower_limit + (100 - win_chance);
					} else {
						upper_limit = average_number + parseFloat((100 - win_chance) / 2);
						lower_limit = average_number - parseFloat((100 - win_chance) / 2);
					}
				}
				$('#lower_limit').val(lower_limit.toFixed(2));
				$('#upper_limit').val(upper_limit.toFixed(2));
				set_slide_bar();
				set_win_profit();
			}

			function change_win_chance() {
				var win_chance = parseFloat($('#win_chance').val());
				if(win_chance < MIN_WIN_CHANCE || isNaN(win_chance)) {
					win_chance = MIN_WIN_CHANCE;
				}
				if(win_chance > MAX_WIN_CHANCE) {
					win_chance = MAX_WIN_CHANCE;
				}
				var multiplier = parseFloat(MAGIC_NUMBER / Math.round(win_chance * 100));
				var win_chance = (Math.round(MAGIC_NUMBER / multiplier) / 100);
				$('#multiplier').val(multiplier.toFixed(2));
				$('#win_chance').val(win_chance.toFixed(2));
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				var average_number = parseFloat((lower_limit + upper_limit) / 2);
				if(bet_on == 'inside') {
					if(average_number > 50 && average_number + parseFloat(win_chance / 2) > 99.99) {
						upper_limit = 99.99;
						lower_limit = upper_limit - win_chance;
					} else if(average_number < 50 && average_number - parseFloat(win_chance / 2) < 0) {
						lower_limit = MIN_LIMIT;
						upper_limit = lower_limit + win_chance;
					} else {
						upper_limit = average_number + parseFloat(win_chance / 2);
						lower_limit = average_number - parseFloat(win_chance / 2);
					}
				} else {
					if(average_number > 50 && average_number + parseFloat((100 - win_chance) / 2) > 99.99) {
						upper_limit = MAX_LIMIT;
						lower_limit = upper_limit - (100 - win_chance);
					} else if(average_number < 50 && average_number - parseFloat((100 - win_chance) / 2) < 0) {
						lower_limit = 0;
						upper_limit = lower_limit + (100 - win_chance);
					} else {
						upper_limit = average_number + parseFloat((100 - win_chance) / 2);
						lower_limit = average_number - parseFloat((100 - win_chance) / 2);
					}
				}
				$('#lower_limit').val(lower_limit.toFixed(2));
				$('#upper_limit').val(upper_limit.toFixed(2));
				set_slide_bar();
				set_win_profit();
			}
			
			function change_lower_limit() {
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				var win_chance = 50;
				var multiplier = 1.94;
				if(lower_limit < MIN_LIMIT || isNaN(lower_limit)) {
					lower_limit = MIN_LIMIT;
				}
				if(bet_on == 'inside') {
					if(lower_limit < upper_limit - MAX_WIN_CHANCE) {
						lower_limit = parseFloat(upper_limit - MAX_WIN_CHANCE);
					} else if(lower_limit > upper_limit - MIN_WIN_CHANCE) {
						lower_limit = parseFloat(upper_limit - MIN_WIN_CHANCE);
					}
					win_chance = parseFloat(upper_limit - lower_limit);
				} else {
					if(lower_limit + (100 - upper_limit) > MAX_WIN_CHANCE) {
						lower_limit = parseFloat(MAX_WIN_CHANCE - (100 - upper_limit));
					} else if(lower_limit + (100 - upper_limit) < MIN_WIN_CHANCE) {
						lower_limit = parseFloat(MIN_WIN_CHANCE - (100 - upper_limit));
					}
					win_chance = parseFloat(lower_limit + 100 - upper_limit);
				}
				multiplier = (Math.round(MAGIC_NUMBER / win_chance) / 100);
				$('#lower_limit').val(lower_limit.toFixed(2));
				$('#multiplier').val(multiplier.toFixed(2));
				$('#win_chance').val(win_chance.toFixed(2));
				$('.slider_left_button').css('z-index', 2);
				$('.slider_right_button').css('z-index', 1);
				set_slide_bar();
				set_win_profit();
			}
			
			function change_upper_limit() {
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				var win_chance = 50;
				var multiplier = 1.94;
				if(upper_limit > MAX_LIMIT || isNaN(upper_limit)) {
					upper_limit = MAX_LIMIT;
				}
				
				if(bet_on == 'inside') {
					if(upper_limit > lower_limit + MAX_WIN_CHANCE) {
						upper_limit = parseFloat(MAX_WIN_CHANCE - lower_limit);
					} else if(upper_limit < lower_limit + MIN_WIN_CHANCE) {
						upper_limit = parseFloat(lower_limit + MIN_WIN_CHANCE);
					}
					win_chance = parseFloat(upper_limit - lower_limit);
				} else {
					if(lower_limit + (100 - upper_limit) > MAX_WIN_CHANCE) {
						upper_limit = parseFloat((100 + lower_limit) - MAX_WIN_CHANCE);
					} else if(lower_limit + (100 - upper_limit) < MIN_WIN_CHANCE) {
						upper_limit = parseFloat((100 + lower_limit) - MIN_WIN_CHANCE);
					}
					win_chance = parseFloat(lower_limit + 100 - upper_limit);
				}
				multiplier = (Math.round(MAGIC_NUMBER / win_chance) / 100);
				$('#upper_limit').val(upper_limit.toFixed(2));
				$('#multiplier').val(multiplier.toFixed(2));
				$('#win_chance').val(win_chance.toFixed(2));
				$('.slider_left_button').css('z-index', 1);
				$('.slider_right_button').css('z-index', 2);
				set_slide_bar();
				set_win_profit();
			}
			
			function set_win_profit() {
				var bet_amount = parseFloat($('#bet_amount').val());
				var multiplier = parseFloat($('#multiplier').val());
				var win_profit = (Math.floor(bet_amount * 100000000 * (multiplier - 1) + 0.0001) / 100000000).toFixed(8);
				$('#win_profit').val(win_profit);
			}

			function switch_bet_on(scope) {
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				var win_chance = 50;
				var multiplier = 1.94;
				if(auto_betting_status == 'running') {
					return;
				}
				if(scope == true) {
					$('#bet_on_label').text('<?=$langs['bet_on_outside_label']?>');
					bet_on = 'outside';
					win_chance = parseFloat(lower_limit + 100 - upper_limit);
				} else {
					$('#bet_on_label').text('<?=$langs['bet_on_inside_label']?>');
					bet_on = 'inside';
					win_chance = parseFloat(upper_limit - lower_limit);
				}
				multiplier = (Math.round(MAGIC_NUMBER / win_chance) / 100);
				$('#multiplier').val(multiplier.toFixed(2));
				$('#win_chance').val(win_chance.toFixed(2));
				set_slide_bar();
				set_win_profit();
			}
			
			function set_slide_bar() {
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				var runway = $(".game_main .slider .runway");
				var slider_bar = $(".game_main .slider .runway .slider_bar");
				var slider_button = $(".game_main .slider .runway .slider_button");
				var slider_left_button = $(".game_main .slider .runway .slider_left_button");
				var slider_right_button = $(".game_main .slider .runway .slider_right_button");
				if(bet_on == 'inside') {
					runway.css('background-color', '#f44336');
					slider_bar.css('background-color', '#4caf50');
				} else {
					runway.css('background-color', '#4caf50');
					slider_bar.css('background-color', '#f44336');
				}
				slider_button.css('left', 'calc('+((upper_limit + lower_limit) / 2)+'% - 15px)');
				slider_left_button.css('left', 'calc('+lower_limit+'% - 17px)');
				slider_right_button.css('left', 'calc('+upper_limit+'% - 17px)');
				slider_bar.css('width', (upper_limit - lower_limit)+'%');
				slider_bar.css('margin-left', lower_limit+'%');
				slider_bar.css('border-radius', '5px 5px 5px 5px');
			}
			
			function start_moving_slide_btn() {
				slide_btn_moving = true;
			}
			
			function stop_moving_slide_btn() {
				slide_btn_moving = false;
			}
			
			function move_slide_btn(e, device = 'Mobile') {
				if(auto_betting_status == 'running') {
					return;
				}
				if(device == 'Mobile' || slide_btn_moving) {
					var lower_limit = parseFloat($('#lower_limit').val());
					var upper_limit = parseFloat($('#upper_limit').val());
					var win_chance = parseFloat($('#win_chance').val());
					var slider = $(".game_main .slider .runway");
					var average_number = 0;
					if(device == 'Mobile') {
						average_number = ((e.originalEvent.touches[0].pageX - slider.offset().left) / slider.width() * 100);
					} else {
						average_number = ((e.pageX - slider.offset().left) / slider.width() * 100);
					}
					if(bet_on == 'inside') {
						average_number = Math.min(Math.max(average_number, (win_chance / 2)), MAX_LIMIT - (win_chance / 2));
						lower_limit = average_number - (win_chance / 2);
						upper_limit = average_number + (win_chance / 2);
					} else {
						average_number = Math.min(Math.max(average_number, ((100 - win_chance) / 2)), MAX_LIMIT - ((100 - win_chance) / 2));
						lower_limit = average_number - ((100 - win_chance) / 2);
						upper_limit = average_number + ((100 - win_chance) / 2);
					}
					$('#lower_limit').val(lower_limit.toFixed(2));
					$('#upper_limit').val(upper_limit.toFixed(2));
					set_slide_bar();
				}
				
			}
			
			function start_moving_slide_left_btn() {
				slide_left_btn_moving = true;
			}
			
			function stop_moving_slide_left_btn() {
				slide_left_btn_moving = false;
			}
			
			function move_slide_left_btn(e, device = 'Mobile') {
				if(auto_betting_status == 'running') {
					return;
				}
				if(device == 'Mobile' || slide_left_btn_moving) {
					var slider = $(".game_main .slider .runway");
					if(device == 'Mobile') {
						lower_limit = ((e.originalEvent.touches[0].pageX - slider.offset().left) / slider.width() * 100);
					} else {
						lower_limit = ((e.pageX - slider.offset().left) / slider.width() * 100);
					}
					$('#lower_limit').val(lower_limit.toFixed(2));
					change_lower_limit();
				}
				
			}
			
			function start_moving_slide_right_btn() {
				slide_right_btn_moving = true;
			}
			
			function stop_moving_slide_right_btn() {
				slide_right_btn_moving = false;
			}
			
			function move_slide_right_btn(e, device = 'Mobile') {
				if(auto_betting_status == 'running') {
					return;
				}
				if(device == 'Mobile' || slide_right_btn_moving) {
					var slider = $(".game_main .slider .runway");
					if(device == 'Mobile') {
						upper_limit = ((e.originalEvent.touches[0].pageX - slider.offset().left) / slider.width() * 100);
					} else {
						upper_limit = ((e.pageX - slider.offset().left) / slider.width() * 100);
					}
					$('#upper_limit').val(upper_limit.toFixed(2));
					change_upper_limit();
				}
			}
			
			function process_bet_game_dice() {
				if(auto_betting_status == 'running') {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				var multiplier = parseFloat($('#multiplier').val());
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				$('#roll_dice span').hide();
				$('#roll_dice img').show();
				$("#roll_dice").attr("disabled", !0);
				disable_all_inputs();
				auto_betting_status = 'running';
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_ultimate_dice&bet_amount="+bet_amount+"&lower_limit="+lower_limit+"&upper_limit="+upper_limit+"&bet_on="+bet_on,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							$('#roll_dice span').show();
							$('#roll_dice img').hide();
							$("#roll_dice").attr("disabled", false);
							enable_all_inputs();
							auto_betting_status = 'stopped';
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								$('#roll_dice span').show();
								$('#roll_dice img').hide();
								$("#roll_dice").attr("disabled", false);
								enable_all_inputs();
								auto_betting_status = 'stopped';
							} else {
								if(obj.amount >= 0) {
									$("#game_ultimate_dice .result_maker").removeClass('negative');
								} 
								if(obj.amount < 0) {
									$(".result_maker").addClass('negative');
								}
								$("#game_ultimate_dice .result_maker").show();
								$('#game_ultimate_dice .result_maker span').html(obj.num);
								$('#game_ultimate_dice .result_maker').css('left', 'calc('+parseFloat(obj.num)+'% - 30px)');
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								$('#roll_dice span').show();
								$('#roll_dice img').hide();
							}
							$("#roll_dice").attr("disabled", false);
							enable_all_inputs();
							auto_betting_status = 'stopped';
						}
					});
				}, 100);
			}

			function change_on_win() {
				if($('#increase_onwin').is(':checked')) {
					$('#increase_onwin_by').prop('disabled', false);
					$('#increase_onwin_by').parent().removeClass('disabled');
				} else {
					$('#increase_onwin_by').prop('disabled', true);
					$('#increase_onwin_by').parent().addClass('disabled');
				}
			}

			function change_on_loss() {
				if($('#increase_onloss').is(':checked')) {
					$('#increase_onloss_by').prop('disabled', false);
					$('#increase_onloss_by').parent().removeClass('disabled');
				} else {
					$('#increase_onloss_by').prop('disabled', true);
					$('#increase_onloss_by').parent().addClass('disabled');
				}
			}
			
			function change_increase_onwin_by() {
				var increase_onwin_by = parseInt($('#increase_onwin_by').val());
				if(increase_onwin_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onwin_by)) {
					increase_onwin_by = MIN_BET_INCREASE_PERCENT;
				} else if(increase_onwin_by > MAX_BET_INCREASE_PERCENT) {
					increase_onwin_by = MAX_BET_INCREASE_PERCENT;
				}
				$('#increase_onwin_by').val(increase_onwin_by);
			}
			
			function change_increase_onloss_by() {
				var increase_onloss_by = parseInt($('#increase_onloss_by').val());
				if(increase_onloss_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onloss_by)) {
					increase_onloss_by = MIN_BET_INCREASE_PERCENT;
				} else if(increase_onloss_by > MAX_BET_INCREASE_PERCENT) {
					increase_onloss_by = MAX_BET_INCREASE_PERCENT;
				}
				$('#increase_onloss_by').val(increase_onloss_by);
			}

			function change_stop_on_profit() {
				var stop_on_profit = parseFloat($('#stop_on_profit').val());
				if(stop_on_profit < MIN_STOP_ON_PROFIT || isNaN(stop_on_profit)) {
					stop_on_profit = MIN_STOP_ON_PROFIT;
				} else if(stop_on_profit > MAX_STOP_ON_PROFIT) {
					stop_on_profit = MAX_STOP_ON_PROFIT;
				}
				$('#stop_on_profit').val(stop_on_profit.toFixed(8));
			}

			function change_stop_on_loss() {
				var stop_on_loss = parseFloat($('#stop_on_loss').val());
				if(stop_on_loss < MIN_STOP_ON_PROFIT || isNaN(stop_on_loss)) {
					stop_on_loss = MIN_STOP_ON_PROFIT;
				} else if(stop_on_loss > MAX_STOP_ON_PROFIT) {
					stop_on_loss = MAX_STOP_ON_PROFIT;
				}
				$('#stop_on_loss').val(stop_on_loss.toFixed(8));
			}
			
			function disable_all_inputs() {
				$('#auto_dice').prop('disabled', true);
				$('#bet_amount').prop('disabled', true);
				$('#bet_amount').parent().addClass('disabled');
				$('#win_profit').prop('disabled', true);
				$('#win_profit').parent().addClass('disabled');
				$('#roll_to_win').prop('disabled', true);
				$('#roll_to_win').parent().addClass('disabled');
				$('#multiplier').prop('disabled', true);
				$('#multiplier').parent().addClass('disabled');
				$('#win_chance').prop('disabled', true);
				$('#win_chance').parent().addClass('disabled');
				$('#reset_onwin').prop('disabled', true);
				$('#increase_onwin').prop('disabled', true);
				$('#increase_onwin_by').prop('disabled', true);
				$('#increase_onwin_by').parent().addClass('disabled');
				$('#reset_onloss').prop('disabled', true);
				$('#increase_onloss').prop('disabled', true);
				$('#increase_onloss_by').prop('disabled', true);
				$('#increase_onloss_by').parent().addClass('disabled');	
				$('#stop_on_profit').prop('disabled', true);
				$('#stop_on_profit').parent().addClass('disabled');
				$('#stop_on_loss').prop('disabled', true);
				$('#stop_on_loss').parent().addClass('disabled');
				$('#number_rolls').prop('disabled', true);
				$('#number_rolls').parent().addClass('disabled');
				$('#profit_loss').prop('disabled', true);
				$('#profit_loss').parent().addClass('disabled');
				$('#lower_limit').prop('disabled', true);
				$('#lower_limit').parent().addClass('disabled');
				$('#upper_limit').prop('disabled', true);
				$('#upper_limit').parent().addClass('disabled');
				$('.jtoggler').prop('disabled', true);
			}
			
			function enable_all_inputs() {
				$('#auto_dice').prop('disabled', false);
				$('#bet_amount').prop('disabled', false);
				$('#bet_amount').parent().removeClass('disabled');
				$('#win_profit').prop('disabled', false);
				$('#win_profit').parent().removeClass('disabled');
				$('#roll_to_win').prop('disabled', false);
				$('#roll_to_win').parent().removeClass('disabled');
				$('#multiplier').prop('disabled', false);
				$('#multiplier').parent().removeClass('disabled');
				$('#win_chance').prop('disabled', false);
				$('#win_chance').parent().removeClass('disabled');
				$('#reset_onwin').prop('disabled', false);
				$('#increase_onwin').prop('disabled', false);
				if($('#increase_onwin').is(':checked')) {
					$('#increase_onwin_by').prop('disabled', false);
					$('#increase_onwin_by').parent().removeClass('disabled');
				}
				$('#reset_onloss').prop('disabled', false);
				$('#increase_onloss').prop('disabled', false);
				if($('#increase_onloss').is(':checked')) {
					$('#increase_onloss_by').prop('disabled', false);
					$('#increase_onloss_by').parent().removeClass('disabled');
				} 
				$('#stop_on_profit').prop('disabled', false);
				$('#stop_on_profit').parent().removeClass('disabled');
				$('#stop_on_loss').prop('disabled', false);
				$('#stop_on_loss').parent().removeClass('disabled');
				$('#number_rolls').prop('disabled', false);
				$('#number_rolls').parent().removeClass('disabled');
				$('#profit_loss').prop('disabled', false);
				$('#profit_loss').parent().removeClass('disabled');
				$('#lower_limit').prop('disabled', false);
				$('#lower_limit').parent().removeClass('disabled');
				$('#upper_limit').prop('disabled', false);
				$('#upper_limit').parent().removeClass('disabled');
				$('.jtoggler').prop('disabled', false);
			}
			
			function process_auto_bet_game_dice() {
				if(auto_betting_status != 'running') {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				var multiplier = parseFloat($('#multiplier').val());
				var lower_limit = parseFloat($('#lower_limit').val());
				var upper_limit = parseFloat($('#upper_limit').val());
				var on_win = null;
				var increase_onwin_by = 0;
				var on_loss = null;
				var increase_onloss_by = 0;
				var stop_on_profit = 0;
				var stop_on_loss = 0;
				var number_rolls = parseInt($('#number_rolls').val());
				if($('#increase_onwin').is(':checked')) {
					on_win = 'increase_onwin';
					increase_onwin_by = parseInt($('#increase_onwin_by').val());
				} else {
					on_win = 'reset_onwin';
				}
				if($('#increase_onloss').is(':checked')) {
					on_loss = 'increase_onloss';
					increase_onloss_by = parseInt($('#increase_onloss_by').val());
				} else {
					on_loss = 'reset_onloss';
				}
				stop_on_profit = parseFloat($('#stop_on_profit').val());
				stop_on_loss = parseFloat($('#stop_on_loss').val());
				
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_ultimate_dice&bet_amount="+bet_amount+"&lower_limit="+lower_limit+"&upper_limit="+upper_limit+"&bet_on="+bet_on,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							stop_auto_bet();
						},
						success: function(out){
							obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								stop_auto_bet();
							} else {
								if(obj.amount >= 0) {
									$("#game_ultimate_dice .result_maker").removeClass('negative');
								} 
								if(obj.amount < 0) {
									$("#game_ultimate_dice .result_maker").addClass('negative');
								} 
								profit_loss = parseFloat((profit_loss * 100000000 +  parseInt(obj.amount)) / 100000000).toFixed(8);
								$('#profit_loss').val(profit_loss);
								
								if(profit_loss > 0) {
									$('#profit_loss').css('color', '#03a9f4');
								} else if(profit_loss < 0) {
									$('#profit_loss').css('color', '#e91e63');
								} else {
									$('#profit_loss').css('color', '#333');
								}
								$("#game_ultimate_dice .result_maker").show();
								$('#game_ultimate_dice .result_maker span').html(obj.num);
								$('#game_ultimate_dice .result_maker').css('left', 'calc('+parseFloat(obj.num)+'% - 30px)');
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								if(obj.amount >= 0) {
									if(on_win == 'reset_onwin') {
										bet_amount = base_bet;
									} else if(on_win == 'increase_onwin') {
										bet_amount =  parseFloat(bet_amount * (1 + increase_onwin_by / 100));
									}
								} else {
									if(on_loss == 'reset_onloss') {
										bet_amount = base_bet;
									} else if(on_loss == 'increase_onloss') {
										bet_amount =  parseFloat(bet_amount * (1 + increase_onloss_by / 100));
									}
								}
								$('#bet_amount').val(bet_amount.toFixed(8));
								$('#number_rolls').val(number_rolls+1);
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								if((stop_on_profit > 0 && profit_loss >= stop_on_profit) 
								|| (stop_on_loss > 0 && profit_loss <= -stop_on_loss)) {
									stop_auto_bet();
								} else {
									process_auto_bet_game_dice();
								}
							}
						}
					});
				}, 300);
			}
			
			function start_auto_bet() {
				$('#start_autobet').hide();
				$('#stop_autobet').show();
				$('#number_rolls').val(0);
				auto_betting_status = 'running';
				profit_loss = 0.00000000;
				base_bet = parseFloat($('#bet_amount').val());
				$('#profit_loss').val(profit_loss.toFixed(8));
				$('#profit_loss').css('color', '#333');
				disable_all_inputs();
				process_auto_bet_game_dice();
			}
			
			function stop_auto_bet() {
				auto_betting_status = 'stopped';
				enable_all_inputs();
				$('#stop_autobet').hide();
				$('#start_autobet').show();
			}
			
			function game_dice_key_down(e) {
				if(e.key == 'w' && auto_betting_status == 'stopped') {
					e.preventDefault();
					set_bet_double_amount();
				} else if(e.key == 's' && auto_betting_status == 'stopped') {
					e.preventDefault();
					set_bet_half_amount();
				} else if(e.key == 'a' && bet_mode == 'manual') {
					e.preventDefault();
					process_bet_game_dice('inside');
				} else if (e.key == 'd' && bet_mode == 'manual') {
					e.preventDefault();
					process_bet_game_dice('lower');
				} else if(e.keyCode == 32 && bet_mode == 'auto' && auto_betting_status == 'stopped') {
					e.preventDefault();
					start_auto_bet();
				} else if (e.keyCode == 32 && bet_mode == 'auto' && auto_betting_status == 'running') {	
					e.preventDefault();
					stop_auto_bet();
				}
			}
			
			$(document).ready(function() {
				change_multiplier();

				$("#auto_dice").on("change", switch_bet_mode);
				$("#bet_double").on("click", set_bet_double_amount);
				$("#bet_half").on("click", set_bet_half_amount);
				$("#bet_amount").on("change", change_bet_amount);
				$("#multiplier").on("change", change_multiplier);
				$("#win_chance").on("change", change_win_chance);
				
				$("#lower_limit").on("change", change_lower_limit);
				$("#upper_limit").on("change", change_upper_limit);
				
				
				$("#bet_on_lower_btn").on("click", function(){process_bet_game_dice()});
				$("#roll_dice").on("click", process_bet_game_dice);
				$("#start_autobet").on("click", start_auto_bet);
				$("#stop_autobet").on("click", stop_auto_bet);
				$("input[type=radio][name=onwin]").on("change", change_on_win);
				$("input[type=radio][name=onloss]").on("change", change_on_loss);
				$("#increase_onwin_by").on("change", change_increase_onwin_by);
				$("#increase_onloss_by").on("change", change_increase_onloss_by);
				$("#stop_on_profit").on("change", change_stop_on_profit);
				$("#stop_on_loss").on("change", change_stop_on_loss);
				
				
				$(".game_main .slider .runway .slider_button").on("mousedown", start_moving_slide_btn);
				$(document).on("mouseup", stop_moving_slide_btn);
				$(document).mousemove(function(e) {move_slide_btn(e, 'PC');});
				$(".game_main .slider .runway .slider_button").on("touchmove", function(e) {move_slide_btn(e, 'Mobile');});
				
				$(".game_main .slider .runway .slider_left_button").on("mousedown", start_moving_slide_left_btn);
				$(document).on("mouseup", stop_moving_slide_left_btn);
				$(document).mousemove(function(e) {move_slide_left_btn(e, 'PC');});
				$(".game_main .slider .runway .slider_left_button").on("touchmove", function(e) {move_slide_left_btn(e, 'Mobile');});
				
				$(".game_main .slider .runway .slider_right_button").on("mousedown", start_moving_slide_right_btn);
				$(document).on("mouseup", stop_moving_slide_right_btn);
				$(document).mousemove(function(e) {move_slide_right_btn(e, 'PC');});
				$(".game_main .slider .runway .slider_right_button").on("touchmove", function(e) {move_slide_right_btn(e, 'Mobile');});
				
				
				show_my_bets(my_bet_data);
				$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
				$('#show_all_bets').on('click', show_all_bets);
				
				<?php if(isset($user_info) && $user_info->total_deposits < 0):?>
				document.addEventListener("visibilitychange", function(){
					prepare_for_stopping = setTimeout(function(){
						if(document.hidden) {
							if(auto_betting_status == 'running') {
								stop_auto_bet();
							}
							prepare_for_stopping = false;
						} else {
							clearTimeout(prepare_for_stopping);
						}
					}, 5000);
				}, false);
				<?php endif?>
				
			});
		</script>
		
		<script>
		$(function(){
			$('.jtoggler').jtoggler();
		});
		$(document).on('jt:toggled', function (event, target) {
			var scope = $(target).prop('checked');
			switch_bet_on(scope);
		});
		</script>
	</body>
</html>