<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<style>
			.game_result_wrap {
				font-size: 0.875rem;
				border-radius: 10px;
				text-align: center;
				position: absolute;
				width: 150px;
				height: 85px;
				left: calc(50% - 75px);
				top: calc(50% - 17.5px);
				border: 4px solid;
				box-shadow: 0 10px 15px -3px rgba(0, 0, 0, .2), 0 4px 6px -2px rgba(0, 0, 0, .1);
				z-index: 100;
				display: none;
				border-color: #00e701;
				color:  #00e701;
				background-image: url(<?=base_url()?>assets/img/games/3440162.png) !important;
				background-repeat: repeat;
			}
			.dark_mode .game_result_wrap {
				background: #1a2c38;
			}
			.game_result_wrap .multiplier {
				font-size: 25px;
				font-weight: 600;
				width: 100%;
				margin-top: 5px;
			}
			.game_result_wrap .win_amount {
				font-size: 14px;
			}
		</style>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
					<h2><?=$langs['game_wof']?></h2>
					<div class="game_main row" style="width: 100%; max-width: 550px">
						<div class="col-xs-12 bet_amount">
							<div class="input_label"><?=$langs['bet_ammount_label']?></div>
							<div class="input_group">
								<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px">
								<input type="text" id="bet_amount" value="<?=$MIN_BET_AMOUNT?>">
							</div>
							<span id="bet_double">2X</span>
							<span id="bet_half">1/2</span>
						</div>
						<div class="col-xs-12">
							<div id="wheel-main">
								<div class="wheel-container">
									<div class="wheel" style=""></div>
									<div class="wheel-shadow"></div>
									<div class="wheel-mask"></div>
									<div class="wheel-pointer"></div>
									<div class="wheel-center"></div>
								</div>
								<!--<div class="game_wheel_result">
									<span class="profit"></span>
								</div>-->
								<div class="game_result_wrap">
									<div class="multiplier"></div>
									<div class="win_amount"></div>
								</div>
							</div>
							
						</div>
						<div class="col-xs-3 auto_dice_box">
							<div class="checkbox icheck-info">
								<input type="checkbox" id="auto_dice">
								<label for="auto_dice"><?=$langs['switch_auto']?></label>
							</div>
						</div>
						<div class="col-xs-6">
							<button class="btn bet_btn" id="process_bet_game_wheel"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px; display: none"><span><?=$langs['spin_btn']?></span></button>
							<button class="btn bet_btn" id="start_autobet"><span><?=$langs['start_auto_spin_btn']?></span></button>
							<button class="btn bet_btn" id="stop_autobet"><img src="<?=base_url()?>assets/img/loading.gif" style="width: 35px"><span><?=$langs['stop_auto_spin_btn']?></span></button>
						</div>
						
						<div class="col-xs-12 col-sm-6" id="on_win_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_win_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onwin" name="onwin" checked="checked">
								  <label for="reset_onwin"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onwin" name="onwin">
									   <label for="increase_onwin"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onwin_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12 col-sm-6" id="on_loss_box">
							<div class="input_container">
								<div class="input_label"><?=$langs['on_loss_label']?></div>
								<div class="radio icheck-success">
								  <input type="radio" id="reset_onloss" name="onloss" checked="checked">
								  <label for="reset_onloss"><?=$langs['reset_bet_label']?></label>
								</div>
								<div style="display: flex">
									<div class="radio icheck-success">
									  <input type="radio" id="increase_onloss" name="onloss">
									  <label for="increase_onloss"><?=$langs['increase_bet_amount']?></label>
									</div>
									<div class="input_group disabled" style="width: 100px; margin-left: 15px; margin-top: -5px">
										<input type="text" id="increase_onloss_by" value="100" disabled="">
										<i style="font-size: 12px" class="fas fa-percent addon"></i>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="stop_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px">
											<input type="text" id="stop_on_profit" value="0.00000000">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['stop_on_loss_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px">
											<input type="text" id="stop_on_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-xs-12" id="total_profit_box">
							<div class="input_container">
								<div class="row">
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['number_rolls_label']?></div>
										<div class="input_group">
											<input type="text" id="number_rolls" value="0">
										</div>
									</div>
									<div class="col-xs-6">
										<div class="input_label"><?=$langs['total_profit_label']?></div>
										<div class="input_group">
											<img src="<?=base_url()?>assets/img/dogecoin.svg" style="width:16px">
											<input type="text" id="profit_loss" value="0.00000000">
										</div>
									</div>
								</div>
							</div>
						</div>
						
					</div>
					<div class="gameBar_wrap">
						<ul class="gameBar_main clear">
							<li class="left gameBar_li" onclick="show_game_rules('Wheel')">
								<div class="footer_wrap"><i class="fas fa-book"></i></div>
								<span class="footer_text"><?=$langs['game_rules_label']?></span>
							</li>
							<li class="left gameBar_li" onclick="show_game_fairness('Wheel')">
								<div class="footer_wrap"><i class="fas fa-balance-scale"></i></div>
								<span class="footer_text"><?=$langs['game_fairness_label']?></span>
							</li>
							<?php if(false):?>
							<li class="left gameBar_li">
								<div class="footer_wrap"><i class="fas fa-keyboard"></i></div>
								<span class="footer_text"><?=$langs['game_hotkeys_label']?></span>
							</li>
							<?php endif?>
						</ul>
					</div>
					<div class="bets_nav" style="width: 192px">
						<ul class="clear">
							<li class="left li_active" id="show_my_bets"><?=$langs['MY_BETS']?></li>
							<li class="left" id="show_all_bets"><?=$langs['ALL_BETS']?></li>
							<?php if(false):?><li class="left"><?=$langs['HIGH_WINS']?></li><?php endif?>
						</ul>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto;" id="my_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
					<div style="width: calc(100% - 20px); margin-left: 10px; overflow-x: auto; display: none" id="all_bets_table">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['bet_tbl_time']?></td>
									<td><?=$langs['bet_tbl_game']?></td>
									<td><?=$langs['bet_tbl_user']?></td>
									<td><?=$langs['bet_tbl_bet_amount']?></td>
									<td><?=$langs['bet_tbl_multiplier']?></td>
									<td><?=$langs['bet_tbl_profit']?></td>
								</tr>
							</thead>
							<tbody></tbody>
						</table>
					</div>
				</div>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			var user_balance = <?=number_format($user_info->balance / 100000000, 8, '.', '')?>;
			const MIN_BET_AMOUNT = <?=$MIN_BET_AMOUNT?>;
			const MAX_BET_AMOUNT = <?=$MAX_BET_AMOUNT?>;
			const MIN_BET_INCREASE_PERCENT = <?=$MIN_BET_INCREASE_PERCENT?>;
			const MAX_BET_INCREASE_PERCENT = <?=$MAX_BET_INCREASE_PERCENT?>;
			const MIN_STOP_ON_PROFIT = <?=$MIN_STOP_ON_PROFIT?>;
			const MAX_STOP_ON_PROFIT = <?=$MAX_STOP_ON_PROFIT?>;
			
			var my_bet_data = [];
			var current_idx = 0;
			var hide_result = '';
			var auto_betting_status = 'stopped';
			var bet_mode = 'manual';
			var prepare_for_stopping = false;
			
			function set_bet_double_amount() {
				if(auto_betting_status == 'running') {
					return;
				}				
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount *= 2;
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function set_bet_half_amount() {
				if(auto_betting_status == 'running') {
					return;
				}
				var bet_amount = parseFloat($('#bet_amount').val());
				bet_amount /= 2;
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				$('#bet_amount').val(bet_amount.toFixed(8));
			}
			
			function change_bet_amount() {
				var bet_amount = parseFloat($('#bet_amount').val());
				if(bet_amount < MIN_BET_AMOUNT || isNaN(bet_amount)) {
					bet_amount = MIN_BET_AMOUNT;
				}
				if(bet_amount > Math.min(MAX_BET_AMOUNT, user_balance)) {
					//bet_amount = Math.min(MAX_BET_AMOUNT, user_balance);
					 $('#bet_amount').parent().css('border', '2px solid #f44336');
				} else {
					 $('#bet_amount').parent().css('border', '1px solid #DDD');
				}
				setTimeout(function() {
					$('#bet_amount').val(bet_amount.toFixed(8));
				}, 100);
			}
			
			function switch_bet_mode() {
				if(auto_betting_status == 'running') {
					return;
				}
				if(bet_mode == 'manual') {
					$('#on_win_box').show();
					$('#on_loss_box').show();
					$('#stop_profit_box').show();
					$('#total_profit_box').show();
					$('#start_autobet').show();
					$('#process_bet_game_wheel').hide();
					bet_mode = 'auto';
				} else {
					$('#on_win_box').hide();
					$('#on_loss_box').hide();
					$('#stop_profit_box').hide();
					$('#total_profit_box').hide();
					$('#start_autobet').hide();
					$('#process_bet_game_wheel').show();
					bet_mode = 'manual';
				}
			}
			
			function change_on_win() {
				if($('#increase_onwin').is(':checked')) {
					$('#increase_onwin_by').prop('disabled', false);
					$('#increase_onwin_by').parent().removeClass('disabled');
				} else {
					$('#increase_onwin_by').prop('disabled', true);
					$('#increase_onwin_by').parent().addClass('disabled');
				}
			}

			function change_on_loss() {
				if($('#increase_onloss').is(':checked')) {
					$('#increase_onloss_by').prop('disabled', false);
					$('#increase_onloss_by').parent().removeClass('disabled');
				} else {
					$('#increase_onloss_by').prop('disabled', true);
					$('#increase_onloss_by').parent().addClass('disabled');
				}
			}
			
			function change_increase_onwin_by() {
				var increase_onwin_by = parseInt($('#increase_onwin_by').val());
				if(increase_onwin_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onwin_by)) {
					increase_onwin_by = MIN_BET_INCREASE_PERCENT;
				} else if(increase_onwin_by > MAX_BET_INCREASE_PERCENT) {
					increase_onwin_by = MAX_BET_INCREASE_PERCENT;
				}
				$('#increase_onwin_by').val(increase_onwin_by);
			}
			
			function change_increase_onloss_by() {
				var increase_onloss_by = parseInt($('#increase_onloss_by').val());
				if(increase_onloss_by < MIN_BET_INCREASE_PERCENT || isNaN(increase_onloss_by)) {
					increase_onloss_by = MIN_BET_INCREASE_PERCENT;
				} else if(increase_onloss_by > MAX_BET_INCREASE_PERCENT) {
					increase_onloss_by = MAX_BET_INCREASE_PERCENT;
				}
				$('#increase_onloss_by').val(increase_onloss_by);
			}

			function change_stop_on_profit() {
				var stop_on_profit = parseFloat($('#stop_on_profit').val());
				if(stop_on_profit < MIN_STOP_ON_PROFIT || isNaN(stop_on_profit)) {
					stop_on_profit = MIN_STOP_ON_PROFIT;
				} else if(stop_on_profit > MAX_STOP_ON_PROFIT) {
					stop_on_profit = MAX_STOP_ON_PROFIT;
				}
				$('#stop_on_profit').val(stop_on_profit.toFixed(8));
			}

			function change_stop_on_loss() {
				var stop_on_loss = parseFloat($('#stop_on_loss').val());
				if(stop_on_loss < MIN_STOP_ON_PROFIT || isNaN(stop_on_loss)) {
					stop_on_loss = MIN_STOP_ON_PROFIT;
				} else if(stop_on_loss > MAX_STOP_ON_PROFIT) {
					stop_on_loss = MAX_STOP_ON_PROFIT;
				}
				$('#stop_on_loss').val(stop_on_loss.toFixed(8));
			}
			
			function disable_all_inputs() {
				$('#auto_dice').prop('disabled', true);
				$('#bet_amount').prop('disabled', true);
				$('#bet_amount').parent().addClass('disabled');
				$('#reset_onwin').prop('disabled', true);
				$('#increase_onwin').prop('disabled', true);
				$('#increase_onwin_by').prop('disabled', true);
				$('#increase_onwin_by').parent().addClass('disabled');
				$('#reset_onloss').prop('disabled', true);
				$('#increase_onloss').prop('disabled', true);
				$('#increase_onloss_by').prop('disabled', true);
				$('#increase_onloss_by').parent().addClass('disabled');	
				$('#stop_on_profit').prop('disabled', true);
				$('#stop_on_profit').parent().addClass('disabled');
				$('#stop_on_loss').prop('disabled', true);
				$('#stop_on_loss').parent().addClass('disabled');
				$('#number_rolls').prop('disabled', true);
				$('#number_rolls').parent().addClass('disabled');
				$('#profit_loss').prop('disabled', true);
				$('#profit_loss').parent().addClass('disabled');
			}
			
			function enable_all_inputs() {
				$('#auto_dice').prop('disabled', false);
				$('#bet_amount').prop('disabled', false);
				$('#bet_amount').parent().removeClass('disabled');
				$('#reset_onwin').prop('disabled', false);
				$('#increase_onwin').prop('disabled', false);
				if($('#increase_onwin').is(':checked')) {
					$('#increase_onwin_by').prop('disabled', false);
					$('#increase_onwin_by').parent().removeClass('disabled');
				}
				$('#reset_onloss').prop('disabled', false);
				$('#increase_onloss').prop('disabled', false);
				if($('#increase_onloss').is(':checked')) {
					$('#increase_onloss_by').prop('disabled', false);
					$('#increase_onloss_by').parent().removeClass('disabled');
				} 
				$('#stop_on_profit').prop('disabled', false);
				$('#stop_on_profit').parent().removeClass('disabled');
				$('#stop_on_loss').prop('disabled', false);
				$('#stop_on_loss').parent().removeClass('disabled');
				$('#number_rolls').prop('disabled', false);
				$('#number_rolls').parent().removeClass('disabled');
				$('#profit_loss').prop('disabled', false);
				$('#profit_loss').parent().removeClass('disabled');
			}
			
			
			function process_bet_game_wheel() {
				var bet_amount = parseFloat($('#bet_amount').val());
				var wheel_multiply = [3, 0, 1.5, 0, 2.5, 0, 1, 0, 2, 0, 1.5, 0];
				var index1 = current_idx;
				var index2 = 0;
				var deg1 = index1 * 30;
				var deg2 = 0;
				$('.game_result_wrap').hide();
				$("#process_bet_game_wheel").attr("disabled", true);
				$('#process_bet_game_wheel span').hide();
				$('#process_bet_game_wheel img').show();
				clearTimeout(hide_result);
				
				var interval = setInterval(function(){
					deg1 += 30;
					index1 = Math.round(deg1 / 30) % 12;
					$('.wheel').css('transform', 'rotate('+deg1+'deg)');
					$('.wheel').css('transition', '-webkit-transform 50ms cubic-bezier(0, 0, 1, 1) 0s');
				}, 50);

				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_wheel&bet_amount="+bet_amount,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							clearInterval(interval);
							index2 = index1;
							current_idx = index2;
							$("#process_bet_game_wheel").attr("disabled", false);
							$('#process_bet_game_wheel span').show();
							$('#process_bet_game_wheel img').hide();
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								clearInterval(interval);
								index2 = index1;
								current_idx = index2;
								$("#process_bet_game_wheel").attr("disabled", false);
								$('#process_bet_game_wheel span').show();
								$('#process_bet_game_wheel img').hide();
							} else {
								index2 = obj.index;
								current_idx = index2;
								if(index2 < index1) {
									deg2 = deg1 + (index2 - index1) * 30;
								} else {
									deg2 = deg1 + (12 + index2 - index1) * 30;
								}
								$('.wheel').css('transform', 'rotate('+deg2+'deg)');
								$('.wheel').css('transition', '-webkit-transform 0ms');
								$("#process_bet_game_wheel").attr("disabled", false);
								$('#process_bet_game_wheel span').show();
								$('#process_bet_game_wheel img').hide();
								clearInterval(interval);
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								if(obj.win_amount > 0) {
									$('.game_result_wrap').show();
									$('.game_result_wrap .multiplier').html(obj.bet_data.payout);
									$('.game_result_wrap .win_amount').text(parseFloat((parseInt(obj.win_amount)) / 100000000).toFixed(8));
								}
							}
						}
					});
				}, 100);
			}
			
			function process_auto_bet_game_wheel(bet_amount) {
				if(auto_betting_status != 'running') {
					return;
				}
				var on_win = null;
				var increase_onwin_by = 0;
				var on_loss = null;
				var increase_onloss_by = 0;
				var stop_on_profit = 0;
				var stop_on_loss = 0;
				var number_rolls = parseInt($('#number_rolls').val());
				$('.game_result_wrap').hide();
				if($('#increase_onwin').is(':checked')) {
					on_win = 'increase_onwin';
					increase_onwin_by = parseInt($('#increase_onwin_by').val());
				} else {
					on_win = 'reset_onwin';
				}
				if($('#increase_onloss').is(':checked')) {
					on_loss = 'increase_onloss';
					increase_onloss_by = parseInt($('#increase_onloss_by').val());
				} else {
					on_loss = 'reset_onloss';
				}
				stop_on_profit = parseFloat($('#stop_on_profit').val());
				stop_on_loss = parseFloat($('#stop_on_loss').val());
				
				var index1 = current_idx;
				var index2 = 0;
				var deg1 = index1 * 30;
				var deg2 = 0;
				clearTimeout(hide_result);
				
				var interval = setInterval(function(){
					deg1 += 30;
					index1 = Math.round(deg1 / 30) % 12;
					$('.wheel').css('transform', 'rotate('+deg1+'deg)');
					$('.wheel').css('transition', '-webkit-transform 50ms cubic-bezier(0, 0, 1, 1) 0s');
				}, 50);
				
				setTimeout(function() {
					$.ajax({
						url: "<?=base_url()?>process.php",
						type: "POST",
						data: "action=bet_game_wheel&bet_amount="+bet_amount,
						error: function(){
							$.toast({
								heading: 'Error!',
								text: 'Request timed out. Please try again!',
								showHideTransition: 'slide',
								position: 'top-right',
								icon: 'error'
							});
							clearInterval(interval);
							index2 = index1;
							current_idx = index2;
							stop_auto_bet();
						},
						success: function(out){
							let obj = JSON.parse(out);
							if(obj.ret == 0) {
								$.toast({
									heading: 'Error!',
									text: obj.mes,
									showHideTransition: 'slide',
									position: 'top-right',
									icon: 'error'
								});
								clearInterval(interval);
								index2 = index1;
								current_idx = index2;
								stop_auto_bet();
							} else {
								index2 = obj.index;
								current_idx = index2;
								if(index2 < index1) {
									deg2 = deg1 + (index2 - index1) * 30;
								} else {
									deg2 = deg1 + (12 + index2 - index1) * 30;
								}
								$('.wheel').css('transform', 'rotate('+deg2+'deg)');
								$('.wheel').css('transition', '-webkit-transform 0ms');
								$("#process_bet_game_wheel").attr("disabled", false);
								$('#process_bet_game_wheel span').show();
								$('#process_bet_game_wheel img').hide();
								clearInterval(interval);
								$('.user_balance').text(parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8));
								user_balance = parseFloat((parseInt(obj.balance)) / 100000000).toFixed(8);
								if(Array.isArray(my_bet_data)) {
									my_bet_data.unshift(obj.bet_data);
								} else {
									my_bet_data = [obj.bet_data];
								}
								if (Array.isArray(my_bet_data) && my_bet_data.length > 20) {
									my_bet_data = my_bet_data.slice(0, 20);
								}
								store_bet_data(my_bet_data);
								show_my_bet_data(my_bet_data);
								if(obj.win_amount > 0) {
									$('.game_result_wrap').show();
									$('.game_result_wrap .multiplier').html(obj.bet_data.payout);
									$('.game_result_wrap .win_amount').text(parseFloat((parseInt(obj.win_amount)) / 100000000).toFixed(8));
								}
								
								if(obj.win_amount > 0) {
									if(on_win == 'reset_onwin') {
										bet_amount = base_bet;
									} else if(on_win == 'increase_onwin') {
										bet_amount =  parseFloat(bet_amount * (1 + increase_onwin_by / 100));
									}
								} else if(obj.win_amount < 0) {
									if(on_loss == 'reset_onloss') {
										bet_amount = base_bet;
									} else if(on_loss == 'increase_onloss') {
										bet_amount =  parseFloat(bet_amount * (1 + increase_onloss_by / 100));
									}
								}
								$('#bet_amount').val(bet_amount.toFixed(8));
								$('#number_rolls').val(number_rolls+1);
								profit_loss = parseFloat((profit_loss * 100000000 +  parseInt(obj.win_amount)) / 100000000).toFixed(8);
								$('#profit_loss').val(profit_loss);
								
								if((stop_on_profit > 0 && profit_loss >= stop_on_profit) 
								|| (stop_on_loss > 0 && profit_loss <= -stop_on_loss)) {
									stop_auto_bet();
								} else {
									setTimeout(function(){
										process_auto_bet_game_wheel(bet_amount);
									}, 1000);
								}
							}
						}
					});
				}, 100);
			}
			
			function start_auto_bet() {
				$('#start_autobet').hide();
				$('#stop_autobet').show();
				$('#number_rolls').val(0);
				auto_betting_status = 'running';
				profit_loss = 0.000000000;
				base_bet = parseFloat($('#bet_amount').val());
				$('#profit_loss').val(profit_loss.toFixed(8));
				$('#profit_loss').css('color', '#333');
				disable_all_inputs();
				process_auto_bet_game_wheel(parseFloat($('#bet_amount').val()));
			}
			
			function stop_auto_bet() {
				auto_betting_status = 'stopped';
				enable_all_inputs();
				$('#stop_autobet').hide();
				$('#start_autobet').show();
			}

			
			$(document).ready(function() {
		
				$("#auto_dice").on("change", switch_bet_mode);
				$("#bet_double").on("click", set_bet_double_amount);
				$("#bet_half").on("click", set_bet_half_amount);
				$("#bet_amount").on("change", change_bet_amount);
				$("input[type=radio][name=onwin]").on("change", change_on_win);
				$("input[type=radio][name=onloss]").on("change", change_on_loss);
				$("#increase_onwin_by").on("change", change_increase_onwin_by);
				$("#increase_onloss_by").on("change", change_increase_onloss_by);
				$("#stop_on_profit").on("change", change_stop_on_profit);
				$("#stop_on_loss").on("change", change_stop_on_loss);
				$("#process_bet_game_wheel").on("click",process_bet_game_wheel);
				$("#start_autobet").on("click", start_auto_bet);
				$("#stop_autobet").on("click", stop_auto_bet);
				
				show_my_bets(my_bet_data);
				$('#show_my_bets').on('click', function(){show_my_bets(my_bet_data);});
				$('#show_all_bets').on('click', show_all_bets);
				
				<?php if(isset($user_info) && $user_info->total_deposits < 0):?>
				document.addEventListener("visibilitychange", function(){
					prepare_for_stopping = setTimeout(function(){
						if(document.hidden) {
							if(auto_betting_status == 'running') {
								stop_auto_bet();
							}
							prepare_for_stopping = false;
						} else {
							clearTimeout(prepare_for_stopping);
						}
					}, 5000);
				}, false);
				<?php endif?>
				
			});
			
		</script>
	</body>
</html>