<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<body>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100">
			<div class="container"> 
				<div class="single_title_n"> 
					<div class="row">
						<div class="col-lg-12">
							<div class="form-wrapper" style="margin-top: 50px; text-align: left">
								<div class="form-wrapper__inner">
									<div class="form-wrapper__main">
										<div class="form-wrapper__copy">
											<h1><?=$langs['login_page_heading']?></h1>
											<p><?=$langs['not_member']?></p>
										</div>
										<div class="form__input-wrapper">
											<label class="form__label" for="email"><?=$langs['form_email_label']?></label>
											<div class="form__input-container">
												<input class="form__input" type="email" id="user_email" name="user_email" placeholder="<?=$langs['type_email']?>" value="<?=$email?>" autocomplete="off" spellcheck="false">
												<span class="form__input-icon"><i class="fas fa-envelope"></i></span>
											</div>
										</div>
										<div class="form__input-wrapper">
											<label class="form__label" for="email"><?=$langs['form_password_label']?></label>
											<div class="form__input-container">
												<input class="form__input" type="password" id="password" name="password" placeholder="<?=$langs['type_password']?>" autocomplete="off">
												<input class="form__input" type="hidden" maxlength="14" id="referrer" name="referrer" value="<?=$referrer?>">
												<span class="form__input-icon"><i class="fas fa-lock"></i></span>
											</div>
											<span class="form__note"><a style="margin-top:7px;font-size:12px" href="<?=base_url()?>recover.php"><?=$langs['forgot_password']?></a></span>
										</div>
										<div class="form__input-wrapper">
											<label class="form__label" for="email"><?=$langs['form_2FA_label']?></label>
											<div class="form__input-container">
												<input class="form__input" type="text" maxlength="6" id="twofa" name="twofa" placeholder="<?=$langs['type_2fa']?>" autocomplete="off">
												<span class="form__input-icon"><i class="fas fa-code"></i></span>
											</div>
											<span class="form__note"><a style="margin-top:7px;font-size:12px" href="<?=base_url()?>disable_2fa.php"><?=$langs['forgot_2FA']?></a></span>
										</div>
										
										
										<?php echo render_all_captcha_widgets(3, $gg_site_key, $cloudflare_site_key);?>
										
										<div class="form__input-wrapper form__submit">
											<button class="btn" id="process_login" onclick="process_login2()" style="width: 150px"><?=$langs['login_btn']?></button>
											<p class="form__note"><i class="fas fa-shield-alt"></i> <?=$langs['login_secure']?></p>
										</div>
									</div>
									<div class="form-wrapper__aside">
										<div class="form-wrapper__logo"><img src="<?=base_url()?>assets/img/dogepick_logo.png" id="main_logo" id="main_logo" alt="dogepick.io"></div>
										<div class="form-wrapper__aside-copy">
											<?=$langs['login_page_desc']?>
										</div>
										<div class="form-wrapper__bonus"></div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>  
		<?php include('scripts.php');?>
	</body>
</html>

<script>
function process_login2() {
  const email = $('#user_email').val();
  const password = $('#password').val();
  const twofa = $('#twofa').val();
  const captcha = collectCaptchaData();

  const $btn = $("#process_login");
  $btn.attr("disabled", true).text("<?=$langs['please_wait_btn']?>");

  const postData = {
	action: 'login2',
	email,
	password,
	twofa,
	captcha_type: captcha.captcha_type,
	'_iconcaptcha-token': captcha.iconcaptcha_token,
	'ic-rq': captcha.ic_rq,
	'ic-wid': captcha.ic_wid,
	'ic-cid': captcha.ic_cid,
	'ic-hp': captcha.ic_hp,
	'g-recaptcha-response': captcha['g-recaptcha-response'],
	'h-captcha-response': captcha['h-captcha-response'],
	'c_captcha_response': captcha['c_captcha_response'],
	'pcaptcha_token': captcha.pcaptcha_token || ''
  };

  $.ajax({
	url: "<?=base_url()?>process.php",
	type: "POST",
	data: postData,
	error: function () {
	  console.log("<?=$langs['connection_timeout_err']?>");
	  $btn.attr("disabled", false).text("<?=$langs['login_btn']?>");
	},
	success: function (out) {
	  /*let obj = {};
	  try { obj = JSON.parse(out); } catch { obj = { ret: 0, mes: "Unexpected error" }; }*/
	  
	  let obj = JSON.parse(out);

	  if (obj.ret == 0) {
		$.toast({ heading: 'Error!', text: obj.mes, showHideTransition: 'slide', position: 'top-right', icon: 'error' });
		resetCaptcha(captcha.captcha_type);
	  } else {
		$.toast({ heading: 'Success!', text: obj.mes, showHideTransition: 'slide', position: 'top-right', icon: 'success' });
		setTimeout(() => window.location.reload(), 500);
	  }

	  $btn.attr("disabled", false).text("<?=$langs['login_btn']?>");
	}
  });
}
</script>