<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<style>
	/* ===== Base Light Theme ===== */
	.survey-locked {
	  max-width: 600px;
	  margin: 80px auto;
	  text-align: center;
	  padding: 40px 20px;
	  border: 1px dashed #cfd8e3;
	  border-radius: 12px;
	  background: #fafbfc;
	  color: #334155;
	  transition: all 0.3s ease;
	}

	.survey-locked-icon {
	  font-size: 40px;
	  margin-bottom: 10px;
	  color: #64748b;
	}

	.survey-locked-title {
	  font-size: 18px;
	  font-weight: 600;
	  color: #334155;
	  margin: 10px 0;
	}

	.survey-locked-text {
	  font-size: 15px;
	  color: #64748b;
	  margin: 3px 0;
	}

	/* ===== Dark Mode ===== */
	.dark_mode .survey-locked {
	  background: #213743!important;
	  border-color: #334155;
	  color: #cbd5e1;
	  box-shadow: 0 2px 8px rgba(0,0,0,0.5);
	  border: 1px dashed #EFEFEF;
	}

	.dark_mode .survey-locked-icon {
	  color: #94a3b8;
	}

	.dark_mode .survey-locked-title {
	  color: #f1f5f9;
	}

	.dark_mode .survey-locked-text {
	  color: #94a3b8;
	}
	</style>
	<?php if(isset($user_info) && $user_info->dark_mode == 1):?>
	<body class="dark_mode">
	<?php else:?>
	<body>
	<?php endif?>
		<?php include('menu2.php');?>
			<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">

					<?php if($user_info->uncredited_survey_rewards > 0):?>
					<div class="alert alert-info">
						<span>You are currently not eligible to receive money from surveys to your main balance. You need to complete at least 100 faucet claims or reach Iron level to be able to receive this amount.</span>
					</div>
					<?php endif?>
				
					<h2><?=$langs['surveys_page_heading']?></h2>
					<?php if($user_info->disable_survey == 0 
							&& (
								($user_info->country != 'US' 
								&& $user_info->country != 'UK' 
								&& $user_info->country != 'AU' 
								&& $user_info->country != 'DE' 
								&& $user_info->country != 'CA' 
								&& $user_info->country != 'NL' 
								&& $user_info->country != 'FR')
								|| $user_info->user_level >= 2
								|| $user_info->claims >= 0)
						):?>
						
					<div class="survey-stats-container">
						<div class="survey-header">
							<h3>Survey Statistics</h3>
							<a href="#survey_history">View History</a>
						</div>
						
						<div class="survey-stats">
							<?php if($user_info->uncredited_survey_rewards > 0):?>
							<div class="survey-stats-card" style="background: rgb(217 237 247); border: 1px solid rgb(156 231 241);">
								<div class="survey-title"><i class="fas fa-lock"></i> Pending</div>
								<div class="survey-value"><?=number_format($user_info->uncredited_survey_rewards / 100000000, 8, '.', '')?> DOGE</div>
								<?php if($user_info->uncredited_survey_rewards > 0):?>
								<div class="survey-sub">Claim faucet <span style="color: #2196f3"><?=(100 - $user_info->claims)?></span> more times to receive this amount.</div>
								<?php else:?>
								<div class="survey-sub"><?=$statistics['total_surveys']?> pending surveys</div>
								<?php endif?>
								
							</div>
							<?php else:?>
							<div class="survey-stats-card" style="background: rgb(139 195 74 / 10%); border: 1px solid #8BC34A;">
								<div class="survey-title"><i class="fas fa-check-circle"></i> Completed</div>
								<div class="survey-value"><?=number_format($statistics['total_amount'] / 100000000, 8, '.', '')?> DOGE</div>
								<div class="survey-sub"><?=$statistics['total_surveys']?> surveys completed</div>
							</div>
							<?php endif?>
							<div class="survey-stats-card" style="background: rgb(255 87 34 / 10%); border: 1px solid #FF5722">
								<div class="survey-title"><i class="fas fa-window-close"></i> Rejected</div>
								<div class="survey-value"><?=number_format($reject_surveys->total_amount / 100000000, 8, '.', '')?> DOGE</div>
								<div class="survey-sub"><?=$reject_surveys->total_surveys?> surveys rejected</div>
							</div>
						</div>
						
					</div>
					
					
					<?php
						// promotion event
						date_default_timezone_set('UTC');
						$promotion_event_start = strtotime("November 1 2024");
						$promotion_event_end = strtotime("November 13 2024");
						if(time() > $promotion_event_start && time() < $promotion_event_end) {
							$promotion_event = true;
						} else {
							$promotion_event = false;
						}
						// promotion event
					?>

					<?php if($promotion_event):?>
					<center><img src="<?=base_url()?>assets/img/banner/bnbpick_cpx_2025.png" width="720" style="margin-bottom: 20px"></center>
					<?php endif?>
					
					<div id="show_surveys" style="display: block; margin-top: 50px">
						<!-- CPX-Research -->
						<?php
							$app_id = 21146;
							$unique_user_id = $user_info->user_id + 123456;
							$user_name = $user_info->user_name;
							$user_email = $user_info->user_email;
							$security_hash = 'kesmZgEcxlEJwX0R93qq2k9w1E5SbpHx';
							$secure_hash = md5($security_hash.''.$unique_user_id);
						
						?>
						<!-- CPX-Research -->

						<script>
							const script1 = {
								div_id: "onerow",
								theme_style: 7,
								order_by: 1,
								display_mode: 3 ,
								limit_surveys:8
							};
							const config = {
								general_config: {
									app_id: '<?=$app_id?>', // replace your app_id
									ext_user_id: '<?=$unique_user_id?>', // replace the userid from your user
									subid_1: '<?=$user_name?>', // string
									subid_2: '<?=$user_email?>', // string
								},
								style_config: {
									text_color: "#2b2b2b", // string // hex, rgba, colorcode
									 survey_box: {
										topbar_background_color: "#1DA05E", // string // hex, rgba, colorcode
										box_background_color: "white", // string // hex, rgba, colorcode
										rounded_borders: true, // boolean true || false
										stars_filled: "#ffaf20", // string // hex, rgba, colorcode
										stars_empty: "rgb(221 221 221)", // string, rgb, colorcode
										accent_color_small_box: "#1DA05E", // string, rgb, colorcode defines the accent color for the row box layout
										place_stars_bottom_small_box: true // default: false (stars are top)
									},  
								},
								script_config: [script1], // Object Array
								debug: false, // boolean
								 useIFrame: true, //boolean    
								 iFramePosition: 3 // 1 right (default), 2 left // 3 = center
							 
							};
							window.config = config;
						</script>
						<div id="onerow"></div>
						<script type="text/javascript" src="https://cdn.cpx-research.com/assets/js/script_tag_v2.0.js"></script>
						
						<!-- survey list -->
						<div class="row survey-list">
							<div class="col-xs-6 col-sm-4 col-md-4 col-lg-4">
								<div class="survey-card active" data-id="cpx_survey" style="overflow: hidden; transform: scale(1)">
									<?php if($promotion_event):?>
									<span class="promo-ribbon">+20%</span>
									<?php endif?>
									<img src="<?=base_url()?>assets/img/surveys/cpx.png" alt="CPX-Research">
									<p>CPX-Research</p>
								</div>
							</div>

							<div class="col-xs-6 col-sm-4 col-md-4 col-lg-4">
								<div class="survey-card" data-id="timewall_survey">
									<img src="<?=base_url()?>assets/img/surveys/timewall.png" alt="TimeWall">
									<p>TimeWall</p>
								</div>
							</div>
						</div>
						<!-- survey list -->
						
						
						<div class="row show_survey" id="cpx_survey" style="margin-top: 150px">
							<div class="col-12">
								<iframe width="90%" frameBorder="0" height="1000px"  src="https://offers.cpx-research.com/index.php?app_id=<?=$app_id?>&ext_user_id=<?=$unique_user_id?>&secure_hash=<?=$secure_hash?>&username=<?=$user_name?>&email=<?=$user_email?>&subid=<?=$user_info->user_token?>"></iframe>
							</div>
						</div>
						
						<div class="row show_survey" id="timewall_survey" style="display: none; margin-top: 150px">
							<div class="col-12">
								<iframe style="width:100%; height:1200px; border:0; padding:0; margin: 0px;" scrolling="yes" frameborder="0" data-src="https://timewall.io/users/login?oid=4b64760547b1b83c&uid=<?=($user_info->user_id + 123456)?>"></iframe>
							</div>
						</div>
					</div>
					
					<p style="margin-top: 50px"><?=$langs['surveys_page_desc']?></p>

					<div id="survey_history" style="width: 100%; overflow-x: auto; margin: 20px auto 0px">
						<table class="table table-striped bets_table">
							<thead>
								<tr>
									<td><?=$langs['trans_tbl_time']?></td>
									<td><?=$langs['trans_tbl_site']?></td>
									<td><?=$langs['trans_tbl_status']?></td>
									<td><?=$langs['trans_tbl_earning']?></td>
								</tr>
							</thead>
							<tbody>
								<?php
									if(is_array($get_surveys)) {
										foreach($get_surveys as $row) {
											echo '<tr>';
											if(date('Y-m-d', $row->time) == date('Y-m-d')) {
												$row->time =  date('H:i:s A', $row->time);
											} else {
												$row->time =  date('Y-m-d', $row->time);
											}
											echo '<td>'.$row->time.'</td>';
											echo '<td>'.$row->survey_site.'</td>';
											
											$USD_value = number_format($row->earning_amount * $DOGE_price / 100000000, 4);
											if($row->status == 1) {
												if($USD_value > 0.05) {
													echo '<td style="color: #8bc34a">Completed</td>';
												} else if ($USD_value >= 0) {
													echo '<td style="color: #03a9f4">Bonus</td>';
												} else {
													echo '<td style="color: #777">Screenout</td>';	
												}
											} else {
												echo '<td style="color: #f44336">Rejected </td>';
											}
											echo '<td>$'.$USD_value.' <br/> ('.number_format($row->earning_amount / 100000000, 8).' DOGE)</td>';

											echo '</tr>';
										}
									} else {
										echo '<tr><td colspan="4">'.$langs['no_completed_surveys_found'].'</td></tr>';
									}
								?>
							</tbody>
						</table>
						<?php if($pagination != '') echo '<div class="pagination">'.$pagination.'</div>';?>
					</div>
					<?php else:?>
					<div class="survey-locked">
					  <div class="survey-locked-icon">🔒</div>
					  <h3 class="survey-locked-title">Survey Access Locked</h3>
					  <p class="survey-locked-text">This feature is temporarily unavailable.</p>
					  <p class="survey-locked-text">We’ll notify you once it’s re-enabled.</p>
					</div>
					<?php endif?>
			   </div>
			</div>
		</section>
		<?php include('footer.php');?>
		<script>
			document.querySelectorAll('.survey-card').forEach(card => {
			  card.addEventListener('click', () => {
				const id = card.dataset.id;
				document.querySelectorAll('.survey-card')
				  .forEach(el => el.classList.remove('active'));
				card.classList.add('active');
				document.querySelectorAll('.show_survey')
				  .forEach(el => el.style.display = 'none');
				const container = document.getElementById(id);
				if (!container) return;

				container.style.display = 'block';
				const iframe = container.querySelector("iframe[data-src]");
				if (iframe && !iframe.src) {
				  iframe.src = iframe.dataset.src;
				}
				setTimeout(() => {
				  window.scrollTo({
					top: container.offsetTop - 80,
					behavior: 'smooth'
				  });
				}, 200);
			  });
			});
	   </script>
	</body>
</html>