<!DOCTYPE html>
<html lang="en">
	<?php include('header.php');?>
	<body>
		<style>
			.dark_mode .form-wrapper__main {
				background: #213743 !important;
				border: none;
				box-shadow: 0 8px 17px 2px rgba(0,0,0,.14), 0 3px 14px 2px rgba(0,0,0,.12), 0 5px 5px -3px rgba(0,0,0,.2);
				border-radius: 2px;
			}
		</style>
		<?php include('menu2.php');?>
		<section class="get_form_nine_area p_100" style="padding-top: 120px">
			<div class="container">
				<div class="single_title_n">
				
					<div class="row">
						<div class="col-lg-12">
							<div class="form-wrapper" style="margin-top: 50px; text-align: left">
								<div class="form-wrapper__inner">
									<div class="form-wrapper__main">
										<div class="form-wrapper__copy">
											<h1><?=$langs['update_tx_page_heading']?></h1>
											<p><?=$langs['update_tx_page_desc']?></p>
										</div>
										<div class="form__input-wrapper">
											<label class="form__label" for="txid"><?=$langs['transaction_id_label']?></label>
											<div class="form__input-container">
												<textarea style="height: 60px; min-height: 60px; max-height: 60px" class="form__input" type="text" id="txid" name="txid" placeholder="<?=$langs['transaction_id_label']?>" value="" autocomplete="off" spellcheck="false"></textarea>
												<span style="height: 58px" class="form__input-icon"><i class="fas fa-code"></i></span>
											</div>
										</div>
										
										<?php echo render_all_captcha_widgets(3, $gg_site_key, $cloudflare_site_key);?>
										
										<div class="form__input-wrapper form__submit">
											<button class="btn" id="process_update_deposit_transaction" onclick="process_update_deposit_transaction()" style="width: 150px; margin-left: calc(50% - 75px)"><?=$langs['update_txid_btn']?></button>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>  
		<?php include('footer.php');?>
		<script>
		
		function process_update_deposit_transaction() {
		  const $btn = $("#process_update_deposit_transaction");
		  const btnLabel = "<?=$langs['update_txid_btn']?>";
		  $btn.prop("disabled", true).text("<?=$langs['please_wait_btn']?>");

		  const txid = $('#txid').val();
		  const captcha = collectCaptchaData();

		  $.ajax({
			url: "<?=base_url()?>process.php",
			type: "POST",
			data: {
			  action: "update_deposit_transaction",
			  txid: txid,
			  captcha_type: captcha.captcha_type,
			  "_iconcaptcha-token": captcha.iconcaptcha_token,
			  "ic-rq": captcha.ic_rq,
			  "ic-wid": captcha.ic_wid,
			  "ic-cid": captcha.ic_cid,
			  "ic-hp": captcha.ic_hp,
			  "g-recaptcha-response": captcha["g-recaptcha-response"],
			  "h-captcha-response": captcha["h-captcha-response"],
			  c_captcha_response: captcha.c_captcha_response,
			  pcaptcha_token: captcha.pcaptcha_token || ""
			},
			error: function () {
			  console.log("Request timed out. Please try again!");
			  $btn.prop("disabled", false).text(btnLabel);
			},
			success: function (out) {
			  /*let obj = {};
			  try { obj = JSON.parse(out); } catch { obj = {ret:0, mes:"Invalid response"}; }*/
			   let obj = JSON.parse(out);

			  if (obj.ret == 0) {
				$.toast({ heading:'Error!', text: obj.mes, showHideTransition:'slide', position:'top-right', icon:'error' });
				if (typeof resetCaptcha === 'function') resetCaptcha(captcha.captcha_type);
			  } else {
				$.toast({ heading:'Success!', text: obj.mes, showHideTransition:'slide', position:'top-right', icon:'success' });
			  }
			  $btn.prop("disabled", false).text(btnLabel);
			}
		  });
		}
		
		</script>
	</body>
</html>